/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.fsm;

import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.CancellingState;
import io.github.interacto.fsm.FSM;
import io.github.interacto.fsm.FSMHandler;
import io.github.interacto.fsm.InputState;
import io.github.interacto.fsm.OutputState;
import io.github.interacto.fsm.TerminalState;
import io.github.interacto.fsm.Transition;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SubFSMTransition<E0>
extends Transition<E0, E0> {
    private final FSM<E0> subFSM;
    private final FSMHandler subFSMHandler;

    public SubFSMTransition(OutputState<E0> srcState, InputState<E0> tgtState, FSM<E0> fsm) {
        super(srcState, tgtState);
        if (fsm == null) {
            throw new IllegalArgumentException("sub fsm cannot be null");
        }
        this.subFSM = fsm;
        this.subFSM.setInner(true);
        this.subFSMHandler = new FSMHandler(){

            @Override
            public void fsmStarts() throws CancelFSMException {
                SubFSMTransition.this.src.exit();
            }

            @Override
            public void fsmUpdates() throws CancelFSMException {
                SubFSMTransition.this.src.getFSM().setCurrentState(SubFSMTransition.this.subFSM.getCurrentState());
                SubFSMTransition.this.src.getFSM().onUpdating();
            }

            @Override
            public void fsmStops() throws CancelFSMException {
                SubFSMTransition.this.action(null);
                SubFSMTransition.this.subFSM.removeHandler(SubFSMTransition.this.subFSMHandler);
                SubFSMTransition.this.src.getFSM().currentSubFSM = null;
                if (SubFSMTransition.this.tgt instanceof TerminalState) {
                    SubFSMTransition.this.tgt.enter();
                    return;
                }
                if (SubFSMTransition.this.tgt instanceof CancellingState) {
                    this.fsmCancels();
                    return;
                }
                if (SubFSMTransition.this.tgt instanceof OutputState) {
                    SubFSMTransition.this.src.getFSM().setCurrentState((OutputState)((Object)SubFSMTransition.this.tgt));
                    SubFSMTransition.this.tgt.enter();
                }
            }

            @Override
            public void fsmCancels() {
                SubFSMTransition.this.subFSM.removeHandler(SubFSMTransition.this.subFSMHandler);
                SubFSMTransition.this.src.getFSM().currentSubFSM = null;
                SubFSMTransition.this.src.getFSM().onCancelling();
            }
        };
    }

    @Override
    public Optional<InputState<E0>> execute(E0 event) {
        Optional<Transition<E0, E0>> transition = this.findTransition(event);
        if (transition.isPresent()) {
            this.src.getFSM().stopCurrentTimeout();
            this.subFSM.addHandler(this.subFSMHandler);
            this.src.getFSM().currentSubFSM = this.subFSM;
            this.subFSM.process(event);
            return Optional.of(transition.get().tgt);
        }
        return Optional.empty();
    }

    @Override
    protected E0 accept(E0 event) {
        return this.findTransition(event).isEmpty() ? null : (E0)event;
    }

    @Override
    protected boolean isGuardOK(E0 event) {
        return this.findTransition(event).filter(tr -> tr.isGuardOK(event)).isPresent();
    }

    private Optional<Transition<E0, E0>> findTransition(E0 event) {
        return this.subFSM.initState.transitions.stream().filter(tr -> tr.accept(event) != null).map(tr -> tr).findFirst();
    }

    @Override
    public Set<Object> getAcceptedEvents() {
        return this.subFSM.initState.getTransitions().stream().map(tr -> tr.getAcceptedEvents()).flatMap(s -> s.stream()).collect(Collectors.toSet());
    }

    @Override
    public void uninstall() {
        this.subFSM.uninstall();
    }
}

