/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.ApiLoaderConfig;
import io.gorules.zen.loader.ApiLoaderException;
import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class ApiDecisionLoader
implements DecisionLoader {
    private final HttpClient httpClient;
    private final ApiLoaderConfig config;
    private final ConcurrentHashMap<String, JsonBuffer> cache;

    public ApiDecisionLoader(ApiLoaderConfig config) {
        this.config = config;
        this.cache = config.isEnableCaching() ? new ConcurrentHashMap() : null;
        this.httpClient = HttpClient.newBuilder().connectTimeout(config.getTimeout()).build();
    }

    @Override
    public CompletableFuture<JsonBuffer> load(String key) {
        if (this.cache != null && this.cache.containsKey(key)) {
            return CompletableFuture.completedFuture(this.cache.get(key));
        }
        return this.loadFromApi(key, 0);
    }

    private CompletableFuture<JsonBuffer> loadFromApi(String key, int attempt) {
        try {
            String encodedKey = URLEncoder.encode(key, StandardCharsets.UTF_8);
            String url = this.config.getBaseUrl() + "/" + encodedKey;
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(this.config.getTimeout()).GET();
            Map<String, String> headers = this.config.getAllHeaders();
            headers.forEach(requestBuilder::header);
            HttpRequest request = requestBuilder.build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).thenCompose(response -> this.handleResponse((HttpResponse<byte[]>)response, key, attempt))).exceptionally(ex -> this.handleException((Throwable)ex, key, attempt));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(new ApiLoaderException("Failed to build request for key: " + key, e));
        }
    }

    private CompletableFuture<JsonBuffer> handleResponse(HttpResponse<byte[]> response, String key, int attempt) {
        int statusCode = response.statusCode();
        if (statusCode == 200) {
            JsonBuffer buffer = new JsonBuffer(response.body());
            if (this.cache != null) {
                this.cache.put(key, buffer);
            }
            return CompletableFuture.completedFuture(buffer);
        }
        if (statusCode >= 500 && statusCode < 600 && attempt < this.config.getMaxRetries()) {
            return this.retryWithBackoff(key, attempt);
        }
        if (statusCode == 404) {
            return CompletableFuture.failedFuture(new ApiLoaderException("Decision not found: " + key + " (HTTP 404)"));
        }
        if (statusCode == 401 || statusCode == 403) {
            return CompletableFuture.failedFuture(new ApiLoaderException("Authentication failed for key: " + key + " (HTTP " + statusCode + ")"));
        }
        String body = new String(response.body(), StandardCharsets.UTF_8);
        return CompletableFuture.failedFuture(new ApiLoaderException("Failed to load decision: " + key + " (HTTP " + statusCode + "): " + body));
    }

    private JsonBuffer handleException(Throwable ex, String key, int attempt) {
        if (attempt < this.config.getMaxRetries()) {
            try {
                return this.retryWithBackoff(key, attempt).join();
            }
            catch (Exception retryEx) {
                throw new ApiLoaderException("Failed to load decision after " + (attempt + 1) + " attempts: " + key, retryEx);
            }
        }
        throw new ApiLoaderException("Failed to load decision: " + key, ex);
    }

    private CompletableFuture<JsonBuffer> retryWithBackoff(String key, int attempt) {
        long delayMs = this.config.getRetryDelay().toMillis() * (1L << attempt);
        return CompletableFuture.supplyAsync(() -> {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiLoaderException("Retry interrupted for key: " + key, e);
            }
            return null;
        }).thenCompose(v -> this.loadFromApi(key, attempt + 1));
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public void evict(String key) {
        if (this.cache != null) {
            this.cache.remove(key);
        }
    }

    public boolean isCached(String key) {
        return this.cache != null && this.cache.containsKey(key);
    }

    public ApiLoaderConfig getConfig() {
        return this.config;
    }
}

