/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.HeaderProvider;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ApiLoaderConfig {
    private final String baseUrl;
    private final Map<String, String> staticHeaders;
    private final HeaderProvider dynamicHeaderProvider;
    private final Duration timeout;
    private final int maxRetries;
    private final Duration retryDelay;
    private final boolean enableCaching;

    private ApiLoaderConfig(Builder builder) {
        this.baseUrl = builder.baseUrl.endsWith("/") ? builder.baseUrl.substring(0, builder.baseUrl.length() - 1) : builder.baseUrl;
        this.staticHeaders = Collections.unmodifiableMap(new HashMap<String, String>(builder.staticHeaders));
        this.dynamicHeaderProvider = builder.dynamicHeaderProvider;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
        this.retryDelay = builder.retryDelay;
        this.enableCaching = builder.enableCaching;
    }

    public static Builder builder(String baseUrl) {
        return new Builder(baseUrl);
    }

    public Map<String, String> getAllHeaders() {
        Map<String, String> dynamicHeaders;
        HashMap<String, String> allHeaders = new HashMap<String, String>(this.staticHeaders);
        if (this.dynamicHeaderProvider != null && (dynamicHeaders = this.dynamicHeaderProvider.getHeaders()) != null) {
            allHeaders.putAll(dynamicHeaders);
        }
        return allHeaders;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> getStaticHeaders() {
        return this.staticHeaders;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public boolean isEnableCaching() {
        return this.enableCaching;
    }

    public static class Builder {
        private final String baseUrl;
        private final Map<String, String> staticHeaders = new HashMap<String, String>();
        private HeaderProvider dynamicHeaderProvider;
        private Duration timeout = Duration.ofSeconds(30L);
        private int maxRetries = 3;
        private Duration retryDelay = Duration.ofSeconds(1L);
        private boolean enableCaching = true;

        private Builder(String baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl cannot be null");
            this.baseUrl = baseUrl;
        }

        public Builder header(String name, String value) {
            Objects.requireNonNull(name, "header name cannot be null");
            Objects.requireNonNull(value, "header value cannot be null");
            this.staticHeaders.put(name, value);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            if (headers != null) {
                this.staticHeaders.putAll(headers);
            }
            return this;
        }

        public Builder bearerToken(String token) {
            Objects.requireNonNull(token, "token cannot be null");
            return this.header("Authorization", "Bearer " + token);
        }

        public Builder apiKey(String key) {
            Objects.requireNonNull(key, "API key cannot be null");
            return this.header("X-API-Key", key);
        }

        public Builder basicAuth(String username, String password) {
            Objects.requireNonNull(username, "username cannot be null");
            Objects.requireNonNull(password, "password cannot be null");
            String credentials = username + ":" + password;
            String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            return this.header("Authorization", "Basic " + encoded);
        }

        public Builder headerProvider(HeaderProvider provider) {
            this.dynamicHeaderProvider = provider;
            return this;
        }

        public Builder timeout(Duration timeout) {
            Objects.requireNonNull(timeout, "timeout cannot be null");
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries cannot be negative");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder retryDelay(Duration retryDelay) {
            Objects.requireNonNull(retryDelay, "retryDelay cannot be null");
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder caching(boolean enable) {
            this.enableCaching = enable;
            return this;
        }

        public ApiLoaderConfig build() {
            return new ApiLoaderConfig(this);
        }
    }
}

