/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class FilesystemDecisionLoader
implements DecisionLoader {
    private final String rootPath;
    private final boolean useCache;
    private final ConcurrentHashMap<String, JsonBuffer> cache;

    public FilesystemDecisionLoader(String rootPath) {
        this(rootPath, true);
    }

    public FilesystemDecisionLoader(String rootPath, boolean useCache) {
        this.rootPath = rootPath.endsWith("/") ? rootPath : rootPath + "/";
        this.useCache = useCache;
        this.cache = useCache ? new ConcurrentHashMap() : null;
    }

    @Override
    public CompletableFuture<JsonBuffer> load(String key) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.useCache && this.cache.containsKey(key)) {
                return this.cache.get(key);
            }
            try {
                Path filePath = Paths.get(this.rootPath + key, new String[0]);
                if (!Files.exists(filePath, new LinkOption[0])) {
                    throw new RuntimeException("Decision file not found: " + String.valueOf(filePath));
                }
                byte[] content = Files.readAllBytes(filePath);
                JsonBuffer buffer = new JsonBuffer(content);
                if (this.useCache) {
                    this.cache.put(key, buffer);
                }
                return buffer;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load decision: " + key, e);
            }
        });
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public void evict(String key) {
        if (this.cache != null) {
            this.cache.remove(key);
        }
    }
}

