package io.github.kaststream.api;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;

/**
 * @deprecated This class will be remove in next version
 *     <p>Use {@link io.github.kaststream.api.v2.Filter}
 */
public interface Filter extends Serializable {
  /**
   * The filter function that evaluates the predicate.
   *
   * <p><strong>IMPORTANT:</strong> The system assumes that the function does not modify the
   * elements on which the predicate is applied. Violating this assumption can lead to incorrect
   * results.
   *
   * @param row The value to be filtered.
   * @return True for values that should be retained, false for values to be filtered out.
   * @throws Exception This method may throw exceptions. Throwing an exception will cause the
   *     operation to fail and may trigger recovery.
   */
  public boolean filter(final Row row) throws Exception;

  /**
   * Declare the data type information of the data produced by your function.
   *
   * @param typeInfo the input row type information
   * @return the produced data typeInfo
   */
  public TypeInformation<Row> getProducedType(final TypeInformation<Row> typeInfo);

  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @param typeInfo the input row type information
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void open(final Configuration configuration, final TypeInformation<Row> typeInfo)
      throws Exception {}
  ;

  /**
   * Tear-down method for the user code. It is called after the last call to the main working
   * methods. For functions that are part of an iteration, this method will be invoked after each
   * iteration superstep.
   *
   * <p>This method can be used for clean up work.
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void close() throws Exception {}
  ;
}
