package io.github.kaststream.api;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;

/**
 * @deprecated This class will be remove in next version
 *     <p>Use {@link io.github.kaststream.api.v2.Mapper} The map function.
 */
public interface Mapper extends Serializable {

  /**
   * Your function implementation. Do what you need on the received rows.
   *
   * @param row the received row
   * @return the transformed row
   * @throws Exception in case of problem. This will stop your dag.
   */
  public Row map(final Row row) throws Exception;

  /**
   * Declare the data type information of the data produced by your function.
   *
   * @param typeInfo the input row type information
   * @return the produced data typeInfo
   */
  public TypeInformation<Row> getProducedType(final TypeInformation<Row> typeInfo);

  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @param typeInfo the input row type information
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void open(final Configuration configuration, final TypeInformation<Row> typeInfo)
      throws Exception {}
  ;

  /**
   * Tear-down method for the user code. It is called after the last call to the main working
   * methods. For functions that are part of an iteration, this method will be invoked after each
   * iteration superstep.
   *
   * <p>This method can be used for clean up work.
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void close() throws Exception {}
  ;
}
