package io.github.kaststream.api.v2;

import io.github.kaststream.api.v2.facade.KastRow;
import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;

public interface FailureHandler extends Serializable {

  /**
   * Handle a failed jdbc request.
   *
   * @param kRow The row that is on failure
   * @param errorMessage the string describing the error
   * @throws Throwable Throwable if the sink should fail on this failure, the implementation should
   *     rethrow the exception or a custom one
   */
  void onFailure(KastRow kRow, String errorMessage) throws Throwable;

  /**
   * Initialization method for the handler.
   *
   * @param schema the input row schema
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void open(Schema schema) throws Exception {};
  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @param schema the input row schema
   * @param meta the udf configuration parameters
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void open(
      final Map<String, String> configuration, final Schema schema, Map<String, Object> meta)
      throws Exception {
    throw new UnsupportedOperationException("open with meta not implemented");
  }
  ;
  /**
   * Initialization method for the handler.
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public default void close() throws Exception {};
}
