package io.github.kaststream.api.v2.facade;

public interface KastCoProcessorContext {
  /**
   * Timestamp of the element currently being processed or timestamp of a firing timer.
   *
   * <p>This might be {@code null}, for example if the time characteristic of your program is set to
   * {@link org.apache.flink.streaming.api.TimeCharacteristic#ProcessingTime}.
   */
  public abstract Long timestamp();

  /**
   * Emits a record to the side output identified by the {@link KastOutputTag}.
   *
   * @param sideOutputTag the {@code KastOutputTag} that identifies the side output to emit to.
   * @param kRow The record to emit.
   */
  public abstract void output(KastOutputTag sideOutputTag, KastRow kRow);
}
