/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.io.ReadUtils;
import io.github.kloping.reg.MatcherUtils;
import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.Setting;
import io.github.kloping.spt.annotations.http.Callback;
import io.github.kloping.spt.annotations.http.DefaultValue;
import io.github.kloping.spt.annotations.http.FileParm;
import io.github.kloping.spt.annotations.http.GetPath;
import io.github.kloping.spt.annotations.http.Headers;
import io.github.kloping.spt.annotations.http.HttpClient;
import io.github.kloping.spt.annotations.http.ParamBody;
import io.github.kloping.spt.annotations.http.ParamName;
import io.github.kloping.spt.annotations.http.PathValue;
import io.github.kloping.spt.annotations.http.PostPath;
import io.github.kloping.spt.annotations.http.RequestBody;
import io.github.kloping.spt.annotations.http.RequestData;
import io.github.kloping.spt.annotations.http.RequestPath;
import io.github.kloping.spt.entity.KeyVals;
import io.github.kloping.spt.entity.Params;
import io.github.kloping.spt.impls.AutomaticWiringParamsImpl;
import io.github.kloping.spt.impls.HttpStatusReceiver;
import io.github.kloping.spt.impls.LoggerImpl;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.ClassManager;
import io.github.kloping.spt.interfaces.component.ContextManager;
import io.github.kloping.spt.interfaces.component.HttpClientManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.fusesource.jansi.Ansi;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.nodes.Document;
import org.slf4j.LoggerFactory;

public class HttpClientManagerImpl
implements HttpClientManager {
    public static final String SPLIT = "/";
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(HttpClientManagerImpl.class);
    private Setting setting;
    private Map<Method, Invoker> methodInks = new ConcurrentHashMap<Method, Invoker>();
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
    private boolean print = true;
    private Logger logger;
    private List<HttpStatusReceiver> receivers = new LinkedList<HttpStatusReceiver>();
    public static String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36 Edg/95.0.1020.53";
    private static final AutomaticWiringParamsImpl AWP = new AutomaticWiringParamsImpl();
    private static final String AND = "&";
    private static final String DO = "?";

    @Override
    public void setPrint(boolean k) {
        this.print = k;
    }

    private <T> T toType(Class<T> cls, Document doc, Response resp, Method[] methods) throws IOException {
        String finalText;
        String text = finalText = doc.body().text();
        if (methods != null) {
            for (Method method : methods) {
                if (method == null) continue;
                try {
                    Object[] os = AWP.wiring(method, text);
                    Object out = method.invoke(null, os);
                    if (out.getClass() == String.class) {
                        text = out.toString();
                        continue;
                    }
                    if (out.getClass() != cls) continue;
                    return (T)out;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage() + PartUtils.getExceptionLine(e));
                }
            }
        }
        try {
            String data;
            String string = data = text == null ? finalText : text;
            if (this.print) {
                this.logger.log(String.format("Get the data [%s] from the [%s]", Ansi.ansi().fgRgb(LoggerImpl.NORMAL_LOW_COLOR.getRGB()).a(data).reset().toString(), resp.request().url().url()));
            }
            if (cls == String.class) {
                return (T)data;
            }
            if (cls.isArray()) {
                return (T)JSON.parseArray((String)data).toJavaObject(cls);
            }
            return (T)JSON.parseObject((String)data).toJavaObject(cls);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() == null ? "" : e.getMessage() + "The data returned by the request could not be converted to the specified type( " + cls.getName() + ")\n" + PartUtils.getExceptionLine(e));
            return null;
        }
    }

    public HttpClientManagerImpl(Setting setting, ClassManager classManager) {
        this.setting = setting;
        classManager.registeredAnnotation(HttpClient.class, this);
        setting.getSTARTED_RUNNABLE().add(() -> {
            this.logger = setting.getContextManager().getContextEntity(Logger.class);
        });
    }

    @Override
    public void addHttpStatusReceiver(HttpStatusReceiver receiver) {
        this.receivers.add(receiver);
    }

    @Override
    public void manager(Method method, ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        method.setAccessible(true);
        String host = method.getDeclaringClass().getDeclaredAnnotation(HttpClient.class).value();
        Connection.Method mt = null;
        String path = null;
        if (method.isAnnotationPresent(GetPath.class)) {
            path = method.getAnnotation(GetPath.class).value();
            mt = Connection.Method.GET;
        } else if (method.isAnnotationPresent(PostPath.class)) {
            path = method.getAnnotation(PostPath.class).value();
            mt = Connection.Method.POST;
        } else if (method.isAnnotationPresent(RequestPath.class)) {
            RequestPath rp = method.getAnnotation(RequestPath.class);
            path = rp.value();
            mt = rp.method();
        }
        this.loadMethod(host, path, method, mt);
    }

    private String merge(String host, String path) throws Throwable {
        if (host.matches(".*?\\{.*?}.*?")) {
            for (String r0 : MatcherUtils.matcherAll((String)host, (String)"\\{.*?}")) {
                String fielda = r0.substring(1, r0.length() - 1);
                AccessibleObject aco = HttpClientManagerImpl.parse(fielda);
                Object value = this.getValue(aco);
                host = host.replace(r0, value.toString());
            }
        }
        if (!host.endsWith(SPLIT)) {
            host = host + SPLIT;
        }
        if (path.startsWith(SPLIT)) {
            path = path.substring(1, path.length());
        }
        if (path.endsWith(SPLIT)) {
            path = path.substring(0, path.length() - 1);
        }
        return host + path;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object o = null;
        if (this.methodInks.containsKey(method)) {
            o = this.methodInks.get(method).run(args);
        }
        return o;
    }

    @Override
    public void manager(Class cla, ContextManager contextManager) throws IllegalAccessException, InvocationTargetException {
        if (!cla.isInterface()) {
            return;
        }
        contextManager.append(cla, Proxy.newProxyInstance(cla.getClassLoader(), new Class[]{cla}, (InvocationHandler)this), UUID.randomUUID().toString());
        for (Method declaredMethod : cla.getDeclaredMethods()) {
            this.manager(declaredMethod, contextManager);
        }
    }

    private void loadMethod(String host, String path, Method method, Connection.Method type2) {
        Method[] methods = null;
        if (method.isAnnotationPresent(Callback.class)) {
            Callback callback = method.getDeclaredAnnotation(Callback.class);
            String[] ss = callback.value();
            methods = this.loadMethods(ss);
        }
        Method[] finalMethods = methods;
        this.methodInks.put(method, new Invoker(host, path, method, type2, methods));
    }

    private okhttp3.RequestBody loadBody(Method method, Object[] objects) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<?> cla = parameter.getType();
            if (!parameter.isAnnotationPresent(RequestBody.class)) continue;
            RequestBody rb = parameter.getAnnotation(RequestBody.class);
            switch (rb.type()) {
                case toString: {
                    return okhttp3.RequestBody.create((String)objects[i].toString(), (MediaType)MediaType.parse((String)"text/plain"));
                }
                case json: {
                    if (objects[i].getClass().isAssignableFrom(String.class)) {
                        return okhttp3.RequestBody.create((String)objects[i].toString(), (MediaType)MediaType.parse((String)"application/json"));
                    }
                    return okhttp3.RequestBody.create((String)JSON.toJSONString((Object)objects[i]), (MediaType)MediaType.parse((String)"application/json"));
                }
            }
        }
        return null;
    }

    private MultipartBody loadData(Method method, Object[] objects) throws IOException {
        MultipartBody.Builder multipartBody = null;
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (objects[i] == null) continue;
            Parameter parameter = parameters[i];
            Class<?> cla = parameter.getType();
            if (parameter.isAnnotationPresent(RequestData.class)) {
                if (cla == Map.Entry.class) {
                    Map.Entry entry = (Map.Entry)objects[i];
                    if (multipartBody == null) {
                        multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    }
                    multipartBody.addFormDataPart(entry.getKey().toString(), entry.getValue().toString());
                    continue;
                }
                if (cla == String.class) {
                    if (multipartBody == null) {
                        multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    }
                    multipartBody.addPart(okhttp3.RequestBody.create((String)objects[i].toString(), (MediaType)MediaType.parse((String)"text/plain")));
                    continue;
                }
                if (!(objects[i] instanceof KeyVals)) continue;
                KeyVals data = (KeyVals)objects[i];
                for (HttpConnection.KeyVal value : data.values()) {
                    if (multipartBody == null) {
                        multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    }
                    if (value.hasInputStream()) {
                        byte[] bytes = ReadUtils.readAll((InputStream)value.inputStream());
                        multipartBody.addFormDataPart(value.key(), value.value(), okhttp3.RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)value.contentType())));
                        continue;
                    }
                    multipartBody.addFormDataPart(value.key(), value.value());
                }
                continue;
            }
            if (!parameter.isAnnotationPresent(FileParm.class)) continue;
            if (cla == byte[].class) {
                byte[] bytes = (byte[])objects[i];
                FileParm fileParm = parameter.getDeclaredAnnotation(FileParm.class);
                if (multipartBody == null) {
                    multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                }
                if (!fileParm.type().isEmpty()) {
                    multipartBody.addFormDataPart(fileParm.value(), fileParm.name(), okhttp3.RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)fileParm.type())));
                    continue;
                }
                multipartBody.addFormDataPart(fileParm.value(), fileParm.name(), okhttp3.RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)fileParm.type())));
                continue;
            }
            if (cla != HttpConnection.KeyVal.class) continue;
            HttpConnection.KeyVal value = (HttpConnection.KeyVal)objects[i];
            if (multipartBody == null) {
                multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
            }
            if (value.hasInputStream()) {
                byte[] bytes = ReadUtils.readAll((InputStream)value.inputStream());
                multipartBody.addFormDataPart(value.key(), value.value(), okhttp3.RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)value.contentType())));
                continue;
            }
            multipartBody.addFormDataPart(value.key(), value.value());
        }
        if (multipartBody != null) {
            return multipartBody.build();
        }
        return null;
    }

    private Method[] loadMethods(String[] ss) {
        int i = 0;
        Method[] methods = new Method[ss.length];
        for (String s : ss) {
            int i0 = s.lastIndexOf(".");
            String methodName = s.substring(i0 + 1, s.length());
            String className = s.substring(0, i0);
            try {
                Class<?> cla = this.getClass().getClassLoader().loadClass(className);
                Method method = null;
                for (Method declaredMethod : cla.getDeclaredMethods()) {
                    if (!declaredMethod.getName().equals(methodName)) continue;
                    method = declaredMethod;
                }
                if (method == null) {
                    methods[i] = null;
                    continue;
                }
                method.setAccessible(true);
                methods[i] = method;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage() + PartUtils.getExceptionLine(e));
            }
            ++i;
        }
        return methods;
    }

    private static void addCookieStore(CookieStore from, CookieStore to) throws IllegalAccessException, NoSuchFieldException {
        Field field = from.getClass().getDeclaredField("uriIndex");
        field.setAccessible(true);
        Map uriIndex = (Map)field.get(from);
        List<HttpCookie> httpCookies = from.getCookies();
        uriIndex.forEach((k, v) -> {
            for (HttpCookie httpCookie : v) {
                to.add((URI)k, httpCookie);
            }
        });
    }

    private String loadPostBody(Method method, Object[] objects) throws Exception {
        Parameter[] parameters = method.getParameters();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(RequestBody.class)) continue;
            RequestBody rb = parameters[i].getAnnotation(RequestBody.class);
            switch (rb.type()) {
                case toString: {
                    sb.append(objects[i]);
                    continue block4;
                }
                case json: {
                    sb.append(JSON.toJSONString((Object)objects[i]));
                    continue block4;
                }
            }
        }
        return sb.toString();
    }

    private CookieStore getCookieStore(String[] urls, Connection.Method method, String url, Method m0, Object ... objects) throws IOException, URISyntaxException {
        return null;
    }

    private String getGetUrl(String host, String path, Method method, Object ... objects) throws Throwable {
        Parameter[] parameters = method.getParameters();
        StringBuilder urlsb = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> replaceMap = new HashMap<String, Object>();
        urlsb.append(this.merge(host, path));
        for (int i = 0; i < parameters.length; ++i) {
            Annotation pn;
            if (objects[i] instanceof Params) {
                Params params = (Params)objects[i];
                params.getParams().forEach((k, v) -> sb.append((String)k).append("=").append((String)v).append(AND));
                continue;
            }
            if (parameters[i].isAnnotationPresent(ParamName.class)) {
                pn = parameters[i].getAnnotation(ParamName.class);
                String k2 = pn.value();
                Object v2 = objects[i];
                if (v2 == null) {
                    if (parameters[i].isAnnotationPresent(DefaultValue.class)) {
                        DefaultValue value = parameters[i].getDeclaredAnnotation(DefaultValue.class);
                        v2 = value.value();
                    }
                } else {
                    v2 = v2.toString();
                }
                sb.append(k2).append("=").append(v2).append(AND);
                continue;
            }
            if (parameters[i].isAnnotationPresent(ParamBody.class)) {
                pn = parameters[i].getAnnotation(ParamBody.class);
                JSONObject jo = JSON.parseObject((String)JSON.toJSONString((Object)objects[i]));
                jo.forEach((k, v) -> sb.append((String)k).append("=").append(v).append(AND));
                continue;
            }
            if (!parameters[i].isAnnotationPresent(PathValue.class)) continue;
            pn = parameters[i].getAnnotation(PathValue.class);
            if (pn.value() == null || pn.value().isEmpty()) {
                if (!urlsb.toString().endsWith(SPLIT)) {
                    urlsb.append(SPLIT);
                }
                urlsb.append(objects[i].toString());
                continue;
            }
            String name = pn.value();
            name = "{" + name + "}";
            replaceMap.put(name, objects[i]);
        }
        if (sb.toString().endsWith(DO)) {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.toString().endsWith(AND)) {
            sb.delete(sb.length() - 1, sb.length());
        }
        urlsb.append(DO);
        urlsb.append(sb.toString());
        String url0 = urlsb.toString();
        if (url0.startsWith(SPLIT)) {
            url0 = url0.substring(1);
        }
        if (url0.endsWith(DO)) {
            url0 = url0.substring(0, url0.length() - 1);
        }
        for (String s : replaceMap.keySet()) {
            url0 = url0.replace(s, replaceMap.get(s).toString());
        }
        if (url0.startsWith(SPLIT)) {
            url0 = url0.substring(1);
        }
        return url0;
    }

    private Map<String, String> getHeaders(Method method, Object ... objects) {
        Headers headers;
        String s;
        Class<?> cn0 = method.getDeclaringClass();
        Parameter[] parameters = method.getParameters();
        Map<String, String> map = new HashMap<String, String>();
        int i = 0;
        for (Parameter parameter : parameters) {
            if (parameter.isAnnotationPresent(Headers.class)) {
                try {
                    Map map2;
                    if (Map.class.isAssignableFrom(parameter.getType()) && (map2 = (Map)objects[i]).keySet().iterator().next() instanceof String && map2.values().iterator().next() instanceof String) {
                        map = map2;
                    }
                }
                catch (Exception e) {
                    this.logger.error("The Parameter Type not is Map<String,String>");
                }
            }
            ++i;
        }
        if (cn0.isAnnotationPresent(Headers.class) && (s = (headers = method.getDeclaringClass().getDeclaredAnnotation(Headers.class)).value()) != null && !s.isEmpty()) {
            try {
                AccessibleObject field = HttpClientManagerImpl.parse(s);
                Object o = this.getValue(field);
                if (o instanceof Map) {
                    Map m = (Map)o;
                    map.putAll(m);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logger.error("parse error at " + cn0 + " Annotation @Headers");
            }
        }
        return map;
    }

    private Object getValue(AccessibleObject ao) throws Throwable {
        if (ao == null) {
            return null;
        }
        ao.setAccessible(true);
        ContextManager contextManager = this.setting.getContextManager();
        if (ao instanceof Method) {
            Method method = (Method)ao;
            Object o = method.invoke(contextManager.getContextEntity(method.getDeclaringClass()), new Object[0]);
            return o;
        }
        if (ao instanceof Field) {
            Field field = (Field)ao;
            Object o = field.get(contextManager.getContextEntity(field.getDeclaringClass()));
            return o;
        }
        return null;
    }

    private static final AccessibleObject parse(String str) throws ClassNotFoundException {
        AccessibleObject accessibleObject = null;
        int i0 = str.lastIndexOf(".");
        String clan = str.substring(0, i0);
        String fn = str.substring(i0 + 1);
        Class<?> cl0 = Class.forName(clan);
        try {
            accessibleObject = cl0.getDeclaredField(fn);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (accessibleObject == null) {
            try {
                accessibleObject = cl0.getDeclaredMethod(fn, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return accessibleObject;
    }

    private class Invoker {
        private String path;
        private String host;
        private Method method;
        private Connection.Method type;
        private Method[] methods;
        private Request.Builder requestBuilder;
        private String finalUrl;

        public Invoker(String host, String path, Method method, Connection.Method type2, Method[] methods) {
            this.path = path;
            this.host = host;
            this.method = method;
            this.type = type2;
            this.methods = methods;
        }

        private Object run(Object ... objects) throws Throwable {
            Object object;
            long start = System.currentTimeMillis();
            long cost = -1L;
            Class<?> rtype = this.method.getReturnType();
            Class<?> dType = this.method.getDeclaringClass();
            try {
                if (this.requestBuilder == null) {
                    this.requestBuilder = new Request.Builder();
                    this.finalUrl = HttpClientManagerImpl.this.getGetUrl(this.host, this.path, this.method, objects);
                    this.requestBuilder.url(this.finalUrl);
                }
                HttpClientManagerImpl.this.getHeaders(this.method, objects).forEach((k, v) -> this.requestBuilder.header(k, v));
                this.requestBuilder.header("User-Agent", userAgent);
                okhttp3.RequestBody requestBody = HttpClientManagerImpl.this.loadBody(this.method, objects);
                MultipartBody multipartBody = HttpClientManagerImpl.this.loadData(this.method, objects);
                if (this.type == Connection.Method.POST) {
                    if (requestBody != null) {
                        this.requestBuilder.post(requestBody);
                    }
                    if (multipartBody != null) {
                        this.requestBuilder.post((okhttp3.RequestBody)multipartBody);
                    }
                }
                Call call = OK_HTTP_CLIENT.newCall(this.requestBuilder.build());
                cost = System.currentTimeMillis();
                Response response = call.execute();
                cost = System.currentTimeMillis() - cost;
                int status = response.code();
                String statusTips = null;
                if (status < 200 || status >= 400) {
                    statusTips = Ansi.ansi().fgRgb(LoggerImpl.ERROR_COLOR.getRGB()).a(status).reset().toString();
                    HttpClientManagerImpl.this.logger.error(new HttpStatusException("HTTP error fetching URL", status, response.request().url().url().toString()).getMessage());
                } else {
                    statusTips = Ansi.ansi().fgRgb(LoggerImpl.INFO_COLOR.getRGB()).a(status).reset().toString();
                }
                if (HttpClientManagerImpl.this.print) {
                    HttpClientManagerImpl.this.logger.log(String.format("resp status code %s from the [%s]", statusTips, response.request().url().url()));
                }
                byte[] outBytes = response.body().bytes();
                Document doc = Jsoup.parse((String)new String(outBytes));
                Object o = null;
                o = rtype == Void.TYPE ? null : (rtype == Document.class ? doc : (rtype == byte[].class ? (Object)outBytes : HttpClientManagerImpl.this.toType(rtype, doc, response, this.methods)));
                Document finalO = o;
                for (HttpStatusReceiver receiver : HttpClientManagerImpl.this.receivers) {
                    receiver.receive(HttpClientManagerImpl.this, this.finalUrl, status, dType, this.method, this.type, rtype, finalO, doc);
                }
                object = o;
            }
            catch (Throwable e) {
                try {
                    for (HttpStatusReceiver receiver : HttpClientManagerImpl.this.receivers) {
                        receiver.receive(HttpClientManagerImpl.this, HttpClientManagerImpl.this.merge(this.host, this.path), 0, dType, this.method, this.type, rtype, null, null);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    HttpClientManagerImpl.this.logger.log(String.format("The entire proxy request process took %sms.(execute okhttp request cost %sms)", System.currentTimeMillis() - start, cost));
                    throw throwable;
                }
            }
            HttpClientManagerImpl.this.logger.log(String.format("The entire proxy request process took %sms.(execute okhttp request cost %sms)", System.currentTimeMillis() - start, cost));
            return object;
        }
    }
}

