/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls.baseup;

import io.github.kloping.spt.Setting;
import io.github.kloping.spt.impls.baseup.QueueExecutorWithReturnsImpl;
import io.github.kloping.spt.interfaces.Executor;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.Callback;
import io.github.kloping.spt.interfaces.component.Filter;
import io.github.kloping.spt.interfaces.component.Interceptor;
import io.github.kloping.spt.interfaces.component.InterceptorCallback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QueueExecutorWithReturnsAndInterceptorImpl
extends QueueExecutorWithReturnsImpl
implements Interceptor,
InterceptorCallback {
    private Logger logger;
    private Map<Filter, Integer> interceptMap = new ConcurrentHashMap<Filter, Integer>();
    private Map<Filter, Callback> interceptCall = new ConcurrentHashMap<Filter, Callback>();

    public QueueExecutorWithReturnsAndInterceptorImpl(Class<?> cla, Executor executor, Setting setting) {
        super(cla, executor, setting);
    }

    protected QueueExecutorWithReturnsAndInterceptorImpl(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        super(cla, poolSize, waitTime, executor, setting);
        this.logger = setting.getContextManager().getContextEntity(Logger.class);
    }

    public static QueueExecutorWithReturnsAndInterceptorImpl create(Class<?> cla, int poolSize, long waitTime, Executor executor, Setting setting) {
        return new QueueExecutorWithReturnsAndInterceptorImpl(cla, poolSize, waitTime, executor, setting);
    }

    @Override
    public int addIntercept(int c, Callback callback, Filter filter) {
        this.interceptMap.put(filter, c);
        this.interceptCall.put(filter, callback);
        return this.interceptCall.size();
    }

    @Override
    public int addIntercept(int c, Filter filter) {
        this.interceptMap.put(filter, c);
        return this.interceptMap.size();
    }

    @Override
    public synchronized boolean intercept(Object ... objects) {
        if (!this.interceptMap.isEmpty()) {
            for (Filter k : this.interceptMap.keySet()) {
                if (!k.filter(objects)) continue;
                int c = this.interceptMap.get(k);
                --c;
                if (this.interceptCall.containsKey(k)) {
                    this.interceptCall.get(k).call(objects);
                }
                if (c <= 0) {
                    this.interceptMap.remove(k);
                    if (this.interceptCall.containsKey(k)) {
                        this.interceptCall.remove(k);
                    }
                } else {
                    this.interceptMap.put(k, c);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> int queueExecute(T t, Object ... objects) {
        if (t.getClass() != this.cla) {
            this.logger.Log("not is mainKey type for " + t.getClass().getSimpleName(), 2);
            return 0;
        }
        if (this.runSet.add(t)) {
            if (!this.intercept(objects)) {
                this.tryRun(t, objects);
            }
            return this.queueMap.size();
        }
        this.append(t, objects);
        this.logger.Log("append queue list and next run", 0);
        return 0;
    }
}

