/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest.exceptions;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;

public class AlpacaAPIException
extends Exception {
    private static final long serialVersionUID = 1L;
    private transient HttpResponse<JsonNode> httpResponse;
    private int httpResponseCode = -1;
    private String httpResponseMessage;
    private int alpacaResponseCode = -1;
    private String alpacaResponseMessage;

    public AlpacaAPIException(HttpResponse<JsonNode> httpResponse) {
        this.httpResponseCode = httpResponse.getStatus();
        this.httpResponseMessage = httpResponse.getStatusText();
        JsonNode jsonNode = (JsonNode)httpResponse.getBody();
        if (jsonNode != null) {
            if (jsonNode.getObject().has("code")) {
                this.alpacaResponseCode = jsonNode.getObject().getInt("code");
            }
            this.alpacaResponseMessage = jsonNode.getObject().has("message") ? jsonNode.getObject().getString("message") : jsonNode.getObject().toString();
        }
    }

    public HttpResponse<JsonNode> getHttpResponse() {
        return this.httpResponse;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public String getHttpResponseMessage() {
        return this.httpResponseMessage;
    }

    public int getAlpacaResponseCode() {
        return this.alpacaResponseCode;
    }

    public String getAlpacaResponseMessage() {
        return this.alpacaResponseMessage;
    }

    @Override
    public String getMessage() {
        String message = "Generic Alpaca Exception";
        if (this.alpacaResponseCode != -1) {
            message = this.alpacaResponseCode + "";
            if (this.alpacaResponseMessage != null && !this.alpacaResponseMessage.isEmpty()) {
                message = message + ": " + this.alpacaResponseMessage;
            }
        } else if (this.httpResponseMessage != null && !this.httpResponseMessage.isEmpty()) {
            message = this.httpResponseCode + ": " + this.httpResponseMessage;
        }
        return message;
    }
}

