/*
 * Decompiled with CFR 0.152.
 */
package io.github.matts.emailengine.client;

import feign.AsyncClient;
import feign.Client;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import io.github.matts.emailengine.api.EmailEngineApi;
import java.util.concurrent.Executors;

public class EmailEngineClient {
    public MailgunClientBuilder builder(String baseUrl, String apiKey) {
        return new MailgunClientBuilder(baseUrl, apiKey);
    }

    public static class MailgunClientBuilder {
        private Retryer retryer = new Retryer.Default();
        private ErrorDecoder errorDecoder = new ErrorDecoder.Default();
        private Request.Options options = new Request.Options();
        private AsyncClient<Object> client = new AsyncClient.Default((Client)new Client.Default(null, null), Executors.newSingleThreadExecutor());
        private final String baseUrl;
        private final String apiKey;

        private MailgunClientBuilder(String baseUrl, String apiKey) {
            this.baseUrl = baseUrl;
            this.apiKey = apiKey;
        }

        public static EmailEngineClient build() {
            return new EmailEngineClient();
        }

        public <T extends EmailEngineApi> T createApi(Class<T> apiType) {
            return (T)((EmailEngineApi)this.getFeignBuilder().target(apiType, this.baseUrl));
        }

        public <T extends EmailEngineApi> T createApiWithRequestInterceptor(Class<T> apiType, RequestInterceptor requestInterceptor) {
            return (T)((EmailEngineApi)this.getFeignBuilder().requestInterceptor(requestInterceptor).target(apiType, this.baseUrl));
        }

        private Feign.Builder getFeignBuilder() {
            return Feign.builder().retryer(this.retryer).encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).errorDecoder(this.errorDecoder).options(this.options).requestInterceptor((RequestInterceptor)new EmailEngineAuthInterceptor());
        }

        public class EmailEngineAuthInterceptor
        implements RequestInterceptor {
            public void apply(RequestTemplate template) {
                template.headerLiteral("Authorization", new String[]{"Bearer " + MailgunClientBuilder.this.apiKey});
                template.headerLiteral("Accept", new String[]{"application/json"});
                template.headerLiteral("Content-Type", new String[]{"application/json"});
                template.headerLiteral("x-ee-timeout", new String[]{"30000"});
            }
        }
    }
}

