/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Rendering;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.ImageInfo;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SinglePointFont;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.TacticalGraphicLookup;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class TacticalGraphicIconRenderer {
    private static TacticalGraphicIconRenderer _instance = null;
    private static String _className = "TacticalGraphicIconRenderer";
    private Font _TacticalGraphicFont = null;
    private RendererSettings _RendererSettings = null;
    private final Object _tgFontMutex = new Object();
    private BufferedImage _buffer = null;
    private FontRenderContext _fontRenderContext = null;

    private TacticalGraphicIconRenderer() {
        try {
            float fontSizeForTGIcons = 60.0f;
            this._RendererSettings = RendererSettings.getInstance();
            this._TacticalGraphicFont = SinglePointFont.getInstance().getTGFont(fontSizeForTGIcons);
            _className = this.getClass().getName();
            if (this._TacticalGraphicFont == null) {
                ErrorLogger.LogException((String)this.getClass().getName(), (String)"SinglePointRenderer()", (Exception)new RendererException("TacticalGraphicIconRenderer failed to initialize - _TacticalGraphicFont didn't load.", null));
            }
            if (this._buffer == null) {
                this._buffer = new BufferedImage(8, 8, 2);
                Graphics2D g2d = this._buffer.createGraphics();
                this._fontRenderContext = g2d.getFontRenderContext();
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"TacticalGraphicIconRenderer", (Exception)exc);
        }
    }

    public boolean CanRender(String symbolID) {
        return TacticalGraphicLookup.getInstance().getCharCodeFromSymbol(symbolID) > 0;
    }

    public static synchronized TacticalGraphicIconRenderer getInstance() {
        if (_instance == null) {
            _instance = new TacticalGraphicIconRenderer();
        }
        return _instance;
    }

    public ImageInfo getIcon(String symbolID) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        return this.getIcon(symbolID, 25, null, symStd);
    }

    public ImageInfo getIcon(String symbolID, int iconHeightWidth) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        return this.getIcon(symbolID, iconHeightWidth, null, symStd);
    }

    public ImageInfo getIcon(String symbolID, int iconHeightWidth, Color color) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        return this.getIcon(symbolID, iconHeightWidth, color, symStd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo getIcon(String symbolID, int iconHeightWidth, Color color, int symStd) {
        try {
            int charSymbolIndex;
            MilStdSymbol ms = new MilStdSymbol(symbolID, null, null, null);
            FontRenderContext frc = this._fontRenderContext;
            String id = symbolID;
            if (!SymbolUtilities.isWeather((String)symbolID)) {
                id = symbolID.substring(0, 1) + "*" + symbolID.substring(2, 3) + "P" + symbolID.substring(4);
                if (color != null) {
                    ms.setLineColor(color);
                }
            } else {
                Color temp = SymbolUtilities.getFillColorOfWeather((String)symbolID);
                if (temp == null) {
                    temp = SymbolUtilities.getLineColorOfWeather((String)symbolID);
                }
                if (temp != null) {
                    ms.setLineColor(temp);
                }
            }
            if ((charSymbolIndex = TacticalGraphicLookup.getInstance().getCharCodeFromSymbol(id, symStd)) >= 0) {
                double ratio = (double)iconHeightWidth / 40.0;
                char[] symbol = new char[]{(char)charSymbolIndex};
                Point pixel = new Point(0, 0);
                GlyphVector gvSymbol = null;
                Object object = this._tgFontMutex;
                synchronized (object) {
                    if (charSymbolIndex > 0) {
                        gvSymbol = this._TacticalGraphicFont.createGlyphVector(frc, symbol);
                    }
                }
                Rectangle bounds = gvSymbol.getPixelBounds(frc, 0.0f, 0.0f);
                ratio = Math.min((double)iconHeightWidth / ((RectangularShape)bounds).getHeight(), (double)iconHeightWidth / ((RectangularShape)bounds).getWidth());
                if (ratio > 0.0 && gvSymbol != null) {
                    gvSymbol.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
                ShapeInfo siSymbol = null;
                if (gvSymbol != null) {
                    siSymbol = new ShapeInfo(gvSymbol, (Point2D)pixel);
                }
                if (siSymbol != null) {
                    siSymbol.setLineColor(ms.getLineColor());
                }
                if (siSymbol != null) {
                    siSymbol.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_FRAME);
                }
                ArrayList<ShapeInfo> shapes = new ArrayList<ShapeInfo>();
                if (siSymbol != null) {
                    shapes.add(siSymbol);
                }
                ms.setSymbolShapes(shapes);
                ImageInfo ii = ms.toImageInfo();
                return ii;
            }
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"getIcon()", (Exception)exc);
            return null;
        }
    }
}

