/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Rendering;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.ModifiersTG;
import ArmyC2.C2SD.Utilities.PointConversion;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SinglePointFont;
import ArmyC2.C2SD.Utilities.SinglePointLookup;
import ArmyC2.C2SD.Utilities.SymbolDef;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.SymbolDraw;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.UnitFontLookup;
import ArmyC2.C2SD.Utilities.UnitFontLookupInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class SinglePointRenderer {
    private static SinglePointRenderer _instance = null;
    private static String _className = "SinglePointRenderer";
    private RendererSettings _RendererSettings = null;
    private BufferedImage _buffer = null;
    private FontRenderContext _fontRenderContext = null;
    PointConversion _PointConverter = null;
    private static ArrayList<String> _ModifierNamesTG = null;
    private static Font _SinglePointFont = null;
    private static Font _UnitFont = null;
    private static Font _ModifierFont = null;
    private final Object _SinglePointFontMutex = new Object();
    private final Object _UnitFontMutex = new Object();
    private final Object _ModifierFontMutex = new Object();
    public static final int UnitSizeMedium = 40;
    public static final int UnitSizeSmall = 30;
    public static final int UnitSizeLarge = 50;
    public static final int UnitSizeXL = 60;
    public static final int SymbolSizeMedium = 80;
    public static final int SymbolSizeSmall = 60;
    public static final int SymbolSizeLarge = 100;
    public static final int SymbolSizeXL = 120;

    private SinglePointRenderer() {
        try {
            this._RendererSettings = RendererSettings.getInstance();
            _SinglePointFont = SinglePointFont.getInstance().getSPFont(60.0f);
            _UnitFont = SinglePointFont.getInstance().getUnitFont(40.0f);
            _ModifierFont = RendererSettings.getInstance().getLabelFont();
            _ModifierNamesTG = ModifiersTG.GetModifierList();
            _className = this.getClass().getName();
            if (_SinglePointFont == null) {
                ErrorLogger.LogException((String)this.getClass().getName(), (String)"SinglePointRenderer()", (Exception)new RendererException("SinglePointRenderer failed to initialize - _SinglePointFont didn't load.", null));
            }
            if (_UnitFont == null) {
                ErrorLogger.LogException((String)this.getClass().getName(), (String)"SinglePointRenderer()", (Exception)new RendererException("SinglePointRenderer failed to initialize - _UnitFont didn't load.", null));
            }
            if (this._buffer == null) {
                this._buffer = new BufferedImage(8, 8, 2);
                Graphics2D g2d = this._buffer.createGraphics();
                this._fontRenderContext = g2d.getFontRenderContext();
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"SinglePointRenderer", (Exception)exc);
        }
    }

    public static synchronized SinglePointRenderer getInstance() {
        if (_instance == null) {
            _instance = new SinglePointRenderer();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessUnitSymbol(MilStdSymbol symbol, IPointConversion converter) {
        try {
            Color c1;
            FontRenderContext fontRenderContext = this._fontRenderContext;
            String symbolID = symbol.getSymbolID();
            int renderMethod = RendererSettings.getInstance().getUnitRenderMethod();
            double pixelSize = symbol.getUnitSize();
            int symStd = symbol.getSymbologyStandard();
            int charFillIndex = UnitFontLookup.getFillCode((String)symbolID, (int)symStd);
            int charFrameIndex = UnitFontLookup.getFrameCode((String)symbolID, (int)charFillIndex, (int)symStd);
            int charFrameAssumedIndex = -1;
            if (symStd == 1) {
                char affiliation = symbol.getSymbolID().charAt(1);
                switch (affiliation) {
                    case 'A': 
                    case 'G': 
                    case 'M': 
                    case 'P': 
                    case 'S': {
                        if (symbol.getSymbolID().charAt(2) == 'U' && (symbolID.substring(4, 6).equals("WM") || symbolID.substring(4, 7).equals("WDM"))) {
                            if (symbol.getSymbolID().charAt(3) != 'A') {
                                ++charFillIndex;
                            }
                            charFrameAssumedIndex = charFillIndex - 1;
                            charFrameIndex = -1;
                            break;
                        }
                        charFrameIndex = charFillIndex + 2;
                        charFrameAssumedIndex = charFillIndex + 1;
                    }
                }
            }
            int charSymbol1Index = -1;
            int charSymbol2Index = -1;
            UnitFontLookupInfo lookup = UnitFontLookup.getInstance().getLookupInfo(symbolID, symStd);
            if (lookup == null) {
                lookup = SinglePointRenderer.ResolveUnitFontLookupInfo(symbolID, symStd);
                symbol.setFillColor(SymbolUtilities.getFillColorOfAffiliation((String)symbolID));
                symbol.setLineColor(SymbolUtilities.getLineColorOfAffiliation((String)symbolID));
            }
            if (lookup != null) {
                charSymbol1Index = lookup.getMapping1(symbolID);
                charSymbol2Index = lookup.getMapping2();
            }
            FontRenderContext frc = fontRenderContext;
            char[] frameSymbol = new char[]{(char)charFrameIndex};
            char[] frameAssumedSymbol = new char[]{(char)charFrameAssumedIndex};
            char[] fillSymbol = new char[]{(char)charFillIndex};
            char[] symbol1 = new char[1];
            char[] symbol2 = new char[1];
            if (charSymbol1Index > 0) {
                symbol1[0] = (char)charSymbol1Index;
            }
            if (charSymbol2Index > 0) {
                symbol2[0] = (char)charSymbol2Index;
            }
            GlyphVector gvFrame = null;
            GlyphVector gvFrameAssumed = null;
            GlyphVector gvFill = null;
            GlyphVector gvSymbol1 = null;
            GlyphVector gvSymbol2 = null;
            Rectangle symbolBounds = null;
            double ratio = 0.0;
            Object object = this._UnitFontMutex;
            synchronized (object) {
                if (symbol.getKeepUnitRatio().booleanValue() && pixelSize > 0.0) {
                    double heightRatio = 1.5;
                    double widthRatio = 1.5;
                    heightRatio = UnitFontLookup.getUnitRatioHeight((int)charFillIndex);
                    pixelSize = heightRatio > (widthRatio = UnitFontLookup.getUnitRatioWidth((int)charFillIndex)) ? pixelSize / 1.5 * heightRatio : pixelSize / 1.5 * widthRatio;
                }
                if (charFrameAssumedIndex > 0) {
                    gvFrameAssumed = _UnitFont.createGlyphVector(frc, frameAssumedSymbol);
                }
                if (charFrameIndex > 0) {
                    gvFrame = _UnitFont.createGlyphVector(frc, frameSymbol);
                }
                if (charFillIndex > 0) {
                    gvFill = _UnitFont.createGlyphVector(frc, fillSymbol);
                }
                if (charSymbol1Index > 0) {
                    gvSymbol1 = _UnitFont.createGlyphVector(frc, symbol1);
                }
                if (charSymbol2Index > 0) {
                    gvSymbol2 = _UnitFont.createGlyphVector(frc, symbol2);
                }
                if (!symbol.getKeepUnitRatio().booleanValue() && gvSymbol1 != null && symbol.getIconColor() != null && symbol.getLineColor().getAlpha() == 0 && symbol.getFillColor().getAlpha() == 0) {
                    gvFill = null;
                    gvFrameAssumed = null;
                    gvFrame = null;
                }
                if (pixelSize > 0.0 && (charFrameIndex > 0 || charFillIndex > 0)) {
                    Rectangle foo = null;
                    if (gvFrame != null) {
                        foo = gvFrame.getPixelBounds(frc, 0.0f, 0.0f);
                    } else if (gvFill != null) {
                        foo = gvFill.getPixelBounds(frc, 0.0f, 0.0f);
                    } else if (gvSymbol1 != null) {
                        foo = gvSymbol1.getPixelBounds(frc, 0.0f, 0.0f);
                    } else if (gvSymbol2 != null) {
                        foo = gvSymbol2.getPixelBounds(frc, 0.0f, 0.0f);
                    }
                    ratio = Math.min(pixelSize / foo.getHeight(), pixelSize / foo.getWidth());
                }
            }
            if (ratio > 0.0) {
                if (gvFill != null) {
                    gvFill.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
                if (gvFrameAssumed != null) {
                    gvFrameAssumed.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
                if (gvFrame != null) {
                    gvFrame.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
                if (gvSymbol1 != null) {
                    gvSymbol1.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
                if (gvSymbol2 != null) {
                    gvSymbol2.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
            }
            ArrayList coords = symbol.getCoordinates();
            Point2D.Double location = (Point2D.Double)coords.get(0);
            Point2D pixel = converter.GeoToPixels((Point2D)location);
            Rectangle2D symbolBounds2D = null;
            if (gvFrame != null) {
                symbolBounds2D = gvFrame.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (gvFill != null) {
                symbolBounds2D = gvFill.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (gvSymbol1 != null) {
                symbolBounds2D = gvSymbol1.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (gvSymbol2 != null) {
                symbolBounds2D = gvSymbol2.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (pixelSize > 0.0) {
                symbolBounds2D = new Rectangle2D.Double(pixel.getX() - pixelSize / 2.0, pixel.getY() - pixelSize / 2.0, pixelSize, pixelSize);
            }
            if (SymbolUtilities.isHQ((String)symbol.getSymbolID()) && RendererSettings.getInstance().getCenterOnHQStaff().booleanValue()) {
                double y;
                double x;
                String affiliation = symbol.getSymbolID().substring(1, 2);
                if (affiliation.equals("F") || affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("J") || affiliation.equals("K") || affiliation.equals("N") || affiliation.equals("L")) {
                    x = pixel.getX() + (double)((int)(symbolBounds2D.getWidth() / 2.0));
                    y = pixel.getY() - (double)((int)(symbolBounds2D.getHeight() * 1.5));
                    pixel.setLocation(x, y);
                } else {
                    x = pixel.getX() + (double)((int)(symbolBounds2D.getWidth() / 2.0));
                    y = pixel.getY() - (double)((int)symbolBounds2D.getHeight());
                    pixel.setLocation(x, y);
                }
            }
            Shape shapeFrameAssumed = null;
            Shape shapeFrame = null;
            Shape shapeFill = null;
            Shape shapeSymbol1 = null;
            Shape shapeSymbol2 = null;
            if (renderMethod == 0) {
                if (gvFrameAssumed != null) {
                    shapeFrameAssumed = gvFrameAssumed.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
                }
                if (gvFrame != null) {
                    shapeFrame = gvFrame.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
                }
                if (gvFill != null) {
                    shapeFill = gvFill.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
                }
                if (gvSymbol1 != null) {
                    shapeSymbol1 = gvSymbol1.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
                }
                if (gvSymbol2 != null) {
                    shapeSymbol2 = gvSymbol2.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
                }
            }
            ShapeInfo siFrameAssumed = null;
            ShapeInfo siFrame = null;
            ShapeInfo siFill = null;
            ShapeInfo siSymbol1 = null;
            ShapeInfo siSymbol2 = null;
            if (renderMethod == 0) {
                if (shapeFrameAssumed != null) {
                    siFrameAssumed = new ShapeInfo(shapeFrameAssumed);
                }
                if (shapeFrame != null) {
                    siFrame = new ShapeInfo(shapeFrame);
                }
                if (shapeFill != null) {
                    siFill = new ShapeInfo(shapeFill);
                }
                if (shapeSymbol1 != null) {
                    siSymbol1 = new ShapeInfo(shapeSymbol1);
                }
                if (shapeSymbol2 != null) {
                    siSymbol2 = new ShapeInfo(shapeSymbol2);
                }
                siFrame.setGlyphPosition(pixel);
                if (siFrameAssumed != null) {
                    siFrameAssumed.setFillColor(Color.WHITE);
                }
                if (siFrame != null) {
                    siFrame.setFillColor(symbol.getLineColor());
                }
                if (siFill != null) {
                    siFill.setFillColor(symbol.getFillColor());
                }
                if (siSymbol1 != null) {
                    c1 = null;
                    c1 = symbol.getIconColor() != null ? symbol.getIconColor() : lookup.getColor1();
                    siSymbol1.setFillColor(new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), symbol.getLineColor().getAlpha()));
                }
                if (siSymbol2 != null) {
                    Color c2 = lookup.getColor2();
                    siSymbol2.setFillColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), symbol.getLineColor().getAlpha()));
                }
            } else if (renderMethod == 1) {
                if (gvFrameAssumed != null) {
                    siFrameAssumed = new ShapeInfo(gvFrameAssumed, pixel);
                }
                if (gvFrame != null) {
                    siFrame = new ShapeInfo(gvFrame, pixel);
                }
                if (gvFill != null) {
                    siFill = new ShapeInfo(gvFill, pixel);
                }
                if (gvSymbol1 != null) {
                    siSymbol1 = new ShapeInfo(gvSymbol1, pixel);
                }
                if (gvSymbol2 != null) {
                    siSymbol2 = new ShapeInfo(gvSymbol2, pixel);
                }
                if (siFrameAssumed != null) {
                    siFrameAssumed.setLineColor(Color.WHITE);
                }
                if (siFrame != null) {
                    siFrame.setLineColor(symbol.getLineColor());
                }
                if (siFill != null) {
                    siFill.setLineColor(symbol.getFillColor());
                }
                c1 = null;
                if (siSymbol1 != null) {
                    if (symbol.getIconColor() != null) {
                        c1 = symbol.getIconColor();
                        siSymbol1.setLineColor(new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha()));
                    } else {
                        c1 = lookup.getColor1();
                        siSymbol1.setLineColor(new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), symbol.getLineColor().getAlpha()));
                    }
                }
                if (siSymbol2 != null) {
                    Color c2 = lookup.getColor2();
                    if (c1 == null) {
                        siSymbol2.setLineColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), symbol.getLineColor().getAlpha()));
                    } else {
                        siSymbol2.setLineColor(new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), c1.getAlpha()));
                    }
                }
                if (symbol.getSymbolID().charAt(2) == 'U' && symbol.getSymbolID().substring(4, 6).equals("WM")) {
                    if (symStd == 0) {
                        siFill.setLineColor(symbol.getFillColor());
                        siSymbol1.setLineColor(symbol.getLineColor());
                    } else if (symStd == 1) {
                        // empty if block
                    }
                } else if (symbol.getSymbolID().charAt(2) == 'S' && symbol.getSymbolID().charAt(4) == 'O') {
                    siFill.setLineColor(symbol.getFillColor());
                }
            }
            if (siFill != null) {
                siFill.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_FILL);
            }
            if (siFrameAssumed != null) {
                siFrameAssumed.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_FRAME);
            }
            if (siFrame != null) {
                siFrame.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_FRAME);
            }
            if (siSymbol1 != null) {
                siSymbol1.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_SYMBOL1);
            }
            if (siSymbol2 != null) {
                siSymbol2.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_SYMBOL2);
            }
            ArrayList<ShapeInfo> shapes = new ArrayList<ShapeInfo>();
            if (siFrameAssumed != null && charFrameIndex == -1) {
                shapes.add(siFrameAssumed);
            }
            if (siFill != null) {
                shapes.add(siFill);
            }
            if (siFrameAssumed != null && charFrameIndex > 0) {
                shapes.add(siFrameAssumed);
            }
            if (siFrame != null) {
                shapes.add(siFrame);
            }
            if (siSymbol2 != null) {
                shapes.add(siSymbol2);
            }
            if (siSymbol1 != null) {
                shapes.add(siSymbol1);
            }
            if (symbol.getOutlineEnabled() && siFrame != null) {
                ArrayList symbolOutlines = SymbolDraw.createSinglePointOutline((ShapeInfo)siFrame, (int)symbol.getOutlineWidth(), (Color)symbol.getOutlineColor());
                shapes.addAll(0, symbolOutlines);
            }
            symbol.setSymbolShapes(shapes);
            if (gvFrame != null) {
                symbolBounds = gvFrame.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (gvFill != null) {
                symbolBounds = gvFill.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (gvSymbol1 != null) {
                symbolBounds = gvSymbol1.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            } else if (gvSymbol2 != null) {
                symbolBounds = gvSymbol2.getPixelBounds(frc, (int)pixel.getX(), (int)pixel.getY());
            }
            String drawModifiers = symbol.getModifier("showdisplaymodifiers");
            if (drawModifiers != null && drawModifiers.equalsIgnoreCase("false")) {
                return;
            }
            if (symbol.getOutlineEnabled()) {
                symbolBounds.grow(symbol.getOutlineWidth(), symbol.getOutlineWidth());
            }
            this.ProcessUnitDisplayModifiers(symbol.getSymbolID(), shapes, symbolBounds, pixelSize, symStd, symbol.getTextColor(), symbol.getTextBackgroundColor());
            if (!symbol.getDrawAffiliationModifierAsLabel()) {
                this.ProcessUnitAffiliationModifiers(symbol.getSymbolID(), shapes, symbolBounds, symStd, symbol.getTextColor(), symbol.getTextBackgroundColor());
            } else {
                String affiliationModifier = SymbolUtilities.getUnitAffiliationModifier((String)symbolID, (int)symStd);
                if (affiliationModifier != null) {
                    symbol.setModifier("E", affiliationModifier);
                }
            }
            Map modifiers = symbol.getModifierMap();
            Boolean hasCC = SymbolUtilities.hasValidCountryCode((String)symbolID);
            if (hasCC.booleanValue() || modifiers != null && modifiers.size() > 0) {
                String dom;
                Object odom = modifiers.get("Q");
                if (odom != null && (dom = String.valueOf(odom)) != null && !dom.equals("") && SymbolUtilities.isNumber((String)dom) && SymbolUtilities.hasDirectionOfMovement((String)symbol.getSymbolID(), (int)symStd)) {
                    double angle = Double.valueOf(dom);
                    ArrayList<ShapeInfo> arrow = this.CreateDOMArrow(symbol.getSymbolID(), symbolBounds, angle);
                    if (arrow != null) {
                        shapes.addAll(arrow);
                    }
                }
                Rectangle echelonBounds = null;
                int shapeSize = shapes.size();
                for (int i = 0; i < shapeSize; ++i) {
                    if (shapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_ECHELON) continue;
                    echelonBounds = shapes.get(i).getBounds();
                    int textOutlineWidth = RendererSettings.getInstance().getTextOutlineWidth();
                    echelonBounds.grow(textOutlineWidth, i);
                    i = shapeSize;
                }
                Rectangle affiliationBounds = null;
                for (int j = 0; j < shapeSize; ++j) {
                    if (shapes.get(j).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_AFFILIATION_MODIFIER) continue;
                    affiliationBounds = shapes.get(j).getBounds();
                    j = shapeSize;
                }
                Rectangle bounds = new Rectangle(symbolBounds);
                Color textColor = Color.BLACK;
                Color textBackgroundColor = null;
                if (symbol.getTextColor() != null) {
                    textColor = symbol.getTextColor();
                }
                if (symbol.getTextBackgroundColor() != null) {
                    textBackgroundColor = symbol.getTextBackgroundColor();
                }
                if (RendererSettings.getInstance().getLabelForegroundColor() != null) {
                    textColor = RendererSettings.getInstance().getLabelForegroundColor();
                }
                ArrayList msTemp = SinglePointRenderer.GetUnitModifierShape(symbol.getSymbolID(), symbol.getModifierMap(), frc, _ModifierFont, bounds, echelonBounds, affiliationBounds, textColor, textBackgroundColor);
                msTemp = SymbolDraw.ProcessModifierBackgrounds(msTemp);
                symbol.setModifierShapes(msTemp);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)("ProcessUnitSymbol(" + symbol.getSymbolID() + ")"), (Exception)exc);
        }
    }

    private static UnitFontLookupInfo ResolveUnitFontLookupInfo(String symbolID, int symStd) {
        String id = symbolID;
        UnitFontLookupInfo lookup = null;
        String affiliation = "";
        String status = "";
        if (id != null && id.length() >= 10) {
            StringBuilder sb = new StringBuilder("");
            sb.append(id.charAt(0));
            if (!SymbolUtilities.hasValidAffiliation((String)id).booleanValue()) {
                sb.append('U');
                affiliation = "U";
            } else {
                sb.append(id.charAt(1));
                affiliation = id.substring(1, 2);
            }
            if (!SymbolUtilities.hasValidBattleDimension((String)id).booleanValue()) {
                sb.append('Z');
                sb.replace(0, 1, "S");
            } else {
                sb.append(id.charAt(2));
            }
            if (!SymbolUtilities.hasValidStatus((String)id).booleanValue()) {
                sb.append('P');
                status = "P";
            } else {
                sb.append(id.charAt(3));
                status = id.substring(3, 4);
            }
            sb.append("------");
            if (id.length() >= 15) {
                sb.append(id.substring(10, 15));
            } else {
                sb.append("*****");
            }
            id = sb.toString();
            lookup = UnitFontLookup.getInstance().getLookupInfo(id, symStd);
        } else if (symbolID == null || symbolID.equals("")) {
            lookup = UnitFontLookup.getInstance().getLookupInfo("SUZP------*****", symStd);
        }
        return lookup;
    }

    private void ProcessUnitAffiliationModifiers(String SymbolID, ArrayList<ShapeInfo> shapes, Rectangle bounds, int symStd, Color textColor, Color textBackgroundColor) {
        int x = 0;
        int y = 0;
        int affiliation = 48;
        String textChar = null;
        ShapeInfo siAffiliation = null;
        Rectangle echelonBounds = null;
        try {
            int fontSize = 12;
            int offset = 1;
            double ratio = 3.0;
            fontSize = (int)Math.round(bounds.getWidth() / ratio);
            int shapeSize = shapes.size();
            for (int i = 0; i < shapeSize; ++i) {
                if (shapes.get(i).getShapeType() != ShapeInfo.SHAPE_TYPE_UNIT_ECHELON) continue;
                echelonBounds = shapes.get(i).getBounds();
                i = shapeSize;
            }
            affiliation = SymbolID.charAt(1);
            if (affiliation == 70 || affiliation == 72 || affiliation == 85 || affiliation == 78 || affiliation == 80) {
                textChar = null;
            } else if (affiliation == 65 || affiliation == 83) {
                textChar = symStd == 0 ? "?" : null;
            } else if (affiliation == 74) {
                textChar = "J";
            } else if (affiliation == 75) {
                textChar = "K";
            } else if (affiliation == 68 || affiliation == 76 || affiliation == 71 || affiliation == 87) {
                textChar = "X";
            } else if (affiliation == 77) {
                textChar = symStd == 0 ? "X?" : "X";
            }
            if (symStd == 1 && SymbolID.charAt(0) == 'S' && SymbolID.indexOf("WM") == 4) {
                textChar = SymbolID.indexOf("GX") == 6 || SymbolID.indexOf("MX") == 6 || SymbolID.indexOf("FX") == 6 || SymbolID.indexOf("X") == 6 || SymbolID.indexOf("SX") == 6 ? "X" : null;
            }
            if (textChar == null) {
                return;
            }
            TextLayout text = new TextLayout(textChar, new Font("Arial", 1, fontSize), this._fontRenderContext);
            if (echelonBounds != null && (double)echelonBounds.width + echelonBounds.getX() > bounds.getX() + bounds.getWidth()) {
                x = echelonBounds.x + echelonBounds.width + offset;
                y = bounds.y - offset;
            } else {
                x = bounds.x + bounds.width + offset;
                y = bounds.y - offset;
            }
            siAffiliation = SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)textChar, (double)x, (double)y, (Color)textColor, (Color)textBackgroundColor);
            siAffiliation.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_AFFILIATION_MODIFIER);
            if (RendererSettings.getInstance().getTextBackgroundMethod() != 0) {
                ArrayList affiliationParts = new ArrayList();
                affiliationParts.add(siAffiliation);
                affiliationParts = SymbolDraw.ProcessModifierBackgrounds(affiliationParts);
                shapes.addAll(affiliationParts);
            } else {
                shapes.add(siAffiliation);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"JavaRenderer", (String)"ProcessUnitAffiliationModifiers", (Exception)exc, (Boolean)Boolean.FALSE);
        }
    }

    private void ProcessUnitDisplayModifiers(String SymbolID, ArrayList<ShapeInfo> shapes, Rectangle bounds, double pixelSize, int symStd, Color textColor, Color textBackgroundColor) {
        try {
            ShapeInfo siTemp = null;
            ArrayList<ShapeInfo> siTempArray = null;
            Rectangle echelonBounds = null;
            siTempArray = this.CreateOperationalConditionIndicator(SymbolID, bounds, pixelSize);
            if (siTempArray != null) {
                shapes.addAll(siTempArray);
            }
            if (!SymbolID.substring(10, 11).equals("M") && !SymbolID.substring(10, 11).equals("N")) {
                String echelon;
                if (SymbolUtilities.canUnitHaveModifier((String)SymbolID, (String)"B") && !SymbolUtilities.hasInstallationModifier((String)SymbolID) && !(echelon = SymbolID.substring(11, 12)).equals("-") && !echelon.equals("*") && (siTemp = this.CreateEchelonShapeInfo(SymbolID.substring(11, 12), this._fontRenderContext, bounds, textColor, textBackgroundColor)) != null) {
                    ArrayList echelonParts = new ArrayList();
                    echelonParts.add(siTemp);
                    echelonParts = SymbolDraw.ProcessModifierBackgrounds(echelonParts);
                    shapes.addAll(echelonParts);
                    echelonBounds = ((ShapeInfo)echelonParts.get(echelonParts.size() - 1)).getBounds();
                }
                if (SymbolUtilities.isTaskForce((String)SymbolID)) {
                    siTemp = this.CreateTaskForceIndicator(SymbolID, bounds, echelonBounds);
                    if (siTemp != null) {
                        shapes.add(siTemp);
                    }
                    echelonBounds = siTemp.getBounds();
                }
                if ((SymbolUtilities.isFeintDummy((String)SymbolID) || SymbolUtilities.isFeintDummyInstallation((String)SymbolID)) && (siTemp = this.CreateFeintDummyIndicator(SymbolID, bounds, echelonBounds)) != null) {
                    shapes.add(siTemp);
                }
                if (SymbolUtilities.hasInstallationModifier((String)SymbolID) && (siTemp = this.CreateInstallationIndicator(SymbolID, bounds)) != null) {
                    String affiliation = SymbolID.substring(1, 2);
                    if (affiliation.equals("F") || affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("J") || affiliation.equals("K") || affiliation.equals("N") || affiliation.equals("L")) {
                        shapes.add(siTemp);
                    } else {
                        shapes.add(0, siTemp);
                    }
                }
                if (SymbolUtilities.isHQ((String)SymbolID)) {
                    Point2D.Double pt1 = null;
                    Point2D.Double pt2 = null;
                    String affiliation = SymbolID.substring(1, 2);
                    if (affiliation.equals("F") || affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("J") || affiliation.equals("K") || affiliation.equals("N") || affiliation.equals("L")) {
                        pt1 = new Point2D.Double(bounds.getX() + 1.0, bounds.getY() + bounds.getHeight());
                        pt2 = new Point2D.Double(((Point2D)pt1).getX(), ((Point2D)pt1).getY() + bounds.getHeight());
                    } else {
                        pt1 = new Point2D.Double(bounds.getX() + 1.0, bounds.getY() + bounds.getHeight() / 2.0);
                        pt2 = new Point2D.Double(((Point2D)pt1).getX(), ((Point2D)pt1).getY() + bounds.getHeight());
                    }
                    Line2D.Double staff = new Line2D.Double(pt1, pt2);
                    siTemp = new ShapeInfo((Shape)staff);
                    siTemp.setLineColor(Color.BLACK);
                    siTemp.setStroke((Stroke)new BasicStroke(2.0f));
                    siTemp.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
                    shapes.add(siTemp);
                }
            } else {
                ArrayList<ShapeInfo> tas;
                if (SymbolID.substring(10, 11).equals("M") && (siTemp = this.CreateMobilityShapeInfo(SymbolID, bounds)) != null) {
                    shapes.add(siTemp);
                }
                if ((SymbolID.substring(10, 12).equals("NS") || SymbolID.substring(10, 12).equals("NL")) && !(tas = this.CreateTowedSonarArrayShapeInfo(SymbolID, bounds)).isEmpty()) {
                    shapes.addAll(tas);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ProcessUnitDisplayModifiers()", (Exception)exc);
        }
    }

    private ShapeInfo CreateFeintDummyIndicator(String symbolID, Rectangle2D symbolBounds, Rectangle2D echelonBounds) {
        Path2D.Double sFeint = new Path2D.Double();
        ShapeInfo siFeint = null;
        float[] dash = new float[]{6.0f, 4.0f};
        float width = 2.0f;
        try {
            if (symbolBounds != null && symbolBounds.getWidth() < 20.0) {
                width = 1.0f;
                dash[0] = 5.0f;
                dash[1] = 3.0f;
            }
            BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, dash, 0.0f);
            Point2D.Double left = new Point2D.Double(symbolBounds.getX(), symbolBounds.getY());
            Point2D.Double top = null;
            Point2D.Double right = new Point2D.Double(symbolBounds.getX() + symbolBounds.getWidth(), symbolBounds.getY());
            String affiliation = symbolID.substring(1, 2);
            top = affiliation.equals("F") || affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("J") || affiliation.equals("K") ? new Point2D.Double(symbolBounds.getCenterX(), symbolBounds.getY() - symbolBounds.getHeight() * 0.75) : new Point2D.Double(symbolBounds.getCenterX(), symbolBounds.getY() - symbolBounds.getHeight() * 0.54);
            Line2D.Double leftLine = new Line2D.Double(left, top);
            Line2D.Double rightLine = new Line2D.Double(top, right);
            sFeint.append(leftLine, false);
            sFeint.append(rightLine, false);
            if (echelonBounds != null && sFeint.intersects(echelonBounds)) {
                ((Path2D)sFeint).transform(AffineTransform.getTranslateInstance(0.0, -echelonBounds.getHeight() - 2.0));
            }
            siFeint = new ShapeInfo((Shape)sFeint);
            siFeint.setLineColor(Color.BLACK);
            siFeint.setStroke((Stroke)stroke);
            siFeint.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CreateFeintDummyIndicator()", (Exception)exc);
        }
        return siFeint;
    }

    private ShapeInfo CreateTaskForceIndicator(String symbolID, Rectangle2D symbolBounds, Rectangle2D echelonBounds) {
        ShapeInfo siTaskForce = null;
        BasicStroke stroke = new BasicStroke(2.0f);
        Rectangle sTaskForce = null;
        int sideBuffer = 3;
        try {
            if (symbolBounds != null && symbolBounds.getWidth() < 20.0) {
                stroke = new BasicStroke(1.0f);
            }
            if (echelonBounds != null && !echelonBounds.isEmpty()) {
                sTaskForce = new Rectangle();
                sTaskForce.setFrame(echelonBounds.getX() - (double)sideBuffer, echelonBounds.getY() - 2.0, echelonBounds.getWidth() + (double)(sideBuffer * 2), symbolBounds.getY() - (echelonBounds.getY() - 2.0));
            } else {
                double height = 10.0;
                double width = 30.0;
                height = symbolBounds.getHeight() / 4.0;
                width = symbolBounds.getWidth() / 3.0;
                sTaskForce = new Rectangle();
                sTaskForce.setFrame(symbolBounds.getX() + width, symbolBounds.getY() - height, width, height);
            }
            siTaskForce = new ShapeInfo((Shape)sTaskForce);
            siTaskForce.setLineColor(Color.BLACK);
            siTaskForce.setStroke((Stroke)stroke);
            siTaskForce.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CreateTaskForceIndicator()", (Exception)exc);
        }
        return siTaskForce;
    }

    private ShapeInfo CreateInstallationIndicator(String symbolID, Rectangle2D symbolBounds) {
        ShapeInfo siInstallation = null;
        BasicStroke stroke = new BasicStroke(1.0f);
        Rectangle sInstallation = null;
        try {
            double height = 10.0;
            double width = 30.0;
            sInstallation = new Rectangle();
            char affiliation = symbolID.charAt(1);
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                height = symbolBounds.getHeight() / 4.0;
                width = symbolBounds.getWidth() / 3.0;
            } else if (affiliation == 'H' || affiliation == 'S') {
                height = symbolBounds.getHeight() / 6.0;
                width = symbolBounds.getWidth() / 3.0;
            } else if (affiliation == 'N' || affiliation == 'L') {
                height = symbolBounds.getHeight() / 6.0;
                width = symbolBounds.getWidth() / 3.0;
            } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                height = symbolBounds.getHeight() / 6.0;
                width = symbolBounds.getWidth() / 3.0;
            } else {
                height = symbolBounds.getHeight() / 6.0;
                width = symbolBounds.getWidth() / 3.0;
            }
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' || affiliation == 'N' || affiliation == 'L') {
                sInstallation.setFrame(symbolBounds.getX() + width, symbolBounds.getY() - height, width, height);
            } else if (affiliation == 'H' || affiliation == 'S') {
                sInstallation.setFrame(symbolBounds.getX() + width, symbolBounds.getY() - height * 0.2, width, height);
            } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                sInstallation.setFrame(symbolBounds.getX() + width, symbolBounds.getY() - height * 0.25, width, height);
            } else {
                sInstallation.setFrame(symbolBounds.getX() + width, symbolBounds.getY() - height * 0.25, width, height);
            }
            siInstallation = new ShapeInfo((Shape)sInstallation);
            siInstallation.setFillColor(Color.BLACK);
            siInstallation.setStroke((Stroke)stroke);
            siInstallation.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CreateInstallationIndicator()", (Exception)exc);
        }
        return siInstallation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<ShapeInfo> CreateOperationalConditionIndicator(String SymbolID, Rectangle2D symbolBounds, double pixelSize) {
        ArrayList<ShapeInfo> bars = null;
        int status = 32;
        Color statusColor = Color.GREEN;
        ShapeInfo siOCIF = null;
        ShapeInfo siOCIB = null;
        BasicStroke stroke = new BasicStroke(1.0f);
        Rectangle2D.Double sOCIForeground = null;
        Rectangle2D.Double sOCIBackground = null;
        int outlineSize = 1;
        int widthAdjust = 1;
        try {
            status = SymbolID.charAt(3);
            if (RendererSettings.getInstance().getOperationalConditionModifierType() == RendererSettings.OperationalConditionModifierType_BAR) {
                if (symbolBounds == null || SymbolID.length() <= 4) return null;
                bars = new ArrayList();
                if (status == 67) {
                    statusColor = Color.GREEN;
                } else if (status == 68) {
                    statusColor = Color.YELLOW;
                } else if (status == 88) {
                    statusColor = Color.RED;
                } else {
                    if (status != 70) return null;
                    statusColor = Color.BLUE;
                }
                bars = new ArrayList();
                double barSize = 0.0;
                if (pixelSize > 0.0) {
                    barSize = pixelSize / 5.0;
                }
                if (barSize < 2.0) {
                    barSize = 2.0;
                }
                sOCIForeground = new Rectangle2D.Double(symbolBounds.getX() + (double)widthAdjust, symbolBounds.getY() + symbolBounds.getHeight() + 2.0, symbolBounds.getWidth() - (double)(widthAdjust * 2), barSize);
                sOCIBackground = new Rectangle2D.Double(((RectangularShape)sOCIForeground).getX() - (double)outlineSize, ((RectangularShape)sOCIForeground).getY() - (double)outlineSize, ((RectangularShape)sOCIForeground).getWidth() + (double)(outlineSize * 2), barSize + (double)(outlineSize * 2));
                siOCIF = new ShapeInfo((Shape)sOCIForeground, ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
                siOCIF.setFillColor(statusColor);
                siOCIF.setStroke((Stroke)stroke);
                siOCIB = new ShapeInfo((Shape)sOCIBackground, ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
                siOCIB.setFillColor(Color.BLACK);
                siOCIB.setStroke((Stroke)stroke);
                bars.add(siOCIB);
                bars.add(siOCIF);
                return bars;
            } else {
                GeneralPath path = null;
                if (status != 68 && status != 88) return bars;
                bars = new ArrayList<ShapeInfo>();
                path = new GeneralPath();
                int fillCode = UnitFontLookup.getFillCode((String)SymbolID, (int)1);
                double widthRatio = UnitFontLookup.getUnitRatioWidth((int)fillCode);
                double heightRatio = UnitFontLookup.getUnitRatioHeight((int)fillCode);
                double slashHeight = symbolBounds.getHeight() / heightRatio * 1.47;
                double slashWidth = symbolBounds.getWidth() / widthRatio * 0.85;
                double centerX = symbolBounds.getCenterX();
                double centerY = symbolBounds.getCenterY();
                if (status == 68) {
                    path.moveTo(centerX - slashWidth / 2.0, centerY + slashHeight / 2.0);
                    path.lineTo(centerX + slashWidth / 2.0, centerY - slashHeight / 2.0);
                } else if (status == 88) {
                    path.moveTo(centerX - slashWidth / 2.0, centerY + slashHeight / 2.0);
                    path.lineTo(centerX + slashWidth / 2.0, centerY - slashHeight / 2.0);
                    path.moveTo(centerX - slashWidth / 2.0, centerY - slashHeight / 2.0);
                    path.lineTo(centerX + slashWidth / 2.0, centerY + slashHeight / 2.0);
                }
                ShapeInfo siOCMS = new ShapeInfo((Shape)path, ShapeInfo.SHAPE_TYPE_UNIT_OPERATIONAL_CONDITION);
                siOCMS.setLineColor(Color.BLACK);
                double size = symbolBounds.getWidth();
                float ociStrokeWidth = 3.0f;
                ociStrokeWidth = (float)size / 20.0f;
                if (ociStrokeWidth < 1.0f) {
                    ociStrokeWidth = 1.0f;
                }
                stroke = new BasicStroke(ociStrokeWidth);
                siOCMS.setStroke((Stroke)stroke);
                if (siOCMS == null) return bars;
                bars.add(siOCMS);
            }
            return bars;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CreateInstallationIndicator()", (Exception)exc);
        }
        return bars;
    }

    private ShapeInfo CreateEchelonShapeInfo(String echelon, FontRenderContext frc, Rectangle bounds, Color textColor, Color textBackgroundColor) {
        ShapeInfo siEchelon = null;
        int x = 0;
        int y = 0;
        boolean bufferY = true;
        double ratio = 3.5;
        int fontSize = 12;
        boolean scaleEchelon = RendererSettings.getInstance().getScaleEchelon();
        fontSize = RendererSettings.getInstance().getLabelFontSize();
        if (scaleEchelon) {
            fontSize = (int)Math.round(bounds.getWidth() / ratio);
        }
        try {
            String echelonText;
            if (echelon != null && !echelon.equals("") && !(echelonText = this.GetEchelonText(echelon)).equals("")) {
                TextLayout text = new TextLayout(echelonText, new Font("Arial", 1, fontSize), frc);
                Float descent = Float.valueOf(text.getDescent());
                Rectangle labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                x = bounds.x + bounds.width / 2 - labelBounds.width / 2;
                y = bounds.y - descent.intValue();
                if (RendererSettings.getInstance().getTextBackgroundMethod() == 2) {
                    y -= RendererSettings.getInstance().getTextOutlineWidth() / 2;
                } else if (RendererSettings.getInstance().getTextBackgroundMethod() == 3) {
                    y -= RendererSettings.getInstance().getTextOutlineWidth();
                } else if (RendererSettings.getInstance().getTextBackgroundMethod() == 1) {
                    --y;
                }
                siEchelon = SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)echelonText, (double)x, (double)y, (Color)textColor, (Color)textBackgroundColor);
                siEchelon.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_ECHELON);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"CreateEchelonShapeInfo()", (Exception)exc);
        }
        return siEchelon;
    }

    private String GetEchelonText(String echelon) {
        char[] dots = new char[]{'\u2022', '\u2022', '\u2022'};
        String dot = new String(dots);
        String text = "";
        if (echelon.equals("A")) {
            text = String.valueOf('\u00d8');
        } else if (echelon.equals("B")) {
            text = dot.substring(0, 1);
        } else if (echelon.equals("C")) {
            text = dot.substring(0, 2);
        } else if (echelon.equals("D")) {
            text = dot;
        } else if (echelon.equals("E")) {
            text = "I ";
        } else if (echelon.equals("F")) {
            text = "I I  ";
        } else if (echelon.equals("G")) {
            text = "I I I ";
        } else if (echelon.equals("H")) {
            text = "X";
        } else if (echelon.equals("I")) {
            text = "XX";
        } else if (echelon.equals("J")) {
            text = "XXX";
        } else if (echelon.equals("K")) {
            text = "XXXX";
        } else if (echelon.equals("L")) {
            text = "XXXXX";
        } else if (echelon.equals("M")) {
            text = "XXXXXX";
        } else if (echelon.equals("N")) {
            text = "++";
        }
        return text;
    }

    private ShapeInfo CreateMobilityShapeInfo(String symbolID, Rectangle bounds) {
        Path2D.Double shapeMobility = new Path2D.Double();
        ShapeInfo siMobility = null;
        BasicStroke stroke = new BasicStroke(2.0f);
        String mobility = "";
        double x = 0.0;
        double y = 0.0;
        double centerX = 0.0;
        double bottomY = 0.0;
        double height = 0.0;
        double width = 0.0;
        double middleY = 0.0;
        double wheelOffset = 1.0;
        double wheelSize = 5.0;
        double rrHeight = 5.0;
        double rrArcWidth = 8.0;
        if (symbolID != null && !symbolID.equals("") && bounds != null && !bounds.isEmpty()) {
            mobility = symbolID.substring(10, 12);
            x = bounds.getX();
            y = bounds.getY();
            height = bounds.getHeight();
            width = bounds.getWidth() - 1.0;
            bottomY = y + height + 1.0;
            wheelSize = width / 7.0;
            rrHeight = width / 7.0;
            if (mobility.equals("MO")) {
                shapeMobility.append(new Line2D.Double(x, bottomY, x + width, bottomY), false);
                shapeMobility.append(new Ellipse2D.Double(x, bottomY + wheelOffset, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
            } else if (mobility.equals("MP")) {
                shapeMobility.append(new Line2D.Double(x, bottomY, x + width, bottomY), false);
                shapeMobility.append(new Ellipse2D.Double(x, bottomY + wheelOffset, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x + width / 2.0 - wheelSize / 2.0, bottomY + wheelOffset, wheelSize, wheelSize), false);
            } else if (mobility.equals("MQ")) {
                shapeMobility.append(new RoundRectangle2D.Double(x, bottomY, width, rrHeight, rrArcWidth, rrHeight), false);
            } else if (mobility.equals("MR")) {
                shapeMobility.append(new RoundRectangle2D.Double(x, bottomY, width, rrHeight, rrArcWidth, rrHeight), false);
                shapeMobility.append(new Ellipse2D.Double(x - wheelSize - wheelSize, bottomY, wheelSize, wheelSize), false);
            } else if (mobility.equals("MS")) {
                shapeMobility.append(new Line2D.Double(x + wheelSize, bottomY + wheelSize / 2.0, x + width - wheelSize, bottomY + wheelSize / 2.0), false);
                shapeMobility.append(new Ellipse2D.Double(x, bottomY, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x + width - wheelSize, bottomY, wheelSize, wheelSize), false);
            } else if (mobility.equals("MT")) {
                shapeMobility.append(new Line2D.Double(x, bottomY, x + width, bottomY), false);
                shapeMobility.append(new Ellipse2D.Double(x + wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x, bottomY + wheelOffset, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
                shapeMobility.append(new Ellipse2D.Double(x + width - wheelSize - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize), false);
            } else if (mobility.equals("MU")) {
                ((Path2D)shapeMobility).moveTo(x, bottomY);
                ((Path2D)shapeMobility).lineTo(x + 5.0, bottomY + 5.0);
                ((Path2D)shapeMobility).lineTo(x + width, bottomY + 5.0);
            } else if (mobility.equals("MV")) {
                ((Path2D)shapeMobility).moveTo(x, bottomY);
                ((Path2D)shapeMobility).curveTo(x, bottomY, x - rrArcWidth, bottomY + 3.0, x, bottomY + rrHeight);
                ((Path2D)shapeMobility).lineTo(x + width, bottomY + rrHeight);
                ((Path2D)shapeMobility).curveTo(x + width, bottomY + rrHeight, x + width + rrArcWidth, bottomY + 3.0, x + width, bottomY);
            } else if (mobility.equals("MW")) {
                centerX = bounds.getCenterX();
                ((Path2D)shapeMobility).moveTo(centerX, bottomY + rrHeight + 2.0);
                ((Path2D)shapeMobility).lineTo(centerX - 3.0, bottomY);
                ((Path2D)shapeMobility).lineTo(centerX - 6.0, bottomY + rrHeight + 2.0);
                ((Path2D)shapeMobility).moveTo(centerX, bottomY + rrHeight + 2.0);
                ((Path2D)shapeMobility).lineTo(centerX + 3.0, bottomY);
                ((Path2D)shapeMobility).lineTo(centerX + 6.0, bottomY + rrHeight + 2.0);
            } else if (mobility.equals("MX")) {
                centerX = bounds.getCenterX();
                double quarterX = (centerX - x) / 2.0;
                double quarterY = (bottomY + rrHeight - bottomY) / 2.0;
                ((Path2D)shapeMobility).moveTo(x + width, bottomY);
                ((Path2D)shapeMobility).lineTo(x, bottomY);
                ((Path2D)shapeMobility).curveTo(x + quarterX, bottomY + rrHeight, centerX + quarterX, bottomY + rrHeight, x + width, bottomY);
            } else if (mobility.equals("MY")) {
                double incrementX = width / 7.0;
                middleY = (bottomY + rrHeight - bottomY) / 2.0;
                shapeMobility.append(new Arc2D.Double(x, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                shapeMobility.append(new Arc2D.Double(x + incrementX, bottomY + middleY, incrementX, rrHeight, 0.0, -180.0, 0), false);
                shapeMobility.append(new Arc2D.Double(x + incrementX * 2.0, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                shapeMobility.append(new Arc2D.Double(x + incrementX * 3.0, bottomY + middleY, incrementX, rrHeight, 0.0, -180.0, 0), false);
                shapeMobility.append(new Arc2D.Double(x + incrementX * 4.0, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
                shapeMobility.append(new Arc2D.Double(x + incrementX * 5.0, bottomY + middleY, incrementX, rrHeight, 0.0, -180.0, 0), false);
                shapeMobility.append(new Arc2D.Double(x + incrementX * 6.0, bottomY + middleY, incrementX, rrHeight, 0.0, 180.0, 0), false);
            }
            siMobility = new ShapeInfo((Shape)shapeMobility);
            siMobility.setLineColor(Color.BLACK);
            siMobility.setStroke((Stroke)stroke);
            siMobility.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
        }
        return siMobility;
    }

    private ArrayList<ShapeInfo> CreateTowedSonarArrayShapeInfo(String symbolID, Rectangle bounds) {
        ArrayList<ShapeInfo> returnVal = new ArrayList<ShapeInfo>();
        Path2D.Double shapeLines = new Path2D.Double();
        Path2D.Double shapeSquares = new Path2D.Double();
        ShapeInfo siLine = null;
        ShapeInfo siSquares = null;
        BasicStroke stroke = new BasicStroke(1.0f);
        String mobility = "";
        double x = 0.0;
        double y = 0.0;
        double centerX = 0.0;
        double bottomY = 0.0;
        double height = 0.0;
        double width = 0.0;
        double middleY = 0.0;
        double wheelOffset = 1.0;
        double wheelSize = 5.0;
        double rrHeight = 5.0;
        double rrArcWidth = 8.0;
        if (symbolID != null && !symbolID.equals("") && bounds != null && !bounds.isEmpty()) {
            double squareOffset;
            mobility = symbolID.substring(10, 12);
            x = bounds.getX();
            y = bounds.getY();
            height = bounds.getHeight();
            width = bounds.getWidth();
            bottomY = y + height + 1.0;
            if (mobility.equals("NS")) {
                centerX = bounds.getCenterX();
                squareOffset = wheelSize / 2.0;
                middleY = (bottomY + rrHeight - bottomY) / 2.0 + bottomY;
                shapeLines.append(new Line2D.Double(centerX, bottomY - 2.0, centerX, bottomY + rrHeight + 1.0), false);
                shapeLines.append(new Line2D.Double(x, middleY, x + width, middleY), false);
                shapeSquares.append(new Rectangle2D.Double(x - squareOffset, bottomY, 5.0, 5.0), false);
                shapeSquares.append(new Rectangle2D.Double(centerX - squareOffset, bottomY, 5.0, 5.0), false);
                shapeSquares.append(new Rectangle2D.Double(x + width - squareOffset, bottomY, 5.0, 5.0), false);
            }
            if (mobility.equals("NL")) {
                centerX = bounds.getCenterX();
                squareOffset = wheelSize / 2.0;
                middleY = (bottomY + rrHeight - bottomY) / 2.0 + bottomY;
                double leftX = x + (centerX - x) / 2.0;
                double rightX = centerX + (x + width - centerX) / 2.0;
                shapeLines.append(new Line2D.Double(leftX, bottomY - 2.0, leftX, bottomY + rrHeight + 1.0), false);
                shapeLines.append(new Line2D.Double(rightX, bottomY - 2.0, rightX, bottomY + rrHeight + 1.0), false);
                shapeLines.append(new Line2D.Double(x, middleY, x + width, middleY), false);
                shapeSquares.append(new Rectangle2D.Double(x - squareOffset, bottomY, 5.0, 5.0), false);
                shapeSquares.append(new Rectangle2D.Double(centerX - squareOffset, bottomY, 5.0, 5.0), false);
                shapeSquares.append(new Rectangle2D.Double(x + width - squareOffset, bottomY, 5.0, 5.0), false);
                shapeSquares.append(new Rectangle2D.Double(leftX - squareOffset, bottomY, 5.0, 5.0), false);
                shapeSquares.append(new Rectangle2D.Double(rightX - squareOffset, bottomY, 5.0, 5.0), false);
            }
            siLine = new ShapeInfo((Shape)shapeLines);
            siLine.setLineColor(Color.BLACK);
            siLine.setStroke((Stroke)stroke);
            siLine.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
            siSquares = new ShapeInfo((Shape)shapeSquares);
            siSquares.setFillColor(Color.BLACK);
            siSquares.setShapeType(ShapeInfo.SHAPE_TYPE_UNIT_DISPLAY_MODIFIER);
            returnVal.add(siLine);
            returnVal.add(siSquares);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessSPSymbol(MilStdSymbol symbol, IPointConversion converter) {
        try {
            String dom;
            Object odom;
            String val;
            FontRenderContext fontRenderContext = this._fontRenderContext;
            int tgRenderMethod = RendererSettings.getInstance().getSymbolRenderMethod();
            int symStd = symbol.getSymbologyStandard();
            double pixelSize = symbol.getUnitSize();
            double scale = symbol.getScale();
            int charIndex = SinglePointLookup.getInstance().getCharCodeFromSymbol(symbol.getSymbolID(), symStd);
            int fillIndex = -1;
            String fillID = null;
            if (SymbolUtilities.isTGSPWithFill((String)symbol.getSymbolID())) {
                fillID = SymbolUtilities.getTGFillSymbolCode((String)symbol.getSymbolID());
                if (fillID != null) {
                    fillIndex = SinglePointLookup.getInstance().getCharCodeFromSymbol(fillID, symStd);
                }
            } else if (SymbolUtilities.isWeatherSPWithFill((String)symbol.getSymbolID())) {
                fillIndex = charIndex + 1;
                symbol.setFillColor(SymbolUtilities.getFillColorOfWeather((String)symbol.getSymbolID()));
            }
            FontRenderContext frc = fontRenderContext;
            char[] frameSymbol = new char[]{(char)charIndex};
            char[] fillSymbol = null;
            GlyphVector gvFrame = null;
            GlyphVector gvFill = null;
            double ratio = 0.0;
            Object object = this._SinglePointFontMutex;
            synchronized (object) {
                if (pixelSize > 0.0) {
                    Rectangle foo = null;
                    gvFrame = _SinglePointFont.createGlyphVector(frc, frameSymbol);
                    foo = gvFrame.getPixelBounds(frc, 0.0f, 0.0f);
                    if (symbol.getKeepUnitRatio().booleanValue() && scale <= 0.0) {
                        scale = _SinglePointFont.getSize2D() == 80.0f ? pixelSize / 35.0 : (_SinglePointFont.getSize2D() == 60.0f ? pixelSize / 35.0 : (_SinglePointFont.getSize2D() == 100.0f ? pixelSize / 35.0 : (_SinglePointFont.getSize2D() == 120.0f ? pixelSize / 35.0 : pixelSize / 35.0)));
                    }
                    ratio = Math.min(pixelSize / foo.getHeight(), pixelSize / foo.getWidth());
                }
                if (gvFrame == null) {
                    gvFrame = _SinglePointFont.createGlyphVector(frc, frameSymbol);
                }
                if (fillIndex > 0) {
                    fillSymbol = new char[]{(char)fillIndex};
                    gvFill = _SinglePointFont.createGlyphVector(frc, fillSymbol);
                }
                if (scale > 0.0) {
                    ratio = scale;
                }
            }
            if (ratio > 0.0) {
                if (gvFill != null) {
                    gvFill.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
                if (gvFrame != null) {
                    gvFrame.setGlyphTransform(0, AffineTransform.getScaleInstance(ratio, ratio));
                }
            }
            ArrayList coords = symbol.getCoordinates();
            Point2D.Double location = (Point2D.Double)coords.get(0);
            Point2D pixel = converter.GeoToPixels((Point2D)location);
            Shape shapeFill = null;
            Shape shapeFrame = null;
            if (tgRenderMethod == 0) {
                if (gvFill != null) {
                    shapeFill = gvFill.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
                }
                shapeFrame = gvFrame.getGlyphOutline(0, (int)pixel.getX(), (int)pixel.getY());
            }
            ShapeInfo siFill = null;
            ShapeInfo siFrame = null;
            float strokeWidth = 0.0f;
            strokeWidth = 0.5f;
            if (tgRenderMethod == 0) {
                if (shapeFill != null) {
                    siFill = new ShapeInfo(shapeFill);
                    siFill.setFillColor(symbol.getFillColor());
                    siFill.setStroke((Stroke)new BasicStroke(strokeWidth, 1, 1, 3.0f));
                    siFill.setGlyphPosition(pixel);
                }
                siFrame = new ShapeInfo(shapeFrame);
                siFrame.setFillColor(symbol.getLineColor());
                siFrame.setStroke((Stroke)new BasicStroke(strokeWidth, 1, 1, 3.0f));
                siFrame.setGlyphPosition(pixel);
            } else if (tgRenderMethod == 1) {
                if (gvFill != null && symbol.getFillColor() != null) {
                    siFill = new ShapeInfo(gvFill, pixel);
                    siFill.setLineColor(symbol.getFillColor());
                    siFill.setStroke((Stroke)new BasicStroke(strokeWidth, 1, 1, 3.0f));
                    siFill.setModifierString(String.valueOf(fillSymbol));
                    siFill.setModifierStringPosition(pixel);
                }
                siFrame = new ShapeInfo(gvFrame, pixel);
                siFrame.setLineColor(symbol.getLineColor());
                siFrame.setStroke((Stroke)new BasicStroke(strokeWidth, 1, 1, 3.0f));
                siFrame.setModifierString(String.valueOf(frameSymbol));
                siFrame.setModifierStringPosition(pixel);
            }
            ArrayList<ShapeInfo> shapes = new ArrayList<ShapeInfo>();
            if (siFill != null) {
                siFill.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_FILL);
                shapes.add(siFill);
            }
            siFrame.setShapeType(ShapeInfo.SHAPE_TYPE_TG_SP_FRAME);
            shapes.add(siFrame);
            if (symbol.getOutlineEnabled()) {
                ArrayList symbolOutlines = SymbolDraw.createSinglePointOutline((ShapeInfo)siFrame, (int)symbol.getOutlineWidth(), (Color)symbol.getOutlineColor());
                if (siFill != null) {
                    shapes.addAll(1, symbolOutlines);
                } else {
                    shapes.addAll(0, symbolOutlines);
                }
            }
            symbol.setSymbolShapes(shapes);
            Map modifiers = symbol.getModifierMap();
            boolean drawAsIcon = false;
            if (modifiers != null && modifiers.containsKey("ICON") && (val = String.valueOf(modifiers.get("ICON"))) != null & val.equalsIgnoreCase("true")) {
                drawAsIcon = true;
            }
            if (!drawAsIcon && (modifiers != null && modifiers.size() > 0 || SymbolUtilities.isTGSPWithIntegralText((String)symbol.getSymbolID()))) {
                ArrayList<ShapeInfo> modifiersShapes = this.ProcessSinglePointModifiers(symbol);
                symbol.setModifierShapes(modifiersShapes);
            }
            if (symbol.getRotation() != 0.0) {
                this.RotateShapeInfo(symbol.getSymbolShapes(), symbol.getRotation(), pixel.getX(), pixel.getY());
                this.RotateShapeInfo(symbol.getModifierShapes(), symbol.getRotation(), pixel.getX(), pixel.getY());
            }
            if ((odom = modifiers.get("Q")) != null && (dom = String.valueOf(odom)) != null && !dom.equals("") && SymbolUtilities.isNumber((String)dom) && SymbolUtilities.hasDirectionOfMovement((String)symbol.getSymbolID(), (int)symStd)) {
                Rectangle bounds = new Rectangle(symbol.getSymbolExtent());
                if (modifiers.containsKey("Y")) {
                    Rectangle adjustedBounds = new Rectangle(symbol.getSymbolExtentFull());
                    bounds.setRect(bounds.getX(), adjustedBounds.getY(), bounds.getWidth(), adjustedBounds.getHeight() + 2.0);
                }
                double angle = Double.valueOf(dom);
                ArrayList<ShapeInfo> arrow = this.CreateDOMArrow(symbol.getSymbolID(), bounds, angle);
                if (arrow != null && arrow.size() > 0) {
                    shapes.addAll(arrow);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)("ProcessSPSymbol(" + symbol.getSymbolID() + ")"), (Exception)exc);
        }
    }

    private ArrayList<ShapeInfo> ProcessSinglePointModifiers(MilStdSymbol symbol) {
        Color textColor = null;
        Color textBackgroundColor = null;
        String validModifiers = "";
        SymbolDef sDef = null;
        ArrayList<ShapeInfo> modifierShapes = null;
        int symStd = symbol.getSymbologyStandard();
        sDef = SymbolDefTable.getInstance().getSymbolDef(SymbolUtilities.getBasicSymbolID((String)symbol.getSymbolID()), symStd);
        if (sDef != null) {
            validModifiers = sDef.getModifiers();
        }
        textColor = symbol.getTextColor() != null ? symbol.getTextColor() : (this._RendererSettings.getLabelForegroundColor() != null ? this._RendererSettings.getLabelForegroundColor() : (SymbolUtilities.isTacticalGraphic((String)symbol.getSymbolID()) && symbol.getLineColor() != null ? symbol.getLineColor() : Color.BLACK));
        if (symbol.getTextBackgroundColor() != null) {
            textBackgroundColor = symbol.getTextBackgroundColor();
        }
        Rectangle symbolBounds = symbol.getSymbolExtent();
        if (symbol.getOutlineEnabled()) {
            symbolBounds.grow(symbol.getOutlineWidth(), symbol.getOutlineWidth());
        }
        modifierShapes = SinglePointRenderer.ProcessSPTGModifiers(symbol.getSymbolID(), validModifiers, symbol.getModifierMap(), symbolBounds, this._fontRenderContext, _ModifierFont, textColor, textBackgroundColor, symStd);
        return modifierShapes;
    }

    private static ArrayList<ShapeInfo> ProcessSPTGModifiers(String milStdCode, String validModifiers, Map<String, String> modifiers, Rectangle bounds, FontRenderContext frc, Font labelFont, Color textColor, Color textBackgroundColor, int symStd) {
        ArrayList modifierShapes = null;
        String modifierValue = null;
        String modifierString = null;
        ArrayList<ShapeInfo> alTemp = null;
        ArrayList<ShapeInfo> alTemp2 = null;
        try {
            alTemp = new ArrayList<ShapeInfo>();
            modifierShapes = new ArrayList();
            if (SymbolUtilities.isTGSPWithIntegralText((String)milStdCode)) {
                alTemp.addAll(SinglePointRenderer.CreateTGSPIntegralText(milStdCode, bounds, frc, labelFont, textColor, textBackgroundColor, symStd));
            }
            if (validModifiers != null && !validModifiers.equals("") && modifiers != null && modifiers.size() > 0) {
                if (_ModifierNamesTG == null) {
                    _ModifierNamesTG = ModifiersTG.GetModifierList();
                }
                String modifierName = "";
                int modifierCount = _ModifierNamesTG.size();
                boolean specialLayout = SymbolUtilities.isTGSPWithSpecialModifierLayout((String)milStdCode);
                for (int lcv = 0; lcv < modifierCount; ++lcv) {
                    modifierName = _ModifierNamesTG.get(lcv);
                    if (modifierName == null || validModifiers.indexOf(modifierName + ".") == -1 || (modifierValue = modifiers.get(modifierName)) == null) continue;
                    if (modifierValue instanceof String) {
                        modifierString = modifierValue.toString();
                    }
                    if (modifierString == null || modifierString.equals("") || (alTemp2 = specialLayout ? SinglePointRenderer.GetSPTGSpecialModifierShape(milStdCode, modifierString, modifierName, frc, labelFont, bounds, textColor, textBackgroundColor) : SinglePointRenderer.GetSPTGModifierShape(milStdCode, modifierString, modifierName, frc, labelFont, bounds, textColor, textBackgroundColor)) == null || alTemp2.size() <= 0) continue;
                    alTemp.addAll(alTemp2);
                }
            }
            modifierShapes = SymbolDraw.ProcessModifierBackgrounds(alTemp);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ProcessSPTGModifiers()", (Exception)new RendererException("Failed to build single point TG for " + milStdCode, (Throwable)exc));
        }
        return modifierShapes;
    }

    private static ArrayList<ShapeInfo> GetSPTGModifierShape(String symbolID, String modifierValue, String modifierName, FontRenderContext frc, Font labelFont, Rectangle bounds, Color TextColor, Color textBackgroundColor) {
        double bufferXL = 6.0;
        double bufferXR = 4.0;
        double bufferY = 2.0;
        double bufferText = 2.0;
        double x = 0.0;
        double y = 0.0;
        ArrayList<ShapeInfo> alTemp = null;
        int labelHeight = 0;
        int labelWidth = 0;
        Boolean byLabelHeight = false;
        try {
            if (modifierValue != null && !modifierValue.equals("")) {
                TextLayout text = new TextLayout(modifierValue, labelFont, frc);
                TextLayout testText = new TextLayout("TQgj", labelFont, frc);
                Float descent = Float.valueOf(text.getDescent());
                Rectangle labelBounds = testText.getPixelBounds(null, 0.0f, 0.0f);
                labelHeight = labelBounds.height;
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                labelWidth = labelBounds.width;
                double maxHeight = bounds.height / 3 * 2;
                if ((double)(labelHeight * 3) > maxHeight) {
                    byLabelHeight = true;
                }
                String basicID = SymbolUtilities.getBasicSymbolID((String)symbolID);
                if (modifierName.equals("N")) {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    if (!byLabelHeight.booleanValue()) {
                        y = labelHeight + bounds.height / 3 * 2;
                        y = (double)bounds.y + y;
                    } else {
                        y = ((double)labelHeight + bufferText) * 3.0;
                        y = (double)bounds.y + y;
                    }
                } else if (modifierName.equals("H")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (float)bounds.y - descent.floatValue();
                } else if (modifierName.equals("H1") && basicID.equals("G*G*GPP---****X")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (double)(bounds.y + labelHeight) + (double)bounds.height * 0.2;
                } else if (modifierName.equals("W")) {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    y = bounds.y + labelHeight;
                } else if (modifierName.equals("W1")) {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    if (!byLabelHeight.booleanValue()) {
                        y = bounds.height / 3 * 2;
                        y = y * 0.5 + (double)labelHeight * 0.5;
                        y = (double)bounds.y + y;
                    } else {
                        y = ((double)labelHeight + bufferText) * 2.0;
                        y = (double)bounds.y + y;
                    }
                } else if (modifierName.equals("T")) {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    y = bounds.y + labelHeight;
                } else if (modifierName.equals("T1") && (basicID.equals("G*O*ES----****X") || basicID.equals("G*S*PP----****X") || basicID.equals("G*S*PX----****X"))) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (double)bounds.height * 0.64;
                    y = (double)bounds.y + y;
                } else {
                    return null;
                }
                ShapeInfo si = null;
                si = SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)textBackgroundColor);
                alTemp = new ArrayList<ShapeInfo>(1);
                alTemp.add(si);
                return alTemp;
            }
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"JavaRenderer", (String)"GetSPTGModifierShape()", (Exception)exc);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<ShapeInfo> GetSPTGSpecialModifierShape(String symbolID, String modifierValue, String modifierName, FontRenderContext frc, Font labelFont, Rectangle bounds, Color textColor, Color textBackgroundColor) {
        double bufferXL = 6.0;
        double bufferXR = 4.0;
        double bufferY = 2.0;
        double bufferText = 2.0;
        double x = 0.0;
        double y = 0.0;
        boolean duplicate = false;
        double x2 = 0.0;
        double y2 = 0.0;
        int labelHeight = 0;
        int labelWidth = 0;
        Boolean byLabelHeight = false;
        try {
            if (modifierValue == null || modifierValue.equals("")) return null;
            String basicSymbolID = SymbolUtilities.getBasicSymbolID((String)symbolID);
            TextLayout text = new TextLayout(modifierValue, labelFont, frc);
            TextLayout testText = new TextLayout("TQgj", labelFont, frc);
            Float descent = Float.valueOf(text.getDescent());
            Rectangle labelBounds = testText.getPixelBounds(null, 0.0f, 0.0f);
            labelHeight = labelBounds.height;
            labelBounds = text.getPixelBounds(frc, 0.0f, 0.0f);
            labelWidth = labelBounds.width;
            if ((basicSymbolID.equals("G*M*NZ----****X") || basicSymbolID.equals("G*M*NEB---****X") || basicSymbolID.equals("G*M*NEC---****X")) && (double)(labelHeight * 3) > bounds.getHeight()) {
                byLabelHeight = true;
            }
            if (basicSymbolID.equals("G*G*GPH---****X") || basicSymbolID.equals("G*G*GPPC--****X") || basicSymbolID.equals("G*G*GPPD--****X")) {
                x = (double)bounds.x + (double)bounds.width * 0.5;
                x -= (double)labelWidth * 0.5;
                y = (double)bounds.y + (double)bounds.height * 0.5;
                y += (double)labelHeight * 0.5;
            } else if (basicSymbolID.equals("G*G*GPRI--****X")) {
                x = (double)bounds.x + (double)bounds.width * 0.5;
                x -= (double)labelWidth * 0.5;
                y = (double)bounds.y + (double)bounds.height * 0.25;
                y += (double)labelHeight * 0.5;
            } else if (basicSymbolID.equals("G*G*GPPW--****X") || basicSymbolID.equals("G*F*PCF---****X")) {
                x = (double)bounds.x + (double)bounds.width * 0.75;
                y = (double)bounds.y + (double)bounds.height * 0.5;
                y += (double)labelHeight * 0.5;
            } else if (basicSymbolID.equals("G*G*APP---****X") || basicSymbolID.equals("G*G*APC---****X")) {
                x = (double)bounds.x + (double)bounds.width * 0.5;
                x -= (double)labelWidth * 0.5;
                y = (double)bounds.y + (double)bounds.height * 0.5;
                y += (double)labelHeight * 1.25;
            } else if (basicSymbolID.equals("G*G*DPT---****X") || basicSymbolID.equals("G*F*PTS---****X") || basicSymbolID.equals("G*F*PTN---****X")) {
                if (modifierName.equals("H") && basicSymbolID.equals("G*F*PTS---****X")) {
                    x = (double)bounds.x + (double)bounds.width * 0.75;
                    y = (double)bounds.y + (double)bounds.height * 0.75;
                    y += (double)labelHeight * 0.5;
                } else if (modifierName.equals("H1") && basicSymbolID.equals("G*F*PTS---****X")) {
                    x = (double)bounds.x + (double)bounds.width * 0.25;
                    x -= (double)labelWidth;
                    y = (double)bounds.y + (double)bounds.height * 0.75;
                    y += (double)labelHeight * 0.5;
                } else {
                    if (!modifierName.equals("T")) return null;
                    x = (double)bounds.x + (double)bounds.width * 0.75;
                    y = (double)bounds.y + (double)bounds.height * 0.25;
                    y += (double)labelHeight * 0.5;
                }
            } else if (basicSymbolID.equals("G*M*NZ----****X") || basicSymbolID.equals("G*M*NEB---****X") || basicSymbolID.equals("G*M*NEC---****X")) {
                if (modifierName.equals("N")) {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    if (!byLabelHeight.booleanValue()) {
                        y = bounds.y + bounds.height;
                    } else {
                        y = ((double)labelHeight + bufferText) * 3.0;
                        y = (double)bounds.y + y;
                    }
                } else if (modifierName.equals("H")) {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    y = (float)(bounds.y + labelHeight) - descent.floatValue();
                } else if (modifierName.equals("W")) {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    y = (float)(bounds.y + labelHeight) - descent.floatValue();
                } else if (modifierName.equals("V")) {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    y = !byLabelHeight.booleanValue() ? (double)bounds.y + ((double)bounds.height * 0.5 + (double)labelHeight * 0.5) : (double)bounds.y + ((double)labelHeight + bufferText) * 2.0;
                } else if (modifierName.equals("T")) {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    if (!byLabelHeight.booleanValue()) {
                        y = bounds.y + bounds.height;
                    } else {
                        y = ((double)labelHeight + bufferText) * 3.0;
                        y = (double)bounds.y + y;
                    }
                } else if (modifierName.equals("Y")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    if (!byLabelHeight.booleanValue()) {
                        y = (double)(bounds.y + bounds.height + labelHeight) + bufferY;
                    } else {
                        y = ((double)labelHeight + bufferText) * 4.0;
                        y = (double)bounds.y + y;
                    }
                } else {
                    if (!modifierName.equals("C")) return null;
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (float)bounds.y - descent.floatValue();
                }
            } else if (basicSymbolID.equals("G*M*OFS---****X")) {
                if (modifierName.equals("H")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (float)bounds.y - descent.floatValue();
                } else if (modifierName.equals("W")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = bounds.y + bounds.height;
                    y = y + (double)labelHeight + (double)descent.floatValue();
                } else if (modifierName.equals("N")) {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    duplicate = true;
                    x2 = bounds.x;
                    x2 = x2 - (double)labelWidth - bufferXL;
                    y = (double)bounds.y + (double)bounds.height * 0.5;
                    y2 = y += (double)labelHeight * 0.5;
                }
            } else {
                if (basicSymbolID.charAt(0) != 'W' || !modifierName.equals("X")) return null;
                String strText = modifierValue;
                if (basicSymbolID.equals("WAS-WSF-LVP----")) {
                    strText = "0\u00b0:" + modifierValue;
                    text = new TextLayout(strText, labelFont, frc);
                    labelBounds = text.getPixelBounds(frc, 0.0f, 0.0f);
                    labelWidth = labelBounds.width;
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (double)bounds.y + (double)bounds.height * 0.5;
                    y += (double)labelHeight * 0.5;
                } else if (basicSymbolID.equals("WAS-WST-LVP----")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (double)bounds.y + (double)bounds.height * 0.5;
                    y += (double)labelHeight * 0.5;
                } else if (basicSymbolID.equals("WAS-PLT---P----")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (double)bounds.y + (double)bounds.height * 0.5;
                    y -= (double)descent.floatValue();
                } else if (basicSymbolID.equals("WAS-PHT---P----")) {
                    x = (double)bounds.x + (double)bounds.width * 0.5;
                    x -= (double)labelWidth * 0.5;
                    y = (double)bounds.y + (double)bounds.height * 0.5;
                    y += (double)labelHeight;
                }
            }
            ShapeInfo si = null;
            si = SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)textColor, (Color)textBackgroundColor);
            ArrayList<ShapeInfo> siList = new ArrayList<ShapeInfo>(1);
            siList.add(si);
            if (!duplicate) return siList;
            ShapeInfo si2 = null;
            si2 = SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x2, (double)y2, (Color)textColor, (Color)textBackgroundColor);
            siList.add(si2);
            return siList;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"JavaRenderer", (String)"GetSPTGModifierShape()", (Exception)exc);
            return null;
        }
    }

    private void RotateShapeInfo(ArrayList<ShapeInfo> shapes, double angle, double anchorX, double anchorY) {
        try {
            double radians = Math.toRadians(angle);
            AffineTransform at = AffineTransform.getRotateInstance(radians, anchorX, anchorY);
            ShapeInfo siTemp = null;
            if (shapes != null) {
                int shapeSize = shapes.size();
                for (int i = 0; i < shapeSize; ++i) {
                    siTemp = shapes.get(i);
                    if (siTemp.getAffineTransform() != null) {
                        siTemp.getAffineTransform().rotate(radians, anchorX, anchorY);
                        continue;
                    }
                    siTemp.setAffineTransform(at);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"JavaRenderer", (String)"RotateShapeInfo()", (Exception)exc);
        }
    }

    private ArrayList<ShapeInfo> CreateDOMArrow(String symbolCode, Rectangle bounds, double angle) {
        ArrayList<ShapeInfo> returnVal = new ArrayList<ShapeInfo>();
        Path2D.Double line = new Path2D.Double();
        Polygon arrowHead = null;
        double length = 40.0;
        char affiliation = symbolCode.charAt(1);
        length = SymbolUtilities.isNBC((String)symbolCode) ? (double)(bounds.height / 2) : (SymbolUtilities.isHQ((String)symbolCode) && !(affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' || affiliation == 'N' || affiliation == 'L') ? (double)Math.round(bounds.getHeight() * 0.7) : (double)bounds.height);
        double x1 = bounds.getCenterX();
        double y1 = bounds.getCenterY();
        line.moveTo(x1, y1);
        char scheme = symbolCode.charAt(0);
        if (SymbolUtilities.isNBC((String)symbolCode) || scheme == 'S' && symbolCode.substring(2, 3).equals("G") || scheme == 'O' || scheme == 'E') {
            if (!SymbolUtilities.isHQ((String)symbolCode)) {
                y1 = bounds.getY() + bounds.getHeight();
                line.moveTo(x1, y1);
                line.lineTo(x1, y1 += length);
            } else {
                x1 = bounds.getX() + 1.0;
                if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' || affiliation == 'N' || affiliation == 'L') {
                    y1 = bounds.getY() + bounds.getHeight();
                    line.moveTo(x1, y1);
                    line.lineTo(x1, y1 += length);
                } else {
                    y1 = bounds.getY() + bounds.getHeight() / 2.0;
                    line.moveTo(x1, y1);
                    line.lineTo(x1, y1 += bounds.getHeight());
                }
            }
        }
        double radians = 0.0;
        radians = Math.toRadians(angle -= 90.0);
        double dx2 = x1 + length * Math.cos(radians);
        double dy2 = y1 + length * Math.sin(radians);
        double x2 = (int)dx2;
        double y2 = (int)dy2;
        float arrowWidth = 8.0f;
        float theta = 0.423f;
        theta = 0.7f;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        float[] vecLine = new float[2];
        float[] vecLeft = new float[2];
        xPoints[0] = (int)x2;
        yPoints[0] = (int)y2;
        vecLine[0] = (float)((double)xPoints[0] - x1);
        vecLine[1] = (float)((double)yPoints[0] - y1);
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        float fLength = (float)Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        float th = arrowWidth / (2.0f * fLength);
        float ta = arrowWidth / (2.0f * ((float)Math.tan(theta) / 2.0f) * fLength);
        float baseX = (float)xPoints[0] - ta * vecLine[0];
        float baseY = (float)yPoints[0] - ta * vecLine[1];
        xPoints[1] = (int)(baseX + th * vecLeft[0]);
        yPoints[1] = (int)(baseY + th * vecLeft[1]);
        xPoints[2] = (int)(baseX - th * vecLeft[0]);
        yPoints[2] = (int)(baseY - th * vecLeft[1]);
        line.lineTo((int)baseX, (int)baseY);
        arrowHead = new Polygon(xPoints, yPoints, 3);
        ShapeInfo siLine = new ShapeInfo((Shape)line);
        siLine.setLineColor(Color.BLACK);
        siLine.setStroke((Stroke)new BasicStroke(2.0f));
        ShapeInfo siArrowHead = new ShapeInfo((Shape)arrowHead);
        siArrowHead.setFillColor(Color.BLACK);
        if (SymbolUtilities.isTacticalGraphic((String)symbolCode)) {
            siLine.setShapeType(ShapeInfo.SHAPE_TYPE_TG_Q_MODIFIER);
            siArrowHead.setShapeType(ShapeInfo.SHAPE_TYPE_TG_Q_MODIFIER);
        }
        returnVal.add(siLine);
        returnVal.add(siArrowHead);
        return returnVal;
    }

    private static ArrayList<ShapeInfo> GetUnitModifierShape(String symbolID, Map<String, String> modifiers, FontRenderContext frc, Font labelFont, Rectangle bounds, Rectangle echelonBounds, Rectangle affiliationBounds, Color TextColor, Color TextBackgroundColor) {
        double bufferXL = 5.0;
        double bufferXR = 5.0;
        double bufferY = 2.0;
        double bufferText = 2.0;
        double x = 0.0;
        double y = 0.0;
        double cpofNameX = 0.0;
        ArrayList<Object> alTemp = new ArrayList<ShapeInfo>();
        int labelHeight = 0;
        int labelWidth = 0;
        Boolean byLabelHeight = false;
        TextLayout text = null;
        try {
            if (echelonBounds != null && echelonBounds.getWidth() > bounds.getWidth()) {
                bounds.setRect(echelonBounds.getX(), bounds.getY(), echelonBounds.getWidth(), bounds.getHeight());
            }
            TextLayout testText = new TextLayout("TQgj", labelFont, frc);
            Float descent = Float.valueOf(testText.getDescent());
            Rectangle labelBounds = testText.getPixelBounds(null, 0.0f, 0.0f);
            labelHeight = labelBounds.height;
            labelWidth = labelBounds.width;
            double maxHeight = bounds.height;
            if ((double)(labelHeight * 3) > maxHeight) {
                byLabelHeight = true;
            }
            alTemp = new ArrayList();
            Iterator<String> itr = modifiers.keySet().iterator();
            String modifierName = "";
            String modifierValue = "";
            if (SymbolUtilities.hasValidCountryCode((String)symbolID).booleanValue()) {
                modifiers.put("CC", symbolID.substring(12, 14));
            }
            cpofNameX = (double)(bounds.x + bounds.width) + bufferXR;
            if (modifiers.containsKey("X") || modifiers.containsKey("Y")) {
                String xm = modifiers.get("X");
                String ym = modifiers.get("Y");
                if (xm == null && ym != null) {
                    modifierValue = ym;
                } else if (xm != null && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"X")) {
                    modifierValue = ym == null ? xm : xm + " " + ym;
                }
                text = new TextLayout(modifierValue, labelFont, frc);
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                if (!byLabelHeight.booleanValue()) {
                    x = (double)(bounds.x - labelBounds.width) - bufferXL;
                    y = bounds.y + labelHeight;
                } else {
                    x = (double)(bounds.x - labelBounds.width) - bufferXL;
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y -= (double)labelHeight + bufferText;
                    y = (double)bounds.y + y;
                }
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("G") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"G")) {
                modifierValue = modifiers.get("G");
                text = new TextLayout(modifierValue, labelFont, frc);
                if (!byLabelHeight.booleanValue()) {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    y = bounds.y + labelHeight;
                } else {
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y -= (double)labelHeight + bufferText;
                    y = (double)bounds.y + y;
                }
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                if (x + text.getBounds().getWidth() + 3.0 > cpofNameX) {
                    cpofNameX = x + text.getBounds().getWidth() + 3.0;
                }
            }
            if (modifiers.containsKey("V") || modifiers.containsKey("AD") || modifiers.containsKey("AE")) {
                String vm = null;
                String adm = null;
                String aem = null;
                if (modifiers.containsKey("V") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"V")) {
                    vm = modifiers.get("V");
                }
                if (modifiers.containsKey("AD") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"AD")) {
                    adm = modifiers.get("AD");
                }
                if (modifiers.containsKey("AE") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"AE")) {
                    aem = modifiers.get("AE");
                }
                modifierValue = "";
                if (vm != null && !vm.equals("")) {
                    modifierValue = vm;
                }
                if (adm != null && !adm.equals("")) {
                    modifierValue = modifierValue + " " + adm;
                }
                if (aem != null && !aem.equals("")) {
                    modifierValue = modifierValue + " " + aem;
                }
                if (!(modifierValue = modifierValue.trim()).equals("")) {
                    text = new TextLayout(modifierValue, labelFont, frc);
                    labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                    x = (double)(bounds.x - labelBounds.width) - bufferXL;
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y = (double)bounds.y + y;
                    alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                }
            }
            if (modifiers.containsKey("H") || modifiers.containsKey("AF")) {
                modifierValue = "";
                String hm = "";
                String afm = "";
                hm = modifiers.get("H");
                if (modifiers.containsKey("H")) {
                    hm = modifiers.get("H");
                }
                if (modifiers.containsKey("AF") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"AF")) {
                    afm = modifiers.get("AF");
                }
                modifierValue = hm + " " + afm;
                if (!(modifierValue = modifierValue.trim()).equals("")) {
                    text = new TextLayout(modifierValue, labelFont, frc);
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y = (double)bounds.y + y;
                    alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                    if (x + text.getBounds().getWidth() + 3.0 > cpofNameX) {
                        cpofNameX = x + text.getBounds().getWidth() + 3.0;
                    }
                }
            }
            if (modifiers.containsKey("T")) {
                modifierValue = modifiers.get("T");
                text = new TextLayout(modifierValue, labelFont, frc);
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                labelWidth = labelBounds.width;
                x = (double)(bounds.x - labelWidth) - bufferXL;
                if (!byLabelHeight.booleanValue()) {
                    y = bounds.y + bounds.height;
                } else {
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y += (double)labelHeight + bufferText;
                    y = (double)bounds.y + y;
                }
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("M") || modifiers.containsKey("CC")) {
                modifierValue = "";
                String mValue = "";
                if (SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"M")) {
                    mValue = modifiers.get("M");
                }
                String ccValue = modifiers.get("CC");
                if (mValue != null) {
                    modifierValue = modifierValue + mValue;
                }
                if (ccValue != null) {
                    if (mValue != null && !mValue.equals("")) {
                        modifierValue = modifierValue + " ";
                    }
                    modifierValue = modifierValue + ccValue;
                }
                if (!modifierValue.equals("")) {
                    text = new TextLayout(modifierValue, labelFont, frc);
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    if (!byLabelHeight.booleanValue()) {
                        y = bounds.y + bounds.height;
                    } else {
                        y = bounds.height;
                        y = y * 0.5 + (double)labelHeight * 0.5;
                        y += (double)labelHeight + bufferText;
                        y = (double)bounds.y + y;
                    }
                    alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                    if (x + text.getBounds().getWidth() + 3.0 > cpofNameX) {
                        cpofNameX = x + text.getBounds().getWidth() + 3.0;
                    }
                }
            }
            if (modifiers.containsKey("Z") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"Z")) {
                modifierValue = modifiers.get("Z");
                text = new TextLayout(modifierValue, labelFont, frc);
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                labelWidth = labelBounds.width;
                x = (double)(bounds.x - labelWidth) - bufferXL;
                if (!byLabelHeight.booleanValue()) {
                    y = (double)(bounds.y + bounds.height + labelHeight) + bufferText;
                } else {
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y += ((double)labelHeight + bufferText) * 2.0;
                    y = (double)bounds.y + y;
                }
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("J") || modifiers.containsKey("K") || modifiers.containsKey("L") || modifiers.containsKey("N") || modifiers.containsKey("P")) {
                String jm = null;
                String km = null;
                String lm = null;
                String nm = null;
                String pm = null;
                if (modifiers.containsKey("J")) {
                    jm = modifiers.get("J");
                }
                if (modifiers.containsKey("K") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"K")) {
                    km = modifiers.get("K");
                }
                if (modifiers.containsKey("L") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"L")) {
                    lm = modifiers.get("L");
                }
                if (modifiers.containsKey("N") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"N")) {
                    nm = modifiers.get("N");
                }
                if (modifiers.containsKey("P") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"P")) {
                    pm = modifiers.get("P");
                }
                modifierValue = "";
                if (jm != null && !jm.equals("")) {
                    modifierValue = modifierValue + jm;
                }
                if (km != null && !km.equals("")) {
                    modifierValue = modifierValue + " " + km;
                }
                if (lm != null && !lm.equals("")) {
                    modifierValue = modifierValue + " " + lm;
                }
                if (nm != null && !nm.equals("")) {
                    modifierValue = modifierValue + " " + nm;
                }
                if (pm != null && !pm.equals("")) {
                    modifierValue = modifierValue + " " + pm;
                }
                if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                    modifierValue = modifierValue.substring(1);
                }
                if (!(modifierValue = modifierValue.trim()).equals("")) {
                    text = new TextLayout(modifierValue, labelFont, frc);
                    labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                    labelWidth = labelBounds.width;
                    x = (double)(bounds.x + bounds.width) + bufferXR;
                    if (!byLabelHeight.booleanValue()) {
                        y = (double)(bounds.y + bounds.height + labelHeight) + bufferText;
                    } else {
                        y = bounds.height;
                        y = y * 0.5 + (double)labelHeight * 0.5;
                        y += ((double)labelHeight + bufferText) * 2.0;
                        y = (double)bounds.y + y;
                    }
                    alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                    if (x + text.getBounds().getWidth() + 3.0 > cpofNameX) {
                        cpofNameX = x + text.getBounds().getWidth() + 3.0;
                    }
                }
            }
            if (modifiers.containsKey("W")) {
                modifierValue = modifiers.get("W");
                text = new TextLayout(modifierValue, labelFont, frc);
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                labelWidth = labelBounds.width;
                if (!byLabelHeight.booleanValue()) {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    y = (double)bounds.y - bufferY - (double)descent.floatValue();
                } else {
                    x = (double)(bounds.x - labelWidth) - bufferXL;
                    y = bounds.height;
                    y = y * 0.5 + (double)labelHeight * 0.5;
                    y -= ((double)labelHeight + bufferText) * 2.0;
                    y = (double)bounds.y + y;
                }
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("F") || modifiers.containsKey("E")) {
                modifierValue = null;
                String E = modifiers.get("E");
                String F = "";
                if (E != null && !E.equals("")) {
                    modifierValue = E;
                }
                if (SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"F")) {
                    F = modifiers.get("F");
                }
                if (F != null && !F.equals("")) {
                    F = F.toUpperCase().equals("R") ? "(+)" : (F.toUpperCase().equals("D") ? "(-)" : (F.toUpperCase().equals("RD") ? "(\u00b1)" : null));
                }
                if (F != null && !F.equals("")) {
                    modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + F : F;
                }
                if (modifierValue != null && !modifierValue.equals("")) {
                    text = new TextLayout(modifierValue, labelFont, frc);
                    if (!byLabelHeight.booleanValue()) {
                        x = affiliationBounds != null ? (double)(affiliationBounds.x + affiliationBounds.width) + bufferXR : (double)(bounds.x + bounds.width) + bufferXR;
                        y = (double)bounds.y - bufferY - (double)descent.floatValue();
                    } else {
                        x = affiliationBounds != null ? (double)(affiliationBounds.x + affiliationBounds.width) + bufferXR : (double)(bounds.x + bounds.width) + bufferXR;
                        y = bounds.height;
                        y = y * 0.5 + (double)labelHeight * 0.5;
                        y -= ((double)labelHeight + bufferText) * 2.0;
                        y = (double)bounds.y + y;
                    }
                    alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                    if (x + text.getBounds().getWidth() + 3.0 > cpofNameX) {
                        cpofNameX = x + text.getBounds().getWidth() + 3.0;
                    }
                }
            }
            if (modifiers.containsKey("C") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"C")) {
                modifierValue = modifiers.get("C");
                text = new TextLayout(modifierValue, labelFont, frc);
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                labelWidth = labelBounds.width;
                x = (double)bounds.x + (double)bounds.width * 0.5 - (double)labelWidth * 0.5;
                y = (double)bounds.y - bufferY - (double)descent.floatValue();
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("AA") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"AA")) {
                modifierValue = modifiers.get("AA");
                text = new TextLayout(modifierValue, labelFont, frc);
                labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                labelWidth = labelBounds.width;
                x = (double)bounds.x + (double)bounds.width * 0.5 - (double)labelWidth * 0.5;
                y = bounds.height;
                y = y * 0.5 + (double)labelHeight * 0.5;
                y = (double)bounds.y + y;
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("CN")) {
                modifierValue = modifiers.get("CN");
                text = new TextLayout(modifierValue, labelFont, frc);
                x = cpofNameX;
                y = bounds.height;
                y = y * 0.5 + (double)labelHeight * 0.5;
                y = (double)bounds.y + y;
                alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
            }
            if (modifiers.containsKey("SCC") && SymbolUtilities.canUnitHaveModifier((String)symbolID, (String)"SCC")) {
                modifierValue = modifiers.get("SCC");
                int scc = 0;
                if (SymbolUtilities.isNumber((String)modifierValue) && SymbolUtilities.hasModifier((String)symbolID, (String)"SCC").booleanValue() && (scc = Integer.valueOf(modifierValue).intValue()) > 0 && scc < 6) {
                    double yPosition = SinglePointRenderer.getYPositionForSCC(symbolID);
                    text = new TextLayout(modifierValue, labelFont, frc);
                    labelBounds = text.getPixelBounds(null, 0.0f, 0.0f);
                    labelWidth = labelBounds.width;
                    x = (double)bounds.x + (double)bounds.width * 0.5 - (double)labelWidth * 0.5;
                    y = bounds.height;
                    y = y * yPosition + (double)((float)labelHeight - descent.floatValue()) * 0.5;
                    y = (double)bounds.y + y;
                    alTemp.add(SymbolDraw.CreateModifierShapeInfo((TextLayout)text, (String)modifierValue, (double)x, (double)y, (Color)TextColor, (Color)TextBackgroundColor));
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"JavaRenderer", (String)"GetUnitModifierShape", (Exception)exc);
        }
        return alTemp;
    }

    private static double getYPositionForSCC(String symbolID) {
        double yPosition = 0.32;
        String temp = symbolID.substring(4, 10);
        char affiliation = symbolID.charAt(1);
        if (temp.equals("WMGC--")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.29 : (affiliation == 'N' || affiliation == 'L' ? 0.32 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.32 : 0.34));
        } else if (temp.equals("WMMC--")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.29 : (affiliation == 'N' || affiliation == 'L' ? 0.32 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.32 : 0.34));
        } else if (temp.equals("WMFC--")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.29 : (affiliation == 'N' || affiliation == 'L' ? 0.32 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.32 : 0.34));
        } else if (temp.equals("WMC---")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.35 : (affiliation == 'N' || affiliation == 'L' ? 0.39 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.39 : 0.39));
        }
        return yPosition;
    }

    private static ArrayList<ShapeInfo> CreateTGSPIntegralText(String SymbolID, Rectangle2D symbolBounds, FontRenderContext frc, Font labelFont, Color textColor, Color textBackgroundColor, int symStd) {
        double bufferXL = 6.0;
        double bufferXR = 4.0;
        double bufferY = 2.0;
        double bufferText = 2.0;
        double centerOffset = 1.0;
        double x = 0.0;
        double y = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int labelHeight = 0;
        boolean labelWidth = false;
        String basicID = SymbolUtilities.getBasicSymbolID((String)SymbolID);
        TextLayout text1 = null;
        TextLayout text2 = null;
        TextLayout testText = null;
        Object gvText1 = null;
        Object gvText2 = null;
        Float descent = Float.valueOf(0.0f);
        Rectangle labelBounds1 = null;
        Rectangle labelBounds2 = null;
        Boolean byLabelHeight = false;
        double ratio = 0.0;
        double pixelSize = 0.0;
        ArrayList<Object> returnVal = null;
        String strText1 = "";
        String strText2 = "";
        try {
            returnVal = new ArrayList<ShapeInfo>();
            if (basicID.equals("G*G*GPRD--****X")) {
                strText1 = "D";
                text1 = new TextLayout(strText1, labelFont, frc);
                descent = Float.valueOf(text1.getDescent());
                labelBounds1 = text1.getPixelBounds(null, 0.0f, 0.0f);
                if (symStd == 0) {
                    y = symbolBounds.getY() + symbolBounds.getHeight();
                    x = symbolBounds.getX() - labelBounds1.getWidth() - bufferXL;
                } else {
                    text1 = null;
                }
            } else if (basicID.equals("G*G*APU---****X")) {
                strText1 = "PUP";
                text1 = new TextLayout(strText1, labelFont, frc);
                descent = Float.valueOf(text1.getDescent());
                labelBounds1 = text1.getPixelBounds(null, 0.0f, 0.0f);
                y = symbolBounds.getY() + symbolBounds.getHeight() / 2.0 + (double)(text1.getAscent() / 2.0f);
                x = symbolBounds.getX() + symbolBounds.getWidth() + bufferXR;
            } else if (!basicID.equals("G*M*NZ----****X") && !basicID.equals("G*M*NF----****X")) {
                if (basicID.equals("G*M*NEB---****X")) {
                    testText = new TextLayout("TQgj", labelFont, frc);
                    labelHeight = (int)testText.getBounds().getHeight();
                    if ((double)(labelHeight * 3) > symbolBounds.getHeight()) {
                        byLabelHeight = true;
                    }
                    strText2 = "BIO";
                    text2 = new TextLayout(strText2, labelFont, frc);
                    labelBounds2 = text2.getPixelBounds(null, 0.0f, 0.0f);
                    y2 = byLabelHeight == false ? symbolBounds.getCenterY() + labelBounds2.getHeight() / 2.0 : symbolBounds.getY() + ((double)labelHeight + bufferText) * 2.0;
                    x2 = symbolBounds.getX() - labelBounds2.getWidth() - bufferXL;
                } else if (basicID.equals("G*M*NEC---****X")) {
                    testText = new TextLayout("TQgj", labelFont, frc);
                    labelHeight = (int)testText.getBounds().getHeight();
                    if ((double)(labelHeight * 3) > symbolBounds.getHeight()) {
                        byLabelHeight = true;
                    }
                    strText2 = "CML";
                    text2 = new TextLayout(strText2, labelFont, frc);
                    labelBounds2 = text2.getPixelBounds(null, 0.0f, 0.0f);
                    y2 = byLabelHeight == false ? symbolBounds.getCenterY() + labelBounds2.getHeight() / 2.0 : symbolBounds.getY() + ((double)labelHeight + bufferText) * 2.0;
                    x2 = symbolBounds.getX() - labelBounds2.getWidth() - bufferXL;
                }
            }
            returnVal = new ArrayList();
            if (text1 != null) {
                ShapeInfo si1 = null;
                si1 = SymbolDraw.CreateModifierShapeInfo((TextLayout)text1, (String)strText1, (double)x, (double)y, (Color)textColor, (Color)textBackgroundColor);
                returnVal.add(si1);
            }
            if (text2 != null) {
                ShapeInfo si2 = null;
                si2 = SymbolDraw.CreateModifierShapeInfo(text2, (String)strText2, (double)x2, (double)y2, (Color)textColor, (Color)textBackgroundColor);
                returnVal.add(si2);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"JavaRenderer", (String)"CreateTGSPIntegralText()", (Exception)exc);
        }
        return returnVal;
    }

    public int getSinglePointTGSymbolSize() {
        return _SinglePointFont.getSize();
    }

    public int getUnitSymbolSize() {
        return _UnitFont.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSinglePointTGSymbolSize(int size) {
        Object object = this._SinglePointFontMutex;
        synchronized (object) {
            _SinglePointFont = SinglePointFont.getInstance().getSPFont((float)size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnitSymbolSize(int size) {
        Object object = this._UnitFontMutex;
        synchronized (object) {
            _UnitFont = SinglePointFont.getInstance().getUnitFont((float)size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RefreshModifierFont() {
        Object object = this._ModifierFontMutex;
        synchronized (object) {
            _ModifierFont = RendererSettings.getInstance().getLabelFont();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModifierFont(String name, int type, int size) {
        Object object = this._ModifierFontMutex;
        synchronized (object) {
            _ModifierFont = RendererSettings.getInstance().getLabelFont();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModifierFont(Font font) {
        Object object = this._ModifierFontMutex;
        synchronized (object) {
            _ModifierFont = RendererSettings.getInstance().getLabelFont();
        }
    }

    private static String PrintList(ArrayList list) {
        String message = "";
        for (Object item : list) {
            message = message + item.toString() + "\n";
        }
        return message;
    }

    private static String PrintObjectMap(Map<String, Object> map) {
        Iterator<Object> itr = map.values().iterator();
        String message = "";
        String temp = null;
        while (itr.hasNext()) {
            temp = String.valueOf(itr.next());
            if (temp == null) continue;
            message = message + temp + "\n";
        }
        return message;
    }

    private static void PrintStringMap(Map<String, String> map) {
        Iterator<String> itr = map.values().iterator();
        String message = "";
        String temp = null;
        while (itr.hasNext()) {
            temp = String.valueOf(itr.next());
            if (temp == null) continue;
            message = message + temp + "\n";
        }
        ErrorLogger.LogMessage((String)message);
    }
}

