/*
 * Decompiled with CFR 0.152.
 */
package RenderMultipoints;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaLineArray.lineutility;
import JavaLineArray.ref;
import JavaTacticalRenderer.TGLight;
import JavaTacticalRenderer.clsMETOC;
import JavaTacticalRenderer.mdlGeodesic;
import RenderMultipoints.clsClipPolygon2;
import RenderMultipoints.clsClipQuad;
import RenderMultipoints.clsUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class clsUtilityCPOF {
    private static final String _className = "clsUtilityCPOF";

    private static ShapeInfo BuildDummyShapeSpec() {
        ShapeInfo shape = new ShapeInfo(null);
        try {
            AffineTransform tx = new AffineTransform();
            tx.setToIdentity();
            GeneralPath gp = new GeneralPath();
            shape.setLineColor(Color.WHITE);
            shape.setFillColor(null);
            shape.setStroke((Stroke)new BasicStroke());
            shape.setTexturePaint(null);
            gp.moveTo(-1000.0f, -1000.0f);
            gp.lineTo(-1001.0f, -1001.0f);
            shape.setShape((Shape)gp);
            shape.setAffineTransform(tx);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"BuidDummyShapeSpec", (Exception)new RendererException("Failed inside BuildDummyShapeSpec", (Throwable)exc));
        }
        return shape;
    }

    private static boolean isValidShapeSpec(ShapeInfo shape) {
        if (shape == null) {
            return false;
        }
        if (shape.getLineColor() == null && shape.getFillColor() == null) {
            return false;
        }
        if (shape.getShape() == null) {
            return false;
        }
        if (shape.getStroke() == null) {
            return false;
        }
        return shape.getAffineTransform() != null;
    }

    protected static void SetLCColor(TGLight tg, Shape2 shape) {
        try {
            String affiliation = tg.get_Affiliation();
            if (affiliation.equals("H")) {
                if (shape.getLineColor() == Color.RED) {
                    shape.setLineColor(tg.get_LineColor());
                } else {
                    shape.setLineColor(Color.RED);
                }
            } else if (shape.getLineColor() != Color.RED) {
                shape.setLineColor(tg.get_LineColor());
            } else {
                shape.setLineColor(Color.RED);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"SetLCColor", (Exception)new RendererException("Failed inside SetLCColor", (Throwable)exc));
        }
    }

    protected static ShapeInfo[] ValidateShapeSpecs(ShapeInfo[] originalShapes, Rectangle2D clipRect) {
        ShapeInfo[] shapes = null;
        try {
            ShapeInfo shape = null;
            if (originalShapes == null || originalShapes.length == 0) {
                shapes = new ShapeInfo[]{};
            } else {
                int j = 0;
                ArrayList<ShapeInfo> newShapes = new ArrayList<ShapeInfo>();
                for (j = 0; j < originalShapes.length; ++j) {
                    shape = originalShapes[j];
                    if (!clsUtilityCPOF.isValidShapeSpec(shape)) continue;
                    newShapes.add(shape);
                }
                if (newShapes.size() > 0) {
                    shapes = new ShapeInfo[newShapes.size()];
                    shapes = newShapes.toArray(shapes);
                } else {
                    shape = clsUtilityCPOF.BuildDummyShapeSpec();
                    shapes = new ShapeInfo[]{shape};
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ValidateShapeSpecs", (Exception)new RendererException("Failed inside ValidateShapeSpecs", (Throwable)exc));
        }
        return shapes;
    }

    private static POINT2 PointLatLongToPixels(POINT2 ptLatLong, IPointConversion converter) {
        POINT2 pt = new POINT2();
        try {
            double x = ptLatLong.x;
            double y = ptLatLong.y;
            Point2D ptPixels = converter.GeoToPixels((Point2D)new Point2D.Double(x, y));
            pt.x = ptPixels.getX();
            pt.y = ptPixels.getY();
            pt.style = ptLatLong.style;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"PointLatLongToPixels", (Exception)new RendererException("Failed inside PointLatLongToPixels", (Throwable)exc));
        }
        return pt;
    }

    private static POINT2 PointPixelsToLatLong(POINT2 ptPixels, IPointConversion converter) {
        POINT2 pt = new POINT2();
        try {
            double x = ptPixels.x;
            double y = ptPixels.y;
            Point2D ptGeo = converter.PixelsToGeo((Point2D)new Point2D.Double(x, y));
            pt.x = ptGeo.getX();
            pt.y = ptGeo.getY();
            pt.style = ptPixels.style;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"PointPixelsToLatLong", (Exception)new RendererException("Failed inside PointPixelsToLatLong", (Throwable)exc));
        }
        return pt;
    }

    private static void SetNumericFields(TGLight tg, int lineType, String radius, String width, String length, String attitude) {
        try {
            switch (lineType) {
                case 15000002: 
                case 24312000: 
                case 24321300: 
                case 24322300: 
                case 24323300: 
                case 24324300: 
                case 24325300: 
                case 24326200: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: {
                    tg.set_T1(radius);
                    break;
                }
                case 14000001: 
                case 14000002: 
                case 24311000: {
                    tg.set_T1(length);
                    tg.set_H(width);
                    tg.set_H2(attitude);
                    break;
                }
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326101: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    tg.set_T1(width);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"SetNumericFields", (Exception)new RendererException("Failed inside SetNumericFields", (Throwable)exc));
        }
    }

    private static void GetNumericFields(TGLight tg, int lineType, ref<double[]> radius, ref<double[]> width, ref<double[]> length, ref<double[]> attitude) {
        try {
            if (lineType == 243111001) {
                return;
            }
            double dist = 0.0;
            ref a12 = new ref();
            ref a21 = new ref();
            POINT2 pt0 = new POINT2(0.0, 0.0);
            POINT2 pt1 = new POINT2(0.0, 0.0);
            radius.value = new double[1];
            width.value = new double[1];
            attitude.value = new double[1];
            length.value = new double[1];
            switch (lineType) {
                case 15000002: 
                case 24312000: 
                case 24321300: 
                case 24322300: 
                case 24323300: 
                case 24324300: 
                case 24325300: 
                case 24326200: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: {
                    if (!SymbolUtilities.isNumber((String)tg.get_T1())) break;
                    ((double[])radius.value)[0] = Double.parseDouble(tg.get_T1());
                    break;
                }
                case 25200101: {
                    if (SymbolUtilities.isNumber((String)tg.get_T1())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_T1());
                    }
                    if (SymbolUtilities.isNumber((String)tg.get_H())) {
                        ((double[])width.value)[0] = Double.parseDouble(tg.get_H());
                    }
                    if (!SymbolUtilities.isNumber((String)tg.get_H2())) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_H2());
                    break;
                }
                case 14000001: 
                case 14000002: 
                case 24311000: {
                    if (SymbolUtilities.isNumber((String)tg.get_T1())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_T1());
                    }
                    if (SymbolUtilities.isNumber((String)tg.get_H())) {
                        ((double[])width.value)[0] = Double.parseDouble(tg.get_H());
                    }
                    if (SymbolUtilities.isNumber((String)tg.get_H1())) {
                        ((double[])radius.value)[0] = Double.parseDouble(tg.get_H1());
                    }
                    if (!SymbolUtilities.isNumber((String)tg.get_H2())) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_H2()) * 0.05625;
                    if (tg.getSymbologyStandard() != 1) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_H2());
                    break;
                }
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326101: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    if (tg.LatLongs.size() >= 2 && tg.LatLongs.size() >= 2) {
                        pt0 = (POINT2)tg.LatLongs.get(0);
                        pt1 = (POINT2)tg.LatLongs.get(1);
                        dist = mdlGeodesic.geodesic_distance((POINT2)pt0, (POINT2)pt1, (ref)a12, (ref)a21);
                        ((double[])attitude.value)[0] = ((double[])a12.value)[0];
                    }
                    if (!SymbolUtilities.isNumber((String)tg.get_T1())) break;
                    ((double[])width.value)[0] = Double.parseDouble(tg.get_T1());
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetNumericFields", (Exception)new RendererException("Failed inside GetNumericFields", (Throwable)exc));
        }
    }

    protected static void TransformPixels(TGLight tg, Rectangle2D clipBounds) {
        try {
            double top = clipBounds.getMaxY();
            double bottom = clipBounds.getMinY();
            AffineTransform xfm = null;
            Point2D.Double pt2d = null;
            int j = 0;
            POINT2 pt2 = null;
            for (j = 0; j < tg.Pixels.size(); ++j) {
                xfm = AffineTransform.getScaleInstance(1.0, -1.0);
                pt2 = (POINT2)tg.Pixels.get(j);
                pt2d = new Point2D.Double(pt2.x, pt2.y);
                xfm.translate(0.0, -top - bottom);
                xfm.transform(pt2d, pt2d);
                pt2 = new POINT2(((Point2D)pt2d).getX(), ((Point2D)pt2d).getY());
                tg.Pixels.set(j, pt2);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"TransformPixels", (Exception)new RendererException("Failed inside TransformPixels", (Throwable)exc));
        }
    }

    protected static void GetFarPixels(TGLight tg, IPointConversion converter, ArrayList farLeftPixels, ArrayList farRightPixels) {
        try {
            if (farLeftPixels == null || farRightPixels == null) {
                return;
            }
            Point2D ptPixels50 = converter.GeoToPixels((Point2D)new Point2D.Double(50.0, 30.0));
            Point2D ptPixels60 = converter.GeoToPixels((Point2D)new Point2D.Double(60.0, 30.0));
            double degLonPerPixel = 10.0 / Math.abs(ptPixels60.getX() - ptPixels50.getX());
            int j = 0;
            double minX = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            for (j = 0; j < tg.Pixels.size(); ++j) {
                if (((POINT2)tg.Pixels.get((int)j)).x < minX) {
                    minX = ((POINT2)tg.Pixels.get((int)j)).x;
                }
                if (!(((POINT2)tg.Pixels.get((int)j)).x > maxX)) continue;
                maxX = ((POINT2)tg.Pixels.get((int)j)).x;
            }
            double degWidth = (maxX - minX) * degLonPerPixel;
            if (Math.abs(degWidth) < 180.0) {
                return;
            }
            double midX = Math.abs(180.0 / degLonPerPixel);
            double x = 0.0;
            double y = 0.0;
            for (j = 0; j < tg.Pixels.size(); ++j) {
                x = ((POINT2)tg.Pixels.get((int)j)).x;
                y = ((POINT2)tg.Pixels.get((int)j)).y;
                if (x > midX) {
                    x -= 2.0 * midX;
                }
                farLeftPixels.add(new POINT2(x, y));
            }
            for (j = 0; j < tg.Pixels.size(); ++j) {
                x = ((POINT2)tg.Pixels.get((int)j)).x;
                y = ((POINT2)tg.Pixels.get((int)j)).y;
                if (x < midX) {
                    x += 2.0 * midX;
                }
                farRightPixels.add(new POINT2(x, y));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetFarPixels", (Exception)new RendererException("Failed inside GetFarPixels", (Throwable)exc));
        }
    }

    protected static boolean Change1TacticalAreas(TGLight tg, int lineType, IPointConversion converter, ArrayList<Shape2> shapes) {
        try {
            ref width = new ref();
            ref length = new ref();
            ref attitude = new ref();
            ref radius = new ref();
            int j = 0;
            POINT2 pt0 = (POINT2)tg.LatLongs.get(0);
            POINT2 pt1 = null;
            POINT2 ptTemp = new POINT2();
            POINT2 pt00 = new POINT2();
            pt1 = tg.LatLongs.size() > 1 ? (POINT2)tg.LatLongs.get(1) : (POINT2)tg.LatLongs.get(0);
            POINT2[] pPoints = null;
            POINT2 ptCenter = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
            clsUtilityCPOF.GetNumericFields(tg, lineType, (ref<double[]>)radius, (ref<double[]>)width, (ref<double[]>)length, (ref<double[]>)attitude);
            switch (lineType) {
                case 25200101: {
                    POINT2[] ellipsePts = mdlGeodesic.getGeoEllipse((POINT2)pt0, (double)((double[])width.value)[0], (double)((double[])length.value)[0], (double)((double[])attitude.value)[0]);
                    for (j = 0; j < ellipsePts.length; ++j) {
                        pt0 = ellipsePts[j];
                        pt1 = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
                        tg.Pixels.add(pt1);
                    }
                    break;
                }
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326101: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    pt00 = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] - 90.0));
                    pt00 = clsUtilityCPOF.PointLatLongToPixels(pt00, converter);
                    pt00.style = 0;
                    tg.Pixels.add(pt00);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 90.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt1, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 90.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt1, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] - 90.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    tg.Pixels.add(pt00);
                    break;
                }
                case 14000001: 
                case 14000002: 
                case 24311000: {
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(((double[])length.value)[0] / 2.0), (double)(((double[])attitude.value)[0] - 90.0));
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)ptTemp, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 0.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(((double[])length.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 90.0));
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)ptTemp, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 0.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(((double[])length.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 90.0));
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)ptTemp, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 180.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(((double[])length.value)[0] / 2.0), (double)(((double[])attitude.value)[0] - 90.0));
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)ptTemp, (double)(((double[])width.value)[0] / 2.0), (double)(((double[])attitude.value)[0] + 180.0));
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    tg.Pixels.add(new POINT2(((POINT2)tg.Pixels.get((int)0)).x, ((POINT2)tg.Pixels.get((int)0)).y));
                    break;
                }
                case 15000002: 
                case 24312000: 
                case 24321300: 
                case 24322300: 
                case 24323300: 
                case 24324300: 
                case 24325300: 
                case 24326200: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: {
                    pt0 = (POINT2)tg.LatLongs.get(0);
                    ptTemp = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)((double[])radius.value)[0], (double)90.0);
                    pPoints = new POINT2[]{new POINT2(pt0), new POINT2(ptTemp), new POINT2(ptTemp)};
                    ArrayList pPoints2 = mdlGeodesic.GetGeodesicArc((POINT2[])pPoints);
                    POINT2 ptTemp2 = null;
                    for (j = 0; j < pPoints2.size(); ++j) {
                        pt0 = (POINT2)pPoints2.get(j);
                        ptTemp2 = new POINT2();
                        ptTemp2 = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
                        tg.Pixels.add(ptTemp2);
                    }
                    break;
                }
                case 243111000: {
                    clsUtilityCPOF.GetConcentricCircles(tg, lineType, converter);
                    if (tg.LatLongs.size() <= 1) break;
                    clsUtilityCPOF.RangeFanOrientation(tg, lineType, converter);
                    break;
                }
                case 243112000: {
                    clsUtilityCPOF.GetSectorRangeFan(tg, converter);
                    clsUtilityCPOF.RangeFanOrientation(tg, lineType, converter);
                    break;
                }
                case 243111001: {
                    clsUtilityCPOF.GetSectorRangeFan(tg, converter);
                    break;
                }
                default: {
                    return false;
                }
            }
            ArrayList farLeftPixels = new ArrayList();
            ArrayList farRightPixels = new ArrayList();
            clsUtilityCPOF.GetFarPixels(tg, converter, farLeftPixels, farRightPixels);
            ArrayList<Shape2> shapesLeft = new ArrayList<Shape2>();
            ArrayList<Shape2> shapesRight = new ArrayList<Shape2>();
            if (farLeftPixels.isEmpty() || farRightPixels.isEmpty()) {
                ArrayList tempPixels = new ArrayList();
                tempPixels.addAll(tg.Pixels);
                clsUtilityCPOF.postSegmentFSA(tg, converter);
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapes, false);
                tg.Pixels = tempPixels;
            } else {
                tg.Pixels = farLeftPixels;
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapesLeft, false);
                tg.Pixels = farRightPixels;
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapesRight, false);
                shapes.addAll(shapesLeft);
                shapes.addAll(shapesRight);
            }
            if (lineType == 15000002) {
                Shape2 shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                shape.moveTo(ptCenter);
                ptCenter.y += 1.0;
                shape.lineTo(ptCenter);
                shapes.add(shape);
            }
            if (lineType == 14000001 || lineType == 14000002) {
                double dist = ((double[])radius.value)[0];
                pt0 = new POINT2((POINT2)tg.LatLongs.get(0));
                pt1 = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)dist, (double)45.0);
                Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                pt02d = converter.GeoToPixels(pt02d);
                pt12d = converter.GeoToPixels(pt12d);
                pt0.x = pt02d.getX();
                pt0.y = pt02d.getY();
                pt1.x = pt12d.getX();
                pt1.y = pt12d.getY();
                dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
                ArrayList tempPixels = new ArrayList();
                tempPixels.addAll(tg.Pixels);
                POINT2[] pts = tempPixels.toArray(new POINT2[tempPixels.size()]);
                pts[0].style = (int)dist;
                lineutility.getExteriorPoints((POINT2[])pts, (int)pts.length, (int)lineType, (boolean)false);
                tg.Pixels.clear();
                for (j = 0; j < pts.length; ++j) {
                    tg.Pixels.add(new POINT2(pts[j].x, pts[j].y));
                }
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapes, true);
                tg.Pixels = tempPixels;
            }
            return true;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"Change1TacticalAreas", (Exception)new RendererException("Failed inside Change1TacticalAreas", (Throwable)exc));
            return false;
        }
    }

    private static void Change1PixelsToShapes(TGLight tg, ArrayList<Shape2> shapes, boolean fill) {
        Shape2 shape = null;
        boolean beginLine = true;
        POINT2 currentPt = null;
        POINT2 lastPt = null;
        int k = 0;
        int linetype = tg.get_LineType();
        for (k = 0; k < tg.Pixels.size(); ++k) {
            if (shape == null) {
                if (!fill) {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                } else if (fill) {
                    shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                }
            }
            currentPt = (POINT2)tg.Pixels.get(k);
            if (k > 0) {
                lastPt = (POINT2)tg.Pixels.get(k - 1);
            }
            if (beginLine) {
                if (k == 0) {
                    shape.set_Style(currentPt.style);
                }
                if (k > 0 && currentPt.style == 5 && lastPt.style == 5) {
                    shape.lineTo(currentPt);
                }
                shape.moveTo(currentPt);
                beginLine = false;
            } else {
                shape.lineTo(currentPt);
                if (currentPt.style == 5 || currentPt.style == 10) {
                    beginLine = true;
                    if (linetype == 243111001 && k < tg.Pixels.size() - 1) {
                        shapes.add(shape);
                        shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    }
                }
            }
            if (k != tg.Pixels.size() - 1) continue;
            if (shape.getShapeType() == ShapeInfo.SHAPE_TYPE_FILL) {
                shapes.add(0, shape);
                continue;
            }
            shapes.add(shape);
        }
    }

    private static void GetConcentricCircles(TGLight tg, int lineType, IPointConversion converter) {
        try {
            int j = 0;
            int l = 0;
            double radius = 0.0;
            POINT2 pt = new POINT2();
            ArrayList pts = new ArrayList();
            double[] radii = null;
            String H2 = tg.get_H2();
            if (tg.LatLongs.size() == 1 && H2 != null) {
                String[] strs = H2.split(",");
                radii = new double[strs.length];
                for (j = 0; j < strs.length; ++j) {
                    radii[j] = Double.parseDouble(strs[j]);
                }
            }
            if (radii == null) {
                radii = JavaTacticalRenderer.clsUtility.GetRadii((TGLight)tg, (int)lineType);
            }
            int n = radii.length;
            POINT2[] pPoints = null;
            for (l = 0; l < n; ++l) {
                radius = radii[l];
                if (radius == 0.0) continue;
                pPoints = new POINT2[3];
                pt = (POINT2)tg.LatLongs.get(0);
                pPoints[0] = new POINT2(pt);
                pt = mdlGeodesic.geodesic_coordinate((POINT2)pt, (double)radius, (double)90.0);
                pPoints[1] = new POINT2(pt);
                pPoints[2] = new POINT2(pt);
                pts = mdlGeodesic.GetGeodesicArc((POINT2[])pPoints);
                POINT2 ptTemp2 = null;
                for (j = 0; j < pts.size(); ++j) {
                    ptTemp2 = new POINT2();
                    ptTemp2 = clsUtilityCPOF.PointLatLongToPixels((POINT2)pts.get(j), converter);
                    ptTemp2.style = 0;
                    if (j == pts.size() - 1) {
                        ptTemp2.style = 5;
                    }
                    tg.Pixels.add(ptTemp2);
                }
            }
            int length = tg.Pixels.size();
            ((POINT2)tg.Pixels.get((int)(length - 1))).style = 5;
            pPoints = null;
            pt = null;
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetConcentricCircles", (Exception)new RendererException("Failed inside GetConcentricCircles", (Throwable)exc));
            return;
        }
    }

    private static String GetMaxSector(TGLight tg) {
        String strLeftRightMinMax = null;
        try {
            double max = 0.0;
            double maxx = -1.7976931348623157E308;
            String H2 = tg.get_H2();
            String[] leftRightMinMax = H2.split(",");
            int numSectors = leftRightMinMax.length / 4;
            int k = 0;
            int maxIndex = -1;
            if (numSectors < 1) {
                return null;
            }
            if (numSectors * 4 != leftRightMinMax.length) {
                return null;
            }
            try {
                for (k = 0; k < numSectors; ++k) {
                    max = Double.parseDouble(leftRightMinMax[4 * k + 3]);
                    if (!(max > maxx)) continue;
                    maxx = max;
                    maxIndex = k;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            String strLeft = leftRightMinMax[4 * maxIndex];
            String strRight = leftRightMinMax[4 * maxIndex + 1];
            String strMin = leftRightMinMax[4 * maxIndex + 2];
            String strMax = leftRightMinMax[4 * maxIndex + 3];
            strLeftRightMinMax = strLeft + "," + strRight + "," + strMin + "," + strMax;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetMaxSector", (Exception)new RendererException("Failed inside GetMaxSector", (Throwable)exc));
        }
        return strLeftRightMinMax;
    }

    protected static TGLight GetCircularRangeFanFillTG(TGLight tg) {
        TGLight tg1 = null;
        try {
            tg1 = new TGLight();
            tg1.set_VisibleModifiers(true);
            tg1.set_LineThickness(0);
            tg1.set_FillColor(tg.get_FillColor());
            tg1.set_Fillstyle(tg.get_FillStyle());
            tg1.LatLongs = new ArrayList();
            tg1.Pixels = new ArrayList();
            tg1.LatLongs.add((POINT2)tg.LatLongs.get(0));
            tg1.Pixels.add((POINT2)tg.Pixels.get(0));
            tg1.Pixels.add((POINT2)tg.Pixels.get(1));
            tg1.set_LineType(243111001);
            String strH2 = tg.get_H2();
            if (tg.get_LineType() != 243111000) {
                tg1.set_H2(strH2);
                return tg1;
            }
            String[] H2 = strH2.split(",");
            String leftRightMinMax = "";
            int j = 0;
            for (j = 0; j < H2.length - 1; ++j) {
                if (j > 0) {
                    leftRightMinMax = leftRightMinMax + ",";
                }
                leftRightMinMax = leftRightMinMax + "0,0," + H2[j] + "," + H2[j + 1];
            }
            tg1.set_H2(leftRightMinMax);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetCircularRangeFanFillTG", (Exception)new RendererException("Failed inside GetCircularRangeFanFillTG", (Throwable)exc));
        }
        return tg1;
    }

    protected static void addCircularRangeFanFillShapesFromTG(ArrayList<Shape2> tgShapes, ArrayList<Shape2> fillShapes) {
        try {
            tgShapes.addAll(0, fillShapes);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"addCircularRangeFanFillShapesFromTG", (Exception)new RendererException("Failed inside addCircularRangeFanFillShapesFromTG", (Throwable)exc));
        }
    }

    private static boolean GetSectorRangeFan(TGLight tg, IPointConversion converter) {
        boolean circle = false;
        try {
            POINT2 ptCenter = (POINT2)tg.LatLongs.get(0);
            int k = 0;
            int l = 0;
            int numSectors = 0;
            JavaTacticalRenderer.clsUtility.GetSectorRadiiFromPoints((TGLight)tg);
            ArrayList<POINT2> pPoints = new ArrayList<POINT2>();
            ArrayList pPointsInnerArc = new ArrayList();
            ArrayList pPointsOuterArc = new ArrayList();
            ArrayList<POINT2> sectorPoints = new ArrayList<POINT2>();
            ArrayList<POINT2> allPoints = new ArrayList<POINT2>();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            String H2 = tg.get_H2();
            String[] leftRightMinMax = H2.split(",");
            double left = 0.0;
            double right = 0.0;
            double min = 0.0;
            double max = 0.0;
            numSectors = leftRightMinMax.length / 4;
            if (numSectors < 1) {
                return false;
            }
            if (numSectors * 4 != leftRightMinMax.length) {
                return false;
            }
            try {
                for (k = 0; k < numSectors; ++k) {
                    left = Double.parseDouble(leftRightMinMax[4 * k]);
                    right = Double.parseDouble(leftRightMinMax[4 * k + 1]);
                    min = Double.parseDouble(leftRightMinMax[4 * k + 2]);
                    max = Double.parseDouble(leftRightMinMax[4 * k + 3]);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            for (k = 0; k < numSectors; ++k) {
                sectorPoints.clear();
                pPointsOuterArc.clear();
                pPointsInnerArc.clear();
                left = Double.parseDouble(leftRightMinMax[4 * k]);
                right = Double.parseDouble(leftRightMinMax[4 * k + 1]);
                min = Double.parseDouble(leftRightMinMax[4 * k + 2]);
                max = Double.parseDouble(leftRightMinMax[4 * k + 3]);
                pt1 = mdlGeodesic.geodesic_coordinate((POINT2)ptCenter, (double)min, (double)left);
                pt2 = mdlGeodesic.geodesic_coordinate((POINT2)ptCenter, (double)min, (double)right);
                pPoints.clear();
                pPoints.add(ptCenter);
                pPoints.add(pt1);
                pPoints.add(pt2);
                circle = mdlGeodesic.GetGeodesicArc2(pPoints, pPointsInnerArc);
                pPoints.clear();
                circle = false;
                pt1 = mdlGeodesic.geodesic_coordinate((POINT2)ptCenter, (double)max, (double)left);
                pt2 = mdlGeodesic.geodesic_coordinate((POINT2)ptCenter, (double)max, (double)right);
                pPoints.add(ptCenter);
                pPoints.add(pt1);
                pPoints.add(pt2);
                circle = mdlGeodesic.GetGeodesicArc2(pPoints, pPointsOuterArc);
                for (l = 0; l < pPointsInnerArc.size(); ++l) {
                    pt1 = new POINT2((POINT2)pPointsInnerArc.get(l));
                    sectorPoints.add(pt1);
                }
                for (l = pPointsOuterArc.size() - 1; l >= 0; --l) {
                    pt1 = new POINT2((POINT2)pPointsOuterArc.get(l));
                    sectorPoints.add(pt1);
                }
                pt1 = new POINT2((POINT2)pPointsInnerArc.get(0));
                pt1.style = 5;
                sectorPoints.add(pt1);
                for (l = 0; l < sectorPoints.size(); ++l) {
                    allPoints.add((POINT2)sectorPoints.get(l));
                }
            }
            pPointsInnerArc = null;
            pPointsOuterArc = null;
            ptCenter = null;
            POINT2 ptTemp = null;
            for (l = 0; l < allPoints.size(); ++l) {
                pt1 = new POINT2();
                pt1 = clsUtilityCPOF.PointLatLongToPixels((POINT2)allPoints.get(l), converter);
                if (ptTemp != null && pt1.x == ptTemp.x && pt1.y == ptTemp.y) continue;
                tg.Pixels.add(new POINT2(pt1));
                ptTemp = new POINT2(pt1);
            }
            return true;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetSectorRangeFan", (Exception)new RendererException("Failed inside GetSectorRangeFan", (Throwable)exc));
            return circle;
        }
    }

    private static void RangeFanOrientation(TGLight tg, int lineType, IPointConversion converter) {
        try {
            POINT2 pt0 = (POINT2)tg.LatLongs.get(0);
            double dist = 0.0;
            double orientation = 0.0;
            double radius = 0.0;
            boolean j = false;
            POINT2 pt1 = new POINT2();
            ref a12 = new ref();
            ref a21 = new ref();
            if (tg.LatLongs.size() > 1) {
                pt1 = (POINT2)tg.LatLongs.get(1);
                dist = mdlGeodesic.geodesic_distance((POINT2)pt0, (POINT2)pt1, (ref)a12, (ref)a21);
                orientation = ((double[])a12.value)[0];
            } else {
                double left;
                String strLeftRightMinMax = clsUtilityCPOF.GetMaxSector(tg);
                String[] sector = strLeftRightMinMax.split(",");
                double right = Double.parseDouble(sector[1]);
                double min = Double.parseDouble(sector[2]);
                double max = Double.parseDouble(sector[3]);
                for (left = Double.parseDouble(sector[0]); left > 360.0; left -= 360.0) {
                }
                while (right > 360.0) {
                    right -= 360.0;
                }
                while (left < 0.0) {
                    left += 360.0;
                }
                while (right < 0.0) {
                    right += 360.0;
                }
                orientation = left > right ? (left - 360.0 + right) / 2.0 : (left + right) / 2.0;
                dist = max;
            }
            radius = dist * 1.1;
            POINT2 pt0F = new POINT2();
            POINT2 pt1F = new POINT2();
            POINT2 ptBaseF = new POINT2();
            POINT2 ptLeftF = new POINT2();
            POINT2 ptRightF = new POINT2();
            POINT2 ptTipF = new POINT2();
            pt0 = (POINT2)tg.LatLongs.get(0);
            pt0F = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
            pt1 = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)radius, (double)orientation);
            pt1F = clsUtilityCPOF.PointLatLongToPixels(pt1, converter);
            dist = lineutility.CalcDistanceDouble((POINT2)pt0F, (POINT2)pt1F);
            double base = 10.0;
            if (dist < 100.0) {
                base = dist / 10.0;
            }
            if (base < 5.0) {
                base = 5.0;
            }
            double basex2 = 2.0 * base;
            ptBaseF = lineutility.ExtendAlongLineDouble((POINT2)pt0F, (POINT2)pt1F, (double)(dist + base));
            ptTipF = lineutility.ExtendAlongLineDouble((POINT2)pt0F, (POINT2)pt1F, (double)(dist + basex2));
            ptLeftF = lineutility.ExtendDirectedLine((POINT2)pt0F, (POINT2)ptBaseF, (POINT2)ptBaseF, (int)0, (double)base);
            ptRightF = lineutility.ExtendDirectedLine((POINT2)pt0F, (POINT2)ptBaseF, (POINT2)ptBaseF, (int)1, (double)base);
            tg.Pixels.add(pt0F);
            ptTipF.style = 5;
            tg.Pixels.add(ptTipF);
            tg.Pixels.add(ptLeftF);
            ptTipF.style = 0;
            tg.Pixels.add(ptTipF);
            tg.Pixels.add(ptRightF);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"RangeFanOrientation", (Exception)new RendererException("Failed inside RangeFanOrientation", (Throwable)exc));
        }
    }

    private static void SetTGStyles(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 22235000: 
                case 23115000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 24324100: 
                case 24324200: 
                case 24324300: 
                case 24351000: 
                case 24352000: 
                case 24353000: 
                case 24361000: 
                case 24362000: 
                case 24363000: {
                    tg.set_Fillstyle(3);
                    break;
                }
                case 21700000: 
                case 21710000: 
                case 22310000: 
                case 22431100: 
                case 22528000: 
                case 23157000: 
                case 23200001: 
                case 24220000: {
                    tg.set_LineStyle(1);
                    break;
                }
                case 22139000: 
                case 22522100: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 211210000: {
                    tg.set_FillColor(tg.get_FillColor());
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"SetTGStyles", (Exception)new RendererException("Failed inside SetTGStyles", (Throwable)exc));
        }
    }

    private static void FilterPoints(TGLight tg) {
        try {
            int lineType = tg.get_LineType();
            double minSpikeDistance = 0.0;
            switch (lineType) {
                case 22122000: 
                case 22134000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23330000: 
                case 23350000: {
                    minSpikeDistance = 25.0;
                    break;
                }
                case 22123000: 
                case 22624000: 
                case 23111000: 
                case 23111001: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23134000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    minSpikeDistance = 35.0;
                    break;
                }
                case 32156000: 
                case 32162000: 
                case 32164000: {
                    minSpikeDistance = 35.0;
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            double dist = 0.0;
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            ArrayList<POINT2> ptsGeo = new ArrayList<POINT2>();
            pts.add((POINT2)tg.Pixels.get(0));
            ptsGeo.add((POINT2)tg.LatLongs.get(0));
            POINT2 lastGoodPt = (POINT2)tg.Pixels.get(0);
            POINT2 currentPt = null;
            POINT2 currentPtGeo = null;
            boolean foundGoodPt = false;
            block10: for (j = 1; j < tg.Pixels.size(); ++j) {
                currentPt = (POINT2)tg.Pixels.get(j);
                currentPtGeo = (POINT2)tg.LatLongs.get(j);
                dist = lineutility.CalcDistanceDouble((POINT2)lastGoodPt, (POINT2)currentPt);
                switch (lineType) {
                    case 22123000: {
                        if (dist > minSpikeDistance) {
                            lastGoodPt = currentPt;
                            pts.add(currentPt);
                            ptsGeo.add(currentPtGeo);
                            foundGoodPt = true;
                            continue block10;
                        }
                        if (j != tg.Pixels.size() - 1) continue block10;
                        pts.set(pts.size() - 1, currentPt);
                        ptsGeo.set(ptsGeo.size() - 1, currentPtGeo);
                        continue block10;
                    }
                    default: {
                        if (!(dist > minSpikeDistance) && j != tg.Pixels.size() - 1) continue block10;
                        lastGoodPt = currentPt;
                        pts.add(currentPt);
                        ptsGeo.add(currentPtGeo);
                        foundGoodPt = true;
                    }
                }
            }
            if (foundGoodPt) {
                tg.Pixels = pts;
                tg.LatLongs = ptsGeo;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"FilterPoints", (Exception)new RendererException("Failed inside FilterPoints", (Throwable)exc));
        }
    }

    protected static void ClearPixelsStyle(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 13000000: 
                case 13000001: 
                case 13000002: 
                case 15000000: 
                case 15000001: 
                case 15000003: 
                case 22221000: 
                case 22222000: 
                case 22222001: 
                case 22223000: 
                case 22224000: 
                case 22224001: 
                case 22225000: {
                    return;
                }
            }
            for (int j = 0; j < tg.Pixels.size(); ++j) {
                ((POINT2)tg.Pixels.get((int)j)).style = 0;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ClearPixelsStyle", (Exception)new RendererException("Failed inside ClearPixelsStyle", (Throwable)exc));
        }
    }

    protected static void FilterPoints2(TGLight tg, IPointConversion converter) {
        try {
            int lineType = tg.get_LineType();
            double minSpikeDistance = 0.0;
            boolean segmented = true;
            if (tg.Pixels.size() < 3) {
                return;
            }
            switch (lineType) {
                case 22124000: 
                case 22125000: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22623000: 
                case 22623001: 
                case 24230000: {
                    minSpikeDistance = 5.0;
                    segmented = false;
                    break;
                }
                case 22122000: 
                case 22134000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23330000: 
                case 23350000: {
                    minSpikeDistance = 25.0;
                    break;
                }
                case 22123000: 
                case 22624000: 
                case 23111000: 
                case 23111001: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23134000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    minSpikeDistance = 35.0;
                    break;
                }
                case 32156000: 
                case 32162000: 
                case 32164000: {
                    minSpikeDistance = 35.0;
                    break;
                }
                default: {
                    return;
                }
            }
            double dist = 0.0;
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            int j = 0;
            POINT2 pt = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            for (j = 0; j < tg.Pixels.size(); ++j) {
                pt = (POINT2)tg.Pixels.get(j);
                pt.style = ((POINT2)tg.Pixels.get((int)j)).style;
                pts.add(pt);
            }
            boolean removedPt = true;
            block9: while (removedPt) {
                removedPt = false;
                for (j = 0; j < pts.size() - 1; ++j) {
                    pt0 = pts.get(j);
                    pt1 = pts.get(j + 1);
                    dist = lineutility.CalcDistanceDouble((POINT2)pts.get(j), (POINT2)pts.get(j + 1));
                    if (!(dist < minSpikeDistance)) continue;
                    if (!segmented) {
                        if (j + 1 == pts.size() - 1) {
                            pts.remove(j);
                        } else {
                            pts.remove(j + 1);
                        }
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == 0 && pt1.style == -1) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == 0 && pt1.style == -2) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -1 && pt1.style == 0) {
                        pts.remove(j);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -1 && pt1.style == -1) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -1 && pt1.style == -2) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -2 && pt1.style == 0) {
                        pts.remove(j);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -2 && pt1.style == -1) {
                        pts.remove(j);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style != -2 || pt1.style != -2) continue;
                    pts.remove(j + 1);
                    removedPt = true;
                    break block9;
                }
            }
            tg.Pixels = pts;
            tg.LatLongs = clsUtility.PixelsToLatLong(pts, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"FilterPoints2", (Exception)new RendererException("Failed inside FilterPoints2", (Throwable)exc));
        }
    }

    private static void FilterAXADPoints(TGLight tg, IPointConversion converter, boolean usas) {
        try {
            int lineType = tg.get_LineType();
            switch (lineType) {
                case 21700000: 
                case 21710000: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: {
                    break;
                }
                default: {
                    return;
                }
            }
            int j = 0;
            ArrayList pts = new ArrayList();
            ArrayList ptsGeo = new ArrayList();
            POINT2 pt0 = (POINT2)tg.Pixels.get(0);
            POINT2 pt1 = (POINT2)tg.Pixels.get(1);
            Point2D pt1Geo2d = converter.PixelsToGeo((Point2D)new Point2D.Double(pt1.x, pt1.y));
            POINT2 pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
            POINT2 ptj = null;
            POINT2 ptjGeo = null;
            POINT2 controlPt = (POINT2)tg.Pixels.get(tg.Pixels.size() - 1);
            POINT2 pt0Relative = lineutility.PointRelativeToLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (POINT2)controlPt);
            double relativeDist = lineutility.CalcDistanceDouble((POINT2)pt0Relative, (POINT2)controlPt);
            relativeDist += 5.0;
            double pt0pt1dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
            boolean foundGoodPoint = false;
            if (relativeDist > pt0pt1dist) {
                pts.add(pt0);
                pt1Geo2d = converter.PixelsToGeo((Point2D)new Point2D.Double(pt0.x, pt0.y));
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
                pt1 = lineutility.ExtendAlongLineDouble((POINT2)pt0, (POINT2)pt1, (double)relativeDist);
                pts.add(pt1);
                pt1Geo2d = converter.PixelsToGeo((Point2D)new Point2D.Double(pt1.x, pt1.y));
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
            } else {
                foundGoodPoint = true;
                pts = tg.Pixels;
                ptsGeo = tg.LatLongs;
            }
            if (!foundGoodPoint) {
                for (j = 2; j < tg.Pixels.size() - 1; ++j) {
                    ptj = (POINT2)tg.Pixels.get(j);
                    ptjGeo = (POINT2)tg.LatLongs.get(j);
                    if (foundGoodPoint) {
                        pts.add(ptj);
                        ptsGeo.add(ptjGeo);
                        continue;
                    }
                    pt0pt1dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)ptj);
                    if (relativeDist > pt0pt1dist) continue;
                    pts.add(ptj);
                    ptsGeo.add(ptjGeo);
                    foundGoodPoint = true;
                }
                pts.add(controlPt);
                pt1Geo2d = converter.PixelsToGeo((Point2D)new Point2D.Double(controlPt.x, controlPt.y));
                pt1geo = new POINT2(pt1Geo2d.getX(), pt1Geo2d.getY());
                ptsGeo.add(pt1geo);
            }
            POINT2 lastGoodPt = (POINT2)pts.get(1);
            POINT2 currentPt = null;
            POINT2 currentPtGeo = null;
            double dist = 0.0;
            tg.Pixels = new ArrayList();
            tg.LatLongs = new ArrayList();
            for (j = 0; j < 2; ++j) {
                tg.Pixels.add((POINT2)pts.get(j));
                tg.LatLongs.add((POINT2)ptsGeo.get(j));
            }
            for (j = 2; j < pts.size() - 1; ++j) {
                currentPt = (POINT2)pts.get(j);
                currentPtGeo = (POINT2)ptsGeo.get(j);
                dist = lineutility.CalcDistanceDouble((POINT2)currentPt, (POINT2)lastGoodPt);
                if (!(dist > 5.0)) continue;
                lastGoodPt = currentPt;
                tg.Pixels.add(currentPt);
                tg.LatLongs.add(currentPtGeo);
            }
            tg.Pixels.add((POINT2)pts.get(pts.size() - 1));
            tg.LatLongs.add((POINT2)ptsGeo.get(ptsGeo.size() - 1));
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"FilterAXADPoints", (Exception)new RendererException("Failed inside FilterAXADPoints", (Throwable)exc));
        }
    }

    public static Boolean canClipPoints(TGLight tg) {
        try {
            String symbolId = tg.get_SymbolId();
            if (clsMETOC.IsWeather((String)symbolId) > 0) {
                return true;
            }
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 0x222248: 
                case 10000000: 
                case 11000000: 
                case 22121000: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22131000: 
                case 22132000: 
                case 22133000: 
                case 22134000: 
                case 22135000: 
                case 22136000: 
                case 22137000: 
                case 22138000: 
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 22235000: 
                case 22330000: 
                case 22340000: 
                case 22350000: 
                case 22421000: 
                case 22431000: 
                case 22431100: 
                case 22432000: 
                case 22522100: 
                case 22522210: 
                case 22522220: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22531000: 
                case 22532000: 
                case 22535000: 
                case 22536000: 
                case 22612000: 
                case 22613000: 
                case 22621000: 
                case 22622000: 
                case 22623000: 
                case 22624000: 
                case 22625000: 
                case 22626000: 
                case 23111000: 
                case 23111001: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23120000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23134000: 
                case 23162000: 
                case 23164000: 
                case 23180000: 
                case 23200000: 
                case 23200001: 
                case 23330000: 
                case 23350000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 23490000: 
                case 24210000: 
                case 24211000: 
                case 24220000: 
                case 24225000: 
                case 24226000: 
                case 24230000: 
                case 24240000: 
                case 24250000: 
                case 24260000: 
                case 24313000: 
                case 24314000: 
                case 24315000: 
                case 24321100: 
                case 24322100: 
                case 24323100: 
                case 24324100: 
                case 24325100: 
                case 24330000: 
                case 24331100: 
                case 24332100: 
                case 24333100: 
                case 24334100: 
                case 24335100: 
                case 24336100: 
                case 24337100: 
                case 24338100: 
                case 24339100: 
                case 24351000: 
                case 24361000: 
                case 25223000: 
                case 25224000: 
                case 25225000: 
                case 25310000: 
                case 25320000: 
                case 25330000: 
                case 25340000: 
                case 25351000: 
                case 25352000: 
                case 25353000: 
                case 221310000: 
                case 221311000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: 
                case 243100000: {
                    return true;
                }
                case 25221000: 
                case 25222000: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"canClipPoints", (Exception)new RendererException("Failed inside canClipPoints", (Throwable)exc));
            return false;
        }
    }

    protected static boolean LinesWithSeparateFill(int linetype, ArrayList<Shape2> shapes) {
        if (shapes == null) {
            return false;
        }
        switch (linetype) {
            case 22612000: 
            case 22623000: 
            case 23410000: {
                return true;
            }
            case 22121000: 
            case 22122000: 
            case 22123000: 
            case 22124000: 
            case 22125000: 
            case 22134000: 
            case 22221000: 
            case 22222000: 
            case 22222001: 
            case 22223000: 
            case 22224000: 
            case 22224001: 
            case 22225000: 
            case 22330000: 
            case 22340000: 
            case 22350000: 
            case 22522100: 
            case 22522210: 
            case 22522220: 
            case 22523000: 
            case 22525000: 
            case 22526000: 
            case 22527000: 
            case 22528000: 
            case 22613000: 
            case 22624000: 
            case 23111000: 
            case 23111001: 
            case 23112000: 
            case 23113000: 
            case 23114000: 
            case 23115000: 
            case 23120000: 
            case 23131100: 
            case 23131200: 
            case 23132000: 
            case 23134000: 
            case 23172000: 
            case 23330000: 
            case 23350000: 
            case 24210000: 
            case 24211000: 
            case 24220000: 
            case 24225000: 
            case 24230000: 
            case 24240000: 
            case 24250000: 
            case 25221000: 
            case 25222000: 
            case 25223000: 
            case 25224000: 
            case 25225000: 
            case 211100000: 
            case 231111000: 
            case 231112000: 
            case 231113000: 
            case 231114000: 
            case 231115000: 
            case 231116000: 
            case 231117100: 
            case 231117200: 
            case 231117300: {
                Shape2 shape = null;
                if (shapes != null && shapes.size() > 0) {
                    for (int j = 0; j < shapes.size(); ++j) {
                        shape = shapes.get(j);
                        if (shape.getShapeType() != Shape2.SHAPE_TYPE_POLYLINE) continue;
                        shapes.get(j).setFillColor(null);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected static ArrayList<POINT2> Point2DtoPOINT2Mapped(ArrayList<Point2D> pts2d, Map<String, Object> hashMap) {
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        try {
            int style = 0;
            for (int j = 0; j < pts2d.size(); ++j) {
                Point2D pt2d = pts2d.get(j);
                style = hashMap.containsValue(pt2d) ? 0 : -1;
                pts.add(new POINT2(pts2d.get(j).getX(), pts2d.get(j).getY(), style));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"Point2DToPOINT2Mapped", (Exception)new RendererException("Failed inside Point2DToPOINT2Mapped", (Throwable)exc));
        }
        return pts;
    }

    protected static ArrayList<POINT2> Point2DtoPOINT2(ArrayList<Point2D> pts2d) {
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        try {
            for (int j = 0; j < pts2d.size(); ++j) {
                pts.add(new POINT2(pts2d.get(j).getX(), pts2d.get(j).getY()));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"Point2DToPOINT2", (Exception)new RendererException("Failed inside Point2DToPOINT2", (Throwable)exc));
        }
        return pts;
    }

    protected static ArrayList<Point2D> POINT2toPoint2D(ArrayList<POINT2> pts) {
        ArrayList<Point2D> pts2d = new ArrayList<Point2D>();
        try {
            for (int j = 0; j < pts.size(); ++j) {
                pts2d.add(new Point2D.Double(pts.get((int)j).x, pts.get((int)j).y));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"POINT2toPoint2D", (Exception)new RendererException("Failed inside POINT2toPoint2D", (Throwable)exc));
        }
        return pts2d;
    }

    private static Shape BuildShapeFromPoints(ArrayList<Point2D> pts2d) {
        GeneralPath shape = new GeneralPath();
        try {
            shape.moveTo(pts2d.get(0).getX(), pts2d.get(0).getY());
            for (int j = 1; j < pts2d.size(); ++j) {
                shape.lineTo(pts2d.get(j).getX(), pts2d.get(j).getY());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"buildShapeFromPoints", (Exception)new RendererException("Failed inside buildShapeFromPoints", (Throwable)exc));
        }
        return shape;
    }

    private static Shape BuildShapeFromPoints2(ArrayList<POINT2> pts2) {
        GeneralPath shape = new GeneralPath();
        try {
            shape.moveTo(pts2.get((int)0).x, pts2.get((int)0).y);
            block8: for (int j = 0; j < pts2.size(); ++j) {
                switch (pts2.get((int)j).style) {
                    case 1: {
                        shape.lineTo(pts2.get((int)j).x, pts2.get((int)j).y);
                        continue block8;
                    }
                    case 2: {
                        shape.quadTo(pts2.get((int)j).x, pts2.get((int)j).y, pts2.get((int)(j + 1)).x, pts2.get((int)(j + 1)).y);
                        ++j;
                        continue block8;
                    }
                    case 3: {
                        shape.curveTo(pts2.get((int)j).x, pts2.get((int)j).y, pts2.get((int)(j + 1)).x, pts2.get((int)(j + 1)).y, pts2.get((int)(j + 2)).x, pts2.get((int)(j + 2)).y);
                        j += 2;
                        continue block8;
                    }
                    case 4: {
                        shape.lineTo(pts2.get((int)0).x, pts2.get((int)0).y);
                        continue block8;
                    }
                    default: {
                        shape.lineTo(pts2.get((int)0).x, pts2.get((int)0).y);
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"BuildShapeFromPoints2", (Exception)new RendererException("Failed inside BuildShapeFromPoints2", (Throwable)exc));
        }
        return shape;
    }

    protected static ArrayList<Shape2> buildShapeSpecFromPoints(TGLight tg0, Shape2 shapeSpec, ArrayList<POINT2> pts, Object clipArea) {
        ArrayList<Shape2> shapeSpecs2 = null;
        try {
            shapeSpecs2 = new ArrayList<Shape2>();
            int j = 0;
            int h = shapeSpec.getBounds().height;
            int w = shapeSpec.getBounds().width;
            int x = shapeSpec.getBounds().x;
            int y = shapeSpec.getBounds().y;
            if (h == 0) {
                h = 1;
            }
            if (w == 0) {
                w = 1;
            }
            Rectangle2D clipBounds = null;
            ArrayList clipPoints = null;
            if (clipArea != null && clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipBounds = (Rectangle2D)clipArea;
            } else if (clipArea != null && clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                clipBounds = (Rectangle2D)clipArea;
            } else if (clipArea != null && clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                clipPoints = (ArrayList)clipArea;
            }
            if (clipBounds != null && !clipBounds.contains(shapeSpec.getShape().getBounds2D()) && !clipBounds.intersects(shapeSpec.getShape().getBounds2D())) {
                if (!clipBounds.contains(x, y, w, h) && !clipBounds.intersects(x, y, w, h)) {
                    return shapeSpecs2;
                }
            } else if (clipPoints != null) {
                GeneralPath poly = new GeneralPath();
                for (j = 0; j < clipPoints.size(); ++j) {
                    if (j == 0) {
                        poly.moveTo(((Point2D)clipPoints.get(j)).getX(), ((Point2D)clipPoints.get(j)).getY());
                        continue;
                    }
                    poly.lineTo(((Point2D)clipPoints.get(j)).getX(), ((Point2D)clipPoints.get(j)).getY());
                }
                poly.closePath();
                if (!(poly.contains(shapeSpec.getShape().getBounds2D()) || poly.intersects(shapeSpec.getShape().getBounds2D()) || poly.contains(x, y, w, h) || poly.intersects(x, y, w, h))) {
                    return shapeSpecs2;
                }
            }
            if (shapeSpec.getShapeType() == Shape2.SHAPE_TYPE_MODIFIER || shapeSpec.getShapeType() == Shape2.SHAPE_TYPE_MODIFIER_FILL) {
                shapeSpecs2.add(shapeSpec);
                return shapeSpecs2;
            }
            TGLight tg = new TGLight();
            POINT2 pt = null;
            tg.set_LineType(22124000);
            ArrayList<POINT2> pts2 = new ArrayList<POINT2>();
            ArrayList<Point2D> pts2d = null;
            Shape shape = null;
            GeneralPath gp = new GeneralPath();
            block7: for (j = 0; j < pts.size(); ++j) {
                pt = pts.get(j);
                switch (pt.style) {
                    case 0: {
                        if (pts2.size() > 1) {
                            tg = new TGLight();
                            tg.set_LineType(22124000);
                            tg.Pixels = pts2;
                            if (clipBounds != null) {
                                pts2d = clsClipPolygon2.ClipPolygon(tg, clipBounds);
                            } else if (clipPoints != null && !clipPoints.isEmpty()) {
                                pts2d = clsClipQuad.ClipPolygon(tg, clipPoints);
                            }
                            if (pts2d != null && pts2d.size() > 1) {
                                shape = clsUtilityCPOF.BuildShapeFromPoints(pts2d);
                                gp.append(shape, false);
                            }
                            pts2.clear();
                            pts2.add(pt);
                            continue block7;
                        }
                        pts2.add(pt);
                        continue block7;
                    }
                    case 1: {
                        pts2.add(pt);
                        continue block7;
                    }
                    default: {
                        pts2.add(pt);
                    }
                }
            }
            if (pts2.size() > 1) {
                tg = new TGLight();
                tg.set_LineType(22124000);
                tg.Pixels = pts2;
                if (clipBounds != null) {
                    pts2d = clsClipPolygon2.ClipPolygon(tg, clipBounds);
                } else if (clipPoints != null) {
                    pts2d = clsClipQuad.ClipPolygon(tg, clipPoints);
                }
                if (pts2d != null && pts2d.size() > 1) {
                    shape = clsUtilityCPOF.BuildShapeFromPoints(pts2d);
                    gp.append(shape, false);
                }
                tg0.set_WasClipped(tg.get_WasClipped());
            }
            Shape2 shapeSpec2 = new Shape2(shapeSpec.getShapeType());
            shapeSpec2.setLineColor(shapeSpec.getLineColor());
            shapeSpec2.setFillColor(shapeSpec.getFillColor());
            shapeSpec2.setStroke(shapeSpec.getStroke());
            shapeSpec2.setTexturePaint(shapeSpec.getTexturePaint());
            shapeSpec2.setShape((Shape)gp);
            shapeSpecs2.add(shapeSpec2);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"buildShapeSpecFromPoints", (Exception)new RendererException("Failed inside buildShapeSpecFromPoints", (Throwable)exc));
        }
        return shapeSpecs2;
    }

    private static boolean doNotClipFill(TGLight tg) {
        switch (tg.get_LineType()) {
            case 21700000: 
            case 21710000: 
            case 22320000: 
            case 22521100: 
            case 22521200: 
            case 22521300: 
            case 22521410: 
            case 22521420: 
            case 25211000: 
            case 25212000: {
                return true;
            }
        }
        return false;
    }

    protected static ArrayList<Shape2> postClipShapes(TGLight tg, ArrayList<Shape2> shapeSpecsArray, Object clipArea) {
        ArrayList<Shape2> shapeSpecs2 = null;
        ArrayList<Shape2> tempShapes = null;
        try {
            if (shapeSpecsArray == null || shapeSpecsArray.size() == 0) {
                return null;
            }
            shapeSpecs2 = new ArrayList<Shape2>();
            int j = 0;
            ArrayList<Shape2> shapeSpecs = new ArrayList<Shape2>();
            for (j = 0; j < shapeSpecsArray.size(); ++j) {
                shapeSpecs.add(shapeSpecsArray.get(j));
            }
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            Shape shape = null;
            float[] coords = new float[6];
            Shape2 shapeSpec = null;
            for (j = 0; j < shapeSpecs.size(); ++j) {
                shapeSpec = (Shape2)shapeSpecs.get(j);
                shape = shapeSpec.getShape();
                pts.clear();
                PathIterator i = shape.getPathIterator(null);
                while (!i.isDone()) {
                    int type = i.currentSegment(coords);
                    switch (type) {
                        case 0: {
                            POINT2 pt = new POINT2((double)coords[0], (double)coords[1]);
                            pt.style = 0;
                            pts.add(pt);
                            break;
                        }
                        case 1: {
                            POINT2 pt = new POINT2((double)coords[0], (double)coords[1]);
                            pt.style = 1;
                            pts.add(pt);
                            break;
                        }
                        case 2: {
                            POINT2 pt = new POINT2((double)coords[0], (double)coords[1]);
                            pt.style = 2;
                            pts.add(pt);
                            pt = new POINT2((double)coords[2], (double)coords[3]);
                            pt.style = 2;
                            pts.add(pt);
                            break;
                        }
                        case 3: {
                            POINT2 pt = new POINT2((double)coords[0], (double)coords[1]);
                            pt.style = 3;
                            pts.add(pt);
                            pt = new POINT2((double)coords[2], (double)coords[3]);
                            pt.style = 3;
                            pts.add(pt);
                            pt = new POINT2((double)coords[4], (double)coords[5]);
                            pt.style = 3;
                            pts.add(pt);
                            break;
                        }
                        case 4: {
                            POINT2 pt = new POINT2((double)coords[0], (double)coords[1]);
                            pt.style = 4;
                            pts.add(pt);
                            break;
                        }
                        default: {
                            POINT2 pt = null;
                        }
                    }
                    i.next();
                }
                tempShapes = clsUtilityCPOF.buildShapeSpecFromPoints(tg, shapeSpec, pts, clipArea);
                shapeSpecs2.addAll(tempShapes);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"postClipShapes", (Exception)new RendererException("Failed inside postClipShapes", (Throwable)exc));
        }
        return shapeSpecs2;
    }

    private static boolean segmentAnticipatedLine(TGLight tg) {
        try {
            int linetype = tg.get_LineType();
            if (JavaTacticalRenderer.clsUtility.IsChange1Area((int)linetype, null)) {
                return false;
            }
            if (clsUtility.isAutoshape(tg)) {
                return false;
            }
            if (JavaTacticalRenderer.clsUtility.isBasicShape((int)linetype)) {
                return false;
            }
            switch (linetype) {
                case 21700000: 
                case 21710000: 
                case 22320000: 
                case 22421000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23200000: 
                case 23200001: {
                    return false;
                }
                case 25223000: 
                case 25224000: 
                case 25225000: {
                    return false;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"segmentGenericLine", (Exception)new RendererException("Failed inside segmentGenericLine", (Throwable)exc));
        }
        return true;
    }

    protected static void postSegmentFSA(TGLight tg, IPointConversion converter) {
        try {
            if (tg.get_Client().equals("2D")) {
                return;
            }
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326101: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: {
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList<POINT2> latLongs = new ArrayList<POINT2>();
            ArrayList<POINT2> resultPts = new ArrayList<POINT2>();
            int j = 0;
            int k = 0;
            int n = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt = null;
            double dist = 0.0;
            double interval = 250000.0;
            double az = 0.0;
            double maxDist = 0.0;
            Point2D pt2d = null;
            for (j = 0; j < tg.Pixels.size(); ++j) {
                pt0 = (POINT2)tg.Pixels.get(j);
                pt2d = new Point2D.Double(pt0.x, pt0.y);
                pt2d = converter.PixelsToGeo(pt2d);
                pt0 = new POINT2(pt2d.getX(), pt2d.getY());
                latLongs.add(pt0);
            }
            for (j = 0; j < latLongs.size() - 1; ++j) {
                pt0 = (POINT2)latLongs.get(j);
                pt1 = (POINT2)latLongs.get(j + 1);
                pt1.style = -1;
                az = mdlGeodesic.GetAzimuth((POINT2)pt0, (POINT2)pt1);
                dist = mdlGeodesic.geodesic_distance((POINT2)latLongs.get(j), (POINT2)latLongs.get(j + 1), null, null);
                if (!(dist > maxDist)) continue;
                maxDist = dist;
            }
            if (interval > maxDist) {
                interval = maxDist;
            }
            for (j = 0; j < latLongs.size() - 1; ++j) {
                pt0 = new POINT2((POINT2)latLongs.get(j));
                pt0.style = 0;
                pt1 = new POINT2(latLongs.get(j + 1));
                pt1.style = 0;
                az = mdlGeodesic.GetAzimuth((POINT2)pt0, (POINT2)pt1);
                dist = mdlGeodesic.geodesic_distance((POINT2)latLongs.get(j), (POINT2)latLongs.get(j + 1), null, null);
                n = (int)(dist / interval);
                if (j == 0) {
                    resultPts.add(pt0);
                }
                for (k = 1; k <= n; ++k) {
                    pt = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(interval * (double)k), (double)az);
                    pt.style = -2;
                    dist = mdlGeodesic.geodesic_distance((POINT2)pt, (POINT2)pt1, null, null);
                    if (!(dist >= interval / 2.0)) continue;
                    resultPts.add(pt);
                }
                resultPts.add(pt1);
            }
            latLongs = resultPts;
            tg.Pixels = clsUtility.LatLongToPixels(latLongs, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"postSegmentFSA", (Exception)new RendererException("Failed inside postSegmentFSA", (Throwable)exc));
        }
    }

    private static ArrayList<POINT2> toGeodesic(TGLight tg, double interval, HashMap hmap) {
        ArrayList<POINT2> locs = new ArrayList<POINT2>();
        try {
            int i = 0;
            int k = 0;
            int n = 0;
            ArrayList points = tg.LatLongs;
            String H = "";
            String color = "";
            boolean bolIsAC = false;
            int acWidth = 0;
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22221000: 
                case 22222001: 
                case 22223000: 
                case 22224001: 
                case 22225000: {
                    bolIsAC = true;
                    break;
                }
            }
            block5: for (i = 0; i < points.size() - 1; ++i) {
                if (bolIsAC) {
                    acWidth = ((POINT2)points.get((int)i)).style;
                }
                double lat1 = Math.toRadians(((POINT2)points.get((int)i)).y);
                double lon1 = Math.toRadians(((POINT2)points.get((int)i)).x);
                double lat2 = Math.toRadians(((POINT2)points.get((int)(i + 1))).y);
                double lon2 = Math.toRadians(((POINT2)points.get((int)(i + 1))).x);
                double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
                double dist = mdlGeodesic.geodesic_distance((POINT2)((POINT2)points.get(i)), (POINT2)((POINT2)points.get(i + 1)), null, null);
                float flt = (float)dist / (float)interval;
                n = Math.round(flt);
                if (n < 1) {
                    n = 1;
                }
                if (n > 32) {
                    n = 32;
                }
                for (k = 0; k <= n; ++k) {
                    if (k == 0) {
                        locs.add(new POINT2((POINT2)points.get(i)));
                        if (hmap == null || !hmap.containsKey(i)) continue;
                        if (!H.isEmpty()) {
                            H = H + ",";
                        }
                        color = (String)hmap.get(i);
                        H = H + Integer.toString(locs.size() - 1) + ":" + color;
                        continue;
                    }
                    if (k == n) {
                        if (i != points.size() - 2) continue block5;
                        locs.add(new POINT2((POINT2)points.get(i + 1)));
                        if (hmap == null || !hmap.containsKey(i + 1)) continue block5;
                        if (!H.isEmpty()) {
                            H = H + ",";
                        }
                        color = (String)hmap.get(i + 1);
                        H = H + Integer.toString(locs.size() - 1) + ":" + color;
                        continue block5;
                    }
                    double f = (double)k / (double)n;
                    double A = Math.sin((1.0 - f) * d) / Math.sin(d);
                    double B = Math.sin(f * d) / Math.sin(d);
                    double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
                    double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
                    double z = A * Math.sin(lat1) + B * Math.sin(lat2);
                    double lat = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
                    double lon = Math.atan2(y, x);
                    POINT2 pt = new POINT2(lon *= 57.29577951308232, lat *= 57.29577951308232);
                    if (bolIsAC) {
                        pt.style = -acWidth;
                    }
                    locs.add(pt);
                    if (hmap == null || !hmap.containsKey(i)) continue;
                    if (!H.isEmpty()) {
                        H = H + ",";
                    }
                    color = (String)hmap.get(i);
                    H = H + Integer.toString(locs.size() - 1) + ":" + color;
                }
            }
            if (!H.isEmpty()) {
                tg.set_H(H);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"toGeodesic", (Exception)new RendererException("Failed inside toGeodesic", (Throwable)exc));
            return null;
        }
        return locs;
    }

    protected static void SegmentGeoPoints(TGLight tg, IPointConversion converter, double zoomFactor) {
        try {
            if (tg.get_Client().equals("2D")) {
                return;
            }
            ArrayList<Object> resultPts = new ArrayList();
            int lineType = tg.get_LineType();
            double interval = 250000.0;
            boolean bolSegmentAC = false;
            boolean bolIsAC = false;
            bolSegmentAC = true;
            switch (lineType) {
                case 22221000: 
                case 22222001: 
                case 22223000: 
                case 22224001: 
                case 22225000: {
                    if (!bolSegmentAC) {
                        return;
                    }
                    bolIsAC = true;
                    break;
                }
                case 22122000: 
                case 22134000: 
                case 22350000: 
                case 22522100: 
                case 22528000: 
                case 22624000: 
                case 23111000: 
                case 23111001: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23134000: 
                case 23330000: 
                case 23350000: 
                case 24220000: 
                case 231111000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    break;
                }
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: {
                    interval = 500000.0;
                    break;
                }
                case 22123000: {
                    interval = 2000000.0;
                    break;
                }
                default: {
                    if (clsUtilityCPOF.segmentAnticipatedLine(tg)) break;
                    return;
                }
            }
            int j = 0;
            int k = 0;
            int n = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt = null;
            double dist = 0.0;
            double az = 0.0;
            double maxDist = 0.0;
            for (j = 0; j < tg.LatLongs.size() - 1; ++j) {
                pt0 = (POINT2)tg.LatLongs.get(j);
                pt1 = (POINT2)tg.LatLongs.get(j + 1);
                if (!bolIsAC) {
                    pt1.style = -1;
                }
                az = mdlGeodesic.GetAzimuth((POINT2)pt0, (POINT2)pt1);
                dist = mdlGeodesic.geodesic_distance((POINT2)((POINT2)tg.LatLongs.get(j)), (POINT2)((POINT2)tg.LatLongs.get(j + 1)), null, null);
                if (!(dist > maxDist)) continue;
                maxDist = dist;
            }
            if (interval > maxDist) {
                interval = maxDist;
            }
            if (zoomFactor > 0.0 && zoomFactor < 0.01) {
                zoomFactor = 0.01;
            }
            if (zoomFactor > 0.0 && zoomFactor < 1.0) {
                interval *= zoomFactor;
            }
            boolean useVincenty = false;
            String H = "";
            String color = "";
            HashMap hmap = JavaTacticalRenderer.clsUtility.getMSRSegmentColorStrings((TGLight)tg);
            if (hmap != null) {
                tg.set_H("");
            }
            if (useVincenty = true) {
                tg.LatLongs = resultPts = clsUtilityCPOF.toGeodesic(tg, interval, hmap);
                tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
                return;
            }
            for (j = 0; j < tg.LatLongs.size() - 1; ++j) {
                pt0 = new POINT2((POINT2)tg.LatLongs.get(j));
                pt1 = new POINT2((POINT2)tg.LatLongs.get(j + 1));
                pt0.style = 0;
                pt1.style = 0;
                az = mdlGeodesic.GetAzimuth((POINT2)pt0, (POINT2)pt1);
                dist = mdlGeodesic.geodesic_distance((POINT2)((POINT2)tg.LatLongs.get(j)), (POINT2)((POINT2)tg.LatLongs.get(j + 1)), null, null);
                n = (int)(dist / interval);
                if (j == 0) {
                    resultPts.add(pt0);
                    if (hmap != null && hmap.containsKey(j)) {
                        if (!H.isEmpty()) {
                            H = H + ",";
                        }
                        color = (String)hmap.get(j);
                        H = H + Integer.toString(resultPts.size() - 1) + ":" + color;
                    }
                }
                for (k = 1; k <= n; ++k) {
                    pt = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)(interval * (double)k), (double)az);
                    pt.style = -2;
                    dist = mdlGeodesic.geodesic_distance((POINT2)pt, (POINT2)pt1, null, null);
                    if (!(dist >= interval / 2.0)) continue;
                    resultPts.add(pt);
                    if (hmap == null || !hmap.containsKey(j)) continue;
                    color = (String)hmap.get(j);
                    if (!H.isEmpty()) {
                        H = H + ",";
                    }
                    H = H + Integer.toString(resultPts.size() - 1) + ":" + color;
                }
                resultPts.add(pt1);
                if (hmap == null || !hmap.containsKey(j + 1)) continue;
                if (!H.isEmpty()) {
                    H = H + ",";
                }
                color = (String)hmap.get(j + 1);
                H = H + Integer.toString(resultPts.size() - 1) + ":" + color;
            }
            if (!H.isEmpty()) {
                tg.set_H(H);
            }
            tg.LatLongs = resultPts;
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"SegmentGeoPoints", (Exception)new RendererException("Failed inside SegmentGeoPoints", (Throwable)exc));
        }
    }
}

