/*
 * Decompiled with CFR 0.152.
 */
package RenderMultipoints;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaLineArray.lineutility;
import JavaTacticalRenderer.TGLight;
import JavaTacticalRenderer.clsMETOC;
import RenderMultipoints.clsUtility;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;

public final class clsUtilityGE {
    private static final String _className = "clsUtilityGE";
    private static final int Hatch_ForwardDiagonal = 2;
    private static final int Hatch_BackwardDiagonal = 3;
    private static final int Hatch_Vertical = 4;
    private static final int Hatch_Horizontal = 5;
    private static final int Hatch_Cross = 8;

    protected static void setSplineLinetype(TGLight tg) {
        switch (tg.get_LineType()) {
            case 22623000: {
                tg.set_LineType(22623001);
                break;
            }
            case 22612000: {
                tg.set_LineType(22612001);
                break;
            }
            case 32164000: {
                tg.set_LineType(32164001);
                break;
            }
            case 32163000: {
                tg.set_LineType(32163001);
                break;
            }
            case 32156000: {
                tg.set_LineType(32156001);
                break;
            }
            case 32162000: {
                tg.set_LineType(32162001);
                break;
            }
            case 32610000: {
                tg.set_LineType(32610001);
                break;
            }
            case 31430000: {
                tg.set_LineType(31430001);
                break;
            }
            case 31440000: {
                tg.set_LineType(31440001);
                break;
            }
            case 32273000: {
                tg.set_LineType(32273001);
                break;
            }
            case 32272000: {
                tg.set_LineType(32272001);
                break;
            }
            case 32234300: {
                tg.set_LineType(32234301);
                break;
            }
            case 32234200: {
                tg.set_LineType(32234201);
                break;
            }
            case 32234100: {
                tg.set_LineType(32234101);
                break;
            }
            case 32233700: {
                tg.set_LineType(32233701);
                break;
            }
            case 32233600: {
                tg.set_LineType(32233601);
                break;
            }
            case 32231700: {
                tg.set_LineType(32231701);
                break;
            }
            case 32221000: {
                tg.set_LineType(32221001);
                break;
            }
            case 32213000: {
                tg.set_LineType(32213001);
                break;
            }
            case 32212000: {
                tg.set_LineType(32212001);
                break;
            }
            case 32161000: {
                tg.set_LineType(32161001);
                break;
            }
            case 32155000: {
                tg.set_LineType(32155001);
                break;
            }
            case 32154000: {
                tg.set_LineType(32154001);
                break;
            }
            case 31830000: {
                tg.set_LineType(31830001);
                break;
            }
            case 31820000: {
                tg.set_LineType(31820001);
                break;
            }
            case 31810000: {
                tg.set_LineType(31810001);
                break;
            }
            case 31850000: {
                tg.set_LineType(31850001);
                break;
            }
            case 31840000: {
                tg.set_LineType(31840001);
                break;
            }
            case 31860000: {
                tg.set_LineType(31860001);
                break;
            }
        }
    }

    private static void createDashedPolylines(TGLight tg, ArrayList<ArrayList<Point2D>> polylines, ShapeInfo shape) {
        try {
            if (tg.get_UseDashArray()) {
                return;
            }
            if (shape.getLineColor() == null) {
                return;
            }
            ArrayList dashedPolylines = new ArrayList();
            BasicStroke s = (BasicStroke)shape.getStroke();
            float[] dash = s.getDashArray();
            float lineThickness = tg.get_LineThickness();
            if (dash == null || dash.length < 2) {
                return;
            }
            if (dash.length == 8) {
                dash = new float[]{2.0f, 2.0f};
                s = new BasicStroke(2.0f, 1, 0, 2.0f, dash, 0.0f);
                shape.setStroke((Stroke)s);
            }
            if (dash.length == 4 && dash[0] == lineThickness * 2.0f && dash[1] == lineThickness * 2.0f && dash[2] == lineThickness * 2.0f && dash[3] == lineThickness * 2.0f) {
                dash = new float[]{lineThickness, lineThickness};
            }
            int j = 0;
            int k = 0;
            int i = 0;
            int l = 0;
            boolean n = false;
            ArrayList<Point2D> polyline = null;
            ArrayList<Point2D> dashedPolyline = null;
            Object previousPolyline = null;
            Point2D pt2d0 = null;
            Point2D pt2d1 = null;
            Point2D.Double pt2d2 = null;
            Point2D.Double pt2d3 = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            double dist = 0.0;
            double patternLength = 0.0;
            int numSegments = 0;
            double dashMultiplier = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            j = 0;
            while (j < dash.length) {
                int n2 = j++;
                dash[n2] = (float)((double)dash[n2] * dashMultiplier);
            }
            for (j = 0; j < dash.length; ++j) {
                patternLength += (double)dash[j];
            }
            float[] sum = new float[dash.length];
            double remainder = 0.0;
            int linetype = tg.get_LineType();
            for (j = 0; j < sum.length; ++j) {
                for (k = 0; k <= j; ++k) {
                    int n3 = j;
                    sum[n3] = sum[n3] + dash[k];
                }
            }
            boolean noShortSegments = false;
            switch (linetype) {
                case 24211000: 
                case 24250000: 
                case 24260000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: {
                    noShortSegments = true;
                    break;
                }
            }
            for (j = 0; j < polylines.size(); ++j) {
                polyline = polylines.get(j);
                for (k = 0; k < polyline.size() - 1; ++k) {
                    pt2d0 = polyline.get(k);
                    pt2d1 = polyline.get(k + 1);
                    pt0 = new POINT2(pt2d0.getX(), pt2d0.getY());
                    pt1 = new POINT2(pt2d1.getX(), pt2d1.getY());
                    dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
                    numSegments = (int)(dist / patternLength);
                    if (noShortSegments && dist < 25.0) {
                        numSegments = 1;
                    }
                    for (l = 0; l < numSegments; ++l) {
                        for (i = 0; i < dash.length; ++i) {
                            if (i % 2 != 0) continue;
                            dashedPolyline = new ArrayList<Point2D>();
                            pt2 = i == 0 ? lineutility.ExtendAlongLineDouble2((POINT2)pt0, (POINT2)pt1, (double)((double)l * patternLength)) : lineutility.ExtendAlongLineDouble2((POINT2)pt0, (POINT2)pt1, (double)((double)l * patternLength + (double)sum[i - 1]));
                            pt3 = lineutility.ExtendAlongLineDouble2((POINT2)pt0, (POINT2)pt1, (double)((double)l * patternLength + (double)sum[i]));
                            pt2d2 = new Point2D.Double(pt2.x, pt2.y);
                            pt2d3 = new Point2D.Double(pt3.x, pt3.y);
                            dashedPolyline.add(pt2d2);
                            dashedPolyline.add(pt2d3);
                            dashedPolylines.add(dashedPolyline);
                        }
                    }
                    remainder = dist - (double)numSegments * patternLength;
                    if (!(remainder > 0.0)) continue;
                    dashedPolyline = new ArrayList();
                    pt2 = lineutility.ExtendAlongLineDouble2((POINT2)pt0, (POINT2)pt1, (double)((double)numSegments * patternLength + remainder / 2.0));
                    pt2d2 = new Point2D.Double(pt2.x, pt2.y);
                    dashedPolyline.add(pt2d2);
                    dashedPolyline.add(pt2d1);
                    dashedPolylines.add(dashedPolyline);
                }
            }
            polylines.clear();
            polylines.addAll(dashedPolylines);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"createDashedPolylines", (Exception)new RendererException("Failed inside createDashedPolylines", (Throwable)exc));
        }
    }

    private static ShapeInfo createSimpleFillShape(TGLight tg, ShapeInfo shape, ArrayList<ArrayList<Point2D>> polylines) {
        try {
            BasicStroke s = (BasicStroke)shape.getStroke();
            float[] dash = s.getDashArray();
            if (!JavaTacticalRenderer.clsUtility.isClosedPolygon((int)tg.get_LineType()) && !JavaTacticalRenderer.clsUtility.IsChange1Area((int)tg.get_LineType(), null)) {
                return null;
            }
            if (dash == null || dash.length < 2) {
                return null;
            }
            if (shape.getFillColor() == null) {
                return null;
            }
            int j = 0;
            int k = 0;
            ShapeInfo shape2 = new ShapeInfo(shape.getShape());
            shape2.setShapeType(ShapeInfo.SHAPE_TYPE_FILL);
            ArrayList polylines2 = new ArrayList();
            ArrayList<Point2D> polyline = null;
            ArrayList<Point2D.Double> polyline2 = null;
            Point2D.Double pt2d = null;
            s = new BasicStroke(0.0f);
            shape2.setStroke((Stroke)s);
            shape2.setFillColor(shape.getFillColor());
            for (j = 0; j < polylines.size(); ++j) {
                polyline = polylines.get(j);
                polyline2 = new ArrayList<Point2D.Double>();
                for (k = 0; k < polyline.size(); ++k) {
                    pt2d = new Point2D.Double(polyline.get(k).getX(), polyline.get(k).getY());
                    polyline2.add(pt2d);
                }
                polylines2.add(polyline2);
            }
            shape.setShapeType(ShapeInfo.SHAPE_TYPE_POLYLINE);
            shape.setFillColor(null);
            shape2.setPolylines(polylines2);
            shape2.setAffineTransform(new AffineTransform());
            return shape2;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"createSimpleFillShape", (Exception)new RendererException("Failed inside createSimpleFillShape", (Throwable)exc));
            return null;
        }
    }

    private static boolean allowFillForThese(TGLight tg) {
        try {
            int linetype = tg.get_LineType();
            int bolMETOC = clsMETOC.IsWeather((String)tg.get_SymbolId());
            if (bolMETOC >= 0) {
                return true;
            }
            switch (linetype) {
                case 15000001: 
                case 15000003: 
                case 21700000: 
                case 21710000: 
                case 22139000: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23131200: 
                case 23132000: 
                case 23172000: 
                case 23173000: 
                case 23174000: 
                case 23200001: 
                case 23211000: 
                case 23212000: 
                case 23213000: 
                case 23223000: 
                case 32214000: 
                case 243111000: 
                case 243112000: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"allowFillForThese", (Exception)new RendererException("Failed inside allowFillForThese", (Throwable)exc));
            return false;
        }
    }

    protected static void SetShapeInfosPolylines(TGLight tg, ArrayList<ShapeInfo> shapeInfos, Object clipBounds) {
        try {
            int j = 0;
            Shape shape = null;
            ShapeInfo shapeInfo = null;
            ArrayList<ArrayList<Point2D>> polylines = null;
            int type = -1;
            ShapeInfo simpleFillShape = null;
            Boolean isClosed = JavaTacticalRenderer.clsUtility.isClosedPolygon((int)tg.get_LineType());
            int linetype = tg.get_LineType();
            Color fillColor = null;
            for (j = 0; j < shapeInfos.size(); ++j) {
                shapeInfo = shapeInfos.get(j);
                type = shapeInfo.getShapeType();
                shape = shapeInfo.getShape();
                polylines = isClosed == false && type != Shape2.SHAPE_TYPE_FILL ? clsUtilityGE.createRenderablesFromShape(tg, shape, type, clipBounds) : clsUtilityGE.createRenderablesFromShape(tg, shape, type, null);
                if (simpleFillShape == null) {
                    simpleFillShape = clsUtilityGE.createSimpleFillShape(tg, shapeInfo, polylines);
                }
                fillColor = shapeInfo.getFillColor();
                if (simpleFillShape != null && !clsUtilityGE.allowFillForThese(tg)) {
                    shapeInfo.setFillColor(null);
                }
                clsUtilityGE.createDashedPolylines(tg, polylines, shapeInfo);
                shapeInfo.setPolylines(polylines);
            }
            if (simpleFillShape != null) {
                shapeInfos.add(0, simpleFillShape);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"SetShapeInfosPolylines", (Exception)new RendererException("Failed inside SetShapeInfosPolylines", (Throwable)exc));
        }
    }

    private static ArrayList<ArrayList<Point2D>> createRenderablesFromShape(TGLight tg, Shape shape, int shapeType, Object clipArea) {
        ArrayList<Point2D.Double> ptsPoly = new ArrayList<Point2D.Double>();
        ArrayList<ArrayList<Point2D>> polylines2 = new ArrayList<ArrayList<Point2D>>();
        Point2D.Double ptPoly = null;
        try {
            float[] coords = new float[6];
            PathIterator i = shape.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                switch (type) {
                    case 0: {
                        if (ptsPoly.size() > 0) {
                            if (shapeType == ShapeInfo.SHAPE_TYPE_FILL && (((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getX() != ((Point2D)ptsPoly.get(0)).getX() || ((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getY() != ((Point2D)ptsPoly.get(0)).getY())) {
                                Point2D.Double pt2d = new Point2D.Double(((Point2D)ptsPoly.get(0)).getX(), ((Point2D)ptsPoly.get(0)).getY());
                                ptsPoly.add(pt2d);
                            }
                            if (ptsPoly.size() > 1) {
                                polylines2.add(ptsPoly);
                            }
                        }
                        ptsPoly = new ArrayList();
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        break;
                    }
                    case 1: {
                        ptPoly = new Point2D.Double(coords[0], coords[1]);
                        ptsPoly.add(ptPoly);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                i.next();
            }
            if (ptsPoly.size() > 1) {
                if (shapeType == ShapeInfo.SHAPE_TYPE_FILL && (((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getX() != ((Point2D)ptsPoly.get(0)).getX() || ((Point2D)ptsPoly.get(ptsPoly.size() - 1)).getY() != ((Point2D)ptsPoly.get(0)).getY())) {
                    Point2D.Double pt2d = new Point2D.Double(((Point2D)ptsPoly.get(0)).getX(), ((Point2D)ptsPoly.get(0)).getY());
                    ptsPoly.add(pt2d);
                }
                polylines2.add(ptsPoly);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"createRenderableFromShape", (Exception)new RendererException("Failed inside createRenderableFromShape", (Throwable)exc));
        }
        return polylines2;
    }

    protected static ArrayList<Point2D> expandPolygon(ArrayList<Point2D> pts, double expand) {
        ArrayList<Point2D.Double> lgPoly = null;
        try {
            int j = 0;
            Object destPts = null;
            boolean isClosed = false;
            if (pts.get(pts.size() - 1).getX() == pts.get(0).getX() && pts.get(pts.size() - 1).getY() == pts.get(0).getY()) {
                pts.remove(pts.size() - 1);
                isClosed = true;
            }
            ArrayList<POINT2> pts2 = clsUtility.Points2DToPOINT2(pts);
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt2 = null;
            POINT2 pt3 = null;
            double m = 0.0;
            double m1 = 0.0;
            double b = 0.0;
            double b1 = 0.0;
            ArrayList<Line2D.Double> lineSegments = new ArrayList<Line2D.Double>();
            for (j = 0; j < pts2.size() - 1; ++j) {
                pt0 = new POINT2(pts2.get(j));
                pt1 = new POINT2(pts2.get(j + 1));
                if (pt0.x != pt1.x) continue;
                pt1.x += 1.0;
                pts2.set(j + 1, pt1);
            }
            POINT2 ptn = pts2.get(pts2.size() - 1);
            pt0 = new POINT2(pts2.get(0));
            if (ptn.x == pt0.x) {
                ptn.x += 1.0;
                pts2.set(pts2.size() - 1, ptn);
            }
            pts2.add(pt0);
            Polygon poly = new Polygon();
            for (j = 0; j < pts2.size(); ++j) {
                poly.addPoint((int)pts2.get((int)j).x, (int)pts2.get((int)j).y);
            }
            Line2D.Double lineSegment = null;
            POINT2 midPt = null;
            for (j = 0; j < pts2.size() - 1; ++j) {
                pt0 = new POINT2(pts2.get(j));
                pt1 = new POINT2(pts2.get(j + 1));
                m = (pt0.y - pt1.y) / (pt0.x - pt1.x);
                if (Math.abs(m) < 1.0) {
                    pt2 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (int)2, (double)expand);
                    pt3 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt1, (int)2, (double)expand);
                    midPt = lineutility.MidPointDouble((POINT2)pt2, (POINT2)pt3, (int)0);
                    if (poly.contains(midPt.x, midPt.y)) {
                        pt2 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (int)3, (double)expand);
                        pt3 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt1, (int)3, (double)expand);
                    }
                } else {
                    pt2 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (int)0, (double)expand);
                    pt3 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt1, (int)0, (double)expand);
                    midPt = lineutility.MidPointDouble((POINT2)pt2, (POINT2)pt3, (int)0);
                    if (poly.contains(midPt.x, midPt.y)) {
                        pt2 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (int)1, (double)expand);
                        pt3 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt1, (int)1, (double)expand);
                    }
                }
                lineSegment = new Line2D.Double(pt2.x, pt2.y, pt3.x, pt3.y);
                lineSegments.add(lineSegment);
            }
            ArrayList<POINT2> expandPts = new ArrayList<POINT2>();
            Line2D thisLine = null;
            Line2D nextLine = null;
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            double x = 0.0;
            double y = 0.0;
            for (j = 0; j < lineSegments.size(); ++j) {
                thisLine = (Line2D)lineSegments.get(j);
                x1 = thisLine.getX1();
                y1 = thisLine.getY1();
                x2 = thisLine.getX2();
                y2 = thisLine.getY2();
                m = (y1 - y2) / (x1 - x2);
                b = y1 - m * x1;
                nextLine = j == lineSegments.size() - 1 ? (Line2D)lineSegments.get(0) : (Line2D)lineSegments.get(j + 1);
                x1 = nextLine.getX1();
                y1 = nextLine.getY1();
                x2 = nextLine.getX2();
                y2 = nextLine.getY2();
                m1 = (y1 - y2) / (x1 - x2);
                b1 = y1 - m1 * x1;
                if (m != m1) {
                    x = (b1 - b) / (m - m1);
                    y = m * x + b;
                } else {
                    x = thisLine.getX2();
                    y = thisLine.getY2();
                }
                expandPts.add(new POINT2(x, y));
            }
            lgPoly = new ArrayList<Point2D.Double>();
            for (j = 0; j < expandPts.size(); ++j) {
                lgPoly.add(new Point2D.Double(((POINT2)expandPts.get((int)j)).x, ((POINT2)expandPts.get((int)j)).y));
            }
            if (isClosed) {
                lgPoly.add(new Point2D.Double(((Point2D)lgPoly.get(0)).getX(), ((Point2D)lgPoly.get(0)).getY()));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"expandPolygon2", (Exception)new RendererException("Failed inside expandPolygon2", (Throwable)exc));
        }
        return lgPoly;
    }

    protected static ArrayList<Point2D> expandPolygon2(ArrayList<Point2D> pts, double expandX, double expandY) {
        ArrayList<Point2D> lgPoly = null;
        try {
            AffineTransform at = new AffineTransform();
            at.setToIdentity();
            double avgX = 0.0;
            double avgY = 0.0;
            double totalX = 0.0;
            double totalY = 0.0;
            int j = 0;
            boolean isClosed = false;
            if (pts.get(pts.size() - 1).getX() == pts.get(0).getX() && pts.get(pts.size() - 1).getY() == pts.get(0).getY()) {
                pts.remove(pts.size() - 1);
                isClosed = true;
            }
            for (j = 0; j < pts.size(); ++j) {
                totalX += pts.get(j).getX();
                totalY += pts.get(j).getY();
            }
            avgX = totalX / (double)pts.size();
            avgY = totalY / (double)pts.size();
            Point2D[] srcPts = new Point2D.Double[pts.size()];
            for (j = 0; j < pts.size(); ++j) {
                srcPts[j] = new Point2D.Double(pts.get(j).getX(), pts.get(j).getY());
            }
            Point2D[] destPts = new Point2D[pts.size()];
            at.translate(-avgY, -avgY);
            at.transform(srcPts, 0, destPts, 0, srcPts.length);
            at.setToIdentity();
            at.scale(expandX, expandY);
            at.transform(destPts, 0, destPts, 0, destPts.length);
            at.setToIdentity();
            at.translate(avgY, avgY);
            at.transform(destPts, 0, destPts, 0, destPts.length);
            lgPoly = new ArrayList<Point2D>();
            for (j = 0; j < destPts.length; ++j) {
                lgPoly.add(destPts[j]);
            }
            if (isClosed) {
                lgPoly.add(new Point2D.Double(destPts[0].getX(), destPts[0].getY()));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"expandPolygon", (Exception)new RendererException("Failed inside expandPolygon", (Throwable)exc));
        }
        return lgPoly;
    }

    private static ArrayList<ArrayList<Point2D>> ptsPolyToPtsPoly(TGLight tg, ArrayList<ArrayList<Point2D>> ptsPoly, Rectangle2D clipBounds) {
        ArrayList ptsPoly2 = null;
        try {
            if (JavaTacticalRenderer.clsUtility.IsChange1Area((int)tg.get_LineType(), null)) {
                return ptsPoly;
            }
            int j = 0;
            int k = 0;
            ArrayList<Point2D> pts = null;
            ArrayList<Point2D> addPts = null;
            Point2D pt0 = null;
            Point2D pt1 = null;
            Line2D.Double line = null;
            ptsPoly2 = new ArrayList();
            for (j = 0; j < ptsPoly.size(); ++j) {
                addPts = null;
                pts = ptsPoly.get(j);
                for (k = 0; k < pts.size() - 1; ++k) {
                    pt0 = pts.get(k);
                    pt1 = pts.get(k + 1);
                    line = new Line2D.Double(pt0, pt1);
                    if (!clipBounds.contains(pt0) && !clipBounds.contains(pt1)) {
                        if (!clipBounds.intersectsLine(line)) {
                            addPts = null;
                            continue;
                        }
                        if (addPts == null) {
                            addPts = new ArrayList<Point2D>();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        ptsPoly2.add(addPts);
                        addPts = null;
                        continue;
                    }
                    if (!clipBounds.contains(pt0) && clipBounds.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (clipBounds.contains(pt0) && clipBounds.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (!clipBounds.contains(pt0) || clipBounds.contains(pt1)) continue;
                    if (addPts == null) {
                        addPts = new ArrayList();
                        addPts.add(pt0);
                    }
                    if (!addPts.contains(pt0)) {
                        addPts.add(pt0);
                    }
                    addPts.add(pt1);
                    ptsPoly2.add(addPts);
                    addPts = null;
                }
                if (addPts == null || addPts.size() <= 0) continue;
                ptsPoly2.add(addPts);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ptsPolyToPtsPoly", (Exception)new RendererException("Failed inside ptsPolyToPtsPoly", (Throwable)exc));
        }
        return ptsPoly2;
    }

    private static ArrayList<ArrayList<Point2D>> ptsPolyToPtsPoly(TGLight tg, ArrayList<ArrayList<Point2D>> ptsPoly, ArrayList<Point2D> clipBounds) {
        ArrayList ptsPoly2 = null;
        try {
            if (JavaTacticalRenderer.clsUtility.IsChange1Area((int)tg.get_LineType(), null)) {
                return ptsPoly;
            }
            int j = 0;
            int k = 0;
            ArrayList<Point2D> pts = null;
            ArrayList<Point2D> addPts = null;
            Point2D pt0 = null;
            Point2D pt1 = null;
            Line2D.Double line = null;
            ptsPoly2 = new ArrayList();
            Polygon clipPoly = new Polygon();
            for (j = 0; j < clipBounds.size(); ++j) {
                clipPoly.addPoint((int)clipBounds.get(j).getX(), (int)clipBounds.get(j).getY());
            }
            for (j = 0; j < ptsPoly.size(); ++j) {
                addPts = null;
                pts = ptsPoly.get(j);
                for (k = 0; k < pts.size() - 1; ++k) {
                    pt0 = pts.get(k);
                    pt1 = pts.get(k + 1);
                    line = new Line2D.Double(pt0, pt1);
                    if (!clipPoly.contains(pt0) && !clipPoly.contains(pt1)) {
                        if (!clsUtilityGE.lineIntersectsClipArea(line, clipBounds)) {
                            addPts = null;
                            continue;
                        }
                        if (addPts == null) {
                            addPts = new ArrayList<Point2D>();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        ptsPoly2.add(addPts);
                        addPts = null;
                        continue;
                    }
                    if (!clipPoly.contains(pt0) && clipPoly.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (clipPoly.contains(pt0) && clipPoly.contains(pt1)) {
                        if (addPts == null) {
                            addPts = new ArrayList();
                            addPts.add(pt0);
                        }
                        if (!addPts.contains(pt0)) {
                            addPts.add(pt0);
                        }
                        addPts.add(pt1);
                        continue;
                    }
                    if (!clipPoly.contains(pt0) || clipPoly.contains(pt1)) continue;
                    if (addPts == null) {
                        addPts = new ArrayList();
                        addPts.add(pt0);
                    }
                    if (!addPts.contains(pt0)) {
                        addPts.add(pt0);
                    }
                    addPts.add(pt1);
                    ptsPoly2.add(addPts);
                    addPts = null;
                }
                if (addPts == null || addPts.size() <= 0) continue;
                ptsPoly2.add(addPts);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ptsPolyToPtsPoly", (Exception)new RendererException("Failed inside ptsPolyToPtsPoly", (Throwable)exc));
        }
        return ptsPoly2;
    }

    protected static void removeTrailingPoints(TGLight tg, Object clipArea) {
        try {
            boolean isClosed = JavaTacticalRenderer.clsUtility.isClosedPolygon((int)tg.get_LineType());
            if (isClosed) {
                return;
            }
            Polygon poly = new Polygon();
            Area area = null;
            Rectangle2D clipBounds = null;
            ArrayList clipPoints = null;
            Object pt2d = null;
            int j = 0;
            if (clipArea == null) {
                return;
            }
            if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipBounds = (Rectangle2D.Double)clipArea;
            } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                clipBounds = (Rectangle2D)clipArea;
            } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                clipPoints = (ArrayList)clipArea;
            }
            if (clipBounds != null) {
                clipPoints = new ArrayList();
                clipPoints.add(new Point2D.Double(clipBounds.getX(), clipBounds.getY()));
                clipPoints.add(new Point2D.Double(clipBounds.getX() + clipBounds.getWidth(), clipBounds.getY()));
                clipPoints.add(new Point2D.Double(clipBounds.getX() + clipBounds.getWidth(), clipBounds.getY() + clipBounds.getHeight()));
                clipPoints.add(new Point2D.Double(clipBounds.getX(), clipBounds.getY() + clipBounds.getHeight()));
                clipPoints.add(new Point2D.Double(clipBounds.getX(), clipBounds.getY()));
            }
            Point2D ptLast = (Point2D)clipPoints.get(clipPoints.size() - 1);
            Point2D pt02d = (Point2D)clipPoints.get(0);
            Object pt12d = null;
            if (pt02d.getX() != ptLast.getX() || pt02d.getY() != ptLast.getY()) {
                clipPoints.add(new Point2D.Double(pt02d.getX(), pt02d.getY()));
            }
            for (j = 0; j < clipPoints.size(); ++j) {
                pt02d = (Point2D)clipPoints.get(j);
                poly.addPoint((int)pt02d.getX(), (int)pt02d.getY());
            }
            area = new Area(poly);
            Line2D.Double line = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            boolean intersects = false;
            int frontIndex = 0;
            int backIndex = tg.Pixels.size() - 1;
            for (j = 0; j < tg.Pixels.size() - 1; ++j) {
                pt0 = (POINT2)tg.Pixels.get(j);
                pt1 = (POINT2)tg.Pixels.get(j + 1);
                line = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                intersects = clsUtilityGE.lineIntersectsClipArea(line, clipPoints);
                if (intersects) {
                    frontIndex = j;
                    break;
                }
                if (!area.contains(pt0.x, pt0.y) && !area.contains(pt1.x, pt1.y)) continue;
                frontIndex = j;
                break;
            }
            for (j = tg.Pixels.size() - 1; j > 0; --j) {
                pt0 = (POINT2)tg.Pixels.get(j);
                pt1 = (POINT2)tg.Pixels.get(j - 1);
                line = new Line2D.Double(pt0.x, pt0.y, pt1.x, pt1.y);
                intersects = clsUtilityGE.lineIntersectsClipArea(line, clipPoints);
                if (intersects) {
                    backIndex = j;
                    break;
                }
                if (!area.contains(pt0.x, pt0.y) && !area.contains(pt1.x, pt1.y)) continue;
                backIndex = j;
                break;
            }
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            for (j = frontIndex; j <= backIndex; ++j) {
                pt0 = new POINT2((POINT2)tg.Pixels.get(j));
                pts.add(pt0);
            }
            tg.Pixels = pts;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)"clsRenderer", (String)"removeTrailingPoints", (Exception)new RendererException("Failed inside removeTrailingPoints", (Throwable)exc));
        }
    }

    private static boolean lineIntersectsClipArea(Line2D line, ArrayList<Point2D> clipPts) {
        boolean result = false;
        try {
            int j = 0;
            Polygon poly = new Polygon();
            for (j = 0; j < clipPts.size(); ++j) {
                poly.addPoint((int)clipPts.get(j).getX(), (int)clipPts.get(j).getY());
            }
            if (poly.contains(line.getX1(), line.getY1())) {
                return true;
            }
            if (poly.contains(line.getX2(), line.getY2())) {
                return true;
            }
            Line2D.Double currentSegment = null;
            for (j = 0; j < clipPts.size() - 1; ++j) {
                currentSegment = new Line2D.Double(clipPts.get(j).getX(), clipPts.get(j).getY(), clipPts.get(j + 1).getX(), clipPts.get(j + 1).getY());
                if (!line.intersectsLine(currentSegment)) continue;
                return true;
            }
            Point2D pt0 = clipPts.get(0);
            Point2D ptLast = clipPts.get(clipPts.size() - 1);
            if ((pt0.getX() != ptLast.getX() || pt0.getY() != ptLast.getY()) && line.intersectsLine(currentSegment = new Line2D.Double(ptLast.getX(), ptLast.getY(), pt0.getX(), pt0.getY()))) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"lineIntersectsClipArea", (Exception)new RendererException("Failed inside lineIntersectsClipArea", (Throwable)exc));
        }
        return result;
    }

    protected static void buildHatchFills(TGLight tg, ArrayList<ShapeInfo> shapes) {
        try {
            if (shapes == null || shapes.size() == 0) {
                return;
            }
            int lineType = tg.get_LineType();
            int hatch = tg.get_FillStyle();
            int j = 0;
            int hatch2 = 0;
            Shape2 shape2 = null;
            int index = 0;
            if (!JavaTacticalRenderer.clsUtility.isClosedPolygon((int)lineType) && !JavaTacticalRenderer.clsUtility.IsChange1Area((int)lineType, null)) {
                switch (lineType) {
                    case 13000001: 
                    case 13000002: 
                    case 15000000: 
                    case 15000001: 
                    case 15000003: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (lineType) {
                case 22235000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 24324100: 
                case 24324200: 
                case 24324300: 
                case 24351000: 
                case 24352000: 
                case 24353000: 
                case 24361000: 
                case 24362000: 
                case 24363000: 
                case 221310000: {
                    hatch = 3;
                    break;
                }
                case 23115000: {
                    for (j = 0; j < shapes.size(); ++j) {
                        ShapeInfo shape = shapes.get(j);
                        Color color = shape.getLineColor();
                        if (color == null || shape.getLineColor().getRGB() != 0) continue;
                        shapes.remove(j);
                    }
                    hatch = 3;
                    break;
                }
                default: {
                    if (hatch > 0) break;
                    return;
                }
            }
            for (j = 0; j < shapes.size(); ++j) {
                shape2 = (Shape2)shapes.get(j);
                hatch2 = shape2.get_FillStyle();
                if (hatch2 != hatch) continue;
                index = j;
                break;
            }
            float hatchLineThickness = Math.round(tg.get_LineThickness() / 2);
            for (int k = 0; k < shapes.size(); ++k) {
                ShapeInfo shape = null;
                if (lineType == 243111000 || lineType == 243112000) {
                    shape = shapes.get(k);
                    shape2 = (Shape2)shapes.get(k);
                    hatch = shape2.get_FillStyle();
                } else {
                    shape = shapes.get(index);
                }
                if (hatch < 2) continue;
                if (hatch != 8) {
                    Shape2 shape3 = clsUtilityGE.buildHatchFill(tg, shape, hatch);
                    shape3.setStroke((Stroke)new BasicStroke(hatchLineThickness));
                    shape3.setLineColor(tg.get_LineColor());
                    shapes.add((ShapeInfo)shape3);
                } else {
                    Shape2 shapeBk = clsUtilityGE.buildHatchFill(tg, shape, 3);
                    Shape2 shapeFwd = clsUtilityGE.buildHatchFill(tg, shape, 2);
                    shapeBk.setStroke((Stroke)new BasicStroke(hatchLineThickness));
                    shapeBk.setLineColor(tg.get_LineColor());
                    shapes.add((ShapeInfo)shapeBk);
                    shapeFwd.setStroke((Stroke)new BasicStroke(hatchLineThickness));
                    shapeFwd.setLineColor(tg.get_LineColor());
                    shapes.add((ShapeInfo)shapeFwd);
                }
                if (lineType == 243111000 || lineType == 243112000) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"buildHatchFills", (Exception)new RendererException("Failed inside buildHatcHFills", (Throwable)exc));
        }
    }

    protected static Shape2 buildHatchFill(TGLight tg, ShapeInfo shape, int hatch) {
        Shape2 hatchLineShape = null;
        try {
            hatchLineShape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            Area hatchLineArea = null;
            Rectangle rect = shape.getBounds();
            double x0 = ((RectangularShape)rect).getX();
            double y0 = ((RectangularShape)rect).getY();
            double width = ((RectangularShape)rect).getWidth();
            double height = ((RectangularShape)rect).getHeight();
            if (width > height) {
                height = width;
            } else {
                width = height;
            }
            if (tg.get_UseHatchFill()) {
                hatchLineShape.moveTo(new POINT2(x0, y0));
                hatchLineShape.lineTo(new POINT2(x0 + width, y0));
                hatchLineShape.lineTo(new POINT2(x0 + width, y0 + width));
                hatchLineShape.lineTo(new POINT2(x0, y0 + width));
                hatchLineShape.set_Fillstyle(hatch);
                hatchLineShape.lineTo(new POINT2(x0, y0));
                Area shapeArea = new Area(shape.getShape());
                hatchLineArea = new Area(hatchLineShape.getShape());
                hatchLineArea.intersect(shapeArea);
                hatchLineShape.setShape((Shape)hatchLineArea);
                return hatchLineShape;
            }
            width *= 2.0;
            height *= 2.0;
            int horizLimit = 0;
            int vertLimit = 0;
            int j = 0;
            ArrayList<POINT2> vertPts = new ArrayList<POINT2>();
            ArrayList<POINT2> horizPts = new ArrayList<POINT2>();
            POINT2 vertPt = null;
            POINT2 horizPt = null;
            if (hatch == 3) {
                horizLimit = (int)(width / 20.0);
                vertLimit = (int)(height / 20.0);
                for (j = 0; j < vertLimit; ++j) {
                    vertPt = new POINT2(x0, y0 + (double)(20 * j));
                    vertPts.add(vertPt);
                }
                for (j = 0; j < horizLimit; ++j) {
                    horizPt = new POINT2(x0 + (double)(20 * j), y0);
                    horizPts.add(horizPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 - 10.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit; ++j) {
                    if (j % 2 == 0) {
                        hatchLineShape.lineTo((POINT2)vertPts.get(j));
                        hatchLineShape.lineTo((POINT2)horizPts.get(j));
                        continue;
                    }
                    hatchLineShape.lineTo((POINT2)horizPts.get(j));
                    hatchLineShape.lineTo((POINT2)vertPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 + width + 10.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + 20.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + 20.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0 - 10.0, y0 - 10.0));
            }
            if (hatch == 2) {
                horizLimit = (int)(width / 20.0);
                vertLimit = (int)(height / 20.0);
                width /= 2.0;
                for (j = 0; j < vertLimit; ++j) {
                    vertPt = new POINT2(x0 + width, y0 + (double)(20 * j));
                    vertPts.add(vertPt);
                }
                for (j = 0; j < horizLimit; ++j) {
                    horizPt = new POINT2(x0 + width - (double)(20 * j), y0);
                    horizPts.add(horizPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 + width + 10.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit; ++j) {
                    if (j % 2 == 0) {
                        hatchLineShape.lineTo((POINT2)vertPts.get(j));
                        hatchLineShape.lineTo((POINT2)horizPts.get(j));
                        continue;
                    }
                    hatchLineShape.lineTo((POINT2)horizPts.get(j));
                    hatchLineShape.lineTo((POINT2)vertPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 - 10.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 - 20.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 - 20.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + 10.0, y0 - 10.0));
            }
            if (hatch == 4) {
                horizLimit = (int)(width / 10.0);
                vertLimit = (int)(height / 10.0);
                for (j = 0; j < horizLimit; ++j) {
                    if (j % 2 == 0) {
                        vertPt = new POINT2(x0 + (double)(10 * j), y0);
                        vertPts.add(vertPt);
                        vertPt = new POINT2(x0 + (double)(10 * j), y0 + height);
                        vertPts.add(vertPt);
                        continue;
                    }
                    vertPt = new POINT2(x0 + (double)(10 * j), y0 + height);
                    vertPts.add(vertPt);
                    vertPt = new POINT2(x0 + (double)(10 * j), y0);
                    vertPts.add(vertPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 - 10.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit - 1; ++j) {
                    hatchLineShape.lineTo((POINT2)vertPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 + width + 10.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + 20.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + 20.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0 - 10.0, y0 - 10.0));
            }
            if (hatch == 5) {
                horizLimit = (int)(width / 10.0);
                vertLimit = (int)(height / 10.0);
                for (j = 0; j < vertLimit; ++j) {
                    if (j % 2 == 0) {
                        horizPt = new POINT2(x0, y0 + (double)(10 * j));
                        horizPts.add(horizPt);
                        horizPt = new POINT2(x0 + width, y0 + (double)(10 * j));
                        horizPts.add(horizPt);
                        continue;
                    }
                    horizPt = new POINT2(x0 + width, y0 + (double)(10 * j));
                    horizPts.add(horizPt);
                    horizPt = new POINT2(x0, y0 + (double)(10 * j));
                    horizPts.add(horizPt);
                }
                hatchLineShape.moveTo(new POINT2(x0 - 10.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0, y0));
                for (j = 0; j < vertLimit - 1; ++j) {
                    hatchLineShape.lineTo((POINT2)horizPts.get(j));
                }
                hatchLineShape.lineTo(new POINT2(x0 - 10.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 - 20.0, y0 + height + 10.0));
                hatchLineShape.lineTo(new POINT2(x0 - 20.0, y0 - 10.0));
                hatchLineShape.lineTo(new POINT2(x0 + width + 10.0, y0 - 10.0));
            }
            Area shapeArea = new Area(shape.getShape());
            hatchLineArea = new Area(hatchLineShape.getShape());
            hatchLineArea.intersect(shapeArea);
            hatchLineShape.setShape((Shape)hatchLineArea);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"buildHatchArea", (Exception)new RendererException("Failed inside buildHatchArea", (Throwable)exc));
        }
        return hatchLineShape;
    }

    protected static boolean segmentColorsSet(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 22121000: 
                case 25221000: 
                case 25222000: {
                    break;
                }
                default: {
                    return false;
                }
            }
            String strH = tg.get_H();
            if (strH == null || strH.isEmpty()) {
                return false;
            }
            String[] strs = strH.split(",");
            if (strs.length > 1) {
                return true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"segmentColorsSet", (Exception)new RendererException("Failed inside segmentColorsSet", (Throwable)exc));
        }
        return false;
    }

    protected static double getZoomFactor(Rectangle2D rect, ArrayList<Point2D> clipPoints, ArrayList<POINT2> pixels) {
        double factor = -1.0;
        try {
            if (pixels == null || pixels.size() < 2) {
                return factor;
            }
            if (clipPoints == null && rect == null) {
                return factor;
            }
            double maxLengthPixels = 0.0;
            double maxLengthClipArea = 0.0;
            double temp = 0.0;
            int j = 0;
            Point2D pt2d0 = null;
            Point2D pt2d1 = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            for (j = 0; j < pixels.size() - 1; ++j) {
                pt0 = pixels.get(j);
                temp = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)(pt1 = pixels.get(j + 1)));
                if (!(temp > maxLengthPixels)) continue;
                maxLengthPixels = temp;
            }
            temp = 0.0;
            if (clipPoints != null) {
                for (j = 0; j < clipPoints.size() - 1; ++j) {
                    pt2d0 = clipPoints.get(j);
                    pt2d1 = clipPoints.get(j + 1);
                    pt0 = new POINT2(pt2d0.getX(), pt2d0.getY());
                    pt1 = new POINT2(pt2d1.getX(), pt2d1.getY());
                    temp = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
                }
            } else if (rect != null && (temp = rect.getMaxX() - rect.getMinX()) < rect.getMaxY() - rect.getMinY()) {
                temp = rect.getMaxY() - rect.getMinY();
            }
            if (temp > maxLengthClipArea) {
                maxLengthClipArea = temp;
            }
            if (maxLengthPixels > 0.0 && maxLengthClipArea > 0.0) {
                factor = maxLengthClipArea / maxLengthPixels;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"getZoomFactor", (Exception)new RendererException("Failed inside getZoomFactor", (Throwable)exc));
        }
        return factor;
    }
}

