/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaLineArray;

import armyc2.c5isr.JavaLineArray.CELineArray;
import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.clsUtility;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import java.awt.BasicStroke;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public final class DISMSupport {
    private static final int LEFT_SIDE = 0;
    private static final int RIGHT_SIDE = 1;
    private static final int COLINEAR = 2;
    private static final double CONST_PI = Math.PI;
    private static final double maxLength = 100.0;
    private static final double minLength = 2.5;
    private static final String _className = "DISMSupport";

    private static double GetTGFontSize(double iLength) {
        double result = -1.0;
        try {
            result = iLength < 20.0 ? 0.0 : (iLength < 50.0 ? 1.0 : (iLength > 250.0 ? 3.0 : 2.0));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetTGFontSize", new RendererException("Failed inside GetTGFontSize", exc));
        }
        return result;
    }

    private static void ArcApproximationDouble(double left, double top, double right, double bottom, double startx, double starty, double endx, double endy, POINT2[] lpoints) {
        try {
            double temp;
            double dstartx = startx;
            double dstarty = starty;
            double dendx = endx;
            double dendy = endy;
            double a = 0.0;
            double b = 0.0;
            double ctrX = 0.0;
            double ctrY = 0.0;
            double angleIncrement = 0.0;
            double t = 0.0;
            int i = 0;
            if (left > right) {
                temp = left;
                left = right;
                right = temp;
            }
            if (top > bottom) {
                temp = top;
                top = bottom;
                bottom = temp;
            }
            a = (right - left) / 2.0;
            b = (bottom - top) / 2.0;
            ctrX = left + a;
            ctrY = top + b;
            double x1 = dstartx - ctrX;
            double x2 = dendx - ctrX;
            double y1 = ctrY - dstarty;
            double y2 = ctrY - dendy;
            double startAngle = y1 == 0.0 ? (x1 > 0.0 ? 0.0 : Math.PI) : (x1 == 0.0 ? (y1 > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan2(y1, x1));
            double endAngle = y2 == 0.0 ? (x2 > 0.0 ? 0.0 : Math.PI) : (x2 == 0.0 ? (y2 > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan2(y2, x2));
            if (endAngle <= startAngle) {
                endAngle += Math.PI * 2;
            }
            angleIncrement = (endAngle - startAngle) / 16.0;
            t = startAngle;
            while (i < 17) {
                lpoints[i].x = ctrX + a * Math.cos(t);
                lpoints[i].y = ctrY - b * Math.sin(t);
                t += angleIncrement;
                ++i;
            }
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ArcApproximationDouble", new RendererException("Failed inside ArcApproximationDouble", exc));
            return;
        }
    }

    private static void DrawOpenRectangleDouble(POINT2[] points, POINT2[] pointsCorner, POINT2[] resultpts) {
        try {
            POINT2 point_mid = new POINT2();
            int j = 0;
            point_mid.x = (points[0].x + points[1].x) / 2.0;
            point_mid.y = (points[0].y + points[1].y) / 2.0;
            pointsCorner[0].x = points[0].x - point_mid.x + points[2].x;
            pointsCorner[0].y = points[0].y - point_mid.y + points[2].y;
            pointsCorner[1].x = points[1].x - point_mid.x + points[2].x;
            pointsCorner[1].y = points[1].y - point_mid.y + points[2].y;
            resultpts[0] = new POINT2(points[1]);
            resultpts[1] = new POINT2(pointsCorner[1]);
            resultpts[2] = new POINT2(pointsCorner[0]);
            resultpts[3] = new POINT2(points[0]);
            for (j = 0; j < 4; ++j) {
                resultpts[j].style = 0;
            }
            resultpts[3].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawOpenRectangleDouble", new RendererException("Failed inside DrawOpenRectangleDouble", exc));
        }
    }

    private static int DetermineDirectionDouble(POINT2[] points) {
        int result = 0;
        try {
            double dP0P1M = 0.0;
            double iP0P1B = 0.0;
            if (points[0].x == points[1].x) {
                if (points[2].x < points[0].x) {
                    return 1;
                }
                return 0;
            }
            dP0P1M = (points[0].y - points[1].y) / (points[0].x - points[1].x);
            iP0P1B = points[0].y - dP0P1M * points[0].x;
            if ((points[2].y - iP0P1B) / dP0P1M > points[2].x) {
                return 1;
            }
            return 0;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DetermineDirectionDouble", new RendererException("Failed inside DetermineDirectionDouble", exc));
            return result;
        }
    }

    private static void CalcEndpieceDeltasDouble(POINT2[] points, ref<double[]> piDeltaX, ref<double[]> piDeltaY, double dAngleDelta) {
        try {
            POINT2 pntMid = new POINT2();
            double iDiagEOL_length = 0.0;
            double dAngle1 = 0.0;
            pntMid.x = (points[0].x + points[1].x) / 2.0;
            pntMid.y = (points[0].y + points[1].y) / 2.0;
            iDiagEOL_length = (Math.sqrt((points[1].x - points[0].x) * (points[1].x - points[0].x) + (points[1].y - points[0].y) * (points[1].y - points[0].y)) + Math.sqrt((points[2].x - pntMid.x) * (points[2].x - pntMid.x) + (points[2].y - pntMid.y) * (points[2].y - pntMid.y))) / 20.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 20.0 * DPIScaleFactor) {
                iDiagEOL_length = 20.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle1 = Math.atan2(points[2].y - pntMid.y, points[2].x - pntMid.x) + dAngleDelta;
            piDeltaX.value = new double[1];
            piDeltaY.value = new double[1];
            ((double[])piDeltaX.value)[0] = iDiagEOL_length * Math.cos(dAngle1);
            ((double[])piDeltaY.value)[0] = iDiagEOL_length * Math.sin(dAngle1);
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcEndpieceDeltasDouble", new RendererException("Failed inside CalcEndpieceDeltasDouble", exc));
            return;
        }
    }

    protected static int GetDelayGraphicEtcDouble(POINT2[] points, int lineType) {
        int counter = 0;
        try {
            POINT2[] savepoints = new POINT2[3];
            double iLength = 0.0;
            double iRadius = 0.0;
            double iDiagEOL_length = 0.0;
            double dAngle1 = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            POINT2 ptArcCenter = new POINT2();
            POINT2[] arcpoints = new POINT2[17];
            POINT2[] deltapoints = new POINT2[4];
            int j = 0;
            points[2] = lineutility.PointRelativeToLine(points[0], points[1], points[1], points[2]);
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(arcpoints);
            lineutility.InitializePOINT2Array(deltapoints);
            points[counter] = new POINT2(savepoints[0]);
            points[counter].style = 14;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 5;
            ++counter;
            iLength = Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y));
            iRadius = Math.sqrt((savepoints[2].x - savepoints[1].x) * (savepoints[2].x - savepoints[1].x) + (savepoints[2].y - savepoints[1].y) * (savepoints[2].y - savepoints[1].y)) / 2.0;
            iDiagEOL_length = (iLength + iRadius * 2.0) / 20.0;
            dAngle1 = lineType == 25344000 ? Math.atan2(points[2].y - points[1].y, points[2].x - points[1].x) : Math.atan2(points[1].y - points[0].y, points[1].x - points[0].x);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            ptArcCenter.x = (savepoints[1].x + savepoints[2].x) / 2.0;
            ptArcCenter.y = (savepoints[1].y + savepoints[2].y) / 2.0;
            boolean reverseArc = DISMSupport.ReverseDelayArc(savepoints);
            if (!reverseArc) {
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - iRadius, ptArcCenter.y - iRadius, ptArcCenter.x + iRadius, ptArcCenter.y + iRadius, savepoints[1].x, savepoints[1].y, savepoints[2].x, savepoints[2].y, arcpoints);
                if (lineType == 25344000) {
                    dAngle1 += 1.5707963267948966;
                }
            } else {
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - iRadius, ptArcCenter.y - iRadius, ptArcCenter.x + iRadius, ptArcCenter.y + iRadius, savepoints[2].x, savepoints[2].y, savepoints[1].x, savepoints[1].y, arcpoints);
                if (lineType == 25344000) {
                    dAngle1 -= 1.5707963267948966;
                }
            }
            iDeltaX1 = iDiagEOL_length * Math.cos(dAngle1 - 0.7853981633974483);
            iDeltaY1 = iDiagEOL_length * Math.sin(dAngle1 - 0.7853981633974483);
            iDeltaX2 = iDiagEOL_length * Math.cos(dAngle1 + 0.7853981633974483);
            iDeltaY2 = iDiagEOL_length * Math.sin(dAngle1 + 0.7853981633974483);
            if (lineType == 25344000) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[2], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints);
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints[j]);
                ++counter;
            }
            for (j = 0; j < 17; ++j) {
                points[counter] = new POINT2(arcpoints[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            if (lineType == 25344000) {
                points[counter] = lineutility.ExtendAlongLineDouble(savepoints[1], savepoints[2], iRadius * 2.0 - iDiagEOL_length, 0);
                points[++counter] = lineutility.ExtendAlongLineDouble(savepoints[1], savepoints[2], iRadius * 2.0 + iDiagEOL_length, 0);
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDelayGraphicEtcDouble", new RendererException("Failed inside GetDelayGraphicEtcDouble", exc));
        }
        return counter;
    }

    private static boolean IsEnvelopmentArcReversed(POINT2[] pPoints) {
        try {
            if (pPoints.length < 4) {
                return false;
            }
            POINT2[] ptsSeize = new POINT2[]{new POINT2(pPoints[1]), new POINT2(pPoints[2])};
            lineutility.CalcClockwiseCenterDouble(ptsSeize);
            double d = lineutility.CalcDistanceDouble(ptsSeize[0], pPoints[3]);
            ptsSeize[0] = new POINT2(pPoints[2]);
            ptsSeize[1] = new POINT2(pPoints[1]);
            lineutility.CalcClockwiseCenterDouble(ptsSeize);
            double dArcReversed = lineutility.CalcDistanceDouble(ptsSeize[0], pPoints[3]);
            return dArcReversed > d;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IsEnvelopmentArcReversed", new RendererException("IsEnvelopmentArcReversed", exc));
            return false;
        }
    }

    protected static int GetEnvelopmentGraphicDouble(POINT2[] points) {
        int counter = 0;
        try {
            double iLength = 0.0;
            double iRadius = 0.0;
            double iDiagEOL_length = 0.0;
            double dAngle1 = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            POINT2 ptArcCenter = new POINT2();
            POINT2[] arcpoints = new POINT2[17];
            POINT2[] deltapoints = new POINT2[4];
            int j = 0;
            lineutility.InitializePOINT2Array(arcpoints);
            lineutility.InitializePOINT2Array(deltapoints);
            boolean reverseArc = DISMSupport.IsEnvelopmentArcReversed(points);
            points[0].style = 14;
            ++counter;
            points[1].style = 5;
            ++counter;
            points[2] = lineutility.ClosestPointOnLine(points[0], lineutility.ExtendLine2Double(points[0], points[1], lineutility.CalcDistanceDouble(points[1], points[2]), 0), points[2]);
            iLength = Math.sqrt((points[1].x - points[0].x) * (points[1].x - points[0].x) + (points[1].y - points[0].y) * (points[1].y - points[0].y));
            iRadius = Math.sqrt((points[2].x - points[1].x) * (points[2].x - points[1].x) + (points[2].y - points[1].y) * (points[2].y - points[1].y)) / 2.0;
            iDiagEOL_length = (iLength + iRadius * 2.0) / 20.0;
            dAngle1 = Math.atan2(points[2].y - points[1].y, points[2].x - points[1].x);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            ptArcCenter.x = (points[1].x + points[2].x) / 2.0;
            ptArcCenter.y = (points[1].y + points[2].y) / 2.0;
            if (reverseArc) {
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - iRadius, ptArcCenter.y - iRadius, ptArcCenter.x + iRadius, ptArcCenter.y + iRadius, points[1].x, points[1].y, points[2].x, points[2].y, arcpoints);
                dAngle1 += 1.5707963267948966;
            } else {
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - iRadius, ptArcCenter.y - iRadius, ptArcCenter.x + iRadius, ptArcCenter.y + iRadius, points[2].x, points[2].y, points[1].x, points[1].y, arcpoints);
                dAngle1 -= 1.5707963267948966;
            }
            iDeltaX1 = iDiagEOL_length * Math.cos(dAngle1 - 0.7853981633974483);
            iDeltaY1 = iDiagEOL_length * Math.sin(dAngle1 - 0.7853981633974483);
            iDeltaX2 = iDiagEOL_length * Math.cos(dAngle1 + 0.7853981633974483);
            iDeltaY2 = iDiagEOL_length * Math.sin(dAngle1 + 0.7853981633974483);
            DISMSupport.DrawEndpieceDeltasDouble(points[2], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints[j]);
                ++counter;
            }
            for (j = 0; j < 17; ++j) {
                points[counter] = new POINT2(arcpoints[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetEnvelopmentGraphicDouble", new RendererException("Failed inside GetEnvelopmentGraphicDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMCoverDouble(POINT2[] points, int lineType) {
        int counter;
        block15: {
            counter = 0;
            try {
                POINT2 pt0 = new POINT2(points[0]);
                POINT2 pt1 = new POINT2(points[1]);
                POINT2 pt2 = new POINT2(points[2]);
                POINT2 pt3 = new POINT2();
                POINT2 pt4 = new POINT2();
                lineutility.LineRelativeToLine(pt1, pt2, pt0, pt3, pt4);
                lineutility.LineRelativeToLine(pt3, pt0, pt1, pt2, pt4);
                int quadrant = lineutility.GetQuadrantDouble(pt0, pt4);
                pt1 = new POINT2(points[1]);
                pt2 = new POINT2(points[2]);
                int sign = pt1.x < pt2.x && (quadrant == 1 || quadrant == 4) ? -1 : (pt1.x > pt2.x && (quadrant == 2 || quadrant == 3) ? -1 : 1);
                POINT2 initialPt = new POINT2(points[0]);
                initialPt.style = 0;
                POINT2 endPt0 = new POINT2(points[1]);
                endPt0.style = 0;
                POINT2 endPt1 = new POINT2(points[2]);
                endPt1.style = 0;
                double length1 = lineutility.CalcDistanceDouble(initialPt, endPt0);
                double length2 = lineutility.CalcDistanceDouble(initialPt, endPt1);
                length1 = Math.min(length1, length2);
                if (DISMSupport.GetTGFontSize(length1) > 0.0) {
                    double delta = length1 / 15.0;
                    double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
                    if (delta > 100.0 * DPIScaleFactor) {
                        delta = 100.0 * DPIScaleFactor;
                    }
                    if (delta < 2.5 * DPIScaleFactor) {
                        delta = 2.5 * DPIScaleFactor;
                    }
                    POINT2[] ptsJaggyLine = new POINT2[4];
                    lineutility.InitializePOINT2Array(ptsJaggyLine);
                    double angle0 = Math.atan2(initialPt.y - endPt0.y, initialPt.x - endPt0.x);
                    double deltaX0a = Math.cos(angle0 + (double)sign * Math.PI / 4.0) * delta;
                    double deltaY0a = Math.sin(angle0 + (double)sign * Math.PI / 4.0) * delta;
                    ptsJaggyLine[0] = new POINT2(initialPt);
                    if (lineType != 22139000) {
                        ptsJaggyLine[0].x -= 30.0 * Math.cos(angle0);
                        ptsJaggyLine[0].y -= 30.0 * Math.sin(angle0);
                    }
                    POINT2 midPt0 = lineutility.MidPointDouble(ptsJaggyLine[0], endPt0, 0);
                    ptsJaggyLine[1].x = midPt0.x - deltaX0a;
                    ptsJaggyLine[1].y = midPt0.y - deltaY0a;
                    ptsJaggyLine[2].x = midPt0.x + deltaX0a;
                    ptsJaggyLine[2].y = midPt0.y + deltaY0a;
                    ptsJaggyLine[3] = new POINT2(endPt0);
                    for (int j = 0; j < 4; ++j) {
                        points[counter] = new POINT2(ptsJaggyLine[j]);
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    double deltaX0b = Math.cos(angle0 - (double)sign * Math.PI / 4.0) * delta;
                    double deltaY0b = Math.sin(angle0 - (double)sign * Math.PI / 4.0) * delta;
                    ptsJaggyLine[0].x = ptsJaggyLine[3].x + deltaX0a;
                    ptsJaggyLine[0].y = ptsJaggyLine[3].y + deltaY0a;
                    ptsJaggyLine[1] = new POINT2(ptsJaggyLine[3]);
                    ptsJaggyLine[2].x = ptsJaggyLine[3].x + deltaX0b;
                    ptsJaggyLine[2].y = ptsJaggyLine[3].y + deltaY0b;
                    for (int j = 0; j < 3; ++j) {
                        points[counter] = new POINT2(ptsJaggyLine[j]);
                        points[counter].style = 0;
                        if (lineType == 22139000) {
                            points[counter].style = 9;
                        }
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    if (lineType == 22139000) {
                        points[counter - 1].style = 9;
                        points[counter] = new POINT2(points[counter - 3]);
                        points[counter].style = 10;
                        ++counter;
                    }
                    double angle1 = Math.atan2(initialPt.y - endPt1.y, initialPt.x - endPt1.x);
                    double deltaX1a = Math.cos(angle1 - (double)sign * Math.PI / 4.0) * delta;
                    double deltaY1a = Math.sin(angle1 - (double)sign * Math.PI / 4.0) * delta;
                    ptsJaggyLine[0] = new POINT2(initialPt);
                    if (lineType != 22139000) {
                        ptsJaggyLine[0].x -= 30.0 * Math.cos(angle1);
                        ptsJaggyLine[0].y -= 30.0 * Math.sin(angle1);
                    }
                    POINT2 midPt1 = lineutility.MidPointDouble(ptsJaggyLine[0], endPt1, 0);
                    ptsJaggyLine[1].x = midPt1.x - deltaX1a;
                    ptsJaggyLine[1].y = midPt1.y - deltaY1a;
                    ptsJaggyLine[2].x = midPt1.x + deltaX1a;
                    ptsJaggyLine[2].y = midPt1.y + deltaY1a;
                    ptsJaggyLine[3] = new POINT2(endPt1);
                    for (int j = 0; j < 4; ++j) {
                        points[counter] = new POINT2(ptsJaggyLine[j]);
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    double deltaX1b = Math.cos(angle1 + (double)sign * Math.PI / 4.0) * delta;
                    double deltaY1b = Math.sin(angle1 + (double)sign * Math.PI / 4.0) * delta;
                    ptsJaggyLine[0].x = ptsJaggyLine[3].x + deltaX1a;
                    ptsJaggyLine[0].y = ptsJaggyLine[3].y + deltaY1a;
                    ptsJaggyLine[1] = new POINT2(ptsJaggyLine[3]);
                    ptsJaggyLine[2].x = ptsJaggyLine[3].x + deltaX1b;
                    ptsJaggyLine[2].y = ptsJaggyLine[3].y + deltaY1b;
                    for (int j = 0; j < 3; ++j) {
                        points[counter] = new POINT2(ptsJaggyLine[j]);
                        points[counter].style = 0;
                        if (lineType == 22139000) {
                            points[counter].style = 9;
                        }
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    if (lineType == 22139000) {
                        points[counter - 1].style = 9;
                        points[counter] = new POINT2(points[counter - 3]);
                        points[counter].style = 10;
                        ++counter;
                    }
                    break block15;
                }
                points[0] = new POINT2(initialPt);
                points[0].style = 0;
                points[1] = new POINT2(endPt0);
                points[1].style = 5;
                points[2] = new POINT2(initialPt);
                points[2].style = 0;
                points[3] = new POINT2(endPt1);
                return 4;
            }
            catch (Exception exc) {
                ErrorLogger.LogException(_className, "GetDISMcoverDouble", new RendererException("Failed inside GetDISMCoverDouble", exc));
            }
        }
        return counter;
    }

    protected static int GetDISMCoverDoubleRevC(POINT2[] points, int linetype, int vblSaveCounter) {
        int counter;
        block36: {
            counter = 0;
            try {
                double dAngle0 = 0.0;
                double dDeltaX0 = 0.0;
                double dDeltaY0 = 0.0;
                double dDeltaX1 = 0.0;
                double dDeltaY1 = 0.0;
                double iLengthPt0Pt1 = 0.0;
                double iLengthPt0Pt2 = 0.0;
                double iDelta = 0.0;
                int j = 0;
                int t = 1;
                double iFontSize = 0.0;
                double iLetterOffset = 0.0;
                POINT2[] savepoints = new POINT2[3];
                POINT2[] pts = new POINT2[2];
                POINT2[] ptsJaggyLine = new POINT2[4];
                boolean goLeftThenRight = false;
                int sign = 1;
                POINT2[] origPoints = null;
                if (vblSaveCounter == 4) {
                    origPoints = new POINT2[4];
                    for (j = 0; j < vblSaveCounter; ++j) {
                        origPoints[j] = new POINT2(points[j]);
                    }
                    points[1] = origPoints[0];
                    points[2] = origPoints[3];
                    points[0].x = (origPoints[1].x + origPoints[2].x) / 2.0;
                    points[0].y = (origPoints[1].y + origPoints[2].y) / 2.0;
                }
                POINT2 pt0 = new POINT2(points[0]);
                POINT2 pt1 = new POINT2(points[1]);
                POINT2 pt2 = new POINT2(points[2]);
                POINT2 pt3 = new POINT2();
                POINT2 pt4 = new POINT2();
                lineutility.LineRelativeToLine(pt1, pt2, pt0, pt3, pt4);
                lineutility.LineRelativeToLine(pt3, pt0, pt1, pt2, pt4);
                int quadrant = lineutility.GetQuadrantDouble(pt0, pt4);
                pt1 = new POINT2(points[1]);
                pt2 = new POINT2(points[2]);
                if (pt1.x < pt2.x && quadrant == 1) {
                    sign = -1;
                } else if (pt1.x > pt2.x && quadrant == 2) {
                    sign = -1;
                } else if (pt1.x > pt2.x && quadrant == 3) {
                    sign = -1;
                } else if (pt1.x < pt2.x && quadrant == 4) {
                    sign = -1;
                }
                if (linetype == 22139000) {
                    t = 0;
                }
                if (points[1].x <= points[2].x) {
                    goLeftThenRight = true;
                }
                for (j = 0; j < 3; ++j) {
                    savepoints[j] = new POINT2(points[j]);
                    savepoints[j].style = 0;
                }
                lineutility.InitializePOINT2Array(pts);
                lineutility.InitializePOINT2Array(ptsJaggyLine);
                iLengthPt0Pt1 = Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y));
                iLengthPt0Pt2 = Math.sqrt((savepoints[2].x - savepoints[0].x) * (savepoints[2].x - savepoints[0].x) + (savepoints[2].y - savepoints[0].y) * (savepoints[2].y - savepoints[0].y));
                if (iLengthPt0Pt1 > iLengthPt0Pt2) {
                    iLengthPt0Pt1 = iLengthPt0Pt2;
                }
                if ((iFontSize = DISMSupport.GetTGFontSize(iLengthPt0Pt1)) > 0.0) {
                    iDelta = iLengthPt0Pt1 / 15.0;
                    double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
                    if (iDelta > 100.0 * DPIScaleFactor) {
                        iDelta = 100.0 * DPIScaleFactor;
                    }
                    if (iDelta < 2.5 * DPIScaleFactor) {
                        iDelta = 2.5 * DPIScaleFactor;
                    }
                    if (vblSaveCounter < 4) {
                        savepoints[0].x = goLeftThenRight ? (savepoints[0].x -= (double)(30 * t)) : (savepoints[0].x += (double)(30 * t));
                        iLetterOffset = 0.0;
                        ptsJaggyLine[0].x = savepoints[0].x - iLetterOffset * 2.0;
                        ptsJaggyLine[0].y = savepoints[0].y;
                        ptsJaggyLine[0].x -= iLetterOffset;
                        dAngle0 = Math.atan2(ptsJaggyLine[0].y - savepoints[1].y, ptsJaggyLine[0].x - savepoints[1].x);
                        pts[0].x = (ptsJaggyLine[0].x + savepoints[1].x) / 2.0;
                        pts[0].y = (ptsJaggyLine[0].y + savepoints[1].y) / 2.0;
                        dDeltaX0 = Math.cos(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        dDeltaY0 = Math.sin(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        ptsJaggyLine[1].x = pts[0].x - dDeltaX0;
                        ptsJaggyLine[1].y = pts[0].y - dDeltaY0;
                        ptsJaggyLine[2].x = pts[0].x + dDeltaX0;
                        ptsJaggyLine[2].y = pts[0].y + dDeltaY0;
                        ptsJaggyLine[3] = new POINT2(savepoints[1]);
                        for (j = 0; j < 4; ++j) {
                            points[counter] = new POINT2(ptsJaggyLine[j]);
                            ++counter;
                        }
                        points[counter - 1].style = 5;
                    } else {
                        ptsJaggyLine[0] = new POINT2(origPoints[1]);
                        dAngle0 = Math.atan2(ptsJaggyLine[0].y - origPoints[0].y, ptsJaggyLine[0].x - origPoints[0].x);
                        pts[0].x = (ptsJaggyLine[0].x + origPoints[0].x) / 2.0;
                        pts[0].y = (ptsJaggyLine[0].y + origPoints[0].y) / 2.0;
                        dDeltaX0 = Math.cos(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        dDeltaY0 = Math.sin(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        ptsJaggyLine[1].x = pts[0].x - dDeltaX0;
                        ptsJaggyLine[1].y = pts[0].y - dDeltaY0;
                        ptsJaggyLine[2].x = pts[0].x + dDeltaX0;
                        ptsJaggyLine[2].y = pts[0].y + dDeltaY0;
                        ptsJaggyLine[3] = new POINT2(origPoints[0]);
                        for (j = 0; j < 4; ++j) {
                            points[counter] = new POINT2(ptsJaggyLine[j]);
                            ++counter;
                        }
                        points[counter - 1].style = 5;
                    }
                    dDeltaX1 = Math.cos(dAngle0 - (double)sign * Math.PI / 4.0) * iDelta;
                    dDeltaY1 = Math.sin(dAngle0 - (double)sign * Math.PI / 4.0) * iDelta;
                    if (vblSaveCounter < 4) {
                        ptsJaggyLine[0].x = savepoints[1].x + dDeltaX0;
                        ptsJaggyLine[0].y = savepoints[1].y + dDeltaY0;
                    } else {
                        ptsJaggyLine[0].x = origPoints[0].x + dDeltaX0;
                        ptsJaggyLine[0].y = origPoints[0].y + dDeltaY0;
                    }
                    ptsJaggyLine[1] = vblSaveCounter < 4 ? new POINT2(savepoints[1]) : new POINT2(origPoints[0]);
                    if (vblSaveCounter < 4) {
                        ptsJaggyLine[2].x = savepoints[1].x + dDeltaX1;
                        ptsJaggyLine[2].y = savepoints[1].y + dDeltaY1;
                    } else {
                        ptsJaggyLine[2].x = origPoints[0].x + dDeltaX1;
                        ptsJaggyLine[2].y = origPoints[0].y + dDeltaY1;
                    }
                    for (j = 0; j < 3; ++j) {
                        points[counter] = new POINT2(ptsJaggyLine[j]);
                        points[counter].style = 0;
                        if (linetype == 22139000 || linetype == 25342900) {
                            points[counter].style = 9;
                        }
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    if (linetype == 22139000 || linetype == 25342900) {
                        points[counter - 1].style = 9;
                        points[counter] = new POINT2(points[counter - 3]);
                        points[counter].style = 10;
                        ++counter;
                    }
                    if (vblSaveCounter < 4) {
                        savepoints[0].x = goLeftThenRight ? (savepoints[0].x += (double)(60 * t)) : (savepoints[0].x -= (double)(60 * t));
                        ptsJaggyLine[0].x = savepoints[0].x + iLetterOffset * 2.0;
                        ptsJaggyLine[0].y = savepoints[0].y;
                        ptsJaggyLine[0].x += iLetterOffset;
                        dAngle0 = Math.atan2(ptsJaggyLine[0].y - savepoints[2].y, ptsJaggyLine[0].x - savepoints[2].x);
                        pts[0].x = (ptsJaggyLine[0].x + savepoints[2].x) / 2.0;
                        pts[0].y = (ptsJaggyLine[0].y + savepoints[2].y) / 2.0;
                        dDeltaX0 = Math.cos(dAngle0 - (double)sign * Math.PI / 4.0) * iDelta;
                        dDeltaY0 = Math.sin(dAngle0 - (double)sign * Math.PI / 4.0) * iDelta;
                        ptsJaggyLine[1].x = pts[0].x - dDeltaX0;
                        ptsJaggyLine[1].y = pts[0].y - dDeltaY0;
                        ptsJaggyLine[2].x = pts[0].x + dDeltaX0;
                        ptsJaggyLine[2].y = pts[0].y + dDeltaY0;
                        ptsJaggyLine[3] = new POINT2(savepoints[2]);
                        for (j = 0; j < 4; ++j) {
                            points[counter] = new POINT2(ptsJaggyLine[j]);
                            ++counter;
                        }
                        points[counter - 1].style = 5;
                        dDeltaX1 = Math.cos(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        dDeltaY1 = Math.sin(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        ptsJaggyLine[0].x = savepoints[2].x + dDeltaX0;
                        ptsJaggyLine[0].y = savepoints[2].y + dDeltaY0;
                        ptsJaggyLine[1] = savepoints[2];
                        ptsJaggyLine[2].x = savepoints[2].x + dDeltaX1;
                        ptsJaggyLine[2].y = savepoints[2].y + dDeltaY1;
                    } else {
                        ptsJaggyLine[0] = new POINT2(origPoints[2]);
                        dAngle0 = Math.atan2(ptsJaggyLine[0].y - origPoints[3].y, ptsJaggyLine[0].x - origPoints[3].x);
                        pts[0].x = (ptsJaggyLine[0].x + origPoints[3].x) / 2.0;
                        pts[0].y = (ptsJaggyLine[0].y + origPoints[3].y) / 2.0;
                        dDeltaX0 = Math.cos(dAngle0 - (double)sign * Math.PI / 4.0) * iDelta;
                        dDeltaY0 = Math.sin(dAngle0 - (double)sign * Math.PI / 4.0) * iDelta;
                        ptsJaggyLine[1].x = pts[0].x - dDeltaX0;
                        ptsJaggyLine[1].y = pts[0].y - dDeltaY0;
                        ptsJaggyLine[2].x = pts[0].x + dDeltaX0;
                        ptsJaggyLine[2].y = pts[0].y + dDeltaY0;
                        ptsJaggyLine[3] = new POINT2(origPoints[3]);
                        for (j = 0; j < 4; ++j) {
                            points[counter] = new POINT2(ptsJaggyLine[j]);
                            ++counter;
                        }
                        points[counter - 1].style = 5;
                        dDeltaX1 = Math.cos(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        dDeltaY1 = Math.sin(dAngle0 + (double)sign * Math.PI / 4.0) * iDelta;
                        ptsJaggyLine[0].x = origPoints[3].x + dDeltaX0;
                        ptsJaggyLine[0].y = origPoints[3].y + dDeltaY0;
                        ptsJaggyLine[1] = new POINT2(origPoints[3]);
                        ptsJaggyLine[2].x = origPoints[3].x + dDeltaX1;
                        ptsJaggyLine[2].y = origPoints[3].y + dDeltaY1;
                    }
                    for (j = 0; j < 3; ++j) {
                        points[counter] = new POINT2(ptsJaggyLine[j]);
                        points[counter].style = 0;
                        if (linetype == 22139000 || linetype == 25342900) {
                            points[counter].style = 9;
                        }
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    if (linetype == 22139000 || linetype == 25342900) {
                        points[counter - 1].style = 9;
                        points[counter] = new POINT2(points[counter - 3]);
                        points[counter].style = 10;
                        ++counter;
                    }
                    break block36;
                }
                points[0] = new POINT2(savepoints[0]);
                points[0].style = 0;
                points[1] = new POINT2(savepoints[1]);
                points[1].style = 5;
                points[2] = new POINT2(savepoints[0]);
                points[2].style = 0;
                points[3] = new POINT2(savepoints[2]);
                return 4;
            }
            catch (Exception exc) {
                ErrorLogger.LogException(_className, "GetDISMcoverDoubleRevC", new RendererException("Failed inside GetDISMCoverDoubleRevc", exc));
            }
        }
        return counter;
    }

    protected static int GetDISMBypassDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            int j = 0;
            POINT2[] pointsCorner = new POINT2[2];
            POINT2[] rectpts = new POINT2[4];
            POINT2[] savepoints = new POINT2[3];
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            ref<double[]> iDeltaX = new ref<double[]>();
            ref<double[]> iDeltaY = new ref<double[]>();
            int bPointsRight = 0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pointsCorner);
            lineutility.InitializePOINT2Array(rectpts);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            DISMSupport.DrawOpenRectangleDouble(savepoints, pointsCorner, rectpts);
            for (j = 0; j < 4; ++j) {
                points[counter] = rectpts[j];
                ++counter;
            }
            bPointsRight = DISMSupport.DetermineDirectionDouble(savepoints);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX, iDeltaY, 0.7853981633974483);
            if (savepoints[0].y - savepoints[1].y < 0.0) {
                if (bPointsRight != 0) {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
                } else {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
                }
            } else if (bPointsRight != 0) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints1[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints2[j]);
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMBypassDouble", new RendererException("Failed inside GetDISMBypassDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMBreachDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pointsCorner = new POINT2[2];
            POINT2[] rectpts = new POINT2[4];
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            ref<double[]> iDeltaX = new ref<double[]>();
            ref<double[]> iDeltaY = new ref<double[]>();
            int bPointsRight = 0;
            int j = 0;
            POINT2[] savepoints = new POINT2[3];
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pointsCorner);
            lineutility.InitializePOINT2Array(rectpts);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            DISMSupport.DrawOpenRectangleDouble(savepoints, pointsCorner, rectpts);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(rectpts[j]);
                ++counter;
            }
            bPointsRight = DISMSupport.DetermineDirectionDouble(savepoints);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX, iDeltaY, 0.7853981633974483);
            if (savepoints[0].y - savepoints[1].y < 0.0) {
                if (bPointsRight != 0) {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints2);
                } else {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints2);
                }
            } else if (bPointsRight != 0) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints2);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints2);
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints1[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints2[j]);
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMBreachDouble", new RendererException("Failed inside GetDISMBreachDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMCanalizeDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pointsCorner = new POINT2[2];
            POINT2[] rectpts = new POINT2[4];
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            int j = 0;
            ref<double[]> iDeltaX = new ref<double[]>();
            ref<double[]> iDeltaY = new ref<double[]>();
            int bPointsRight = 0;
            POINT2[] savepoints = new POINT2[3];
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pointsCorner);
            lineutility.InitializePOINT2Array(rectpts);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            DISMSupport.DrawOpenRectangleDouble(savepoints, pointsCorner, rectpts);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(rectpts[j]);
                ++counter;
            }
            bPointsRight = DISMSupport.DetermineDirectionDouble(savepoints);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX, iDeltaY, 0.7853981633974483);
            if (savepoints[0].y - savepoints[1].y < 0.0) {
                if (bPointsRight != 0) {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints2);
                } else {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints2);
                }
            } else if (bPointsRight != 0) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints2);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], -((double[])iDeltaY.value)[0], ((double[])iDeltaX.value)[0], deltapoints2);
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints1[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints2[j]);
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMCanalizeDouble", new RendererException("Failed inside GetDISMCanalizeDouble", exc));
        }
        return counter;
    }

    public static Shape2 getFDIShape(TGLight tg, POINT2 ptA, POINT2 ptC) {
        try {
            POINT2 midPt = lineutility.MidPointDouble(ptA, ptC, 0);
            double len = lineutility.CalcDistanceDouble(ptA, midPt);
            POINT2 ptB = lineutility.ExtendDirectedLine(ptA, ptC, midPt, 2, len);
            Shape2 shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            shape.moveTo(ptA);
            shape.lineTo(ptB);
            shape.lineTo(ptC);
            shape.set_Style(1);
            shape.setLineColor(tg.get_LineColor());
            BasicStroke stroke = clsUtility.getLineStroke(tg.get_LineThickness(), shape.get_Style(), 2, 0);
            shape.setStroke(stroke);
            return shape;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getFDIShape", new RendererException("Failed inside getFDIShape", exc));
            return null;
        }
    }

    public static Shape2 getFDIShape(TGLight tg, POINT2 ptA, POINT2 ptB, POINT2 ptC) {
        try {
            POINT2 midPt;
            double w = lineutility.CalcDistanceDouble(ptA, ptC) * 0.25;
            if (w < (double)tg.get_LineThickness() * 1.5) {
                w = (double)tg.get_LineThickness() * 1.5;
            }
            if ((w = lineutility.CalcDistanceDouble(midPt = lineutility.MidPointDouble(ptA = lineutility.ExtendLineDouble(ptC = lineutility.ExtendLineDouble(ptA, ptC, w), ptA, w), ptC, 0), ptB) * 0.5) < (double)tg.get_LineThickness() * 1.5) {
                w = (double)tg.get_LineThickness() * 1.5;
            }
            ptB = lineutility.ExtendLineDouble(midPt, ptB, w);
            Shape2 shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
            shape.moveTo(ptA);
            shape.lineTo(ptB);
            shape.lineTo(ptC);
            shape.set_Style(1);
            shape.setLineColor(tg.get_LineColor());
            BasicStroke stroke = clsUtility.getLineStroke(tg.get_LineThickness(), shape.get_Style(), 2, 0);
            shape.setStroke(stroke);
            return shape;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getFDIShape", new RendererException("Failed inside getFDIShape", exc));
            return null;
        }
    }

    protected static int GetDISMDisruptDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[2];
            POINT2[] ptsArrow = new POINT2[3];
            POINT2 ptCenter = new POINT2();
            int j = 0;
            POINT2[] savepoints = new POINT2[3];
            double dAngle1 = 0.0;
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            POINT2[] deltapoints3 = new POINT2[4];
            double iDiagEOL_length = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(ptsArrow);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            lineutility.InitializePOINT2Array(deltapoints3);
            points[counter] = new POINT2(savepoints[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 5;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 0;
            points[++counter] = new POINT2(savepoints[2]);
            points[counter].style = 5;
            ++counter;
            ptCenter.x = (savepoints[0].x + savepoints[1].x) / 2.0;
            ptCenter.y = (savepoints[0].y + savepoints[1].y) / 2.0;
            ptsArrow[0] = new POINT2(savepoints[2]);
            ptsArrow[1].x = ptCenter.x + (savepoints[2].x - savepoints[1].x) * 4.0 / 5.0;
            ptsArrow[1].y = ptCenter.y + (savepoints[2].y - savepoints[1].y) * 4.0 / 5.0;
            ptsArrow[2].x = savepoints[0].x + (savepoints[2].x - savepoints[1].x) * 3.0 / 5.0;
            ptsArrow[2].y = savepoints[0].y + (savepoints[2].y - savepoints[1].y) * 3.0 / 5.0;
            pts[0].x = ptCenter.x - (savepoints[2].x - savepoints[1].x) / 5.0;
            pts[0].y = ptCenter.y - (savepoints[2].y - savepoints[1].y) / 5.0;
            pts[1] = new POINT2(ptsArrow[1]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[0] = new POINT2(savepoints[0]);
            pts[1] = new POINT2(ptsArrow[2]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            iDiagEOL_length = (Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y)) + Math.sqrt((savepoints[2].x - savepoints[1].x) * (savepoints[2].x - savepoints[1].x) + (savepoints[2].y - savepoints[1].y) * (savepoints[2].y - savepoints[1].y))) / 15.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle1 = Math.atan2(savepoints[1].y - savepoints[2].y, savepoints[1].x - savepoints[2].x);
            iDeltaX1 = iDiagEOL_length * Math.cos(dAngle1 - 0.5235987755982988);
            iDeltaY1 = iDiagEOL_length * Math.sin(dAngle1 - 0.5235987755982988);
            iDeltaX2 = iDiagEOL_length * Math.cos(dAngle1 + 0.5235987755982988);
            iDeltaY2 = iDiagEOL_length * Math.sin(dAngle1 + 0.5235987755982988);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[0], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints1);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[1], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints2);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[2], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints3);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints1[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints2[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints3[j]);
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMDisruptDouble", new RendererException("Failed inside GetDISMDisruptDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMContainDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            double DPIScaleFactor;
            POINT2[] pts = new POINT2[3];
            POINT2 ptCenter = new POINT2();
            POINT2 ptPerp = new POINT2();
            double iPerpLength = 0.0;
            int j = 0;
            double dAngle1 = 0.0;
            double d = 0.0;
            double dCosAngle1 = 0.0;
            double dSinAngle1 = 0.0;
            double iRadius = 0.0;
            double iDiagEOL_length = 0.0;
            double dAngle2 = 0.0;
            POINT2[] savepoints = new POINT2[3];
            POINT2[] arcpoints = new POINT2[17];
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(arcpoints);
            ptCenter.x = (savepoints[0].x + savepoints[1].x) / 2.0;
            ptCenter.y = (savepoints[0].y + savepoints[1].y) / 2.0;
            ref<double[]> m = new ref<double[]>();
            POINT2 ptRelative = lineutility.PointRelativeToLine(savepoints[0], savepoints[1], savepoints[2]);
            lineutility.CalcTrueSlopeDouble2(savepoints[0], savepoints[1], m);
            if (((double[])m.value)[0] != 0.0) {
                if (savepoints[0].y > savepoints[1].y && ptRelative.x > ptCenter.x) {
                    lineutility.Reverse2Points(savepoints[0], savepoints[1]);
                }
                if (savepoints[0].y < savepoints[1].y && ptRelative.x < ptCenter.x) {
                    lineutility.Reverse2Points(savepoints[0], savepoints[1]);
                }
            } else {
                if (savepoints[0].x < savepoints[1].x && ptRelative.y > ptCenter.y) {
                    lineutility.Reverse2Points(savepoints[0], savepoints[1]);
                }
                if (savepoints[0].x > savepoints[1].x && ptRelative.y < ptCenter.y) {
                    lineutility.Reverse2Points(savepoints[0], savepoints[1]);
                }
            }
            if ((iPerpLength = Math.sqrt((ptCenter.x - savepoints[2].x) * (ptCenter.x - savepoints[2].x) + (ptCenter.y - savepoints[2].y) * (ptCenter.y - savepoints[2].y))) < 1.0) {
                iPerpLength = 1.0;
            }
            dAngle1 = Math.atan2(savepoints[0].y - savepoints[1].y, savepoints[0].x - savepoints[1].x);
            dCosAngle1 = Math.cos(dAngle1 + 1.5707963267948966);
            dSinAngle1 = Math.sin(dAngle1 + 1.5707963267948966);
            ptPerp.x = ptCenter.x + dCosAngle1 * iPerpLength;
            ptPerp.y = ptCenter.y + dSinAngle1 * iPerpLength;
            pts[0] = new POINT2(ptCenter);
            pts[1] = new POINT2(savepoints[2]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 14;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            iRadius = Math.sqrt((ptCenter.x - savepoints[0].x) * (ptCenter.x - savepoints[0].x) + (ptCenter.y - savepoints[0].y) * (ptCenter.y - savepoints[0].y));
            iDiagEOL_length = (iPerpLength + iRadius) / 20.0;
            if (iDiagEOL_length > 100.0 * (DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0)) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle2 = Math.atan2(ptPerp.y - ptCenter.y, ptPerp.x - ptCenter.x);
            double dDeltaX1 = Math.cos(dAngle2 + 0.7853981633974483);
            double dDeltaY1 = Math.sin(dAngle2 + 0.7853981633974483);
            double dDeltaX2 = Math.cos(dAngle2 - 0.7853981633974483);
            double dDeltaY2 = Math.sin(dAngle2 - 0.7853981633974483);
            pts[0].x = ptCenter.x + dDeltaX1 * iDiagEOL_length;
            pts[0].y = ptCenter.y + dDeltaY1 * iDiagEOL_length;
            pts[1] = new POINT2(ptCenter);
            pts[2].x = ptCenter.x + dDeltaX2 * iDiagEOL_length;
            pts[2].y = ptCenter.y + dDeltaY2 * iDiagEOL_length;
            for (j = 0; j < 3; ++j) {
                points[counter] = new POINT2(pts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            DISMSupport.ArcApproximationDouble(ptCenter.x - iRadius, ptCenter.y - iRadius, ptCenter.x + iRadius, ptCenter.y + iRadius, savepoints[0].x, savepoints[0].y, savepoints[1].x, savepoints[1].y, arcpoints);
            for (j = 0; j < 17; ++j) {
                points[counter] = new POINT2(arcpoints[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            pts[0] = new POINT2(savepoints[0]);
            pts[1].x = (pts[0].x + ptCenter.x) / 2.0;
            pts[1].y = (pts[0].y + ptCenter.y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0] = new POINT2(savepoints[1]);
            pts[1].x = (pts[0].x + ptCenter.x) / 2.0;
            pts[1].y = (pts[0].y + ptCenter.y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = ptCenter.x - (ptPerp.x - ptCenter.x) * iRadius / iPerpLength;
            pts[0].y = ptCenter.y - (ptPerp.y - ptCenter.y) * iRadius / iPerpLength;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = ptCenter.x - dDeltaX1 * iRadius;
            pts[0].y = ptCenter.y - dDeltaY1 * iRadius;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = ptCenter.x - dDeltaX2 * iRadius;
            pts[0].y = ptCenter.y - dDeltaY2 * iRadius;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            dDeltaX1 = Math.cos(dAngle2 + 0.39269908169872414);
            dDeltaY1 = Math.sin(dAngle2 + 0.39269908169872414);
            dDeltaX2 = Math.cos(dAngle2 - 0.39269908169872414);
            dDeltaY2 = Math.sin(dAngle2 - 0.39269908169872414);
            pts[0].x = ptCenter.x - dDeltaX1 * iRadius;
            pts[0].y = ptCenter.y - dDeltaY1 * iRadius;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = ptCenter.x - dDeltaX2 * iRadius;
            pts[0].y = ptCenter.y - dDeltaY2 * iRadius;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            dDeltaX1 = Math.cos(dAngle2 + 1.1780972450961724);
            dDeltaY1 = Math.sin(dAngle2 + 1.1780972450961724);
            dDeltaX2 = Math.cos(dAngle2 - 1.1780972450961724);
            dDeltaY2 = Math.sin(dAngle2 - 1.1780972450961724);
            pts[0].x = ptCenter.x - dDeltaX1 * iRadius;
            pts[0].y = ptCenter.y - dDeltaY1 * iRadius;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = ptCenter.x - dDeltaX2 * iRadius;
            pts[0].y = ptCenter.y - dDeltaY2 * iRadius;
            pts[1].x = (ptCenter.x + pts[0].x) / 2.0;
            pts[1].y = (ptCenter.y + pts[0].y) / 2.0;
            d = lineutility.CalcDistanceDouble(pts[0], pts[1]);
            if (d > 100.0 * DPIScaleFactor) {
                pts[1] = lineutility.ExtendLineDouble(pts[1], pts[0], -100.0 * DPIScaleFactor);
            }
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMContainDouble", new RendererException("Failed inside GetDISMContainDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMFixDouble(POINT2[] points, int linetype, Rectangle2D clipBounds) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[3];
            POINT2[] savepoints = new POINT2[2];
            double dAngle1 = 0.0;
            double dLength = 0.0;
            double dJaggyHalfAmp = 0.0;
            double dJaggyHalfPeriod = 0.0;
            double dDeltaXOut = 0.0;
            double dDeltaYOut = 0.0;
            double dDeltaXAlong = 0.0;
            double dDeltaYAlong = 0.0;
            int iNumJaggies = 0;
            int i = 0;
            int j = 0;
            for (j = 0; j < 2; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            Boolean drawJaggies = true;
            if (clipBounds != null) {
                POINT2 ul = new POINT2(clipBounds.getMinX(), clipBounds.getMinY());
                POINT2 lr = new POINT2(clipBounds.getMaxX(), clipBounds.getMaxY());
                savepoints = lineutility.BoundOneSegment(savepoints[0], savepoints[1], ul, lr);
            }
            if (savepoints == null) {
                savepoints = new POINT2[2];
                for (j = 0; j < 2; ++j) {
                    savepoints[j] = new POINT2(points[j]);
                }
                drawJaggies = false;
            }
            lineutility.InitializePOINT2Array(pts);
            dAngle1 = Math.atan2(savepoints[0].y - savepoints[1].y, savepoints[0].x - savepoints[1].x);
            dLength = Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y));
            dJaggyHalfAmp = dLength / 15.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (dJaggyHalfAmp > 100.0 * DPIScaleFactor) {
                dJaggyHalfAmp = 100.0 * DPIScaleFactor;
            }
            if (dJaggyHalfAmp < 2.5 * DPIScaleFactor) {
                dJaggyHalfAmp = 2.5 * DPIScaleFactor;
            }
            dJaggyHalfPeriod = dJaggyHalfAmp / 1.5;
            dDeltaXOut = Math.cos(dAngle1 + 1.5707963267948966) * dJaggyHalfAmp;
            dDeltaYOut = Math.sin(dAngle1 + 1.5707963267948966) * dJaggyHalfAmp;
            dDeltaXAlong = Math.cos(dAngle1) * dJaggyHalfPeriod;
            dDeltaYAlong = Math.sin(dAngle1) * dJaggyHalfPeriod;
            iNumJaggies = (int)(dLength / dJaggyHalfPeriod) - 3;
            i = 2;
            pts[0] = new POINT2(savepoints[1]);
            pts[1].x = savepoints[1].x + dDeltaXAlong * 1.5;
            pts[1].y = savepoints[1].y + dDeltaYAlong * 1.5;
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[0].x = savepoints[1].x + dDeltaXOut + dDeltaXAlong * (double)i;
            pts[0].y = savepoints[1].y + dDeltaYOut + dDeltaYAlong * (double)i;
            ++i;
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            if (drawJaggies.booleanValue()) {
                while (i <= iNumJaggies) {
                    pts[1].x = savepoints[1].x - dDeltaXOut + dDeltaXAlong * (double)i;
                    pts[1].y = savepoints[1].y - dDeltaYOut + dDeltaYAlong * (double)i;
                    pts[2].x = savepoints[1].x + dDeltaXOut + dDeltaXAlong * (double)(++i);
                    pts[2].y = savepoints[1].y + dDeltaYOut + dDeltaYAlong * (double)i;
                    ++i;
                    for (j = 0; j < 3; ++j) {
                        points[counter] = new POINT2(pts[j]);
                        points[counter].style = 0;
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    pts[0] = new POINT2(pts[2]);
                }
            }
            pts[1] = new POINT2(pts[0]);
            pts[0].x = savepoints[1].x + dDeltaXAlong * (double)i;
            pts[0].y = savepoints[1].y + dDeltaYAlong * (double)i;
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[1] = new POINT2(savepoints[0]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = savepoints[0].x + dDeltaXOut / 1.5 - dDeltaXAlong;
            pts[0].y = savepoints[0].y + dDeltaYOut / 1.5 - dDeltaYAlong;
            pts[2].x = savepoints[0].x - dDeltaXOut / 1.5 - dDeltaXAlong;
            pts[2].y = savepoints[0].y - dDeltaYOut / 1.5 - dDeltaYAlong;
            for (j = 0; j < 3; ++j) {
                points[counter] = new POINT2(pts[j]);
                points[counter].style = (long)linetype == 23172000L ? 9 : 0;
                ++counter;
            }
            points[counter - 1].style = (long)linetype == 23172000L ? 10 : 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMFixDouble", new RendererException("Failed inside GetDISMFixDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMClearDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] savepoints = new POINT2[3];
            int j = 0;
            POINT2[] pts = new POINT2[2];
            POINT2[] ptsArrow = new POINT2[3];
            double ctrX = (points[0].x + points[1].x) / 2.0;
            double ctrY = (points[0].y + points[1].y) / 2.0;
            ref<double[]> iDeltaX1 = new ref<double[]>();
            ref<double[]> iDeltaY1 = new ref<double[]>();
            ref<double[]> iDeltaX2 = new ref<double[]>();
            ref<double[]> iDeltaY2 = new ref<double[]>();
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            POINT2[] deltapoints3 = new POINT2[4];
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(ptsArrow);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            lineutility.InitializePOINT2Array(deltapoints3);
            points[counter] = new POINT2(savepoints[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 5;
            pts[0].x = ctrX;
            pts[0].y = ctrY;
            pts[1] = new POINT2(savepoints[2]);
            ptsArrow[0] = new POINT2(pts[0]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = (savepoints[0].x + ctrX) / 2.0;
            pts[0].y = (savepoints[0].y + ctrY) / 2.0;
            pts[1].x = savepoints[2].x + savepoints[0].x - pts[0].x;
            pts[1].y = savepoints[2].y + savepoints[0].y - pts[0].y;
            ptsArrow[1] = new POINT2(pts[0]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0].x = (savepoints[1].x + ctrX) / 2.0;
            pts[0].y = (savepoints[1].y + ctrY) / 2.0;
            pts[1].x = savepoints[2].x + savepoints[1].x - pts[0].x;
            pts[1].y = savepoints[2].y + savepoints[1].y - pts[0].y;
            ptsArrow[2] = new POINT2(pts[0]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX1, iDeltaY1, 0.5235987755982988);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX2, iDeltaY2, -0.5235987755982988);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[0], ((double[])iDeltaX1.value)[0], ((double[])iDeltaY1.value)[0], ((double[])iDeltaX2.value)[0], ((double[])iDeltaY2.value)[0], deltapoints1);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[1], ((double[])iDeltaX1.value)[0], ((double[])iDeltaY1.value)[0], ((double[])iDeltaX2.value)[0], ((double[])iDeltaY2.value)[0], deltapoints2);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[2], ((double[])iDeltaX1.value)[0], ((double[])iDeltaY1.value)[0], ((double[])iDeltaX2.value)[0], ((double[])iDeltaY2.value)[0], deltapoints3);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints1[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints2[j]);
                ++counter;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints3[j]);
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMClearDouble", new RendererException("Failed inside GetDISMClearDouble", exc));
        }
        return counter;
    }

    private static boolean IsSeizeArcReversed(POINT2[] pPoints) {
        try {
            double dAngle1 = Math.atan2(pPoints[0].y - pPoints[1].y, pPoints[0].x - pPoints[1].x);
            double dDeltaX1 = Math.cos(dAngle1 + 0.7853981633974483);
            double dDeltaY1 = Math.sin(dAngle1 + 0.7853981633974483);
            double dDeltaX2 = Math.cos(dAngle1 - 0.7853981633974483);
            double dDeltaY2 = Math.sin(dAngle1 - 0.7853981633974483);
            double dChordLength = Math.sqrt((pPoints[1].x - pPoints[0].x) * (pPoints[1].x - pPoints[0].x) + (pPoints[1].y - pPoints[0].y) * (pPoints[1].y - pPoints[0].y));
            double dArcRadius = dChordLength / 1.414213562373;
            POINT2 ptArcCenter = new POINT2();
            ptArcCenter.x = pPoints[0].x - dDeltaX1 * dArcRadius;
            ptArcCenter.y = pPoints[0].y - dDeltaY1 * dArcRadius;
            double d = lineutility.CalcDistanceDouble(ptArcCenter, pPoints[2]);
            POINT2 ptArcCenterReversed = new POINT2();
            ptArcCenterReversed.x = pPoints[0].x - dDeltaX2 * dArcRadius;
            ptArcCenterReversed.y = pPoints[0].y - dDeltaY2 * dArcRadius;
            double dReversed = lineutility.CalcDistanceDouble(ptArcCenterReversed, pPoints[2]);
            return dReversed > d;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "IsSeizeArcReversed", new RendererException("Failed inside IsSeizeArcReversed", exc));
            return false;
        }
    }

    protected static int GetDISMSeizeDouble(POINT2[] points, int linetype, double radius) {
        int counter = 0;
        try {
            POINT2 ptArcCenter = new POINT2();
            POINT2 ptArcStart = new POINT2();
            POINT2[] savepoints = new POINT2[3];
            float scale = 0.9f;
            double iCircleRadius = 25.0f * scale;
            POINT2[] arcpoints = new POINT2[17];
            POINT2[] pts = new POINT2[3];
            double dAngle1 = 0.0;
            double dDeltaX1 = 0.0;
            double dDeltaY1 = 0.0;
            double dDeltaX2 = 0.0;
            double dDeltaY2 = 0.0;
            double dChordLength = 0.0;
            double dArcRadius = 0.0;
            int j = 0;
            double dDeltaX3 = 0.0;
            double dDeltaY3 = 0.0;
            double iDiagEOL_length = 0.0;
            double factor = 1.0;
            if (radius > 0.0) {
                iCircleRadius = radius;
            }
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            String client = CELineArray.getClient();
            if (!client.startsWith("cpof") && radius == 0.0 && iCircleRadius > (dArcRadius = lineutility.CalcDistanceDouble(savepoints[0], savepoints[1])) / 2.0) {
                iCircleRadius = dArcRadius / 2.0;
            }
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(arcpoints);
            DISMSupport.ArcApproximationDouble(savepoints[0].x - iCircleRadius, savepoints[0].y - iCircleRadius, savepoints[0].x + iCircleRadius, savepoints[0].y + iCircleRadius, savepoints[0].x, savepoints[0].y, savepoints[0].x, savepoints[0].y, arcpoints);
            for (j = 0; j < 17; ++j) {
                points[counter] = new POINT2(arcpoints[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            dAngle1 = Math.atan2(savepoints[0].y - savepoints[1].y, savepoints[0].x - savepoints[1].x);
            dDeltaX1 = Math.cos(dAngle1 + 0.7853981633974483);
            dDeltaY1 = Math.sin(dAngle1 + 0.7853981633974483);
            dDeltaX2 = Math.cos(dAngle1 - 0.7853981633974483);
            dDeltaY2 = Math.sin(dAngle1 - 0.7853981633974483);
            boolean isArcReversed = DISMSupport.IsSeizeArcReversed(savepoints);
            if (!isArcReversed) {
                ptArcStart.x = savepoints[0].x - dDeltaX2 * iCircleRadius;
                ptArcStart.y = savepoints[0].y - dDeltaY2 * iCircleRadius;
                dChordLength = Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y));
                dArcRadius = dChordLength / 1.414213562373;
                ptArcCenter.x = savepoints[0].x - dDeltaX1 * dArcRadius;
                ptArcCenter.y = savepoints[0].y - dDeltaY1 * dArcRadius;
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - dArcRadius, ptArcCenter.y - dArcRadius, ptArcCenter.x + dArcRadius, ptArcCenter.y + dArcRadius, savepoints[1].x, savepoints[1].y, ptArcStart.x, ptArcStart.y, arcpoints);
                for (j = 0; j < 17; ++j) {
                    if (lineutility.CalcDistanceDouble(savepoints[0], arcpoints[j]) >= iCircleRadius) {
                        points[counter] = new POINT2(arcpoints[j]);
                        points[counter].style = 0;
                        ++counter;
                        continue;
                    }
                    if (j > 0) {
                        POINT2 intersectPt = lineutility.intersectPolygon(Arrays.copyOfRange(points, 0, 17), arcpoints[j], arcpoints[j - 1]);
                        if (intersectPt == null) {
                            intersectPt = arcpoints[j];
                        }
                        for (int k = j; k < 17; ++k) {
                            points[counter] = new POINT2(intersectPt);
                            points[counter].style = 0;
                            ++counter;
                        }
                    } else {
                        for (j = 0; j < 17; ++j) {
                            points[counter] = new POINT2(arcpoints[j]);
                            points[counter].style = 0;
                            ++counter;
                        }
                    }
                    break;
                }
            } else {
                ptArcStart.x = savepoints[0].x - dDeltaX1 * iCircleRadius;
                ptArcStart.y = savepoints[0].y - dDeltaY1 * iCircleRadius;
                dChordLength = Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y));
                dArcRadius = dChordLength / 1.414213562373;
                ptArcCenter.x = savepoints[0].x - dDeltaX2 * dArcRadius;
                ptArcCenter.y = savepoints[0].y - dDeltaY2 * dArcRadius;
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - dArcRadius, ptArcCenter.y - dArcRadius, ptArcCenter.x + dArcRadius, ptArcCenter.y + dArcRadius, ptArcStart.x, ptArcStart.y, savepoints[1].x, savepoints[1].y, arcpoints);
                boolean outsideCircle = false;
                for (j = 0; j < 17; ++j) {
                    if (!outsideCircle && !(lineutility.CalcDistanceDouble(savepoints[0], arcpoints[j]) >= iCircleRadius)) continue;
                    if (!outsideCircle && j > 0) {
                        POINT2 intersectPt = lineutility.intersectPolygon(Arrays.copyOfRange(points, 0, 17), arcpoints[j], arcpoints[j - 1]);
                        if (intersectPt == null) {
                            intersectPt = arcpoints[j - 1];
                        }
                        for (int k = 0; k < j; ++k) {
                            points[counter] = new POINT2(intersectPt);
                            points[counter].style = 0;
                            ++counter;
                        }
                    }
                    points[counter] = new POINT2(arcpoints[j]);
                    points[counter].style = 0;
                    ++counter;
                    outsideCircle = true;
                }
                if (!outsideCircle) {
                    for (j = 0; j < 17; ++j) {
                        points[counter] = new POINT2(arcpoints[j]);
                        points[counter].style = 0;
                        ++counter;
                    }
                }
            }
            points[counter - 1].style = 5;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (dChordLength / 8.0 > 100.0 * DPIScaleFactor) {
                factor = dChordLength / (800.0 * DPIScaleFactor);
            }
            if (factor == 0.0) {
                factor = 1.0;
            }
            if (!isArcReversed) {
                pts[0].x = savepoints[1].x - (savepoints[1].x - savepoints[0].x) / (8.0 * factor);
                pts[0].y = savepoints[1].y - (savepoints[1].y - savepoints[0].y) / (8.0 * factor);
                pts[1] = new POINT2(savepoints[1]);
                dDeltaX3 = Math.cos(dAngle1 + 1.5707963267948966);
                dDeltaY3 = Math.sin(dAngle1 + 1.5707963267948966);
                iDiagEOL_length = dChordLength / 8.0;
                pts[2].x = savepoints[1].x + dDeltaX3 * iDiagEOL_length / factor;
                pts[2].y = savepoints[1].y + dDeltaY3 * iDiagEOL_length / factor;
            } else {
                pts[0].x = savepoints[1].x - (savepoints[1].x - savepoints[0].x) / (8.0 * factor);
                pts[0].y = savepoints[1].y - (savepoints[1].y - savepoints[0].y) / (8.0 * factor);
                pts[1] = new POINT2(savepoints[1]);
                dDeltaX3 = Math.cos(dAngle1 - 1.5707963267948966);
                dDeltaY3 = Math.sin(dAngle1 - 1.5707963267948966);
                iDiagEOL_length = dChordLength / 8.0;
                pts[2].x = savepoints[1].x + dDeltaX3 * iDiagEOL_length / factor;
                pts[2].y = savepoints[1].y + dDeltaY3 * iDiagEOL_length / factor;
            }
            for (j = 0; j < 3; ++j) {
                points[counter] = new POINT2(pts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMSeizeDouble", new RendererException("Failed inside GetDISMSeizeDouble", exc));
        }
        return counter;
    }

    private static int side(double x1, double y1, double x2, double y2, double px, double py) {
        try {
            double dx1 = x2 - x1;
            double dy1 = y2 - y1;
            double dx2 = px - x1;
            double dy2 = py - y1;
            double o = dx1 * dy2 - dy1 * dx2;
            if (o > 0.0) {
                return 0;
            }
            if (o < 0.0) {
                return 1;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "side", new RendererException("Failed inside side", exc));
        }
        return 2;
    }

    protected static int GetDISMRIPDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[2];
            POINT2[] savepoints = new POINT2[4];
            int j = 0;
            double iLengthPt0Pt1 = 0.0;
            double iDiagEOL_length = 0.0;
            double dAngle1 = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            double iLengthPt2Pt3 = 0.0;
            double iRadius = 0.0;
            POINT2[] deltapoints = new POINT2[4];
            POINT2[] arcpoints = new POINT2[17];
            POINT2 ptArcCenter = new POINT2();
            boolean clockwise = false;
            int side01 = DISMSupport.side(points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
            int side12 = DISMSupport.side(points[1].x, points[1].y, points[2].x, points[2].y, points[3].x, points[3].y);
            if (side01 == 1 && side12 == 1) {
                clockwise = true;
            } else if (side01 == 1 && side12 == 2) {
                clockwise = true;
            } else if (side01 == 2 && side12 == 1) {
                clockwise = true;
            }
            for (j = 0; j < 4; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(deltapoints);
            lineutility.InitializePOINT2Array(arcpoints);
            points[counter] = new POINT2(savepoints[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 5;
            pts[0] = new POINT2(savepoints[2]);
            pts[1] = new POINT2(savepoints[3]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            pts[0] = new POINT2(savepoints[0]);
            pts[1] = new POINT2(savepoints[1]);
            iLengthPt0Pt1 = Math.sqrt((pts[1].x - pts[0].x) * (pts[1].x - pts[0].x) + (pts[1].y - pts[0].y) * (pts[1].y - pts[0].y));
            iDiagEOL_length = iLengthPt0Pt1 / 8.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle1 = Math.atan2(pts[1].y - pts[0].y, pts[1].x - pts[0].x);
            iDeltaX1 = iDiagEOL_length * Math.cos(dAngle1 - 0.7853981633974483);
            iDeltaY1 = iDiagEOL_length * Math.sin(dAngle1 - 0.7853981633974483);
            iDeltaX2 = iDiagEOL_length * Math.cos(dAngle1 + 0.7853981633974483);
            iDeltaY2 = iDiagEOL_length * Math.sin(dAngle1 + 0.7853981633974483);
            DISMSupport.DrawEndpieceDeltasDouble(pts[0], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(deltapoints[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 3].style = 5;
            points[counter - 1].style = 5;
            if (linetype != 25152800) {
                pts[0] = new POINT2(savepoints[2]);
                pts[1] = new POINT2(savepoints[3]);
                iLengthPt2Pt3 = Math.sqrt((pts[1].x - pts[0].x) * (pts[1].x - pts[0].x) + (pts[1].y - pts[0].y) * (pts[1].y - pts[0].y));
                iDiagEOL_length = iLengthPt2Pt3 / 8.0;
                if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                    iDiagEOL_length = 100.0 * DPIScaleFactor;
                }
                if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                    iDiagEOL_length = 2.5 * DPIScaleFactor;
                }
                dAngle1 = Math.atan2(pts[1].y - pts[0].y, pts[1].x - pts[0].x);
                iDeltaX1 = iDiagEOL_length * Math.cos(dAngle1 - 0.7853981633974483);
                iDeltaY1 = iDiagEOL_length * Math.sin(dAngle1 - 0.7853981633974483);
                iDeltaX2 = iDiagEOL_length * Math.cos(dAngle1 + 0.7853981633974483);
                iDeltaY2 = iDiagEOL_length * Math.sin(dAngle1 + 0.7853981633974483);
                DISMSupport.DrawEndpieceDeltasDouble(pts[0], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints);
                for (j = 0; j < 4; ++j) {
                    points[counter] = new POINT2(deltapoints[j]);
                    points[counter].style = 0;
                    ++counter;
                }
                points[counter - 3].style = 5;
                points[counter - 1].style = 5;
            }
            iRadius = Math.sqrt((savepoints[2].x - savepoints[1].x) * (savepoints[2].x - savepoints[1].x) + (savepoints[2].y - savepoints[1].y) * (savepoints[2].y - savepoints[1].y)) / 2.0;
            ptArcCenter.x = (savepoints[1].x + savepoints[2].x) / 2.0;
            ptArcCenter.y = (savepoints[1].y + savepoints[2].y) / 2.0;
            if (!clockwise) {
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - iRadius, ptArcCenter.y - iRadius, ptArcCenter.x + iRadius, ptArcCenter.y + iRadius, savepoints[2].x, savepoints[2].y, savepoints[1].x, savepoints[1].y, arcpoints);
            } else {
                DISMSupport.ArcApproximationDouble(ptArcCenter.x - iRadius, ptArcCenter.y - iRadius, ptArcCenter.x + iRadius, ptArcCenter.y + iRadius, savepoints[1].x, savepoints[1].y, savepoints[2].x, savepoints[2].y, arcpoints);
            }
            for (j = 0; j < 17; ++j) {
                points[counter] = new POINT2(arcpoints[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMRIPDouble", new RendererException("Failed inside GetDISMRIPDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMByDifDouble(POINT2[] points, int linetype, Rectangle2D clipBounds) {
        int counter = 0;
        try {
            double DPIScaleFactor;
            POINT2[] pointsCorner = new POINT2[2];
            POINT2[] rectpts = new POINT2[4];
            POINT2[] savepoints = new POINT2[3];
            POINT2[] savepoints2 = new POINT2[2];
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            POINT2[] pts = new POINT2[3];
            ref<double[]> iDeltaX = new ref<double[]>();
            ref<double[]> iDeltaY = new ref<double[]>();
            int bPointsRight = 0;
            double dAngle1 = 0.0;
            double dLength = 0.0;
            double dJaggyHalfAmp = 0.0;
            double dJaggyHalfPeriod = 0.0;
            double dDeltaXOut = 0.0;
            double dDeltaYOut = 0.0;
            double dDeltaXAlong = 0.0;
            double dDeltaYAlong = 0.0;
            int iNumJaggies = 0;
            int i = 0;
            int j = 0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pointsCorner);
            lineutility.InitializePOINT2Array(rectpts);
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            DISMSupport.DrawOpenRectangleDouble(savepoints, pointsCorner, rectpts);
            savepoints2[0] = new POINT2(rectpts[1]);
            savepoints2[1] = new POINT2(rectpts[2]);
            if (clipBounds != null) {
                POINT2 ul = new POINT2(clipBounds.getMinX(), clipBounds.getMinY());
                POINT2 lr = new POINT2(clipBounds.getMaxX(), clipBounds.getMaxY());
                savepoints2 = lineutility.BoundOneSegment(savepoints2[0], savepoints2[1], ul, lr);
            }
            Boolean drawJaggies = true;
            if (savepoints2 == null) {
                savepoints2 = new POINT2[]{new POINT2(rectpts[1]), new POINT2(rectpts[2])};
                drawJaggies = false;
            }
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(rectpts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[1].style = 5;
            points[counter - 1].style = 5;
            dAngle1 = Math.atan2(savepoints2[0].y - savepoints2[1].y, savepoints2[0].x - savepoints2[1].x);
            dLength = Math.sqrt((savepoints2[1].x - savepoints2[0].x) * (savepoints2[1].x - savepoints2[0].x) + (savepoints2[1].y - savepoints2[0].y) * (savepoints2[1].y - savepoints2[0].y));
            dJaggyHalfAmp = dLength / 15.0;
            if (dJaggyHalfAmp > 100.0 * (DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0)) {
                dJaggyHalfAmp = 100.0 * DPIScaleFactor;
            }
            if (dJaggyHalfAmp < 2.5 * DPIScaleFactor) {
                dJaggyHalfAmp = 2.5 * DPIScaleFactor;
            }
            dJaggyHalfPeriod = dJaggyHalfAmp / 1.5;
            dDeltaXOut = Math.cos(dAngle1 + 1.5707963267948966) * dJaggyHalfAmp;
            dDeltaYOut = Math.sin(dAngle1 + 1.5707963267948966) * dJaggyHalfAmp;
            dDeltaXAlong = Math.cos(dAngle1) * dJaggyHalfPeriod;
            dDeltaYAlong = Math.sin(dAngle1) * dJaggyHalfPeriod;
            iNumJaggies = (int)(dLength / dJaggyHalfPeriod) - 3;
            i = 2;
            pts[0] = new POINT2(savepoints2[1]);
            pts[1].x = savepoints2[1].x + dDeltaXAlong * 1.5;
            pts[1].y = savepoints2[1].y + dDeltaYAlong * 1.5;
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[0].x = savepoints2[1].x + dDeltaXOut + dDeltaXAlong * (double)i;
            pts[0].y = savepoints2[1].y + dDeltaYOut + dDeltaYAlong * (double)i;
            ++i;
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            if (drawJaggies.booleanValue()) {
                while (i <= iNumJaggies) {
                    pts[1].x = savepoints2[1].x - dDeltaXOut + dDeltaXAlong * (double)i;
                    pts[1].y = savepoints2[1].y - dDeltaYOut + dDeltaYAlong * (double)i;
                    pts[2].x = savepoints2[1].x + dDeltaXOut + dDeltaXAlong * (double)(++i);
                    pts[2].y = savepoints2[1].y + dDeltaYOut + dDeltaYAlong * (double)i;
                    ++i;
                    for (j = 0; j < 3; ++j) {
                        points[counter] = new POINT2(pts[j]);
                        points[counter].style = 0;
                        ++counter;
                    }
                    points[counter - 1].style = 5;
                    pts[0] = new POINT2(pts[2]);
                }
            }
            pts[1] = new POINT2(pts[0]);
            pts[0].x = savepoints2[1].x + dDeltaXAlong * (double)i;
            pts[0].y = savepoints2[1].y + dDeltaYAlong * (double)i;
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[1] = new POINT2(savepoints2[0]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            bPointsRight = DISMSupport.DetermineDirectionDouble(savepoints);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX, iDeltaY, 0.7853981633974483);
            if (savepoints[0].y - savepoints[1].y < 0.0) {
                if (bPointsRight != 0) {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
                } else {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
                }
            } else if (bPointsRight != 0) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
            }
            points[counter] = new POINT2(deltapoints1[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 10;
            points[++counter] = new POINT2(deltapoints2[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 10;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMByDifDouble", new RendererException("Failed inside GetDISMByDifDouble", exc));
        }
        return counter;
    }

    protected static void GetDISMPenetrateDouble(POINT2[] points, int linetype) {
        try {
            String client;
            POINT2[] arrowpts = new POINT2[3];
            POINT2 midpt = new POINT2();
            POINT2[] savepoints = new POINT2[3];
            int j = 0;
            double d = 0.0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(arrowpts);
            points[0].x = savepoints[0].x;
            points[0].y = savepoints[0].y;
            points[0].style = 0;
            points[1].x = savepoints[1].x;
            points[1].y = savepoints[1].y;
            points[1].style = 5;
            midpt = lineutility.MidPointDouble(savepoints[0], savepoints[1], 0);
            points[2] = new POINT2(savepoints[2]);
            points[3] = new POINT2(midpt);
            points[3].style = 5;
            d = lineutility.MBRDistance(savepoints, 3);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (d / 5.0 > 100.0 * DPIScaleFactor) {
                d = 500.0 * DPIScaleFactor;
            }
            if (d / 5.0 < 2.5 * DPIScaleFactor) {
                d = 12.5 * DPIScaleFactor;
            }
            if ((client = CELineArray.getClient()).matches("cpof3d") || client.matches("cpof2d")) {
                if (d < 400.0 * DPIScaleFactor) {
                    d = 400.0 * DPIScaleFactor;
                }
            } else if (d < 150.0 * DPIScaleFactor) {
                d = 150.0 * DPIScaleFactor;
            }
            if (d > 600.0 * DPIScaleFactor) {
                d = 600.0 * DPIScaleFactor;
            }
            lineutility.GetArrowHead4Double(points[2], points[3], (int)d / 20, (int)d / 20, arrowpts, 0);
            for (j = 0; j < 3; ++j) {
                points[4 + j] = new POINT2(arrowpts[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMPenetrateDouble", new RendererException("Failed inside GetDISMPenetrateDouble", exc));
        }
    }

    protected static int GetDISMByImpDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            int j = 0;
            POINT2[] pointsCorner = new POINT2[2];
            POINT2[] rectpts = new POINT2[4];
            POINT2[] savepoints = new POINT2[3];
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            POINT2 midpt = new POINT2();
            POINT2[] pts = new POINT2[6];
            POINT2 ptRelative = new POINT2();
            ref<double[]> iDeltaX = new ref<double[]>();
            ref<double[]> iDeltaY = new ref<double[]>();
            int bPointsRight = 0;
            double dMBR = lineutility.MBRDistance(points, 3);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (dMBR > 4000.0 * DPIScaleFactor) {
                dMBR = 4000.0 * DPIScaleFactor;
            }
            if (dMBR < 12.5 * DPIScaleFactor) {
                dMBR = 12.5 * DPIScaleFactor;
            }
            if (dMBR > 250.0 * DPIScaleFactor) {
                dMBR = 250.0 * DPIScaleFactor;
            }
            if (dMBR / 15.0 > lineutility.CalcDistanceDouble(points[0], points[1])) {
                dMBR = 15.0 * lineutility.CalcDistanceDouble(points[0], points[1]);
            }
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(rectpts);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            lineutility.InitializePOINT2Array(pts);
            lineutility.InitializePOINT2Array(pointsCorner);
            DISMSupport.DrawOpenRectangleDouble(savepoints, pointsCorner, rectpts);
            points[counter] = new POINT2(rectpts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(rectpts[1]);
            points[counter].style = 0;
            midpt = lineutility.MidPointDouble(rectpts[1], rectpts[2], 0);
            pts[0] = lineutility.ExtendLine2Double(rectpts[1], midpt, -dMBR / 30.0, 5);
            pts[1] = lineutility.ExtendLine2Double(rectpts[1], midpt, dMBR / 30.0, 5);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 5;
            ptRelative = lineutility.PointRelativeToLine(rectpts[0], rectpts[1], pts[0]);
            pts[2] = lineutility.ExtendLineDouble(ptRelative, pts[0], -dMBR / 30.0);
            pts[3] = lineutility.ExtendLineDouble(ptRelative, pts[0], dMBR / 30.0);
            points[++counter] = new POINT2(pts[2]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[3]);
            points[counter].style = 5;
            ptRelative = lineutility.PointRelativeToLine(rectpts[2], rectpts[3], pts[1]);
            pts[4] = lineutility.ExtendLineDouble(ptRelative, pts[1], -dMBR / 30.0);
            pts[5] = lineutility.ExtendLineDouble(ptRelative, pts[1], dMBR / 30.0);
            points[++counter] = new POINT2(pts[4]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[5]);
            points[counter].style = 5;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 0;
            points[++counter] = new POINT2(rectpts[2]);
            points[counter].style = 0;
            points[++counter] = new POINT2(rectpts[3]);
            points[counter].style = 5;
            ++counter;
            bPointsRight = DISMSupport.DetermineDirectionDouble(savepoints);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX, iDeltaY, 0.7853981633974483);
            if (savepoints[0].y - savepoints[1].y < 0.0) {
                if (bPointsRight != 0) {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
                } else {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
                }
            } else if (bPointsRight != 0) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
            }
            points[counter] = new POINT2(deltapoints1[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 10;
            points[++counter] = new POINT2(deltapoints2[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 10;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMByImpDouble", new RendererException("Failed inside GetDISMByImpDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMSupportByFireDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[3];
            POINT2[] savepoints = new POINT2[4];
            int j = 0;
            double iDiagEOL_length = 0.0;
            double dAngle1 = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            for (j = 0; j < 4; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            DISMSupport.ReorderSptByFirePoints(savepoints);
            lineutility.InitializePOINT2Array(pts);
            points[counter] = new POINT2(savepoints[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 5;
            pts[0] = new POINT2(savepoints[0]);
            pts[1] = new POINT2(savepoints[2]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            iDiagEOL_length = Math.sqrt((savepoints[0].x - savepoints[1].x) * (savepoints[0].x - savepoints[1].x) + (savepoints[0].y - savepoints[1].y) * (savepoints[0].y - savepoints[1].y)) / 10.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle1 = Math.atan2(savepoints[0].y - savepoints[2].y, savepoints[0].x - savepoints[2].x);
            iDeltaX1 = Math.cos(dAngle1 + 0.5235987755982988) * iDiagEOL_length;
            iDeltaY1 = Math.sin(dAngle1 + 0.5235987755982988) * iDiagEOL_length;
            iDeltaX2 = Math.cos(dAngle1 - 0.5235987755982988) * iDiagEOL_length;
            iDeltaY2 = Math.sin(dAngle1 - 0.5235987755982988) * iDiagEOL_length;
            pts[0].x = savepoints[2].x + iDeltaX1;
            pts[0].y = savepoints[2].y + iDeltaY1;
            pts[1] = new POINT2(savepoints[2]);
            pts[2].x = savepoints[2].x + iDeltaX2;
            pts[2].y = savepoints[2].y + iDeltaY2;
            for (j = 0; j < 3; ++j) {
                points[counter] = new POINT2(pts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            pts[0] = new POINT2(savepoints[1]);
            pts[1] = new POINT2(savepoints[3]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            dAngle1 = Math.atan2(savepoints[1].y - savepoints[3].y, savepoints[1].x - savepoints[3].x);
            iDeltaX1 = Math.cos(dAngle1 + 0.5235987755982988) * iDiagEOL_length;
            iDeltaY1 = Math.sin(dAngle1 + 0.5235987755982988) * iDiagEOL_length;
            iDeltaX2 = Math.cos(dAngle1 - 0.5235987755982988) * iDiagEOL_length;
            iDeltaY2 = Math.sin(dAngle1 - 0.5235987755982988) * iDiagEOL_length;
            pts[0].x = savepoints[3].x + iDeltaX1;
            pts[0].y = savepoints[3].y + iDeltaY1;
            pts[1] = new POINT2(savepoints[3]);
            pts[2].x = savepoints[3].x + iDeltaX2;
            pts[2].y = savepoints[3].y + iDeltaY2;
            for (j = 0; j < 3; ++j) {
                points[counter] = new POINT2(pts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            dAngle1 = Math.atan2(savepoints[1].y - savepoints[0].y, savepoints[1].x - savepoints[0].x);
            iDeltaX1 = Math.cos(dAngle1 - 0.7853981633974483) * (iDiagEOL_length *= 2.0);
            iDeltaY1 = Math.sin(dAngle1 - 0.7853981633974483) * iDiagEOL_length;
            iDeltaX2 = Math.cos(dAngle1 + 0.7853981633974483) * iDiagEOL_length;
            iDeltaY2 = Math.sin(dAngle1 + 0.7853981633974483) * iDiagEOL_length;
            pts[0].x = savepoints[0].x - iDeltaX1;
            pts[0].y = savepoints[0].y - iDeltaY1;
            pts[1] = new POINT2(savepoints[0]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[0].x = savepoints[1].x + iDeltaX2;
            pts[0].y = savepoints[1].y + iDeltaY2;
            pts[1] = new POINT2(savepoints[1]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMSupportbyFireDouble", new RendererException("Failed inside GetDISMSupportByFireDouble", exc));
        }
        return counter;
    }

    private static void ReorderAtkByFirePoints(POINT2[] points) {
        try {
            POINT2[] savepoints = new POINT2[3];
            POINT2 ptAboveLine = new POINT2();
            POINT2 ptBelowLine = new POINT2();
            POINT2 ptLeftOfLine = new POINT2();
            POINT2 ptRightOfLine = new POINT2();
            double distToLine = 0.0;
            double distanceToPointAboveLine = 0.0;
            double distanceToPointBelowLine = 0.0;
            double distanceToPointLeftOfLine = 0.0;
            double distanceToPointRightOfLine = 0.0;
            for (int j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            if (Math.abs(savepoints[1].x - savepoints[2].x) > 2.0) {
                distToLine = lineutility.CalcDistanceToLineDouble(savepoints[1], savepoints[2], savepoints[0]);
                ptAboveLine = lineutility.ExtendDirectedLine(savepoints[1], savepoints[2], savepoints[2], 2, distToLine);
                ptBelowLine = lineutility.ExtendDirectedLine(savepoints[1], savepoints[2], savepoints[2], 3, distToLine);
                distanceToPointAboveLine = lineutility.CalcDistanceDouble(savepoints[0], ptAboveLine);
                if (distanceToPointAboveLine < (distanceToPointBelowLine = lineutility.CalcDistanceDouble(savepoints[0], ptBelowLine))) {
                    if (savepoints[2].x < savepoints[1].x) {
                        lineutility.Reverse2Points(savepoints[1], savepoints[2]);
                    }
                } else if (savepoints[2].x > savepoints[1].x) {
                    lineutility.Reverse2Points(savepoints[1], savepoints[2]);
                }
            } else {
                distToLine = lineutility.CalcDistanceToLineDouble(savepoints[1], savepoints[2], savepoints[0]);
                ptLeftOfLine = lineutility.ExtendDirectedLine(savepoints[1], savepoints[2], savepoints[2], 0, distToLine);
                ptRightOfLine = lineutility.ExtendDirectedLine(savepoints[1], savepoints[2], savepoints[2], 1, distToLine);
                distanceToPointLeftOfLine = lineutility.CalcDistanceDouble(savepoints[0], ptLeftOfLine);
                distanceToPointRightOfLine = lineutility.CalcDistanceDouble(savepoints[0], ptRightOfLine);
                if (distanceToPointRightOfLine < distanceToPointLeftOfLine) {
                    if (savepoints[2].y < savepoints[1].y) {
                        lineutility.Reverse2Points(savepoints[1], savepoints[2]);
                    }
                } else if (savepoints[2].y > savepoints[1].y) {
                    lineutility.Reverse2Points(savepoints[1], savepoints[2]);
                }
            }
            points[1].x = savepoints[1].x;
            points[1].y = savepoints[1].y;
            points[2].x = savepoints[2].x;
            points[2].y = savepoints[2].y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReorderAtkByFirePoints", new RendererException("Failed inside GetDISMSupportByFireDouble", exc));
        }
    }

    private static void ReorderSptByFirePoints(POINT2[] points) {
        try {
            POINT2 ptAboveLine = new POINT2();
            POINT2 ptBelowLine = new POINT2();
            POINT2 ptLeftOfLine = new POINT2();
            POINT2 ptRightOfLine = new POINT2();
            double distToLine = 0.0;
            double distanceToPointAboveLine = 0.0;
            double distanceToPointBelowLine = 0.0;
            double distanceToPointLeftOfLine = 0.0;
            double distanceToPointRightOfLine = 0.0;
            POINT2 midpt = lineutility.MidPointDouble(points[0], points[1], 0);
            if (Math.abs(points[2].x - points[3].x) > 2.0) {
                distToLine = lineutility.CalcDistanceToLineDouble(points[1], points[2], midpt);
                ptAboveLine = lineutility.ExtendDirectedLine(points[1], points[2], points[2], 2, distToLine);
                ptBelowLine = lineutility.ExtendDirectedLine(points[1], points[2], points[2], 3, distToLine);
                distanceToPointAboveLine = lineutility.CalcDistanceDouble(points[0], ptAboveLine);
                if (distanceToPointAboveLine < (distanceToPointBelowLine = lineutility.CalcDistanceDouble(points[0], ptBelowLine))) {
                    if (points[2].x < points[1].x) {
                        lineutility.Reverse2Points(points[0], points[1]);
                        lineutility.Reverse2Points(points[2], points[3]);
                    }
                } else if (points[2].x > points[1].x) {
                    lineutility.Reverse2Points(points[0], points[1]);
                    lineutility.Reverse2Points(points[2], points[3]);
                }
            } else {
                distToLine = lineutility.CalcDistanceToLineDouble(points[1], points[2], midpt);
                ptLeftOfLine = lineutility.ExtendDirectedLine(points[1], points[2], points[2], 0, distToLine);
                ptRightOfLine = lineutility.ExtendDirectedLine(points[1], points[2], points[2], 1, distToLine);
                distanceToPointLeftOfLine = lineutility.CalcDistanceDouble(points[0], ptLeftOfLine);
                if (distanceToPointLeftOfLine < (distanceToPointRightOfLine = lineutility.CalcDistanceDouble(points[0], ptRightOfLine))) {
                    if (points[2].y > points[1].y) {
                        lineutility.Reverse2Points(points[0], points[1]);
                        lineutility.Reverse2Points(points[2], points[3]);
                    }
                } else if (points[2].y < points[1].y) {
                    lineutility.Reverse2Points(points[0], points[1]);
                    lineutility.Reverse2Points(points[2], points[3]);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReorderSptByFire", new RendererException("Failed inside ReorderSptByFirePoints", exc));
        }
    }

    protected static int GetDISMATKBYFIREDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[3];
            POINT2 ptMid = new POINT2();
            POINT2[] savepoints = new POINT2[3];
            int j = 0;
            double iDiagEOL_length = 0.0;
            double dAngle1 = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            DISMSupport.ReorderAtkByFirePoints(savepoints);
            lineutility.InitializePOINT2Array(pts);
            pts[0] = new POINT2(savepoints[1]);
            pts[1] = new POINT2(savepoints[2]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ptMid.x = (savepoints[1].x + savepoints[2].x) / 2.0;
            ptMid.y = (savepoints[1].y + savepoints[2].y) / 2.0;
            pts[0] = new POINT2(ptMid);
            pts[1] = new POINT2(savepoints[0]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            iDiagEOL_length = (Math.sqrt((savepoints[1].x - savepoints[2].x) * (savepoints[1].x - savepoints[2].x) + (savepoints[1].y - savepoints[2].y) * (savepoints[1].y - savepoints[2].y)) + Math.sqrt((savepoints[0].x - ptMid.x) * (savepoints[0].x - ptMid.x) + (savepoints[0].y - ptMid.y) * (savepoints[0].y - ptMid.y))) / 20.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iDiagEOL_length > 20.0 * DPIScaleFactor) {
                iDiagEOL_length = 20.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle1 = Math.atan2(ptMid.y - savepoints[0].y, ptMid.x - savepoints[0].x);
            iDeltaX1 = Math.cos(dAngle1 + 0.5235987755982988) * iDiagEOL_length;
            iDeltaY1 = Math.sin(dAngle1 + 0.5235987755982988) * iDiagEOL_length;
            iDeltaX2 = Math.cos(dAngle1 - 0.5235987755982988) * iDiagEOL_length;
            iDeltaY2 = Math.sin(dAngle1 - 0.5235987755982988) * iDiagEOL_length;
            pts[0].x = savepoints[0].x + iDeltaX1;
            pts[0].y = savepoints[0].y + iDeltaY1;
            pts[1] = new POINT2(savepoints[0]);
            pts[2].x = savepoints[0].x + iDeltaX2;
            pts[2].y = savepoints[0].y + iDeltaY2;
            for (j = 0; j < 3; ++j) {
                points[counter] = new POINT2(pts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            dAngle1 = Math.atan2(savepoints[1].y - savepoints[2].y, savepoints[1].x - savepoints[2].x);
            iDeltaX1 = Math.cos(dAngle1 - 0.7853981633974483) * iDiagEOL_length * 2.0;
            iDeltaY1 = Math.sin(dAngle1 - 0.7853981633974483) * iDiagEOL_length * 2.0;
            iDeltaX2 = Math.cos(dAngle1 + 0.7853981633974483) * iDiagEOL_length * 2.0;
            iDeltaY2 = Math.sin(dAngle1 + 0.7853981633974483) * iDiagEOL_length * 2.0;
            pts[0].x = savepoints[1].x + iDeltaX1;
            pts[0].y = savepoints[1].y + iDeltaY1;
            pts[1] = new POINT2(savepoints[1]);
            points[counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            pts[0].x = savepoints[2].x - iDeltaX2;
            pts[0].y = savepoints[2].y - iDeltaY2;
            pts[1] = new POINT2(savepoints[2]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMAtkByFireDouble", new RendererException("Failed inside GetDISMAtkByFireDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMGapDouble(POINT2[] points, int linetype) {
        try {
            POINT2[] savepoints = new POINT2[4];
            POINT2[] pts = new POINT2[2];
            int j = 0;
            double dMBR = lineutility.MBRDistance(points, 4);
            for (j = 0; j < 4; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(pts);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (dMBR / 10.0 > 100.0 * DPIScaleFactor) {
                dMBR = 1000.0 * DPIScaleFactor;
            }
            if (dMBR / 10.0 < 2.5 * DPIScaleFactor) {
                dMBR = 25.0 * DPIScaleFactor;
            }
            points[0] = new POINT2(savepoints[0]);
            points[0].style = 0;
            points[1] = new POINT2(savepoints[1]);
            points[1].style = 5;
            points[2] = new POINT2(savepoints[2]);
            points[2].style = 0;
            points[3] = new POINT2(savepoints[3]);
            points[3].style = 5;
            double dist = dMBR / 10.0;
            if (dist > 20.0 * DPIScaleFactor) {
                dist = 20.0 * DPIScaleFactor;
            }
            double dist2 = dist;
            pts[0] = lineutility.ExtendLineDouble(savepoints[1], savepoints[0], dist);
            pts[1] = lineutility.ExtendLineDouble(savepoints[2], savepoints[0], dist2);
            points[4] = new POINT2(points[0]);
            points[4].style = 0;
            points[5] = lineutility.MidPointDouble(pts[0], pts[1], 5);
            pts[0] = lineutility.ExtendLineDouble(savepoints[0], savepoints[1], dist);
            pts[1] = lineutility.ExtendLineDouble(savepoints[3], savepoints[1], dist2);
            points[6] = new POINT2(points[1]);
            points[6].style = 0;
            points[7] = lineutility.MidPointDouble(pts[0], pts[1], 5);
            pts[0] = lineutility.ExtendLineDouble(savepoints[0], savepoints[2], dist2);
            pts[1] = lineutility.ExtendLineDouble(savepoints[3], savepoints[2], dist);
            points[8] = new POINT2(points[2]);
            points[8].style = 0;
            points[9] = lineutility.MidPointDouble(pts[0], pts[1], 5);
            pts[0] = lineutility.ExtendLineDouble(savepoints[1], savepoints[3], dist2);
            pts[1] = lineutility.ExtendLineDouble(savepoints[2], savepoints[3], dist);
            points[10] = new POINT2(points[3]);
            points[10].style = 0;
            points[11] = lineutility.MidPointDouble(pts[0], pts[1], 5);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMGapDouble", new RendererException("Failed inside GetDISMGapDouble", exc));
        }
        return 12;
    }

    protected static int GetDISMMinefieldDisruptDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[2];
            POINT2[] ptsArrow = new POINT2[3];
            POINT2 ptCenter = new POINT2();
            int j = 0;
            POINT2[] savepoints = new POINT2[3];
            double dAngle1 = 0.0;
            double d = 0.0;
            double dist = 0.0;
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            POINT2[] deltapoints3 = new POINT2[4];
            double iDiagEOL_length = 0.0;
            double iDeltaX1 = 0.0;
            double iDeltaY1 = 0.0;
            double iDeltaX2 = 0.0;
            double iDeltaY2 = 0.0;
            POINT2 ptTail = new POINT2();
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(points[j]);
            }
            lineutility.InitializePOINT2Array(ptsArrow);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            lineutility.InitializePOINT2Array(deltapoints3);
            lineutility.InitializePOINT2Array(pts);
            points[counter] = new POINT2(savepoints[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(savepoints[1]);
            points[counter].style = 5;
            ++counter;
            ptCenter.x = (savepoints[0].x + savepoints[1].x) / 2.0;
            ptCenter.y = (savepoints[0].y + savepoints[1].y) / 2.0;
            ptsArrow[0] = new POINT2(savepoints[2]);
            ptsArrow[1].x = ptCenter.x + (savepoints[2].x - savepoints[0].x) * 4.0 / 5.0;
            ptsArrow[1].y = ptCenter.y + (savepoints[2].y - savepoints[0].y) * 4.0 / 5.0;
            ptsArrow[2].x = savepoints[1].x + (savepoints[2].x - savepoints[0].x) * 3.0 / 5.0;
            ptsArrow[2].y = savepoints[1].y + (savepoints[2].y - savepoints[0].y) * 3.0 / 5.0;
            points[counter] = new POINT2(savepoints[1]);
            points[counter].style = 0;
            points[++counter] = new POINT2(ptsArrow[2]);
            points[counter].style = 5;
            pts[1] = new POINT2(ptsArrow[1]);
            points[++counter] = new POINT2(ptCenter);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            d = dist = lineutility.CalcDistanceDouble(savepoints[2], savepoints[0]);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (d > 500.0 * DPIScaleFactor) {
                d = 500.0 * DPIScaleFactor;
            }
            if (d < 12.5 * DPIScaleFactor) {
                d = 12.5 * DPIScaleFactor;
            }
            ptTail = new POINT2(ptCenter);
            pts[0].x = ptTail.x - (savepoints[2].x - savepoints[0].x) / 5.0;
            pts[0].y = ptTail.y - (savepoints[2].y - savepoints[0].y) / 5.0;
            pts[0] = lineutility.ExtendLineDouble(pts[0], ptTail, -d / 5.0);
            points[counter] = new POINT2(ptTail);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 5;
            pts[0] = new POINT2(savepoints[0]);
            pts[1] = new POINT2(ptsArrow[0]);
            points[++counter] = new POINT2(pts[0]);
            points[counter].style = 0;
            points[++counter] = new POINT2(pts[1]);
            points[counter].style = 5;
            ++counter;
            iDiagEOL_length = (Math.sqrt((savepoints[1].x - savepoints[0].x) * (savepoints[1].x - savepoints[0].x) + (savepoints[1].y - savepoints[0].y) * (savepoints[1].y - savepoints[0].y)) + Math.sqrt((savepoints[2].x - savepoints[1].x) * (savepoints[2].x - savepoints[1].x) + (savepoints[2].y - savepoints[1].y) * (savepoints[2].y - savepoints[1].y))) / 15.0;
            if (iDiagEOL_length > 100.0 * DPIScaleFactor) {
                iDiagEOL_length = 100.0 * DPIScaleFactor;
            }
            if (iDiagEOL_length < 2.5 * DPIScaleFactor) {
                iDiagEOL_length = 2.5 * DPIScaleFactor;
            }
            dAngle1 = Math.atan2(savepoints[0].y - savepoints[2].y, savepoints[0].x - savepoints[2].x);
            iDeltaX1 = iDiagEOL_length * Math.cos(dAngle1 - 0.5235987755982988);
            iDeltaY1 = iDiagEOL_length * Math.sin(dAngle1 - 0.5235987755982988);
            iDeltaX2 = iDiagEOL_length * Math.cos(dAngle1 + 0.5235987755982988);
            iDeltaY2 = iDiagEOL_length * Math.sin(dAngle1 + 0.5235987755982988);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[0], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints1);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[1], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints2);
            DISMSupport.DrawEndpieceDeltasDouble(ptsArrow[2], iDeltaX1, iDeltaY1, iDeltaX2, iDeltaY2, deltapoints3);
            points[counter] = new POINT2(deltapoints1[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 10;
            points[++counter] = new POINT2(deltapoints2[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 10;
            points[++counter] = new POINT2(deltapoints3[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints3[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints3[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints3[3]);
            points[counter].style = 10;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMMinefieldDisruptDouble", new RendererException("Failed inside GetDISMMinefieldDisruptDouble", exc));
        }
        return counter;
    }

    protected static int GetDISMLinearTargetDouble(POINT2[] points, int linetype, int vblCounter) {
        int counter = 0;
        try {
            int j = 0;
            double dMBR = lineutility.MBRDistance(points, vblCounter - 4);
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (dMBR / 20.0 > 100.0 * DPIScaleFactor) {
                dMBR = 2000.0 * DPIScaleFactor;
            }
            if (dMBR / 20.0 < 2.5 * DPIScaleFactor) {
                dMBR = 50.0 * DPIScaleFactor;
            }
            if (dMBR < 150.0 * DPIScaleFactor) {
                dMBR = 150.0 * DPIScaleFactor;
            }
            if (dMBR > 250.0 * DPIScaleFactor) {
                dMBR = 250.0 * DPIScaleFactor;
            }
            for (j = 0; j < vblCounter - 4; ++j) {
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            points[counter] = lineutility.ExtendTrueLinePerpDouble(points[0], points[1], points[0], dMBR / 20.0, 0);
            points[++counter] = lineutility.ExtendTrueLinePerpDouble(points[0], points[1], points[0], -dMBR / 20.0, 5);
            points[++counter] = lineutility.ExtendTrueLinePerpDouble(points[vblCounter - 5], points[vblCounter - 6], points[vblCounter - 5], dMBR / 20.0, 0);
            points[++counter] = lineutility.ExtendTrueLinePerpDouble(points[vblCounter - 5], points[vblCounter - 6], points[vblCounter - 5], -dMBR / 20.0, 5);
            ++counter;
            if ((long)linetype == 24260000L) {
                points[0].style = 6;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMLinearTargetDouble", new RendererException("Failed inside GetDISMLinearTargetDouble", exc));
        }
        return counter;
    }

    protected static void GetDISMBlockDouble2(POINT2[] points, int linetype) {
        try {
            POINT2 ptRelative = new POINT2(points[2]);
            POINT2 midpt = lineutility.MidPointDouble(points[0], points[1], 0);
            boolean j = false;
            points[0].style = 0;
            points[1].style = 5;
            points[2] = new POINT2(midpt);
            points[3] = new POINT2(ptRelative);
            if ((long)linetype == 21100000L) {
                points[2].style = 14;
            }
            if ((long)linetype == 24260000L) {
                points[2].style = 6;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMBlockDouble2", new RendererException("Failed inside GetDISMBlockDouble2", exc));
        }
    }

    protected static void GetDISMPAADouble(POINT2[] points, int linetype) {
        try {
            POINT2 pt0 = new POINT2(points[0]);
            POINT2 pt1 = new POINT2(points[1]);
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 midpt = new POINT2();
            double d = lineutility.CalcDistanceDouble(pt0, pt1);
            midpt = lineutility.MidPointDouble(pt0, pt1, 0);
            pt2 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, midpt, d / 2.0, 0);
            pt3 = lineutility.ExtendTrueLinePerpDouble(pt0, pt1, midpt, -d / 2.0, 0);
            d = lineutility.CalcDistanceDouble(pt0, pt2);
            points[0] = new POINT2(pt0);
            points[0].style = 14;
            points[1] = new POINT2(pt2);
            points[1].style = 14;
            points[2] = new POINT2(pt1);
            points[2].style = 14;
            points[3] = new POINT2(pt3);
            points[3].style = 14;
            points[4] = new POINT2(pt0);
            points[4].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMPAADouble", new RendererException("Failed inside GetDISMPAADouble", exc));
        }
    }

    private static boolean ReverseDelayArc(POINT2[] points) {
        float upperBound;
        POINT2 pt1 = points[0];
        POINT2 pt2 = points[1];
        POINT2 pt3 = points[2];
        float lineAngle = DISMSupport.getAngleBetweenPoints(pt1.x, pt1.y, pt2.x, pt2.y);
        float curveAngle = DISMSupport.getAngleBetweenPoints(pt2.x, pt2.y, pt3.x, pt3.y);
        return !DISMSupport.isInRange(curveAngle, upperBound = curveAngle + 180.0f, lineAngle);
    }

    private static boolean isInRange(float min, float max, float targetAngle) {
        targetAngle = DISMSupport.normalizeAngle(targetAngle);
        if ((min = DISMSupport.normalizeAngle(min)) < (max = DISMSupport.normalizeAngle(max))) {
            return min <= targetAngle && targetAngle <= max;
        }
        return min <= targetAngle || targetAngle <= max;
    }

    private static float getAngleBetweenPoints(double x1, double y1, double x2, double y2) {
        return (float)Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
    }

    public static float normalizeAngle(float angle) {
        return (3600000.0f + angle) % 360.0f;
    }

    private static void DrawEndpieceDeltasDouble(POINT2 point, double iDelta1, double iDelta2, double iDelta3, double iDelta4, POINT2[] deltapoints) {
        try {
            deltapoints[0] = new POINT2(point);
            deltapoints[0].style = 0;
            deltapoints[1].x = point.x + iDelta1;
            deltapoints[1].y = point.y + iDelta2;
            deltapoints[1].style = 5;
            deltapoints[2] = new POINT2(point);
            deltapoints[2].style = 0;
            deltapoints[3].x = point.x + iDelta3;
            deltapoints[3].y = point.y + iDelta4;
            deltapoints[3].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DrawEndpieceDeltasDouble", new RendererException("Failed inside DrawEndpieceDeltasDouble", exc));
        }
    }

    protected static int GetDISMEasyDouble(POINT2[] points, int linetype) {
        int counter = 0;
        try {
            int j = 0;
            POINT2[] pointsCorner = new POINT2[2];
            POINT2[] rectpts = new POINT2[4];
            POINT2[] savepoints = new POINT2[3];
            POINT2[] deltapoints1 = new POINT2[4];
            POINT2[] deltapoints2 = new POINT2[4];
            ref<double[]> iDeltaX = new ref<double[]>();
            ref<double[]> iDeltaY = new ref<double[]>();
            int bPointsRight = 0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = points[j];
            }
            lineutility.InitializePOINT2Array(pointsCorner);
            lineutility.InitializePOINT2Array(rectpts);
            lineutility.InitializePOINT2Array(deltapoints1);
            lineutility.InitializePOINT2Array(deltapoints2);
            DISMSupport.DrawOpenRectangleDouble(savepoints, pointsCorner, rectpts);
            for (j = 0; j < 4; ++j) {
                points[counter] = new POINT2(rectpts[j]);
                points[counter].style = 0;
                ++counter;
            }
            points[counter - 1].style = 5;
            bPointsRight = DISMSupport.DetermineDirectionDouble(savepoints);
            DISMSupport.CalcEndpieceDeltasDouble(savepoints, iDeltaX, iDeltaY, 0.7853981633974483);
            if (savepoints[0].y - savepoints[1].y < 0.0) {
                if (bPointsRight != 0) {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
                } else {
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                    DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
                }
            } else if (bPointsRight != 0) {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], deltapoints2);
            } else {
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[0], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints1);
                DISMSupport.DrawEndpieceDeltasDouble(savepoints[1], ((double[])iDeltaX.value)[0], ((double[])iDeltaY.value)[0], ((double[])iDeltaY.value)[0], -((double[])iDeltaX.value)[0], deltapoints2);
            }
            points[counter] = new POINT2(deltapoints1[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints1[3]);
            points[counter].style = 10;
            points[++counter] = new POINT2(deltapoints2[1]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[0]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 9;
            points[++counter] = new POINT2(deltapoints2[3]);
            points[counter].style = 10;
            ++counter;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDISMEasyDouble", new RendererException("Failed inside GetDISMEasyDouble", exc));
        }
        return counter;
    }

    protected static int AmbushPointsDouble(POINT2[] pLinePoints) {
        int counter = 0;
        try {
            POINT2[] pts = new POINT2[3];
            POINT2[] savepoints = new POINT2[3];
            POINT2 ptMid = new POINT2();
            double dRadius = 0.0;
            double d = 0.0;
            double dAngle1 = 0.0;
            double dAngle1c = 0.0;
            double dAngle2c = 0.0;
            double dAngle12c = 0.0;
            double dAngle0 = 0.0;
            POINT2[] arcpoints = new POINT2[17];
            double dAngleTic = 0.0;
            double dDeltaX1 = 0.0;
            double dDeltaY1 = 0.0;
            double dDeltaX2 = 0.0;
            double dDeltaY2 = 0.0;
            POINT2 ptCenter = new POINT2();
            int j = 0;
            int i = 0;
            double iArrowLength = 0.0;
            for (j = 0; j < 3; ++j) {
                savepoints[j] = new POINT2(pLinePoints[j]);
            }
            lineutility.InitializePOINT2Array(arcpoints);
            lineutility.InitializePOINT2Array(pts);
            ptMid.x = (savepoints[1].x + savepoints[2].x) / 2.0;
            ptMid.y = (savepoints[1].y + savepoints[2].y) / 2.0;
            dRadius = Math.sqrt((ptMid.x - savepoints[2].x) * (ptMid.x - savepoints[2].x) + (ptMid.y - savepoints[2].y) * (ptMid.y - savepoints[2].y));
            double dRadius2 = Math.sqrt((ptMid.x - savepoints[1].x) * (ptMid.x - savepoints[1].x) + (ptMid.y - savepoints[1].y) * (ptMid.y - savepoints[1].y));
            dAngle1 = Math.atan2(savepoints[1].y - savepoints[2].y, savepoints[1].x - savepoints[2].x);
            ptCenter.x = ptMid.x + Math.cos(dAngle1 - 1.5707963267948966) * dRadius;
            ptCenter.y = ptMid.y + Math.sin(dAngle1 - 1.5707963267948966) * dRadius;
            double dAngle2 = Math.atan2(savepoints[2].y - savepoints[1].y, savepoints[2].x - savepoints[1].x);
            POINT2 ptCenter2 = new POINT2();
            ptCenter2.x = ptMid.x + Math.cos(dAngle2 - 1.5707963267948966) * dRadius;
            ptCenter2.y = ptMid.y + Math.sin(dAngle2 - 1.5707963267948966) * dRadius;
            double dist = lineutility.CalcDistanceDouble(savepoints[0], ptCenter);
            double dist2 = lineutility.CalcDistanceDouble(savepoints[0], ptCenter2);
            if (dist2 > dist) {
                POINT2 ptTemp = new POINT2(savepoints[1]);
                savepoints[1] = new POINT2(savepoints[2]);
                savepoints[2] = new POINT2(ptTemp);
                ptCenter = new POINT2(ptCenter2);
                dAngle1 = dAngle2;
            }
            dRadius = Math.sqrt((savepoints[1].x - ptCenter.x) * (savepoints[1].x - ptCenter.x) + (savepoints[1].y - ptCenter.y) * (savepoints[1].y - ptCenter.y));
            DISMSupport.ArcApproximationDouble(ptCenter.x - dRadius, ptCenter.y - dRadius, ptCenter.x + dRadius, ptCenter.y + dRadius, savepoints[2].x, savepoints[2].y, savepoints[1].x, savepoints[1].y, arcpoints);
            for (j = 0; j < 17; ++j) {
                pLinePoints[counter] = new POINT2(arcpoints[j]);
                pLinePoints[counter].style = 0;
                ++counter;
            }
            pLinePoints[counter - 1].style = 5;
            pts[0] = new POINT2(savepoints[0]);
            dAngle1c = Math.atan2(ptCenter.y - savepoints[1].y, ptCenter.x - savepoints[1].x);
            dAngle2c = Math.atan2(ptCenter.y - savepoints[2].y, ptCenter.x - savepoints[2].x);
            dAngle12c = (dAngle1c + dAngle2c) / 2.0;
            if (dAngle1c > 0.0 && dAngle2c < 0.0) {
                pts[1].x = ptCenter.x + Math.cos(dAngle12c) * dRadius;
                pts[1].y = ptCenter.y + Math.sin(dAngle12c) * dRadius;
            } else {
                pts[1].x = ptCenter.x - Math.cos(dAngle12c) * dRadius;
                pts[1].y = ptCenter.y - Math.sin(dAngle12c) * dRadius;
            }
            pLinePoints[counter] = new POINT2(pts[0]);
            pLinePoints[counter].style = 0;
            pLinePoints[++counter] = new POINT2(pts[1]);
            pLinePoints[counter].style = 5;
            ++counter;
            dAngle0 = Math.atan2(pts[1].y - savepoints[0].y, pts[1].x - savepoints[0].x);
            iArrowLength = (Math.sqrt((savepoints[1].x - savepoints[2].x) * (savepoints[1].x - savepoints[2].x) + (savepoints[1].y - savepoints[2].y) * (savepoints[1].y - savepoints[2].y)) + Math.sqrt((savepoints[0].x - ptMid.x) * (savepoints[0].x - ptMid.x) + (savepoints[0].y - ptMid.y) * (savepoints[0].y - ptMid.y))) / 20.0;
            double DPIScaleFactor = (double)RendererSettings.getInstance().getDeviceDPI() / 96.0;
            if (iArrowLength > 100.0 * DPIScaleFactor) {
                iArrowLength = 100.0 * DPIScaleFactor;
            }
            if (iArrowLength < 2.5 * DPIScaleFactor) {
                iArrowLength = 2.0 * DPIScaleFactor;
            }
            pts[0].x = savepoints[0].x + Math.cos(dAngle0 + 0.5235987755982988) * iArrowLength;
            pts[0].y = savepoints[0].y + Math.sin(dAngle0 + 0.5235987755982988) * iArrowLength;
            pts[1] = savepoints[0];
            pts[2].x = savepoints[0].x + Math.cos(dAngle0 - 0.5235987755982988) * iArrowLength;
            pts[2].y = savepoints[0].y + Math.sin(dAngle0 - 0.5235987755982988) * iArrowLength;
            for (j = 0; j < 3; ++j) {
                pLinePoints[counter] = new POINT2(pts[j]);
                pLinePoints[counter].style = 0;
                ++counter;
            }
            pLinePoints[counter - 1].style = 5;
            d = dRadius / 3.0;
            if (d > 100.0 * DPIScaleFactor) {
                d = 100.0 * DPIScaleFactor;
            }
            if (d < 2.5 * DPIScaleFactor) {
                d = 2.5 * DPIScaleFactor;
            }
            dAngleTic = 0.17453292519943295;
            dDeltaX2 = Math.cos(dAngle1 + 1.5707963267948966) * d;
            dDeltaY2 = Math.sin(dAngle1 + 1.5707963267948966) * d;
            for (i = 0; i < 8; ++i) {
                dDeltaX1 = Math.cos(dAngle1c += dAngleTic) * dRadius;
                dDeltaY1 = Math.sin(dAngle1c) * dRadius;
                pts[0].x = ptCenter.x - dDeltaX1;
                pts[0].y = ptCenter.y - dDeltaY1;
                pLinePoints[counter] = new POINT2(pts[0]);
                pLinePoints[counter].style = 0;
                pts[1].x = pts[0].x - dDeltaX2;
                pts[1].y = pts[0].y - dDeltaY2;
                pLinePoints[++counter] = new POINT2(pts[1]);
                pLinePoints[counter].style = 5;
                ++counter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "AmbushPointsDouble", new RendererException("Failed inside AmbushPointsDouble", exc));
        }
        return counter;
    }
}

