/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.JavaLineArray;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.arraysupport;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;

public final class lineutility {
    private static final String _className = "lineutility";
    public static final int extend_left = 0;
    public static final int extend_right = 1;
    public static final int extend_above = 2;
    public static final int extend_below = 3;

    protected static POINT2[] ResizeArray(POINT2[] pLinePoints, int length) {
        POINT2[] array = new POINT2[length];
        try {
            if (pLinePoints.length <= length) {
                return pLinePoints;
            }
            int j = 0;
            for (j = 0; j < length; ++j) {
                array[j] = new POINT2(pLinePoints[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ResizeArray", new RendererException("Failed inside ResizeArray", exc));
        }
        return array;
    }

    protected static void SegmentLineShape(POINT2 pt0, POINT2 pt1, Shape2 shape) {
        try {
            if (pt0 == null || pt1 == null) {
                return;
            }
            int j = 0;
            int n = 0;
            double dist = lineutility.CalcDistanceDouble(pt0, pt1);
            n = (int)(dist / 25.0);
            POINT2 pt = null;
            shape.lineTo(pt0);
            for (j = 1; j <= n; ++j) {
                pt = lineutility.ExtendAlongLineDouble(pt0, pt1, 25.0);
                shape.lineTo(pt);
            }
            shape.lineTo(pt1);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SegmentLineShape", new RendererException("Failed inside SegmentLineShape", exc));
        }
    }

    public static int GetDirAtkAirMiddleSegment(POINT2[] pLinePoints, int vblSaveCounter) {
        int middleSegment = -1;
        try {
            double d = 0.0;
            int k = 0;
            for (k = vblSaveCounter - 1; k > 0 && !((d += lineutility.CalcDistanceDouble(pLinePoints[k], pLinePoints[k - 1])) > 60.0); --k) {
            }
            middleSegment = d > 60.0 ? k : (vblSaveCounter <= 3 ? 1 : 2);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDirAtkAirMiddleSegment", new RendererException("Failed inside GetDirAtkAirMiddleSegment", exc));
        }
        return middleSegment;
    }

    protected static double CalcSegmentAngleDouble(POINT2 pt0, POINT2 pt1) {
        double dAngle = 0.0;
        try {
            int nTemp = 0;
            ref<double[]> m = new ref<double[]>();
            nTemp = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
            dAngle = nTemp == 0 ? 1.5707963267948966 : Math.atan(((double[])m.value)[0]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcSegmentAngleDouble", new RendererException("Failed inside CalcSegmentAngleDouble", exc));
        }
        return dAngle;
    }

    protected static void InitializePOINT2Array(POINT2[] pts) {
        if (pts == null || pts.length == 0) {
            return;
        }
        int n = pts.length;
        for (int j = 0; j < n; ++j) {
            pts[j] = new POINT2();
        }
    }

    protected static POINT2 CalcCenterPointDouble(POINT2[] pLinePoints, int vblCounter) {
        POINT2 CenterLinePoint = new POINT2(pLinePoints[0]);
        try {
            int j = 0;
            double dMinX = pLinePoints[0].x;
            double dMinY = pLinePoints[0].y;
            double dMaxX = pLinePoints[0].x;
            double dMaxY = pLinePoints[0].y;
            dMinX = pLinePoints[0].x;
            dMinY = pLinePoints[0].y;
            dMaxX = pLinePoints[0].x;
            dMaxY = pLinePoints[0].y;
            for (j = 0; j < vblCounter; ++j) {
                if (pLinePoints[j].x < dMinX) {
                    dMinX = pLinePoints[j].x;
                }
                if (pLinePoints[j].y < dMinY) {
                    dMinY = pLinePoints[j].y;
                }
                if (pLinePoints[j].x > dMaxX) {
                    dMaxX = pLinePoints[j].x;
                }
                if (!(pLinePoints[j].y > dMaxY)) continue;
                dMaxY = pLinePoints[j].y;
            }
            CenterLinePoint.x = (dMinX + dMaxX) / 2.0;
            CenterLinePoint.y = (dMinY + dMaxY) / 2.0;
        }
        catch (Error exc) {
            ErrorLogger.LogException(_className, "CalcCenterPointDouble", new RendererException("Failed inside CalcCenterPointDouble", exc));
        }
        return CenterLinePoint;
    }

    public static POINT2 CalcCenterPointDouble2(Object[] pLinePoints, int vblCounter) {
        POINT2 pt0 = (POINT2)pLinePoints[0];
        POINT2 CenterLinePoint = new POINT2();
        try {
            int j = 0;
            double dMinX = pt0.x;
            double dMinY = pt0.y;
            double dMaxX = pt0.x;
            double dMaxY = pt0.y;
            dMinX = pt0.x;
            dMinY = pt0.y;
            dMaxX = pt0.x;
            dMaxY = pt0.y;
            for (j = 0; j < vblCounter; ++j) {
                POINT2 pt = (POINT2)pLinePoints[j];
                if (pt.x < dMinX) {
                    dMinX = pt.x;
                }
                if (pt.y < dMinY) {
                    dMinY = pt.y;
                }
                if (pt.x > dMaxX) {
                    dMaxX = pt.x;
                }
                if (!(pt.y > dMaxY)) continue;
                dMaxY = pt.y;
            }
            CenterLinePoint.x = (dMinX + dMaxX) / 2.0;
            CenterLinePoint.y = (dMinY + dMaxY) / 2.0;
        }
        catch (Error exc) {
            ErrorLogger.LogException(_className, "CalcCenterPointDouble2", new RendererException("Failed inside CalcCenterPointDouble2", exc));
        }
        return CenterLinePoint;
    }

    public static double CalcDistanceDouble(POINT2 p1, POINT2 p2) {
        double returnValue = 0.0;
        try {
            returnValue = Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
            double xdist = Math.abs(p1.x - p2.x);
            double ydist = Math.abs(p1.y - p2.y);
            double max = xdist;
            if (ydist > xdist) {
                max = ydist;
            }
            if ((returnValue == 0.0 || Double.isInfinite(returnValue)) && max > 0.0) {
                returnValue = max;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcDistanceDouble", new RendererException("Failed inside CalcDistanceDouble", exc));
        }
        return returnValue;
    }

    public static double CalcDistanceDouble(Point2D p1, Point2D p2) {
        double returnValue = 0.0;
        try {
            returnValue = Math.sqrt((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY()));
            double xdist = Math.abs(p1.getX() - p2.getX());
            double ydist = Math.abs(p1.getY() - p2.getY());
            double max = xdist;
            if (ydist > xdist) {
                max = ydist;
            }
            if ((returnValue == 0.0 || Double.isInfinite(returnValue)) && max > 0.0) {
                returnValue = max;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcDistanceDouble", new RendererException("Failed inside CalcDistanceDouble", exc));
        }
        return returnValue;
    }

    protected static int CalcTrueSlopeDouble(POINT2 firstLinePoint, POINT2 lastLinePoint, ref<double[]> slope) {
        int result = 1;
        try {
            if (slope.value == null) {
                slope.value = new double[1];
            }
            double deltaX = 0.0;
            double deltaY = 0.0;
            deltaX = firstLinePoint.x - lastLinePoint.x;
            if (Math.abs(deltaX) < 1.0) {
                deltaX = deltaX >= 0.0 ? 1.0 : -1.0;
                result = 1;
            }
            deltaY = firstLinePoint.y - lastLinePoint.y;
            ((double[])slope.value)[0] = deltaY / deltaX;
        }
        catch (Error exc) {
            ErrorLogger.LogException(_className, "CalcTrueSlopeDouble", new RendererException("Failed inside CalcTrueSlopeDouble", exc));
        }
        return result;
    }

    public static void WriteFile(String str) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("Test.txt"));
            bufferedWriter.write(str);
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "WriteFile", new RendererException("Failed inside WriteFile", exc));
        }
    }

    protected static void ReversePointsDouble2(POINT2[] pLowerLinePoints, int vblCounter) {
        try {
            POINT2[] pResultPoints = new POINT2[vblCounter];
            int k = 0;
            for (k = 0; k < vblCounter; ++k) {
                pResultPoints[k] = new POINT2(pLowerLinePoints[vblCounter - k - 1]);
            }
            for (k = 0; k < vblCounter; ++k) {
                pLowerLinePoints[k] = new POINT2(pResultPoints[k]);
            }
            pResultPoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ReversePointsDouble2", new RendererException("Failed inside ReversePointsDouble2", exc));
        }
    }

    public static boolean CalcTrueSlopeDoubleForRoutes(POINT2 firstLinePoint, POINT2 lastLinePoint, ref<double[]> slope) {
        try {
            double deltaX = 0.0;
            double deltaY = 0.0;
            deltaX = firstLinePoint.x - lastLinePoint.x;
            if (Math.abs(deltaX) < 2.0) {
                return false;
            }
            deltaY = firstLinePoint.y - lastLinePoint.y;
            if (slope.value == null) {
                slope.value = new double[1];
            }
            ((double[])slope.value)[0] = deltaY / deltaX;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcTrueSlopeDoubleForRoutes", new RendererException("Failed inside CalcTrueSlopeDoubleForRoutes", exc));
        }
        return true;
    }

    public static boolean CalcTrueSlopeDouble2(POINT2 firstLinePoint, POINT2 lastLinePoint, ref<double[]> slope) {
        Boolean result = true;
        try {
            double deltaX = 0.0;
            double deltaY = 0.0;
            deltaX = firstLinePoint.x - lastLinePoint.x;
            if (Math.abs(deltaX) < 1.0) {
                deltaX = deltaX >= 0.0 ? 1.0 : -1.0;
                result = false;
            }
            deltaY = firstLinePoint.y - lastLinePoint.y;
            if (slope.value == null) {
                slope.value = new double[1];
            }
            ((double[])slope.value)[0] = deltaY / deltaX;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcTrueSlopeDouble2", new RendererException("Failed inside CalcTrueSlopeDouble2", exc));
        }
        return result;
    }

    protected static int CalcTrueLinesDouble(long nDistance, POINT2 linePoint1, POINT2 linePoint2, ref<double[]> pdResult) {
        try {
            int nTemp = 0;
            double b = 0.0;
            double delta = 0.0;
            ref<double[]> m = new ref<double[]>();
            nTemp = lineutility.CalcTrueSlopeDouble(linePoint1, linePoint2, m);
            pdResult.value = new double[6];
            if (nTemp == 0) {
                ((double[])pdResult.value)[3] = linePoint1.x + (double)nDistance;
                ((double[])pdResult.value)[5] = linePoint1.x - (double)nDistance;
                return 0;
            }
            b = linePoint2.y - ((double[])m.value)[0] * linePoint2.x;
            delta = Math.sqrt(((double[])m.value)[0] * ((double[])m.value)[0] * ((double)nDistance * (double)nDistance) + (double)nDistance * (double)nDistance);
            ((double[])pdResult.value)[0] = ((double[])m.value)[0];
            ((double[])pdResult.value)[1] = b;
            ((double[])pdResult.value)[2] = ((double[])m.value)[0];
            ((double[])pdResult.value)[3] = b + delta;
            ((double[])pdResult.value)[4] = ((double[])m.value)[0];
            ((double[])pdResult.value)[5] = b - delta;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcTrueLinesDouble", new RendererException("Failed inside CalcTrueLinesDouble", exc));
        }
        return 1;
    }

    public static POINT2 CalcTrueIntersectDouble2(double m1, double b1, double m2, double b2, int bolVertical1, int bolVertical2, double X1, double X2) {
        POINT2 ptIntersect = new POINT2();
        try {
            double x = 0.0;
            double y = 0.0;
            ptIntersect.x = X1;
            ptIntersect.y = X2;
            if (bolVertical1 == 0 && bolVertical2 == 0) {
                return ptIntersect;
            }
            if (bolVertical1 == 0 && bolVertical2 == 1) {
                ptIntersect.x = X1;
                ptIntersect.y = m2 * X1 + b2;
                return ptIntersect;
            }
            if (bolVertical1 == 1 && bolVertical2 == 0) {
                ptIntersect.x = X2;
                ptIntersect.y = m1 * X2 + b1;
                return ptIntersect;
            }
            if (m1 != m2) {
                x = (b2 - b1) / (m1 - m2);
                y = m1 * x + b1;
                ptIntersect.x = x;
                ptIntersect.y = y;
                return ptIntersect;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcTrueIntersectDouble2", new RendererException("Failed inside CalcTrueIntersectDouble2", exc));
        }
        return ptIntersect;
    }

    protected static POINT2 GetOffsetPointDouble(POINT2 startLinePoint, POINT2 endLinePoint, long nOffset) {
        POINT2 tempLinePoint = new POINT2(startLinePoint);
        try {
            double dx = endLinePoint.x - startLinePoint.x;
            double dy = endLinePoint.y - startLinePoint.y;
            double dOffset = nOffset;
            double dHypotenuse = 0.0;
            double dAngle = 0.0;
            if (dx == 0.0) {
                if (dy > 0.0) {
                    tempLinePoint.x = endLinePoint.x;
                    tempLinePoint.y = endLinePoint.y + dOffset;
                } else {
                    tempLinePoint.x = endLinePoint.x;
                    tempLinePoint.y = endLinePoint.y - dOffset;
                }
                return tempLinePoint;
            }
            if (dy == 0.0) {
                if (dx > 0.0) {
                    tempLinePoint.x = endLinePoint.x + dOffset;
                    tempLinePoint.y = endLinePoint.y;
                } else {
                    tempLinePoint.x = endLinePoint.x - dOffset;
                    tempLinePoint.y = endLinePoint.y;
                }
                return tempLinePoint;
            }
            dAngle = dy == 0.0 ? 0.0 : Math.atan(dx / dy) + 1.5707963267948966;
            dHypotenuse = nOffset;
            tempLinePoint.x = endLinePoint.x > startLinePoint.x ? endLinePoint.x + dHypotenuse * Math.abs(Math.cos(dAngle)) : endLinePoint.x - dHypotenuse * Math.abs(Math.cos(dAngle));
            tempLinePoint.y = endLinePoint.y > startLinePoint.y ? endLinePoint.y + dHypotenuse * Math.abs(Math.sin(dAngle)) : endLinePoint.y - dHypotenuse * Math.abs(Math.sin(dAngle));
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetOffsetPointDouble", new RendererException("Failed inside GetOffsetPointDouble", exc));
        }
        return tempLinePoint;
    }

    protected static ArrayList LineOfXPoints(TGLight tg, POINT2[] pLinePoints) {
        ArrayList<POINT2> xPoints = new ArrayList<POINT2>();
        try {
            int j = 0;
            int k = 0;
            double dist = 0.0;
            int iterations = 0;
            POINT2 frontPt = null;
            POINT2 backPt = null;
            POINT2 extendFrontAbove = null;
            POINT2 extendFrontBelow = null;
            POINT2 extendBackAbove = null;
            POINT2 extendBackBelow = null;
            Object xPoint1 = null;
            Object xPoint2 = null;
            int n = pLinePoints.length;
            double xSize = arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
            double dIncrement = xSize * 4.0;
            for (j = 0; j < n - 1; ++j) {
                dist = lineutility.CalcDistanceDouble(pLinePoints[j], pLinePoints[j + 1]);
                if (dist - (double)(iterations = (int)((dist - xSize) / dIncrement)) * dIncrement > dIncrement / 2.0) {
                    ++iterations;
                }
                for (k = 0; k < iterations; ++k) {
                    frontPt = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], (double)k * dIncrement - xSize);
                    backPt = lineutility.ExtendAlongLineDouble(pLinePoints[j], pLinePoints[j + 1], (double)k * dIncrement + xSize);
                    extendFrontAbove = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], frontPt, 2, xSize);
                    extendFrontBelow = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], frontPt, 3, xSize);
                    extendBackAbove = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], backPt, 2, xSize);
                    extendBackBelow = lineutility.ExtendDirectedLine(pLinePoints[j], pLinePoints[j + 1], backPt, 3, xSize);
                    xPoints.add(extendFrontAbove);
                    extendBackBelow.style = 5;
                    xPoints.add(extendBackBelow);
                    xPoints.add(extendBackAbove);
                    extendFrontBelow.style = 5;
                    xPoints.add(extendFrontBelow);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "LineOfXPoints", new RendererException("Failed inside LineOfXPoints", exc));
        }
        return xPoints;
    }

    public static double CalcDistanceToLineDouble(POINT2 pt1, POINT2 pt2, POINT2 pt3) {
        double dResult = 0.0;
        try {
            double m1 = 1.0;
            double b = 0.0;
            double b1 = 0.0;
            POINT2 ptIntersect = new POINT2(pt1);
            int bolVertical = 0;
            ref<double[]> m = new ref<double[]>();
            bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt2, m);
            if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                m1 = -1.0 / ((double[])m.value)[0];
                b = pt1.y - ((double[])m.value)[0] * pt1.x;
                b1 = pt3.y - m1 * pt3.x;
                ptIntersect = lineutility.CalcTrueIntersectDouble2(((double[])m.value)[0], b, m1, b1, 1, 1, ptIntersect.x, ptIntersect.y);
            }
            if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                ptIntersect.y = pt1.y;
                ptIntersect.x = pt3.x;
            }
            if (bolVertical == 0) {
                ptIntersect.y = pt3.y;
                ptIntersect.x = pt1.x;
            }
            dResult = lineutility.CalcDistanceDouble(pt3, ptIntersect);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CaclDistanceToLineDouble", new RendererException("Failed inside CalcDistanceToLineDouble", exc));
        }
        return dResult;
    }

    public static POINT2 ExtendLineDouble(POINT2 pt1, POINT2 pt2, double dist) {
        POINT2 pt3 = new POINT2();
        try {
            double dOriginalDistance = lineutility.CalcDistanceDouble(pt1, pt2);
            if (dOriginalDistance == 0.0 || dist == 0.0) {
                return pt2;
            }
            pt3.x = (dOriginalDistance + dist) / dOriginalDistance * (pt2.x - pt1.x) + pt1.x;
            pt3.y = (dOriginalDistance + dist) / dOriginalDistance * (pt2.y - pt1.y) + pt1.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendLineDouble", new RendererException("Failed inside ExtendLineDouble", exc));
        }
        return pt3;
    }

    public static POINT2 ExtendAlongLineDouble(POINT2 pt1, POINT2 pt2, double dist) {
        POINT2 pt3 = new POINT2();
        try {
            double dOriginalDistance = lineutility.CalcDistanceDouble(pt1, pt2);
            if (dOriginalDistance == 0.0 || dist == 0.0) {
                return pt2;
            }
            pt3.x = dist / dOriginalDistance * (pt2.x - pt1.x) + pt1.x;
            pt3.y = dist / dOriginalDistance * (pt2.y - pt1.y) + pt1.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendAlongLineDouble", new RendererException("Failed inside ExtendAlongLineDouble", exc));
        }
        return pt3;
    }

    public static POINT2 ExtendAlongLineDouble2(POINT2 pt1, POINT2 pt2, double dist) {
        POINT2 pt3 = new POINT2();
        try {
            double dOriginalDistance = lineutility.CalcDistanceDouble(pt1, pt2);
            if (dOriginalDistance == 0.0 || dist == 0.0) {
                return pt1;
            }
            pt3.x = dist / dOriginalDistance * (pt2.x - pt1.x) + pt1.x;
            pt3.y = dist / dOriginalDistance * (pt2.y - pt1.y) + pt1.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendAlongLineDouble2", new RendererException("Failed inside ExtendAlongLineDouble2", exc));
        }
        return pt3;
    }

    public static Point2D ExtendAlongLineDouble2(Point2D pt1, Point2D pt2, double dist) {
        try {
            double dOriginalDistance = lineutility.CalcDistanceDouble(pt1, pt2);
            if (dOriginalDistance == 0.0 || dist == 0.0) {
                return new Point2D.Double(pt1.getX(), pt1.getY());
            }
            double x = dist / dOriginalDistance * (pt2.getX() - pt1.getX()) + pt1.getX();
            double y = dist / dOriginalDistance * (pt2.getY() - pt1.getY()) + pt1.getY();
            return new Point2D.Double(x, y);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendAlongLineDouble2", new RendererException("Failed inside ExtendAlongLineDouble2", exc));
            return new Point2D.Double(0.0, 0.0);
        }
    }

    public static POINT2 ExtendAlongLineDouble(POINT2 pt1, POINT2 pt2, double dist, int styl) {
        POINT2 pt3 = new POINT2();
        try {
            double dOriginalDistance = lineutility.CalcDistanceDouble(pt1, pt2);
            if (dOriginalDistance == 0.0 || dist == 0.0) {
                return pt2;
            }
            pt3.x = dist / dOriginalDistance * (pt2.x - pt1.x) + pt1.x;
            pt3.y = dist / dOriginalDistance * (pt2.y - pt1.y) + pt1.y;
            pt3.style = styl;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendAlongLineDouble", new RendererException("Failed inside ExtendAlongLineDouble", exc));
        }
        return pt3;
    }

    protected static int ExtendLineAbove(POINT2 pt1, POINT2 pt2, POINT2 pt3, double d, ref<double[]> X, ref<double[]> Y, int direction) {
        try {
            ref<double[]> m = new ref<double[]>();
            double dx = 0.0;
            double dy = 0.0;
            int bolVertical = 0;
            X.value = new double[1];
            Y.value = new double[1];
            bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt2, m);
            if (bolVertical == 0) {
                return 0;
            }
            if (((double[])m.value)[0] == 0.0) {
                ((double[])X.value)[0] = pt3.x;
                ((double[])Y.value)[0] = direction == 0 ? pt3.y - Math.abs(d) : pt3.y + Math.abs(d);
                return 1;
            }
            dy = direction == 0 ? -Math.abs(d / (((double[])m.value)[0] * Math.sqrt(1.0 + 1.0 / (((double[])m.value)[0] * ((double[])m.value)[0])))) : Math.abs(d / (((double[])m.value)[0] * Math.sqrt(1.0 + 1.0 / (((double[])m.value)[0] * ((double[])m.value)[0]))));
            dx = -((double[])m.value)[0] * dy;
            ((double[])X.value)[0] = pt3.x + dx;
            ((double[])Y.value)[0] = pt3.y + dy;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendLineAbove", new RendererException("Failed inside ExtendLineAbove", exc));
        }
        return 1;
    }

    protected static int ExtendLineLeft(POINT2 pt1, POINT2 pt2, POINT2 pt3, double d, ref<double[]> X, ref<double[]> Y, int direction) {
        try {
            ref<double[]> m = new ref<double[]>();
            double dx = 0.0;
            double dy = 0.0;
            int bolVertical = 0;
            X.value = new double[1];
            Y.value = new double[1];
            bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt2, m);
            if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                return 0;
            }
            if (bolVertical == 0) {
                ((double[])Y.value)[0] = pt3.y;
                ((double[])X.value)[0] = direction == 0 ? pt3.x - Math.abs(d) : pt3.x + Math.abs(d);
                return 1;
            }
            dx = direction == 0 ? -Math.abs(d / Math.sqrt(1.0 + 1.0 / (((double[])m.value)[0] * ((double[])m.value)[0]))) : Math.abs(d / Math.sqrt(1.0 + 1.0 / (((double[])m.value)[0] * ((double[])m.value)[0])));
            dy = -(1.0 / ((double[])m.value)[0]) * dx;
            ((double[])X.value)[0] = pt3.x + dx;
            ((double[])Y.value)[0] = pt3.y + dy;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendLineLeft", new RendererException("Failed inside ExtendLineLeft", exc));
        }
        return 1;
    }

    protected static int CalcDirectionFromLine(POINT2 pt0, POINT2 pt1, POINT2 ptRelative) {
        int result = -1;
        try {
            double m2 = 0.0;
            double b1 = 0.0;
            double b2 = 0.0;
            ref<double[]> m1 = new ref<double[]>();
            POINT2 ptIntersect = new POINT2();
            if (pt0.x == pt1.x) {
                if (ptRelative.x < pt0.x) {
                    return 0;
                }
                return 1;
            }
            if (pt0.y == pt1.y) {
                if (ptRelative.y < pt0.y) {
                    return 2;
                }
                return 3;
            }
            lineutility.CalcTrueSlopeDouble(pt0, pt1, m1);
            m2 = -1.0 / ((double[])m1.value)[0];
            b1 = pt0.y - ((double[])m1.value)[0] * pt0.x;
            b2 = ptRelative.y - m2 * ptRelative.x;
            ptIntersect = lineutility.CalcTrueIntersectDouble2(((double[])m1.value)[0], b1, m2, b2, 1, 1, 0.0, 0.0);
            if (((double[])m1.value)[0] > 1.0) {
                if (ptRelative.x < ptIntersect.x) {
                    return 0;
                }
                return 1;
            }
            if (ptRelative.y < ptIntersect.y) {
                return 2;
            }
            return 3;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return result;
        }
    }

    public static POINT2 ExtendDirectedLine(POINT2 pt1, POINT2 pt2, POINT2 pt0, int direction, double d) {
        POINT2 ptResult = new POINT2();
        try {
            ref<double[]> X = new ref<double[]>();
            ref<double[]> Y = new ref<double[]>();
            ptResult = new POINT2(pt0);
            switch (direction) {
                case 0: {
                    lineutility.ExtendLineLeft(pt1, pt2, pt0, d, X, Y, 0);
                    break;
                }
                case 1: {
                    lineutility.ExtendLineLeft(pt1, pt2, pt0, d, X, Y, 1);
                    break;
                }
                case 2: {
                    lineutility.ExtendLineAbove(pt1, pt2, pt0, d, X, Y, 0);
                    break;
                }
                case 3: {
                    lineutility.ExtendLineAbove(pt1, pt2, pt0, d, X, Y, 1);
                    break;
                }
            }
            ptResult.x = ((double[])X.value)[0];
            ptResult.y = ((double[])Y.value)[0];
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendDirectedLine", new RendererException("Failed inside ExtendDirectedLine", exc));
        }
        return ptResult;
    }

    public static POINT2 ExtendDirectedLineText(POINT2 pt1, POINT2 pt2, POINT2 pt0, int direction, double d) {
        POINT2 ptResult = new POINT2();
        try {
            ref<double[]> X = new ref<double[]>();
            ref<double[]> Y = new ref<double[]>();
            ptResult = new POINT2(pt0);
            if (d < 0.0) {
                direction = lineutility.reverseDirection(direction);
                d = Math.abs(d);
            }
            if (pt1.y == pt2.y) {
                switch (direction) {
                    case 0: {
                        direction = 2;
                        break;
                    }
                    case 1: {
                        direction = 3;
                        break;
                    }
                }
            }
            if (pt1.x == pt2.x) {
                switch (direction) {
                    case 2: {
                        direction = 0;
                        break;
                    }
                    case 3: {
                        direction = 1;
                        break;
                    }
                }
            }
            switch (direction) {
                case 0: {
                    lineutility.ExtendLineLeft(pt1, pt2, pt0, d, X, Y, 0);
                    break;
                }
                case 1: {
                    lineutility.ExtendLineLeft(pt1, pt2, pt0, d, X, Y, 1);
                    break;
                }
                case 2: {
                    lineutility.ExtendLineAbove(pt1, pt2, pt0, d, X, Y, 0);
                    break;
                }
                case 3: {
                    lineutility.ExtendLineAbove(pt1, pt2, pt0, d, X, Y, 1);
                    break;
                }
            }
            ptResult.x = ((double[])X.value)[0];
            ptResult.y = ((double[])Y.value)[0];
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendDirectedLine", new RendererException("Failed inside ExtendDirectedLine", exc));
        }
        return ptResult;
    }

    public static POINT2 ExtendDirectedLine(POINT2 pt1, POINT2 pt2, POINT2 pt0, int direction, double d, int style) {
        POINT2 ptResult = new POINT2(pt0);
        try {
            ref<double[]> X = new ref<double[]>();
            ref<double[]> Y = new ref<double[]>();
            if (pt1.x == pt2.x) {
                if (direction == 2) {
                    direction = 0;
                }
                if (direction == 3) {
                    direction = 1;
                }
            }
            if (pt1.y == pt2.y) {
                if (direction == 0) {
                    direction = 2;
                }
                if (direction == 1) {
                    direction = 3;
                }
            }
            switch (direction) {
                case 0: {
                    lineutility.ExtendLineLeft(pt1, pt2, pt0, d, X, Y, 0);
                    break;
                }
                case 1: {
                    lineutility.ExtendLineLeft(pt1, pt2, pt0, d, X, Y, 1);
                    break;
                }
                case 2: {
                    lineutility.ExtendLineAbove(pt1, pt2, pt0, d, X, Y, 0);
                    break;
                }
                case 3: {
                    lineutility.ExtendLineAbove(pt1, pt2, pt0, d, X, Y, 1);
                }
            }
            ptResult.x = ((double[])X.value)[0];
            ptResult.y = ((double[])Y.value)[0];
            ptResult.style = style;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendDirectedLine", new RendererException("Failed inside ExtendDirectedLine", exc));
        }
        return ptResult;
    }

    protected static POINT2 ExtendLine2Double(POINT2 pt1, POINT2 pt2, double dist, int styl) {
        POINT2 pt3 = new POINT2();
        try {
            double dOriginalDistance = lineutility.CalcDistanceDouble(pt1, pt2);
            pt3.x = pt2.x;
            pt3.y = pt2.y;
            if (dOriginalDistance > 0.0) {
                pt3.x = (dOriginalDistance + dist) / dOriginalDistance * (pt2.x - pt1.x) + pt1.x;
                pt3.y = (dOriginalDistance + dist) / dOriginalDistance * (pt2.y - pt1.y) + pt1.y;
                pt3.style = styl;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendLine2Double", new RendererException("Failed inside ExtendLine2Double", exc));
        }
        return pt3;
    }

    public static POINT2 ExtendAngledLine(POINT2 pt0, POINT2 pt1, POINT2 pt2, double alpha, double d) {
        POINT2 pt = new POINT2();
        try {
            double psi = Math.atan((pt1.y - pt0.y) / (pt1.x - pt0.x));
            double alpha1 = Math.PI * alpha / 180.0;
            double theta = psi + alpha1;
            double dx = d * Math.cos(theta);
            double dy = d * Math.sin(theta);
            pt.x = pt2.x + dx;
            pt.y = pt2.y + dy;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendAngledLine", new RendererException("Failed inside ExtendAngledLine", exc));
        }
        return pt;
    }

    public static int GetQuadrantDouble(POINT2 pt1, POINT2 pt2) {
        int nQuadrant = 1;
        try {
            if (pt2.x >= pt1.x && pt2.y <= pt1.y) {
                nQuadrant = 1;
            }
            if (pt2.x >= pt1.x && pt2.y >= pt1.y) {
                nQuadrant = 2;
            }
            if (pt2.x <= pt1.x && pt2.y >= pt1.y) {
                nQuadrant = 3;
            }
            if (pt2.x <= pt1.x && pt2.y <= pt1.y) {
                nQuadrant = 4;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetQuadrantDouble", new RendererException("Failed inside GetQuadrantDouble", exc));
        }
        return nQuadrant;
    }

    public static int GetQuadrantDouble(double x1, double y1, double x2, double y2) {
        int nQuadrant = 1;
        try {
            if (x2 >= x1 && y2 <= y1) {
                nQuadrant = 1;
            }
            if (x2 >= x1 && y2 >= y1) {
                nQuadrant = 2;
            }
            if (x2 <= x1 && y2 >= y1) {
                nQuadrant = 3;
            }
            if (x2 <= x1 && y2 <= y1) {
                nQuadrant = 4;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetQuadrantDouble", new RendererException("Failed inside GetQuadrantDouble", exc));
        }
        return nQuadrant;
    }

    public static void GetPixelsMin(POINT2[] ptsSeize, int vblCounter, ref<double[]> x, ref<double[]> y) {
        try {
            double xmin = Double.POSITIVE_INFINITY;
            double ymin = Double.POSITIVE_INFINITY;
            int j = 0;
            for (j = 0; j < vblCounter; ++j) {
                if (ptsSeize[j].x < xmin) {
                    xmin = ptsSeize[j].x;
                }
                if (!(ptsSeize[j].y < ymin)) continue;
                ymin = ptsSeize[j].y;
            }
            x.value = new double[1];
            y.value = new double[1];
            ((double[])x.value)[0] = xmin;
            ((double[])y.value)[0] = ymin;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPixelsMin", new RendererException("Failed inside GetPixelsMin", exc));
        }
    }

    public static void GetPixelsMax(POINT2[] ptsSeize, int vblCounter, ref<double[]> x, ref<double[]> y) {
        try {
            double xmax = Double.NEGATIVE_INFINITY;
            double ymax = Double.NEGATIVE_INFINITY;
            int j = 0;
            for (j = 0; j < vblCounter; ++j) {
                if (ptsSeize[j].x > xmax) {
                    xmax = ptsSeize[j].x;
                }
                if (!(ptsSeize[j].y > ymax)) continue;
                ymax = ptsSeize[j].y;
            }
            x.value = new double[1];
            y.value = new double[1];
            ((double[])x.value)[0] = xmax;
            ((double[])y.value)[0] = ymax;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetPixelsMax", new RendererException("Failed inside GetPixelsMax", exc));
        }
    }

    protected static double CalcClockwiseCenterDouble(POINT2[] ptsSeize) {
        double dRadius = 0.0;
        try {
            POINT2 pt1 = new POINT2(ptsSeize[0]);
            POINT2 pt2 = new POINT2(ptsSeize[1]);
            POINT2 C = new POINT2(pt1);
            POINT2 midPt = new POINT2(pt1);
            POINT2 E = new POINT2(pt1);
            POINT2 ptYIntercept = new POINT2(pt1);
            int nQuadrant = 1;
            double b = 0.0;
            double b1 = 0.0;
            double b2 = 0.0;
            double dLength = 0.0;
            ref<double[]> m = new ref<double[]>();
            int bolVertical = 0;
            ref<double[]> offsetX = new ref<double[]>();
            ref<double[]> offsetY = new ref<double[]>();
            POINT2[] ptsTemp = new POINT2[]{new POINT2(pt1), new POINT2(pt2)};
            lineutility.GetPixelsMin(ptsTemp, 2, offsetX, offsetY);
            ((double[])offsetX.value)[0] = ((double[])offsetX.value)[0] < 0.0 ? ((double[])offsetX.value)[0] - 100.0 : 0.0;
            midPt.x = (pt1.x + pt2.x) / 2.0;
            midPt.y = (pt1.y + pt2.y) / 2.0;
            dLength = lineutility.CalcDistanceDouble(pt1, pt2);
            dRadius = dLength / Math.sqrt(2.0);
            nQuadrant = lineutility.GetQuadrantDouble(pt1, pt2);
            bolVertical = lineutility.CalcTrueSlopeDouble(pt1, pt2, m);
            if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                b = pt1.y - ((double[])m.value)[0] * pt1.x;
                b1 = midPt.y + 1.0 / ((double[])m.value)[0] * midPt.x;
                b2 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b1;
                ptYIntercept.x = ((double[])offsetX.value)[0];
                ptYIntercept.y = b2;
                switch (nQuadrant) {
                    case 1: 
                    case 4: {
                        C = lineutility.ExtendLineDouble(ptYIntercept, midPt, dLength / 2.0);
                        break;
                    }
                    case 2: 
                    case 3: {
                        C = lineutility.ExtendLineDouble(ptYIntercept, midPt, -dLength / 2.0);
                        break;
                    }
                }
            }
            if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                C.x = midPt.x;
                C.y = pt1.x < pt2.x ? midPt.y + dLength / 2.0 : midPt.y - dLength / 2.0;
            }
            if (bolVertical == 0) {
                ptYIntercept.x = ((double[])offsetX.value)[0];
                ptYIntercept.y = midPt.y;
                switch (nQuadrant) {
                    case 1: 
                    case 4: {
                        C = lineutility.ExtendLineDouble(ptYIntercept, midPt, dLength / 2.0);
                        break;
                    }
                    case 2: 
                    case 3: {
                        C = lineutility.ExtendLineDouble(ptYIntercept, midPt, -dLength / 2.0);
                        break;
                    }
                }
            }
            E = lineutility.ExtendLineDouble(C, pt1, 50.0);
            ptsSeize[0] = new POINT2(C);
            ptsSeize[1] = new POINT2(E);
            ptsTemp = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcClockwiseCenterDouble", new RendererException("Failed inside CalcClockwiseCenterDouble", exc));
        }
        return dRadius;
    }

    protected static void GetArrowHead4Double(POINT2 startLinePoint, POINT2 endLinePoint, int nBiSector, int nBase, POINT2[] pResultLinePoints, int styl) {
        try {
            int j = 0;
            double dy = endLinePoint.y - startLinePoint.y;
            double dx = endLinePoint.x - startLinePoint.x;
            double dSign = 1.0;
            double AHBY = 0.0;
            double AHBX = 0.0;
            double AHBLY = 0.0;
            double AHBLX = 0.0;
            double AHBRY = 0.0;
            double AHBRX = 0.0;
            double dAngle = 0.0;
            double dHypotenuse = 0.0;
            POINT2 tempLinePoint = new POINT2(startLinePoint);
            dAngle = dy == 0.0 ? (dx > 0.0 ? Math.PI : 0.0) : Math.atan(dx / dy) + 1.5707963267948966;
            tempLinePoint.style = 0;
            if (dx <= 0.0 && dy <= 0.0) {
                dSign = -1.0;
            }
            if (dx >= 0.0 && dy <= 0.0) {
                dSign = -1.0;
            }
            if (dx <= 0.0 && dy >= 0.0) {
                dSign = 1.0;
            }
            if (dx >= 0.0 && dy >= 0.0) {
                dSign = 1.0;
            }
            dHypotenuse = dSign * (double)nBiSector;
            AHBX = endLinePoint.x + dHypotenuse * Math.cos(dAngle);
            AHBY = endLinePoint.y - dHypotenuse * Math.sin(dAngle);
            dHypotenuse = dSign * ((double)nBase / 2.0);
            AHBLX = AHBX - dHypotenuse * Math.sin(dAngle);
            AHBLY = AHBY - dHypotenuse * Math.cos(dAngle);
            AHBRX = AHBX + dHypotenuse * Math.sin(dAngle);
            AHBRY = AHBY + dHypotenuse * Math.cos(dAngle);
            tempLinePoint.x = (int)AHBLX;
            tempLinePoint.y = (int)AHBLY;
            pResultLinePoints[0] = new POINT2(tempLinePoint);
            pResultLinePoints[1] = new POINT2(endLinePoint);
            tempLinePoint.x = (int)AHBRX;
            tempLinePoint.y = (int)AHBRY;
            pResultLinePoints[2] = new POINT2(tempLinePoint);
            switch (styl) {
                case 0: {
                    for (j = 0; j < 2; ++j) {
                        pResultLinePoints[j].style = 0;
                    }
                    pResultLinePoints[2].style = 5;
                    break;
                }
                case 9: {
                    for (j = 0; j < 2; ++j) {
                        pResultLinePoints[j].style = 9;
                    }
                    pResultLinePoints[2].style = 10;
                    break;
                }
                case 18: {
                    for (j = 0; j < 2; ++j) {
                        pResultLinePoints[j].style = 18;
                    }
                    pResultLinePoints[2].style = 5;
                    break;
                }
                default: {
                    for (j = 0; j < 2; ++j) {
                        pResultLinePoints[j].style = styl;
                    }
                    pResultLinePoints[2].style = 5;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetArrowhead4Double", new RendererException("Failed inside GetArrowhead4Double", exc));
        }
    }

    public static POINT2 MidPointDouble(POINT2 pt0, POINT2 pt1, int styl) {
        POINT2 ptResult = new POINT2(pt0);
        try {
            ptResult.x = (pt0.x + pt1.x) / 2.0;
            ptResult.y = (pt0.y + pt1.y) / 2.0;
            ptResult.style = styl;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "MidPointDouble", new RendererException("Failed inside MidPointDouble", exc));
        }
        return ptResult;
    }

    protected static POINT2[] RotateGeometryDoubleOrigin(POINT2[] pLinePoints, int vblCounter, int lAngle) {
        try {
            int j = 0;
            double dRotate = 0.0;
            double dTheta = 0.0;
            double dGamma = 0.0;
            double x = 0.0;
            double y = 0.0;
            if (lAngle != 0) {
                POINT2 pdCenter = new POINT2();
                dRotate = (double)lAngle * Math.PI / 180.0;
                pdCenter = new POINT2(pLinePoints[0]);
                for (j = 0; j < vblCounter; ++j) {
                    dGamma = Math.PI + Math.atan((pLinePoints[j].y - pdCenter.y) / (pLinePoints[j].x - pdCenter.x));
                    if (pLinePoints[j].x >= pdCenter.x) {
                        dGamma += Math.PI;
                    }
                    dTheta = dRotate + dGamma;
                    y = lineutility.CalcDistanceDouble(pLinePoints[j], pdCenter) * Math.sin(dTheta);
                    x = lineutility.CalcDistanceDouble(pLinePoints[j], pdCenter) * Math.cos(dTheta);
                    pLinePoints[j].y = pdCenter.y + y;
                    pLinePoints[j].x = pdCenter.x + x;
                }
                return pLinePoints;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "RotateGeometryDoubleOrigin", new RendererException("Failed inside RotateGeometryDoubleOrigin", exc));
        }
        return pLinePoints;
    }

    public static POINT2 ExtendTrueLinePerpDouble(POINT2 pt0, POINT2 pt1, POINT2 pt2, double d, int styl) {
        POINT2 ptResult = new POINT2(pt0);
        try {
            POINT2 ptYIntercept = new POINT2(pt0);
            ref<double[]> m = new ref<double[]>();
            double b = 0.0;
            double b1 = 0.0;
            int nTemp = 0;
            ref<double[]> offsetX = new ref<double[]>();
            ref<double[]> offsetY = new ref<double[]>();
            POINT2[] pts = new POINT2[]{new POINT2(pt0), new POINT2(pt1), new POINT2(pt2)};
            lineutility.GetPixelsMin(pts, 3, offsetX, offsetY);
            ((double[])offsetX.value)[0] = ((double[])offsetX.value)[0] <= 0.0 ? ((double[])offsetX.value)[0] - 100.0 : 0.0;
            nTemp = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
            switch (nTemp) {
                case 0: {
                    if (pt0.y < pt1.y) {
                        ptResult.x = pt2.x - d;
                        ptResult.y = pt2.y;
                        break;
                    }
                    ptResult.x = pt2.x + d;
                    ptResult.y = pt2.y;
                    break;
                }
                default: {
                    if (((double[])m.value)[0] == 0.0) {
                        ptResult.x = pt2.x;
                        ptResult.y = pt2.y + d;
                        break;
                    }
                    b = pt2.y + 1.0 / ((double[])m.value)[0] * pt2.x;
                    b1 = -1.0 / ((double[])m.value)[0] * ((double[])offsetX.value)[0] + b;
                    ptYIntercept.x = ((double[])offsetX.value)[0];
                    ptYIntercept.y = b1;
                    ptResult = lineutility.ExtendLineDouble(ptYIntercept, pt2, d);
                }
            }
            ptResult.style = styl;
            pts = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ExtendTrueLinePerpDouble", new RendererException("Failed inside ExtendTrueLinePerpDouble", exc));
        }
        return ptResult;
    }

    protected static int CalcTrueIntersectDouble(double m1, double b1, double m2, double b2, POINT2 p2, int bolVerticalSlope1, int bolVerticalSlope2, double dWidth, int lOrient, ref<double[]> X, ref<double[]> Y) {
        try {
            double dWidth2 = Math.abs(dWidth);
            double b = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            double m = 0.0;
            X.value = new double[1];
            Y.value = new double[1];
            if (m1 != m2 && Math.abs(m1 - m2) <= Double.MIN_VALUE) {
                m1 = m2;
            }
            if (b1 != b2 && Math.abs(b1 - b2) <= Double.MIN_VALUE) {
                b1 = b2;
            }
            if (b1 == b2 && m1 + b1 == m2 + b2) {
                m1 = m2;
            }
            if (bolVerticalSlope1 == 0 && bolVerticalSlope2 == 0) {
                switch (lOrient) {
                    case 0: {
                        ((double[])X.value)[0] = p2.x - dWidth2;
                        ((double[])Y.value)[0] = p2.y;
                        break;
                    }
                    case 3: {
                        ((double[])X.value)[0] = p2.x + dWidth2;
                        ((double[])Y.value)[0] = p2.y;
                        break;
                    }
                    default: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y;
                    }
                }
                return 1;
            }
            if (bolVerticalSlope1 == 0 && bolVerticalSlope2 != 0) {
                switch (lOrient) {
                    case 0: 
                    case 1: {
                        ((double[])X.value)[0] = p2.x - dWidth2;
                        ((double[])Y.value)[0] = m2 * ((double[])X.value)[0] + b2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ((double[])X.value)[0] = p2.x + dWidth2;
                        ((double[])Y.value)[0] = m2 * ((double[])X.value)[0] + b2;
                        break;
                    }
                    default: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y;
                    }
                }
                return 1;
            }
            if (bolVerticalSlope2 == 0 && bolVerticalSlope1 != 0) {
                switch (lOrient) {
                    case 0: 
                    case 2: {
                        ((double[])X.value)[0] = p2.x - dWidth2;
                        ((double[])Y.value)[0] = m1 * ((double[])X.value)[0] + b1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        ((double[])X.value)[0] = p2.x + dWidth2;
                        ((double[])Y.value)[0] = m1 * ((double[])X.value)[0] + b1;
                        break;
                    }
                    default: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y;
                    }
                }
                return 1;
            }
            if (m1 == m2 && m1 != 0.0) {
                if (b1 == b2) {
                    m = -1.0 / m1;
                    b = p2.y - m * p2.x;
                    ((double[])X.value)[0] = (b2 - b) / (m - m2);
                    ((double[])Y.value)[0] = m1 * ((double[])X.value)[0] + b1;
                    return 1;
                }
                ((double[])X.value)[0] = p2.x;
                ((double[])Y.value)[0] = p2.y;
                return 1;
            }
            if (m1 == m2 && m1 == 0.0) {
                switch (lOrient) {
                    case 0: 
                    case 1: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y - dWidth2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y + dWidth2;
                        break;
                    }
                    default: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y;
                    }
                }
                return 1;
            }
            if (m1 == m2 && b1 == b2 && bolVerticalSlope1 != 0 && bolVerticalSlope2 != 0) {
                switch (lOrient) {
                    case 0: {
                        if (m1 < 0.0) {
                            dy = m1 * dWidth / Math.sqrt(1.0 + m1 * m1);
                            dx = dy / m1;
                            ((double[])X.value)[0] = p2.x + dx;
                            ((double[])Y.value)[0] = p2.y + dy;
                        }
                        if (!(m1 > 0.0)) break;
                        dy = -m1 * dWidth / Math.sqrt(1.0 + m1 * m1);
                        dx = -dy / m1;
                        ((double[])X.value)[0] = p2.x + dx;
                        ((double[])Y.value)[0] = p2.y + dy;
                        break;
                    }
                    case 3: {
                        if (m1 <= 0.0) {
                            dy = -m1 * dWidth / Math.sqrt(1.0 + m1 * m1);
                            dx = dy / m1;
                            ((double[])X.value)[0] = p2.x + dx;
                            ((double[])Y.value)[0] = p2.y + dy;
                            break;
                        }
                        dy = m1 * dWidth / Math.sqrt(1.0 + m1 * m1);
                        dx = -dy / m1;
                        ((double[])X.value)[0] = p2.x + dx;
                        ((double[])Y.value)[0] = p2.y + dy;
                        break;
                    }
                    default: {
                        ((double[])X.value)[0] = p2.x;
                        ((double[])Y.value)[0] = p2.y;
                    }
                }
                return 1;
            }
            ((double[])X.value)[0] = (b2 - b1) / (m1 - m2);
            ((double[])Y.value)[0] = m1 * ((double[])X.value)[0] + b1;
            return 1;
        }
        catch (Exception exc) {
            ((double[])X.value)[0] = p2.x;
            ((double[])Y.value)[0] = p2.y;
            ErrorLogger.LogException(_className, "CalcTrueIntersectDouble", new RendererException("Failed inside ExtendTrueIntersectDouble", exc));
            return 1;
        }
    }

    protected static double CalcDistance2(long x1, long y1, long x2, long y2) {
        double dResult = 0.0;
        try {
            dResult = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double xdist = Math.abs(x1 - x2);
            double ydist = Math.abs(y1 - y2);
            double max = xdist;
            if (ydist > xdist) {
                max = ydist;
            }
            if ((dResult == 0.0 || Double.isInfinite(dResult)) && max > 0.0) {
                dResult = max;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcDistance2", new RendererException("Failed inside CalcDistance2", exc));
        }
        return dResult;
    }

    protected static POINT2[] GetSAAFRMiddleLine(POINT2[] pLinePoints) {
        POINT2[] pts = null;
        try {
            int j = 0;
            int count = 0;
            for (j = 0; j < pLinePoints.length - 1; ++j) {
                if (pLinePoints[j].style <= 0) continue;
                ++count;
            }
            pts = new POINT2[count * 2];
            count = 0;
            double dMRR = 0.0;
            POINT2 firstSegPt = null;
            POINT2 lastSegPt = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            for (j = 0; j < pLinePoints.length; ++j) {
                if (pLinePoints[j].style < 0 && j != pLinePoints.length - 1) continue;
                if (lastSegPt != null) {
                    firstSegPt = new POINT2(lastSegPt);
                    lastSegPt = new POINT2(pLinePoints[j]);
                    dMRR = firstSegPt.style;
                    pt0 = lineutility.ExtendLine2Double(lastSegPt, firstSegPt, -dMRR, 0);
                    pt1 = lineutility.ExtendLine2Double(firstSegPt, lastSegPt, -dMRR, 5);
                    pts[count++] = pt0;
                    pts[count++] = pt1;
                    continue;
                }
                lastSegPt = new POINT2(pLinePoints[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSAAFRMiddleLine", new RendererException("Failed inside GetSAAFRMiddleLine", exc));
        }
        return pts;
    }

    protected static void GetSAAFRSegment(POINT2[] pLinePoints, int lineType, double dMRR) {
        try {
            POINT2 pt0 = new POINT2();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            POINT2 pt5 = new POINT2();
            ref<double[]> m = new ref<double[]>();
            int bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[0], pLinePoints[1], m);
            pt1 = lineutility.ExtendLine2Double(pLinePoints[0], pLinePoints[1], -dMRR, 5);
            pt0 = lineutility.ExtendLine2Double(pLinePoints[1], pLinePoints[0], -dMRR, 0);
            if (bolVertical != 0 && ((double[])m.value)[0] < 1.0) {
                pt2 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 2, dMRR);
                pt2.style = 0;
                pt3 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 2, dMRR);
                pt3.style = 5;
                pt4 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 3, dMRR);
                pt4.style = 0;
                pt5 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 3, dMRR);
                pt5.style = 5;
            } else {
                pt2 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 0, dMRR);
                pt2.style = 0;
                pt3 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 0, dMRR);
                pt3.style = 5;
                pt4 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 1, dMRR);
                pt4.style = 0;
                pt5 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 1, dMRR);
                pt5.style = 5;
            }
            pLinePoints[0] = new POINT2(pt0);
            pLinePoints[1] = new POINT2(pt1);
            pLinePoints[2] = new POINT2(pt2);
            pLinePoints[3] = new POINT2(pt3);
            pLinePoints[4] = new POINT2(pt4);
            pLinePoints[5] = new POINT2(pt5);
            pLinePoints[5].style = 5;
            pLinePoints[0].style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSAAFRSegment", new RendererException("Failed inside GetSAAFRSegment", exc));
        }
    }

    protected static void GetSAAFRFillSegment(POINT2[] pLinePoints, double dMRR) {
        try {
            POINT2 pt2 = new POINT2();
            POINT2 pt3 = new POINT2();
            POINT2 pt4 = new POINT2();
            POINT2 pt5 = new POINT2();
            ref<double[]> m = new ref<double[]>();
            int bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[0], pLinePoints[1], m);
            if (bolVertical != 0 && ((double[])m.value)[0] < 1.0) {
                pt2 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 2, dMRR);
                pt3 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 2, dMRR);
                pt4 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 3, dMRR);
                pt5 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 3, dMRR);
            } else {
                pt2 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 0, dMRR);
                pt3 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 0, dMRR);
                pt4 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[0], 1, dMRR);
                pt5 = lineutility.ExtendDirectedLine(pLinePoints[0], pLinePoints[1], pLinePoints[1], 1, dMRR);
            }
            pLinePoints[0] = new POINT2(pt2);
            pLinePoints[1] = new POINT2(pt3);
            pLinePoints[2] = new POINT2(pt5);
            pLinePoints[3] = new POINT2(pt4);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSAAFRFillSegment", new RendererException("Failed inside GetSAAFRFillSegment", exc));
        }
    }

    protected static POINT2[] ArcArrayDouble(POINT2[] pResultLinePoints, int vblCounter, double dRadius, int linetype, IPointConversion converter) {
        try {
            int j;
            Point2D pt12d;
            Point2D pt02d;
            double startangle = 0.0;
            double endangle = 0.0;
            double increment = 0.0;
            double length = 0.0;
            double M = 0.0;
            int numarcpts = 0;
            int bolVertical = 0;
            ref<double[]> m = new ref<double[]>();
            POINT2 C = new POINT2(pResultLinePoints[0]);
            POINT2 a = new POINT2(pResultLinePoints[1]);
            POINT2 e = new POINT2(pResultLinePoints[0]);
            POINT2[] pArcLinePoints = null;
            bolVertical = lineutility.CalcTrueSlopeDouble(a, e, m);
            M = bolVertical != 0 ? Math.atan(((double[])m.value)[0]) : (a.y < e.y ? -1.5707963267948966 : 1.5707963267948966);
            if (converter != null) {
                pt02d = new Point2D.Double(pResultLinePoints[0].x, pResultLinePoints[0].y);
                pt12d = new Point2D.Double(pResultLinePoints[1].x, pResultLinePoints[1].y);
                pt02d = converter.PixelsToGeo(pt02d);
                pt12d = converter.PixelsToGeo(pt12d);
                M = mdlGeodesic.GetAzimuth(new POINT2(pt02d.getX(), pt02d.getY()), new POINT2(pt12d.getX(), pt12d.getY()));
                if ((M *= Math.PI / 180) < 0.0) {
                    M += Math.PI;
                }
            }
            length = lineutility.CalcDistanceDouble(a, e);
            if (converter != null) {
                pt02d = new Point2D.Double(pResultLinePoints[0].x, pResultLinePoints[0].y);
                pt12d = new Point2D.Double(pResultLinePoints[1].x, pResultLinePoints[1].y);
                pt02d = converter.PixelsToGeo(pt02d);
                pt12d = converter.PixelsToGeo(pt12d);
                length = mdlGeodesic.geodesic_distance(new POINT2(pt02d.getX(), pt02d.getY()), new POINT2(pt12d.getX(), pt12d.getY()), null, null);
            }
            switch (linetype) {
                case 23157000: {
                    startangle = M - 1.5707963267948966;
                    endangle = startangle + Math.PI;
                    break;
                }
                case 25152600: 
                case 211400000: 
                case 212500000: 
                case 212600000: {
                    startangle = M;
                    endangle = startangle + 5.759586531581287;
                    break;
                }
                case 23173000: 
                case 25270504: {
                    startangle = M;
                    endangle = startangle + 1.5707963267948966;
                    break;
                }
                case 211600000: 
                case 211900000: 
                case 212100000: {
                    startangle = M;
                    endangle = startangle + 5.899212871740834;
                    break;
                }
                default: {
                    startangle = 0.0;
                    endangle = Math.PI * 2;
                }
            }
            if (a.x < e.x) {
                switch (linetype) {
                    case 25152600: 
                    case 211400000: 
                    case 212500000: 
                    case 212600000: {
                        startangle = M - Math.PI;
                        endangle = startangle + 5.759586531581287;
                        break;
                    }
                    case 211600000: 
                    case 211900000: 
                    case 212100000: {
                        startangle = M - Math.PI;
                        endangle = startangle + 5.899212871740834;
                        break;
                    }
                    case 23173000: 
                    case 25270504: {
                        startangle = M - Math.PI;
                        endangle = startangle + 1.5707963267948966;
                        break;
                    }
                    case 23157000: {
                        startangle = M - Math.PI + 1.5707963267948966;
                        endangle = startangle - Math.PI;
                        break;
                    }
                }
            }
            numarcpts = 26;
            pArcLinePoints = new POINT2[numarcpts];
            lineutility.InitializePOINT2Array(pArcLinePoints);
            increment = (endangle - startangle) / (double)(numarcpts - 1);
            if (dRadius != 0.0 && length != 0.0) {
                C.x = (int)(e.x - dRadius / length * (a.x - e.x));
                C.y = (int)(e.y - dRadius / length * (a.y - e.y));
            } else {
                C.x = e.x;
                C.y = e.y;
            }
            if (converter != null) {
                Point2D C2d = new Point2D.Double(pResultLinePoints[0].x, pResultLinePoints[0].y);
                C2d = converter.PixelsToGeo(C2d);
                double az = 0.0;
                Point2D ptGeo2d = null;
                POINT2 ptGeo = null;
                POINT2 ptPixels = null;
                for (j = 0; j < numarcpts; ++j) {
                    az = startangle * 180.0 / Math.PI + (double)j * increment * 180.0 / Math.PI;
                    ptGeo = mdlGeodesic.geodesic_coordinate(new POINT2(C2d.getX(), C2d.getY()), length, az);
                    ptGeo2d = new Point2D.Double(ptGeo.x, ptGeo.y);
                    ptGeo2d = converter.GeoToPixels(ptGeo2d);
                    ptPixels = new POINT2(ptGeo2d.getX(), ptGeo2d.getY());
                    pArcLinePoints[j].x = ptPixels.x;
                    pArcLinePoints[j].y = ptPixels.y;
                }
            } else {
                for (j = 0; j < numarcpts; ++j) {
                    pArcLinePoints[j].x = (int)(dRadius * Math.cos(startangle + (double)j * increment));
                    pArcLinePoints[j].y = (int)(dRadius * Math.sin(startangle + (double)j * increment));
                }
                for (j = 0; j < numarcpts; ++j) {
                    pArcLinePoints[j].x += C.x;
                    pArcLinePoints[j].y += C.y;
                }
            }
            for (j = 0; j < numarcpts; ++j) {
                pResultLinePoints[j] = new POINT2(pArcLinePoints[j]);
            }
            pArcLinePoints = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ArcArrayDouble", new RendererException("Failed inside ArcArrayDouble", exc));
        }
        return pResultLinePoints;
    }

    protected static void CalcCircleDouble2(POINT2 Center, POINT2 pt1, int numpts, POINT2[] CirclePoints, IPointConversion converter) {
        try {
            int j = 0;
            double increment = Math.PI * 2 / (double)(numpts - 1);
            Point2D ptCenter2d = new Point2D.Double(Center.x, Center.y);
            ptCenter2d = converter.PixelsToGeo(ptCenter2d);
            Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
            pt12d = converter.PixelsToGeo(pt12d);
            Center = new POINT2(ptCenter2d.getX(), ptCenter2d.getY());
            pt1 = new POINT2(pt12d.getX(), pt12d.getY());
            double dist = mdlGeodesic.geodesic_distance(Center, pt1, null, null);
            double az = 0.0;
            double startangle = 0.0;
            double endAngle = Math.PI * 2;
            POINT2 ptGeo = null;
            POINT2 ptPixels = null;
            Point2D ptGeo2d = null;
            for (j = 0; j < numpts - 1; ++j) {
                az = startangle * 180.0 / Math.PI + (double)j * increment * 180.0 / Math.PI;
                ptGeo = mdlGeodesic.geodesic_coordinate(Center, dist, az);
                ptGeo2d = new Point2D.Double(ptGeo.x, ptGeo.y);
                ptGeo2d = converter.GeoToPixels(ptGeo2d);
                ptPixels = new POINT2(ptGeo2d.getX(), ptGeo2d.getY());
                CirclePoints[j].x = ptPixels.x;
                CirclePoints[j].y = ptPixels.y;
            }
            CirclePoints[numpts - 1] = new POINT2(CirclePoints[0]);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcCircleDouble2", new RendererException("Failed inside CalcCircleDouble2", exc));
        }
    }

    protected static void CalcCircleDouble(POINT2 Center, double radius, int numpts, POINT2[] CirclePoints, int styl) {
        try {
            int j = 0;
            double dSegmentAngle = Math.PI * 2 / (double)(numpts - 1);
            double x = 0.0;
            double y = 0.0;
            for (j = 0; j < numpts - 1; ++j) {
                x = Center.x + radius * Math.cos((double)j * dSegmentAngle);
                y = Center.y + radius * Math.sin((double)j * dSegmentAngle);
                CirclePoints[j] = new POINT2(x, y);
                CirclePoints[j].style = styl;
            }
            CirclePoints[numpts - 1] = new POINT2(CirclePoints[0]);
            switch (styl) {
                case 0: {
                    CirclePoints[numpts - 1].style = 0;
                    break;
                }
                case 9: {
                    CirclePoints[numpts - 1].style = 10;
                    break;
                }
                case 11: {
                    CirclePoints[numpts - 1].style = 12;
                    break;
                }
                default: {
                    CirclePoints[numpts - 1].style = 5;
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcCircleDouble", new RendererException("Failed inside CalcCircleDouble", exc));
        }
    }

    protected static Shape2 CalcCircleShape(POINT2 Center, double radius, int numpts, POINT2[] CirclePoints, int styl) {
        Shape2 shape = styl == 9 ? new Shape2(Shape2.SHAPE_TYPE_FILL) : new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
        shape.set_Style(styl);
        try {
            int j = 0;
            lineutility.CalcCircleDouble(Center, radius, numpts, CirclePoints, styl);
            shape.moveTo(CirclePoints[0]);
            for (j = 1; j < numpts; ++j) {
                shape.lineTo(CirclePoints[j]);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcCircleShape", new RendererException("Failed inside CalcCircleShape", exc));
        }
        return shape;
    }

    private static void GetSquallCurve(POINT2 StartPt, POINT2 EndPt, POINT2[] pSquallPts, int sign, double amplitude, int quantity) {
        try {
            double dist = lineutility.CalcDistanceDouble(StartPt, EndPt);
            POINT2 ptTemp = new POINT2();
            int j = 0;
            for (j = 0; j < quantity; ++j) {
                ptTemp = lineutility.ExtendLineDouble(EndPt, StartPt, -dist * (double)j / (double)quantity);
                pSquallPts[j].x = ptTemp.x;
                pSquallPts[j].y = ptTemp.y + amplitude * (double)sign * Math.sin((double)j * 180.0 / (double)quantity * Math.PI / 180.0);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSquallShape", new RendererException("Failed inside GeSquallShape", exc));
        }
    }

    protected static int GetSquallSegment(POINT2 StartPt, POINT2 EndPt, POINT2[] pSquallPts, ref<int[]> sign, double amplitude, int quantity, double length) {
        int counter = 0;
        try {
            POINT2[] pSquallPts2 = new POINT2[quantity];
            double dist = lineutility.CalcDistanceDouble(StartPt, EndPt);
            int numCurves = (int)(dist / length);
            int j = 0;
            int k = 0;
            POINT2 EndPt2 = new POINT2();
            double angle = Math.atan((StartPt.y - EndPt.y) / (StartPt.x - EndPt.x));
            int lAngle = (int)(57.29577951308232 * angle);
            lineutility.InitializePOINT2Array(pSquallPts2);
            EndPt2.x = StartPt.x < EndPt.x ? StartPt.x + dist : StartPt.x - dist;
            EndPt2.y = StartPt.y;
            POINT2 EndCurvePt = StartPt;
            for (j = 0; j < numCurves; ++j) {
                POINT2 StartCurvePt = lineutility.ExtendLineDouble(EndPt2, StartPt, -((double)j * length));
                EndCurvePt = lineutility.ExtendLineDouble(EndPt2, StartPt, -((double)(j + 1) * length));
                lineutility.GetSquallCurve(StartCurvePt, EndCurvePt, pSquallPts2, ((int[])sign.value)[0], amplitude, quantity);
                for (k = 0; k < quantity; ++k) {
                    pSquallPts[counter] = new POINT2(pSquallPts2[k]);
                    ++counter;
                }
                ((int[])sign.value)[0] = -((int[])sign.value)[0];
            }
            if (numCurves == 0) {
                pSquallPts[counter] = new POINT2(StartPt);
                pSquallPts[++counter] = new POINT2(EndPt);
                ++counter;
            }
            lineutility.RotateGeometryDoubleOrigin(pSquallPts, counter, lAngle);
            pSquallPts2 = null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSquallSegment", new RendererException("Failed inside GetSquallSegment", exc));
        }
        return counter;
    }

    private static int PointInBounds(POINT2 pt) {
        try {
            double maxPixels = 100000.0;
            if (Math.abs(pt.x) <= maxPixels && Math.abs(pt.y) <= maxPixels) {
                return 1;
            }
            return 0;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "PointInBounds", new RendererException("Failed inside PointInBounds", exc));
            return 1;
        }
    }

    private static int PointInBounds2(POINT2 pt, POINT2 ul, POINT2 lr) {
        try {
            double maxX = lr.x;
            double minX = ul.x;
            double maxY = lr.y;
            double minY = ul.y;
            if (pt.x <= maxX && pt.x >= minX && pt.y <= maxY && pt.y >= minY) {
                return 1;
            }
            return 0;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "PointInBounds2", new RendererException("Failed inside PointInBounds2", exc));
            return 1;
        }
    }

    private static POINT2 intersectSegment(POINT2 pt0, POINT2 pt1, POINT2 sidePt0, POINT2 sidePt1) {
        POINT2 pt = null;
        try {
            if (pt0.x == pt1.x) {
                return null;
            }
            double m = (pt1.y - pt0.y) / (pt1.x - pt0.x);
            double dx = 0.0;
            double dy = 0.0;
            double x = 0.0;
            double y = 0.0;
            POINT2 upper = null;
            POINT2 lower = null;
            POINT2 left = null;
            POINT2 right = null;
            Boolean bolVertical = false;
            if (sidePt0.x == sidePt1.x) {
                bolVertical = true;
                if (sidePt0.y < sidePt1.y) {
                    upper = sidePt0;
                    lower = sidePt1;
                } else {
                    upper = sidePt1;
                    lower = sidePt0;
                }
            } else if (sidePt0.x < sidePt1.x) {
                left = sidePt0;
                right = sidePt1;
            } else {
                left = sidePt1;
                right = sidePt0;
            }
            if (bolVertical.booleanValue()) {
                dx = upper.x - pt0.x;
                dy = m * dx;
                x = upper.x;
                y = pt0.y + dy;
                pt = new POINT2(x, y);
                if (pt0.x <= pt.x && pt.x <= pt1.x ? upper.y <= pt.y && pt.y <= lower.y : pt0.x >= pt.x && pt.x >= pt1.x && upper.y <= pt.y && pt.y <= lower.y) {
                    return pt;
                }
            } else {
                dy = left.y - pt0.y;
                dx = dy / m;
                x = pt0.x + dx;
                y = left.y;
                pt = new POINT2(x, y);
                if (pt0.y <= pt.y && pt.y <= pt1.y ? left.x <= pt.x && pt.x <= right.x : pt0.y >= pt.y && pt.y >= pt1.y && left.x <= pt.x && pt.x <= right.x) {
                    return pt;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "intersectSegment", new RendererException("Failed inside intersectSegment", exc));
        }
        return null;
    }

    public static POINT2[] BoundOneSegment(POINT2 pt0, POINT2 pt1, POINT2 ul, POINT2 lr) {
        POINT2[] line = new POINT2[2];
        try {
            if (pt0.y < ul.y && pt1.y < ul.y) {
                return null;
            }
            if (pt0.y > lr.y && pt1.y > lr.y) {
                return null;
            }
            if (pt0.x < ul.x && pt1.x < ul.x) {
                return null;
            }
            if (pt0.x > lr.x && pt1.x > lr.x) {
                return null;
            }
            Boolean bolVertical = false;
            lineutility.InitializePOINT2Array(line);
            if (pt0.x == pt1.x) {
                bolVertical = true;
            }
            if (bolVertical.booleanValue()) {
                line[0] = new POINT2(pt0);
                if (line[0].y < ul.y) {
                    line[0].y = ul.y;
                }
                if (line[0].y > lr.y) {
                    line[0].y = lr.y;
                }
                line[1] = new POINT2(pt1);
                if (line[1].y < ul.y) {
                    line[1].y = ul.y;
                }
                if (line[1].y > lr.y) {
                    line[1].y = lr.y;
                }
                return line;
            }
            double dx = 0.0;
            double dy = 0.0;
            double x = 0.0;
            double y = 0.0;
            double m = (pt1.y - pt0.y) / (pt1.x - pt0.x);
            Boolean side0Intersect = false;
            Boolean side1Intersect = false;
            Boolean side2Intersect = false;
            Boolean side3Intersect = false;
            POINT2 ur = new POINT2(lr.x, ul.y);
            POINT2 ll = new POINT2(ul.x, lr.y);
            POINT2 pt0Intersect = null;
            if (lineutility.PointInBounds2(pt0, ul, lr) == 1) {
                pt0Intersect = pt0;
            }
            if (pt0Intersect == null) {
                pt0Intersect = lineutility.intersectSegment(pt0, pt1, ll, ul);
                side0Intersect = true;
            }
            if (pt0Intersect == null) {
                pt0Intersect = lineutility.intersectSegment(pt0, pt1, ul, ur);
                side1Intersect = true;
            }
            if (pt0Intersect == null) {
                pt0Intersect = lineutility.intersectSegment(pt0, pt1, ur, lr);
                side2Intersect = true;
            }
            if (pt0Intersect == null) {
                pt0Intersect = lineutility.intersectSegment(pt0, pt1, ll, lr);
                side3Intersect = true;
            }
            POINT2 pt1Intersect = null;
            if (lineutility.PointInBounds2(pt1, ul, lr) == 1) {
                pt1Intersect = pt1;
            }
            if (pt1Intersect == null && !side0Intersect.booleanValue()) {
                pt1Intersect = lineutility.intersectSegment(pt1, pt0, ll, ul);
            }
            if (pt1Intersect == null && !side1Intersect.booleanValue()) {
                pt1Intersect = lineutility.intersectSegment(pt1, pt0, ul, ur);
            }
            if (pt1Intersect == null && !side2Intersect.booleanValue()) {
                pt1Intersect = lineutility.intersectSegment(pt1, pt0, ur, lr);
            }
            if (pt1Intersect == null && !side3Intersect.booleanValue()) {
                pt1Intersect = lineutility.intersectSegment(pt1, pt0, ll, lr);
            }
            if (pt0Intersect != null && pt1Intersect != null) {
                line[0] = pt0Intersect;
                line[1] = pt1Intersect;
            } else {
                line = null;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "BoundOneSegment", new RendererException("Failed inside BoundOneSegment", exc));
        }
        return line;
    }

    private static int DisplayIntersectPixels(POINT2 pt0, POINT2 pt1, ref<double[]> pt2x, ref<double[]> pt2y, ref<double[]> pt3x, ref<double[]> pt3y) {
        int nResult = -1;
        try {
            double X = 0.0;
            double Y = 0.0;
            ref<double[]> m = new ref<double[]>();
            double maxPixels = 2000.0;
            boolean bol0Inside = false;
            boolean bol1Inside = false;
            int bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
            double b = pt0.y - ((double[])m.value)[0] * pt0.x;
            pt2x.value = new double[1];
            pt2y.value = new double[1];
            pt3x.value = new double[1];
            pt3y.value = new double[1];
            POINT2 pt2 = new POINT2(pt0);
            POINT2 pt3 = new POINT2(pt1);
            if (pt0.x <= maxPixels && pt0.x >= -maxPixels && pt0.y <= maxPixels && pt0.y >= -maxPixels) {
                bol0Inside = true;
            }
            if (pt1.x <= maxPixels && pt1.x >= -maxPixels && pt1.y <= maxPixels && pt1.y >= -maxPixels) {
                bol1Inside = true;
            }
            if (bol0Inside && bol1Inside) {
                return 0;
            }
            if (bol0Inside || bol1Inside) {
                nResult = 1;
            }
            if (bolVertical != 0) {
                X = -maxPixels;
                Y = ((double[])m.value)[0] * X + b;
                if (pt0.x < -maxPixels && -maxPixels < pt1.x && -maxPixels <= Y && Y <= maxPixels) {
                    pt2.x = X;
                    pt2.y = Y;
                    nResult = 1;
                }
                if (pt1.x < -maxPixels && -maxPixels < pt0.x && -maxPixels <= Y && Y <= maxPixels) {
                    pt3.x = X;
                    pt3.y = Y;
                    nResult = 1;
                }
                Y = -maxPixels;
                if (((double[])m.value)[0] != 0.0) {
                    X = (Y - b) / ((double[])m.value)[0];
                    if (pt0.y < -maxPixels && -maxPixels < pt1.y && -maxPixels <= X && X <= maxPixels) {
                        pt2.x = X;
                        pt2.y = Y;
                        nResult = 1;
                    }
                    if (pt1.y <= -maxPixels && -maxPixels <= pt0.y && -maxPixels < X && X < maxPixels) {
                        pt3.x = X;
                        pt3.y = Y;
                        nResult = 1;
                    }
                }
                X = maxPixels;
                Y = ((double[])m.value)[0] * X + b;
                if (pt0.x < maxPixels && maxPixels < pt1.x && -maxPixels <= Y && Y <= maxPixels) {
                    pt3.x = X;
                    pt3.y = Y;
                    nResult = 1;
                }
                if (pt1.x < maxPixels && maxPixels < pt0.x && -maxPixels <= Y && Y <= maxPixels) {
                    pt2.x = X;
                    pt2.y = Y;
                    nResult = 1;
                }
                Y = maxPixels;
                if (((double[])m.value)[0] != 0.0) {
                    X = (Y - b) / ((double[])m.value)[0];
                    if (pt0.y < maxPixels && maxPixels < pt1.y && -maxPixels <= X && X <= maxPixels) {
                        pt3.x = X;
                        pt3.y = Y;
                        nResult = 1;
                    }
                    if (pt1.y < maxPixels && maxPixels < pt0.y && -maxPixels <= X && X <= maxPixels) {
                        pt2.x = X;
                        pt2.y = Y;
                        nResult = 1;
                    }
                }
            }
            if (bolVertical == 0) {
                X = pt0.x;
                Y = -maxPixels;
                if (-maxPixels < pt0.x && pt0.x < maxPixels) {
                    if (pt0.y <= -maxPixels && -maxPixels <= pt1.y) {
                        pt2.x = X;
                        pt2.y = Y;
                        nResult = 1;
                    }
                    if (pt1.y <= -maxPixels && -maxPixels <= pt0.y) {
                        pt3.x = X;
                        pt3.y = Y;
                        nResult = 1;
                    }
                }
                X = pt0.x;
                Y = maxPixels;
                if (-maxPixels < pt0.x && pt0.x < maxPixels) {
                    if (pt0.y <= maxPixels && maxPixels <= pt1.y) {
                        pt3.x = X;
                        pt3.y = Y;
                        nResult = 1;
                    }
                    if (pt1.y <= maxPixels && maxPixels <= pt0.y) {
                        pt2.x = X;
                        pt2.y = Y;
                        nResult = 1;
                    }
                }
            }
            ((double[])pt2x.value)[0] = pt2.x;
            ((double[])pt2y.value)[0] = pt2.y;
            ((double[])pt3x.value)[0] = pt3.x;
            ((double[])pt3y.value)[0] = pt3.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "DisplayIntersectPixels", new RendererException("Failed inside DisplayIntersectPixels", exc));
        }
        return nResult;
    }

    protected static int GetDitchSpikeDouble(TGLight tg, POINT2[] pLinePoints, int nOldCounter, int bWayIs) {
        int nSpikeCounter = 0;
        try {
            int j;
            int linetype = tg.get_LineType();
            int nNumberOfSegments = 0;
            int lCircleCounter = 0;
            int bolVertical = 0;
            int nTemp = 0;
            double dPrinter = 1.0;
            double dIntLocation1x = 0.0;
            double dIntLocation2x = 0.0;
            double dIntLocation1y = 0.0;
            double dIntLocation2y = 0.0;
            double r = 0.0;
            double s = 0.0;
            double use = 0.0;
            double length = 0.0;
            double k = 0.0;
            double bint = 0.0;
            ref<double[]> pdAnswer = new ref<double[]>();
            ref<double[]> m = new ref<double[]>();
            POINT2 UpperLinePoint = new POINT2(pLinePoints[0]);
            POINT2 Lower1LinePoint = new POINT2(pLinePoints[0]);
            POINT2 Lower2LinePoint = new POINT2(pLinePoints[0]);
            POINT2 a = new POINT2(pLinePoints[0]);
            POINT2 b = new POINT2(pLinePoints[0]);
            POINT2[] pCirclePoints = new POINT2[pLinePoints.length];
            POINT2 averagePoint = new POINT2();
            POINT2 lastAveragePoint = new POINT2();
            POINT2[] pTempLinePoints = null;
            pTempLinePoints = new POINT2[nOldCounter];
            for (j = 0; j < nOldCounter; ++j) {
                pTempLinePoints[j] = new POINT2(pLinePoints[j]);
            }
            ArrayList<POINT2> basePoints = new ArrayList<POINT2>();
            lineutility.InitializePOINT2Array(pCirclePoints);
            nSpikeCounter = nOldCounter;
            double spikeLength = arraysupport.getScaledSize(12.0, tg.get_LineThickness(), tg.get_patternScale());
            double spikeHeight = spikeLength * 1.25;
            double minLength = 2.0 * spikeLength;
            for (int i = 0; i < nOldCounter - 1; ++i) {
                if (linetype == 23132000 && i == 0) {
                    double radius = arraysupport.getScaledSize(4.0, tg.get_LineThickness(), tg.get_patternScale());
                    minLength = spikeLength * 2.5 + radius * 2.0;
                }
                nTemp = lineutility.CalcTrueLinesDouble((long)(spikeHeight * dPrinter), pLinePoints[i], pLinePoints[i + 1], pdAnswer);
                r = ((double[])pdAnswer.value)[3];
                s = ((double[])pdAnswer.value)[5];
                length = lineutility.CalcDistanceDouble(pLinePoints[i], pLinePoints[i + 1]);
                bolVertical = lineutility.CalcTrueSlopeDouble(pLinePoints[i], pLinePoints[i + 1], m);
                nNumberOfSegments = (int)((length - 1.0) / (spikeLength * dPrinter));
                if (length > minLength * dPrinter) {
                    if (bWayIs != 0) {
                        if (pLinePoints[i].x <= pLinePoints[i + 1].x) {
                            use = r;
                        }
                        if (pLinePoints[i].x >= pLinePoints[i + 1].x) {
                            use = s;
                        }
                    } else {
                        if (pLinePoints[i].x <= pLinePoints[i + 1].x) {
                            use = s;
                        }
                        if (pLinePoints[i].x >= pLinePoints[i + 1].x) {
                            use = r;
                        }
                    }
                    for (j = 1; j <= nNumberOfSegments; ++j) {
                        k = j;
                        a = new POINT2(pLinePoints[i]);
                        b = new POINT2(pLinePoints[i + 1]);
                        dIntLocation1x = j > 1 ? dIntLocation2x : pLinePoints[i].x + (k * spikeLength - spikeLength / 2.0) * dPrinter / length * (pLinePoints[i + 1].x - pLinePoints[i].x);
                        dIntLocation1y = j > 1 ? dIntLocation2y : pLinePoints[i].y + (k * spikeLength - spikeLength / 2.0) * dPrinter / length * (pLinePoints[i + 1].y - pLinePoints[i].y);
                        dIntLocation2x = pLinePoints[i].x + (k * spikeLength + spikeLength / 2.0) * dPrinter / length * (pLinePoints[i + 1].x - pLinePoints[i].x);
                        dIntLocation2y = pLinePoints[i].y + (k * spikeLength + spikeLength / 2.0) * dPrinter / length * (pLinePoints[i + 1].y - pLinePoints[i].y);
                        if (((double[])m.value)[0] != 0.0 && bolVertical != 0) {
                            bint = (dIntLocation1y + dIntLocation2y) / 2.0 + 1.0 / ((double[])m.value)[0] * (dIntLocation1x + dIntLocation2x) / 2.0;
                            UpperLinePoint = lineutility.CalcTrueIntersectDouble2(((double[])m.value)[0], use, -1.0 / ((double[])m.value)[0], bint, 1, 1, pLinePoints[0].x, pLinePoints[0].y);
                        }
                        if (bolVertical == 0) {
                            UpperLinePoint.y = dIntLocation1y < dIntLocation2y ? (double)((int)dIntLocation1y + (int)(length / (double)nNumberOfSegments / 2.0)) : (double)((int)dIntLocation1y - (int)(length / (double)nNumberOfSegments / 2.0));
                            UpperLinePoint.x = pLinePoints[i].y < pLinePoints[i + 1].y ? (double)((int)dIntLocation1x + (int)(length / (double)nNumberOfSegments)) : (double)((int)dIntLocation1x - (int)(length / (double)nNumberOfSegments));
                        }
                        if (((double[])m.value)[0] == 0.0 && bolVertical != 0) {
                            UpperLinePoint.x = dIntLocation1x < dIntLocation2x ? (double)((int)dIntLocation1x + (int)(length / (double)nNumberOfSegments / 2.0)) : (double)((int)dIntLocation1x - (int)(length / (double)nNumberOfSegments / 2.0));
                            UpperLinePoint.y = pLinePoints[i + 1].x < pLinePoints[i].x ? (double)((int)dIntLocation1y + (int)(length / (double)nNumberOfSegments)) : (double)((int)dIntLocation1y - (int)(length / (double)nNumberOfSegments));
                        }
                        Lower1LinePoint.x = dIntLocation1x;
                        Lower1LinePoint.y = dIntLocation1y;
                        Lower2LinePoint.x = dIntLocation2x;
                        Lower2LinePoint.y = dIntLocation2y;
                        pLinePoints[nSpikeCounter] = new POINT2(Lower1LinePoint);
                        if (linetype == 23131200 || linetype == 23132000) {
                            pLinePoints[nSpikeCounter].style = 9;
                        }
                        if (j % 2 == 1 && linetype == 23132000) {
                            pLinePoints[nSpikeCounter].style = 5;
                        }
                        pLinePoints[++nSpikeCounter] = new POINT2(UpperLinePoint);
                        if ((long)linetype == 23131200L || (long)linetype == 23132000L) {
                            pLinePoints[nSpikeCounter].style = 9;
                        }
                        if (j % 2 == 1 && linetype == 23132000) {
                            pLinePoints[nSpikeCounter].style = 5;
                        }
                        pLinePoints[++nSpikeCounter] = new POINT2(Lower2LinePoint);
                        if ((long)linetype == 23131200L || (long)linetype == 23132000L) {
                            pLinePoints[nSpikeCounter].style = 10;
                        }
                        if (j % 2 == 1 && linetype == 23132000) {
                            pLinePoints[nSpikeCounter].style = 5;
                        }
                        ++nSpikeCounter;
                        if (linetype == 23132000) {
                            if (j % 2 == 0) {
                                averagePoint = lineutility.MidPointDouble(Lower1LinePoint, Lower2LinePoint, 0);
                                averagePoint = lineutility.MidPointDouble(averagePoint, UpperLinePoint, 0);
                            } else if (j == 1) {
                                averagePoint = lineutility.ExtendLineDouble(Lower2LinePoint, Lower1LinePoint, 5.0);
                                averagePoint = lineutility.MidPointDouble(averagePoint, UpperLinePoint, 0);
                            }
                        }
                        if (j > 1 && j < nNumberOfSegments) {
                            basePoints.add(new POINT2(Lower1LinePoint));
                        } else if (j == 1) {
                            basePoints.add(new POINT2(pLinePoints[i]));
                        } else if (j == nNumberOfSegments) {
                            basePoints.add(new POINT2(pLinePoints[i + 1]));
                            ((POINT2)basePoints.get((int)(basePoints.size() - 1))).style = 5;
                        }
                        if (linetype == 23132000 && j > 1 && j % 2 == 0) {
                            pCirclePoints[lCircleCounter] = lineutility.MidPointDouble(averagePoint, lastAveragePoint, 20);
                            ++lCircleCounter;
                        }
                        if (j >= nNumberOfSegments || linetype != 23132000 || j != 1 && j % 2 != 0) continue;
                        lastAveragePoint = new POINT2(averagePoint);
                    }
                    continue;
                }
                pLinePoints[nSpikeCounter].x = pLinePoints[i].x;
                pLinePoints[nSpikeCounter].y = pLinePoints[i].y;
                pLinePoints[nSpikeCounter].style = 0;
                pLinePoints[++nSpikeCounter].x = pLinePoints[i + 1].x;
                pLinePoints[nSpikeCounter].y = pLinePoints[i + 1].y;
                pLinePoints[nSpikeCounter].style = 5;
                ++nSpikeCounter;
            }
            for (j = 0; j < nOldCounter; ++j) {
                pLinePoints[j] = new POINT2(pTempLinePoints[nOldCounter - j - 1]);
                pLinePoints[j].style = 5;
            }
            if (pLinePoints[nSpikeCounter - 1].style == 0) {
                pLinePoints[nSpikeCounter - 1].style = 5;
            }
            int t = basePoints.size();
            for (j = nSpikeCounter; j < nSpikeCounter + t; ++j) {
                pLinePoints[j] = new POINT2((POINT2)basePoints.get(j - nSpikeCounter));
                if (pLinePoints[j].style == 5) continue;
                pLinePoints[j].style = 0;
            }
            nSpikeCounter += basePoints.size();
            if (linetype == 23132000) {
                pLinePoints[nSpikeCounter - 1].style = 5;
                for (j = nSpikeCounter; j < nSpikeCounter + lCircleCounter; ++j) {
                    pLinePoints[j] = new POINT2(pCirclePoints[j - nSpikeCounter]);
                    pLinePoints[j].style = 20;
                }
                nSpikeCounter += lCircleCounter;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetDitchSpikeDouble", new RendererException("Failed inside GetDitchSpikeDouble", exc));
        }
        return nSpikeCounter;
    }

    protected static void MoveChannelPixels(POINT2[] pLinePoints) {
        try {
            int j;
            if (pLinePoints == null || pLinePoints.length <= 0) {
                return;
            }
            double[] pixels = new double[pLinePoints.length * 2];
            int k = 0;
            int count = pLinePoints.length;
            for (j = 0; j < count; ++j) {
                pixels[k++] = pLinePoints[j].x;
                pixels[k++] = pLinePoints[j].y;
            }
            boolean bolNoRepeats = false;
            block3: do {
                bolNoRepeats = true;
                for (j = 0; j < count - 1; ++j) {
                    double x1 = pixels[2 * j];
                    double y1 = pixels[2 * j + 1];
                    double x2 = pixels[2 * j + 2];
                    double y2 = pixels[2 * j + 3];
                    if (x1 != x2 || y1 != y2) continue;
                    bolNoRepeats = false;
                    pixels[2 * j + 2] = (long)x2 + 1L;
                    continue block3;
                }
            } while (!bolNoRepeats);
            k = 0;
            for (j = 0; j < count; ++j) {
                pLinePoints[j].x = pixels[k++];
                pLinePoints[j].y = pixels[k++];
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "MoveChannelPixels", new RendererException("Failed inside MoveChannelPixels", exc));
        }
    }

    protected static void moveSingleCPixels(int linetype, POINT2[] pLinePoints) {
        try {
            switch (linetype) {
                case 231117100: {
                    break;
                }
                default: {
                    return;
                }
            }
            if (pLinePoints.length > 1 && pLinePoints[1].y == pLinePoints[0].y) {
                pLinePoints[1].y += 1.0;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "MoveSingleCPixels", new RendererException("Failed inside MoveSingleCPixels", exc));
        }
    }

    protected static void RotateGeometryDouble(POINT2[] pLinePoints, int vblCounter, double lAngle) {
        try {
            int j = 0;
            double dRotate = 0.0;
            double dTheta = 0.0;
            double dGamma = 0.0;
            double x = 0.0;
            double y = 0.0;
            if (lAngle != 0.0) {
                dRotate = lAngle * Math.PI / 180.0;
                POINT2 pdCenter = lineutility.CalcCenterPointDouble(pLinePoints, vblCounter);
                for (j = 0; j < vblCounter; ++j) {
                    dGamma = pLinePoints[j].x == pdCenter.x ? (pLinePoints[j].y > pdCenter.y ? 4.71238898038469 : 1.5707963267948966) : Math.PI + Math.atan((pLinePoints[j].y - pdCenter.y) / (pLinePoints[j].x - pdCenter.x));
                    if (pLinePoints[j].x >= pdCenter.x) {
                        dGamma += Math.PI;
                    }
                    dTheta = dRotate + dGamma;
                    y = lineutility.CalcDistanceDouble(pLinePoints[j], pdCenter) * Math.sin(dTheta);
                    x = lineutility.CalcDistanceDouble(pLinePoints[j], pdCenter) * Math.cos(dTheta);
                    pLinePoints[j].y = pdCenter.y + y;
                    pLinePoints[j].x = pdCenter.x + x;
                }
                return;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "RotateGeometryDouble", new RendererException("Failed inside RotateGeometryDouble", exc));
        }
    }

    public static POINT2 ClosestPointOnLine(POINT2 pt0, POINT2 pt1, POINT2 ptRelative) {
        if (pt0.x == ptRelative.x && pt0.y == ptRelative.y) {
            return new POINT2(pt0);
        }
        if (pt1.x == ptRelative.x && pt1.y == ptRelative.y) {
            return new POINT2(pt1);
        }
        if (pt0.x == pt1.x && pt0.y == pt1.y) {
            return new POINT2(pt0);
        }
        POINT2 atob = new POINT2(pt1.x - pt0.x, pt1.y - pt0.y);
        POINT2 atop = new POINT2(ptRelative.x - pt0.x, ptRelative.y - pt0.y);
        double len = atob.x * atob.x + atob.y * atob.y;
        double dot = atop.x * atob.x + atop.y * atob.y;
        double t = Math.min(1.0, Math.max(0.0, dot / len));
        return new POINT2(pt0.x + atob.x * t, pt0.y + atob.y * t);
    }

    private static POINT2 getIntersectionPoint(POINT2 pt1, POINT2 pt2, POINT2 pt3, POINT2 pt4) {
        double denom = (pt4.y - pt3.y) * (pt2.x - pt1.x) - (pt4.x - pt3.x) * (pt2.y - pt1.y);
        if (denom == 0.0) {
            return null;
        }
        double ua = ((pt4.x - pt3.x) * (pt1.y - pt3.y) - (pt4.y - pt3.y) * (pt1.x - pt3.x)) / denom;
        double ub = ((pt2.x - pt1.x) * (pt1.y - pt3.y) - (pt2.y - pt1.y) * (pt1.x - pt3.x)) / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            double intersectX = pt1.x + ua * (pt2.x - pt1.x);
            double intersectY = pt1.y + ua * (pt2.y - pt1.y);
            return new POINT2(intersectX, intersectY);
        }
        return null;
    }

    public static POINT2 intersectPolygon(POINT2[] polyPts, POINT2 pt0, POINT2 pt1) {
        for (int i = 0; i < polyPts.length; ++i) {
            POINT2 temp = lineutility.getIntersectionPoint(polyPts[i], polyPts[(i + 1) % polyPts.length], pt0, pt1);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    protected static POINT2 PointRelativeToLine(POINT2 pt0, POINT2 pt1, POINT2 ptRelative) {
        POINT2 ptResult = new POINT2(pt0);
        try {
            int bolVertical = 0;
            ref<double[]> m = new ref<double[]>();
            POINT2 midPt = lineutility.MidPointDouble(pt0, pt1, 0);
            double b1 = 0.0;
            double b2 = 0.0;
            bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
            if (bolVertical == 0) {
                ptResult.x = ptRelative.x;
                ptResult.y = midPt.y;
            }
            if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                ptResult.x = midPt.x;
                ptResult.y = ptRelative.y;
            }
            if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                b1 = midPt.y + 1.0 / ((double[])m.value)[0] * midPt.x;
                b2 = ptRelative.y - ((double[])m.value)[0] * ptRelative.x;
                ptResult = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b1, ((double[])m.value)[0], b2, 1, 1, 0.0, 0.0);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "PointRelativeToLine", new RendererException("Failed inside PointRelativeToLine", exc));
        }
        return ptResult;
    }

    public static void adjustCATKBYFIREControlPoint(int linetype, ArrayList<POINT2> pLinePoints, double dist) {
        try {
            if (linetype != 21710000) {
                return;
            }
            double dist2 = lineutility.CalcDistanceDouble(pLinePoints.get(0), pLinePoints.get(1));
            if (dist2 <= dist) {
                return;
            }
            POINT2 pt = null;
            int count = pLinePoints.size();
            POINT2 pt0 = new POINT2(pLinePoints.get(0));
            POINT2 pt1 = new POINT2(pLinePoints.get(1));
            POINT2 controlPt = new POINT2(pLinePoints.get(count - 1));
            POINT2 pt4 = lineutility.PointRelativeToLine(pt0, pt1, pt1, controlPt);
            pt = lineutility.ExtendLineDouble(pt4, controlPt, dist);
            pLinePoints.set(count - 1, pt);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "adjustCATKBYFIREControlPoint", new RendererException("Failed inside adjustCATKBYFIREControlPoint", exc));
        }
    }

    public static POINT2 PointRelativeToLine(POINT2 pt0, POINT2 pt1, POINT2 atPoint, POINT2 ptRelative) {
        POINT2 ptResult = new POINT2(pt0);
        try {
            int bolVertical = 0;
            ref<double[]> m = new ref<double[]>();
            double b1 = 0.0;
            double b2 = 0.0;
            bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
            if (bolVertical == 0) {
                ptResult.x = ptRelative.x;
                ptResult.y = atPoint.y;
            }
            if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                ptResult.x = atPoint.x;
                ptResult.y = ptRelative.y;
            }
            if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                b1 = atPoint.y + 1.0 / ((double[])m.value)[0] * atPoint.x;
                b2 = ptRelative.y - ((double[])m.value)[0] * ptRelative.x;
                ptResult = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b1, ((double[])m.value)[0], b2, 1, 1, 0.0, 0.0);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "PointRelativeToLine", new RendererException("Failed inside PointRelativeToLine", exc));
        }
        return ptResult;
    }

    public static void LineRelativeToLine(POINT2 pt0, POINT2 pt1, POINT2 ptRelative, POINT2 pt2, POINT2 pt3) {
        try {
            int bolVertical = 0;
            ref<double[]> m = new ref<double[]>();
            double b1 = 0.0;
            double b2 = 0.0;
            POINT2 pt2Temp = null;
            POINT2 pt3Temp = null;
            bolVertical = lineutility.CalcTrueSlopeDouble(pt0, pt1, m);
            if (bolVertical == 0) {
                pt2.x = ptRelative.x;
                pt2.y = pt0.y;
                pt3.x = ptRelative.x;
                pt3.y = pt1.y;
            }
            if (bolVertical != 0 && ((double[])m.value)[0] == 0.0) {
                pt2.x = pt0.x;
                pt2.y = ptRelative.y;
                pt3.x = pt1.x;
                pt3.y = ptRelative.y;
            }
            if (bolVertical != 0 && ((double[])m.value)[0] != 0.0) {
                b1 = pt0.y + 1.0 / ((double[])m.value)[0] * pt0.x;
                b2 = ptRelative.y - ((double[])m.value)[0] * ptRelative.x;
                pt2Temp = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b1, ((double[])m.value)[0], b2, 1, 1, 0.0, 0.0);
                b1 = pt1.y + 1.0 / ((double[])m.value)[0] * pt1.x;
                pt3Temp = lineutility.CalcTrueIntersectDouble2(-1.0 / ((double[])m.value)[0], b1, ((double[])m.value)[0], b2, 1, 1, 0.0, 0.0);
                pt2.x = pt2Temp.x;
                pt2.y = pt2Temp.y;
                pt3.x = pt3Temp.x;
                pt3.y = pt3Temp.y;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "LineRelativeToLine", new RendererException("Failed inside LineRelativeToLine", exc));
        }
    }

    private static void CalcMBR(POINT2[] pLinePoints, int numpts, ref<double[]> ulx, ref<double[]> uly, ref<double[]> lrx, ref<double[]> lry) {
        try {
            int j = 0;
            ulx.value = new double[1];
            uly.value = new double[1];
            lrx.value = new double[1];
            lry.value = new double[1];
            ((double[])ulx.value)[0] = Double.MAX_VALUE;
            ((double[])uly.value)[0] = Double.MAX_VALUE;
            ((double[])lrx.value)[0] = -1.7976931348623157E308;
            ((double[])lry.value)[0] = -1.7976931348623157E308;
            for (j = 0; j < numpts; ++j) {
                if (pLinePoints[j].x > ((double[])lrx.value)[0]) {
                    ((double[])lrx.value)[0] = pLinePoints[j].x;
                }
                if (pLinePoints[j].y > ((double[])lry.value)[0]) {
                    ((double[])lry.value)[0] = pLinePoints[j].y;
                }
                if (pLinePoints[j].x < ((double[])ulx.value)[0]) {
                    ((double[])ulx.value)[0] = pLinePoints[j].x;
                }
                if (!(pLinePoints[j].y < ((double[])uly.value)[0])) continue;
                ((double[])uly.value)[0] = pLinePoints[j].y;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcMBR", new RendererException("Failed inside CalcMBR", exc));
        }
    }

    public static void CalcMBRPoints(POINT2[] pLinePoints, int numpts, POINT2 ul, POINT2 lr) {
        try {
            int j = 0;
            ul.x = Double.MAX_VALUE;
            ul.y = Double.MAX_VALUE;
            lr.x = -1.7976931348623157E308;
            lr.y = -1.7976931348623157E308;
            for (j = 0; j < numpts; ++j) {
                if (pLinePoints[j].x > lr.x) {
                    lr.x = pLinePoints[j].x;
                }
                if (pLinePoints[j].y > lr.y) {
                    lr.y = pLinePoints[j].y;
                }
                if (pLinePoints[j].x < ul.x) {
                    ul.x = pLinePoints[j].x;
                }
                if (!(pLinePoints[j].y < ul.y)) continue;
                ul.y = pLinePoints[j].y;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "CalcMBRPoints", new RendererException("Failed inside CalcMBRPoints", exc));
        }
    }

    protected static double MBRDistance(POINT2[] pLinePoints, int numpts) {
        double result = 0.0;
        try {
            ref<double[]> ulx = new ref<double[]>();
            ref<double[]> uly = new ref<double[]>();
            ref<double[]> lrx = new ref<double[]>();
            ref<double[]> lry = new ref<double[]>();
            lineutility.CalcMBR(pLinePoints, numpts, ulx, uly, lrx, lry);
            result = Math.sqrt((((double[])lrx.value)[0] - ((double[])ulx.value)[0]) * (((double[])lrx.value)[0] - ((double[])ulx.value)[0]) + (((double[])lry.value)[0] - ((double[])uly.value)[0]) * (((double[])lry.value)[0] - ((double[])uly.value)[0]));
            double xdist = Math.abs(((double[])lrx.value)[0] - ((double[])ulx.value)[0]);
            double ydist = Math.abs(((double[])lry.value)[0] - ((double[])uly.value)[0]);
            double max = xdist;
            if (ydist > xdist) {
                max = ydist;
            }
            if ((result == 0.0 || Double.isInfinite(result)) && max > 0.0) {
                result = max;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "MBRDistance", new RendererException("Failed inside MBRDistance", exc));
        }
        return result;
    }

    protected static void Reverse2Points(POINT2 pt1, POINT2 pt2) {
        try {
            POINT2 tempPt = new POINT2();
            tempPt.x = pt1.x;
            tempPt.y = pt1.y;
            pt1.x = pt2.x;
            pt1.y = pt2.y;
            pt2.x = tempPt.x;
            pt2.y = tempPt.y;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "Reverse2Points", new RendererException("Failed inside Reverse2Points", exc));
        }
    }

    public static Shape createStrokedShape(Shape shape) {
        GeneralPath newshape = new GeneralPath();
        try {
            double[] coords = new double[6];
            PathIterator i = shape.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                switch (type) {
                    case 0: {
                        newshape.moveTo(coords[0], coords[1]);
                        break;
                    }
                    case 1: {
                        newshape.lineTo(coords[0], coords[1]);
                        break;
                    }
                    case 2: {
                        newshape.quadTo(coords[0], coords[1], coords[2], coords[3]);
                        break;
                    }
                    case 3: {
                        newshape.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                        break;
                    }
                    case 4: {
                        newshape.closePath();
                    }
                }
                i.next();
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createStrokedShape", new RendererException("Failed inside createStrokedShape", exc));
        }
        return newshape;
    }

    private static int distance(Point p1, Point p2, Point p3) {
        try {
            int x1 = p1.x;
            int x2 = p2.x;
            int x3 = p3.x;
            int y1 = p1.y;
            int y2 = p2.y;
            int y3 = p3.y;
            return x1 * y2 + x3 * y1 + x2 * y3 - x3 * y2 - x2 * y1 - x1 * y3;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "distance", new RendererException("Failed inside distance", exc));
            return 0;
        }
    }

    private static double distance2(POINT2 p1, POINT2 p2, POINT2 p3) {
        try {
            double x1 = p1.x;
            double x2 = p2.x;
            double x3 = p3.x;
            double y1 = p1.y;
            double y2 = p2.y;
            double y3 = p3.y;
            return x1 * y2 + x3 * y1 + x2 * y3 - x3 * y2 - x2 * y1 - x1 * y3;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "distance2", new RendererException("Failed inside distance2", exc));
            return 0.0;
        }
    }

    private static void cHull(ArrayList<Point> points, Point l, Point r, ArrayList<Point> path) {
        if (points.size() < 3) {
            return;
        }
        int maxDist = 0;
        Point p = null;
        for (Point pt : points) {
            int tmp;
            if (pt == l || pt == r || (tmp = lineutility.distance(l, r, pt)) <= maxDist) continue;
            maxDist = tmp;
            p = pt;
        }
        ArrayList<Point> left = new ArrayList<Point>();
        ArrayList<Point> right = new ArrayList<Point>();
        left.add(l);
        right.add(p);
        for (Point pt : points) {
            if (lineutility.distance(l, p, pt) > 0) {
                left.add(pt);
                continue;
            }
            if (lineutility.distance(p, r, pt) <= 0) continue;
            right.add(pt);
        }
        left.add(p);
        right.add(r);
        lineutility.cHull(left, l, p, path);
        path.add(p);
        lineutility.cHull(right, p, r, path);
    }

    private static void cHull2(ArrayList<POINT2> points, POINT2 l, POINT2 r, ArrayList<POINT2> path) {
        if (points.size() < 3) {
            return;
        }
        double maxDist = 0.0;
        POINT2 p = null;
        for (POINT2 pt : points) {
            double tmp;
            if (pt == l || pt == r || !((tmp = lineutility.distance2(l, r, pt)) > maxDist)) continue;
            maxDist = tmp;
            p = pt;
        }
        ArrayList<POINT2> left = new ArrayList<POINT2>();
        ArrayList<POINT2> right = new ArrayList<POINT2>();
        left.add(l);
        right.add(p);
        for (POINT2 pt : points) {
            if (lineutility.distance2(l, p, pt) > 0.0) {
                left.add(pt);
                continue;
            }
            if (!(lineutility.distance2(p, r, pt) > 0.0)) continue;
            right.add(pt);
        }
        left.add(p);
        right.add(r);
        lineutility.cHull2(left, l, p, path);
        path.add(p);
        lineutility.cHull2(right, p, r, path);
    }

    public static ArrayList<Point> cHull(ArrayList<Point> array) {
        int size = array.size();
        if (size < 2) {
            return null;
        }
        Point l = array.get(0);
        Point r = array.get(size - 1);
        ArrayList<Point> path = new ArrayList<Point>();
        path.add(l);
        lineutility.cHull(array, l, r, path);
        path.add(r);
        lineutility.cHull(array, r, l, path);
        return path;
    }

    public static ArrayList<POINT2> cHull2(ArrayList<POINT2> array) {
        try {
            int size = array.size();
            if (size < 2) {
                return null;
            }
            POINT2 l = array.get(0);
            POINT2 r = array.get(size - 1);
            ArrayList<POINT2> path = new ArrayList<POINT2>();
            path.add(l);
            lineutility.cHull2(array, l, r, path);
            path.add(r);
            lineutility.cHull2(array, r, l, path);
            return path;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "cHull2", new RendererException("Failed inside cHull2", exc));
            return null;
        }
    }

    public static void getExteriorPoints(POINT2[] pLinePoints, int vblCounter, int lineType, boolean interior) {
        int j;
        ref<double[]> m01 = new ref<double[]>();
        ref<double[]> m12 = new ref<double[]>();
        ArrayList<POINT2> intersectPoints = new ArrayList<POINT2>();
        double dist = pLinePoints[0].style;
        for (j = 0; j < vblCounter; ++j) {
            POINT2 intersectPt;
            int index;
            POINT2 pt2;
            POINT2 pt1;
            POINT2 pt0;
            if (j == 0 || j == vblCounter - 1) {
                pt0 = new POINT2(pLinePoints[vblCounter - 2]);
                pt1 = new POINT2(pLinePoints[0]);
                pt2 = new POINT2(pLinePoints[1]);
            } else {
                pt0 = new POINT2(pLinePoints[j - 1]);
                pt1 = new POINT2(pLinePoints[j]);
                pt2 = new POINT2(pLinePoints[j + 1]);
            }
            if (pt1.style > 0) {
                dist = pt1.style;
            }
            if ((index = j - 1) < 0) {
                index = vblCounter - 1;
            }
            POINT2[] pts = new POINT2[pLinePoints.length];
            int n = pLinePoints.length;
            for (int k = 0; k < n; ++k) {
                pts[k] = pLinePoints[k];
            }
            int direction = arraysupport.GetInsideOutsideDouble2(pt0, pt1, pts, vblCounter, index, lineType);
            if (interior) {
                direction = lineutility.reverseDirection(direction);
            }
            POINT2 pt00 = lineutility.ExtendDirectedLine(pt0, pt1, pt0, direction, dist);
            POINT2 pt01 = lineutility.ExtendDirectedLine(pt0, pt1, pt1, direction, dist);
            index = j;
            if (j == vblCounter - 1) {
                index = 0;
            }
            direction = arraysupport.GetInsideOutsideDouble2(pt1, pt2, pts, vblCounter, index, lineType);
            if (interior) {
                direction = lineutility.reverseDirection(direction);
            }
            POINT2 pt10 = lineutility.ExtendDirectedLine(pt1, pt2, pt1, direction, dist);
            POINT2 pt11 = lineutility.ExtendDirectedLine(pt1, pt2, pt2, direction, dist);
            if (pt0.x == pt1.x && pt1.x == pt2.x) {
                intersectPt = new POINT2(pt01);
                intersectPoints.add(intersectPt);
                continue;
            }
            lineutility.CalcTrueSlopeDouble2(pt00, pt01, m01);
            lineutility.CalcTrueSlopeDouble2(pt10, pt11, m12);
            if (((double[])m01.value)[0] == ((double[])m12.value)[0]) {
                intersectPt = new POINT2(pt01);
                intersectPoints.add(intersectPt);
                continue;
            }
            double b01 = pt01.y - ((double[])m01.value)[0] * pt01.x;
            double b12 = pt11.y - ((double[])m12.value)[0] * pt11.x;
            intersectPt = lineutility.CalcTrueIntersectDouble2(((double[])m01.value)[0], b01, ((double[])m12.value)[0], b12, 1, 1, 0.0, 0.0);
            intersectPoints.add(intersectPt);
        }
        int n = intersectPoints.size();
        for (j = 0; j < n; ++j) {
            pLinePoints[j] = (POINT2)intersectPoints.get(j);
        }
    }

    public static ArrayList<POINT2> getDeepCopy(ArrayList<POINT2> pts) {
        ArrayList<POINT2> deepCopy = null;
        try {
            if (pts == null || pts.isEmpty()) {
                return pts;
            }
            deepCopy = new ArrayList<POINT2>();
            int j = 0;
            POINT2 pt = null;
            for (j = 0; j < pts.size(); ++j) {
                pt = new POINT2(pts.get((int)j).x, pts.get((int)j).y, pts.get((int)j).style);
                deepCopy.add(pt);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getDeepCopy", new RendererException("Failed inside getDeepCopy", exc));
        }
        return deepCopy;
    }

    public static int reverseDirection(int direction) {
        switch (direction) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return direction;
    }
}

