/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.RenderMultipoints;

import armyc2.c5isr.JavaLineArray.CELineArray;
import armyc2.c5isr.JavaLineArray.DISMSupport;
import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaTacticalRenderer.Modifier2;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c5isr.RenderMultipoints.clsClipPolygon2;
import armyc2.c5isr.RenderMultipoints.clsClipQuad;
import armyc2.c5isr.RenderMultipoints.clsRenderer2;
import armyc2.c5isr.RenderMultipoints.clsUtility;
import armyc2.c5isr.RenderMultipoints.clsUtilityCPOF;
import armyc2.c5isr.RenderMultipoints.clsUtilityGE;
import armyc2.c5isr.renderer.utilities.DistanceUnit;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.MilStdSymbol;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public final class clsRenderer {
    private static final String _className = "clsRenderer";

    private static void setClientCoords(MilStdSymbol milStd, TGLight tg) {
        try {
            ArrayList<POINT2> latLongs = new ArrayList<POINT2>();
            int j = 0;
            ArrayList<Point2D> coords = milStd.getCoordinates();
            Point2D pt2d = null;
            POINT2 pt2 = null;
            int n = coords.size();
            for (j = 0; j < n; ++j) {
                pt2d = coords.get(j);
                pt2 = clsUtility.Point2DToPOINT2(pt2d);
                latLongs.add(pt2);
            }
            tg.set_LatLongs(latLongs);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "setClientCoords", new RendererException("Failed to set geo points or pixels for " + milStd.getSymbolID(), exc));
        }
    }

    private static ArrayList<Point2D> getClientCoords(TGLight tg) {
        ArrayList<Point2D> coords = null;
        try {
            int j = 0;
            Point2D.Double pt2d = null;
            POINT2 pt2 = null;
            coords = new ArrayList<Point2D>();
            int n = tg.LatLongs.size();
            for (j = 0; j < n; ++j) {
                pt2 = tg.LatLongs.get(j);
                pt2d = new Point2D.Double(pt2.x, pt2.y);
                coords.add(pt2d);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "getClientCoords", new RendererException("Failed to set geo points or pixels for " + tg.get_SymbolId(), exc));
        }
        return coords;
    }

    public static TGLight createTGLightFromMilStdSymbolBasicShape(MilStdSymbol milStd, IPointConversion converter, int lineType) {
        TGLight tg = new TGLight();
        try {
            ArrayList<Double> AM;
            boolean useLineInterpolation = milStd.getUseLineInterpolation();
            tg.set_UseLineInterpolation(useLineInterpolation);
            tg.set_LineType(lineType);
            String status = tg.get_Status();
            tg.set_VisibleModifiers(true);
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            RendererSettings r = RendererSettings.getInstance();
            int type = r.getMPLabelFontType();
            String name = r.getMPLabelFontName();
            int sz = r.getMPLabelFontSize();
            Font font = new Font(name, type, sz);
            tg.set_Font(font);
            tg.set_FillColor(milStd.getFillColor());
            tg.set_LineColor(milStd.getLineColor());
            tg.set_LineThickness(milStd.getLineWidth());
            tg.set_TexturePaint(milStd.getFillStyle());
            tg.set_Fillstyle(milStd.getPatternFillType());
            tg.set_patternScale(milStd.getPatternScale());
            tg.setIconSize(milStd.getUnitSize());
            tg.set_KeepUnitRatio(milStd.getKeepUnitRatio());
            tg.set_FontBackColor(Color.WHITE);
            tg.set_TextColor(milStd.getTextColor());
            if (milStd.getModifier("W_DTG_1") != null) {
                tg.set_DTG(milStd.getModifier("W_DTG_1"));
            }
            if (milStd.getModifier("W1_DTG_2") != null) {
                tg.set_DTG1(milStd.getModifier("W1_DTG_2"));
            }
            if (milStd.getModifier("H_ADDITIONAL_INFO_1") != null) {
                tg.set_H(milStd.getModifier("H_ADDITIONAL_INFO_1"));
            }
            if (milStd.getModifier("H1_ADDITIONAL_INFO_2") != null) {
                tg.set_H1(milStd.getModifier("H1_ADDITIONAL_INFO_2"));
            }
            if (milStd.getModifier("H2_ADDITIONAL_INFO_3") != null) {
                tg.set_H2(milStd.getModifier("H2_ADDITIONAL_INFO_3"));
            }
            if (milStd.getModifier("T_UNIQUE_DESIGNATION_1") != null) {
                tg.set_Name(milStd.getModifier("T_UNIQUE_DESIGNATION_1"));
            }
            if (milStd.getModifier("T1_UNIQUE_DESIGNATION_2") != null) {
                tg.set_T1(milStd.getModifier("T1_UNIQUE_DESIGNATION_2"));
            }
            if (milStd.getModifier("V_EQUIP_TYPE") != null) {
                tg.set_V(milStd.getModifier("V_EQUIP_TYPE"));
            }
            if (milStd.getModifier("AS_COUNTRY") != null) {
                tg.set_AS(milStd.getModifier("AS_COUNTRY"));
            }
            if (milStd.getModifier("AP_TARGET_NUMBER") != null) {
                tg.set_AP(milStd.getModifier("AP_TARGET_NUMBER"));
            }
            if (milStd.getModifier("Y_LOCATION") != null) {
                tg.set_Location(milStd.getModifier("Y_LOCATION"));
            }
            if (milStd.getModifier("N_HOSTILE") != null) {
                tg.set_N(milStd.getModifier("N_HOSTILE"));
            }
            tg.set_UseDashArray(milStd.getUseDashArray());
            tg.set_UseHatchFill(milStd.getUseFillPattern());
            tg.set_HideOptionalLabels(milStd.getHideOptionalLabels());
            boolean isClosedArea = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(lineType);
            if (isClosedArea) {
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.Pixels);
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.LatLongs);
            }
            String strXAlt = "";
            if (lineType == 13000000) {
                POINT2 pt0;
                ArrayList<Double> AM2 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                double r2 = 0.0;
                double b = 0.0;
                if (AM2.size() == 1) {
                    r2 = AM2.get(0);
                    AM2.add(r2);
                    AM2.add(0.0);
                } else if (AM2.size() == 2) {
                    r2 = AM2.get(0);
                    b = AM2.get(1);
                    AM2.set(1, r2);
                    AM2.add(b);
                }
                if (AN == null) {
                    AN = new ArrayList();
                }
                if (AN.size() < 1) {
                    AN.add(new Double(0.0));
                }
                if (AM2 != null && AM2.size() >= 2 && AN != null && AN.size() >= 1) {
                    POINT2 ptAzimuth = new POINT2(0.0, 0.0);
                    ptAzimuth.x = AN.get(0);
                    POINT2 ptCenter = tg.Pixels.get(0);
                    pt0 = mdlGeodesic.geodesic_coordinate(tg.LatLongs.get(0), AM2.get(0), 90.0);
                    POINT2 pt1 = mdlGeodesic.geodesic_coordinate(tg.LatLongs.get(0), AM2.get(1), 0.0);
                    Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                    Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                    pt02d = converter.GeoToPixels(pt02d);
                    pt12d = converter.GeoToPixels(pt12d);
                    pt0 = new POINT2(pt02d.getX(), pt02d.getY());
                    pt1 = new POINT2(pt12d.getX(), pt12d.getY());
                    tg.Pixels = new ArrayList();
                    tg.Pixels.add(ptCenter);
                    tg.Pixels.add(pt0);
                    tg.Pixels.add(pt1);
                    tg.Pixels.add(ptAzimuth);
                }
                if (AM2 != null && AM2.size() > 2) {
                    double dist = AM2.get(2);
                    pt0 = mdlGeodesic.geodesic_coordinate(tg.LatLongs.get(0), dist, 45.0);
                    Point2D pt02d = new Point2D.Double(tg.LatLongs.get((int)0).x, tg.LatLongs.get((int)0).y);
                    Point2D pt12d = new Point2D.Double(pt0.x, pt0.y);
                    pt02d = converter.GeoToPixels(pt02d);
                    pt12d = converter.GeoToPixels(pt12d);
                    pt0 = new POINT2(pt02d.getX(), pt02d.getY());
                    POINT2 pt1 = new POINT2(pt12d.getX(), pt12d.getY());
                    dist = lineutility.CalcDistanceDouble(pt0, pt1);
                    tg.Pixels.get((int)0).style = (int)dist;
                }
            }
            int j = 0;
            if (lineType == 15000003 || lineType == 15000004) {
                double minLat = tg.LatLongs.get((int)0).y;
                double maxLat = tg.LatLongs.get((int)0).y;
                double minLong = tg.LatLongs.get((int)0).x;
                double maxLong = tg.LatLongs.get((int)0).x;
                for (j = 1; j < tg.LatLongs.size(); ++j) {
                    if (tg.LatLongs.get((int)j).x < minLong) {
                        minLong = tg.LatLongs.get((int)j).x;
                    }
                    if (tg.LatLongs.get((int)j).x > maxLong) {
                        maxLong = tg.LatLongs.get((int)j).x;
                    }
                    if (tg.LatLongs.get((int)j).y < minLat) {
                        minLat = tg.LatLongs.get((int)j).y;
                    }
                    if (!(tg.LatLongs.get((int)j).y > maxLat)) continue;
                    maxLat = tg.LatLongs.get((int)j).y;
                }
                tg.LatLongs = new ArrayList();
                tg.LatLongs.add(new POINT2(minLong, maxLat));
                tg.LatLongs.add(new POINT2(maxLong, maxLat));
                tg.LatLongs.add(new POINT2(maxLong, minLat));
                tg.LatLongs.add(new POINT2(minLong, minLat));
                if (lineType == 15000004) {
                    tg.LatLongs.add(new POINT2(minLong, maxLat));
                }
                tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            }
            switch (lineType) {
                case 15000000: 
                case 15000001: 
                case 15000003: {
                    String H2 = null;
                    double dist = 0.0;
                    ArrayList<Double> AM3 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                    if (AM3 != null && AM3.size() > 0) {
                        H2 = AM3.get(0).toString();
                        tg.set_H2(H2);
                    }
                    if (H2 == null || H2.isEmpty()) break;
                    for (j = 0; j < tg.LatLongs.size(); ++j) {
                        if (tg.LatLongs.size() <= j) continue;
                        if (!Double.isNaN(Double.parseDouble(H2))) {
                            if (j == 0) {
                                dist = Double.parseDouble(H2);
                                POINT2 pt0 = new POINT2(tg.LatLongs.get(0));
                                POINT2 pt1 = mdlGeodesic.geodesic_coordinate(pt0, dist, 45.0);
                                Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                                Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                                pt02d = converter.GeoToPixels(pt02d);
                                pt12d = converter.GeoToPixels(pt12d);
                                pt0.x = pt02d.getX();
                                pt0.y = pt02d.getY();
                                pt1.x = pt12d.getX();
                                pt1.y = pt12d.getY();
                                dist = lineutility.CalcDistanceDouble(pt0, pt1);
                            }
                            tg.Pixels.get((int)j).style = Math.round((float)dist);
                            continue;
                        }
                        tg.Pixels.get((int)j).style = 0;
                    }
                    break;
                }
            }
            if (lineType == 13000001) {
                ArrayList<Double> AM4 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AM4 != null && AM4.size() > 1) {
                    String strAM = AM4.get(0).toString();
                    tg.set_AM(strAM);
                    String strAM1 = AM4.get(1).toString();
                    tg.set_AM1(strAM1);
                }
                if (AN != null && AN.size() > 0) {
                    String strAN = AN.get(0).toString();
                    tg.set_AN(strAN);
                }
            }
            if (lineType == 16000005) {
                ArrayList<Double> AM5 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AM5 != null) {
                    StringBuilder strAM = new StringBuilder();
                    for (j = 0; j < AM5.size(); ++j) {
                        strAM.append(AM5.get(j).toString());
                        if (j >= AM5.size() - 1) continue;
                        strAM.append(",");
                    }
                    tg.set_AM(strAM.toString());
                }
                if (AN != null) {
                    StringBuilder strAN = new StringBuilder();
                    for (j = 0; j < AN.size(); ++j) {
                        strAN.append(AN.get(j));
                        if (j >= AN.size() - 1) continue;
                        strAN.append(",");
                    }
                    tg.set_AN(strAN.toString());
                }
                if (AM5 != null && AN != null) {
                    int numSectors = AN.size() / 2;
                    double left = 0.0;
                    double right = 0.0;
                    double min = 0.0;
                    double max = 0.0;
                    StringBuilder strLeftRightMinMax = new StringBuilder();
                    for (j = 0; j < numSectors; ++j) {
                        left = AN.get(2 * j);
                        right = AN.get(2 * j + 1);
                        min = AM5.get(2 * j);
                        max = AM5.get(2 * j + 1);
                        strLeftRightMinMax.append(left).append(",").append(right).append(",").append(min).append(",").append(max);
                        if (j >= numSectors - 1) continue;
                        strLeftRightMinMax.append(",");
                    }
                    int len = strLeftRightMinMax.length();
                    String c = strLeftRightMinMax.substring(len - 1, len);
                    if (c.equals(",")) {
                        strLeftRightMinMax = new StringBuilder(strLeftRightMinMax.substring(0, len - 1));
                    }
                    tg.set_LRMM(strLeftRightMinMax.toString());
                }
            }
            if (lineType == 16000003) {
                ArrayList<Double> AM6 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AM6 != null) {
                    StringBuilder strAM = new StringBuilder();
                    for (j = 0; j < AM6.size() && j < 2; ++j) {
                        strAM.append(AM6.get(j).toString());
                        if (j >= AM6.size() - 1) continue;
                        strAM.append(",");
                    }
                    tg.set_AM(strAM.toString());
                }
                if (AN != null) {
                    StringBuilder strAN = new StringBuilder();
                    for (j = 0; j < AN.size() && j < 2; ++j) {
                        strAN.append(AN.get(j));
                        if (j >= AN.size() - 1) continue;
                        strAN.append(",");
                    }
                    tg.set_AN(strAN.toString());
                }
                if (AM6 != null && AN != null) {
                    double left = 0.0;
                    double right = 0.0;
                    double min = 0.0;
                    double max = 0.0;
                    String strLeftRightMinMax = "";
                    left = AN.get(0);
                    right = AN.get(1);
                    min = AM6.get(0);
                    max = AM6.get(1);
                    strLeftRightMinMax = strLeftRightMinMax + left + "," + right + "," + min + "," + max;
                    tg.set_LRMM(strLeftRightMinMax);
                }
            }
            if (lineType == 16000004) {
                ArrayList<Double> AM7 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AM7 != null && AM7.size() > 0) {
                    String strAM = AM7.get(0).toString();
                    tg.set_AM(strAM);
                }
                if (AN != null) {
                    StringBuilder strAN = new StringBuilder();
                    for (j = 0; j < AN.size() && j < 2; ++j) {
                        strAN.append(AN.get(j));
                        if (j >= AN.size() - 1) continue;
                        strAN.append(",");
                    }
                    tg.set_AN(strAN.toString());
                }
            }
            switch (lineType) {
                case 15000000: 
                case 15000001: 
                case 15000002: 
                case 15000003: {
                    if (tg.get_FillColor() != null) break;
                    tg.set_FillColor(Color.LIGHT_GRAY);
                    break;
                }
            }
            switch (lineType) {
                case 13000002: 
                case 15000002: 
                case 16000001: 
                case 16000002: 
                case 16000006: {
                    ArrayList<Double> AM8 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                    if (AM8 != null && AM8.size() > 0) {
                        String strAM = Double.toString(AM8.get(0));
                        tg.set_AM(strAM);
                        break;
                    }
                    if (lineType != 15000002 || tg.LatLongs.size() <= 1) break;
                    double dist = mdlGeodesic.geodesic_distance(tg.LatLongs.get(0), tg.LatLongs.get(1), null, null);
                    String strT1 = Double.toString(dist);
                    tg.set_T1(strT1);
                    break;
                }
            }
            if (lineType == 16000006 && (AM = milStd.getModifiers_AM_AN_X("AM_DISTANCE")) != null) {
                StringBuilder strAM = new StringBuilder();
                for (j = 0; j < AM.size(); ++j) {
                    strAM.append(AM.get(j).toString());
                    if (j >= AM.size() - 1) continue;
                    strAM.append(",");
                }
                tg.set_AM(strAM.toString());
            }
            if (lineType == 14000001 || lineType == 14000002) {
                AM = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (lineType == 14000002) {
                    double r2 = AM.get(0);
                    double b = 0.0;
                    if (AM.size() == 1) {
                        AM.add(r2);
                        AM.add(b);
                    } else if (AM.size() == 2) {
                        b = AM.get(1);
                        AM.set(1, r2);
                        AM.add(b);
                    } else if (AM.size() > 2) {
                        AM.set(1, r2);
                    }
                }
                if (lineType == 14000002) {
                    double am0 = AM.get(0);
                    if (AM.size() == 1) {
                        AM.add(am0);
                    } else if (AM.size() >= 2) {
                        AM.set(1, am0);
                    }
                }
                if (AN == null) {
                    AN = new ArrayList();
                }
                if (AN.isEmpty()) {
                    AN.add(0.0);
                }
                if (AM != null && AM.size() > 1) {
                    String strAM = Double.toString(AM.get(0));
                    String strAM1 = Double.toString(AM.get(1));
                    tg.set_AM(strAM);
                    tg.set_AM1(strAM1);
                    String strAN = Double.toString(AN.get(0));
                    tg.set_AN(strAN);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createTGLightFromBasicMilStdSymbol", new RendererException("Failed to build multipoint TG for " + lineType, exc));
        }
        return tg;
    }

    public static MilStdSymbol createMilStdSymboFromTGLight(TGLight tg, IPointConversion converter) {
        MilStdSymbol milStd = null;
        try {
            String symbolId = tg.get_SymbolId();
            int lineType = armyc2.c5isr.JavaTacticalRenderer.clsUtility.GetLinetypeFromString(symbolId);
            String status = tg.get_Status();
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            boolean isClosedArea = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(lineType);
            if (isClosedArea) {
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.Pixels);
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.LatLongs);
            }
            ArrayList<Point2D> coords = clsRenderer.getClientCoords(tg);
            tg.set_Font(new Font("Arial", 0, 12));
            HashMap<String, String> modifiers = new HashMap<String, String>();
            modifiers.put("W_DTG_1", tg.get_DTG());
            modifiers.put("W1_DTG_2", tg.get_DTG1());
            modifiers.put("H_ADDITIONAL_INFO_1", tg.get_H());
            modifiers.put("H1_ADDITIONAL_INFO_2", tg.get_H1());
            modifiers.put("H2_ADDITIONAL_INFO_3", tg.get_H2());
            modifiers.put("T_UNIQUE_DESIGNATION_1", tg.get_Name());
            modifiers.put("T1_UNIQUE_DESIGNATION_2", tg.get_T1());
            modifiers.put("Y_LOCATION", tg.get_Location());
            modifiers.put("N_HOSTILE", tg.get_N());
            milStd = new MilStdSymbol(symbolId, "1", coords, modifiers);
            milStd.setFillColor(tg.get_FillColor());
            milStd.setLineColor(tg.get_LineColor());
            milStd.setLineWidth(tg.get_LineThickness());
            milStd.setFillStyle(tg.get_TexturePaint());
            milStd.setPatternScale(tg.get_patternScale());
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createMilStdSymboFromTGLight", new RendererException("Failed to set geo points or pixels for " + tg.get_SymbolId(), exc));
        }
        return milStd;
    }

    public static TGLight createTGLightFromMilStdSymbol(MilStdSymbol milStd, IPointConversion converter) {
        TGLight tg = new TGLight();
        try {
            ArrayList<Double> AM;
            ArrayList<Double> AN;
            ArrayList<Double> AM2;
            DistanceUnit distanceUnit;
            DistanceUnit altitudeUnit;
            String symbolId = milStd.getSymbolID();
            tg.set_SymbolId(symbolId);
            boolean useLineInterpolation = milStd.getUseLineInterpolation();
            tg.set_UseLineInterpolation(useLineInterpolation);
            int lineType = armyc2.c5isr.JavaTacticalRenderer.clsUtility.GetLinetypeFromString(symbolId);
            tg.set_LineType(lineType);
            String status = tg.get_Status();
            if (status != null && status.equals("A")) {
                tg.set_LineStyle(1);
            }
            tg.set_VisibleModifiers(true);
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            tg.set_Font(RendererSettings.getInstance().getMPLabelFont());
            tg.set_FillColor(milStd.getFillColor());
            tg.set_LineColor(milStd.getLineColor());
            tg.set_LineThickness(milStd.getLineWidth());
            tg.set_TexturePaint(milStd.getFillStyle());
            tg.set_patternScale(milStd.getPatternScale());
            tg.setIconSize(milStd.getUnitSize());
            tg.set_KeepUnitRatio(milStd.getKeepUnitRatio());
            tg.set_FontBackColor(Color.WHITE);
            tg.set_TextColor(milStd.getTextColor());
            if (milStd.getModifier("W_DTG_1") != null) {
                tg.set_DTG(milStd.getModifier("W_DTG_1"));
            }
            if (milStd.getModifier("W1_DTG_2") != null) {
                tg.set_DTG1(milStd.getModifier("W1_DTG_2"));
            }
            if (milStd.getModifier("H_ADDITIONAL_INFO_1") != null) {
                tg.set_H(milStd.getModifier("H_ADDITIONAL_INFO_1"));
            }
            if (milStd.getModifier("H1_ADDITIONAL_INFO_2") != null) {
                tg.set_H1(milStd.getModifier("H1_ADDITIONAL_INFO_2"));
            }
            if (milStd.getModifier("H2_ADDITIONAL_INFO_3") != null) {
                tg.set_H2(milStd.getModifier("H2_ADDITIONAL_INFO_3"));
            }
            if (milStd.getModifier("T_UNIQUE_DESIGNATION_1") != null) {
                tg.set_Name(milStd.getModifier("T_UNIQUE_DESIGNATION_1"));
            }
            if (milStd.getModifier("T1_UNIQUE_DESIGNATION_2") != null) {
                tg.set_T1(milStd.getModifier("T1_UNIQUE_DESIGNATION_2"));
            }
            if (milStd.getModifier("V_EQUIP_TYPE") != null) {
                tg.set_V(milStd.getModifier("V_EQUIP_TYPE"));
            }
            if (milStd.getModifier("AS_COUNTRY") != null) {
                tg.set_AS(milStd.getModifier("AS_COUNTRY"));
            }
            if (milStd.getModifier("AP_TARGET_NUMBER") != null) {
                tg.set_AP(milStd.getModifier("AP_TARGET_NUMBER"));
            }
            if (milStd.getModifier("Y_LOCATION") != null) {
                tg.set_Location(milStd.getModifier("Y_LOCATION"));
            }
            if (milStd.getModifier("N_HOSTILE") != null) {
                tg.set_N(milStd.getModifier("N_HOSTILE"));
            }
            tg.set_UseDashArray(milStd.getUseDashArray());
            tg.set_UseHatchFill(milStd.getUseFillPattern());
            tg.set_HideOptionalLabels(milStd.getHideOptionalLabels());
            boolean isClosedArea = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(lineType);
            if (lineType == 272101) {
                ArrayList<POINT2> poly1Pixels = new ArrayList<POINT2>(tg.Pixels.subList(0, tg.Pixels.size() / 2));
                ArrayList<POINT2> poly1LatLons = new ArrayList<POINT2>(tg.LatLongs.subList(0, tg.LatLongs.size() / 2));
                ArrayList<POINT2> poly2Pixels = new ArrayList<POINT2>(tg.Pixels.subList(tg.Pixels.size() / 2, tg.Pixels.size()));
                ArrayList<POINT2> poly2LatLons = new ArrayList<POINT2>(tg.LatLongs.subList(tg.LatLongs.size() / 2, tg.LatLongs.size()));
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(poly1Pixels);
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(poly1LatLons);
                tg.Pixels = poly1Pixels;
                tg.LatLongs = poly1LatLons;
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(poly2Pixels);
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(poly2LatLons);
                tg.Pixels.addAll(poly2Pixels);
                tg.LatLongs.addAll(poly2LatLons);
            } else if (isClosedArea) {
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.Pixels);
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.LatLongs);
            }
            String altitudeLabel = milStd.getAltitudeMode();
            if (altitudeLabel == null || altitudeLabel.isEmpty()) {
                altitudeLabel = "AMSL";
            }
            if ((altitudeUnit = milStd.getAltitudeUnit()) == null) {
                altitudeUnit = DistanceUnit.FEET;
            }
            if ((distanceUnit = milStd.getDistanceUnit()) == null) {
                distanceUnit = DistanceUnit.METERS;
            }
            String strXAlt = "";
            if (lineType == 243112000) {
                int j;
                AM2 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                ArrayList<Double> X = milStd.getModifiers_AM_AN_X("X_ALTITUDE_DEPTH");
                if (AM2 != null) {
                    String strAM = "";
                    for (j = 0; j < AM2.size(); ++j) {
                        strAM = strAM + Double.toString(AM2.get(j));
                        if (j >= AM2.size() - 1) continue;
                        strAM = strAM + ",";
                    }
                    tg.set_AM(strAM);
                }
                if (AN != null) {
                    String strAN = "";
                    for (j = 0; j < AN.size(); ++j) {
                        strAN = strAN + AN.get(j);
                        if (j >= AN.size() - 1) continue;
                        strAN = strAN + ",";
                    }
                    tg.set_AN(strAN);
                }
                if (X != null) {
                    String strX = "";
                    for (j = 0; j < X.size(); ++j) {
                        strXAlt = clsRenderer.createAltitudeLabel(X.get(j), altitudeUnit, altitudeLabel);
                        strX = strX + strXAlt;
                        if (j >= X.size() - 1) continue;
                        strX = strX + ",";
                    }
                    tg.set_X(strX);
                }
                if (AM2 != null && AN != null) {
                    int len;
                    String c;
                    int numSectors = AN.size() / 2;
                    double min = 0.0;
                    double max = 0.0;
                    String strLeftRightMinMax = "";
                    for (int j2 = 0; j2 < numSectors; ++j2) {
                        double left = AN.get(2 * j2);
                        double right = AN.get(2 * j2 + 1);
                        if (j2 + 1 == AM2.size()) break;
                        min = AM2.get(j2);
                        max = AM2.get(j2 + 1);
                        strLeftRightMinMax = strLeftRightMinMax + Double.toString(left) + "," + Double.toString(right) + "," + Double.toString(min) + "," + Double.toString(max);
                        if (j2 >= numSectors - 1) continue;
                        strLeftRightMinMax = strLeftRightMinMax + ",";
                    }
                    if ((c = strLeftRightMinMax.substring((len = strLeftRightMinMax.length()) - 1, len)).equalsIgnoreCase(",")) {
                        strLeftRightMinMax = strLeftRightMinMax.substring(0, len - 1);
                    }
                    tg.set_LRMM(strLeftRightMinMax);
                }
            } else if (lineType == 25200700) {
                int j;
                AM2 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                AN = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AM2 != null) {
                    String strAM = "";
                    for (j = 0; j < AM2.size() && j < 2; ++j) {
                        strAM = strAM + Double.toString(AM2.get(j));
                        if (j >= AM2.size() - 1) continue;
                        strAM = strAM + ",";
                    }
                    tg.set_AM(strAM);
                }
                if (AN != null) {
                    String strAN = "";
                    for (j = 0; j < AN.size() && j < 2; ++j) {
                        strAN = strAN + AN.get(j);
                        if (j >= AN.size() - 1) continue;
                        strAN = strAN + ",";
                    }
                    tg.set_AN(strAN);
                }
                if (AM2 != null && AN != null) {
                    double min = 0.0;
                    double max = 0.0;
                    String strLeftRightMinMax = "";
                    double left = AN.get(0);
                    double right = AN.get(1);
                    min = AM2.get(0);
                    max = AM2.get(1);
                    strLeftRightMinMax = strLeftRightMinMax + Double.toString(left) + "," + Double.toString(right) + "," + Double.toString(min) + "," + Double.toString(max);
                    tg.set_LRMM(strLeftRightMinMax);
                }
            }
            int j = 0;
            if (lineType == 25200101 || lineType == 25200201 || lineType == 25200401) {
                AM = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN2 = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AM != null && AM.size() > 1) {
                    String strAM = AM.get(0).toString();
                    tg.set_AM(strAM);
                    String strAM1 = AM.get(1).toString();
                    tg.set_AM1(strAM1);
                }
                if (AN2 != null && AN2.size() > 0) {
                    String strAN = AN2.get(0).toString();
                    tg.set_AN(strAN);
                }
            }
            switch (lineType) {
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 22235000: 
                case 24322100: 
                case 24322200: 
                case 24322300: 
                case 25171100: 
                case 25171200: 
                case 25171300: 
                case 25171400: 
                case 25171500: {
                    ArrayList<Double> X = milStd.getModifiers_AM_AN_X("X_ALTITUDE_DEPTH");
                    if (X != null && X.size() > 0) {
                        strXAlt = clsRenderer.createAltitudeLabel(X.get(0), altitudeUnit, altitudeLabel);
                        tg.set_X(strXAlt);
                    }
                    if (X == null || X.size() <= 1) break;
                    strXAlt = clsRenderer.createAltitudeLabel(X.get(1), altitudeUnit, altitudeLabel);
                    tg.set_X1(strXAlt);
                    break;
                }
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    POINT2 pt = tg.LatLongs.get(0);
                    Point2D.Double pt2d0 = new Point2D.Double(pt.x, pt.y);
                    Point2D pt2d0Pixels = converter.GeoToPixels(pt2d0);
                    POINT2 pt0Pixels = new POINT2(pt2d0Pixels.getX(), pt2d0Pixels.getY());
                    double dist = 10000.0;
                    POINT2 pt2 = mdlGeodesic.geodesic_coordinate(pt, dist, 0.0);
                    Point2D.Double pt2d1 = new Point2D.Double(pt2.x, pt2.y);
                    Point2D pt2d1Pixels = converter.GeoToPixels(pt2d1);
                    POINT2 pt1Pixels = new POINT2(pt2d1Pixels.getX(), pt2d1Pixels.getY());
                    double distPixels = lineutility.CalcDistanceDouble(pt0Pixels, pt1Pixels);
                    double pixelsPerMeter = distPixels / dist;
                    ArrayList<Double> AM3 = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                    if (AM3 != null) {
                        String strAM = "";
                        for (j = 0; j < AM3.size(); ++j) {
                            strAM = strAM + AM3.get(j).toString();
                            if (j >= AM3.size() - 1) continue;
                            strAM = strAM + ",";
                        }
                        tg.set_AM(strAM);
                    }
                    String[] strRadii = null;
                    double maxWidth = 0.0;
                    double temp = 0.0;
                    double maxWidthMeters = 0.0;
                    if (tg.get_AM() != null && !tg.get_AM().isEmpty() && (strRadii = tg.get_AM().split(",")).length > 0) {
                        for (j = 0; j < strRadii.length; ++j) {
                            if (Double.isNaN(Double.parseDouble(strRadii[j])) || !((temp = Double.parseDouble(strRadii[j])) > maxWidth)) continue;
                            maxWidth = temp;
                        }
                        maxWidthMeters = maxWidth;
                        maxWidth *= pixelsPerMeter / 2.0;
                        for (j = 0; j < tg.Pixels.size(); ++j) {
                            if (strRadii.length > j) {
                                if (!Double.isNaN(Double.parseDouble(strRadii[j]))) {
                                    double pixels = Double.parseDouble(strRadii[j]) * pixelsPerMeter / 2.0;
                                    tg.Pixels.get((int)j).style = (int)pixels;
                                    tg.LatLongs.get((int)j).style = (int)pixels;
                                    continue;
                                }
                                tg.Pixels.get((int)j).style = (int)maxWidth;
                                tg.LatLongs.get((int)j).style = (int)maxWidth;
                                continue;
                            }
                            tg.Pixels.get((int)j).style = (int)maxWidth;
                            tg.LatLongs.get((int)j).style = (int)maxWidth;
                        }
                    }
                    maxWidthMeters *= distanceUnit.conversionFactor;
                    maxWidthMeters *= 10.0;
                    maxWidthMeters = Math.round(maxWidthMeters);
                    int tempWidth = (int)maxWidthMeters;
                    maxWidthMeters = (double)tempWidth / 10.0;
                    tg.set_AM(Double.toString(maxWidthMeters) + " " + distanceUnit.label);
                    ArrayList<Double> X = milStd.getModifiers_AM_AN_X("X_ALTITUDE_DEPTH");
                    if (X != null && X.size() > 0) {
                        strXAlt = clsRenderer.createAltitudeLabel(X.get(0), altitudeUnit, altitudeLabel);
                        tg.set_X(strXAlt);
                    }
                    if (X == null || X.size() <= 1) break;
                    strXAlt = clsRenderer.createAltitudeLabel(X.get(1), altitudeUnit, altitudeLabel);
                    tg.set_X1(strXAlt);
                    break;
                }
            }
            if (lineType == 243111000) {
                AM = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> X = milStd.getModifiers_AM_AN_X("X_ALTITUDE_DEPTH");
                String strAM = "";
                String strX = "";
                if (AM != null) {
                    for (j = 0; j < AM.size() && j < 3; ++j) {
                        strAM = strAM + Double.toString(AM.get(j));
                        if (j < AM.size() - 1) {
                            strAM = strAM + ",";
                        }
                        if (X == null || j >= X.size()) continue;
                        strXAlt = clsRenderer.createAltitudeLabel(X.get(j), altitudeUnit, altitudeLabel);
                        strX = strX + strXAlt;
                        if (j >= X.size() - 1) continue;
                        strX = strX + ",";
                    }
                }
                tg.set_AM(strAM);
                tg.set_X(strX);
            }
            switch (lineType) {
                case 240804: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24326100: 
                case 24326200: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: 
                case 25170800: 
                case 25200202: 
                case 25200300: 
                case 25200402: {
                    AM = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                    if (AM == null || AM.size() <= 0) break;
                    String strAM = Double.toString(AM.get(0));
                    tg.set_AM(strAM);
                    break;
                }
            }
            if (lineType == 24311000 || lineType == 25200600) {
                AM = milStd.getModifiers_AM_AN_X("AM_DISTANCE");
                ArrayList<Double> AN3 = milStd.getModifiers_AM_AN_X("AN_AZIMUTH");
                if (AN3 == null) {
                    AN3 = new ArrayList();
                }
                if (AN3.isEmpty()) {
                    AN3.add(0.0);
                }
                if (AM != null && AM.size() > 1) {
                    String strAM = Double.toString(AM.get(0));
                    String strAM1 = Double.toString(AM.get(1));
                    tg.set_AM(strAM);
                    tg.set_AM1(strAM1);
                    String strAN = Double.toString(AN3.get(0));
                    tg.set_AN(strAN);
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createTGLightfromMilStdSymbol", new RendererException("Failed to build multipoint TG for " + milStd.getSymbolID(), exc));
        }
        return tg;
    }

    private static String createAltitudeLabel(double distance, DistanceUnit altitudeUnit, String altitudeLabel) {
        double conversionFactor = altitudeLabel.equals("FL") ? DistanceUnit.FLIGHT_LEVEL.conversionFactor : altitudeUnit.conversionFactor;
        double result = distance * conversionFactor;
        result *= 10.0;
        int tempResult = (int)(result = (double)Math.round(result));
        int truncatedResult = tempResult / 10;
        if (truncatedResult == 0) {
            if (altitudeLabel.equals("AGL") || altitudeLabel.equals("GL")) {
                return "GL";
            }
            if (altitudeLabel.equals("AMSL") || altitudeLabel.equals("BMSL") || altitudeLabel.equals("MSL")) {
                return "MSL";
            }
        }
        if (altitudeLabel.equals("FL")) {
            return "FL " + String.format("%03d", truncatedResult);
        }
        return truncatedResult + " " + altitudeUnit.label + " " + altitudeLabel;
    }

    public static TGLight createTGLightFromMilStdSymbol(MilStdSymbol milStd, IPointConversion converter, Boolean computeChannelPt) {
        TGLight tg = new TGLight();
        try {
            int lineType;
            boolean isClosedArea;
            String symbolId = milStd.getSymbolID();
            tg.set_SymbolId(symbolId);
            String status = tg.get_Status();
            if (status != null && status.equals("A")) {
                tg.set_LineStyle(1);
            }
            tg.set_VisibleModifiers(true);
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            tg.set_Font(new Font("Arial", 0, 12));
            tg.set_FillColor(milStd.getFillColor());
            tg.set_LineColor(milStd.getLineColor());
            tg.set_LineThickness(milStd.getLineWidth());
            tg.set_TexturePaint(milStd.getFillStyle());
            tg.set_patternScale(milStd.getPatternScale());
            tg.set_FontBackColor(Color.WHITE);
            tg.set_TextColor(milStd.getTextColor());
            if (milStd.getModifier("W_DTG_1") != null) {
                tg.set_DTG(milStd.getModifier("W_DTG_1"));
            }
            if (milStd.getModifier("W1_DTG_2") != null) {
                tg.set_DTG1(milStd.getModifier("W1_DTG_2"));
            }
            if (milStd.getModifier("H_ADDITIONAL_INFO_1") != null) {
                tg.set_H(milStd.getModifier("H_ADDITIONAL_INFO_1"));
            }
            if (milStd.getModifier("H1_ADDITIONAL_INFO_2") != null) {
                tg.set_H1(milStd.getModifier("H1_ADDITIONAL_INFO_2"));
            }
            if (milStd.getModifier("H2_ADDITIONAL_INFO_3") != null) {
                tg.set_H2(milStd.getModifier("H2_ADDITIONAL_INFO_3"));
            }
            if (milStd.getModifier("T_UNIQUE_DESIGNATION_1") != null) {
                tg.set_Name(milStd.getModifier("T_UNIQUE_DESIGNATION_1"));
            }
            if (milStd.getModifier("T1_UNIQUE_DESIGNATION_2") != null) {
                tg.set_T1(milStd.getModifier("T1_UNIQUE_DESIGNATION_2"));
            }
            if (milStd.getModifier("V_EQUIP_TYPE") != null) {
                tg.set_V(milStd.getModifier("V_EQUIP_TYPE"));
            }
            if (milStd.getModifier("AS_COUNTRY") != null) {
                tg.set_AS(milStd.getModifier("AS_COUNTRY"));
            }
            if (milStd.getModifier("AP_TARGET_NUMBER") != null) {
                tg.set_AP(milStd.getModifier("AP_TARGET_NUMBER"));
            }
            if (milStd.getModifier("Y_LOCATION") != null) {
                tg.set_Location(milStd.getModifier("Y_LOCATION"));
            }
            if (milStd.getModifier("N_HOSTILE") != null) {
                tg.set_N(milStd.getModifier("N_HOSTILE"));
            }
            if (isClosedArea = armyc2.c5isr.JavaTacticalRenderer.clsUtility.isClosedPolygon(lineType = armyc2.c5isr.JavaTacticalRenderer.clsUtility.GetLinetypeFromString(symbolId))) {
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.Pixels);
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.ClosePolygon(tg.LatLongs);
            }
            if (computeChannelPt.booleanValue()) {
                switch (lineType) {
                    case 21700000: 
                    case 21710000: 
                    case 22521200: 
                    case 22521300: 
                    case 22521410: 
                    case 22521420: 
                    case 25152700: 
                    case 25152900: 
                    case 25342900: {
                        POINT2 ptPixels = armyc2.c5isr.JavaTacticalRenderer.clsUtility.ComputeLastPoint(tg.Pixels);
                        tg.Pixels.add(ptPixels);
                        Point2D.Double pt = new Point2D.Double(ptPixels.x, ptPixels.y);
                        Point2D ptGeo2d = converter.PixelsToGeo(pt);
                        POINT2 ptGeo = clsUtility.Point2DToPOINT2(ptGeo2d);
                        tg.LatLongs.add(ptGeo);
                        break;
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "createTGLightfromMilStdSymbol", new RendererException("Failed to build multipoint TG for " + milStd.getSymbolID(), exc));
        }
        return tg;
    }

    private static void Shape2ToShapeInfo(ArrayList<ShapeInfo> shapeInfos, ArrayList<Shape2> shapes) {
        try {
            int j = 0;
            Shape2 shape = null;
            if (shapes == null || shapeInfos == null || shapes.size() == 0) {
                return;
            }
            for (j = 0; j < shapes.size(); ++j) {
                shape = shapes.get(j);
                shapeInfos.add(shape);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "Shape2ToShapeInfo", new RendererException("Failed to build ShapeInfo ArrayList", exc));
        }
    }

    public static boolean intersectsClipArea(TGLight tg, IPointConversion converter, Object clipArea) {
        boolean result = false;
        try {
            double minx;
            double coordsTop;
            double coordsLeft;
            if (clipArea == null || tg.LatLongs.size() < 2) {
                return true;
            }
            RectangularShape clipBounds = null;
            ArrayList clipPoints = null;
            if (clipArea != null) {
                if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                    clipBounds = (Rectangle2D.Double)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                    Rectangle rectx = (Rectangle)clipArea;
                    clipBounds = new Rectangle2D.Double(rectx.x, rectx.y, rectx.width, rectx.height);
                } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                    clipPoints = (ArrayList)clipArea;
                    clipBounds = clsUtility.getMBR(clipPoints);
                }
            }
            int j = 0;
            double x = clipBounds.getMinX();
            double y = clipBounds.getMinY();
            double width = clipBounds.getWidth();
            double height = clipBounds.getHeight();
            POINT2 tl = new POINT2(x, y);
            POINT2 br = new POINT2(x + width, y + height);
            tl = clsUtility.PointPixelsToLatLong(tl, converter);
            br = clsUtility.PointPixelsToLatLong(br, converter);
            double coordsRight = coordsLeft = tg.LatLongs.get((int)0).x;
            double coordsBottom = coordsTop = tg.LatLongs.get((int)0).y;
            boolean intersects = false;
            double maxx = minx = tg.LatLongs.get((int)0).x;
            double maxNegX = 0.0;
            for (j = 0; j < tg.LatLongs.size(); ++j) {
                POINT2 pt = tg.LatLongs.get(j);
                if (pt.x < minx) {
                    minx = pt.x;
                }
                if (pt.x > maxx) {
                    maxx = pt.x;
                }
                if (maxNegX == 0.0 && pt.x < 0.0) {
                    maxNegX = pt.x;
                }
                if (maxNegX < 0.0 && pt.x < 0.0 && pt.x > maxNegX) {
                    maxNegX = pt.x;
                }
                if (pt.y < coordsBottom) {
                    coordsBottom = pt.y;
                }
                if (!(pt.y > coordsTop)) continue;
                coordsTop = pt.y;
            }
            boolean coordSpanIDL = false;
            if (maxx == 180.0 || minx == -180.0) {
                coordSpanIDL = true;
            }
            if (maxx - minx >= 180.0) {
                coordSpanIDL = true;
                coordsLeft = maxx;
                coordsRight = maxNegX;
            } else {
                coordsLeft = minx;
                coordsRight = maxx;
            }
            if (br.y <= coordsBottom && coordsBottom <= tl.y) {
                intersects = true;
            } else if (coordsBottom <= br.y && br.y <= coordsTop) {
                intersects = true;
            } else {
                return false;
            }
            intersects = false;
            boolean boxSpanIDL = false;
            if (tl.x == 180.0 || tl.x == -180.0 || br.x == 180.0 || br.x == -180.0) {
                boxSpanIDL = true;
            } else if (Math.abs(br.x - tl.x) > 180.0) {
                boxSpanIDL = true;
            }
            if (coordSpanIDL && boxSpanIDL) {
                intersects = true;
            } else if (!coordSpanIDL && !boxSpanIDL) {
                if (coordsLeft <= tl.x && tl.x <= coordsRight) {
                    intersects = true;
                }
                if (coordsLeft <= br.x && br.x <= coordsRight) {
                    intersects = true;
                }
                if (tl.x <= coordsLeft && coordsLeft <= br.x) {
                    intersects = true;
                }
                if (tl.x <= coordsRight && coordsRight <= br.x) {
                    intersects = true;
                }
            } else if (!coordSpanIDL && boxSpanIDL) {
                if (tl.x < coordsRight && coordsRight < 180.0) {
                    intersects = true;
                }
                if (-180.0 < coordsLeft && coordsLeft < br.x) {
                    intersects = true;
                }
            } else if (coordSpanIDL && !boxSpanIDL) {
                if (coordsLeft < br.x && br.x < 180.0) {
                    intersects = true;
                }
                if (-180.0 < tl.x && tl.x < coordsRight) {
                    intersects = true;
                }
            }
            return intersects;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "intersectsClipArea", new RendererException("Failed inside intersectsClipArea", exc));
            return result;
        }
    }

    private static void addFDI(TGLight tg, ArrayList<Shape2> shapes) {
        try {
            MSInfo msi = MSLookup.getInstance().getMSLInfo(tg.get_SymbolId());
            int drawRule = msi != null ? msi.getDrawRule() : -1;
            int lineType = tg.get_LineType();
            if (lineType == 22521410) {
                ArrayList<POINT2> points = shapes.get(1).getPoints();
                POINT2 ptA = new POINT2(points.get(points.size() - 3));
                POINT2 ptB = new POINT2(points.get(points.size() - 8));
                POINT2 ptC = new POINT2(points.get(points.size() - 7));
                shapes.add(DISMSupport.getFDIShape(tg, ptA, ptB, ptC));
            } else if (drawRule == 501 || drawRule == 502) {
                ArrayList<POINT2> points = shapes.get(0).getPoints();
                POINT2 ptA = new POINT2(points.get(points.size() / 2 - 1));
                POINT2 ptB = new POINT2(points.get(points.size() / 2));
                POINT2 ptC = new POINT2(points.get(points.size() / 2 + 1));
                shapes.add(DISMSupport.getFDIShape(tg, ptA, ptB, ptC));
            } else if (lineType == 22522100) {
                ArrayList<POINT2> points = shapes.get(2).getPoints();
                POINT2 ptA = new POINT2(points.get(0));
                POINT2 ptB = new POINT2(points.get(1));
                POINT2 ptC = new POINT2(points.get(2));
                shapes.add(DISMSupport.getFDIShape(tg, ptA, ptB, ptC));
            } else if (lineType == 22522210) {
                ArrayList<POINT2> points = shapes.get(1).getPoints();
                POINT2 ptA = new POINT2(points.get(7));
                POINT2 ptB = new POINT2(points.get(4));
                POINT2 ptC = new POINT2(points.get(9));
                shapes.add(DISMSupport.getFDIShape(tg, ptA, ptB, ptC));
            } else if (lineType == 22522220 || lineType == 25343800) {
                ArrayList<POINT2> points = shapes.get(1).getPoints();
                POINT2 ptA = new POINT2(points.get(0));
                POINT2 ptB = new POINT2(points.get(1));
                POINT2 ptC = new POINT2(points.get(2));
                shapes.add(DISMSupport.getFDIShape(tg, ptA, ptB, ptC));
            } else if (lineType == 25343100) {
                ArrayList<POINT2> points = shapes.get(1).getPoints();
                POINT2 ptA = new POINT2(points.get(0));
                POINT2 ptB = new POINT2(points.get(1));
                POINT2 ptC = new POINT2(points.get(2));
                shapes.add(DISMSupport.getFDIShape(tg, ptA, ptB, ptC));
            } else {
                POINT2 firstPoint = shapes.get(0).getPoints().get(0);
                POINT2 ptUl = new POINT2(firstPoint);
                POINT2 ptUr = new POINT2(firstPoint);
                POINT2 ptLr = new POINT2(firstPoint);
                POINT2 ptLl = new POINT2(firstPoint);
                clsUtility.GetMBR(shapes, ptUl, ptUr, ptLr, ptLl);
                shapes.add(DISMSupport.getFDIShape(tg, ptUl, ptUr));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "addFDI", new RendererException("failed inside addFDI", exc));
        }
    }

    public static void renderWithPolylines(MilStdSymbol mss, IPointConversion converter, Object clipArea, Graphics2D g2d) {
        try {
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbol(mss, converter);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            if (clsRenderer.intersectsClipArea(tg, converter, clipArea)) {
                clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, converter, clipArea, g2d);
            }
            mss.setSymbolShapes(shapeInfos);
            mss.setModifierShapes(modifierShapeInfos);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "renderWithPolylines", new RendererException("Failed inside renderWithPolylines", exc));
        }
    }

    public static void renderWithPolylines(MilStdSymbol mss, IPointConversion converter, Object clipArea) {
        try {
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbol(mss, converter);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            if (clsRenderer.intersectsClipArea(tg, converter, clipArea)) {
                clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, converter, clipArea);
            }
            mss.setSymbolShapes(shapeInfos);
            mss.setModifierShapes(modifierShapeInfos);
            mss.set_WasClipped(tg.get_WasClipped());
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "renderWithPolylines", new RendererException("Failed inside renderWithPolylines", exc));
        }
    }

    public static void render_GE(TGLight tg, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos, IPointConversion converter, Object clipArea, Graphics2D g2d) {
        clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, converter, clipArea);
    }

    public static void render_GE(TGLight tg, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos, IPointConversion converter, Object clipArea) {
        try {
            clsRenderer.reversePointsRevD(tg);
            Rectangle2D.Double clipBounds = null;
            CELineArray.setClient("ge");
            ArrayList<POINT2> origFillPixels = lineutility.getDeepCopy(tg.Pixels);
            if (tg.get_LineType() == 22123000) {
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.SegmentLCPoints(tg, converter);
            }
            ArrayList<Point2D> clipPoints = null;
            if (clipArea != null) {
                if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                    clipBounds = (Rectangle2D.Double)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                    Rectangle rectx = (Rectangle)clipArea;
                    clipBounds = new Rectangle2D.Double(rectx.x, rectx.y, rectx.width, rectx.height);
                } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                    clipPoints = (ArrayList<Point2D>)clipArea;
                }
            }
            double zoomFactor = clsUtilityGE.getZoomFactor(clipBounds, clipPoints, tg.Pixels);
            boolean useClipPoints = false;
            if (useClipPoints && clipBounds != null) {
                double x = clipBounds.getMinX();
                double y = clipBounds.getMinY();
                double width = ((RectangularShape)clipBounds).getWidth();
                double height = ((RectangularShape)clipBounds).getHeight();
                clipPoints = new ArrayList<Point2D>();
                clipPoints.add(new Point2D.Double(x, y));
                clipPoints.add(new Point2D.Double(x + width, y));
                clipPoints.add(new Point2D.Double(x + width, y + height));
                clipPoints.add(new Point2D.Double(x, y + height));
                clipPoints.add(new Point2D.Double(x, y));
                clipBounds = null;
            }
            if (tg.get_Client() == null || tg.get_Client().isEmpty()) {
                tg.set_client("ge");
            }
            clsUtility.RemoveDuplicatePoints(tg);
            int linetype = tg.get_LineType();
            if (linetype < 0) {
                linetype = armyc2.c5isr.JavaTacticalRenderer.clsUtility.GetLinetypeFromString(tg.get_SymbolId());
                tg.set_LineType(linetype);
            }
            Boolean isTextFlipped = false;
            ArrayList<Shape2> shapes = null;
            clsUtilityGE.setSplineLinetype(tg);
            clsUtilityCPOF.SegmentGeoPoints(tg, converter, zoomFactor);
            if ((clipBounds != null || clipPoints != null) && clsUtilityCPOF.canClipPoints(tg).booleanValue()) {
                if (clipBounds != null) {
                    clsClipPolygon2.ClipPolygon(tg, clipBounds);
                } else if (clipPoints != null) {
                    clsClipQuad.ClipPolygon(tg, clipPoints);
                }
                clsUtilityGE.removeTrailingPoints(tg, clipArea);
                tg.LatLongs = clsUtility.PixelsToLatLong(tg.Pixels, converter);
            }
            armyc2.c5isr.JavaTacticalRenderer.clsUtility.InterpolatePixels(tg);
            tg.modifiers = new ArrayList();
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.setFont(tg.get_Font());
            Modifier2.AddModifiersGeo(tg, g2d, clipArea, converter);
            clsUtilityCPOF.FilterPoints2(tg, converter);
            armyc2.c5isr.JavaTacticalRenderer.clsUtility.FilterVerticalSegments(tg);
            clsUtility.FilterAXADPoints(tg, converter);
            clsUtilityCPOF.ClearPixelsStyle(tg);
            ArrayList<Shape2> linesWithFillShapes = null;
            ArrayList<POINT2> savePixels = tg.Pixels;
            tg.Pixels = origFillPixels;
            if (clipBounds != null) {
                linesWithFillShapes = clsClipPolygon2.LinesWithFill(tg, clipBounds);
            } else if (clipPoints != null) {
                linesWithFillShapes = clsClipQuad.LinesWithFill(tg, clipPoints);
            } else if (clipArea == null) {
                linesWithFillShapes = clsClipPolygon2.LinesWithFill(tg, null);
            }
            tg.Pixels = savePixels;
            ArrayList<Shape2> rangeFanFillShapes = null;
            int savefillStyle = tg.get_FillStyle();
            if (linetype == 243111000) {
                tg.set_Fillstyle(0);
            }
            if (clipBounds != null) {
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
            } else if (clipPoints != null) {
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipPoints);
            } else if (clipArea == null) {
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, null);
            }
            if (shapes != null && SymbolID.getSymbolSet(tg.get_SymbolId()) == 25 && SymbolUtilities.hasFDI(tg.get_SymbolId()).booleanValue()) {
                clsRenderer.addFDI(tg, shapes);
            }
            switch (linetype) {
                case 25200700: 
                case 243111000: 
                case 243112000: {
                    if (tg.get_FillColor() == null || tg.get_FillColor().getAlpha() < 2) break;
                    TGLight tg1 = clsUtilityCPOF.GetCircularRangeFanFillTG(tg);
                    tg1.set_Fillstyle(savefillStyle);
                    tg1.set_SymbolId(tg.get_SymbolId());
                    if (clipBounds != null) {
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipBounds);
                    } else if (clipPoints != null) {
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipPoints);
                    } else if (clipArea == null) {
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, null);
                    }
                    if (rangeFanFillShapes == null) break;
                    if (shapes == null) {
                        System.out.println("shapes is null");
                        break;
                    }
                    shapes.addAll(0, rangeFanFillShapes);
                    break;
                }
                default: {
                    clsRenderer2.getAutoshapeFillShape(tg, shapes);
                }
            }
            clsUtilityCPOF.LinesWithSeparateFill(tg.get_LineType(), shapes);
            clsClipPolygon2.addAbatisFill(tg, shapes);
            if (shapes != null && linesWithFillShapes != null && linesWithFillShapes.size() > 0) {
                shapes.addAll(0, linesWithFillShapes);
            }
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            } else if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipPoints != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipPoints);
            }
            clsRenderer.resolvePostClippedShapes(tg, shapes);
            if (modifierShapeInfos != null) {
                ArrayList<Shape2> textSpecs = new ArrayList<Shape2>();
                Modifier2.DisplayModifiers2(tg, g2d, textSpecs, isTextFlipped, converter);
                clsRenderer.Shape2ToShapeInfo(modifierShapeInfos, textSpecs);
            }
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            clsUtility.addHatchFills(tg, shapeInfos);
            if (clipBounds != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipBounds);
            } else if (clipPoints != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipPoints);
            } else if (clipArea == null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, null);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "render_GE", new RendererException("Failed inside render_GE", exc));
        }
    }

    public static void render_Shape(MilStdSymbol milStd, IPointConversion ipc, Object clipArea, int shapeType, Color lineColor, Color fillColor, int hatch) {
        try {
            Rectangle2D clipBounds = null;
            ArrayList clipPoints = null;
            if (clipArea != null) {
                if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                    clipBounds = (Rectangle2D.Double)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                    clipBounds = (Rectangle2D)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                    clipPoints = (ArrayList)clipArea;
                }
            }
            TGLight tg = new TGLight();
            tg.set_SymbolId(milStd.getSymbolID());
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, ipc);
            Shape2 shape = new Shape2(shapeType);
            shape.setFillColor(fillColor);
            if (lineColor != null) {
                shape.setLineColor(lineColor);
                shape.setStroke(new BasicStroke(milStd.getLineWidth()));
            }
            for (int j = 0; j < tg.Pixels.size(); ++j) {
                POINT2 pt = tg.Pixels.get(j);
                if (j == 0) {
                    shape.moveTo(pt);
                    continue;
                }
                shape.lineTo(pt);
            }
            ArrayList<Shape2> shapes = new ArrayList<Shape2>();
            shapes.add(shape);
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            } else if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipPoints != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipPoints);
            }
            shape = shapes.get(0);
            if (hatch > 1) {
                shape = clsUtility.buildHatchArea(tg, shape, hatch, 20.0);
                shape.setLineColor(lineColor);
                shape.setStroke(new BasicStroke(1.0f));
                shapes.add(shape);
            }
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            if (clipBounds != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipBounds);
            } else if (clipPoints != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipPoints);
            } else if (clipArea == null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, null);
            }
            if (milStd.getSymbolShapes() == null) {
                milStd.setSymbolShapes(shapeInfos);
            } else {
                milStd.getSymbolShapes().addAll(shapeInfos);
            }
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "render_Shape", new RendererException("Failed inside render_Shape", exc));
            return;
        }
    }

    private static void resolvePostClippedShapes(TGLight tg, ArrayList<Shape2> shapes) {
        try {
            switch (tg.get_LineType()) {
                case 14000001: 
                case 14000002: 
                case 15000000: 
                case 15000001: 
                case 15000002: 
                case 15000003: {
                    break;
                }
                default: {
                    return;
                }
            }
            Color fillColor = tg.get_FillColor();
            shapes.get(0).setFillColor(fillColor);
            shapes.get(1).setFillColor(null);
            int fillStyle = tg.get_FillStyle();
            shapes.get(0).set_Fillstyle(0);
            shapes.get(1).set_Fillstyle(fillStyle);
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "resolvePostClippedShapes", new RendererException("Failed inside resolvePostClippedShapes", exc));
            return;
        }
    }

    private static boolean setClip(Object clipBounds, Rectangle2D clipRect, ArrayList<Point2D> clipArray) {
        try {
            if (clipBounds == null) {
                return false;
            }
            if (clipBounds.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipRect.setRect((Rectangle2D)clipBounds);
            } else if (clipBounds.getClass().isAssignableFrom(Rectangle2D.class)) {
                clipRect.setRect((Rectangle2D)clipBounds);
            } else if (clipBounds.getClass().isAssignableFrom(Rectangle.class)) {
                Rectangle rectx = (Rectangle)clipBounds;
                clipRect.setRect(rectx.x, rectx.y, rectx.width, rectx.height);
            } else if (clipBounds.getClass().isAssignableFrom(ArrayList.class)) {
                clipArray.addAll((ArrayList)clipBounds);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "setClip", new RendererException("Failed inside setClip", exc));
        }
        return true;
    }

    public static void render(MilStdSymbol mss, IPointConversion converter, Object clipBounds) {
        try {
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            clsRenderer.render(mss, converter, shapeInfos, modifierShapeInfos, clipBounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "render", new RendererException("render", exc));
        }
    }

    public static void render(MilStdSymbol mss, IPointConversion converter, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos, Object clipBounds) {
        try {
            Rectangle2D.Double clipRect = new Rectangle2D.Double();
            ArrayList<Point2D> clipArray = new ArrayList<Point2D>();
            clsRenderer.setClip(clipBounds, clipRect, clipArray);
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbol(mss, converter);
            clsRenderer.reversePointsRevD(tg);
            CELineArray.setClient("generic");
            int linetype = tg.get_LineType();
            clsUtility.RemoveDuplicatePoints(tg);
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.setFont(tg.get_Font());
            clsUtilityCPOF.SegmentGeoPoints(tg, converter, 1.0);
            clsUtility.FilterAXADPoints(tg, converter);
            armyc2.c5isr.JavaTacticalRenderer.clsUtility.FilterVerticalSegments(tg);
            boolean isChange1Area = armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(linetype);
            boolean isTextFlipped = false;
            ArrayList farLeftPixels = new ArrayList();
            ArrayList farRightPixels = new ArrayList();
            if (!isChange1Area) {
                clsUtilityCPOF.GetFarPixels(tg, converter, farLeftPixels, farRightPixels);
            }
            ArrayList<Object> shapesLeft = new ArrayList();
            ArrayList<Object> shapesRight = new ArrayList();
            ArrayList<Object> shapes = null;
            ArrayList<Shape2> textSpecsLeft = null;
            ArrayList<Shape2> textSpecsRight = null;
            textSpecsLeft = new ArrayList<Shape2>();
            textSpecsRight = new ArrayList<Shape2>();
            if (farLeftPixels.size() > 0) {
                tg.Pixels = farLeftPixels;
                shapesLeft = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                Modifier2.DisplayModifiers2(tg, g2d, textSpecsLeft, isTextFlipped, null);
            }
            if (farRightPixels.size() > 0) {
                tg.Pixels = farRightPixels;
                shapesRight = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                Modifier2.DisplayModifiers2(tg, g2d, textSpecsRight, isTextFlipped, null);
            }
            ArrayList<Shape2> textSpecs = new ArrayList<Shape2>();
            if (shapesLeft.isEmpty() || shapesRight.isEmpty()) {
                ArrayList<Shape2> linesWithFillShapes = null;
                linesWithFillShapes = clipArray != null && !clipArray.isEmpty() ? clsClipQuad.LinesWithFill(tg, clipArray) : (clipRect != null && ((RectangularShape)clipRect).getWidth() != 0.0 ? clsClipPolygon2.LinesWithFill(tg, clipRect) : clsClipPolygon2.LinesWithFill(tg, null));
                if (clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                    if (clipArray != null && !clipArray.isEmpty()) {
                        clsClipQuad.ClipPolygon(tg, clipArray);
                    } else if (clipRect != null && ((RectangularShape)clipRect).getWidth() != 0.0) {
                        clsClipPolygon2.ClipPolygon(tg, clipRect);
                    }
                    tg.LatLongs = clsUtility.PixelsToLatLong(tg.Pixels, converter);
                }
                armyc2.c5isr.JavaTacticalRenderer.clsUtility.InterpolatePixels(tg);
                tg.modifiers = new ArrayList();
                Modifier2.AddModifiersGeo(tg, g2d, clipBounds, converter);
                clsUtilityCPOF.FilterPoints2(tg, converter);
                clsUtilityCPOF.ClearPixelsStyle(tg);
                ArrayList<Shape2> rangeFanFillShapes = null;
                int savefillStyle = tg.get_FillStyle();
                if (linetype == 243111000) {
                    tg.set_Fillstyle(0);
                }
                if ((shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds)) != null && SymbolID.getSymbolSet(tg.get_SymbolId()) == 25 && SymbolUtilities.hasFDI(tg.get_SymbolId()).booleanValue()) {
                    clsRenderer.addFDI(tg, shapes);
                }
                switch (linetype) {
                    case 25200700: 
                    case 243111000: 
                    case 243112000: {
                        if (tg.get_FillColor() == null || tg.get_FillColor().getAlpha() < 2) break;
                        TGLight tg1 = clsUtilityCPOF.GetCircularRangeFanFillTG(tg);
                        tg1.set_Fillstyle(savefillStyle);
                        tg1.set_SymbolId(tg.get_SymbolId());
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipBounds);
                        if (rangeFanFillShapes == null) break;
                        shapes.addAll(0, rangeFanFillShapes);
                        break;
                    }
                }
                clsUtilityCPOF.LinesWithSeparateFill(tg.get_LineType(), shapes);
                clsClipPolygon2.addAbatisFill(tg, shapes);
                if (shapes != null && linesWithFillShapes != null && linesWithFillShapes.size() > 0) {
                    shapes.addAll(0, linesWithFillShapes);
                }
                if (shapes != null && shapes.size() > 0) {
                    Modifier2.DisplayModifiers2(tg, g2d, textSpecs, isTextFlipped, null);
                    clsRenderer.Shape2ToShapeInfo(modifierShapeInfos, textSpecs);
                    mss.setModifierShapes(modifierShapeInfos);
                }
            } else {
                shapes = shapesLeft;
                shapes.addAll(shapesRight);
                if (textSpecs != null) {
                    textSpecs.addAll(textSpecsLeft);
                    textSpecs.addAll(textSpecsRight);
                }
            }
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            }
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            clsUtility.addHatchFills(tg, shapeInfos);
            mss.setSymbolShapes(shapeInfos);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "render", new RendererException("Failed inside render", exc));
        }
    }

    public static int getCMLineType(int version, int entityCode) {
        if (version >= 15) {
            switch (entityCode) {
                case 152600: {
                    return 25152600;
                }
                case 152700: {
                    return 25152700;
                }
                case 152900: {
                    return 25152900;
                }
                case 152800: {
                    return 25152800;
                }
                case 242800: {
                    return 25242800;
                }
                case 342900: {
                    return 25342900;
                }
                case 343100: {
                    return 25343100;
                }
                case 343300: {
                    return 25343300;
                }
                case 343500: {
                    return 25343500;
                }
                case 343800: {
                    return 25343800;
                }
                case 344000: {
                    return 25344000;
                }
                case 344400: {
                    return 25344400;
                }
                case 344500: {
                    return 25344500;
                }
                case 344700: {
                    return 23173000;
                }
                case 172000: {
                    return 22235000;
                }
                case 240804: {
                    return -1;
                }
            }
        }
        if (version >= 13) {
            switch (entityCode) {
                case 110400: {
                    return 25110400;
                }
                case 120700: {
                    return 25120700;
                }
                case 141800: {
                    return 25141800;
                }
                case 141900: {
                    return 2514190;
                }
                case 310800: {
                    return 25310800;
                }
                case 330500: {
                    return 25330500;
                }
                case 330501: {
                    return 25330501;
                }
                case 330502: {
                    return 25330502;
                }
                case 344100: {
                    return 25344100;
                }
                case 344200: {
                    return 25344200;
                }
                case 120500: {
                    return 13120500;
                }
                case 120600: {
                    return 13120600;
                }
                case 151000: {
                    return 1322134000;
                }
                case 260400: {
                    return 1325260400;
                }
                case 310100: {
                    return 1325310000;
                }
                case 172000: {
                    return 2517200;
                }
            }
        } else {
            switch (entityCode) {
                case 120500: {
                    return 11120500;
                }
                case 120600: {
                    return 11120600;
                }
                case 151000: {
                    return 22134000;
                }
                case 260400: {
                    return 25260400;
                }
                case 310100: {
                    return 25310000;
                }
                case 150300: {
                    return 22132000;
                }
                case 241601: {
                    return 24333100;
                }
                case 241602: {
                    return 24333200;
                }
                case 241603: {
                    return 24333300;
                }
                case 172000: {
                    return 2517200;
                }
            }
        }
        switch (entityCode) {
            case 200101: {
                return 25200101;
            }
            case 200201: {
                return 25200201;
            }
            case 200202: {
                return 25200202;
            }
            case 120100: {
                return 22621000;
            }
            case 120200: {
                return 22625000;
            }
            case 120300: {
                return 22626000;
            }
            case 120400: {
                return 221311000;
            }
            case 151401: {
                return 22521200;
            }
            case 151402: {
                return 22521300;
            }
            case 151403: {
                return 22521410;
            }
            case 151404: {
                return 22521420;
            }
            case 110100: {
                return 22121000;
            }
            case 110200: {
                return 22125000;
            }
            case 110300: {
                return 110300;
            }
            case 140100: {
                return 22122000;
            }
            case 140200: {
                return 22123000;
            }
            case 140300: {
                return 22124000;
            }
            case 140400: {
                return 25140400;
            }
            case 140500: {
                return 22422000;
            }
            case 140601: {
                return 22522100;
            }
            case 140602: {
                return 22522210;
            }
            case 140603: {
                return 22522220;
            }
            case 140700: {
                return 22523000;
            }
            case 140800: {
                return 22524000;
            }
            case 140900: {
                return 22525000;
            }
            case 141000: {
                return 22526000;
            }
            case 141100: {
                return 22527000;
            }
            case 141200: {
                return 22528000;
            }
            case 150200: {
                return 22132000;
            }
            case 150100: {
                return 22131000;
            }
            case 150501: {
                return 150501;
            }
            case 150502: {
                return 150502;
            }
            case 150503: {
                return 150503;
            }
            case 150600: {
                return 22135000;
            }
            case 150700: {
                return 22136000;
            }
            case 150800: {
                return 22137000;
            }
            case 150900: {
                return 22138000;
            }
            case 151100: {
                return 221310000;
            }
            case 151200: {
                return 22431000;
            }
            case 151202: {
                return 22431100;
            }
            case 151204: {
                return 21600000;
            }
            case 151205: {
                return 211900000;
            }
            case 151300: {
                return 22133000;
            }
            case 151203: {
                return 23350000;
            }
            case 151500: {
                return 22531000;
            }
            case 151600: {
                return 22532000;
            }
            case 151700: {
                return 22535000;
            }
            case 151800: {
                return 22624000;
            }
            case 151900: {
                return 22536000;
            }
            case 152000: {
                return 22533000;
            }
            case 152100: {
                return 22534000;
            }
            case 152200: {
                return 22139000;
            }
            case 141300: {
                return 22622000;
            }
            case 141400: {
                return 22623000;
            }
            case 141500: {
                return 22612000;
            }
            case 141600: {
                return 22613000;
            }
            case 141700: {
                return 22611000;
            }
            case 170100: {
                return 22221000;
            }
            case 170200: {
                return 22225000;
            }
            case 170300: {
                return 22222000;
            }
            case 170400: {
                return 25170400;
            }
            case 170500: {
                return 22223000;
            }
            case 170600: {
                return 25170600;
            }
            case 170700: {
                return 22224000;
            }
            case 170800: {
                return 25170800;
            }
            case 170900: {
                return 22233000;
            }
            case 171000: {
                return 22231000;
            }
            case 171100: {
                return 25171100;
            }
            case 171200: {
                return 25171200;
            }
            case 171300: {
                return 25171300;
            }
            case 171400: {
                return 25171400;
            }
            case 171500: {
                return 25171500;
            }
            case 171600: {
                return 22234000;
            }
            case 171700: {
                return 22234100;
            }
            case 171800: {
                return 22234200;
            }
            case 171900: {
                return 22232000;
            }
            case 200401: {
                return 25200401;
            }
            case 240804: {
                return 240804;
            }
            case 220100: {
                return 26400000;
            }
            case 220101: {
                return 26410000;
            }
            case 220102: {
                return 220101;
            }
            case 220103: {
                return 26420000;
            }
            case 220104: {
                return 220104;
            }
            case 220105: {
                return 26430000;
            }
            case 220106: {
                return 26440000;
            }
            case 218400: {
                return 26220000;
            }
            case 220107: {
                return 220107;
            }
            case 220108: {
                return 220108;
            }
            case 240101: {
                return 24322100;
            }
            case 240102: {
                return 24322200;
            }
            case 240103: {
                return 24322300;
            }
            case 240201: {
                return 24323100;
            }
            case 240202: {
                return 24323200;
            }
            case 240203: {
                return 24323300;
            }
            case 240301: {
                return 24324100;
            }
            case 240302: {
                return 24324200;
            }
            case 240303: {
                return 24324300;
            }
            case 240401: {
                return 24325100;
            }
            case 240402: {
                return 24325200;
            }
            case 240403: {
                return 24325300;
            }
            case 240503: {
                return 243100000;
            }
            case 240501: {
                return 24326100;
            }
            case 240502: {
                return 24326200;
            }
            case 260100: {
                return 24210000;
            }
            case 300100: {
                return 25300100;
            }
            case 190100: {
                return 25190100;
            }
            case 190200: {
                return 25190200;
            }
            case 260200: {
                return 24220000;
            }
            case 260300: {
                return 24230000;
            }
            case 260500: {
                return 24240000;
            }
            case 260600: {
                return 24225000;
            }
            case 240701: {
                return 24250000;
            }
            case 240702: {
                return 24211000;
            }
            case 240703: {
                return 24260000;
            }
            case 240801: {
                return 24330000;
            }
            case 240802: {
                return 24311000;
            }
            case 240803: {
                return 24312000;
            }
            case 240805: {
                return 24313000;
            }
            case 240806: {
                return 24314000;
            }
            case 240808: {
                return 24315000;
            }
            case 241001: {
                return 24321100;
            }
            case 241002: {
                return 24321200;
            }
            case 200402: {
                return 25200402;
            }
            case 200600: {
                return 25200600;
            }
            case 200700: {
                return 25200700;
            }
            case 241003: {
                return 24321300;
            }
            case 200300: {
                return 25200300;
            }
            case 241101: {
                return 24331100;
            }
            case 241102: {
                return 24331200;
            }
            case 241103: {
                return 24331300;
            }
            case 241201: {
                return 24332100;
            }
            case 241202: {
                return 24332200;
            }
            case 241203: {
                return 24332300;
            }
            case 241301: {
                return 24334100;
            }
            case 241302: {
                return 24334200;
            }
            case 241303: {
                return 24334300;
            }
            case 241401: {
                return 24336100;
            }
            case 241402: {
                return 24336200;
            }
            case 241403: {
                return 24336300;
            }
            case 241501: {
                return 24335100;
            }
            case 241502: {
                return 24335200;
            }
            case 241503: {
                return 24335300;
            }
            case 241701: {
                return 24338100;
            }
            case 241702: {
                return 24338200;
            }
            case 241703: {
                return 24338300;
            }
            case 241801: {
                return 24339100;
            }
            case 241802: {
                return 24339200;
            }
            case 241803: {
                return 24339300;
            }
            case 241901: {
                return 24337100;
            }
            case 241902: {
                return 24337200;
            }
            case 241903: {
                return 24337300;
            }
            case 242000: {
                return 24226000;
            }
            case 242100: {
                return 243111000;
            }
            case 242200: {
                return 243112000;
            }
            case 242301: {
                return 24351000;
            }
            case 242302: {
                return 24352000;
            }
            case 242303: {
                return 24353000;
            }
            case 242304: {
                return 24361000;
            }
            case 242305: {
                return 24362000;
            }
            case 242306: {
                return 24363000;
            }
            case 270100: 
            case 270200: {
                return 23113000;
            }
            case 270300: {
                return 23114000;
            }
            case 270400: {
                return 23115000;
            }
            case 270501: {
                return 23171000;
            }
            case 270502: {
                return 23174000;
            }
            case 270503: {
                return 23172000;
            }
            case 270504: {
                return 25270504;
            }
            case 270601: {
                return 23211000;
            }
            case 270602: {
                return 23212000;
            }
            case 270603: {
                return 23213000;
            }
            case 271100: {
                return 23163000;
            }
            case 271201: {
                return 23191000;
            }
            case 271202: {
                return 23192000;
            }
            case 271203: {
                return 23193000;
            }
            case 271204: {
                return 23194000;
            }
            case 280100: {
                return 23120000;
            }
            case 290100: {
                return 23112000;
            }
            case 290201: {
                return 23131100;
            }
            case 290202: {
                return 23131200;
            }
            case 290203: {
                return 23132000;
            }
            case 290204: {
                return 23134000;
            }
            case 290301: {
                return 231111000;
            }
            case 290302: {
                return 231112000;
            }
            case 290303: {
                return 231113000;
            }
            case 290304: {
                return 231114000;
            }
            case 290305: {
                return 231115000;
            }
            case 290306: {
                return 231116000;
            }
            case 290307: {
                return 231117100;
            }
            case 290308: {
                return 231117200;
            }
            case 290309: {
                return 231117300;
            }
            case 290600: {
                return 23226000;
            }
            case 270707: {
                return 23162000;
            }
            case 270800: {
                return 23164000;
            }
            case 270801: {
                return 270801;
            }
            case 290101: {
                return 290101;
            }
            case 271000: {
                return 23180000;
            }
            case 271700: {
                return 23450000;
            }
            case 271800: {
                return 23460000;
            }
            case 271900: {
                return 271900;
            }
            case 272000: {
                return 23440000;
            }
            case 290400: {
                return 23157000;
            }
            case 290500: {
                return 231100000;
            }
            case 282003: {
                return 23200000;
            }
            case 271300: {
                return 23221000;
            }
            case 271500: {
                return 23224000;
            }
            case 271600: {
                return 23225000;
            }
            case 290700: {
                return 23223000;
            }
            case 290800: {
                return 23227000;
            }
            case 290900: {
                return 23330000;
            }
            case 291000: {
                return 23340000;
            }
            case 272100: {
                return 23410000;
            }
            case 272200: {
                return 23490000;
            }
            case 310200: {
                return 25320000;
            }
            case 310300: {
                return 25330000;
            }
            case 310400: {
                return 25340000;
            }
            case 310500: {
                return 25353000;
            }
            case 310600: {
                return 25351000;
            }
            case 310700: {
                return 25352000;
            }
            case 330100: {
                return 25211000;
            }
            case 330200: {
                return 25212000;
            }
            case 330300: {
                return 25221000;
            }
            case 330301: {
                return 25330301;
            }
            case 330401: {
                return 25330401;
            }
            case 330302: {
                return 25330302;
            }
            case 330402: {
                return 25330402;
            }
            case 330303: {
                return 25330303;
            }
            case 330403: {
                return 25330403;
            }
            case 330400: {
                return 25222000;
            }
            case 340100: {
                return 21100000;
            }
            case 340200: {
                return 21200000;
            }
            case 340300: {
                return 21300000;
            }
            case 340400: {
                return 21400000;
            }
            case 340500: {
                return 21500000;
            }
            case 340600: {
                return 21700000;
            }
            case 340700: {
                return 21710000;
            }
            case 340800: {
                return 21800000;
            }
            case 341000: {
                return 211000000;
            }
            case 341100: {
                return 211100000;
            }
            case 341200: {
                return 211200000;
            }
            case 341300: {
                return 211210000;
            }
            case 341500: {
                return 211400000;
            }
            case 341700: {
                return 211600000;
            }
            case 341800: {
                return 211700000;
            }
            case 341900: {
                return 211800000;
            }
            case 342000: {
                return 212000000;
            }
            case 342100: {
                return 212100000;
            }
            case 342201: {
                return 212230000;
            }
            case 342202: {
                return 212220000;
            }
            case 342203: {
                return 212210000;
            }
            case 342300: {
                return 212300000;
            }
            case 342400: {
                return 212400000;
            }
            case 342500: {
                return 212410000;
            }
            case 342600: {
                return 212600000;
            }
            case 342700: {
                return 212500000;
            }
            case 272101: {
                return 272101;
            }
        }
        return -1;
    }

    private static void reversePointsRevD(TGLight tg) {
        try {
            if (tg.get_SymbolId().length() < 20 || SymbolID.getSymbolSet(tg.get_SymbolId()) != 25) {
                return;
            }
            switch (tg.get_LineType()) {
                case 23112000: 
                case 231111000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    if (tg.Pixels != null) {
                        Collections.reverse(tg.Pixels);
                    }
                    if (tg.LatLongs == null) break;
                    Collections.reverse(tg.LatLongs);
                    break;
                }
                case 23157000: {
                    if (SymbolID.getVersion(tg.get_SymbolId()) >= 13) break;
                    if (tg.Pixels != null) {
                        Collections.reverse(tg.Pixels);
                    }
                    if (tg.LatLongs == null) break;
                    Collections.reverse(tg.LatLongs);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "reversePointsRevD", new RendererException("Failed inside reversePointsRevD", exc));
        }
    }
}

