/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.RenderMultipoints;

import armyc2.c5isr.JavaLineArray.POINT2;
import armyc2.c5isr.JavaLineArray.Shape2;
import armyc2.c5isr.JavaLineArray.arraysupport;
import armyc2.c5isr.JavaLineArray.lineutility;
import armyc2.c5isr.JavaLineArray.ref;
import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.JavaTacticalRenderer.clsMETOC;
import armyc2.c5isr.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c5isr.RenderMultipoints.clsClipPolygon2;
import armyc2.c5isr.RenderMultipoints.clsClipQuad;
import armyc2.c5isr.RenderMultipoints.clsUtility;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.RendererException;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class clsUtilityCPOF {
    private static final String _className = "clsUtilityCPOF";

    private static POINT2 PointLatLongToPixels(POINT2 ptLatLong, IPointConversion converter) {
        POINT2 pt = new POINT2();
        try {
            double x = ptLatLong.x;
            double y = ptLatLong.y;
            Point2D ptPixels = converter.GeoToPixels(new Point2D.Double(x, y));
            pt.x = ptPixels.getX();
            pt.y = ptPixels.getY();
            pt.style = ptLatLong.style;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "PointLatLongToPixels", new RendererException("Failed inside PointLatLongToPixels", exc));
        }
        return pt;
    }

    private static void GetNumericFields(TGLight tg, int lineType, ref<double[]> radius, ref<double[]> width, ref<double[]> length, ref<double[]> attitude) {
        try {
            if (lineType == 243111001) {
                return;
            }
            double dist = 0.0;
            ref<double[]> a12 = new ref<double[]>();
            ref<double[]> a21 = new ref<double[]>();
            POINT2 pt0 = new POINT2(0.0, 0.0);
            POINT2 pt1 = new POINT2(0.0, 0.0);
            radius.value = new double[1];
            width.value = new double[1];
            attitude.value = new double[2];
            length.value = new double[1];
            switch (lineType) {
                case 13000002: 
                case 15000002: 
                case 24312000: 
                case 24321300: 
                case 24322300: 
                case 24323300: 
                case 24324300: 
                case 24325300: 
                case 24326200: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: 
                case 25170800: 
                case 25200300: {
                    if (!SymbolUtilities.isNumber(tg.get_AM())) break;
                    ((double[])radius.value)[0] = Double.parseDouble(tg.get_AM());
                    break;
                }
                case 13000001: 
                case 25200101: 
                case 25200201: 
                case 25200401: {
                    if (SymbolUtilities.isNumber(tg.get_AM1())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_AM1());
                    }
                    if (SymbolUtilities.isNumber(tg.get_AM())) {
                        ((double[])width.value)[0] = Double.parseDouble(tg.get_AM());
                    }
                    if (!SymbolUtilities.isNumber(tg.get_AN())) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_AN());
                    break;
                }
                case 24311000: {
                    if (SymbolUtilities.isNumber(tg.get_AM1())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_AM1());
                    }
                    if (SymbolUtilities.isNumber(tg.get_AM())) {
                        ((double[])width.value)[0] = Double.parseDouble(tg.get_AM());
                    }
                    if (!SymbolUtilities.isNumber(tg.get_AN())) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_AN()) * 0.05625;
                    break;
                }
                case 14000001: 
                case 14000002: {
                    if (SymbolUtilities.isNumber(tg.get_AM1())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_AM1());
                    }
                    if (SymbolUtilities.isNumber(tg.get_AM())) {
                        ((double[])width.value)[0] = Double.parseDouble(tg.get_AM());
                    }
                    if (!SymbolUtilities.isNumber(tg.get_AN())) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_AN());
                    break;
                }
                case 25200600: {
                    if (SymbolUtilities.isNumber(tg.get_AM())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_AM());
                    }
                    if (SymbolUtilities.isNumber(tg.get_AM1())) {
                        ((double[])width.value)[0] = Double.parseDouble(tg.get_AM1());
                    }
                    if (!SymbolUtilities.isNumber(tg.get_AN())) break;
                    ((double[])attitude.value)[0] = Double.parseDouble(tg.get_AN()) + 270.0;
                    break;
                }
                case 240804: 
                case 16000001: 
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326100: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: 
                case 25200202: 
                case 25200402: {
                    if (tg.LatLongs.size() >= 2) {
                        pt0 = tg.LatLongs.get(0);
                        pt1 = tg.LatLongs.get(1);
                        dist = mdlGeodesic.geodesic_distance(pt0, pt1, a12, a21);
                        ((double[])attitude.value)[0] = ((double[])a12.value)[0];
                    }
                    if (!SymbolUtilities.isNumber(tg.get_AM())) break;
                    ((double[])width.value)[0] = Double.parseDouble(tg.get_AM());
                    break;
                }
                case 16000004: {
                    if (SymbolUtilities.isNumber(tg.get_AM())) {
                        ((double[])length.value)[0] = Double.parseDouble(tg.get_AM());
                    }
                    String[] an = tg.get_AN().split(",");
                    ((double[])attitude.value)[0] = Double.parseDouble(an[0]);
                    ((double[])attitude.value)[1] = Double.parseDouble(an[1]);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetNumericFields", new RendererException("Failed inside GetNumericFields", exc));
        }
    }

    protected static void GetFarPixels(TGLight tg, IPointConversion converter, ArrayList farLeftPixels, ArrayList farRightPixels) {
        try {
            if (farLeftPixels == null || farRightPixels == null) {
                return;
            }
            Point2D ptPixels50 = converter.GeoToPixels(new Point2D.Double(50.0, 30.0));
            Point2D ptPixels60 = converter.GeoToPixels(new Point2D.Double(60.0, 30.0));
            double degLonPerPixel = 10.0 / Math.abs(ptPixels60.getX() - ptPixels50.getX());
            int j = 0;
            double minX = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                if (tg.Pixels.get((int)j).x < minX) {
                    minX = tg.Pixels.get((int)j).x;
                }
                if (!(tg.Pixels.get((int)j).x > maxX)) continue;
                maxX = tg.Pixels.get((int)j).x;
            }
            double degWidth = (maxX - minX) * degLonPerPixel;
            if (Math.abs(degWidth) < 180.0) {
                return;
            }
            double midX = Math.abs(180.0 / degLonPerPixel);
            double x = 0.0;
            double y = 0.0;
            for (j = 0; j < n; ++j) {
                x = tg.Pixels.get((int)j).x;
                y = tg.Pixels.get((int)j).y;
                if (x > midX) {
                    x -= 2.0 * midX;
                }
                farLeftPixels.add(new POINT2(x, y));
            }
            for (j = 0; j < n; ++j) {
                x = tg.Pixels.get((int)j).x;
                y = tg.Pixels.get((int)j).y;
                if (x < midX) {
                    x += 2.0 * midX;
                }
                farRightPixels.add(new POINT2(x, y));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetFarPixels", new RendererException("Failed inside GetFarPixels", exc));
        }
    }

    protected static boolean Change1TacticalAreas(TGLight tg, int lineType, IPointConversion converter, ArrayList<Shape2> shapes) {
        try {
            ref<double[]> width = new ref<double[]>();
            ref<double[]> length = new ref<double[]>();
            ref<double[]> attitude = new ref<double[]>();
            ref<double[]> radius = new ref<double[]>();
            int j = 0;
            POINT2 pt0 = tg.LatLongs.get(0);
            POINT2 pt1 = null;
            POINT2 ptTemp = new POINT2();
            POINT2 pt00 = new POINT2();
            pt1 = tg.LatLongs.size() > 1 ? tg.LatLongs.get(1) : tg.LatLongs.get(0);
            POINT2[] pPoints = null;
            POINT2 ptCenter = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
            clsUtilityCPOF.GetNumericFields(tg, lineType, radius, width, length, attitude);
            switch (lineType) {
                case 13000001: 
                case 25200101: 
                case 25200201: 
                case 25200401: {
                    POINT2[] ellipsePts = mdlGeodesic.getGeoEllipse(pt0, ((double[])width.value)[0], ((double[])length.value)[0], ((double[])attitude.value)[0]);
                    for (j = 0; j < ellipsePts.length; ++j) {
                        pt0 = ellipsePts[j];
                        pt1 = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
                        tg.Pixels.add(pt1);
                    }
                    break;
                }
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326100: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: 
                case 25200202: 
                case 25200402: {
                    pt00 = mdlGeodesic.geodesic_coordinate(pt0, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    pt00 = clsUtilityCPOF.PointLatLongToPixels(pt00, converter);
                    pt00.style = 0;
                    tg.Pixels.add(pt00);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt1, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt1, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    tg.Pixels.add(pt00);
                    break;
                }
                case 16000001: {
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt1, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    pPoints = new POINT2[]{new POINT2(pt1), new POINT2(ptTemp), new POINT2(ptTemp)};
                    ArrayList<Object> pPoints2 = mdlGeodesic.GetGeodesicArc(pPoints);
                    for (j = 0; j < pPoints2.size() / 2; ++j) {
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels((POINT2)pPoints2.get(j), converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                    }
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    pPoints[0] = new POINT2(pt0);
                    pPoints[1] = new POINT2(ptTemp);
                    pPoints[2] = new POINT2(ptTemp);
                    pPoints2 = mdlGeodesic.GetGeodesicArc(pPoints);
                    for (j = 0; j < pPoints2.size() / 2; ++j) {
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels((POINT2)pPoints2.get(j), converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                    }
                    break;
                }
                case 16000002: {
                    ref<double[]> a21;
                    ArrayList<String> am = new ArrayList<String>(Arrays.asList(tg.get_AM().split(",")));
                    while (am.size() < tg.LatLongs.size() - 1) {
                        am.add(am.get(am.size() - 1));
                    }
                    for (int i = 0; i < tg.LatLongs.size() - 1; ++i) {
                        ref<double[]> a12 = new ref<double[]>();
                        a21 = new ref<double[]>();
                        pt0 = tg.LatLongs.get(i);
                        pt1 = tg.LatLongs.get(i + 1);
                        double widthVal = 0.0;
                        double attitudeVal = 0.0;
                        mdlGeodesic.geodesic_distance(pt0, pt1, a12, a21);
                        attitudeVal = ((double[])a12.value)[0];
                        if (SymbolUtilities.isNumber(am.get(i))) {
                            widthVal = Double.parseDouble(am.get(i));
                        }
                        pt00 = mdlGeodesic.geodesic_coordinate(pt0, widthVal / 2.0, attitudeVal - 90.0);
                        pt00 = clsUtilityCPOF.PointLatLongToPixels(pt00, converter);
                        pt00.style = 0;
                        tg.Pixels.add(pt00);
                        ptTemp = mdlGeodesic.geodesic_coordinate(pt0, widthVal / 2.0, attitudeVal + 90.0);
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                        ptTemp = mdlGeodesic.geodesic_coordinate(pt1, widthVal / 2.0, attitudeVal + 90.0);
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                        ptTemp = mdlGeodesic.geodesic_coordinate(pt1, widthVal / 2.0, attitudeVal - 90.0);
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                        pt00 = new POINT2(pt00);
                        pt00.style = 5;
                        tg.Pixels.add(pt00);
                    }
                    break;
                }
                case 16000006: {
                    ref<double[]> a21;
                    ArrayList<String> am = new ArrayList<String>(Arrays.asList(tg.get_AM().split(",")));
                    while (am.size() < tg.LatLongs.size() - 1) {
                        am.add(am.get(am.size() - 1));
                    }
                    for (int i = 0; i < tg.LatLongs.size() - 1; ++i) {
                        ref<double[]> a12 = new ref<double[]>();
                        a21 = new ref();
                        pt0 = tg.LatLongs.get(i);
                        pt1 = tg.LatLongs.get(i + 1);
                        double leftWidth = 0.0;
                        double rightWidth = 0.0;
                        double attitudeVal = 0.0;
                        mdlGeodesic.geodesic_distance(pt0, pt1, a12, a21);
                        attitudeVal = ((double[])a12.value)[0];
                        if (SymbolUtilities.isNumber(am.get(2 * i))) {
                            leftWidth = Double.parseDouble(am.get(2 * i));
                        }
                        if (SymbolUtilities.isNumber(am.get(2 * i + 1))) {
                            rightWidth = Double.parseDouble(am.get(2 * i + 1));
                        }
                        pt00 = mdlGeodesic.geodesic_coordinate(pt0, leftWidth, attitudeVal - 90.0);
                        pt00 = clsUtilityCPOF.PointLatLongToPixels(pt00, converter);
                        pt00.style = 0;
                        tg.Pixels.add(pt00);
                        ptTemp = mdlGeodesic.geodesic_coordinate(pt0, rightWidth, attitudeVal + 90.0);
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                        ptTemp = mdlGeodesic.geodesic_coordinate(pt1, rightWidth, attitudeVal + 90.0);
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                        ptTemp = mdlGeodesic.geodesic_coordinate(pt1, leftWidth, attitudeVal - 90.0);
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        ptTemp.style = 0;
                        tg.Pixels.add(ptTemp);
                        pt00 = new POINT2(pt00);
                        pt00.style = 5;
                        tg.Pixels.add(pt00);
                    }
                    break;
                }
                case 240804: {
                    Object[] pts = new POINT2[4];
                    pts[0] = mdlGeodesic.geodesic_coordinate(pt0, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(pts[0], converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    pts[1] = mdlGeodesic.geodesic_coordinate(pt0, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(pts[1], converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    pts[2] = mdlGeodesic.geodesic_coordinate(pt1, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(pts[2], converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    pts[3] = mdlGeodesic.geodesic_coordinate(pt1, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(pts[3], converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(pts[0], converter);
                    ptTemp.style = 5;
                    tg.Pixels.add(ptTemp);
                    double heightD = mdlGeodesic.geodesic_distance(pts[0], pts[1], null, null);
                    double widthD = mdlGeodesic.geodesic_distance(pts[1], pts[2], null, null);
                    double crossLength = Math.min(heightD, widthD) * 0.4;
                    POINT2 centerPt = lineutility.CalcCenterPointDouble2(pts, 4);
                    ptTemp = mdlGeodesic.geodesic_coordinate(centerPt, crossLength, 0.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(centerPt, crossLength, 180.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 5;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(centerPt, crossLength, -90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(centerPt, crossLength, 90.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    ptTemp.style = 0;
                    tg.Pixels.add(ptTemp);
                    break;
                }
                case 14000001: 
                case 14000002: 
                case 24311000: 
                case 25200600: {
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])length.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    ptTemp = mdlGeodesic.geodesic_coordinate(ptTemp, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 0.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])length.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    ptTemp = mdlGeodesic.geodesic_coordinate(ptTemp, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 0.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])length.value)[0] / 2.0, ((double[])attitude.value)[0] + 90.0);
                    ptTemp = mdlGeodesic.geodesic_coordinate(ptTemp, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 180.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])length.value)[0] / 2.0, ((double[])attitude.value)[0] - 90.0);
                    ptTemp = mdlGeodesic.geodesic_coordinate(ptTemp, ((double[])width.value)[0] / 2.0, ((double[])attitude.value)[0] + 180.0);
                    ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                    tg.Pixels.add(ptTemp);
                    tg.Pixels.add(new POINT2(tg.Pixels.get((int)0).x, tg.Pixels.get((int)0).y));
                    break;
                }
                case 13000002: 
                case 15000002: 
                case 24312000: 
                case 24321300: 
                case 24322300: 
                case 24323300: 
                case 24324300: 
                case 24325300: 
                case 24326200: 
                case 24331300: 
                case 24332300: 
                case 24333300: 
                case 24334300: 
                case 24335300: 
                case 24336300: 
                case 24337300: 
                case 24338300: 
                case 24339300: 
                case 24353000: 
                case 24363000: 
                case 25170800: 
                case 25200300: {
                    pt0 = tg.LatLongs.get(0);
                    ptTemp = mdlGeodesic.geodesic_coordinate(pt0, ((double[])radius.value)[0], 90.0);
                    pPoints = new POINT2[]{new POINT2(pt0), new POINT2(ptTemp), new POINT2(ptTemp)};
                    ArrayList<Object> pPoints2 = mdlGeodesic.GetGeodesicArc(pPoints);
                    POINT2 ptTemp2 = null;
                    for (j = 0; j < pPoints2.size(); ++j) {
                        pt0 = (POINT2)pPoints2.get(j);
                        ptTemp2 = new POINT2();
                        ptTemp2 = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
                        tg.Pixels.add(ptTemp2);
                    }
                    break;
                }
                case 243111000: {
                    clsUtilityCPOF.GetConcentricCircles(tg, lineType, converter);
                    if (tg.LatLongs.size() <= 1) break;
                    clsUtilityCPOF.RangeFanOrientation(tg, lineType, converter);
                    break;
                }
                case 243112000: {
                    clsUtilityCPOF.GetSectorRangeFan(tg, converter);
                    clsUtilityCPOF.RangeFanOrientation(tg, lineType, converter);
                    break;
                }
                case 16000003: 
                case 16000005: 
                case 25200700: {
                    clsUtilityCPOF.GetSectorRangeFan(tg, converter);
                    break;
                }
                case 243111001: {
                    clsUtilityCPOF.GetSectorRangeFan(tg, converter);
                    break;
                }
                case 16000004: {
                    int i;
                    if (clsUtilityCPOF.CalculateSignedAreaOfPolygon(tg.LatLongs) < 0.0) {
                        ptTemp = tg.LatLongs.remove(0);
                        Collections.reverse(tg.LatLongs);
                        tg.LatLongs.add(0, ptTemp);
                    }
                    ArrayList<POINT2> pPointsArc = new ArrayList<POINT2>();
                    ArrayList<Object> pPoints2 = new ArrayList<POINT2>();
                    pPoints2.add(pt0);
                    pPoints2.add(mdlGeodesic.geodesic_coordinate(pt0, ((double[])length.value)[0], ((double[])attitude.value)[0]));
                    pPoints2.add(mdlGeodesic.geodesic_coordinate(pt0, ((double[])length.value)[0], ((double[])attitude.value)[1]));
                    mdlGeodesic.GetGeodesicArc2(pPoints2, pPointsArc);
                    for (i = 0; i < pPointsArc.size(); ++i) {
                        ptTemp = new POINT2(pPointsArc.get(i));
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        tg.Pixels.add(ptTemp);
                    }
                    for (i = 1; i < tg.LatLongs.size(); ++i) {
                        ptTemp = new POINT2(tg.LatLongs.get(i));
                        ptTemp = clsUtilityCPOF.PointLatLongToPixels(ptTemp, converter);
                        tg.Pixels.add(ptTemp);
                    }
                    tg.Pixels.add(tg.Pixels.get(0));
                    break;
                }
                default: {
                    return false;
                }
            }
            ArrayList farLeftPixels = new ArrayList();
            ArrayList farRightPixels = new ArrayList();
            clsUtilityCPOF.GetFarPixels(tg, converter, farLeftPixels, farRightPixels);
            ArrayList<Shape2> shapesLeft = new ArrayList<Shape2>();
            ArrayList<Shape2> shapesRight = new ArrayList<Shape2>();
            if (farLeftPixels.isEmpty() || farRightPixels.isEmpty()) {
                ArrayList<POINT2> tempPixels = new ArrayList<POINT2>();
                tempPixels.addAll(tg.Pixels);
                clsUtilityCPOF.postSegmentFSA(tg, converter);
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapes, false);
                tg.Pixels = tempPixels;
            } else {
                tg.Pixels = farLeftPixels;
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapesLeft, false);
                tg.Pixels = farRightPixels;
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapesRight, false);
                shapes.addAll(shapesLeft);
                shapes.addAll(shapesRight);
            }
            if (lineType == 15000002) {
                Shape2 shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                shape.moveTo(ptCenter);
                ptCenter.y += 1.0;
                shape.lineTo(ptCenter);
                shapes.add(shape);
            }
            if (lineType == 14000001 || lineType == 14000002) {
                double dist = ((double[])radius.value)[0];
                pt0 = new POINT2(tg.LatLongs.get(0));
                pt1 = mdlGeodesic.geodesic_coordinate(pt0, dist, 45.0);
                Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                pt02d = converter.GeoToPixels(pt02d);
                pt12d = converter.GeoToPixels(pt12d);
                pt0.x = pt02d.getX();
                pt0.y = pt02d.getY();
                pt1.x = pt12d.getX();
                pt1.y = pt12d.getY();
                dist = lineutility.CalcDistanceDouble(pt0, pt1);
                ArrayList<POINT2> tempPixels = new ArrayList<POINT2>();
                tempPixels.addAll(tg.Pixels);
                POINT2[] pts = tempPixels.toArray(new POINT2[tempPixels.size()]);
                pts[0].style = (int)dist;
                lineutility.getExteriorPoints(pts, pts.length, lineType, false);
                tg.Pixels.clear();
                for (j = 0; j < pts.length; ++j) {
                    tg.Pixels.add(new POINT2(pts[j].x, pts[j].y));
                }
                clsUtilityCPOF.Change1PixelsToShapes(tg, shapes, true);
                tg.Pixels = tempPixels;
            }
            return true;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "Change1TacticalAreas", new RendererException("Failed inside Change1TacticalAreas", exc));
            return false;
        }
    }

    private static void Change1PixelsToShapes(TGLight tg, ArrayList<Shape2> shapes, boolean fill) {
        Shape2 shape = null;
        boolean beginLine = true;
        POINT2 currentPt = null;
        POINT2 lastPt = null;
        int k = 0;
        int linetype = tg.get_LineType();
        int n = tg.Pixels.size();
        for (k = 0; k < n; ++k) {
            if (shape == null) {
                if (!fill) {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                } else if (fill) {
                    shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
                }
            }
            currentPt = tg.Pixels.get(k);
            if (k > 0) {
                lastPt = tg.Pixels.get(k - 1);
            }
            if (beginLine) {
                if (k == 0) {
                    shape.set_Style(currentPt.style);
                }
                if (k > 0 && currentPt.style == 5 && lastPt.style == 5) {
                    shape.lineTo(currentPt);
                }
                shape.moveTo(currentPt);
                beginLine = false;
            } else {
                shape.lineTo(currentPt);
                if (currentPt.style == 5 || currentPt.style == 10) {
                    beginLine = true;
                    if ((linetype == 243111001 || linetype == 16000002 || linetype == 16000006 || linetype == 16000005) && k < tg.Pixels.size() - 1) {
                        shapes.add(shape);
                        shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    }
                }
            }
            if (k != tg.Pixels.size() - 1) continue;
            if (shape.getShapeType() == ShapeInfo.SHAPE_TYPE_FILL) {
                shapes.add(0, shape);
                continue;
            }
            shapes.add(shape);
        }
    }

    private static void GetConcentricCircles(TGLight tg, int lineType, IPointConversion converter) {
        try {
            int j = 0;
            int l = 0;
            double radius = 0.0;
            POINT2 pt = new POINT2();
            ArrayList<Object> pts = new ArrayList();
            double[] radii = null;
            String strAM = tg.get_AM();
            if (tg.LatLongs.size() == 1 && strAM != null) {
                String[] strs = strAM.split(",");
                radii = new double[strs.length];
                for (j = 0; j < strs.length; ++j) {
                    radii[j] = Double.parseDouble(strs[j]);
                }
            }
            int n = radii.length;
            POINT2[] pPoints = null;
            for (l = 0; l < n; ++l) {
                radius = radii[l];
                if (radius == 0.0) continue;
                pPoints = new POINT2[3];
                pt = tg.LatLongs.get(0);
                pPoints[0] = new POINT2(pt);
                pt = mdlGeodesic.geodesic_coordinate(pt, radius, 90.0);
                pPoints[1] = new POINT2(pt);
                pPoints[2] = new POINT2(pt);
                pts = mdlGeodesic.GetGeodesicArc(pPoints);
                POINT2 ptTemp2 = null;
                int t = pts.size();
                for (j = 0; j < t; ++j) {
                    ptTemp2 = new POINT2();
                    ptTemp2 = clsUtilityCPOF.PointLatLongToPixels((POINT2)pts.get(j), converter);
                    ptTemp2.style = 0;
                    if (j == pts.size() - 1) {
                        ptTemp2.style = 5;
                    }
                    tg.Pixels.add(ptTemp2);
                }
            }
            int length = tg.Pixels.size();
            tg.Pixels.get((int)(length - 1)).style = 5;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetConcentricCircles", new RendererException("Failed inside GetConcentricCircles", exc));
        }
    }

    private static String GetMaxSector(TGLight tg) {
        String strLeftRightMinMax = null;
        try {
            double max = 0.0;
            double maxx = -1.7976931348623157E308;
            strLeftRightMinMax = tg.get_LRMM();
            String[] leftRightMinMax = strLeftRightMinMax.split(",");
            int numSectors = leftRightMinMax.length / 4;
            int k = 0;
            int maxIndex = -1;
            if (numSectors < 1) {
                return null;
            }
            if (numSectors * 4 != leftRightMinMax.length) {
                return null;
            }
            try {
                for (k = 0; k < numSectors; ++k) {
                    max = Double.parseDouble(leftRightMinMax[4 * k + 3]);
                    if (!(max > maxx)) continue;
                    maxx = max;
                    maxIndex = k;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            String strLeft = leftRightMinMax[4 * maxIndex];
            String strRight = leftRightMinMax[4 * maxIndex + 1];
            String strMin = leftRightMinMax[4 * maxIndex + 2];
            String strMax = leftRightMinMax[4 * maxIndex + 3];
            strLeftRightMinMax = strLeft + "," + strRight + "," + strMin + "," + strMax;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetMaxSector", new RendererException("Failed inside GetMaxSector", exc));
        }
        return strLeftRightMinMax;
    }

    protected static TGLight GetCircularRangeFanFillTG(TGLight tg) {
        TGLight tg1 = null;
        try {
            tg1 = new TGLight();
            tg1.set_VisibleModifiers(true);
            tg1.set_LineThickness(0);
            tg1.set_FillColor(tg.get_FillColor());
            tg1.set_Fillstyle(tg.get_FillStyle());
            tg1.LatLongs = new ArrayList();
            tg1.Pixels = new ArrayList();
            tg1.LatLongs.add(tg.LatLongs.get(0));
            tg1.Pixels.add(tg.Pixels.get(0));
            tg1.Pixels.add(tg.Pixels.get(1));
            tg1.set_LineType(243111001);
            if (tg.get_LineType() == 243112000 || tg.get_LineType() == 25200700) {
                tg1.set_LRMM(tg.get_LRMM());
                return tg1;
            }
            if (tg.get_LineType() == 243111000) {
                String[] radii = tg.get_AM().split(",");
                String strLeftRightMinMax = "";
                for (int j = 0; j < radii.length - 1; ++j) {
                    if (j > 0) {
                        strLeftRightMinMax = strLeftRightMinMax + ",";
                    }
                    strLeftRightMinMax = strLeftRightMinMax + "0,0," + radii[j] + "," + radii[j + 1];
                }
                tg1.set_LRMM(strLeftRightMinMax);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetCircularRangeFanFillTG", new RendererException("Failed inside GetCircularRangeFanFillTG", exc));
        }
        return tg1;
    }

    private static boolean GetSectorRangeFan(TGLight tg, IPointConversion converter) {
        boolean circle = false;
        try {
            POINT2 ptCenter = tg.LatLongs.get(0);
            int k = 0;
            int l = 0;
            int numSectors = 0;
            armyc2.c5isr.JavaTacticalRenderer.clsUtility.GetSectorRadiiFromPoints(tg);
            ArrayList<POINT2> pPoints = new ArrayList<POINT2>();
            ArrayList<POINT2> pPointsInnerArc = new ArrayList<POINT2>();
            ArrayList<POINT2> pPointsOuterArc = new ArrayList<POINT2>();
            ArrayList<POINT2> sectorPoints = new ArrayList<POINT2>();
            ArrayList<POINT2> allPoints = new ArrayList<POINT2>();
            POINT2 pt1 = new POINT2();
            POINT2 pt2 = new POINT2();
            String strLeftRightMinMax = tg.get_LRMM();
            String[] leftRightMinMax = strLeftRightMinMax.split(",");
            double left = 0.0;
            double right = 0.0;
            double min = 0.0;
            double max = 0.0;
            numSectors = leftRightMinMax.length / 4;
            if (numSectors < 1) {
                return false;
            }
            if (numSectors * 4 != leftRightMinMax.length) {
                return false;
            }
            try {
                for (k = 0; k < numSectors; ++k) {
                    left = Double.parseDouble(leftRightMinMax[4 * k]);
                    right = Double.parseDouble(leftRightMinMax[4 * k + 1]);
                    min = Double.parseDouble(leftRightMinMax[4 * k + 2]);
                    max = Double.parseDouble(leftRightMinMax[4 * k + 3]);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            for (k = 0; k < numSectors; ++k) {
                sectorPoints.clear();
                pPointsOuterArc.clear();
                pPointsInnerArc.clear();
                left = Double.parseDouble(leftRightMinMax[4 * k]);
                right = Double.parseDouble(leftRightMinMax[4 * k + 1]);
                min = Double.parseDouble(leftRightMinMax[4 * k + 2]);
                max = Double.parseDouble(leftRightMinMax[4 * k + 3]);
                pt1 = mdlGeodesic.geodesic_coordinate(ptCenter, min, left);
                pt2 = mdlGeodesic.geodesic_coordinate(ptCenter, min, right);
                pPoints.clear();
                pPoints.add(ptCenter);
                pPoints.add(pt1);
                pPoints.add(pt2);
                circle = mdlGeodesic.GetGeodesicArc2(pPoints, pPointsInnerArc);
                pPoints.clear();
                circle = false;
                pt1 = mdlGeodesic.geodesic_coordinate(ptCenter, max, left);
                pt2 = mdlGeodesic.geodesic_coordinate(ptCenter, max, right);
                pPoints.add(ptCenter);
                pPoints.add(pt1);
                pPoints.add(pt2);
                circle = mdlGeodesic.GetGeodesicArc2(pPoints, pPointsOuterArc);
                int n = pPointsInnerArc.size();
                for (l = 0; l < n; ++l) {
                    pt1 = new POINT2(pPointsInnerArc.get(l));
                    sectorPoints.add(pt1);
                }
                n = pPointsOuterArc.size();
                for (l = n - 1; l >= 0; --l) {
                    pt1 = new POINT2(pPointsOuterArc.get(l));
                    sectorPoints.add(pt1);
                }
                pt1 = new POINT2(pPointsInnerArc.get(0));
                pt1.style = 5;
                sectorPoints.add(pt1);
                n = sectorPoints.size();
                for (l = 0; l < n; ++l) {
                    allPoints.add((POINT2)sectorPoints.get(l));
                }
            }
            pPointsInnerArc = null;
            pPointsOuterArc = null;
            ptCenter = null;
            POINT2 ptTemp = null;
            int n = allPoints.size();
            for (l = 0; l < n; ++l) {
                pt1 = new POINT2();
                pt1 = clsUtilityCPOF.PointLatLongToPixels((POINT2)allPoints.get(l), converter);
                if (ptTemp != null && pt1.x == ptTemp.x && pt1.y == ptTemp.y) continue;
                tg.Pixels.add(new POINT2(pt1));
                ptTemp = new POINT2(pt1);
            }
            return true;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "GetSectorRangeFan", new RendererException("Failed inside GetSectorRangeFan", exc));
            return circle;
        }
    }

    private static void RangeFanOrientation(TGLight tg, int lineType, IPointConversion converter) {
        try {
            POINT2 pt0 = tg.LatLongs.get(0);
            double dist = 0.0;
            double orientation = 0.0;
            double radius = 0.0;
            boolean j = false;
            POINT2 pt1 = new POINT2();
            ref<double[]> a12 = new ref<double[]>();
            ref<double[]> a21 = new ref<double[]>();
            if (tg.LatLongs.size() > 1) {
                pt1 = tg.LatLongs.get(1);
                dist = mdlGeodesic.geodesic_distance(pt0, pt1, a12, a21);
                orientation = ((double[])a12.value)[0];
            } else {
                double left;
                String strLeftRightMinMax = clsUtilityCPOF.GetMaxSector(tg);
                String[] sector = strLeftRightMinMax.split(",");
                double right = Double.parseDouble(sector[1]);
                double min = Double.parseDouble(sector[2]);
                double max = Double.parseDouble(sector[3]);
                for (left = Double.parseDouble(sector[0]); left > 360.0; left -= 360.0) {
                }
                while (right > 360.0) {
                    right -= 360.0;
                }
                while (left < 0.0) {
                    left += 360.0;
                }
                while (right < 0.0) {
                    right += 360.0;
                }
                orientation = left > right ? (left - 360.0 + right) / 2.0 : (left + right) / 2.0;
                dist = max;
            }
            radius = dist * 1.1;
            POINT2 pt0F = new POINT2();
            POINT2 pt1F = new POINT2();
            POINT2 ptBaseF = new POINT2();
            POINT2 ptLeftF = new POINT2();
            POINT2 ptRightF = new POINT2();
            POINT2 ptTipF = new POINT2();
            pt0 = tg.LatLongs.get(0);
            pt0F = clsUtilityCPOF.PointLatLongToPixels(pt0, converter);
            pt1 = mdlGeodesic.geodesic_coordinate(pt0, radius, orientation);
            pt1F = clsUtilityCPOF.PointLatLongToPixels(pt1, converter);
            dist = lineutility.CalcDistanceDouble(pt0F, pt1F);
            double base = 10.0;
            if (dist < 100.0) {
                base = dist / 10.0;
            }
            if (base < 5.0) {
                base = 5.0;
            }
            double basex2 = 2.0 * base;
            ptBaseF = lineutility.ExtendAlongLineDouble(pt0F, pt1F, dist + base);
            ptTipF = lineutility.ExtendAlongLineDouble(pt0F, pt1F, dist + basex2);
            ptLeftF = lineutility.ExtendDirectedLine(pt0F, ptBaseF, ptBaseF, 0, base);
            ptRightF = lineutility.ExtendDirectedLine(pt0F, ptBaseF, ptBaseF, 1, base);
            tg.Pixels.add(pt0F);
            ptTipF.style = 5;
            tg.Pixels.add(ptTipF);
            tg.Pixels.add(ptLeftF);
            ptTipF.style = 0;
            tg.Pixels.add(ptTipF);
            tg.Pixels.add(ptRightF);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "RangeFanOrientation", new RendererException("Failed inside RangeFanOrientation", exc));
        }
    }

    protected static void ClearPixelsStyle(TGLight tg) {
        try {
            switch (tg.get_LineType()) {
                case 13000000: 
                case 15000000: 
                case 15000001: 
                case 15000003: 
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    return;
                }
            }
            int n = tg.Pixels.size();
            for (int j = 0; j < n; ++j) {
                tg.Pixels.get((int)j).style = 0;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "ClearPixelsStyle", new RendererException("Failed inside ClearPixelsStyle", exc));
        }
    }

    protected static void FilterPoints2(TGLight tg, IPointConversion converter) {
        try {
            int lineType = tg.get_LineType();
            double minSpikeDistance = 0.0;
            boolean segmented = true;
            if (tg.Pixels.size() < 3) {
                return;
            }
            switch (lineType) {
                case 110300: 
                case 2514190: 
                case 22124000: 
                case 22125000: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22623000: 
                case 22623001: 
                case 24230000: 
                case 25140400: 
                case 25141800: {
                    minSpikeDistance = arraysupport.getScaledSize(5.0, tg.get_LineThickness(), tg.get_patternScale());
                    segmented = false;
                    break;
                }
                case 22122000: 
                case 22134000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23330000: 
                case 23350000: 
                case 1322134000: {
                    minSpikeDistance = arraysupport.getScaledSize(25.0, tg.get_LineThickness(), tg.get_patternScale());
                    break;
                }
                case 22123000: 
                case 22624000: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23134000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: {
                    minSpikeDistance = arraysupport.getScaledSize(35.0, tg.get_LineThickness(), tg.get_patternScale());
                    break;
                }
                case 32156000: 
                case 32162000: 
                case 32164000: {
                    minSpikeDistance = arraysupport.getScaledSize(35.0, tg.get_LineThickness(), tg.get_patternScale());
                    break;
                }
                default: {
                    return;
                }
            }
            double dist = 0.0;
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            int j = 0;
            POINT2 pt = null;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            int n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                pt = tg.Pixels.get(j);
                pt.style = tg.Pixels.get((int)j).style;
                pts.add(pt);
            }
            boolean removedPt = true;
            block9: while (removedPt) {
                removedPt = false;
                for (j = 0; j < pts.size() - 1; ++j) {
                    pt0 = pts.get(j);
                    pt1 = pts.get(j + 1);
                    dist = lineutility.CalcDistanceDouble(pts.get(j), pts.get(j + 1));
                    if (!(dist < minSpikeDistance)) continue;
                    if (!segmented) {
                        if (j + 1 == pts.size() - 1) {
                            pts.remove(j);
                        } else {
                            pts.remove(j + 1);
                        }
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == 0 && pt1.style == -1) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == 0 && pt1.style == -2) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -1 && pt1.style == 0) {
                        pts.remove(j);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -1 && pt1.style == -1) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -1 && pt1.style == -2) {
                        pts.remove(j + 1);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -2 && pt1.style == 0) {
                        pts.remove(j);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style == -2 && pt1.style == -1) {
                        pts.remove(j);
                        removedPt = true;
                        break block9;
                    }
                    if (pt0.style != -2 || pt1.style != -2) continue;
                    pts.remove(j + 1);
                    removedPt = true;
                    break block9;
                }
            }
            tg.Pixels = pts;
            tg.LatLongs = clsUtility.PixelsToLatLong(pts, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "FilterPoints2", new RendererException("Failed inside FilterPoints2", exc));
        }
    }

    public static Boolean canClipPoints(TGLight tg) {
        try {
            String symbolId = tg.get_SymbolId();
            if (clsMETOC.IsWeather(symbolId) > 0) {
                return true;
            }
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 110300: 
                case 150501: 
                case 150502: 
                case 150503: 
                case 270801: 
                case 271900: 
                case 272101: 
                case 2514190: 
                case 2517200: 
                case 10000000: 
                case 11000000: 
                case 11120500: 
                case 11120600: 
                case 13120500: 
                case 13120600: 
                case 22122000: 
                case 22123000: 
                case 22124000: 
                case 22125000: 
                case 22131000: 
                case 22132000: 
                case 22133000: 
                case 22134000: 
                case 22135000: 
                case 22136000: 
                case 22137000: 
                case 22138000: 
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 22235000: 
                case 22431000: 
                case 22431100: 
                case 22522100: 
                case 22522210: 
                case 22522220: 
                case 22523000: 
                case 22525000: 
                case 22526000: 
                case 22527000: 
                case 22528000: 
                case 22531000: 
                case 22532000: 
                case 22535000: 
                case 22536000: 
                case 22612000: 
                case 22612001: 
                case 22613000: 
                case 22621000: 
                case 22622000: 
                case 22623000: 
                case 22623001: 
                case 22624000: 
                case 22625000: 
                case 22626000: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23120000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23134000: 
                case 23162000: 
                case 23164000: 
                case 23180000: 
                case 23200000: 
                case 23330000: 
                case 23350000: 
                case 23440000: 
                case 23450000: 
                case 23460000: 
                case 23490000: 
                case 24210000: 
                case 24211000: 
                case 24220000: 
                case 24225000: 
                case 24226000: 
                case 24230000: 
                case 24240000: 
                case 24250000: 
                case 24260000: 
                case 24313000: 
                case 24314000: 
                case 24315000: 
                case 24321100: 
                case 24322100: 
                case 24323100: 
                case 24324100: 
                case 24325100: 
                case 24330000: 
                case 24331100: 
                case 24332100: 
                case 24333100: 
                case 24334100: 
                case 24335100: 
                case 24336100: 
                case 24337100: 
                case 24338100: 
                case 24339100: 
                case 24351000: 
                case 24361000: 
                case 25110400: 
                case 25120700: 
                case 25140400: 
                case 25141800: 
                case 25171100: 
                case 25171200: 
                case 25171300: 
                case 25171400: 
                case 25171500: 
                case 25190100: 
                case 25190200: 
                case 25242800: 
                case 25260400: 
                case 25300100: 
                case 25310000: 
                case 25310800: 
                case 25320000: 
                case 25330000: 
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330501: 
                case 25330502: 
                case 25340000: 
                case 25343800: 
                case 25351000: 
                case 25352000: 
                case 25353000: 
                case 221310000: 
                case 221311000: 
                case 231100000: 
                case 231111000: 
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: 
                case 231117100: 
                case 231117200: 
                case 231117300: 
                case 243100000: 
                case 1322134000: 
                case 1325260400: 
                case 1325310000: {
                    return true;
                }
                case 22121000: 
                case 25221000: 
                case 25222000: 
                case 25330500: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "canClipPoints", new RendererException("Failed inside canClipPoints", exc));
            return false;
        }
    }

    protected static boolean LinesWithSeparateFill(int linetype, ArrayList<Shape2> shapes) {
        if (shapes == null) {
            return false;
        }
        switch (linetype) {
            case 23410000: {
                return true;
            }
            case 110300: 
            case 2514190: 
            case 22121000: 
            case 22122000: 
            case 22123000: 
            case 22124000: 
            case 22125000: 
            case 22134000: 
            case 22221000: 
            case 22222000: 
            case 22223000: 
            case 22224000: 
            case 22225000: 
            case 22522100: 
            case 22522210: 
            case 22522220: 
            case 22523000: 
            case 22525000: 
            case 22526000: 
            case 22527000: 
            case 22528000: 
            case 22612000: 
            case 22612001: 
            case 22613000: 
            case 22623000: 
            case 22623001: 
            case 22624000: 
            case 23112000: 
            case 23113000: 
            case 23114000: 
            case 23115000: 
            case 23120000: 
            case 23131100: 
            case 23131200: 
            case 23132000: 
            case 23134000: 
            case 23172000: 
            case 23330000: 
            case 23350000: 
            case 24210000: 
            case 24211000: 
            case 24220000: 
            case 24225000: 
            case 24230000: 
            case 24240000: 
            case 24250000: 
            case 25110400: 
            case 25140400: 
            case 25141800: 
            case 25170400: 
            case 25170600: 
            case 25190100: 
            case 25190200: 
            case 25221000: 
            case 25222000: 
            case 25260400: 
            case 25300100: 
            case 25330301: 
            case 25330302: 
            case 25330303: 
            case 25330401: 
            case 25330402: 
            case 25330403: 
            case 25330500: 
            case 25330501: 
            case 25330502: 
            case 25343800: 
            case 211100000: 
            case 231100000: 
            case 231111000: 
            case 231112000: 
            case 231113000: 
            case 231114000: 
            case 231115000: 
            case 231116000: 
            case 231117100: 
            case 231117200: 
            case 231117300: 
            case 1322134000: 
            case 1325260400: {
                Shape2 shape = null;
                if (shapes != null && shapes.size() > 0) {
                    int n = shapes.size();
                    for (int j = 0; j < n; ++j) {
                        shape = shapes.get(j);
                        if (shape.getShapeType() != Shape2.SHAPE_TYPE_POLYLINE) continue;
                        shapes.get(j).setFillColor(null);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected static ArrayList<POINT2> Point2DtoPOINT2Mapped(ArrayList<Point2D> pts2d, Map<String, Object> hashMap) {
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        try {
            int style = 0;
            int n = pts2d.size();
            for (int j = 0; j < n; ++j) {
                Point2D pt2d = pts2d.get(j);
                style = hashMap.containsValue(pt2d) ? 0 : -1;
                pts.add(new POINT2(pts2d.get(j).getX(), pts2d.get(j).getY(), style));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "Point2DToPOINT2Mapped", new RendererException("Failed inside Point2DToPOINT2Mapped", exc));
        }
        return pts;
    }

    protected static ArrayList<POINT2> Point2DtoPOINT2(ArrayList<Point2D> pts2d) {
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        try {
            int n = pts2d.size();
            for (int j = 0; j < n; ++j) {
                pts.add(new POINT2(pts2d.get(j).getX(), pts2d.get(j).getY()));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "Point2DToPOINT2", new RendererException("Failed inside Point2DToPOINT2", exc));
        }
        return pts;
    }

    protected static ArrayList<Point2D> POINT2toPoint2D(ArrayList<POINT2> pts) {
        ArrayList<Point2D> pts2d = new ArrayList<Point2D>();
        try {
            int n = pts.size();
            for (int j = 0; j < n; ++j) {
                pts2d.add(new Point2D.Double(pts.get((int)j).x, pts.get((int)j).y));
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "POINT2toPoint2D", new RendererException("Failed inside POINT2toPoint2D", exc));
        }
        return pts2d;
    }

    private static Shape BuildShapeFromPoints(ArrayList<Point2D> pts2d) {
        GeneralPath shape = new GeneralPath();
        try {
            shape.moveTo(pts2d.get(0).getX(), pts2d.get(0).getY());
            int n = pts2d.size();
            for (int j = 1; j < n; ++j) {
                shape.lineTo(pts2d.get(j).getX(), pts2d.get(j).getY());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "buildShapeFromPoints", new RendererException("Failed inside buildShapeFromPoints", exc));
        }
        return shape;
    }

    protected static ArrayList<Shape2> buildShapeSpecFromPoints(TGLight tg0, Shape2 shapeSpec, ArrayList<POINT2> pts, Object clipArea) {
        ArrayList<Shape2> shapeSpecs2 = null;
        try {
            shapeSpecs2 = new ArrayList<Shape2>();
            int j = 0;
            int n = 0;
            Rectangle rect = shapeSpec.getBounds();
            int h = shapeSpec.getBounds().height;
            int w = shapeSpec.getBounds().width;
            int x = shapeSpec.getBounds().x;
            int y = shapeSpec.getBounds().y;
            if (h == 0) {
                h = 1;
            }
            if (w == 0) {
                w = 1;
            }
            Rectangle2D clipBounds = null;
            ArrayList clipPoints = null;
            if (clipArea != null && clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipBounds = (Rectangle2D)clipArea;
            } else if (clipArea != null && clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                Rectangle rectx = (Rectangle)clipArea;
                clipBounds = new Rectangle2D.Double(rectx.x, rectx.y, rectx.width, rectx.height);
            } else if (clipArea != null && clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                clipPoints = (ArrayList)clipArea;
            }
            if (clipBounds != null && !clipBounds.contains(shapeSpec.getShape().getBounds2D()) && !clipBounds.intersects(shapeSpec.getShape().getBounds2D())) {
                if (!clipBounds.contains(x, y, w, h) && !clipBounds.intersects(x, y, w, h)) {
                    return shapeSpecs2;
                }
            } else if (clipPoints != null) {
                GeneralPath poly = new GeneralPath();
                n = clipPoints.size();
                for (j = 0; j < n; ++j) {
                    if (j == 0) {
                        poly.moveTo(((Point2D)clipPoints.get(j)).getX(), ((Point2D)clipPoints.get(j)).getY());
                        continue;
                    }
                    poly.lineTo(((Point2D)clipPoints.get(j)).getX(), ((Point2D)clipPoints.get(j)).getY());
                }
                poly.closePath();
                if (!(poly.contains(shapeSpec.getShape().getBounds2D()) || poly.intersects(shapeSpec.getShape().getBounds2D()) || poly.contains(x, y, w, h) || poly.intersects(x, y, w, h))) {
                    return shapeSpecs2;
                }
            }
            if (shapeSpec.getShapeType() == Shape2.SHAPE_TYPE_MODIFIER || shapeSpec.getShapeType() == Shape2.SHAPE_TYPE_MODIFIER_FILL) {
                shapeSpecs2.add(shapeSpec);
                return shapeSpecs2;
            }
            TGLight tg = new TGLight();
            POINT2 pt = null;
            tg.set_LineType(22124000);
            ArrayList<POINT2> pts2 = new ArrayList<POINT2>();
            ArrayList<Point2D> pts2d = null;
            Shape shape = null;
            GeneralPath gp = new GeneralPath();
            n = pts.size();
            block7: for (j = 0; j < n; ++j) {
                pt = pts.get(j);
                switch (pt.style) {
                    case 0: {
                        if (pts2.size() > 1) {
                            tg = new TGLight();
                            tg.set_LineType(22124000);
                            tg.Pixels = pts2;
                            if (clipBounds != null) {
                                pts2d = clsClipPolygon2.ClipPolygon(tg, clipBounds);
                            } else if (clipPoints != null && !clipPoints.isEmpty()) {
                                pts2d = clsClipQuad.ClipPolygon(tg, clipPoints);
                            }
                            if (pts2d != null && pts2d.size() > 1) {
                                shape = clsUtilityCPOF.BuildShapeFromPoints(pts2d);
                                gp.append(shape, false);
                            }
                            pts2.clear();
                            pts2.add(pt);
                            continue block7;
                        }
                        pts2.add(pt);
                        continue block7;
                    }
                    case 1: {
                        pts2.add(pt);
                        continue block7;
                    }
                    default: {
                        pts2.add(pt);
                    }
                }
            }
            if (pts2.size() > 1) {
                tg = new TGLight();
                tg.set_LineType(22124000);
                tg.Pixels = pts2;
                if (clipBounds != null) {
                    pts2d = clsClipPolygon2.ClipPolygon(tg, clipBounds);
                } else if (clipPoints != null) {
                    pts2d = clsClipQuad.ClipPolygon(tg, clipPoints);
                }
                if (pts2d != null && pts2d.size() > 1) {
                    shape = clsUtilityCPOF.BuildShapeFromPoints(pts2d);
                    gp.append(shape, false);
                }
                tg0.set_WasClipped(tg.get_WasClipped());
            }
            Shape2 shapeSpec2 = new Shape2(shapeSpec.getShapeType());
            shapeSpec2.setLineColor(shapeSpec.getLineColor());
            shapeSpec2.setFillColor(shapeSpec.getFillColor());
            shapeSpec2.setStroke(shapeSpec.getStroke());
            shapeSpec2.setTexturePaint(shapeSpec.getTexturePaint());
            shapeSpec2.setShape(gp);
            shapeSpecs2.add(shapeSpec2);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "buildShapeSpecFromPoints", new RendererException("Failed inside buildShapeSpecFromPoints", exc));
        }
        return shapeSpecs2;
    }

    protected static ArrayList<Shape2> postClipShapes(TGLight tg, ArrayList<Shape2> shapeSpecsArray, Object clipArea) {
        ArrayList<Shape2> shapeSpecs2 = null;
        ArrayList<Shape2> tempShapes = null;
        try {
            if (shapeSpecsArray == null || shapeSpecsArray.size() == 0) {
                return null;
            }
            shapeSpecs2 = new ArrayList<Shape2>();
            int j = 0;
            ArrayList<Shape2> shapeSpecs = new ArrayList<Shape2>();
            int n = shapeSpecsArray.size();
            for (j = 0; j < n; ++j) {
                shapeSpecs.add(shapeSpecsArray.get(j));
            }
            ArrayList<POINT2> pts = new ArrayList<POINT2>();
            Shape shape = null;
            double[] coords = new double[6];
            Shape2 shapeSpec = null;
            n = shapeSpecs.size();
            for (j = 0; j < n; ++j) {
                shapeSpec = (Shape2)shapeSpecs.get(j);
                shape = shapeSpec.getShape();
                pts.clear();
                PathIterator i = shape.getPathIterator(null);
                while (!i.isDone()) {
                    int type = i.currentSegment(coords);
                    switch (type) {
                        case 0: {
                            POINT2 pt = new POINT2(coords[0], coords[1]);
                            pt.style = 0;
                            pts.add(pt);
                            break;
                        }
                        case 1: {
                            POINT2 pt = new POINT2(coords[0], coords[1]);
                            pt.style = 1;
                            pts.add(pt);
                            break;
                        }
                        case 2: {
                            POINT2 pt = new POINT2(coords[0], coords[1]);
                            pt.style = 2;
                            pts.add(pt);
                            pt = new POINT2(coords[2], coords[3]);
                            pt.style = 2;
                            pts.add(pt);
                            break;
                        }
                        case 3: {
                            POINT2 pt = new POINT2(coords[0], coords[1]);
                            pt.style = 3;
                            pts.add(pt);
                            pt = new POINT2(coords[2], coords[3]);
                            pt.style = 3;
                            pts.add(pt);
                            pt = new POINT2(coords[4], coords[5]);
                            pt.style = 3;
                            pts.add(pt);
                            break;
                        }
                        case 4: {
                            POINT2 pt = new POINT2(coords[0], coords[1]);
                            pt.style = 4;
                            pts.add(pt);
                            break;
                        }
                        default: {
                            POINT2 pt = null;
                        }
                    }
                    i.next();
                }
                tempShapes = clsUtilityCPOF.buildShapeSpecFromPoints(tg, shapeSpec, pts, clipArea);
                shapeSpecs2.addAll(tempShapes);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "postClipShapes", new RendererException("Failed inside postClipShapes", exc));
        }
        return shapeSpecs2;
    }

    private static boolean segmentAnticipatedLine(TGLight tg) {
        try {
            int linetype = tg.get_LineType();
            if (armyc2.c5isr.JavaTacticalRenderer.clsUtility.IsChange1Area(linetype)) {
                return false;
            }
            if (armyc2.c5isr.JavaTacticalRenderer.clsUtility.isAutoshape(tg)) {
                return false;
            }
            if (SymbolUtilities.isBasicShape(linetype)) {
                return false;
            }
            switch (linetype) {
                case 21700000: 
                case 21710000: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23200000: 
                case 25152700: 
                case 25152900: 
                case 25342900: {
                    return false;
                }
                case 25330301: 
                case 25330302: 
                case 25330303: 
                case 25330401: 
                case 25330402: 
                case 25330403: 
                case 25330501: 
                case 25330502: {
                    return false;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "segmentGenericLine", new RendererException("Failed inside segmentGenericLine", exc));
        }
        return true;
    }

    protected static void postSegmentFSA(TGLight tg, IPointConversion converter) {
        try {
            if (tg.get_Client().equals("2D")) {
                return;
            }
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 24321200: 
                case 24322200: 
                case 24323200: 
                case 24324200: 
                case 24325200: 
                case 24326100: 
                case 24331200: 
                case 24332200: 
                case 24333200: 
                case 24334200: 
                case 24335200: 
                case 24336200: 
                case 24337200: 
                case 24338200: 
                case 24339200: 
                case 24352000: 
                case 24362000: 
                case 25200202: 
                case 25200402: {
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList<POINT2> latLongs = new ArrayList<POINT2>();
            ArrayList<POINT2> resultPts = new ArrayList<POINT2>();
            int j = 0;
            int k = 0;
            int n = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt = null;
            double dist = 0.0;
            double interval = 250000.0;
            double az = 0.0;
            double maxDist = 0.0;
            Point2D pt2d = null;
            int t = tg.Pixels.size();
            for (j = 0; j < t; ++j) {
                pt0 = tg.Pixels.get(j);
                pt2d = new Point2D.Double(pt0.x, pt0.y);
                pt2d = converter.PixelsToGeo(pt2d);
                pt0 = new POINT2(pt2d.getX(), pt2d.getY());
                latLongs.add(pt0);
            }
            t = latLongs.size();
            for (j = 0; j < t - 1; ++j) {
                pt0 = (POINT2)latLongs.get(j);
                pt1 = (POINT2)latLongs.get(j + 1);
                pt1.style = -1;
                az = mdlGeodesic.GetAzimuth(pt0, pt1);
                dist = mdlGeodesic.geodesic_distance(latLongs.get(j), latLongs.get(j + 1), null, null);
                if (!(dist > maxDist)) continue;
                maxDist = dist;
            }
            if (interval > maxDist) {
                interval = maxDist;
            }
            for (j = 0; j < t - 1; ++j) {
                pt0 = new POINT2((POINT2)latLongs.get(j));
                pt0.style = 0;
                pt1 = new POINT2(latLongs.get(j + 1));
                pt1.style = 0;
                az = mdlGeodesic.GetAzimuth(pt0, pt1);
                dist = mdlGeodesic.geodesic_distance(latLongs.get(j), latLongs.get(j + 1), null, null);
                n = (int)(dist / interval);
                if (j == 0) {
                    resultPts.add(pt0);
                }
                for (k = 1; k <= n; ++k) {
                    pt = mdlGeodesic.geodesic_coordinate(pt0, interval * (double)k, az);
                    pt.style = -2;
                    dist = mdlGeodesic.geodesic_distance(pt, pt1, null, null);
                    if (!(dist >= interval / 2.0)) continue;
                    resultPts.add(pt);
                }
                resultPts.add(pt1);
            }
            latLongs = resultPts;
            tg.Pixels = clsUtility.LatLongToPixels(latLongs, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "postSegmentFSA", new RendererException("Failed inside postSegmentFSA", exc));
        }
    }

    private static ArrayList<POINT2> toGeodesic(TGLight tg, double interval, HashMap<Integer, String> hmap) {
        ArrayList<POINT2> locs = new ArrayList<POINT2>();
        try {
            int i = 0;
            int k = 0;
            int n = 0;
            ArrayList<POINT2> points = tg.LatLongs;
            String H = "";
            String color = "";
            boolean bolIsAC = false;
            int acWidth = 0;
            int linetype = tg.get_LineType();
            switch (linetype) {
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    bolIsAC = true;
                    break;
                }
            }
            block5: for (i = 0; i < points.size() - 1; ++i) {
                if (bolIsAC) {
                    acWidth = points.get((int)i).style;
                }
                double lat1 = Math.toRadians(points.get((int)i).y);
                double lon1 = Math.toRadians(points.get((int)i).x);
                double lat2 = Math.toRadians(points.get((int)(i + 1)).y);
                double lon2 = Math.toRadians(points.get((int)(i + 1)).x);
                double d = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
                double dist = mdlGeodesic.geodesic_distance(points.get(i), points.get(i + 1), null, null);
                float flt = (float)dist / (float)interval;
                n = Math.round(flt);
                if (n < 1) {
                    n = 1;
                }
                if (n > 32) {
                    n = 32;
                }
                for (k = 0; k <= n; ++k) {
                    if (k == 0) {
                        locs.add(new POINT2(points.get(i)));
                        if (hmap == null || !hmap.containsKey(i)) continue;
                        if (!H.isEmpty()) {
                            H = H + ",";
                        }
                        color = hmap.get(i);
                        H = H + Integer.toString(locs.size() - 1) + ":" + color;
                        continue;
                    }
                    if (k == n) {
                        if (i != points.size() - 2) continue block5;
                        locs.add(new POINT2(points.get(i + 1)));
                        if (hmap == null || !hmap.containsKey(i + 1)) continue block5;
                        if (!H.isEmpty()) {
                            H = H + ",";
                        }
                        color = hmap.get(i + 1);
                        H = H + Integer.toString(locs.size() - 1) + ":" + color;
                        continue block5;
                    }
                    double f = (double)k / (double)n;
                    double A = Math.sin((1.0 - f) * d) / Math.sin(d);
                    double B = Math.sin(f * d) / Math.sin(d);
                    double x = A * Math.cos(lat1) * Math.cos(lon1) + B * Math.cos(lat2) * Math.cos(lon2);
                    double y = A * Math.cos(lat1) * Math.sin(lon1) + B * Math.cos(lat2) * Math.sin(lon2);
                    double z = A * Math.sin(lat1) + B * Math.sin(lat2);
                    double lat = Math.atan2(z, Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
                    double lon = Math.atan2(y, x);
                    POINT2 pt = new POINT2(lon *= 57.29577951308232, lat *= 57.29577951308232);
                    if (bolIsAC) {
                        pt.style = -acWidth;
                    }
                    locs.add(pt);
                    if (hmap == null || !hmap.containsKey(i)) continue;
                    if (!H.isEmpty()) {
                        H = H + ",";
                    }
                    color = hmap.get(i);
                    H = H + Integer.toString(locs.size() - 1) + ":" + color;
                }
            }
            if (!H.isEmpty()) {
                tg.set_H(H);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "toGeodesic", new RendererException("Failed inside toGeodesic", exc));
            return null;
        }
        return locs;
    }

    protected static void SegmentGeoPoints(TGLight tg, IPointConversion converter, double zoomFactor) {
        try {
            if (tg.get_Client().equals("2D")) {
                return;
            }
            ArrayList<Object> resultPts = new ArrayList();
            int lineType = tg.get_LineType();
            double interval = 250000.0;
            boolean bolSegmentAC = false;
            boolean bolIsAC = false;
            bolSegmentAC = true;
            switch (lineType) {
                case 22221000: 
                case 22222000: 
                case 22223000: 
                case 22224000: 
                case 22225000: 
                case 25170400: 
                case 25170600: {
                    if (!bolSegmentAC) {
                        return;
                    }
                    bolIsAC = true;
                    break;
                }
                case 22122000: 
                case 22134000: 
                case 22522100: 
                case 22528000: 
                case 22624000: 
                case 23112000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23131100: 
                case 23131200: 
                case 23132000: 
                case 23134000: 
                case 23330000: 
                case 23350000: 
                case 24220000: 
                case 231111000: 
                case 231117100: 
                case 231117200: 
                case 231117300: 
                case 1322134000: {
                    break;
                }
                case 231112000: 
                case 231113000: 
                case 231114000: 
                case 231115000: 
                case 231116000: {
                    interval = 500000.0;
                    break;
                }
                case 22123000: {
                    interval = 2000000.0;
                    break;
                }
                default: {
                    if (clsUtilityCPOF.segmentAnticipatedLine(tg)) break;
                    return;
                }
            }
            int j = 0;
            int k = 0;
            int n = 0;
            POINT2 pt0 = null;
            POINT2 pt1 = null;
            POINT2 pt = null;
            double dist = 0.0;
            double az = 0.0;
            double maxDist = 0.0;
            int t = tg.LatLongs.size();
            for (j = 0; j < t - 1; ++j) {
                pt0 = tg.LatLongs.get(j);
                pt1 = tg.LatLongs.get(j + 1);
                if (!bolIsAC) {
                    pt1.style = -1;
                }
                az = mdlGeodesic.GetAzimuth(pt0, pt1);
                dist = mdlGeodesic.geodesic_distance(tg.LatLongs.get(j), tg.LatLongs.get(j + 1), null, null);
                if (!(dist > maxDist)) continue;
                maxDist = dist;
            }
            if (interval > maxDist) {
                interval = maxDist;
            }
            if (zoomFactor > 0.0 && zoomFactor < 0.01) {
                zoomFactor = 0.01;
            }
            if (zoomFactor > 0.0 && zoomFactor < 1.0) {
                interval *= zoomFactor;
            }
            boolean useVincenty = false;
            String H = "";
            String color = "";
            HashMap<Integer, String> hmap = armyc2.c5isr.JavaTacticalRenderer.clsUtility.getMSRSegmentColorStrings(tg);
            if (hmap != null) {
                tg.set_H("");
            }
            if (useVincenty = true) {
                resultPts = clsUtilityCPOF.toGeodesic(tg, interval, hmap);
                tg.LatLongs = resultPts;
                tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
                return;
            }
            for (j = 0; j < tg.LatLongs.size() - 1; ++j) {
                pt0 = new POINT2(tg.LatLongs.get(j));
                pt0.style = 0;
                pt1 = new POINT2(tg.LatLongs.get(j + 1));
                pt1.style = 0;
                az = mdlGeodesic.GetAzimuth(pt0, pt1);
                dist = mdlGeodesic.geodesic_distance(tg.LatLongs.get(j), tg.LatLongs.get(j + 1), null, null);
                n = (int)(dist / interval);
                if (j == 0) {
                    resultPts.add(pt0);
                    if (hmap != null && hmap.containsKey(j)) {
                        if (!H.isEmpty()) {
                            H = H + ",";
                        }
                        color = hmap.get(j);
                        H = H + Integer.toString(resultPts.size() - 1) + ":" + color;
                    }
                }
                for (k = 1; k <= n; ++k) {
                    pt = mdlGeodesic.geodesic_coordinate(pt0, interval * (double)k, az);
                    pt.style = -2;
                    dist = mdlGeodesic.geodesic_distance(pt, pt1, null, null);
                    if (!(dist >= interval / 2.0)) continue;
                    resultPts.add(pt);
                    if (hmap == null || !hmap.containsKey(j)) continue;
                    color = hmap.get(j);
                    if (!H.isEmpty()) {
                        H = H + ",";
                    }
                    H = H + Integer.toString(resultPts.size() - 1) + ":" + color;
                }
                resultPts.add(pt1);
                if (hmap == null || !hmap.containsKey(j + 1)) continue;
                if (!H.isEmpty()) {
                    H = H + ",";
                }
                color = hmap.get(j + 1);
                H = H + Integer.toString(resultPts.size() - 1) + ":" + color;
            }
            if (!H.isEmpty()) {
                tg.set_H(H);
            }
            tg.LatLongs = resultPts;
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
        }
        catch (Exception exc) {
            ErrorLogger.LogException(_className, "SegmentGeoPoints", new RendererException("Failed inside SegmentGeoPoints", exc));
        }
    }

    static double CalculateSignedAreaOfPolygon(ArrayList<POINT2> coords) {
        double signedArea = 0.0;
        int len = coords.size();
        for (int i = 0; i < len; ++i) {
            double x1 = coords.get((int)i).x;
            double y1 = coords.get((int)i).y;
            double x2 = coords.get((int)((i + 1) % len)).x;
            double y2 = coords.get((int)((i + 1) % len)).y;
            signedArea += x1 * y2 - x2 * y1;
        }
        return signedArea / 2.0;
    }
}

