/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GENCLookup {
    private static GENCLookup _instance = null;
    private static Boolean _initCalled = false;
    private static Map<Integer, String> _GENCLookup = null;
    private String TAG = "GENCLookup";
    private List<String> _IDList = new ArrayList<String>();

    private GENCLookup() {
        this.init();
    }

    public static synchronized GENCLookup getInstance() {
        if (_instance == null) {
            _instance = new GENCLookup();
        }
        return _instance;
    }

    private synchronized void init() {
        if (!_initCalled.booleanValue()) {
            _GENCLookup = new HashMap<Integer, String>();
            String[] temp = null;
            String delimiter = "\t";
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("data/genc.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                while (line != null) {
                    temp = line.split(delimiter);
                    if (temp != null && temp.length >= 2 && SymbolUtilities.isNumber(temp[1])) {
                        _GENCLookup.put(Integer.valueOf(temp[1]), temp[0]);
                    }
                    line = br.readLine();
                }
                _initCalled = true;
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public String get3CharCode(int id) {
        if (_GENCLookup != null && _GENCLookup.containsKey(id)) {
            return _GENCLookup.get(id);
        }
        return "";
    }
}

