/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.AffiliationColors;
import armyc2.c5isr.renderer.utilities.DistanceUnit;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolID;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MilStdSymbol {
    private Map<String, String> _Properties = null;
    private ArrayList<Double> _X_Altitude = null;
    private ArrayList<Double> _AM_Distance = null;
    private ArrayList<Double> _AN_Azimuth = null;
    private String _symbolID = "";
    private String _UUID = null;
    private ArrayList<ShapeInfo> _SymbolShapes;
    private ArrayList<ShapeInfo> _ModifierShapes;
    private ArrayList<Point2D> _Coordinates;
    private int _UnitSize = 50;
    private double _scale = 0.0;
    private Boolean _KeepUnitRatio = true;
    Integer _LineWidth = 3;
    Color _LineColor = null;
    Color _FillColor = null;
    Color _TextColor = null;
    Color _TextBackgroundColor = null;
    double _Rotation = 0.0;
    boolean _Outline = false;
    Color _OutLineColor = null;
    int _OutLineWidth = 0;
    TexturePaint _tp = null;
    boolean _fs = true;
    int _patternFillType = 0;
    private double patternScale = 1.0;
    private static String _AltitudeMode = "";
    private static DistanceUnit _AltitudeUnit = null;
    private static DistanceUnit _DistanceUnit = null;
    private static boolean _useDashArray = true;
    private static boolean _hideOptionalLabels = false;
    private static boolean _DrawAffiliationModifierAsLabel = true;
    private static boolean _UseLineInterpolation = false;
    public static final int TextScaleSensitive_No = 0;
    public static final int TextScaleSensitive_OnSlightZoomIn = 1;
    public static final int TextScaleSensitive_OnZoomIn = 2;
    public static final int TextScaleSensitive_OnZoomInOut = 3;
    public static final int SymbolScaleSensitive_No = 0;
    public static final int SymbolScaleSensitive_ArrowHeads = 1;
    public static final int SymbolScaleSensitive_DecoratedLines = 2;
    public static final int SymbolScaleSensitive_PatternFills = 3;
    Object _Tag = null;
    private boolean _wasClipped = false;

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D> Coordinates, Map<String, String> modifiers) {
        this(symbolID, uniqueID, Coordinates, modifiers, true);
    }

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D> Coordinates, Map<String, String> modifiers, Boolean keepUnitRatio) {
        this._Properties = modifiers == null ? new HashMap<String, String>() : modifiers;
        this._UUID = uniqueID;
        this.setCoordinates(Coordinates);
        this.setSymbolID(symbolID);
        this.setLineColor(SymbolUtilities.getDefaultLineColor(this._symbolID));
        this.setTextColor(SymbolUtilities.getLineColorOfAffiliation(symbolID));
        if (SymbolUtilities.hasDefaultFill(this._symbolID)) {
            this.setFillColor(SymbolUtilities.getFillColorOfAffiliation(this._symbolID));
        }
        _DrawAffiliationModifierAsLabel = RendererSettings.getInstance().getDrawAffiliationModifierAsLabel();
        _UseLineInterpolation = RendererSettings.getInstance().getUseLineInterpolation();
        this._KeepUnitRatio = keepUnitRatio;
    }

    public TexturePaint getFillStyle() {
        return this._tp;
    }

    public void setFillStyle(TexturePaint value) {
        this._tp = value;
    }

    public boolean getUseFillPattern() {
        return this._fs;
    }

    public void setUseFillPattern(boolean value) {
        this._fs = value;
    }

    public int getPatternFillType() {
        return this._patternFillType;
    }

    public void setPatternFillType(int value) {
        this._patternFillType = value;
    }

    public String getAltitudeMode() {
        return _AltitudeMode;
    }

    public void setAltitudeMode(String value) {
        _AltitudeMode = value;
    }

    public DistanceUnit getAltitudeUnit() {
        return _AltitudeUnit;
    }

    public void setAltitudeUnit(DistanceUnit unit) {
        _AltitudeUnit = unit;
    }

    public DistanceUnit getDistanceUnit() {
        return _DistanceUnit;
    }

    public void setDistanceUnit(DistanceUnit unit) {
        _DistanceUnit = unit;
    }

    public boolean getUseDashArray() {
        return _useDashArray;
    }

    public void setUseDashArray(boolean value) {
        _useDashArray = value;
    }

    public boolean getHideOptionalLabels() {
        return _hideOptionalLabels;
    }

    public void setHideOptionalLabels(boolean value) {
        _hideOptionalLabels = value;
    }

    public void setUseLineInterpolation(boolean value) {
        _UseLineInterpolation = value;
    }

    public boolean getUseLineInterpolation() {
        return _UseLineInterpolation;
    }

    public void setUnitSize(int pixelSize) {
        this._UnitSize = pixelSize;
    }

    public int getUnitSize() {
        return this._UnitSize;
    }

    public void setKeepUnitRatio(boolean value) {
        this._KeepUnitRatio = value;
    }

    public boolean getKeepUnitRatio() {
        return this._KeepUnitRatio;
    }

    public void setDrawAffiliationModifierAsLabel(boolean value) {
        _DrawAffiliationModifierAsLabel = value;
    }

    public boolean getDrawAffiliationModifierAsLabel() {
        return _DrawAffiliationModifierAsLabel;
    }

    public Map<String, String> getModifierMap() {
        return this._Properties;
    }

    public void setModifierMap(Map<String, String> modifiers) {
        this._Properties = modifiers;
    }

    public String getModifier(String modifier) {
        if (this._Properties.containsKey(modifier)) {
            return this._Properties.get(modifier);
        }
        return this.getModifier(modifier, 0);
    }

    public void setModifier(String modifier, String value) {
        if (!value.equals("")) {
            if (modifier != "AM_DISTANCE" || modifier == "AN_AZIMUTH" || modifier == "X_ALTITUDE_DEPTH") {
                this._Properties.put(modifier, value);
            } else {
                this.setModifier(modifier, value, 0);
            }
        }
    }

    public String getModifier(String modifier, int index) {
        if (this._Properties.containsKey(modifier)) {
            return this._Properties.get(modifier);
        }
        if (modifier == "AM_DISTANCE" || modifier == "AN_AZIMUTH" || modifier == "X_ALTITUDE_DEPTH") {
            String value = String.valueOf(this.getModifier_AM_AN_X(modifier, index));
            if (value != null && !value.equalsIgnoreCase("null") && !value.equalsIgnoreCase("")) {
                return value;
            }
            return null;
        }
        return null;
    }

    public Double getModifier_AM_AN_X(String modifier, int index) {
        ArrayList<Double> modifiers = null;
        if (modifier == "AM_DISTANCE") {
            modifiers = this._AM_Distance;
        } else if (modifier == "AN_AZIMUTH") {
            modifiers = this._AN_Azimuth;
        } else if (modifier == "X_ALTITUDE_DEPTH") {
            modifiers = this._X_Altitude;
        } else {
            return null;
        }
        if (modifiers != null && modifiers.size() > index) {
            Double value = null;
            value = modifiers.get(index);
            if (value != null) {
                return value;
            }
            return null;
        }
        return null;
    }

    public void setModifier(String modifier, String value, int index) {
        if (!value.equals("")) {
            if (modifier != "AM_DISTANCE" && modifier != "AN_AZIMUTH" && modifier != "X_ALTITUDE_DEPTH") {
                this._Properties.put(modifier, value);
            } else {
                Double dblValue = Double.valueOf(value);
                if (dblValue != null) {
                    this.setModifier_AM_AN_X(modifier, dblValue, index);
                }
            }
        }
    }

    public void setModifier_AM_AN_X(String modifier, Double value, int index) {
        if (modifier == "AM_DISTANCE" || modifier == "AN_AZIMUTH" || modifier == "X_ALTITUDE_DEPTH") {
            ArrayList<Double> modifiers = null;
            if (modifier == "AM_DISTANCE") {
                if (this._AM_Distance == null) {
                    this._AM_Distance = new ArrayList();
                }
                modifiers = this._AM_Distance;
            } else if (modifier == "AN_AZIMUTH") {
                if (this._AN_Azimuth == null) {
                    this._AN_Azimuth = new ArrayList();
                }
                modifiers = this._AN_Azimuth;
            } else if (modifier == "X_ALTITUDE_DEPTH") {
                if (this._X_Altitude == null) {
                    this._X_Altitude = new ArrayList();
                }
                modifiers = this._X_Altitude;
            }
            if (index + 1 > modifiers.size()) {
                modifiers.add(value);
            } else {
                modifiers.set(index, value);
            }
        }
    }

    public ArrayList<Double> getModifiers_AM_AN_X(String modifier) {
        if (modifier == "AM_DISTANCE") {
            return this._AM_Distance;
        }
        if (modifier == "AN_AZIMUTH") {
            return this._AN_Azimuth;
        }
        if (modifier == "X_ALTITUDE_DEPTH") {
            return this._X_Altitude;
        }
        return null;
    }

    public void setModifiers_AM_AN_X(String modifier, ArrayList<Double> modifiers) {
        if (modifier == "AM_DISTANCE") {
            this._AM_Distance = modifiers;
        } else if (modifier == "AN_AZIMUTH") {
            this._AN_Azimuth = modifiers;
        } else if (modifier == "X_ALTITUDE_DEPTH") {
            this._X_Altitude = modifiers;
        }
    }

    public void setFillColor(Color value) {
        this._FillColor = value;
    }

    public Color getFillColor() {
        return this._FillColor;
    }

    public void setTextColor(Color value) {
        this._TextColor = value;
        if (RendererSettings.getInstance().getTextBackgroundMethod() != 0 && this._TextBackgroundColor == null) {
            this._TextBackgroundColor = RendererUtilities.getIdealOutlineColor(this._TextColor);
        }
    }

    public Color getTextColor() {
        return this._TextColor;
    }

    public void setTextBackgroundColor(Color value) {
        this._TextBackgroundColor = value;
    }

    public Color getTextBackgroundColor() {
        return this._TextBackgroundColor;
    }

    public void setLineWidth(int value) {
        this._LineWidth = value;
    }

    public int getLineWidth() {
        return this._LineWidth;
    }

    public void setLineColor(Color value) {
        if (SymbolUtilities.isGreenProtectionGraphic(this.getSymbolID())) {
            this._LineColor = AffiliationColors.ObstacleGreen;
        } else if (value != null) {
            this._LineColor = value;
        }
    }

    public Color getLineColor() {
        return this._LineColor;
    }

    public void setOutlineColor(Color value) {
        this._OutLineColor = value;
    }

    public Color getOutlineColor() {
        return this._OutLineColor;
    }

    public void setTag(Object value) {
        this._Tag = value;
    }

    public Object getTag() {
        return this._Tag;
    }

    public void setCoordinates(ArrayList<Point2D> value) {
        this._Coordinates = value;
    }

    public ArrayList<Point2D> getCoordinates() {
        return this._Coordinates;
    }

    public void setModifierShapes(ArrayList<ShapeInfo> value) {
        this._ModifierShapes = value;
    }

    public ArrayList<ShapeInfo> getModifierShapes() {
        return this._ModifierShapes;
    }

    public void setSymbolShapes(ArrayList<ShapeInfo> value) {
        this._SymbolShapes = value;
    }

    public ArrayList<ShapeInfo> getSymbolShapes() {
        return this._SymbolShapes;
    }

    public String getSymbolID() {
        return this._symbolID;
    }

    public String getUUID() {
        return this._UUID;
    }

    public void setUUID(String ID) {
        this._UUID = ID;
    }

    public void setSymbolID(String value) {
        String current = this._symbolID;
        try {
            if (value != null && !value.equals("") && !current.equals(value)) {
                this._symbolID = value;
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("MilStdSymbol", "setSymbolID - Did not fall under TG or FE", e);
        }
    }

    public void set_WasClipped(boolean value) {
        this._wasClipped = value;
    }

    public boolean get_WasClipped() {
        return this._wasClipped;
    }

    public void setWasClipped(boolean value) {
        this._wasClipped = value;
    }

    public boolean getWasClipped() {
        return this._wasClipped;
    }

    public int isTextScaleSensitive() {
        ArrayList<ShapeInfo> modifiers = this.getModifierShapes();
        if (this._Properties == null) {
            return 0;
        }
        if (this._Properties.isEmpty()) {
            return 0;
        }
        if (SymbolID.getSymbolSet(this._symbolID) == 25) {
            MSInfo msi = MSLookup.getInstance().getMSLInfo(this._symbolID);
            if (msi != null) {
                int dr = msi.getDrawRule();
                String ec = String.valueOf(SymbolID.getEntityCode(this._symbolID));
                switch (dr) {
                    case 501: 
                    case 502: {
                        if (this._Properties.containsKey("W_DTG_1") || this._Properties.containsKey("W1_DTG_2")) {
                            return 3;
                        }
                        return 0;
                    }
                    case 401: {
                        if (this._Properties.size() > 1) {
                            return 3;
                        }
                        return 0;
                    }
                    case 305: {
                        if (ec.startsWith("2201")) {
                            if (this._Properties.containsKey("H_ADDITIONAL_INFO_1")) {
                                return 2;
                            }
                            return 0;
                        }
                        if (ec.startsWith("2407")) {
                            if (modifiers != null && !modifiers.isEmpty()) {
                                int size = modifiers.size();
                                if (size == 1) {
                                    return 2;
                                }
                                return 3;
                            }
                            return 0;
                        }
                        return 0;
                    }
                    case 801: {
                        if (modifiers != null && modifiers.size() > 1 && ec.startsWith("24")) {
                            return 3;
                        }
                        return 0;
                    }
                    case 901: {
                        if (modifiers != null && modifiers.size() > 1 && (ec.startsWith("2003") || ec.startsWith("24"))) {
                            return 3;
                        }
                        return 0;
                    }
                    case 803: {
                        if (modifiers != null && !modifiers.isEmpty()) {
                            return 2;
                        }
                        return 0;
                    }
                    case 902: 
                    case 1001: {
                        return 0;
                    }
                }
            }
            int ec = SymbolID.getEntityCode(this._symbolID);
            switch (ec) {
                case 140300: 
                case 140400: 
                case 330100: 
                case 330200: {
                    return 1;
                }
                case 110200: 
                case 110300: 
                case 140700: 
                case 140900: 
                case 141000: 
                case 141100: 
                case 141200: 
                case 141400: 
                case 141500: 
                case 141600: 
                case 141800: 
                case 141900: 
                case 142000: 
                case 190100: 
                case 190200: 
                case 200401: 
                case 200402: 
                case 330300: 
                case 330301: 
                case 330302: 
                case 330303: 
                case 330400: 
                case 330401: 
                case 330402: 
                case 330403: {
                    return 2;
                }
                case 120400: 
                case 142100: 
                case 370100: {
                    if (this._Properties.containsKey("H_ADDITIONAL_INFO_1")) {
                        return 2;
                    }
                    return 0;
                }
                case 290100: {
                    if (this._Properties.containsKey("T_UNIQUE_DESIGNATION_1")) {
                        return 2;
                    }
                    return 0;
                }
                case 140100: {
                    if (SymbolID.getAffiliation(this._symbolID) == 6) {
                        return 2;
                    }
                    return 1;
                }
                case 110100: {
                    if (this._Properties.containsKey("T_UNIQUE_DESIGNATION_1") || this._Properties.containsKey("T1_UNIQUE_DESIGNATION_2") || this._Properties.containsKey("AS_COUNTRY")) {
                        return 3;
                    }
                    return 0;
                }
                case 140601: 
                case 140602: 
                case 140603: 
                case 140605: 
                case 150501: 
                case 150502: 
                case 150503: 
                case 200300: {
                    if (this._Properties.containsKey("W_DTG_1") || this._Properties.containsKey("W1_DTG_2")) {
                        return 3;
                    }
                    return 0;
                }
                case 151100: {
                    if (SymbolID.getModifier1(this._symbolID) != 0 || this._Properties.containsKey("H_ADDITIONAL_INFO_1")) {
                        return 3;
                    }
                    return 0;
                }
                case 152400: 
                case 152500: {
                    if (modifiers != null && modifiers.size() > 1) {
                        return 3;
                    }
                    return 0;
                }
                case 120700: 
                case 170900: 
                case 171000: 
                case 171100: 
                case 171200: 
                case 171300: 
                case 171400: 
                case 171500: 
                case 171600: 
                case 171700: 
                case 171800: 
                case 171900: 
                case 172000: 
                case 240101: 
                case 240201: 
                case 240301: 
                case 240401: 
                case 240806: 
                case 241001: 
                case 241101: 
                case 241201: 
                case 241301: 
                case 241401: 
                case 241501: 
                case 241601: 
                case 241701: 
                case 241801: 
                case 241901: 
                case 242000: 
                case 242301: 
                case 242304: 
                case 242702: 
                case 242800: 
                case 270300: 
                case 290600: 
                case 310100: 
                case 310200: 
                case 310300: 
                case 310400: 
                case 310800: {
                    if (modifiers != null && modifiers.size() > 1) {
                        return 3;
                    }
                    return 0;
                }
                case 240501: 
                case 242400: {
                    if (modifiers != null && modifiers.size() > 4) {
                        return 3;
                    }
                    return 0;
                }
                case 110400: 
                case 260100: 
                case 260200: 
                case 260300: 
                case 260400: 
                case 260500: 
                case 300100: {
                    if (this._Properties.containsKey("W_DTG_1") || this._Properties.containsKey("W1_DTG_2")) {
                        return 3;
                    }
                    return 2;
                }
                case 260600: 
                case 340800: {
                    if (this._Properties.containsKey("W_DTG_1") || this._Properties.containsKey("W1_DTG_2")) {
                        return 2;
                    }
                    return 0;
                }
                case 270800: {
                    if (this._Properties.containsKey("W_DTG_1") || this._Properties.containsKey("H_ADDITIONAL_INFO_1")) {
                        return 2;
                    }
                    return 0;
                }
                case 220109: {
                    if (modifiers != null && modifiers.size() > 1) {
                        return 3;
                    }
                    return 2;
                }
                case 271100: 
                case 271300: {
                    if (this._Properties.containsKey("W_DTG_1") || this._Properties.containsKey("W1_DTG_2")) {
                        return 3;
                    }
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }

    public int isSymbolScaleSensitive() {
        int ec = SymbolID.getEntityCode(this._symbolID);
        if (SymbolID.getSymbolSet(this._symbolID) == 25) {
            switch (ec) {
                case 140601: 
                case 140602: 
                case 140603: 
                case 140605: 
                case 141700: 
                case 142100: 
                case 152000: 
                case 152100: 
                case 152200: 
                case 240701: 
                case 240702: 
                case 240703: 
                case 270502: 
                case 270504: 
                case 270601: 
                case 270602: 
                case 270603: 
                case 271100: 
                case 271300: 
                case 280100: 
                case 290600: 
                case 290700: 
                case 290800: 
                case 340200: 
                case 340300: 
                case 340400: 
                case 340500: 
                case 340800: 
                case 341000: 
                case 341200: 
                case 341300: 
                case 342100: 
                case 342201: 
                case 342202: 
                case 342203: 
                case 342300: 
                case 342400: 
                case 342500: 
                case 343000: 
                case 343200: 
                case 343300: 
                case 343400: 
                case 343500: 
                case 343600: 
                case 343700: 
                case 343800: 
                case 343900: 
                case 344000: 
                case 344100: 
                case 344200: 
                case 344400: 
                case 344500: 
                case 344600: 
                case 344700: {
                    return 1;
                }
                case 130701: 
                case 140100: 
                case 140200: 
                case 151000: 
                case 151202: 
                case 151203: 
                case 151204: 
                case 151205: 
                case 151208: 
                case 151800: 
                case 152600: 
                case 152800: 
                case 270100: 
                case 270200: 
                case 270300: 
                case 270400: 
                case 270801: 
                case 282003: 
                case 290100: 
                case 290201: 
                case 290202: 
                case 290203: 
                case 290204: 
                case 290301: 
                case 290302: 
                case 290303: 
                case 290304: 
                case 290305: 
                case 290306: 
                case 290307: 
                case 290308: 
                case 290309: 
                case 290900: 
                case 291000: 
                case 330100: 
                case 330200: 
                case 330301: 
                case 330302: 
                case 330303: 
                case 330401: 
                case 330402: 
                case 330403: 
                case 341100: {
                    return 2;
                }
                case 151100: 
                case 152400: 
                case 152500: 
                case 172000: 
                case 240301: 
                case 240302: 
                case 240303: 
                case 271700: 
                case 271701: 
                case 271800: 
                case 271801: 
                case 271900: 
                case 272000: 
                case 272001: {
                    if (!this.getUseFillPattern()) {
                        return 3;
                    }
                    return 0;
                }
            }
            return 0;
        }
        return 0;
    }

    public void setPatternScale(double scale) {
        this.patternScale = scale;
    }

    public double getPatternScale() {
        return this.patternScale;
    }
}

