/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SectorModUtils {
    private static SectorModUtils _instance = null;
    private static Boolean _initCalled = false;
    private String TAG = "SectorModUtils";
    private List<String> _IDList = new ArrayList<String>();
    private static Map<String, String> _sectorMods = new HashMap<String, String>();
    private static Map<String, ArrayList<String[]>> _sectorModLists = new HashMap<String, ArrayList<String[]>>();

    private SectorModUtils() {
        this.init();
    }

    public static synchronized SectorModUtils getInstance() {
        if (_instance == null) {
            _instance = new SectorModUtils();
        }
        return _instance;
    }

    private synchronized void init() {
        if (!_initCalled.booleanValue()) {
            try {
                this.loadData("data/smd.txt", 11);
                this.loadData("data/sme.txt", 15);
                _initCalled = true;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void loadData(String path, int version) {
        String[] temp = null;
        String delimiter = "\t";
        int ver = 0;
        int ss = -1;
        int l = 0;
        String code = "00";
        String name = "";
        String id = null;
        StringBuilder sb = null;
        ArrayList<String[]> sectorList = null;
        try {
            ver = version <= 11 ? 11 : 15;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
            if (is != null) {
                String[] entry = null;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = br.readLine();
                while (line != null) {
                    temp = line.split(delimiter);
                    if (temp.length == 2) {
                        if (sectorList != null && sectorList.size() > 0) {
                            sb = new StringBuilder();
                            sb.append(ver).append("-").append(ss).append("-").append(l);
                            id = sb.toString();
                            _sectorModLists.put(id, sectorList);
                        }
                        ss = Integer.parseInt(temp[0].split(" ")[0]);
                        l = Integer.parseInt(temp[1]);
                        sectorList = new ArrayList<String[]>();
                    } else if (temp != null && temp.length >= 3) {
                        name = temp[0];
                        code = temp[2];
                        if (code.length() == 1) {
                            code = "0" + code;
                        }
                        sb = new StringBuilder();
                        id = sb.append(ver).append("-").append(ss).append("-").append(l).append("-").append(code).toString();
                        entry = new String[]{code, name};
                        sectorList.add(entry);
                        _sectorMods.put(id, name);
                    }
                    line = br.readLine();
                }
                br.close();
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public ArrayList<String[]> getSectorModList(int version, int symbolSet, int location) {
        int ss;
        StringBuilder sb = new StringBuilder();
        int ver = 11;
        if (version >= 13) {
            ver = 15;
        }
        if ((ss = symbolSet) > 50 && ss < 60) {
            ss = 50;
        }
        sb.append(ver).append("-").append(ss).append("-").append(location);
        String id = sb.toString();
        if (_sectorModLists.containsKey(id)) {
            return _sectorModLists.get(sb.toString());
        }
        String[] entry = new String[]{"00", "Unspecified"};
        ArrayList<String[]> al = new ArrayList<String[]>();
        al.add(entry);
        return al;
    }

    public String getName(int version, int symbolSet, int location, String code) {
        int ss;
        StringBuilder sb = new StringBuilder();
        int ver = 11;
        if (version >= 13) {
            ver = 15;
        }
        if ((ss = symbolSet) > 50 && ss < 60) {
            ss = 50;
        }
        if (ss > 0 && code.length() != 2) {
            if (code.length() > 2) {
                code = code.substring(0, 2);
            } else {
                while (code.length() < 2) {
                    code = "0" + code;
                }
            }
        } else if (ss == 0 && code.length() != 3) {
            if (code.length() > 3) {
                code = code.substring(0, 3);
            } else {
                if (code.startsWith("0")) {
                    code = "1" + code;
                }
                while (code.length() < 3) {
                    code = "0" + code;
                }
            }
        }
        sb.append(ver).append("-").append(ss).append("-").append(location).append("-").append(code);
        String id = sb.toString();
        return _sectorMods.getOrDefault(id, "");
    }
}

