/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ShapeUtilities {
    public static void grow(Rectangle2D rect, int size) {
        rect.setFrame(rect.getX() - (double)size, rect.getY() - (double)size, rect.getWidth() + (double)(size * 2), rect.getHeight() + (double)(size * 2));
    }

    public static void offset(Rectangle2D rect, int offsetX, int offsetY) {
        rect.setRect(rect.getX() + (double)offsetX, rect.getY() + (double)offsetY, rect.getWidth(), rect.getHeight());
    }

    public static void offset(Rectangle2D rect, double offsetX, double offsetY) {
        rect.setRect(rect.getX() + offsetX, rect.getY() + offsetY, rect.getWidth(), rect.getHeight());
    }

    public static void offset(Point2D point, int offsetX, int offsetY) {
        point.setLocation(point.getX() + (double)offsetX, point.getY() + (double)offsetY);
    }

    public static void offset(Point2D point, double offsetX, double offsetY) {
        point.setLocation(point.getX() + offsetX, point.getY() + offsetY);
    }

    public static void offset(Path2D path, int offsetX, int offsetY) {
        path.transform(AffineTransform.getTranslateInstance(offsetX, offsetY));
    }

    public static Ellipse2D offset(Ellipse2D ellipse, double offsetX, double offsetY) {
        return new Ellipse2D.Double(ellipse.getX() + offsetX, ellipse.getY() + offsetY, ellipse.getWidth(), ellipse.getHeight());
    }

    public static Ellipse2D offset(Ellipse2D.Float ellipse, float offsetX, float offsetY) {
        return new Ellipse2D.Float((float)ellipse.getX() + offsetX, (float)ellipse.getY() + offsetY, (float)ellipse.getWidth(), (float)ellipse.getHeight());
    }

    public static Line2D offset(Line2D line, double offsetX, double offsetY) {
        return new Line2D.Double(line.getX1() + offsetX, line.getY1() + offsetY, line.getX2() + offsetX, line.getY2() + offsetY);
    }

    public static Line2D offset(Line2D.Float line, float offsetX, float offsetY) {
        return new Line2D.Float((float)line.getX1() + offsetX, (float)line.getY1() + offsetY, (float)line.getX2() + offsetX, (float)line.getY2() + offsetY);
    }
}

