/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render;

import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.web.render.GeoPixelConversion;
import java.awt.Point;
import java.awt.geom.Point2D;

public class PointConverter
implements IPointConversion {
    private double _controlLat = 0.0;
    private double _controlLong = 0.0;
    private double _scale = 0.0;
    private double _metersPerPixel = 0.0;
    private boolean _normalize = true;

    public void set_normalize(boolean value) {
        this._normalize = value;
    }

    public PointConverter(double controlLong, double controlLat, double scale) {
        this._controlLat = controlLat;
        this._controlLong = controlLong;
        this._scale = scale;
        this._metersPerPixel = GeoPixelConversion.metersPerPixel(scale);
    }

    public PointConverter(double left, double top, double right, double bottom, double scale) {
        this._controlLat = top;
        this._controlLong = left;
        this._scale = scale;
        this._metersPerPixel = GeoPixelConversion.metersPerPixel(scale);
        if (top < bottom) {
            this._metersPerPixel = -this._metersPerPixel;
        }
    }

    public Point2D.Double PixelsToGeo(Point pixel) {
        Point2D.Double pt2dGeo = null;
        double y = GeoPixelConversion.y2lat(pixel.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion.x2long(pixel.getX(), this._scale, this._controlLong, y, this._metersPerPixel);
        pt2dGeo = new Point2D.Double(x, y);
        return pt2dGeo;
    }

    public Point GeoToPixels(Point2D.Double coord) {
        Point ptPixels = null;
        double y = GeoPixelConversion.lat2y(coord.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion.long2x(coord.getX(), this._scale, this._controlLong, coord.getY(), this._metersPerPixel, this._normalize);
        ptPixels = new Point();
        ptPixels.setLocation(x, y);
        return ptPixels;
    }

    @Override
    public Point2D PixelsToGeo(Point2D pixel) {
        Point2D.Double pt2dGeo = null;
        double y = GeoPixelConversion.y2lat(pixel.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion.x2long(pixel.getX(), this._scale, this._controlLong, y, this._metersPerPixel);
        pt2dGeo = new Point2D.Double(x, y);
        return pt2dGeo;
    }

    @Override
    public Point2D GeoToPixels(Point2D coord) {
        Point2D.Double pt2DPixels = null;
        double y = GeoPixelConversion.lat2y(coord.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion.long2x(coord.getX(), this._scale, this._controlLong, coord.getY(), this._metersPerPixel, this._normalize);
        pt2DPixels = new Point2D.Double(x, y);
        return pt2DPixels;
    }
}

