/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render;

import armyc2.c5isr.JavaTacticalRenderer.TGLight;
import armyc2.c5isr.RenderMultipoints.clsRenderer;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.IPointConversion;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.MilStdSymbol;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolDraw;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import armyc2.c5isr.web.render.MultiPointHandler;
import armyc2.c5isr.web.render.PointConverter;
import armyc2.c5isr.web.render.utilities.JavaRendererUtilities;
import armyc2.c5isr.web.render.utilities.Point3D;
import armyc2.c5isr.web.render.utilities.ShapeInfo3D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class Shape3DHandler {
    public static String RenderMilStd3dSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, Double scale, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes, int format) {
        Color defaultColor;
        boolean normalize = true;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo3D> shapes = new ArrayList<ShapeInfo3D>();
        ArrayList<ShapeInfo3D> modifiers = new ArrayList<ShapeInfo3D>();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        Object coordsUL = null;
        if (symbolAttributes.get("LINECOLOR") == null) {
            defaultColor = SymbolUtilities.getLineColorOfAffiliation(symbolCode);
            if (defaultColor == null) {
                defaultColor = Color.BLACK;
            }
            symbolAttributes.put("LINECOLOR", RendererUtilities.colorToHexString(defaultColor, true));
        }
        if (symbolAttributes.get("FILLCOLOR") == null) {
            defaultColor = SymbolUtilities.getFillColorOfAffiliation(symbolCode);
            if (defaultColor == null) {
                defaultColor = Color.white;
            }
            defaultColor = new Color(defaultColor.getRed(), defaultColor.getGreen(), defaultColor.getBlue(), 170);
            symbolAttributes.put("FILLCOLOR", RendererUtilities.colorToHexString(defaultColor, true));
        }
        if (altitudeMode == null || altitudeMode.equals("clampToGround")) {
            altitudeMode = "absolute";
        }
        if (!JavaRendererUtilities.is3dSymbol(symbolCode)) {
            String basicID = SymbolUtilities.getBasicSymbolID(symbolCode);
            String errorMsg = "Basic ID: " + basicID + " is not a 3D Symbol";
            String ErrorOutput = "";
            ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the 3D MilStdSymbol " + symbolCode + " - ID: " + id + " - ";
            ErrorOutput = ErrorOutput + errorMsg;
            ErrorOutput = ErrorOutput + "\"}";
            ErrorLogger.LogMessage("Shape3DHandler", "RenderMilStd3dSymbol", errorMsg, Level.FINE);
            return ErrorOutput;
        }
        String symbolIsValid = MultiPointHandler.canRenderMultiPoint(symbolCode, symbolModifiers, len);
        if (!symbolIsValid.equals("true")) {
            String ErrorOutput = "";
            ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the 3D MilStdSymbol " + symbolCode + " - ID: " + id + " - ";
            ErrorOutput = ErrorOutput + symbolIsValid;
            ErrorOutput = ErrorOutput + "\"}";
            ErrorLogger.LogMessage("Shape3DHandler", "RenderMilStd3dSymbol", symbolIsValid, Level.WARNING);
            return ErrorOutput;
        }
        if (MSLookup.getInstance().getMSLInfo(symbolCode).getDrawRule() != 110) {
            len = Math.min(len, MSLookup.getInstance().getMSLInfo(symbolCode).getMaxPointCount());
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        Object tgPoints = null;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                String[] coords = bbox.split(" ");
                for (String coord : coords) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                String bbox2 = MultiPointHandler.getBboxFromCoords(bboxCoords);
                scale = MultiPointHandler.getReasonableScale(bbox2, scale);
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            ArrayList<Double> altitudes;
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (format == 3) {
                symbolAttributes.put("USEDASHARRAY", "true");
                symbolAttributes.put("USEPATTERNFILL", "true");
            }
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            if (bboxCoords == null) {
                Rectangle clipBounds = MultiPointHandler.getOverscanClipBounds(rect, ipc);
                clsRenderer.renderWithPolylines(mSymbol, ipc, clipBounds);
            } else {
                clsRenderer.renderWithPolylines(mSymbol, ipc, bboxCoords);
            }
            if (MSLookup.getInstance().getMSLInfo(symbolCode).getDrawRule() == 401) {
                for (int i = 0; i < mSymbol.getSymbolShapes().size() - 1; ++i) {
                    mSymbol.getSymbolShapes().get(i).setLineColor(mSymbol.getSymbolShapes().get(mSymbol.getSymbolShapes().size() - 1).getLineColor());
                }
                mSymbol.getSymbolShapes().remove(mSymbol.getSymbolShapes().size() - 1);
                Collections.reverse(mSymbol.getSymbolShapes());
            }
            if ((altitudes = mSymbol.getModifiers_AM_AN_X("X_ALTITUDE_DEPTH")).size() == 1) {
                altitudes.add(0, 0.0);
            }
            Double lastAlt = altitudes.get(altitudes.size() - 1);
            Double nextToLastAlt = altitudes.get(altitudes.size() - 2);
            while (altitudes.size() < mSymbol.getSymbolShapes().size() * 2) {
                altitudes.add(nextToLastAlt);
                altitudes.add(lastAlt);
            }
            for (int shapeIndex = 0; shapeIndex < mSymbol.getSymbolShapes().size(); ++shapeIndex) {
                Double minAlt = altitudes.get(shapeIndex * 2);
                Double maxAlt = altitudes.get(shapeIndex * 2 + 1);
                ShapeInfo oldShape = mSymbol.getSymbolShapes().get(shapeIndex);
                ShapeInfo3D bottomShape = new ShapeInfo3D();
                bottomShape.setShapeType(oldShape.getShapeType());
                bottomShape.setStroke(oldShape.getStroke());
                bottomShape.setLineColor(oldShape.getLineColor());
                bottomShape.setFillColor(oldShape.getFillColor());
                bottomShape.setPatternFillImage(oldShape.getPatternFillImage());
                bottomShape.setPolylines3D(new ArrayList<ArrayList<Point3D>>());
                ShapeInfo3D topShape = new ShapeInfo3D();
                topShape.setShapeType(oldShape.getShapeType());
                topShape.setStroke(oldShape.getStroke());
                topShape.setLineColor(oldShape.getLineColor());
                topShape.setFillColor(oldShape.getFillColor());
                topShape.setPatternFillImage(oldShape.getPatternFillImage());
                topShape.setPolylines3D(new ArrayList<ArrayList<Point3D>>());
                for (int polyLineIndex = 0; polyLineIndex < oldShape.getPolylines().size(); ++polyLineIndex) {
                    ArrayList<Point2D> polyline = oldShape.getPolylines().get(polyLineIndex);
                    bottomShape.getPolylines3D().add(new ArrayList());
                    topShape.getPolylines3D().add(new ArrayList());
                    for (int ptIndex = 0; ptIndex < polyline.size(); ++ptIndex) {
                        Point2D pt = polyline.get(ptIndex);
                        Point2D pt2 = polyline.get((ptIndex + 1) % polyline.size());
                        bottomShape.getPolylines3D().get(polyLineIndex).add(new Point3D(pt, (double)minAlt));
                        topShape.getPolylines3D().get(polyLineIndex).add(new Point3D(pt, (double)maxAlt));
                        ShapeInfo3D sideShape = new ShapeInfo3D();
                        sideShape.setShapeType(oldShape.getShapeType());
                        sideShape.setStroke(oldShape.getStroke());
                        sideShape.setLineColor(oldShape.getLineColor());
                        sideShape.setFillColor(oldShape.getFillColor());
                        sideShape.setPatternFillImage(oldShape.getPatternFillImage());
                        sideShape.setPolylines3D(new ArrayList<ArrayList<Point3D>>());
                        sideShape.getPolylines3D().add(new ArrayList());
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt, (double)minAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt2, (double)minAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt2, (double)maxAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt, (double)maxAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt, (double)minAlt));
                        shapes.add(sideShape);
                    }
                }
                shapes.add(bottomShape);
                shapes.add(topShape);
            }
            if (!mSymbol.getSymbolShapes().isEmpty() && !mSymbol.getModifierShapes().isEmpty()) {
                double modifierAlt = Collections.max(altitudes.subList(0, mSymbol.getSymbolShapes().size() * 2));
                for (ShapeInfo oldShape : mSymbol.getModifierShapes()) {
                    ShapeInfo3D modShape = new ShapeInfo3D();
                    modShape.setModifierString(oldShape.getModifierString());
                    modShape.setModifierPosition(new Point3D(oldShape.getModifierPosition(), modifierAlt));
                    modShape.setModifierAngle(oldShape.getModifierAngle());
                    modShape.setTextJustify(oldShape.getTextJustify());
                    modShape.setModifierImage(oldShape.getModifierImage());
                    modifiers.add(modShape);
                }
            }
            if (format == 0) {
                Color textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = Shape3DHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, textColor, altitudeMode, mSymbol.get_WasClipped());
                jsonOutput.append(jsonContent);
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = Shape3DHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.replace(jsonOutput.toString().length() - 1, jsonOutput.toString().length(), "");
                if (jsonContent.length() > 2) {
                    jsonOutput.append(",");
                }
                jsonOutput.append("{\"type\": \"Feature\",\"geometry\": { \"type\": \"Polygon\",\"coordinates\": [ ]}");
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.get_WasClipped()));
                jsonOutput.append("\"}}]}");
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the 3D MilStdSymbol ").append(symbolCode).append(": ").append("- ");
            jsonOutput.append(exc.getMessage()).append(" - ");
            jsonOutput.append(st);
            jsonOutput.append("\"}");
            ErrorLogger.LogException("Shape3DHandler", "RenderMilStd3dSymbol", exc);
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        ErrorLogger.LogMessage("Shape3DHandler", "RenderMilStd3dSymbol()", "exit RenderMilStd3dSymbol", Level.FINER);
        return jsonOutput.toString();
    }

    public static String RenderBasic3DShape(String id, String name, String description, int basicShapeType, String controlPoints, String altitudeMode, Double scale, String bbox, Map<String, String> symbolModifiers, Map<String, String> symbolAttributes, int format) {
        boolean normalize = true;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Cloneable rect = null;
        String[] coordinates = controlPoints.split(" ");
        ArrayList<ShapeInfo3D> shapes = new ArrayList<ShapeInfo3D>();
        ArrayList<ShapeInfo3D> modifiers = new ArrayList<ShapeInfo3D>();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        Object coordsUL = null;
        String symbolCode = "";
        if (symbolAttributes.get("LINECOLOR") == null) {
            symbolAttributes.put("LINECOLOR", RendererUtilities.colorToHexString(Color.BLACK, true));
        }
        if (symbolAttributes.get("FILLCOLOR") == null) {
            Color defaultColor = new Color(255, 255, 255, 170);
            symbolAttributes.put("FILLCOLOR", RendererUtilities.colorToHexString(defaultColor, true));
        }
        if (altitudeMode == null || altitudeMode.equals("clampToGround")) {
            altitudeMode = "absolute";
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        Object tgPoints = null;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                String bbox2 = MultiPointHandler.getBboxFromCoords(bboxCoords);
                scale = MultiPointHandler.getReasonableScale(bbox2, scale);
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels((Point2D)pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        try {
            MilStdSymbol mSymbol = new MilStdSymbol("", null, geoCoords, null);
            if (format == 3) {
                symbolAttributes.put("USEDASHARRAY", "true");
                symbolAttributes.put("USEPATTERNFILL", "true");
            }
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbolBasicShape(mSymbol, ipc, basicShapeType);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            Cloneable clipArea = bboxCoords == null ? rect : bboxCoords;
            if (clsRenderer.intersectsClipArea(tg, ipc, clipArea)) {
                clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, ipc, clipArea);
            }
            mSymbol.setSymbolShapes(shapeInfos);
            mSymbol.setModifierShapes(modifierShapeInfos);
            mSymbol.set_WasClipped(tg.get_WasClipped());
            ArrayList<Double> altitudes = mSymbol.getModifiers_AM_AN_X("X_ALTITUDE_DEPTH");
            if (altitudes.size() == 1) {
                altitudes.add(0, 0.0);
            }
            if (basicShapeType == 16000002) {
                altitudes = new ArrayList<Double>(altitudes.subList(0, 2));
            }
            Double lastAlt = altitudes.get(altitudes.size() - 1);
            Double nextToLastAlt = altitudes.get(altitudes.size() - 2);
            while (altitudes.size() < mSymbol.getSymbolShapes().size() * 2) {
                altitudes.add(nextToLastAlt);
                altitudes.add(lastAlt);
            }
            for (int shapeIndex = 0; shapeIndex < mSymbol.getSymbolShapes().size(); ++shapeIndex) {
                Double minAlt = altitudes.get(shapeIndex * 2);
                Double maxAlt = altitudes.get(shapeIndex * 2 + 1);
                ShapeInfo oldShape = mSymbol.getSymbolShapes().get(shapeIndex);
                ShapeInfo3D bottomShape = new ShapeInfo3D();
                bottomShape.setShapeType(oldShape.getShapeType());
                bottomShape.setStroke(oldShape.getStroke());
                bottomShape.setLineColor(oldShape.getLineColor());
                bottomShape.setFillColor(oldShape.getFillColor());
                bottomShape.setPatternFillImage(oldShape.getPatternFillImage());
                bottomShape.setPolylines3D(new ArrayList<ArrayList<Point3D>>());
                ShapeInfo3D topShape = new ShapeInfo3D();
                topShape.setShapeType(oldShape.getShapeType());
                topShape.setStroke(oldShape.getStroke());
                topShape.setLineColor(oldShape.getLineColor());
                topShape.setFillColor(oldShape.getFillColor());
                topShape.setPatternFillImage(oldShape.getPatternFillImage());
                topShape.setPolylines3D(new ArrayList<ArrayList<Point3D>>());
                for (int polyLineIndex = 0; polyLineIndex < oldShape.getPolylines().size(); ++polyLineIndex) {
                    ArrayList<Point2D> polyline = oldShape.getPolylines().get(polyLineIndex);
                    bottomShape.getPolylines3D().add(new ArrayList());
                    topShape.getPolylines3D().add(new ArrayList());
                    for (int ptIndex = 0; ptIndex < polyline.size(); ++ptIndex) {
                        Point2D pt = polyline.get(ptIndex);
                        Point2D pt2 = polyline.get((ptIndex + 1) % polyline.size());
                        bottomShape.getPolylines3D().get(polyLineIndex).add(new Point3D(pt, (double)minAlt));
                        topShape.getPolylines3D().get(polyLineIndex).add(new Point3D(pt, (double)maxAlt));
                        ShapeInfo3D sideShape = new ShapeInfo3D();
                        sideShape.setShapeType(oldShape.getShapeType());
                        sideShape.setStroke(oldShape.getStroke());
                        sideShape.setLineColor(oldShape.getLineColor());
                        sideShape.setFillColor(oldShape.getFillColor());
                        sideShape.setPatternFillImage(oldShape.getPatternFillImage());
                        sideShape.setPolylines3D(new ArrayList<ArrayList<Point3D>>());
                        sideShape.getPolylines3D().add(new ArrayList());
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt, (double)minAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt2, (double)minAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt2, (double)maxAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt, (double)maxAlt));
                        sideShape.getPolylines3D().get(0).add(new Point3D(pt, (double)minAlt));
                        shapes.add(sideShape);
                    }
                }
                shapes.add(bottomShape);
                shapes.add(topShape);
            }
            if (!mSymbol.getSymbolShapes().isEmpty() && !mSymbol.getModifierShapes().isEmpty()) {
                double modifierAlt = Collections.max(altitudes.subList(0, mSymbol.getSymbolShapes().size() * 2));
                for (ShapeInfo oldShape : mSymbol.getModifierShapes()) {
                    ShapeInfo3D modShape = new ShapeInfo3D();
                    modShape.setModifierString(oldShape.getModifierString());
                    modShape.setModifierPosition(new Point3D(oldShape.getModifierPosition(), modifierAlt));
                    modShape.setModifierAngle(oldShape.getModifierAngle());
                    modShape.setTextJustify(oldShape.getTextJustify());
                    modShape.setModifierImage(oldShape.getModifierImage());
                    modifiers.add(modShape);
                }
            }
            if (format == 0) {
                Color textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = Shape3DHandler.KMLize(id, name, description, "", shapes, modifiers, ipc, normalize, textColor, altitudeMode, mSymbol.get_WasClipped());
                jsonOutput.append(jsonContent);
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = Shape3DHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.replace(jsonOutput.toString().length() - 1, jsonOutput.toString().length(), "");
                if (jsonContent.length() > 2) {
                    jsonOutput.append(",");
                }
                jsonOutput.append("{\"type\": \"Feature\",\"geometry\": { \"type\": \"Polygon\",\"coordinates\": [ ]}");
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append("");
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.get_WasClipped()));
                jsonOutput.append("\"}}]}");
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the 3D MilStdSymbol : - ");
            jsonOutput.append(exc.getMessage()).append(" - ");
            jsonOutput.append(st);
            jsonOutput.append("\"}");
            ErrorLogger.LogException("Shape3DHandler", "RenderBasic3DShape", exc);
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: ");
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + ((Rectangle)rect).toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        ErrorLogger.LogMessage("Shape3DHandler", "RenderBasic3DShape()", "exit RenderBasic3DShape", Level.FINER);
        return jsonOutput.toString();
    }

    private static String KMLize(String id, String name, String description, String symbolCode, ArrayList<ShapeInfo3D> shapes, ArrayList<ShapeInfo3D> modifiers, IPointConversion ipc, boolean normalize, Color textColor, String altitudeMode, boolean wasClipped) {
        StringBuilder kml = new StringBuilder();
        ShapeInfo3D tempModifier = null;
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        int len = shapes.size();
        kml.append("<Folder id=\"").append(id).append("\">");
        kml.append("<name>").append(cdataStart).append(name).append(cdataEnd).append("</name>");
        kml.append("<visibility>1</visibility>");
        kml.append("<description>").append(cdataStart).append(description).append(cdataEnd).append("</description>");
        kml.append("<ExtendedData>");
        kml.append("<Data name=\"symbolID\"><value>").append(cdataStart).append(symbolCode).append(cdataEnd).append("</value></Data>");
        kml.append("<Data name=\"wasClipped\"><value>").append(cdataStart).append(wasClipped).append(cdataEnd).append("</value></Data>");
        kml.append("</ExtendedData>");
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = Shape3DHandler.ShapeToKMLString(shapes.get(i), ipc, normalize, altitudeMode);
            kml.append(shapesToAdd);
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = Shape3DHandler.LabelToKMLString(tempModifier, ipc, normalize, textColor, altitudeMode);
            kml.append(labelsToAdd);
        }
        kml.append("</Folder>");
        return kml.toString();
    }

    private static String ShapeToKMLString(ShapeInfo3D shapeInfo, IPointConversion ipc, boolean normalize, String altitudeMode) {
        StringBuilder kml = new StringBuilder();
        Color lineColor = null;
        Color fillColor = null;
        String googleLineColor = null;
        String googleFillColor = null;
        BasicStroke stroke = null;
        int lineWidth = 4;
        kml.append("<Placemark>");
        kml.append("<Style>");
        lineColor = shapeInfo.getLineColor();
        if (lineColor != null) {
            googleLineColor = Integer.toHexString(shapeInfo.getLineColor().getRGB());
            stroke = shapeInfo.getStroke();
            if (stroke != null) {
                lineWidth = (int)stroke.getLineWidth();
            }
            googleLineColor = JavaRendererUtilities.ARGBtoABGR(googleLineColor);
            kml.append("<LineStyle>");
            kml.append("<color>").append(googleLineColor).append("</color>");
            kml.append("<colorMode>normal</colorMode>");
            kml.append("<width>").append(String.valueOf(lineWidth)).append("</width>");
            kml.append("</LineStyle>");
        }
        fillColor = shapeInfo.getFillColor();
        BufferedImage fillPattern = shapeInfo.getPatternFillImage();
        if (fillColor != null || fillPattern != null) {
            kml.append("<PolyStyle>");
            if (fillColor != null) {
                googleFillColor = Integer.toHexString(shapeInfo.getFillColor().getRGB());
                googleFillColor = JavaRendererUtilities.ARGBtoABGR(googleFillColor);
                kml.append("<color>").append(googleFillColor).append("</color>");
                kml.append("<colorMode>normal</colorMode>");
            }
            if (fillPattern != null) {
                kml.append("<shader>").append(MultiPointHandler.bitmapToString(fillPattern)).append("</shader>");
            }
            kml.append("<fill>1</fill>");
            if (lineColor != null) {
                kml.append("<outline>1</outline>");
            } else {
                kml.append("<outline>0</outline>");
            }
            kml.append("</PolyStyle>");
        }
        kml.append("</Style>");
        ArrayList<ArrayList<Point3D>> shapesArray = shapeInfo.getPolylines3D();
        int len = shapesArray.size();
        kml.append("<MultiGeometry>");
        for (int i = 0; i < len; ++i) {
            double altitude;
            double longitude;
            double latitude;
            Point2D geoCoord;
            Point3D coord;
            int j;
            int n;
            ArrayList<Point3D> shape = shapesArray.get(i);
            normalize = Shape3DHandler.normalizePoints(shape, ipc);
            if (lineColor != null && fillColor == null) {
                kml.append("<Polygon>");
                kml.append("<tessellate>1</tessellate>");
                kml.append("<altitudeMode>").append(altitudeMode).append("</altitudeMode>");
                kml.append("<outerBoundaryIs><LinearRing><coordinates>");
                n = shape.size();
                for (j = 0; j < n; ++j) {
                    coord = shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                    longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                    altitude = coord.getZ();
                    kml.append(longitude);
                    kml.append(",");
                    kml.append(latitude);
                    kml.append(",");
                    kml.append(altitude);
                    if (j >= shape.size() - 1) continue;
                    kml.append(" ");
                }
                kml.append("</coordinates></LinearRing></outerBoundaryIs>");
                kml.append("</Polygon>");
            }
            if (fillColor == null) continue;
            if (i == 0) {
                kml.append("<Polygon>");
                kml.append("<tessellate>1</tessellate>");
                kml.append("<altitudeMode>").append(altitudeMode).append("</altitudeMode>");
            }
            if (i == 1 && len > 1) {
                kml.append("<innerBoundaryIs>");
            } else {
                kml.append("<outerBoundaryIs>");
            }
            kml.append("<LinearRing>");
            kml.append("<coordinates>");
            n = shape.size();
            for (j = 0; j < n; ++j) {
                coord = shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                altitude = coord.getZ();
                if (normalize && longitude > 0.0) {
                    longitude -= 360.0;
                }
                kml.append(longitude);
                kml.append(",");
                kml.append(latitude);
                kml.append(",");
                kml.append(altitude);
                if (j >= shape.size() - 1) continue;
                kml.append(" ");
            }
            kml.append("</coordinates>");
            kml.append("</LinearRing>");
            if (i == 1 && len > 1) {
                kml.append("</innerBoundaryIs>");
            } else {
                kml.append("</outerBoundaryIs>");
            }
            if (i != len - 1) continue;
            kml.append("</Polygon>");
        }
        kml.append("</MultiGeometry>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static String LabelToKMLString(ShapeInfo3D shapeInfo, IPointConversion ipc, boolean normalize, Color textColor, String altitudeMode) {
        StringBuilder kml = new StringBuilder();
        Point3D coord = new Point3D(shapeInfo.getModifierPosition().getX(), shapeInfo.getModifierPosition().getY(), shapeInfo.getModifierPosition().getZ());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double altitude = coord.getZ();
        long angle = Math.round(shapeInfo.getModifierAngle());
        String text = shapeInfo.getModifierString();
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        String color = Integer.toHexString(textColor.getRGB());
        color = JavaRendererUtilities.ARGBtoABGR(color);
        float kmlScale = RendererSettings.getInstance().getKMLLabelScale();
        if (!(kmlScale > 0.0f) || text == null || text.equals("")) {
            return "";
        }
        kml.append("<Placemark>");
        kml.append("<name>").append(cdataStart).append(text).append(cdataEnd).append("</name>");
        kml.append("<Style>");
        kml.append("<IconStyle>");
        kml.append("<scale>").append(kmlScale).append("</scale>");
        kml.append("<heading>").append(angle).append("</heading>");
        kml.append("<Icon>");
        kml.append("<href></href>");
        kml.append("</Icon>");
        kml.append("</IconStyle>");
        kml.append("<LabelStyle>");
        kml.append("<color>").append(color).append("</color>");
        kml.append("<scale>").append(String.valueOf(kmlScale)).append("</scale>");
        kml.append("</LabelStyle>");
        kml.append("</Style>");
        kml.append("<Point>");
        kml.append("<extrude>0</extrude>");
        kml.append("<altitudeMode>").append(altitudeMode).append("</altitudeMode>");
        kml.append("<coordinates>");
        kml.append(longitude);
        kml.append(",");
        kml.append(latitude);
        kml.append(",");
        kml.append(altitude);
        kml.append("</coordinates>");
        kml.append("</Point>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static String GeoJSONize(ArrayList<ShapeInfo3D> shapes, ArrayList<ShapeInfo3D> modifiers, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        ShapeInfo3D tempModifier = null;
        StringBuilder fc = new StringBuilder();
        fc.append("[");
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = Shape3DHandler.ShapeToGeoJSONString(shapes.get(i), ipc, normalize);
            if (shapesToAdd.length() <= 0) continue;
            fc.append(shapesToAdd);
            if (i >= len - 1) continue;
            fc.append(",");
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String modifiersToAdd = null;
            modifiersToAdd = modifiers.get(j).getModifierImage() != null ? Shape3DHandler.ImageToGeoJSONString(tempModifier, ipc, normalize) : Shape3DHandler.LabelToGeoJSONString(tempModifier, ipc, normalize, textColor, textBackgroundColor);
            if (modifiersToAdd.length() <= 0) continue;
            if (fc.length() > 1) {
                fc.append(",");
            }
            fc.append(modifiersToAdd);
        }
        fc.append("]");
        String GeoJSON = fc.toString();
        return GeoJSON;
    }

    private static String ShapeToGeoJSONString(ShapeInfo3D shapeInfo, IPointConversion ipc, boolean normalize) {
        int i;
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        String geometryType = null;
        String sda = null;
        Color lineColor = shapeInfo.getLineColor();
        Color fillColor = shapeInfo.getFillColor();
        geometryType = shapeInfo.getShapeType() == ShapeInfo.SHAPE_TYPE_FILL || fillColor != null || shapeInfo.getPatternFillImage() != null ? "\"Polygon\"" : "\"MultiLineString\"";
        BasicStroke stroke = null;
        stroke = shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        properties.append("\"properties\":{");
        properties.append("\"label\":\"\",");
        if (lineColor != null) {
            properties.append("\"strokeColor\":\"").append(RendererUtilities.colorToHexString(lineColor, false)).append("\",");
            properties.append("\"lineOpacity\":").append(String.valueOf((float)lineColor.getAlpha() / 255.0f)).append(",");
        }
        if (fillColor != null) {
            properties.append("\"fillColor\":\"").append(RendererUtilities.colorToHexString(fillColor, false)).append("\",");
            properties.append("\"fillOpacity\":").append(String.valueOf((float)fillColor.getAlpha() / 255.0f)).append(",");
        }
        if (shapeInfo.getPatternFillImage() != null) {
            properties.append("\"fillPattern\":\"").append(MultiPointHandler.bitmapToString(shapeInfo.getPatternFillImage())).append("\",");
        }
        if (stroke.getDashArray() != null) {
            sda = "\"strokeDasharray\":" + Arrays.toString(stroke.getDashArray()) + ",";
            properties.append(sda);
        }
        int lineCap = stroke.getEndCap();
        properties.append("\"lineCap\":").append(lineCap).append(",");
        String strokeWidth = String.valueOf(lineWidth);
        properties.append("\"strokeWidth\":").append(strokeWidth).append(",");
        properties.append("\"strokeWeight\":").append(strokeWidth);
        properties.append("},");
        properties.append("\"style\":{");
        if (lineColor != null) {
            properties.append("\"stroke\":\"").append(RendererUtilities.colorToHexString(lineColor, false)).append("\",");
            properties.append("\"line-opacity\":").append(String.valueOf((float)lineColor.getAlpha() / 255.0f)).append(",");
        }
        if (fillColor != null) {
            properties.append("\"fill\":\"").append(RendererUtilities.colorToHexString(fillColor, false)).append("\",");
            properties.append("\"fill-opacity\":").append(String.valueOf((float)fillColor.getAlpha() / 255.0f)).append(",");
        }
        if (stroke.getDashArray() != null) {
            float[] da = stroke.getDashArray();
            sda = String.valueOf(da[0]);
            if (da.length > 1) {
                for (i = 1; i < da.length; ++i) {
                    sda = sda + " " + String.valueOf(da[i]);
                }
            }
            sda = "\"stroke-dasharray\":\"" + sda + "\",";
            properties.append(sda);
            sda = null;
        }
        if (lineCap == 2) {
            properties.append("\"stroke-linecap\":\"square\",");
        } else if (lineCap == 1) {
            properties.append("\"stroke-linecap\":\"round\",");
        } else if (lineCap == 0) {
            properties.append("\"stroke-linecap\":\"butt\",");
        }
        strokeWidth = String.valueOf(lineWidth);
        properties.append("\"stroke-width\":").append(strokeWidth);
        properties.append("}");
        geometry.append("\"geometry\":{\"type\":");
        geometry.append(geometryType);
        geometry.append(",\"coordinates\":[");
        ArrayList<ArrayList<Point3D>> shapesArray = shapeInfo.getPolylines3D();
        for (i = 0; i < shapesArray.size(); ++i) {
            ArrayList<Point3D> pointList = shapesArray.get(i);
            normalize = Shape3DHandler.normalizePoints(pointList, ipc);
            geometry.append("[");
            for (int j = 0; j < pointList.size(); ++j) {
                Point3D coord = pointList.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                double altitude = coord.getZ();
                if (normalize && fillColor != null && longitude > 0.0) {
                    longitude -= 360.0;
                }
                coord = new Point3D(longitude, latitude, altitude);
                pointList.set(j, coord);
                geometry.append("[");
                geometry.append(longitude);
                geometry.append(",");
                geometry.append(latitude);
                geometry.append(",");
                geometry.append(altitude);
                geometry.append("]");
                if (j >= pointList.size() - 1) continue;
                geometry.append(",");
            }
            geometry.append("]");
            if (i >= shapesArray.size() - 1) continue;
            geometry.append(",");
        }
        geometry.append("]}");
        JSONed.append("{\"type\":\"Feature\",");
        JSONed.append(properties.toString());
        JSONed.append(",");
        JSONed.append(geometry.toString());
        JSONed.append("}");
        return JSONed.toString();
    }

    private static String ImageToGeoJSONString(ShapeInfo3D shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        Point3D coord = new Point3D(shapeInfo.getModifierPosition().getX(), shapeInfo.getModifierPosition().getY(), shapeInfo.getModifierPosition().getZ());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double altitude = coord.getZ();
        double angle = shapeInfo.getModifierAngle();
        coord.setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        BufferedImage image = shapeInfo.getModifierImage();
        RendererSettings RS = RendererSettings.getInstance();
        if (image == null) {
            return "";
        }
        JSONed.append("{\"type\":\"Feature\",\"properties\":{\"image\":\"");
        JSONed.append(MultiPointHandler.bitmapToString(image));
        JSONed.append("\",\"rotation\":");
        JSONed.append(angle);
        JSONed.append(",\"angle\":");
        JSONed.append(angle);
        JSONed.append("},");
        JSONed.append("\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append(",");
        JSONed.append(altitude);
        JSONed.append("]");
        JSONed.append("}}");
        return JSONed.toString();
    }

    private static String LabelToGeoJSONString(ShapeInfo3D shapeInfo, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        StringBuilder JSONed = new StringBuilder();
        Color outlineColor = SymbolDraw.getIdealTextBackgroundColor(textColor);
        if (textBackgroundColor != null) {
            outlineColor = textBackgroundColor;
        }
        Point3D coord = new Point3D(shapeInfo.getModifierPosition().getX(), shapeInfo.getModifierPosition().getY(), shapeInfo.getModifierPosition().getZ());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double altitude = coord.getZ();
        double angle = shapeInfo.getModifierAngle();
        coord.setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        String text = shapeInfo.getModifierString();
        int justify = shapeInfo.getTextJustify();
        String strJustify = "left";
        if (justify == 0) {
            strJustify = "left";
        } else if (justify == 1) {
            strJustify = "center";
        } else if (justify == 2) {
            strJustify = "right";
        }
        RendererSettings RS = RendererSettings.getInstance();
        if (text != null && !text.equals("")) {
            JSONed.append("{\"type\":\"Feature\",\"properties\":{\"label\":\"");
            JSONed.append(text);
            JSONed.append("\",\"pointRadius\":0,\"fontColor\":\"");
            JSONed.append(RendererUtilities.colorToHexString(textColor, false));
            JSONed.append("\",\"fontSize\":\"");
            JSONed.append(String.valueOf(RS.getMPLabelFont().getSize())).append("pt\"");
            JSONed.append(",\"fontFamily\":\"");
            JSONed.append(RS.getMPLabelFont().getName());
            JSONed.append(", sans-serif");
            if (RS.getMPLabelFont().getStyle() == 1) {
                JSONed.append("\",\"fontWeight\":\"bold\"");
            } else {
                JSONed.append("\",\"fontWeight\":\"normal\"");
            }
        } else {
            return "";
        }
        JSONed.append(",\"labelAlign\":\"");
        JSONed.append(strJustify);
        JSONed.append("\",\"labelBaseline\":\"alphabetic");
        JSONed.append("\",\"labelXOffset\":0");
        JSONed.append(",\"labelYOffset\":0");
        JSONed.append(",\"labelOutlineColor\":\"");
        JSONed.append(RendererUtilities.colorToHexString(outlineColor, false));
        JSONed.append("\",\"labelOutlineWidth\":");
        JSONed.append("4");
        JSONed.append(",\"rotation\":");
        JSONed.append(angle);
        JSONed.append(",\"angle\":");
        JSONed.append(angle);
        JSONed.append("},");
        JSONed.append("\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append(",");
        JSONed.append(altitude);
        JSONed.append("]");
        JSONed.append("}}");
        return JSONed.toString();
    }

    static Boolean normalizePoints(ArrayList<Point3D> shape, IPointConversion ipc) {
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int n = shape.size();
        for (int j = 0; j < n; ++j) {
            Point2D coord = shape.get(j);
            Point2D geoCoord = ipc.PixelsToGeo(coord);
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            double latitude = geoCoord.getY();
            double longitude = geoCoord.getX();
            Point2D.Double pt2d = new Point2D.Double(longitude, latitude);
            geoCoords.add(pt2d);
        }
        Boolean normalize = MultiPointHandler.crossesIDL(geoCoords);
        return normalize;
    }
}

