/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import java.util.Optional;

public class CustomerMapper {
    private final String mapperClass;
    private final String mapper;
    private final String sourceClass;
    private final String source;
    private final String targetClass;
    private final String target;

    public CustomerMapper(String mapperClass, String sourceClass, String targetClass) {
        this.mapperClass = mapperClass;
        this.mapper = this.getName(mapperClass);
        this.sourceClass = sourceClass;
        this.source = Optional.ofNullable(sourceClass).map(this::getName).orElse(null);
        this.targetClass = targetClass;
        this.target = this.getName(targetClass);
    }

    private String getName(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public String getMapper() {
        return this.mapper;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getSource() {
        return this.source;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public String getTarget() {
        return this.target;
    }
}

