/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import io.github.opensabe.mapstruct.core.Binding;
import io.github.opensabe.mapstruct.core.MapperRepository;
import io.github.opensabe.mapstruct.processor.AbstractMapper;
import io.github.opensabe.mapstruct.processor.FreeMarkerProcessor;
import io.github.opensabe.mapstruct.processor.MapperRep;
import io.github.opensabe.mapstruct.processor.MetaDataFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@SupportedAnnotationTypes(value={"io.github.opensabe.mapstruct.core.Binding"})
public class MapperGeneratorProcessor
extends FreeMarkerProcessor {
    private Elements elementUtils;
    private Types typeUtils;
    private TypeMirror bindingMirror;
    private boolean hasBinding = true;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        TypeElement typeElement = this.elementUtils.getTypeElement(Binding.class.getName());
        if (typeElement == null) {
            this.hasBinding = false;
        } else {
            this.typeUtils = processingEnv.getTypeUtils();
            this.bindingMirror = typeElement.asType();
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.hasBinding) {
            return false;
        }
        MapperRep mappers = new MapperRep();
        if (!roundEnv.processingOver() && !annotations.isEmpty()) {
            this.messager.printNote("---- resolve annotation [io.github.opensabe.mapstruct.core.Binding] ----------");
            HashSet<? extends AbstractMapper> maps = new HashSet<AbstractMapper>();
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> beans = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : beans) {
                    List bindings = element.getAnnotationMirrors().stream().filter(m -> this.typeUtils.isSameType(m.getAnnotationType(), this.bindingMirror)).collect(Collectors.toList());
                    maps.addAll(MetaDataFactory.create(this.elementUtils, element, bindings));
                }
            }
            for (AbstractMapper abstractMapper : maps) {
                String className = abstractMapper.getPackageName() + "." + abstractMapper.getMapperName();
                this.messager.printNote("[io.github.opensabe.mapstruct.core.Binding] mapper: [%s], sourceClass : [%s], targetClass : [%s] ".formatted(abstractMapper.getMapperName(), abstractMapper.getSourceClass(), abstractMapper.getTargetClass()));
                this.writeClass(className, abstractMapper.template(), abstractMapper);
                mappers.add(abstractMapper);
            }
            if (!mappers.isEmpty()) {
                this.writeClass(MapperRepository.class.getName() + "Impl", MapperRepository.class.getSimpleName() + ".ftl", mappers);
            }
        }
        return false;
    }
}

