/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import io.github.opensabe.mapstruct.processor.AbstractMapper;
import io.github.opensabe.mapstruct.processor.CommonMapper;
import io.github.opensabe.mapstruct.processor.MapMapper;
import io.github.opensabe.mapstruct.processor.SelfMapper;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MapperRep {
    private final Set<String> targetSource = new HashSet<String>();
    private final Set<MapperPair> common = new HashSet<MapperPair>();
    private final Set<MapperPair> map = new HashSet<MapperPair>();
    private final Set<MapperPair> self = new HashSet<MapperPair>();
    private final Set<String> imports = new HashSet<String>();

    void add(AbstractMapper mapper) {
        this.targetSource.add(mapper.getSourceClass() + mapper.getTargetClass());
        AbstractMapper abstractMapper = mapper;
        Objects.requireNonNull(abstractMapper);
        AbstractMapper abstractMapper2 = abstractMapper;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SelfMapper.class, MapMapper.class, CommonMapper.class}, (Object)abstractMapper2, n)) {
            case 0: {
                SelfMapper selfMapper = (SelfMapper)abstractMapper2;
                this.self.add(new MapperPair(mapper.getMapperName(), mapper.getSourceName()));
                break;
            }
            case 1: {
                MapMapper mapMapper = (MapMapper)abstractMapper2;
                this.map.add(new MapperPair(mapper.getMapperName(), mapper.getSourceName()));
                break;
            }
            case 2: {
                CommonMapper commonMapper = (CommonMapper)abstractMapper2;
                this.common.add(new MapperPair(commonMapper.getMapperName(), commonMapper.getSourceName(), commonMapper.getTargetName()));
                break;
            }
        }
        this.imports.add(mapper.getPackageName() + "." + mapper.getMapperName());
        this.imports.add(mapper.getPackageName() + "." + mapper.getMapperName() + "Impl");
        this.imports.add(mapper.getSourceClass());
        this.imports.add(mapper.getTargetClass());
    }

    boolean contains(AbstractMapper mapper) {
        return this.targetSource.contains(mapper.getSourceClass() + mapper.getTargetClass()) || this.targetSource.contains(mapper.getTargetClass() + mapper.getSourceClass());
    }

    public Set<MapperPair> getCommon() {
        return this.common;
    }

    public Set<MapperPair> getMap() {
        return this.map;
    }

    public Set<MapperPair> getSelf() {
        return this.self;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void destroy() {
        this.targetSource.clear();
        this.common.clear();
        this.map.clear();
        this.self.clear();
        this.imports.clear();
    }

    public boolean isEmpty() {
        return this.targetSource.isEmpty() && this.common.isEmpty() && this.map.isEmpty() && this.self.isEmpty() && this.imports.isEmpty();
    }

    public static class MapperPair {
        private final String bean;
        private final String from;
        private final String to;

        public MapperPair(String bean, String from, String to) {
            this.bean = bean;
            this.from = from;
            this.to = to;
        }

        public MapperPair(String bean, String from) {
            this(bean, from, null);
        }

        public String getBean() {
            return this.bean;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }
    }
}

