/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.LinuxDevice;
import io.github.pod4dev.libpodj.model.LinuxDeviceCgroup;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.github.pod4dev.libpodj.model.Secret;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * ContainerStorageConfig contains information on the storage configuration of a container.
 */
@ApiModel(description = "ContainerStorageConfig contains information on the storage configuration of a container.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ContainerStorageConfig implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_CHROOT_DIRECTORIES = "chroot_directories";
  @SerializedName(SERIALIZED_NAME_CHROOT_DIRECTORIES)
  private List<String> chrootDirectories = null;

  public static final String SERIALIZED_NAME_CREATE_WORKING_DIR = "create_working_dir";
  @SerializedName(SERIALIZED_NAME_CREATE_WORKING_DIR)
  private Boolean createWorkingDir;

  public static final String SERIALIZED_NAME_DEVICE_CGROUP_RULE = "device_cgroup_rule";
  @SerializedName(SERIALIZED_NAME_DEVICE_CGROUP_RULE)
  private List<LinuxDeviceCgroup> deviceCgroupRule = null;

  public static final String SERIALIZED_NAME_DEVICES = "devices";
  @SerializedName(SERIALIZED_NAME_DEVICES)
  private List<LinuxDevice> devices = null;

  public static final String SERIALIZED_NAME_DEVICES_FROM = "devices_from";
  @SerializedName(SERIALIZED_NAME_DEVICES_FROM)
  private List<String> devicesFrom = null;

  public static final String SERIALIZED_NAME_HOST_DEVICE_LIST = "host_device_list";
  @SerializedName(SERIALIZED_NAME_HOST_DEVICE_LIST)
  private List<LinuxDevice> hostDeviceList = null;

  public static final String SERIALIZED_NAME_IMAGE = "image";
  @SerializedName(SERIALIZED_NAME_IMAGE)
  private String image;

  public static final String SERIALIZED_NAME_IMAGE_ARCH = "image_arch";
  @SerializedName(SERIALIZED_NAME_IMAGE_ARCH)
  private String imageArch;

  public static final String SERIALIZED_NAME_IMAGE_OS = "image_os";
  @SerializedName(SERIALIZED_NAME_IMAGE_OS)
  private String imageOs;

  public static final String SERIALIZED_NAME_IMAGE_VARIANT = "image_variant";
  @SerializedName(SERIALIZED_NAME_IMAGE_VARIANT)
  private String imageVariant;

  public static final String SERIALIZED_NAME_IMAGE_VOLUME_MODE = "image_volume_mode";
  @SerializedName(SERIALIZED_NAME_IMAGE_VOLUME_MODE)
  private String imageVolumeMode;

  public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
  @SerializedName(SERIALIZED_NAME_IMAGE_VOLUMES)
  private List<ImageVolume> imageVolumes = null;

  public static final String SERIALIZED_NAME_INIT = "init";
  @SerializedName(SERIALIZED_NAME_INIT)
  private Boolean init;

  public static final String SERIALIZED_NAME_INIT_PATH = "init_path";
  @SerializedName(SERIALIZED_NAME_INIT_PATH)
  private String initPath;

  public static final String SERIALIZED_NAME_IPCNS = "ipcns";
  @SerializedName(SERIALIZED_NAME_IPCNS)
  private Namespace ipcns;

  public static final String SERIALIZED_NAME_MOUNTS = "mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<Mount> mounts = null;

  public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
  @SerializedName(SERIALIZED_NAME_OVERLAY_VOLUMES)
  private List<OverlayVolume> overlayVolumes = null;

  public static final String SERIALIZED_NAME_RAW_IMAGE_NAME = "raw_image_name";
  @SerializedName(SERIALIZED_NAME_RAW_IMAGE_NAME)
  private String rawImageName;

  public static final String SERIALIZED_NAME_ROOTFS = "rootfs";
  @SerializedName(SERIALIZED_NAME_ROOTFS)
  private String rootfs;

  public static final String SERIALIZED_NAME_ROOTFS_MAPPING = "rootfs_mapping";
  @SerializedName(SERIALIZED_NAME_ROOTFS_MAPPING)
  private String rootfsMapping;

  public static final String SERIALIZED_NAME_ROOTFS_OVERLAY = "rootfs_overlay";
  @SerializedName(SERIALIZED_NAME_ROOTFS_OVERLAY)
  private Boolean rootfsOverlay;

  public static final String SERIALIZED_NAME_ROOTFS_PROPAGATION = "rootfs_propagation";
  @SerializedName(SERIALIZED_NAME_ROOTFS_PROPAGATION)
  private String rootfsPropagation;

  public static final String SERIALIZED_NAME_SECRETS = "secrets";
  @SerializedName(SERIALIZED_NAME_SECRETS)
  private List<Secret> secrets = null;

  public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE)
  private Long shmSize;

  public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE_SYSTEMD)
  private Long shmSizeSystemd;

  public static final String SERIALIZED_NAME_STORAGE_OPTS = "storage_opts";
  @SerializedName(SERIALIZED_NAME_STORAGE_OPTS)
  private Map<String, String> storageOpts = null;

  public static final String SERIALIZED_NAME_VOLATILE = "volatile";
  @SerializedName(SERIALIZED_NAME_VOLATILE)
  private Boolean _volatile;

  public static final String SERIALIZED_NAME_VOLUMES = "volumes";
  @SerializedName(SERIALIZED_NAME_VOLUMES)
  private List<NamedVolume> volumes = null;

  public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
  @SerializedName(SERIALIZED_NAME_VOLUMES_FROM)
  private List<String> volumesFrom = null;

  public static final String SERIALIZED_NAME_WORK_DIR = "work_dir";
  @SerializedName(SERIALIZED_NAME_WORK_DIR)
  private String workDir;

  public ContainerStorageConfig() {
  }

  public ContainerStorageConfig chrootDirectories(List<String> chrootDirectories) {
    
    this.chrootDirectories = chrootDirectories;
    return this;
  }

  public ContainerStorageConfig addChrootDirectoriesItem(String chrootDirectoriesItem) {
    if (this.chrootDirectories == null) {
      this.chrootDirectories = new ArrayList<>();
    }
    this.chrootDirectories.add(chrootDirectoriesItem);
    return this;
  }

   /**
   * ChrootDirs is an additional set of directories that need to be treated as root directories. Standard bind mounts will be mounted into paths relative to these directories. Optional.
   * @return chrootDirectories
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ChrootDirs is an additional set of directories that need to be treated as root directories. Standard bind mounts will be mounted into paths relative to these directories. Optional.")

  public List<String> getChrootDirectories() {
    return chrootDirectories;
  }


  public void setChrootDirectories(List<String> chrootDirectories) {
    this.chrootDirectories = chrootDirectories;
  }


  public ContainerStorageConfig createWorkingDir(Boolean createWorkingDir) {
    
    this.createWorkingDir = createWorkingDir;
    return this;
  }

   /**
   * Create the working directory if it doesn&#39;t exist. If unset, it doesn&#39;t create it. Optional.
   * @return createWorkingDir
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Create the working directory if it doesn't exist. If unset, it doesn't create it. Optional.")

  public Boolean getCreateWorkingDir() {
    return createWorkingDir;
  }


  public void setCreateWorkingDir(Boolean createWorkingDir) {
    this.createWorkingDir = createWorkingDir;
  }


  public ContainerStorageConfig deviceCgroupRule(List<LinuxDeviceCgroup> deviceCgroupRule) {
    
    this.deviceCgroupRule = deviceCgroupRule;
    return this;
  }

  public ContainerStorageConfig addDeviceCgroupRuleItem(LinuxDeviceCgroup deviceCgroupRuleItem) {
    if (this.deviceCgroupRule == null) {
      this.deviceCgroupRule = new ArrayList<>();
    }
    this.deviceCgroupRule.add(deviceCgroupRuleItem);
    return this;
  }

   /**
   * DeviceCgroupRule are device cgroup rules that allow containers to use additional types of devices.
   * @return deviceCgroupRule
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "DeviceCgroupRule are device cgroup rules that allow containers to use additional types of devices.")

  public List<LinuxDeviceCgroup> getDeviceCgroupRule() {
    return deviceCgroupRule;
  }


  public void setDeviceCgroupRule(List<LinuxDeviceCgroup> deviceCgroupRule) {
    this.deviceCgroupRule = deviceCgroupRule;
  }


  public ContainerStorageConfig devices(List<LinuxDevice> devices) {
    
    this.devices = devices;
    return this;
  }

  public ContainerStorageConfig addDevicesItem(LinuxDevice devicesItem) {
    if (this.devices == null) {
      this.devices = new ArrayList<>();
    }
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * Devices are devices that will be added to the container. Optional.
   * @return devices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Devices are devices that will be added to the container. Optional.")

  public List<LinuxDevice> getDevices() {
    return devices;
  }


  public void setDevices(List<LinuxDevice> devices) {
    this.devices = devices;
  }


  public ContainerStorageConfig devicesFrom(List<String> devicesFrom) {
    
    this.devicesFrom = devicesFrom;
    return this;
  }

  public ContainerStorageConfig addDevicesFromItem(String devicesFromItem) {
    if (this.devicesFrom == null) {
      this.devicesFrom = new ArrayList<>();
    }
    this.devicesFrom.add(devicesFromItem);
    return this;
  }

   /**
   * DevicesFrom specifies that this container will mount the device(s) from other container(s). Optional.
   * @return devicesFrom
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "DevicesFrom specifies that this container will mount the device(s) from other container(s). Optional.")

  public List<String> getDevicesFrom() {
    return devicesFrom;
  }


  public void setDevicesFrom(List<String> devicesFrom) {
    this.devicesFrom = devicesFrom;
  }


  public ContainerStorageConfig hostDeviceList(List<LinuxDevice> hostDeviceList) {
    
    this.hostDeviceList = hostDeviceList;
    return this;
  }

  public ContainerStorageConfig addHostDeviceListItem(LinuxDevice hostDeviceListItem) {
    if (this.hostDeviceList == null) {
      this.hostDeviceList = new ArrayList<>();
    }
    this.hostDeviceList.add(hostDeviceListItem);
    return this;
  }

   /**
   * HostDeviceList is used to recreate the mounted device on inherited containers
   * @return hostDeviceList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "HostDeviceList is used to recreate the mounted device on inherited containers")

  public List<LinuxDevice> getHostDeviceList() {
    return hostDeviceList;
  }


  public void setHostDeviceList(List<LinuxDevice> hostDeviceList) {
    this.hostDeviceList = hostDeviceList;
  }


  public ContainerStorageConfig image(String image) {
    
    this.image = image;
    return this;
  }

   /**
   * Image is the image the container will be based on. The image will be used as the container&#39;s root filesystem, and its environment vars, volumes, and other configuration will be applied to the container. Conflicts with Rootfs. At least one of Image or Rootfs must be specified.
   * @return image
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Image is the image the container will be based on. The image will be used as the container's root filesystem, and its environment vars, volumes, and other configuration will be applied to the container. Conflicts with Rootfs. At least one of Image or Rootfs must be specified.")

  public String getImage() {
    return image;
  }


  public void setImage(String image) {
    this.image = image;
  }


  public ContainerStorageConfig imageArch(String imageArch) {
    
    this.imageArch = imageArch;
    return this;
  }

   /**
   * ImageArch is the user-specified image architecture. Used to select a different variant from a manifest list. Optional.
   * @return imageArch
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ImageArch is the user-specified image architecture. Used to select a different variant from a manifest list. Optional.")

  public String getImageArch() {
    return imageArch;
  }


  public void setImageArch(String imageArch) {
    this.imageArch = imageArch;
  }


  public ContainerStorageConfig imageOs(String imageOs) {
    
    this.imageOs = imageOs;
    return this;
  }

   /**
   * ImageOS is the user-specified OS of the image. Used to select a different variant from a manifest list. Optional.
   * @return imageOs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ImageOS is the user-specified OS of the image. Used to select a different variant from a manifest list. Optional.")

  public String getImageOs() {
    return imageOs;
  }


  public void setImageOs(String imageOs) {
    this.imageOs = imageOs;
  }


  public ContainerStorageConfig imageVariant(String imageVariant) {
    
    this.imageVariant = imageVariant;
    return this;
  }

   /**
   * ImageVariant is the user-specified image variant. Used to select a different variant from a manifest list. Optional.
   * @return imageVariant
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ImageVariant is the user-specified image variant. Used to select a different variant from a manifest list. Optional.")

  public String getImageVariant() {
    return imageVariant;
  }


  public void setImageVariant(String imageVariant) {
    this.imageVariant = imageVariant;
  }


  public ContainerStorageConfig imageVolumeMode(String imageVolumeMode) {
    
    this.imageVolumeMode = imageVolumeMode;
    return this;
  }

   /**
   * ImageVolumeMode indicates how image volumes will be created. Supported modes are \&quot;ignore\&quot; (do not create), \&quot;tmpfs\&quot; (create as tmpfs), and \&quot;anonymous\&quot; (create as anonymous volumes). The default if unset is anonymous. Optional.
   * @return imageVolumeMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ImageVolumeMode indicates how image volumes will be created. Supported modes are \"ignore\" (do not create), \"tmpfs\" (create as tmpfs), and \"anonymous\" (create as anonymous volumes). The default if unset is anonymous. Optional.")

  public String getImageVolumeMode() {
    return imageVolumeMode;
  }


  public void setImageVolumeMode(String imageVolumeMode) {
    this.imageVolumeMode = imageVolumeMode;
  }


  public ContainerStorageConfig imageVolumes(List<ImageVolume> imageVolumes) {
    
    this.imageVolumes = imageVolumes;
    return this;
  }

  public ContainerStorageConfig addImageVolumesItem(ImageVolume imageVolumesItem) {
    if (this.imageVolumes == null) {
      this.imageVolumes = new ArrayList<>();
    }
    this.imageVolumes.add(imageVolumesItem);
    return this;
  }

   /**
   * Image volumes bind-mount a container-image mount into the container. Optional.
   * @return imageVolumes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Image volumes bind-mount a container-image mount into the container. Optional.")

  public List<ImageVolume> getImageVolumes() {
    return imageVolumes;
  }


  public void setImageVolumes(List<ImageVolume> imageVolumes) {
    this.imageVolumes = imageVolumes;
  }


  public ContainerStorageConfig init(Boolean init) {
    
    this.init = init;
    return this;
  }

   /**
   * Init specifies that an init binary will be mounted into the container, and will be used as PID1. Optional.
   * @return init
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Init specifies that an init binary will be mounted into the container, and will be used as PID1. Optional.")

  public Boolean getInit() {
    return init;
  }


  public void setInit(Boolean init) {
    this.init = init;
  }


  public ContainerStorageConfig initPath(String initPath) {
    
    this.initPath = initPath;
    return this;
  }

   /**
   * InitPath specifies the path to the init binary that will be added if Init is specified above. If not specified, the default set in the Libpod config will be used. Ignored if Init above is not set. Optional.
   * @return initPath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "InitPath specifies the path to the init binary that will be added if Init is specified above. If not specified, the default set in the Libpod config will be used. Ignored if Init above is not set. Optional.")

  public String getInitPath() {
    return initPath;
  }


  public void setInitPath(String initPath) {
    this.initPath = initPath;
  }


  public ContainerStorageConfig ipcns(Namespace ipcns) {
    
    this.ipcns = ipcns;
    return this;
  }

   /**
   * Get ipcns
   * @return ipcns
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public Namespace getIpcns() {
    return ipcns;
  }


  public void setIpcns(Namespace ipcns) {
    this.ipcns = ipcns;
  }


  public ContainerStorageConfig mounts(List<Mount> mounts) {
    
    this.mounts = mounts;
    return this;
  }

  public ContainerStorageConfig addMountsItem(Mount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

   /**
   * Mounts are mounts that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.
   * @return mounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Mounts are mounts that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.")

  public List<Mount> getMounts() {
    return mounts;
  }


  public void setMounts(List<Mount> mounts) {
    this.mounts = mounts;
  }


  public ContainerStorageConfig overlayVolumes(List<OverlayVolume> overlayVolumes) {
    
    this.overlayVolumes = overlayVolumes;
    return this;
  }

  public ContainerStorageConfig addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
    if (this.overlayVolumes == null) {
      this.overlayVolumes = new ArrayList<>();
    }
    this.overlayVolumes.add(overlayVolumesItem);
    return this;
  }

   /**
   * Overlay volumes are named volumes that will be added to the container. Optional.
   * @return overlayVolumes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Overlay volumes are named volumes that will be added to the container. Optional.")

  public List<OverlayVolume> getOverlayVolumes() {
    return overlayVolumes;
  }


  public void setOverlayVolumes(List<OverlayVolume> overlayVolumes) {
    this.overlayVolumes = overlayVolumes;
  }


  public ContainerStorageConfig rawImageName(String rawImageName) {
    
    this.rawImageName = rawImageName;
    return this;
  }

   /**
   * RawImageName is the user-specified and unprocessed input referring to a local or a remote image. Optional, but strongly encouraged to be set if Image is set.
   * @return rawImageName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RawImageName is the user-specified and unprocessed input referring to a local or a remote image. Optional, but strongly encouraged to be set if Image is set.")

  public String getRawImageName() {
    return rawImageName;
  }


  public void setRawImageName(String rawImageName) {
    this.rawImageName = rawImageName;
  }


  public ContainerStorageConfig rootfs(String rootfs) {
    
    this.rootfs = rootfs;
    return this;
  }

   /**
   * Rootfs is the path to a directory that will be used as the container&#39;s root filesystem. No modification will be made to the directory, it will be directly mounted into the container as root. Conflicts with Image. At least one of Image or Rootfs must be specified.
   * @return rootfs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Rootfs is the path to a directory that will be used as the container's root filesystem. No modification will be made to the directory, it will be directly mounted into the container as root. Conflicts with Image. At least one of Image or Rootfs must be specified.")

  public String getRootfs() {
    return rootfs;
  }


  public void setRootfs(String rootfs) {
    this.rootfs = rootfs;
  }


  public ContainerStorageConfig rootfsMapping(String rootfsMapping) {
    
    this.rootfsMapping = rootfsMapping;
    return this;
  }

   /**
   * RootfsMapping specifies if there are UID/GID mappings to apply to the rootfs. Optional.
   * @return rootfsMapping
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RootfsMapping specifies if there are UID/GID mappings to apply to the rootfs. Optional.")

  public String getRootfsMapping() {
    return rootfsMapping;
  }


  public void setRootfsMapping(String rootfsMapping) {
    this.rootfsMapping = rootfsMapping;
  }


  public ContainerStorageConfig rootfsOverlay(Boolean rootfsOverlay) {
    
    this.rootfsOverlay = rootfsOverlay;
    return this;
  }

   /**
   * RootfsOverlay tells if rootfs is actually an overlay on top of base path. Optional.
   * @return rootfsOverlay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RootfsOverlay tells if rootfs is actually an overlay on top of base path. Optional.")

  public Boolean getRootfsOverlay() {
    return rootfsOverlay;
  }


  public void setRootfsOverlay(Boolean rootfsOverlay) {
    this.rootfsOverlay = rootfsOverlay;
  }


  public ContainerStorageConfig rootfsPropagation(String rootfsPropagation) {
    
    this.rootfsPropagation = rootfsPropagation;
    return this;
  }

   /**
   * RootfsPropagation is the rootfs propagation mode for the container. If not set, the default of rslave will be used. Optional.
   * @return rootfsPropagation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RootfsPropagation is the rootfs propagation mode for the container. If not set, the default of rslave will be used. Optional.")

  public String getRootfsPropagation() {
    return rootfsPropagation;
  }


  public void setRootfsPropagation(String rootfsPropagation) {
    this.rootfsPropagation = rootfsPropagation;
  }


  public ContainerStorageConfig secrets(List<Secret> secrets) {
    
    this.secrets = secrets;
    return this;
  }

  public ContainerStorageConfig addSecretsItem(Secret secretsItem) {
    if (this.secrets == null) {
      this.secrets = new ArrayList<>();
    }
    this.secrets.add(secretsItem);
    return this;
  }

   /**
   * Secrets are the secrets that will be added to the container Optional.
   * @return secrets
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Secrets are the secrets that will be added to the container Optional.")

  public List<Secret> getSecrets() {
    return secrets;
  }


  public void setSecrets(List<Secret> secrets) {
    this.secrets = secrets;
  }


  public ContainerStorageConfig shmSize(Long shmSize) {
    
    this.shmSize = shmSize;
    return this;
  }

   /**
   * ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.
   * @return shmSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.")

  public Long getShmSize() {
    return shmSize;
  }


  public void setShmSize(Long shmSize) {
    this.shmSize = shmSize;
  }


  public ContainerStorageConfig shmSizeSystemd(Long shmSizeSystemd) {
    
    this.shmSizeSystemd = shmSizeSystemd;
    return this;
  }

   /**
   * ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional
   * @return shmSizeSystemd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional")

  public Long getShmSizeSystemd() {
    return shmSizeSystemd;
  }


  public void setShmSizeSystemd(Long shmSizeSystemd) {
    this.shmSizeSystemd = shmSizeSystemd;
  }


  public ContainerStorageConfig storageOpts(Map<String, String> storageOpts) {
    
    this.storageOpts = storageOpts;
    return this;
  }

  public ContainerStorageConfig putStorageOptsItem(String key, String storageOptsItem) {
    if (this.storageOpts == null) {
      this.storageOpts = new HashMap<>();
    }
    this.storageOpts.put(key, storageOptsItem);
    return this;
  }

   /**
   * StorageOpts is the container&#39;s storage options Optional.
   * @return storageOpts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "StorageOpts is the container's storage options Optional.")

  public Map<String, String> getStorageOpts() {
    return storageOpts;
  }


  public void setStorageOpts(Map<String, String> storageOpts) {
    this.storageOpts = storageOpts;
  }


  public ContainerStorageConfig _volatile(Boolean _volatile) {
    
    this._volatile = _volatile;
    return this;
  }

   /**
   * Volatile specifies whether the container storage can be optimized at the cost of not syncing all the dirty files in memory. Optional.
   * @return _volatile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Volatile specifies whether the container storage can be optimized at the cost of not syncing all the dirty files in memory. Optional.")

  public Boolean getVolatile() {
    return _volatile;
  }


  public void setVolatile(Boolean _volatile) {
    this._volatile = _volatile;
  }


  public ContainerStorageConfig volumes(List<NamedVolume> volumes) {
    
    this.volumes = volumes;
    return this;
  }

  public ContainerStorageConfig addVolumesItem(NamedVolume volumesItem) {
    if (this.volumes == null) {
      this.volumes = new ArrayList<>();
    }
    this.volumes.add(volumesItem);
    return this;
  }

   /**
   * Volumes are named volumes that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.
   * @return volumes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Volumes are named volumes that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.")

  public List<NamedVolume> getVolumes() {
    return volumes;
  }


  public void setVolumes(List<NamedVolume> volumes) {
    this.volumes = volumes;
  }


  public ContainerStorageConfig volumesFrom(List<String> volumesFrom) {
    
    this.volumesFrom = volumesFrom;
    return this;
  }

  public ContainerStorageConfig addVolumesFromItem(String volumesFromItem) {
    if (this.volumesFrom == null) {
      this.volumesFrom = new ArrayList<>();
    }
    this.volumesFrom.add(volumesFromItem);
    return this;
  }

   /**
   * VolumesFrom is a set of containers whose volumes will be added to this container. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are &#39;ro&#39;, &#39;rw&#39;, and &#39;z&#39;. Options will be used for all volumes sourced from the container. Optional.
   * @return volumesFrom
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "VolumesFrom is a set of containers whose volumes will be added to this container. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are 'ro', 'rw', and 'z'. Options will be used for all volumes sourced from the container. Optional.")

  public List<String> getVolumesFrom() {
    return volumesFrom;
  }


  public void setVolumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
  }


  public ContainerStorageConfig workDir(String workDir) {
    
    this.workDir = workDir;
    return this;
  }

   /**
   * WorkDir is the container&#39;s working directory. If unset, the default, /, will be used. Optional.
   * @return workDir
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "WorkDir is the container's working directory. If unset, the default, /, will be used. Optional.")

  public String getWorkDir() {
    return workDir;
  }


  public void setWorkDir(String workDir) {
    this.workDir = workDir;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContainerStorageConfig containerStorageConfig = (ContainerStorageConfig) o;
    return Objects.equals(this.chrootDirectories, containerStorageConfig.chrootDirectories) &&
        Objects.equals(this.createWorkingDir, containerStorageConfig.createWorkingDir) &&
        Objects.equals(this.deviceCgroupRule, containerStorageConfig.deviceCgroupRule) &&
        Objects.equals(this.devices, containerStorageConfig.devices) &&
        Objects.equals(this.devicesFrom, containerStorageConfig.devicesFrom) &&
        Objects.equals(this.hostDeviceList, containerStorageConfig.hostDeviceList) &&
        Objects.equals(this.image, containerStorageConfig.image) &&
        Objects.equals(this.imageArch, containerStorageConfig.imageArch) &&
        Objects.equals(this.imageOs, containerStorageConfig.imageOs) &&
        Objects.equals(this.imageVariant, containerStorageConfig.imageVariant) &&
        Objects.equals(this.imageVolumeMode, containerStorageConfig.imageVolumeMode) &&
        Objects.equals(this.imageVolumes, containerStorageConfig.imageVolumes) &&
        Objects.equals(this.init, containerStorageConfig.init) &&
        Objects.equals(this.initPath, containerStorageConfig.initPath) &&
        Objects.equals(this.ipcns, containerStorageConfig.ipcns) &&
        Objects.equals(this.mounts, containerStorageConfig.mounts) &&
        Objects.equals(this.overlayVolumes, containerStorageConfig.overlayVolumes) &&
        Objects.equals(this.rawImageName, containerStorageConfig.rawImageName) &&
        Objects.equals(this.rootfs, containerStorageConfig.rootfs) &&
        Objects.equals(this.rootfsMapping, containerStorageConfig.rootfsMapping) &&
        Objects.equals(this.rootfsOverlay, containerStorageConfig.rootfsOverlay) &&
        Objects.equals(this.rootfsPropagation, containerStorageConfig.rootfsPropagation) &&
        Objects.equals(this.secrets, containerStorageConfig.secrets) &&
        Objects.equals(this.shmSize, containerStorageConfig.shmSize) &&
        Objects.equals(this.shmSizeSystemd, containerStorageConfig.shmSizeSystemd) &&
        Objects.equals(this.storageOpts, containerStorageConfig.storageOpts) &&
        Objects.equals(this._volatile, containerStorageConfig._volatile) &&
        Objects.equals(this.volumes, containerStorageConfig.volumes) &&
        Objects.equals(this.volumesFrom, containerStorageConfig.volumesFrom) &&
        Objects.equals(this.workDir, containerStorageConfig.workDir);
  }

  @Override
  public int hashCode() {
    return Objects.hash(chrootDirectories, createWorkingDir, deviceCgroupRule, devices, devicesFrom, hostDeviceList, image, imageArch, imageOs, imageVariant, imageVolumeMode, imageVolumes, init, initPath, ipcns, mounts, overlayVolumes, rawImageName, rootfs, rootfsMapping, rootfsOverlay, rootfsPropagation, secrets, shmSize, shmSizeSystemd, storageOpts, _volatile, volumes, volumesFrom, workDir);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContainerStorageConfig {\n");
    sb.append("    chrootDirectories: ").append(toIndentedString(chrootDirectories)).append("\n");
    sb.append("    createWorkingDir: ").append(toIndentedString(createWorkingDir)).append("\n");
    sb.append("    deviceCgroupRule: ").append(toIndentedString(deviceCgroupRule)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    devicesFrom: ").append(toIndentedString(devicesFrom)).append("\n");
    sb.append("    hostDeviceList: ").append(toIndentedString(hostDeviceList)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    imageArch: ").append(toIndentedString(imageArch)).append("\n");
    sb.append("    imageOs: ").append(toIndentedString(imageOs)).append("\n");
    sb.append("    imageVariant: ").append(toIndentedString(imageVariant)).append("\n");
    sb.append("    imageVolumeMode: ").append(toIndentedString(imageVolumeMode)).append("\n");
    sb.append("    imageVolumes: ").append(toIndentedString(imageVolumes)).append("\n");
    sb.append("    init: ").append(toIndentedString(init)).append("\n");
    sb.append("    initPath: ").append(toIndentedString(initPath)).append("\n");
    sb.append("    ipcns: ").append(toIndentedString(ipcns)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    overlayVolumes: ").append(toIndentedString(overlayVolumes)).append("\n");
    sb.append("    rawImageName: ").append(toIndentedString(rawImageName)).append("\n");
    sb.append("    rootfs: ").append(toIndentedString(rootfs)).append("\n");
    sb.append("    rootfsMapping: ").append(toIndentedString(rootfsMapping)).append("\n");
    sb.append("    rootfsOverlay: ").append(toIndentedString(rootfsOverlay)).append("\n");
    sb.append("    rootfsPropagation: ").append(toIndentedString(rootfsPropagation)).append("\n");
    sb.append("    secrets: ").append(toIndentedString(secrets)).append("\n");
    sb.append("    shmSize: ").append(toIndentedString(shmSize)).append("\n");
    sb.append("    shmSizeSystemd: ").append(toIndentedString(shmSizeSystemd)).append("\n");
    sb.append("    storageOpts: ").append(toIndentedString(storageOpts)).append("\n");
    sb.append("    _volatile: ").append(toIndentedString(_volatile)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("    volumesFrom: ").append(toIndentedString(volumesFrom)).append("\n");
    sb.append("    workDir: ").append(toIndentedString(workDir)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("chroot_directories");
    openapiFields.add("create_working_dir");
    openapiFields.add("device_cgroup_rule");
    openapiFields.add("devices");
    openapiFields.add("devices_from");
    openapiFields.add("host_device_list");
    openapiFields.add("image");
    openapiFields.add("image_arch");
    openapiFields.add("image_os");
    openapiFields.add("image_variant");
    openapiFields.add("image_volume_mode");
    openapiFields.add("image_volumes");
    openapiFields.add("init");
    openapiFields.add("init_path");
    openapiFields.add("ipcns");
    openapiFields.add("mounts");
    openapiFields.add("overlay_volumes");
    openapiFields.add("raw_image_name");
    openapiFields.add("rootfs");
    openapiFields.add("rootfs_mapping");
    openapiFields.add("rootfs_overlay");
    openapiFields.add("rootfs_propagation");
    openapiFields.add("secrets");
    openapiFields.add("shm_size");
    openapiFields.add("shm_size_systemd");
    openapiFields.add("storage_opts");
    openapiFields.add("volatile");
    openapiFields.add("volumes");
    openapiFields.add("volumes_from");
    openapiFields.add("work_dir");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ContainerStorageConfig
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ContainerStorageConfig.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerStorageConfig is not found in the empty JSON string", ContainerStorageConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ContainerStorageConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerStorageConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("chroot_directories") != null && !jsonObj.get("chroot_directories").isJsonNull()) && !jsonObj.get("chroot_directories").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `chroot_directories` to be an array in the JSON string but got `%s`", jsonObj.get("chroot_directories").toString()));
      }
      if (jsonObj.get("device_cgroup_rule") != null && !jsonObj.get("device_cgroup_rule").isJsonNull()) {
        JsonArray jsonArraydeviceCgroupRule = jsonObj.getAsJsonArray("device_cgroup_rule");
        if (jsonArraydeviceCgroupRule != null) {
          // ensure the json data is an array
          if (!jsonObj.get("device_cgroup_rule").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `device_cgroup_rule` to be an array in the JSON string but got `%s`", jsonObj.get("device_cgroup_rule").toString()));
          }

          // validate the optional field `device_cgroup_rule` (array)
          for (int i = 0; i < jsonArraydeviceCgroupRule.size(); i++) {
            LinuxDeviceCgroup.validateJsonObject(jsonArraydeviceCgroupRule.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("devices") != null && !jsonObj.get("devices").isJsonNull()) {
        JsonArray jsonArraydevices = jsonObj.getAsJsonArray("devices");
        if (jsonArraydevices != null) {
          // ensure the json data is an array
          if (!jsonObj.get("devices").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get("devices").toString()));
          }

          // validate the optional field `devices` (array)
          for (int i = 0; i < jsonArraydevices.size(); i++) {
            LinuxDevice.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("devices_from") != null && !jsonObj.get("devices_from").isJsonNull()) && !jsonObj.get("devices_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `devices_from` to be an array in the JSON string but got `%s`", jsonObj.get("devices_from").toString()));
      }
      if (jsonObj.get("host_device_list") != null && !jsonObj.get("host_device_list").isJsonNull()) {
        JsonArray jsonArrayhostDeviceList = jsonObj.getAsJsonArray("host_device_list");
        if (jsonArrayhostDeviceList != null) {
          // ensure the json data is an array
          if (!jsonObj.get("host_device_list").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `host_device_list` to be an array in the JSON string but got `%s`", jsonObj.get("host_device_list").toString()));
          }

          // validate the optional field `host_device_list` (array)
          for (int i = 0; i < jsonArrayhostDeviceList.size(); i++) {
            LinuxDevice.validateJsonObject(jsonArrayhostDeviceList.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("image") != null && !jsonObj.get("image").isJsonNull()) && !jsonObj.get("image").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image").toString()));
      }
      if ((jsonObj.get("image_arch") != null && !jsonObj.get("image_arch").isJsonNull()) && !jsonObj.get("image_arch").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_arch` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_arch").toString()));
      }
      if ((jsonObj.get("image_os") != null && !jsonObj.get("image_os").isJsonNull()) && !jsonObj.get("image_os").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_os` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_os").toString()));
      }
      if ((jsonObj.get("image_variant") != null && !jsonObj.get("image_variant").isJsonNull()) && !jsonObj.get("image_variant").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_variant").toString()));
      }
      if ((jsonObj.get("image_volume_mode") != null && !jsonObj.get("image_volume_mode").isJsonNull()) && !jsonObj.get("image_volume_mode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_volume_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_volume_mode").toString()));
      }
      if (jsonObj.get("image_volumes") != null && !jsonObj.get("image_volumes").isJsonNull()) {
        JsonArray jsonArrayimageVolumes = jsonObj.getAsJsonArray("image_volumes");
        if (jsonArrayimageVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("image_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("image_volumes").toString()));
          }

          // validate the optional field `image_volumes` (array)
          for (int i = 0; i < jsonArrayimageVolumes.size(); i++) {
            ImageVolume.validateJsonObject(jsonArrayimageVolumes.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("init_path") != null && !jsonObj.get("init_path").isJsonNull()) && !jsonObj.get("init_path").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `init_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get("init_path").toString()));
      }
      // validate the optional field `ipcns`
      if (jsonObj.get("ipcns") != null && !jsonObj.get("ipcns").isJsonNull()) {
        Namespace.validateJsonObject(jsonObj.getAsJsonObject("ipcns"));
      }
      if (jsonObj.get("mounts") != null && !jsonObj.get("mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get("mounts").toString()));
          }

          // validate the optional field `mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            Mount.validateJsonObject(jsonArraymounts.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("overlay_volumes") != null && !jsonObj.get("overlay_volumes").isJsonNull()) {
        JsonArray jsonArrayoverlayVolumes = jsonObj.getAsJsonArray("overlay_volumes");
        if (jsonArrayoverlayVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("overlay_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("overlay_volumes").toString()));
          }

          // validate the optional field `overlay_volumes` (array)
          for (int i = 0; i < jsonArrayoverlayVolumes.size(); i++) {
            OverlayVolume.validateJsonObject(jsonArrayoverlayVolumes.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("raw_image_name") != null && !jsonObj.get("raw_image_name").isJsonNull()) && !jsonObj.get("raw_image_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `raw_image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("raw_image_name").toString()));
      }
      if ((jsonObj.get("rootfs") != null && !jsonObj.get("rootfs").isJsonNull()) && !jsonObj.get("rootfs").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rootfs` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rootfs").toString()));
      }
      if ((jsonObj.get("rootfs_mapping") != null && !jsonObj.get("rootfs_mapping").isJsonNull()) && !jsonObj.get("rootfs_mapping").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rootfs_mapping` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rootfs_mapping").toString()));
      }
      if ((jsonObj.get("rootfs_propagation") != null && !jsonObj.get("rootfs_propagation").isJsonNull()) && !jsonObj.get("rootfs_propagation").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rootfs_propagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rootfs_propagation").toString()));
      }
      if (jsonObj.get("secrets") != null && !jsonObj.get("secrets").isJsonNull()) {
        JsonArray jsonArraysecrets = jsonObj.getAsJsonArray("secrets");
        if (jsonArraysecrets != null) {
          // ensure the json data is an array
          if (!jsonObj.get("secrets").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `secrets` to be an array in the JSON string but got `%s`", jsonObj.get("secrets").toString()));
          }

          // validate the optional field `secrets` (array)
          for (int i = 0; i < jsonArraysecrets.size(); i++) {
            Secret.validateJsonObject(jsonArraysecrets.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("volumes") != null && !jsonObj.get("volumes").isJsonNull()) {
        JsonArray jsonArrayvolumes = jsonObj.getAsJsonArray("volumes");
        if (jsonArrayvolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get("volumes").toString()));
          }

          // validate the optional field `volumes` (array)
          for (int i = 0; i < jsonArrayvolumes.size(); i++) {
            NamedVolume.validateJsonObject(jsonArrayvolumes.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("volumes_from") != null && !jsonObj.get("volumes_from").isJsonNull()) && !jsonObj.get("volumes_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get("volumes_from").toString()));
      }
      if ((jsonObj.get("work_dir") != null && !jsonObj.get("work_dir").isJsonNull()) && !jsonObj.get("work_dir").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `work_dir` to be a primitive type in the JSON string but got `%s`", jsonObj.get("work_dir").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ContainerStorageConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ContainerStorageConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ContainerStorageConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ContainerStorageConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<ContainerStorageConfig>() {
           @Override
           public void write(JsonWriter out, ContainerStorageConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ContainerStorageConfig read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ContainerStorageConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ContainerStorageConfig
  * @throws IOException if the JSON string is invalid with respect to ContainerStorageConfig
  */
  public static ContainerStorageConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ContainerStorageConfig.class);
  }

 /**
  * Convert an instance of ContainerStorageConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

