/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.InspectBlkioThrottleDevice;
import io.github.pod4dev.libpodj.model.InspectBlkioWeightDevice;
import io.github.pod4dev.libpodj.model.InspectDevice;
import io.github.pod4dev.libpodj.model.InspectMount;
import io.github.pod4dev.libpodj.model.InspectPodContainerInfo;
import io.github.pod4dev.libpodj.model.InspectPodInfraConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * InspectPodData contains detailed information on a pod&#39;s configuration and state. It is used as the output of Inspect on pods.
 */
@ApiModel(description = "InspectPodData contains detailed information on a pod's configuration and state. It is used as the output of Inspect on pods.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class InspectPodData implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_CGROUP_PARENT = "CgroupParent";
  @SerializedName(SERIALIZED_NAME_CGROUP_PARENT)
  private String cgroupParent;

  public static final String SERIALIZED_NAME_CGROUP_PATH = "CgroupPath";
  @SerializedName(SERIALIZED_NAME_CGROUP_PATH)
  private String cgroupPath;

  public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
  @SerializedName(SERIALIZED_NAME_CONTAINERS)
  private List<InspectPodContainerInfo> containers = null;

  public static final String SERIALIZED_NAME_CREATE_CGROUP = "CreateCgroup";
  @SerializedName(SERIALIZED_NAME_CREATE_CGROUP)
  private Boolean createCgroup;

  public static final String SERIALIZED_NAME_CREATE_COMMAND = "CreateCommand";
  @SerializedName(SERIALIZED_NAME_CREATE_COMMAND)
  private List<String> createCommand = null;

  public static final String SERIALIZED_NAME_CREATE_INFRA = "CreateInfra";
  @SerializedName(SERIALIZED_NAME_CREATE_INFRA)
  private Boolean createInfra;

  public static final String SERIALIZED_NAME_CREATED = "Created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private OffsetDateTime created;

  public static final String SERIALIZED_NAME_EXIT_POLICY = "ExitPolicy";
  @SerializedName(SERIALIZED_NAME_EXIT_POLICY)
  private String exitPolicy;

  public static final String SERIALIZED_NAME_HOSTNAME = "Hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_ID = "Id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INFRA_CONFIG = "InfraConfig";
  @SerializedName(SERIALIZED_NAME_INFRA_CONFIG)
  private InspectPodInfraConfig infraConfig;

  public static final String SERIALIZED_NAME_INFRA_CONTAINER_I_D = "InfraContainerID";
  @SerializedName(SERIALIZED_NAME_INFRA_CONTAINER_I_D)
  private String infraContainerID;

  public static final String SERIALIZED_NAME_LABELS = "Labels";
  @SerializedName(SERIALIZED_NAME_LABELS)
  private Map<String, String> labels = null;

  public static final String SERIALIZED_NAME_LOCK_NUMBER = "LockNumber";
  @SerializedName(SERIALIZED_NAME_LOCK_NUMBER)
  private Integer lockNumber;

  public static final String SERIALIZED_NAME_NAME = "Name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NAMESPACE = "Namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_NUM_CONTAINERS = "NumContainers";
  @SerializedName(SERIALIZED_NAME_NUM_CONTAINERS)
  private Integer numContainers;

  public static final String SERIALIZED_NAME_RESTART_POLICY = "RestartPolicy";
  @SerializedName(SERIALIZED_NAME_RESTART_POLICY)
  private String restartPolicy;

  public static final String SERIALIZED_NAME_SHARED_NAMESPACES = "SharedNamespaces";
  @SerializedName(SERIALIZED_NAME_SHARED_NAMESPACES)
  private List<String> sharedNamespaces = null;

  public static final String SERIALIZED_NAME_STATE = "State";
  @SerializedName(SERIALIZED_NAME_STATE)
  private String state;

  public static final String SERIALIZED_NAME_BLKIO_WEIGHT = "blkio_weight";
  @SerializedName(SERIALIZED_NAME_BLKIO_WEIGHT)
  private Integer blkioWeight;

  public static final String SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE = "blkio_weight_device";
  @SerializedName(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE)
  private List<InspectBlkioWeightDevice> blkioWeightDevice = null;

  public static final String SERIALIZED_NAME_CPU_PERIOD = "cpu_period";
  @SerializedName(SERIALIZED_NAME_CPU_PERIOD)
  private Integer cpuPeriod;

  public static final String SERIALIZED_NAME_CPU_QUOTA = "cpu_quota";
  @SerializedName(SERIALIZED_NAME_CPU_QUOTA)
  private Long cpuQuota;

  public static final String SERIALIZED_NAME_CPU_SHARES = "cpu_shares";
  @SerializedName(SERIALIZED_NAME_CPU_SHARES)
  private Integer cpuShares;

  public static final String SERIALIZED_NAME_CPUSET_CPUS = "cpuset_cpus";
  @SerializedName(SERIALIZED_NAME_CPUSET_CPUS)
  private String cpusetCpus;

  public static final String SERIALIZED_NAME_CPUSET_MEMS = "cpuset_mems";
  @SerializedName(SERIALIZED_NAME_CPUSET_MEMS)
  private String cpusetMems;

  public static final String SERIALIZED_NAME_DEVICE_READ_BPS = "device_read_bps";
  @SerializedName(SERIALIZED_NAME_DEVICE_READ_BPS)
  private List<InspectBlkioThrottleDevice> deviceReadBps = null;

  public static final String SERIALIZED_NAME_DEVICE_WRITE_BPS = "device_write_bps";
  @SerializedName(SERIALIZED_NAME_DEVICE_WRITE_BPS)
  private List<InspectBlkioThrottleDevice> deviceWriteBps = null;

  public static final String SERIALIZED_NAME_DEVICES = "devices";
  @SerializedName(SERIALIZED_NAME_DEVICES)
  private List<InspectDevice> devices = null;

  public static final String SERIALIZED_NAME_MEMORY_LIMIT = "memory_limit";
  @SerializedName(SERIALIZED_NAME_MEMORY_LIMIT)
  private Integer memoryLimit;

  public static final String SERIALIZED_NAME_MEMORY_SWAP = "memory_swap";
  @SerializedName(SERIALIZED_NAME_MEMORY_SWAP)
  private Integer memorySwap;

  public static final String SERIALIZED_NAME_MOUNTS = "mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<InspectMount> mounts = null;

  public static final String SERIALIZED_NAME_SECURITY_OPT = "security_opt";
  @SerializedName(SERIALIZED_NAME_SECURITY_OPT)
  private List<String> securityOpt = null;

  public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
  @SerializedName(SERIALIZED_NAME_VOLUMES_FROM)
  private List<String> volumesFrom = null;

  public InspectPodData() {
  }

  public InspectPodData cgroupParent(String cgroupParent) {
    
    this.cgroupParent = cgroupParent;
    return this;
  }

   /**
   * CgroupParent is the parent of the pod&#39;s Cgroup.
   * @return cgroupParent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CgroupParent is the parent of the pod's Cgroup.")

  public String getCgroupParent() {
    return cgroupParent;
  }


  public void setCgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
  }


  public InspectPodData cgroupPath(String cgroupPath) {
    
    this.cgroupPath = cgroupPath;
    return this;
  }

   /**
   * CgroupPath is the path to the pod&#39;s Cgroup.
   * @return cgroupPath
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CgroupPath is the path to the pod's Cgroup.")

  public String getCgroupPath() {
    return cgroupPath;
  }


  public void setCgroupPath(String cgroupPath) {
    this.cgroupPath = cgroupPath;
  }


  public InspectPodData containers(List<InspectPodContainerInfo> containers) {
    
    this.containers = containers;
    return this;
  }

  public InspectPodData addContainersItem(InspectPodContainerInfo containersItem) {
    if (this.containers == null) {
      this.containers = new ArrayList<>();
    }
    this.containers.add(containersItem);
    return this;
  }

   /**
   * Containers gives a brief summary of all containers in the pod and their current status.
   * @return containers
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Containers gives a brief summary of all containers in the pod and their current status.")

  public List<InspectPodContainerInfo> getContainers() {
    return containers;
  }


  public void setContainers(List<InspectPodContainerInfo> containers) {
    this.containers = containers;
  }


  public InspectPodData createCgroup(Boolean createCgroup) {
    
    this.createCgroup = createCgroup;
    return this;
  }

   /**
   * CreateCgroup is whether this pod will create its own Cgroup to group containers under.
   * @return createCgroup
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CreateCgroup is whether this pod will create its own Cgroup to group containers under.")

  public Boolean getCreateCgroup() {
    return createCgroup;
  }


  public void setCreateCgroup(Boolean createCgroup) {
    this.createCgroup = createCgroup;
  }


  public InspectPodData createCommand(List<String> createCommand) {
    
    this.createCommand = createCommand;
    return this;
  }

  public InspectPodData addCreateCommandItem(String createCommandItem) {
    if (this.createCommand == null) {
      this.createCommand = new ArrayList<>();
    }
    this.createCommand.add(createCommandItem);
    return this;
  }

   /**
   * CreateCommand is the full command plus arguments of the process the container has been created with.
   * @return createCommand
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CreateCommand is the full command plus arguments of the process the container has been created with.")

  public List<String> getCreateCommand() {
    return createCommand;
  }


  public void setCreateCommand(List<String> createCommand) {
    this.createCommand = createCommand;
  }


  public InspectPodData createInfra(Boolean createInfra) {
    
    this.createInfra = createInfra;
    return this;
  }

   /**
   * CreateInfra is whether this pod will create an infra container to share namespaces.
   * @return createInfra
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CreateInfra is whether this pod will create an infra container to share namespaces.")

  public Boolean getCreateInfra() {
    return createInfra;
  }


  public void setCreateInfra(Boolean createInfra) {
    this.createInfra = createInfra;
  }


  public InspectPodData created(OffsetDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Created is the time when the pod was created.
   * @return created
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Created is the time when the pod was created.")

  public OffsetDateTime getCreated() {
    return created;
  }


  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }


  public InspectPodData exitPolicy(String exitPolicy) {
    
    this.exitPolicy = exitPolicy;
    return this;
  }

   /**
   * ExitPolicy of the pod.
   * @return exitPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ExitPolicy of the pod.")

  public String getExitPolicy() {
    return exitPolicy;
  }


  public void setExitPolicy(String exitPolicy) {
    this.exitPolicy = exitPolicy;
  }


  public InspectPodData hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   * Hostname is the hostname that the pod will set.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Hostname is the hostname that the pod will set.")

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public InspectPodData id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * ID is the ID of the pod.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ID is the ID of the pod.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public InspectPodData infraConfig(InspectPodInfraConfig infraConfig) {
    
    this.infraConfig = infraConfig;
    return this;
  }

   /**
   * Get infraConfig
   * @return infraConfig
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public InspectPodInfraConfig getInfraConfig() {
    return infraConfig;
  }


  public void setInfraConfig(InspectPodInfraConfig infraConfig) {
    this.infraConfig = infraConfig;
  }


  public InspectPodData infraContainerID(String infraContainerID) {
    
    this.infraContainerID = infraContainerID;
    return this;
  }

   /**
   * InfraContainerID is the ID of the pod&#39;s infra container, if one is present.
   * @return infraContainerID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "InfraContainerID is the ID of the pod's infra container, if one is present.")

  public String getInfraContainerID() {
    return infraContainerID;
  }


  public void setInfraContainerID(String infraContainerID) {
    this.infraContainerID = infraContainerID;
  }


  public InspectPodData labels(Map<String, String> labels) {
    
    this.labels = labels;
    return this;
  }

  public InspectPodData putLabelsItem(String key, String labelsItem) {
    if (this.labels == null) {
      this.labels = new HashMap<>();
    }
    this.labels.put(key, labelsItem);
    return this;
  }

   /**
   * Labels is a set of key-value labels that have been applied to the pod.
   * @return labels
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Labels is a set of key-value labels that have been applied to the pod.")

  public Map<String, String> getLabels() {
    return labels;
  }


  public void setLabels(Map<String, String> labels) {
    this.labels = labels;
  }


  public InspectPodData lockNumber(Integer lockNumber) {
    
    this.lockNumber = lockNumber;
    return this;
  }

   /**
   * Number of the pod&#39;s Libpod lock.
   * @return lockNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of the pod's Libpod lock.")

  public Integer getLockNumber() {
    return lockNumber;
  }


  public void setLockNumber(Integer lockNumber) {
    this.lockNumber = lockNumber;
  }


  public InspectPodData name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name is the name of the pod.
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name is the name of the pod.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public InspectPodData namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * Namespace is the Libpod namespace the pod is placed in.
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Namespace is the Libpod namespace the pod is placed in.")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public InspectPodData numContainers(Integer numContainers) {
    
    this.numContainers = numContainers;
    return this;
  }

   /**
   * NumContainers is the number of containers in the pod, including the infra container.
   * @return numContainers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "NumContainers is the number of containers in the pod, including the infra container.")

  public Integer getNumContainers() {
    return numContainers;
  }


  public void setNumContainers(Integer numContainers) {
    this.numContainers = numContainers;
  }


  public InspectPodData restartPolicy(String restartPolicy) {
    
    this.restartPolicy = restartPolicy;
    return this;
  }

   /**
   * RestartPolicy of the pod.
   * @return restartPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RestartPolicy of the pod.")

  public String getRestartPolicy() {
    return restartPolicy;
  }


  public void setRestartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
  }


  public InspectPodData sharedNamespaces(List<String> sharedNamespaces) {
    
    this.sharedNamespaces = sharedNamespaces;
    return this;
  }

  public InspectPodData addSharedNamespacesItem(String sharedNamespacesItem) {
    if (this.sharedNamespaces == null) {
      this.sharedNamespaces = new ArrayList<>();
    }
    this.sharedNamespaces.add(sharedNamespacesItem);
    return this;
  }

   /**
   * SharedNamespaces contains a list of namespaces that will be shared by containers within the pod. Can only be set if CreateInfra is true.
   * @return sharedNamespaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SharedNamespaces contains a list of namespaces that will be shared by containers within the pod. Can only be set if CreateInfra is true.")

  public List<String> getSharedNamespaces() {
    return sharedNamespaces;
  }


  public void setSharedNamespaces(List<String> sharedNamespaces) {
    this.sharedNamespaces = sharedNamespaces;
  }


  public InspectPodData state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * State represents the current state of the pod.
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "State represents the current state of the pod.")

  public String getState() {
    return state;
  }


  public void setState(String state) {
    this.state = state;
  }


  public InspectPodData blkioWeight(Integer blkioWeight) {
    
    this.blkioWeight = blkioWeight;
    return this;
  }

   /**
   * BlkioWeight contains the blkio weight limit for the pod
   * @return blkioWeight
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "BlkioWeight contains the blkio weight limit for the pod")

  public Integer getBlkioWeight() {
    return blkioWeight;
  }


  public void setBlkioWeight(Integer blkioWeight) {
    this.blkioWeight = blkioWeight;
  }


  public InspectPodData blkioWeightDevice(List<InspectBlkioWeightDevice> blkioWeightDevice) {
    
    this.blkioWeightDevice = blkioWeightDevice;
    return this;
  }

  public InspectPodData addBlkioWeightDeviceItem(InspectBlkioWeightDevice blkioWeightDeviceItem) {
    if (this.blkioWeightDevice == null) {
      this.blkioWeightDevice = new ArrayList<>();
    }
    this.blkioWeightDevice.add(blkioWeightDeviceItem);
    return this;
  }

   /**
   * BlkioWeightDevice contains the blkio weight device limits for the pod
   * @return blkioWeightDevice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "BlkioWeightDevice contains the blkio weight device limits for the pod")

  public List<InspectBlkioWeightDevice> getBlkioWeightDevice() {
    return blkioWeightDevice;
  }


  public void setBlkioWeightDevice(List<InspectBlkioWeightDevice> blkioWeightDevice) {
    this.blkioWeightDevice = blkioWeightDevice;
  }


  public InspectPodData cpuPeriod(Integer cpuPeriod) {
    
    this.cpuPeriod = cpuPeriod;
    return this;
  }

   /**
   * CPUPeriod contains the CPU period of the pod
   * @return cpuPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CPUPeriod contains the CPU period of the pod")

  public Integer getCpuPeriod() {
    return cpuPeriod;
  }


  public void setCpuPeriod(Integer cpuPeriod) {
    this.cpuPeriod = cpuPeriod;
  }


  public InspectPodData cpuQuota(Long cpuQuota) {
    
    this.cpuQuota = cpuQuota;
    return this;
  }

   /**
   * CPUQuota contains the CPU quota of the pod
   * @return cpuQuota
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CPUQuota contains the CPU quota of the pod")

  public Long getCpuQuota() {
    return cpuQuota;
  }


  public void setCpuQuota(Long cpuQuota) {
    this.cpuQuota = cpuQuota;
  }


  public InspectPodData cpuShares(Integer cpuShares) {
    
    this.cpuShares = cpuShares;
    return this;
  }

   /**
   * CPUShares contains the cpu shares for the pod
   * @return cpuShares
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CPUShares contains the cpu shares for the pod")

  public Integer getCpuShares() {
    return cpuShares;
  }


  public void setCpuShares(Integer cpuShares) {
    this.cpuShares = cpuShares;
  }


  public InspectPodData cpusetCpus(String cpusetCpus) {
    
    this.cpusetCpus = cpusetCpus;
    return this;
  }

   /**
   * CPUSetCPUs contains linux specific CPU data for the pod
   * @return cpusetCpus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CPUSetCPUs contains linux specific CPU data for the pod")

  public String getCpusetCpus() {
    return cpusetCpus;
  }


  public void setCpusetCpus(String cpusetCpus) {
    this.cpusetCpus = cpusetCpus;
  }


  public InspectPodData cpusetMems(String cpusetMems) {
    
    this.cpusetMems = cpusetMems;
    return this;
  }

   /**
   * CPUSetMems contains linux specific CPU data for the pod
   * @return cpusetMems
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CPUSetMems contains linux specific CPU data for the pod")

  public String getCpusetMems() {
    return cpusetMems;
  }


  public void setCpusetMems(String cpusetMems) {
    this.cpusetMems = cpusetMems;
  }


  public InspectPodData deviceReadBps(List<InspectBlkioThrottleDevice> deviceReadBps) {
    
    this.deviceReadBps = deviceReadBps;
    return this;
  }

  public InspectPodData addDeviceReadBpsItem(InspectBlkioThrottleDevice deviceReadBpsItem) {
    if (this.deviceReadBps == null) {
      this.deviceReadBps = new ArrayList<>();
    }
    this.deviceReadBps.add(deviceReadBpsItem);
    return this;
  }

   /**
   * BlkioDeviceReadBps contains the Read/Access limit for the pod&#39;s devices
   * @return deviceReadBps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "BlkioDeviceReadBps contains the Read/Access limit for the pod's devices")

  public List<InspectBlkioThrottleDevice> getDeviceReadBps() {
    return deviceReadBps;
  }


  public void setDeviceReadBps(List<InspectBlkioThrottleDevice> deviceReadBps) {
    this.deviceReadBps = deviceReadBps;
  }


  public InspectPodData deviceWriteBps(List<InspectBlkioThrottleDevice> deviceWriteBps) {
    
    this.deviceWriteBps = deviceWriteBps;
    return this;
  }

  public InspectPodData addDeviceWriteBpsItem(InspectBlkioThrottleDevice deviceWriteBpsItem) {
    if (this.deviceWriteBps == null) {
      this.deviceWriteBps = new ArrayList<>();
    }
    this.deviceWriteBps.add(deviceWriteBpsItem);
    return this;
  }

   /**
   * BlkioDeviceReadBps contains the Read/Access limit for the pod&#39;s devices
   * @return deviceWriteBps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "BlkioDeviceReadBps contains the Read/Access limit for the pod's devices")

  public List<InspectBlkioThrottleDevice> getDeviceWriteBps() {
    return deviceWriteBps;
  }


  public void setDeviceWriteBps(List<InspectBlkioThrottleDevice> deviceWriteBps) {
    this.deviceWriteBps = deviceWriteBps;
  }


  public InspectPodData devices(List<InspectDevice> devices) {
    
    this.devices = devices;
    return this;
  }

  public InspectPodData addDevicesItem(InspectDevice devicesItem) {
    if (this.devices == null) {
      this.devices = new ArrayList<>();
    }
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * Devices contains the specified host devices
   * @return devices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Devices contains the specified host devices")

  public List<InspectDevice> getDevices() {
    return devices;
  }


  public void setDevices(List<InspectDevice> devices) {
    this.devices = devices;
  }


  public InspectPodData memoryLimit(Integer memoryLimit) {
    
    this.memoryLimit = memoryLimit;
    return this;
  }

   /**
   * MemoryLimit contains the specified cgroup memory limit for the pod
   * @return memoryLimit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "MemoryLimit contains the specified cgroup memory limit for the pod")

  public Integer getMemoryLimit() {
    return memoryLimit;
  }


  public void setMemoryLimit(Integer memoryLimit) {
    this.memoryLimit = memoryLimit;
  }


  public InspectPodData memorySwap(Integer memorySwap) {
    
    this.memorySwap = memorySwap;
    return this;
  }

   /**
   * MemorySwap contains the specified memory swap limit for the pod
   * @return memorySwap
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "MemorySwap contains the specified memory swap limit for the pod")

  public Integer getMemorySwap() {
    return memorySwap;
  }


  public void setMemorySwap(Integer memorySwap) {
    this.memorySwap = memorySwap;
  }


  public InspectPodData mounts(List<InspectMount> mounts) {
    
    this.mounts = mounts;
    return this;
  }

  public InspectPodData addMountsItem(InspectMount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

   /**
   * Mounts contains volume related information for the pod
   * @return mounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Mounts contains volume related information for the pod")

  public List<InspectMount> getMounts() {
    return mounts;
  }


  public void setMounts(List<InspectMount> mounts) {
    this.mounts = mounts;
  }


  public InspectPodData securityOpt(List<String> securityOpt) {
    
    this.securityOpt = securityOpt;
    return this;
  }

  public InspectPodData addSecurityOptItem(String securityOptItem) {
    if (this.securityOpt == null) {
      this.securityOpt = new ArrayList<>();
    }
    this.securityOpt.add(securityOptItem);
    return this;
  }

   /**
   * SecurityOpt contains the specified security labels and related SELinux information
   * @return securityOpt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SecurityOpt contains the specified security labels and related SELinux information")

  public List<String> getSecurityOpt() {
    return securityOpt;
  }


  public void setSecurityOpt(List<String> securityOpt) {
    this.securityOpt = securityOpt;
  }


  public InspectPodData volumesFrom(List<String> volumesFrom) {
    
    this.volumesFrom = volumesFrom;
    return this;
  }

  public InspectPodData addVolumesFromItem(String volumesFromItem) {
    if (this.volumesFrom == null) {
      this.volumesFrom = new ArrayList<>();
    }
    this.volumesFrom.add(volumesFromItem);
    return this;
  }

   /**
   * VolumesFrom contains the containers that the pod inherits mounts from
   * @return volumesFrom
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "VolumesFrom contains the containers that the pod inherits mounts from")

  public List<String> getVolumesFrom() {
    return volumesFrom;
  }


  public void setVolumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InspectPodData inspectPodData = (InspectPodData) o;
    return Objects.equals(this.cgroupParent, inspectPodData.cgroupParent) &&
        Objects.equals(this.cgroupPath, inspectPodData.cgroupPath) &&
        Objects.equals(this.containers, inspectPodData.containers) &&
        Objects.equals(this.createCgroup, inspectPodData.createCgroup) &&
        Objects.equals(this.createCommand, inspectPodData.createCommand) &&
        Objects.equals(this.createInfra, inspectPodData.createInfra) &&
        Objects.equals(this.created, inspectPodData.created) &&
        Objects.equals(this.exitPolicy, inspectPodData.exitPolicy) &&
        Objects.equals(this.hostname, inspectPodData.hostname) &&
        Objects.equals(this.id, inspectPodData.id) &&
        Objects.equals(this.infraConfig, inspectPodData.infraConfig) &&
        Objects.equals(this.infraContainerID, inspectPodData.infraContainerID) &&
        Objects.equals(this.labels, inspectPodData.labels) &&
        Objects.equals(this.lockNumber, inspectPodData.lockNumber) &&
        Objects.equals(this.name, inspectPodData.name) &&
        Objects.equals(this.namespace, inspectPodData.namespace) &&
        Objects.equals(this.numContainers, inspectPodData.numContainers) &&
        Objects.equals(this.restartPolicy, inspectPodData.restartPolicy) &&
        Objects.equals(this.sharedNamespaces, inspectPodData.sharedNamespaces) &&
        Objects.equals(this.state, inspectPodData.state) &&
        Objects.equals(this.blkioWeight, inspectPodData.blkioWeight) &&
        Objects.equals(this.blkioWeightDevice, inspectPodData.blkioWeightDevice) &&
        Objects.equals(this.cpuPeriod, inspectPodData.cpuPeriod) &&
        Objects.equals(this.cpuQuota, inspectPodData.cpuQuota) &&
        Objects.equals(this.cpuShares, inspectPodData.cpuShares) &&
        Objects.equals(this.cpusetCpus, inspectPodData.cpusetCpus) &&
        Objects.equals(this.cpusetMems, inspectPodData.cpusetMems) &&
        Objects.equals(this.deviceReadBps, inspectPodData.deviceReadBps) &&
        Objects.equals(this.deviceWriteBps, inspectPodData.deviceWriteBps) &&
        Objects.equals(this.devices, inspectPodData.devices) &&
        Objects.equals(this.memoryLimit, inspectPodData.memoryLimit) &&
        Objects.equals(this.memorySwap, inspectPodData.memorySwap) &&
        Objects.equals(this.mounts, inspectPodData.mounts) &&
        Objects.equals(this.securityOpt, inspectPodData.securityOpt) &&
        Objects.equals(this.volumesFrom, inspectPodData.volumesFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cgroupParent, cgroupPath, containers, createCgroup, createCommand, createInfra, created, exitPolicy, hostname, id, infraConfig, infraContainerID, labels, lockNumber, name, namespace, numContainers, restartPolicy, sharedNamespaces, state, blkioWeight, blkioWeightDevice, cpuPeriod, cpuQuota, cpuShares, cpusetCpus, cpusetMems, deviceReadBps, deviceWriteBps, devices, memoryLimit, memorySwap, mounts, securityOpt, volumesFrom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InspectPodData {\n");
    sb.append("    cgroupParent: ").append(toIndentedString(cgroupParent)).append("\n");
    sb.append("    cgroupPath: ").append(toIndentedString(cgroupPath)).append("\n");
    sb.append("    containers: ").append(toIndentedString(containers)).append("\n");
    sb.append("    createCgroup: ").append(toIndentedString(createCgroup)).append("\n");
    sb.append("    createCommand: ").append(toIndentedString(createCommand)).append("\n");
    sb.append("    createInfra: ").append(toIndentedString(createInfra)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    exitPolicy: ").append(toIndentedString(exitPolicy)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    infraConfig: ").append(toIndentedString(infraConfig)).append("\n");
    sb.append("    infraContainerID: ").append(toIndentedString(infraContainerID)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    lockNumber: ").append(toIndentedString(lockNumber)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    numContainers: ").append(toIndentedString(numContainers)).append("\n");
    sb.append("    restartPolicy: ").append(toIndentedString(restartPolicy)).append("\n");
    sb.append("    sharedNamespaces: ").append(toIndentedString(sharedNamespaces)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    blkioWeight: ").append(toIndentedString(blkioWeight)).append("\n");
    sb.append("    blkioWeightDevice: ").append(toIndentedString(blkioWeightDevice)).append("\n");
    sb.append("    cpuPeriod: ").append(toIndentedString(cpuPeriod)).append("\n");
    sb.append("    cpuQuota: ").append(toIndentedString(cpuQuota)).append("\n");
    sb.append("    cpuShares: ").append(toIndentedString(cpuShares)).append("\n");
    sb.append("    cpusetCpus: ").append(toIndentedString(cpusetCpus)).append("\n");
    sb.append("    cpusetMems: ").append(toIndentedString(cpusetMems)).append("\n");
    sb.append("    deviceReadBps: ").append(toIndentedString(deviceReadBps)).append("\n");
    sb.append("    deviceWriteBps: ").append(toIndentedString(deviceWriteBps)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    memoryLimit: ").append(toIndentedString(memoryLimit)).append("\n");
    sb.append("    memorySwap: ").append(toIndentedString(memorySwap)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    securityOpt: ").append(toIndentedString(securityOpt)).append("\n");
    sb.append("    volumesFrom: ").append(toIndentedString(volumesFrom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("CgroupParent");
    openapiFields.add("CgroupPath");
    openapiFields.add("Containers");
    openapiFields.add("CreateCgroup");
    openapiFields.add("CreateCommand");
    openapiFields.add("CreateInfra");
    openapiFields.add("Created");
    openapiFields.add("ExitPolicy");
    openapiFields.add("Hostname");
    openapiFields.add("Id");
    openapiFields.add("InfraConfig");
    openapiFields.add("InfraContainerID");
    openapiFields.add("Labels");
    openapiFields.add("LockNumber");
    openapiFields.add("Name");
    openapiFields.add("Namespace");
    openapiFields.add("NumContainers");
    openapiFields.add("RestartPolicy");
    openapiFields.add("SharedNamespaces");
    openapiFields.add("State");
    openapiFields.add("blkio_weight");
    openapiFields.add("blkio_weight_device");
    openapiFields.add("cpu_period");
    openapiFields.add("cpu_quota");
    openapiFields.add("cpu_shares");
    openapiFields.add("cpuset_cpus");
    openapiFields.add("cpuset_mems");
    openapiFields.add("device_read_bps");
    openapiFields.add("device_write_bps");
    openapiFields.add("devices");
    openapiFields.add("memory_limit");
    openapiFields.add("memory_swap");
    openapiFields.add("mounts");
    openapiFields.add("security_opt");
    openapiFields.add("volumes_from");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to InspectPodData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (InspectPodData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in InspectPodData is not found in the empty JSON string", InspectPodData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!InspectPodData.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectPodData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if ((jsonObj.get("CgroupParent") != null && !jsonObj.get("CgroupParent").isJsonNull()) && !jsonObj.get("CgroupParent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CgroupParent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CgroupParent").toString()));
      }
      if ((jsonObj.get("CgroupPath") != null && !jsonObj.get("CgroupPath").isJsonNull()) && !jsonObj.get("CgroupPath").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CgroupPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CgroupPath").toString()));
      }
      if (jsonObj.get("Containers") != null && !jsonObj.get("Containers").isJsonNull()) {
        JsonArray jsonArraycontainers = jsonObj.getAsJsonArray("Containers");
        if (jsonArraycontainers != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Containers").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Containers` to be an array in the JSON string but got `%s`", jsonObj.get("Containers").toString()));
          }

          // validate the optional field `Containers` (array)
          for (int i = 0; i < jsonArraycontainers.size(); i++) {
            InspectPodContainerInfo.validateJsonObject(jsonArraycontainers.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("CreateCommand") != null && !jsonObj.get("CreateCommand").isJsonNull()) && !jsonObj.get("CreateCommand").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `CreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get("CreateCommand").toString()));
      }
      if ((jsonObj.get("ExitPolicy") != null && !jsonObj.get("ExitPolicy").isJsonNull()) && !jsonObj.get("ExitPolicy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ExitPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ExitPolicy").toString()));
      }
      if ((jsonObj.get("Hostname") != null && !jsonObj.get("Hostname").isJsonNull()) && !jsonObj.get("Hostname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Hostname").toString()));
      }
      if ((jsonObj.get("Id") != null && !jsonObj.get("Id").isJsonNull()) && !jsonObj.get("Id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Id").toString()));
      }
      // validate the optional field `InfraConfig`
      if (jsonObj.get("InfraConfig") != null && !jsonObj.get("InfraConfig").isJsonNull()) {
        InspectPodInfraConfig.validateJsonObject(jsonObj.getAsJsonObject("InfraConfig"));
      }
      if ((jsonObj.get("InfraContainerID") != null && !jsonObj.get("InfraContainerID").isJsonNull()) && !jsonObj.get("InfraContainerID").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `InfraContainerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("InfraContainerID").toString()));
      }
      if ((jsonObj.get("Name") != null && !jsonObj.get("Name").isJsonNull()) && !jsonObj.get("Name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Name").toString()));
      }
      if ((jsonObj.get("Namespace") != null && !jsonObj.get("Namespace").isJsonNull()) && !jsonObj.get("Namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Namespace").toString()));
      }
      if ((jsonObj.get("RestartPolicy") != null && !jsonObj.get("RestartPolicy").isJsonNull()) && !jsonObj.get("RestartPolicy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `RestartPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("RestartPolicy").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("SharedNamespaces") != null && !jsonObj.get("SharedNamespaces").isJsonNull()) && !jsonObj.get("SharedNamespaces").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `SharedNamespaces` to be an array in the JSON string but got `%s`", jsonObj.get("SharedNamespaces").toString()));
      }
      if ((jsonObj.get("State") != null && !jsonObj.get("State").isJsonNull()) && !jsonObj.get("State").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `State` to be a primitive type in the JSON string but got `%s`", jsonObj.get("State").toString()));
      }
      if (jsonObj.get("blkio_weight_device") != null && !jsonObj.get("blkio_weight_device").isJsonNull()) {
        JsonArray jsonArrayblkioWeightDevice = jsonObj.getAsJsonArray("blkio_weight_device");
        if (jsonArrayblkioWeightDevice != null) {
          // ensure the json data is an array
          if (!jsonObj.get("blkio_weight_device").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `blkio_weight_device` to be an array in the JSON string but got `%s`", jsonObj.get("blkio_weight_device").toString()));
          }

          // validate the optional field `blkio_weight_device` (array)
          for (int i = 0; i < jsonArrayblkioWeightDevice.size(); i++) {
            InspectBlkioWeightDevice.validateJsonObject(jsonArrayblkioWeightDevice.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("cpuset_cpus") != null && !jsonObj.get("cpuset_cpus").isJsonNull()) && !jsonObj.get("cpuset_cpus").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cpuset_cpus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cpuset_cpus").toString()));
      }
      if ((jsonObj.get("cpuset_mems") != null && !jsonObj.get("cpuset_mems").isJsonNull()) && !jsonObj.get("cpuset_mems").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cpuset_mems` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cpuset_mems").toString()));
      }
      if (jsonObj.get("device_read_bps") != null && !jsonObj.get("device_read_bps").isJsonNull()) {
        JsonArray jsonArraydeviceReadBps = jsonObj.getAsJsonArray("device_read_bps");
        if (jsonArraydeviceReadBps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("device_read_bps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `device_read_bps` to be an array in the JSON string but got `%s`", jsonObj.get("device_read_bps").toString()));
          }

          // validate the optional field `device_read_bps` (array)
          for (int i = 0; i < jsonArraydeviceReadBps.size(); i++) {
            InspectBlkioThrottleDevice.validateJsonObject(jsonArraydeviceReadBps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("device_write_bps") != null && !jsonObj.get("device_write_bps").isJsonNull()) {
        JsonArray jsonArraydeviceWriteBps = jsonObj.getAsJsonArray("device_write_bps");
        if (jsonArraydeviceWriteBps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("device_write_bps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `device_write_bps` to be an array in the JSON string but got `%s`", jsonObj.get("device_write_bps").toString()));
          }

          // validate the optional field `device_write_bps` (array)
          for (int i = 0; i < jsonArraydeviceWriteBps.size(); i++) {
            InspectBlkioThrottleDevice.validateJsonObject(jsonArraydeviceWriteBps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("devices") != null && !jsonObj.get("devices").isJsonNull()) {
        JsonArray jsonArraydevices = jsonObj.getAsJsonArray("devices");
        if (jsonArraydevices != null) {
          // ensure the json data is an array
          if (!jsonObj.get("devices").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get("devices").toString()));
          }

          // validate the optional field `devices` (array)
          for (int i = 0; i < jsonArraydevices.size(); i++) {
            InspectDevice.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("mounts") != null && !jsonObj.get("mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get("mounts").toString()));
          }

          // validate the optional field `mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            InspectMount.validateJsonObject(jsonArraymounts.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("security_opt") != null && !jsonObj.get("security_opt").isJsonNull()) && !jsonObj.get("security_opt").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `security_opt` to be an array in the JSON string but got `%s`", jsonObj.get("security_opt").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("volumes_from") != null && !jsonObj.get("volumes_from").isJsonNull()) && !jsonObj.get("volumes_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get("volumes_from").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!InspectPodData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'InspectPodData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<InspectPodData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(InspectPodData.class));

       return (TypeAdapter<T>) new TypeAdapter<InspectPodData>() {
           @Override
           public void write(JsonWriter out, InspectPodData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public InspectPodData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of InspectPodData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of InspectPodData
  * @throws IOException if the JSON string is invalid with respect to InspectPodData
  */
  public static InspectPodData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, InspectPodData.class);
  }

 /**
  * Convert an instance of InspectPodData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

