/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.ContainerExecRequest;
import io.github.pod4dev.libpodj.model.ExecStartRequest;
import io.github.pod4dev.libpodj.model.InspectExecSession;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import okhttp3.Call;

public class ExecCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExecCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExecCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call containerExecCall(String name, ContainerExecRequest control, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ContainerExecRequest localVarPostBody = control;
        String localVarPath = "/containers/{name}/exec".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerExecValidateBeforeCall(String name, ContainerExecRequest control, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerExec(Async)");
        }
        Call localVarCall = this.containerExecCall(name, control, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> containerExecWithHttpInfo(@NotNull String name, ContainerExecRequest control) throws ApiException {
        Call localVarCall = this.containerExecValidateBeforeCall(name, control, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerExecAsync(String name, ContainerExecRequest control, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerExecValidateBeforeCall(name, control, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerExecRequest containerExec(String name) {
        return new APIcontainerExecRequest(name);
    }

    private Call execInspectCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/exec/{id}/json".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call execInspectValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling execInspect(Async)");
        }
        Call localVarCall = this.execInspectCall(id, _callback);
        return localVarCall;
    }

    private ApiResponse<InspectExecSession> execInspectWithHttpInfo(@NotNull String id) throws ApiException {
        Call localVarCall = this.execInspectValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<InspectExecSession>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call execInspectAsync(String id, ApiCallback<InspectExecSession> _callback) throws ApiException {
        Call localVarCall = this.execInspectValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<InspectExecSession>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIexecInspectRequest execInspect(String id) {
        return new APIexecInspectRequest(id);
    }

    private Call execResizeCall(String id, Integer h, Integer w, Boolean running, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/exec/{id}/resize".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (h != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("h", h));
        }
        if (w != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("w", w));
        }
        if (running != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("running", running));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call execResizeValidateBeforeCall(String id, Integer h, Integer w, Boolean running, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling execResize(Async)");
        }
        Call localVarCall = this.execResizeCall(id, h, w, running, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> execResizeWithHttpInfo(@NotNull String id, Integer h, Integer w, Boolean running) throws ApiException {
        Call localVarCall = this.execResizeValidateBeforeCall(id, h, w, running, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call execResizeAsync(String id, Integer h, Integer w, Boolean running, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.execResizeValidateBeforeCall(id, h, w, running, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIexecResizeRequest execResize(String id) {
        return new APIexecResizeRequest(id);
    }

    private Call execStartCall(String id, ExecStartRequest control, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExecStartRequest localVarPostBody = control;
        String localVarPath = "/exec/{id}/start".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call execStartValidateBeforeCall(String id, ExecStartRequest control, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling execStart(Async)");
        }
        Call localVarCall = this.execStartCall(id, control, _callback);
        return localVarCall;
    }

    private ApiResponse<Void> execStartWithHttpInfo(@NotNull String id, ExecStartRequest control) throws ApiException {
        Call localVarCall = this.execStartValidateBeforeCall(id, control, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call execStartAsync(String id, ExecStartRequest control, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.execStartValidateBeforeCall(id, control, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIexecStartRequest execStart(String id) {
        return new APIexecStartRequest(id);
    }

    public class APIcontainerExecRequest {
        private final String name;
        private ContainerExecRequest control;

        private APIcontainerExecRequest(String name) {
            this.name = name;
        }

        public APIcontainerExecRequest control(ContainerExecRequest control) {
            this.control = control;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecCompatApi.this.containerExecCall(this.name, this.control, _callback);
        }

        public void execute() throws ApiException {
            ExecCompatApi.this.containerExecWithHttpInfo(this.name, this.control);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecCompatApi.this.containerExecWithHttpInfo(this.name, this.control);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecCompatApi.this.containerExecAsync(this.name, this.control, _callback);
        }
    }

    public class APIexecInspectRequest {
        private final String id;

        private APIexecInspectRequest(String id) {
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecCompatApi.this.execInspectCall(this.id, _callback);
        }

        public InspectExecSession execute() throws ApiException {
            ApiResponse<InspectExecSession> localVarResp = ExecCompatApi.this.execInspectWithHttpInfo(this.id);
            return localVarResp.getData();
        }

        public ApiResponse<InspectExecSession> executeWithHttpInfo() throws ApiException {
            return ExecCompatApi.this.execInspectWithHttpInfo(this.id);
        }

        public Call executeAsync(ApiCallback<InspectExecSession> _callback) throws ApiException {
            return ExecCompatApi.this.execInspectAsync(this.id, _callback);
        }
    }

    public class APIexecResizeRequest {
        private final String id;
        private Integer h;
        private Integer w;
        private Boolean running;

        private APIexecResizeRequest(String id) {
            this.id = id;
        }

        public APIexecResizeRequest h(Integer h) {
            this.h = h;
            return this;
        }

        public APIexecResizeRequest w(Integer w) {
            this.w = w;
            return this;
        }

        public APIexecResizeRequest running(Boolean running) {
            this.running = running;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecCompatApi.this.execResizeCall(this.id, this.h, this.w, this.running, _callback);
        }

        public void execute() throws ApiException {
            ExecCompatApi.this.execResizeWithHttpInfo(this.id, this.h, this.w, this.running);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecCompatApi.this.execResizeWithHttpInfo(this.id, this.h, this.w, this.running);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecCompatApi.this.execResizeAsync(this.id, this.h, this.w, this.running, _callback);
        }
    }

    public class APIexecStartRequest {
        private final String id;
        private ExecStartRequest control;

        private APIexecStartRequest(String id) {
            this.id = id;
        }

        public APIexecStartRequest control(ExecStartRequest control) {
            this.control = control;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecCompatApi.this.execStartCall(this.id, this.control, _callback);
        }

        public void execute() throws ApiException {
            ExecCompatApi.this.execStartWithHttpInfo(this.id, this.control);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecCompatApi.this.execStartWithHttpInfo(this.id, this.control);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecCompatApi.this.execStartAsync(this.id, this.control, _callback);
        }
    }
}

