/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ClusterVolumeSpec;
import io.github.pod4dev.libpodj.model.Info;
import io.github.pod4dev.libpodj.model.PublishStatus;
import io.github.pod4dev.libpodj.model.Version;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="ClusterVolume contains options and information specific to, and only present on, Swarm CSI cluster volumes.")
public class ClusterVolume
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CREATED_AT = "CreatedAt";
    @SerializedName(value="CreatedAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_I_D = "ID";
    @SerializedName(value="ID")
    private String ID;
    public static final String SERIALIZED_NAME_INFO = "Info";
    @SerializedName(value="Info")
    private Info info;
    public static final String SERIALIZED_NAME_PUBLISH_STATUS = "PublishStatus";
    @SerializedName(value="PublishStatus")
    private List<PublishStatus> publishStatus = null;
    public static final String SERIALIZED_NAME_SPEC = "Spec";
    @SerializedName(value="Spec")
    private ClusterVolumeSpec spec;
    public static final String SERIALIZED_NAME_UPDATED_AT = "UpdatedAt";
    @SerializedName(value="UpdatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_VERSION = "Version";
    @SerializedName(value="Version")
    private Version version;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ClusterVolume createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ClusterVolume ID(String ID) {
        this.ID = ID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID is the Swarm ID of the volume. Because cluster volumes are Swarm objects, they have an ID, unlike non-cluster volumes, which only have a Name. This ID can be used to refer to the cluster volume.")
    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public ClusterVolume info(Info info) {
        this.info = info;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public ClusterVolume publishStatus(List<PublishStatus> publishStatus) {
        this.publishStatus = publishStatus;
        return this;
    }

    public ClusterVolume addPublishStatusItem(PublishStatus publishStatusItem) {
        if (this.publishStatus == null) {
            this.publishStatus = new ArrayList<PublishStatus>();
        }
        this.publishStatus.add(publishStatusItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="PublishStatus contains the status of the volume as it pertains to its publishing on Nodes.")
    public List<PublishStatus> getPublishStatus() {
        return this.publishStatus;
    }

    public void setPublishStatus(List<PublishStatus> publishStatus) {
        this.publishStatus = publishStatus;
    }

    public ClusterVolume spec(ClusterVolumeSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public ClusterVolumeSpec getSpec() {
        return this.spec;
    }

    public void setSpec(ClusterVolumeSpec spec) {
        this.spec = spec;
    }

    public ClusterVolume updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public ClusterVolume version(Version version) {
        this.version = version;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterVolume clusterVolume = (ClusterVolume)o;
        return Objects.equals(this.createdAt, clusterVolume.createdAt) && Objects.equals(this.ID, clusterVolume.ID) && Objects.equals(this.info, clusterVolume.info) && Objects.equals(this.publishStatus, clusterVolume.publishStatus) && Objects.equals(this.spec, clusterVolume.spec) && Objects.equals(this.updatedAt, clusterVolume.updatedAt) && Objects.equals(this.version, clusterVolume.version);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.ID, this.info, this.publishStatus, this.spec, this.updatedAt, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterVolume {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    ID: ").append(this.toIndentedString(this.ID)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    publishStatus: ").append(this.toIndentedString(this.publishStatus)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraypublishStatus;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ClusterVolume is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ClusterVolume` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_I_D) != null && !jsonObj.get(SERIALIZED_NAME_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFO) != null && !jsonObj.get(SERIALIZED_NAME_INFO).isJsonNull()) {
            Info.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_PUBLISH_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_PUBLISH_STATUS).isJsonNull() && (jsonArraypublishStatus = jsonObj.getAsJsonArray(SERIALIZED_NAME_PUBLISH_STATUS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PUBLISH_STATUS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `PublishStatus` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PUBLISH_STATUS).toString()));
            }
            for (int i = 0; i < jsonArraypublishStatus.size(); ++i) {
                PublishStatus.validateJsonObject(jsonArraypublishStatus.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SPEC) != null && !jsonObj.get(SERIALIZED_NAME_SPEC).isJsonNull()) {
            ClusterVolumeSpec.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SPEC));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull()) {
            Version.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VERSION));
        }
    }

    public static ClusterVolume fromJson(String jsonString) throws IOException {
        return (ClusterVolume)JSON.getGson().fromJson(jsonString, ClusterVolume.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_I_D);
        openapiFields.add(SERIALIZED_NAME_INFO);
        openapiFields.add(SERIALIZED_NAME_PUBLISH_STATUS);
        openapiFields.add(SERIALIZED_NAME_SPEC);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ClusterVolume.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ClusterVolume.class));
            return new TypeAdapter<ClusterVolume>(){

                public void write(JsonWriter out, ClusterVolume value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ClusterVolume read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ClusterVolume.validateJsonObject(jsonObj);
                    return (ClusterVolume)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

