/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.LinuxPersonality;
import io.github.pod4dev.libpodj.model.LogConfigLibpod;
import io.github.pod4dev.libpodj.model.Namespace;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class ContainerBasicConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private Map<String, String> annotations = null;
    public static final String SERIALIZED_NAME_COMMAND = "command";
    @SerializedName(value="command")
    private List<String> command = null;
    public static final String SERIALIZED_NAME_CONMON_PID_FILE = "conmon_pid_file";
    @SerializedName(value="conmon_pid_file")
    private String conmonPidFile;
    public static final String SERIALIZED_NAME_CONTAINER_CREATE_COMMAND = "containerCreateCommand";
    @SerializedName(value="containerCreateCommand")
    private List<String> containerCreateCommand = null;
    public static final String SERIALIZED_NAME_DEPENDENCY_CONTAINERS = "dependencyContainers";
    @SerializedName(value="dependencyContainers")
    private List<String> dependencyContainers = null;
    public static final String SERIALIZED_NAME_ENTRYPOINT = "entrypoint";
    @SerializedName(value="entrypoint")
    private List<String> entrypoint = null;
    public static final String SERIALIZED_NAME_ENV = "env";
    @SerializedName(value="env")
    private Map<String, String> env = null;
    public static final String SERIALIZED_NAME_ENV_HOST = "env_host";
    @SerializedName(value="env_host")
    private Boolean envHost;
    public static final String SERIALIZED_NAME_ENVMERGE = "envmerge";
    @SerializedName(value="envmerge")
    private List<String> envmerge = null;
    public static final String SERIALIZED_NAME_GROUP_ENTRY = "group_entry";
    @SerializedName(value="group_entry")
    private String groupEntry;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_HOSTUSERS = "hostusers";
    @SerializedName(value="hostusers")
    private List<String> hostusers = null;
    public static final String SERIALIZED_NAME_HTTPPROXY = "httpproxy";
    @SerializedName(value="httpproxy")
    private Boolean httpproxy;
    public static final String SERIALIZED_NAME_INIT_CONTAINER_TYPE = "init_container_type";
    @SerializedName(value="init_container_type")
    private String initContainerType;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_LOG_CONFIGURATION = "log_configuration";
    @SerializedName(value="log_configuration")
    private LogConfigLibpod logConfiguration;
    public static final String SERIALIZED_NAME_MANAGE_PASSWORD = "manage_password";
    @SerializedName(value="manage_password")
    private Boolean managePassword;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OCI_RUNTIME = "oci_runtime";
    @SerializedName(value="oci_runtime")
    private String ociRuntime;
    public static final String SERIALIZED_NAME_PASSWD_ENTRY = "passwd_entry";
    @SerializedName(value="passwd_entry")
    private String passwdEntry;
    public static final String SERIALIZED_NAME_PERSONALITY = "personality";
    @SerializedName(value="personality")
    private LinuxPersonality personality;
    public static final String SERIALIZED_NAME_PIDNS = "pidns";
    @SerializedName(value="pidns")
    private Namespace pidns;
    public static final String SERIALIZED_NAME_POD = "pod";
    @SerializedName(value="pod")
    private String pod;
    public static final String SERIALIZED_NAME_REMOVE = "remove";
    @SerializedName(value="remove")
    private Boolean remove;
    public static final String SERIALIZED_NAME_REMOVE_IMAGE = "removeImage";
    @SerializedName(value="removeImage")
    private Boolean removeImage;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
    @SerializedName(value="restart_policy")
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
    @SerializedName(value="restart_tries")
    private Integer restartTries;
    public static final String SERIALIZED_NAME_SDNOTIFY_MODE = "sdnotifyMode";
    @SerializedName(value="sdnotifyMode")
    private String sdnotifyMode;
    public static final String SERIALIZED_NAME_SECRET_ENV = "secret_env";
    @SerializedName(value="secret_env")
    private Map<String, String> secretEnv = null;
    public static final String SERIALIZED_NAME_STDIN = "stdin";
    @SerializedName(value="stdin")
    private Boolean stdin;
    public static final String SERIALIZED_NAME_STOP_SIGNAL = "stop_signal";
    @SerializedName(value="stop_signal")
    private Long stopSignal;
    public static final String SERIALIZED_NAME_STOP_TIMEOUT = "stop_timeout";
    @SerializedName(value="stop_timeout")
    private Integer stopTimeout;
    public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
    @SerializedName(value="sysctl")
    private Map<String, String> sysctl = null;
    public static final String SERIALIZED_NAME_SYSTEMD = "systemd";
    @SerializedName(value="systemd")
    private String systemd;
    public static final String SERIALIZED_NAME_TERMINAL = "terminal";
    @SerializedName(value="terminal")
    private Boolean terminal;
    public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
    @SerializedName(value="timeout")
    private Integer timeout;
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    private String timezone;
    public static final String SERIALIZED_NAME_UNSETENV = "unsetenv";
    @SerializedName(value="unsetenv")
    private List<String> unsetenv = null;
    public static final String SERIALIZED_NAME_UNSETENVALL = "unsetenvall";
    @SerializedName(value="unsetenvall")
    private Boolean unsetenvall;
    public static final String SERIALIZED_NAME_UTSNS = "utsns";
    @SerializedName(value="utsns")
    private Namespace utsns;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContainerBasicConfig annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public ContainerBasicConfig putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations are key-value options passed into the container runtime that can be used to trigger special behavior. Optional.")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public ContainerBasicConfig command(List<String> command) {
        this.command = command;
        return this;
    }

    public ContainerBasicConfig addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Command is the container's command. If not given and Image is specified, this will be populated by the image's configuration. Optional.")
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public ContainerBasicConfig conmonPidFile(String conmonPidFile) {
        this.conmonPidFile = conmonPidFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConmonPidFile is a path at which a PID file for Conmon will be placed. If not given, a default location will be used. Optional.")
    public String getConmonPidFile() {
        return this.conmonPidFile;
    }

    public void setConmonPidFile(String conmonPidFile) {
        this.conmonPidFile = conmonPidFile;
    }

    public ContainerBasicConfig containerCreateCommand(List<String> containerCreateCommand) {
        this.containerCreateCommand = containerCreateCommand;
        return this;
    }

    public ContainerBasicConfig addContainerCreateCommandItem(String containerCreateCommandItem) {
        if (this.containerCreateCommand == null) {
            this.containerCreateCommand = new ArrayList<String>();
        }
        this.containerCreateCommand.add(containerCreateCommandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ContainerCreateCommand is the command that was used to create this container. This will be shown in the output of Inspect() on the container, and may also be used by some tools that wish to recreate the container (e.g. `podman generate systemd --new`). Optional.")
    public List<String> getContainerCreateCommand() {
        return this.containerCreateCommand;
    }

    public void setContainerCreateCommand(List<String> containerCreateCommand) {
        this.containerCreateCommand = containerCreateCommand;
    }

    public ContainerBasicConfig dependencyContainers(List<String> dependencyContainers) {
        this.dependencyContainers = dependencyContainers;
        return this;
    }

    public ContainerBasicConfig addDependencyContainersItem(String dependencyContainersItem) {
        if (this.dependencyContainers == null) {
            this.dependencyContainers = new ArrayList<String>();
        }
        this.dependencyContainers.add(dependencyContainersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DependencyContainers is an array of containers this container depends on. Dependency containers must be started before this container. Dependencies can be specified by name or full/partial ID. Optional.")
    public List<String> getDependencyContainers() {
        return this.dependencyContainers;
    }

    public void setDependencyContainers(List<String> dependencyContainers) {
        this.dependencyContainers = dependencyContainers;
    }

    public ContainerBasicConfig entrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public ContainerBasicConfig addEntrypointItem(String entrypointItem) {
        if (this.entrypoint == null) {
            this.entrypoint = new ArrayList<String>();
        }
        this.entrypoint.add(entrypointItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Entrypoint is the container's entrypoint. If not given and Image is specified, this will be populated by the image's configuration. Optional.")
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public ContainerBasicConfig env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public ContainerBasicConfig putEnvItem(String key, String envItem) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, envItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Env is a set of environment variables that will be set in the container. Optional.")
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public ContainerBasicConfig envHost(Boolean envHost) {
        this.envHost = envHost;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvHost indicates that the host environment should be added to container Optional.")
    public Boolean getEnvHost() {
        return this.envHost;
    }

    public void setEnvHost(Boolean envHost) {
        this.envHost = envHost;
    }

    public ContainerBasicConfig envmerge(List<String> envmerge) {
        this.envmerge = envmerge;
        return this;
    }

    public ContainerBasicConfig addEnvmergeItem(String envmergeItem) {
        if (this.envmerge == null) {
            this.envmerge = new ArrayList<String>();
        }
        this.envmerge.add(envmergeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvMerge takes the specified environment variables from image and preprocess them before injecting them into the container. Optional.")
    public List<String> getEnvmerge() {
        return this.envmerge;
    }

    public void setEnvmerge(List<String> envmerge) {
        this.envmerge = envmerge;
    }

    public ContainerBasicConfig groupEntry(String groupEntry) {
        this.groupEntry = groupEntry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GroupEntry specifies an arbitrary string to append to the container's /etc/group file. Optional.")
    public String getGroupEntry() {
        return this.groupEntry;
    }

    public void setGroupEntry(String groupEntry) {
        this.groupEntry = groupEntry;
    }

    public ContainerBasicConfig hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hostname is the container's hostname. If not set, the hostname will not be modified (if UtsNS is not private) or will be set to the container ID (if UtsNS is private). Conflicts with UtsNS if UtsNS is not set to private. Optional.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ContainerBasicConfig hostusers(List<String> hostusers) {
        this.hostusers = hostusers;
        return this;
    }

    public ContainerBasicConfig addHostusersItem(String hostusersItem) {
        if (this.hostusers == null) {
            this.hostusers = new ArrayList<String>();
        }
        this.hostusers.add(hostusersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostUsers is a list of host usernames or UIDs to add to the container etc/passwd file")
    public List<String> getHostusers() {
        return this.hostusers;
    }

    public void setHostusers(List<String> hostusers) {
        this.hostusers = hostusers;
    }

    public ContainerBasicConfig httpproxy(Boolean httpproxy) {
        this.httpproxy = httpproxy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvHTTPProxy indicates that the http host proxy environment variables should be added to container Optional.")
    public Boolean getHttpproxy() {
        return this.httpproxy;
    }

    public void setHttpproxy(Boolean httpproxy) {
        this.httpproxy = httpproxy;
    }

    public ContainerBasicConfig initContainerType(String initContainerType) {
        this.initContainerType = initContainerType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InitContainerType describes if this container is an init container and if so, what type: always or once. Optional.")
    public String getInitContainerType() {
        return this.initContainerType;
    }

    public void setInitContainerType(String initContainerType) {
        this.initContainerType = initContainerType;
    }

    public ContainerBasicConfig labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public ContainerBasicConfig putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Labels are key-value pairs that are used to add metadata to containers. Optional.")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public ContainerBasicConfig logConfiguration(LogConfigLibpod logConfiguration) {
        this.logConfiguration = logConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LogConfigLibpod getLogConfiguration() {
        return this.logConfiguration;
    }

    public void setLogConfiguration(LogConfigLibpod logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public ContainerBasicConfig managePassword(Boolean managePassword) {
        this.managePassword = managePassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Passwd is a container run option that determines if we are validating users/groups before running the container")
    public Boolean getManagePassword() {
        return this.managePassword;
    }

    public void setManagePassword(Boolean managePassword) {
        this.managePassword = managePassword;
    }

    public ContainerBasicConfig name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name is the name the container will be given. If no name is provided, one will be randomly generated. Optional.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerBasicConfig ociRuntime(String ociRuntime) {
        this.ociRuntime = ociRuntime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OCIRuntime is the name of the OCI runtime that will be used to create the container. If not specified, the default will be used. Optional.")
    public String getOciRuntime() {
        return this.ociRuntime;
    }

    public void setOciRuntime(String ociRuntime) {
        this.ociRuntime = ociRuntime;
    }

    public ContainerBasicConfig passwdEntry(String passwdEntry) {
        this.passwdEntry = passwdEntry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PasswdEntry specifies an arbitrary string to append to the container's /etc/passwd file. Optional.")
    public String getPasswdEntry() {
        return this.passwdEntry;
    }

    public void setPasswdEntry(String passwdEntry) {
        this.passwdEntry = passwdEntry;
    }

    public ContainerBasicConfig personality(LinuxPersonality personality) {
        this.personality = personality;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxPersonality getPersonality() {
        return this.personality;
    }

    public void setPersonality(LinuxPersonality personality) {
        this.personality = personality;
    }

    public ContainerBasicConfig pidns(Namespace pidns) {
        this.pidns = pidns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getPidns() {
        return this.pidns;
    }

    public void setPidns(Namespace pidns) {
        this.pidns = pidns;
    }

    public ContainerBasicConfig pod(String pod) {
        this.pod = pod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pod is the ID of the pod the container will join. Optional.")
    public String getPod() {
        return this.pod;
    }

    public void setPod(String pod) {
        this.pod = pod;
    }

    public ContainerBasicConfig remove(Boolean remove) {
        this.remove = remove;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove indicates if the container should be removed once it has been started and exits. Optional.")
    public Boolean getRemove() {
        return this.remove;
    }

    public void setRemove(Boolean remove) {
        this.remove = remove;
    }

    public ContainerBasicConfig removeImage(Boolean removeImage) {
        this.removeImage = removeImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RemoveImage indicates that the container should remove the image it was created from after it exits. Only allowed if Remove is set to true and Image, not Rootfs, is in use. Optional.")
    public Boolean getRemoveImage() {
        return this.removeImage;
    }

    public void setRemoveImage(Boolean removeImage) {
        this.removeImage = removeImage;
    }

    public ContainerBasicConfig restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RestartPolicy is the container's restart policy - an action which will be taken when the container exits. If not given, the default policy, which does nothing, will be used. Optional.")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public ContainerBasicConfig restartTries(Integer restartTries) {
        this.restartTries = restartTries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RestartRetries is the number of attempts that will be made to restart the container. Only available when RestartPolicy is set to \"on-failure\". Optional.")
    public Integer getRestartTries() {
        return this.restartTries;
    }

    public void setRestartTries(Integer restartTries) {
        this.restartTries = restartTries;
    }

    public ContainerBasicConfig sdnotifyMode(String sdnotifyMode) {
        this.sdnotifyMode = sdnotifyMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through \"container\" - let the OCI runtime deal with it, advertise conmon's MAINPID \"conmon-only\" - advertise conmon's MAINPID, send READY when started, don't pass to OCI \"ignore\" - unset NOTIFY_SOCKET Optional.")
    public String getSdnotifyMode() {
        return this.sdnotifyMode;
    }

    public void setSdnotifyMode(String sdnotifyMode) {
        this.sdnotifyMode = sdnotifyMode;
    }

    public ContainerBasicConfig secretEnv(Map<String, String> secretEnv) {
        this.secretEnv = secretEnv;
        return this;
    }

    public ContainerBasicConfig putSecretEnvItem(String key, String secretEnvItem) {
        if (this.secretEnv == null) {
            this.secretEnv = new HashMap<String, String>();
        }
        this.secretEnv.put(key, secretEnvItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvSecrets are secrets that will be set as environment variables Optional.")
    public Map<String, String> getSecretEnv() {
        return this.secretEnv;
    }

    public void setSecretEnv(Map<String, String> secretEnv) {
        this.secretEnv = secretEnv;
    }

    public ContainerBasicConfig stdin(Boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Stdin is whether the container will keep its STDIN open. Optional.")
    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public ContainerBasicConfig stopSignal(Long stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="It implements the [os.Signal] interface.")
    public Long getStopSignal() {
        return this.stopSignal;
    }

    public void setStopSignal(Long stopSignal) {
        this.stopSignal = stopSignal;
    }

    public ContainerBasicConfig stopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StopTimeout is a timeout between the container's stop signal being sent and SIGKILL being sent. If not provided, the default will be used. If 0 is used, stop signal will not be sent, and SIGKILL will be sent instead. Optional.")
    public Integer getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    public ContainerBasicConfig sysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
        return this;
    }

    public ContainerBasicConfig putSysctlItem(String key, String sysctlItem) {
        if (this.sysctl == null) {
            this.sysctl = new HashMap<String, String>();
        }
        this.sysctl.put(key, sysctlItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sysctl sets kernel parameters for the container")
    public Map<String, String> getSysctl() {
        return this.sysctl;
    }

    public void setSysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
    }

    public ContainerBasicConfig systemd(String systemd) {
        this.systemd = systemd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Systemd is whether the container will be started in systemd mode. Valid options are \"true\", \"false\", and \"always\". \"true\" enables this mode only if the binary run in the container is sbin/init or systemd. \"always\" unconditionally enables systemd mode. \"false\" unconditionally disables systemd mode. If enabled, mounts and stop signal will be modified. If set to \"always\" or set to \"true\" and conditionally triggered, conflicts with StopSignal. If not specified, \"false\" will be assumed. Optional.")
    public String getSystemd() {
        return this.systemd;
    }

    public void setSystemd(String systemd) {
        this.systemd = systemd;
    }

    public ContainerBasicConfig terminal(Boolean terminal) {
        this.terminal = terminal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Terminal is whether the container will create a PTY. Optional.")
    public Boolean getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Boolean terminal) {
        this.terminal = terminal;
    }

    public ContainerBasicConfig timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout is a maximum time in seconds the container will run before main process is sent SIGKILL. If 0 is used, signal will not be sent. Container can run indefinitely if they do not stop after the default termination signal. Optional.")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public ContainerBasicConfig timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timezone is the timezone inside the container. Local means it has the same timezone as the host machine Optional.")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public ContainerBasicConfig unsetenv(List<String> unsetenv) {
        this.unsetenv = unsetenv;
        return this;
    }

    public ContainerBasicConfig addUnsetenvItem(String unsetenvItem) {
        if (this.unsetenv == null) {
            this.unsetenv = new ArrayList<String>();
        }
        this.unsetenv.add(unsetenvItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UnsetEnv unsets the specified default environment variables from the image or from built-in or containers.conf Optional.")
    public List<String> getUnsetenv() {
        return this.unsetenv;
    }

    public void setUnsetenv(List<String> unsetenv) {
        this.unsetenv = unsetenv;
    }

    public ContainerBasicConfig unsetenvall(Boolean unsetenvall) {
        this.unsetenvall = unsetenvall;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UnsetEnvAll unsetall default environment variables from the image or from built-in or containers.conf UnsetEnvAll unsets all default environment variables from the image or from built-in Optional.")
    public Boolean getUnsetenvall() {
        return this.unsetenvall;
    }

    public void setUnsetenvall(Boolean unsetenvall) {
        this.unsetenvall = unsetenvall;
    }

    public ContainerBasicConfig utsns(Namespace utsns) {
        this.utsns = utsns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getUtsns() {
        return this.utsns;
    }

    public void setUtsns(Namespace utsns) {
        this.utsns = utsns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerBasicConfig containerBasicConfig = (ContainerBasicConfig)o;
        return Objects.equals(this.annotations, containerBasicConfig.annotations) && Objects.equals(this.command, containerBasicConfig.command) && Objects.equals(this.conmonPidFile, containerBasicConfig.conmonPidFile) && Objects.equals(this.containerCreateCommand, containerBasicConfig.containerCreateCommand) && Objects.equals(this.dependencyContainers, containerBasicConfig.dependencyContainers) && Objects.equals(this.entrypoint, containerBasicConfig.entrypoint) && Objects.equals(this.env, containerBasicConfig.env) && Objects.equals(this.envHost, containerBasicConfig.envHost) && Objects.equals(this.envmerge, containerBasicConfig.envmerge) && Objects.equals(this.groupEntry, containerBasicConfig.groupEntry) && Objects.equals(this.hostname, containerBasicConfig.hostname) && Objects.equals(this.hostusers, containerBasicConfig.hostusers) && Objects.equals(this.httpproxy, containerBasicConfig.httpproxy) && Objects.equals(this.initContainerType, containerBasicConfig.initContainerType) && Objects.equals(this.labels, containerBasicConfig.labels) && Objects.equals(this.logConfiguration, containerBasicConfig.logConfiguration) && Objects.equals(this.managePassword, containerBasicConfig.managePassword) && Objects.equals(this.name, containerBasicConfig.name) && Objects.equals(this.ociRuntime, containerBasicConfig.ociRuntime) && Objects.equals(this.passwdEntry, containerBasicConfig.passwdEntry) && Objects.equals(this.personality, containerBasicConfig.personality) && Objects.equals(this.pidns, containerBasicConfig.pidns) && Objects.equals(this.pod, containerBasicConfig.pod) && Objects.equals(this.remove, containerBasicConfig.remove) && Objects.equals(this.removeImage, containerBasicConfig.removeImage) && Objects.equals(this.restartPolicy, containerBasicConfig.restartPolicy) && Objects.equals(this.restartTries, containerBasicConfig.restartTries) && Objects.equals(this.sdnotifyMode, containerBasicConfig.sdnotifyMode) && Objects.equals(this.secretEnv, containerBasicConfig.secretEnv) && Objects.equals(this.stdin, containerBasicConfig.stdin) && Objects.equals(this.stopSignal, containerBasicConfig.stopSignal) && Objects.equals(this.stopTimeout, containerBasicConfig.stopTimeout) && Objects.equals(this.sysctl, containerBasicConfig.sysctl) && Objects.equals(this.systemd, containerBasicConfig.systemd) && Objects.equals(this.terminal, containerBasicConfig.terminal) && Objects.equals(this.timeout, containerBasicConfig.timeout) && Objects.equals(this.timezone, containerBasicConfig.timezone) && Objects.equals(this.unsetenv, containerBasicConfig.unsetenv) && Objects.equals(this.unsetenvall, containerBasicConfig.unsetenvall) && Objects.equals(this.utsns, containerBasicConfig.utsns);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.command, this.conmonPidFile, this.containerCreateCommand, this.dependencyContainers, this.entrypoint, this.env, this.envHost, this.envmerge, this.groupEntry, this.hostname, this.hostusers, this.httpproxy, this.initContainerType, this.labels, this.logConfiguration, this.managePassword, this.name, this.ociRuntime, this.passwdEntry, this.personality, this.pidns, this.pod, this.remove, this.removeImage, this.restartPolicy, this.restartTries, this.sdnotifyMode, this.secretEnv, this.stdin, this.stopSignal, this.stopTimeout, this.sysctl, this.systemd, this.terminal, this.timeout, this.timezone, this.unsetenv, this.unsetenvall, this.utsns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerBasicConfig {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    conmonPidFile: ").append(this.toIndentedString(this.conmonPidFile)).append("\n");
        sb.append("    containerCreateCommand: ").append(this.toIndentedString(this.containerCreateCommand)).append("\n");
        sb.append("    dependencyContainers: ").append(this.toIndentedString(this.dependencyContainers)).append("\n");
        sb.append("    entrypoint: ").append(this.toIndentedString(this.entrypoint)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    envHost: ").append(this.toIndentedString(this.envHost)).append("\n");
        sb.append("    envmerge: ").append(this.toIndentedString(this.envmerge)).append("\n");
        sb.append("    groupEntry: ").append(this.toIndentedString(this.groupEntry)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    hostusers: ").append(this.toIndentedString(this.hostusers)).append("\n");
        sb.append("    httpproxy: ").append(this.toIndentedString(this.httpproxy)).append("\n");
        sb.append("    initContainerType: ").append(this.toIndentedString(this.initContainerType)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    logConfiguration: ").append(this.toIndentedString(this.logConfiguration)).append("\n");
        sb.append("    managePassword: ").append(this.toIndentedString(this.managePassword)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ociRuntime: ").append(this.toIndentedString(this.ociRuntime)).append("\n");
        sb.append("    passwdEntry: ").append(this.toIndentedString(this.passwdEntry)).append("\n");
        sb.append("    personality: ").append(this.toIndentedString(this.personality)).append("\n");
        sb.append("    pidns: ").append(this.toIndentedString(this.pidns)).append("\n");
        sb.append("    pod: ").append(this.toIndentedString(this.pod)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("    removeImage: ").append(this.toIndentedString(this.removeImage)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    restartTries: ").append(this.toIndentedString(this.restartTries)).append("\n");
        sb.append("    sdnotifyMode: ").append(this.toIndentedString(this.sdnotifyMode)).append("\n");
        sb.append("    secretEnv: ").append(this.toIndentedString(this.secretEnv)).append("\n");
        sb.append("    stdin: ").append(this.toIndentedString(this.stdin)).append("\n");
        sb.append("    stopSignal: ").append(this.toIndentedString(this.stopSignal)).append("\n");
        sb.append("    stopTimeout: ").append(this.toIndentedString(this.stopTimeout)).append("\n");
        sb.append("    sysctl: ").append(this.toIndentedString(this.sysctl)).append("\n");
        sb.append("    systemd: ").append(this.toIndentedString(this.systemd)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    unsetenv: ").append(this.toIndentedString(this.unsetenv)).append("\n");
        sb.append("    unsetenvall: ").append(this.toIndentedString(this.unsetenvall)).append("\n");
        sb.append("    utsns: ").append(this.toIndentedString(this.utsns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerBasicConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerBasicConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE) != null && !jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `containerCreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dependencyContainers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRYPOINT) != null && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVMERGE) != null && !jsonObj.get(SERIALIZED_NAME_ENVMERGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENVMERGE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `envmerge` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVMERGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTUSERS) != null && !jsonObj.get(SERIALIZED_NAME_HOSTUSERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTUSERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostusers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTUSERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `init_container_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOG_CONFIGURATION) != null && !jsonObj.get(SERIALIZED_NAME_LOG_CONFIGURATION).isJsonNull()) {
            LogConfigLibpod.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LOG_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME) != null && !jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `oci_runtime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY) != null && !jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `passwd_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERSONALITY) != null && !jsonObj.get(SERIALIZED_NAME_PERSONALITY).isJsonNull()) {
            LinuxPersonality.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PERSONALITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_PIDNS) != null && !jsonObj.get(SERIALIZED_NAME_PIDNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PIDNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD) != null && !jsonObj.get(SERIALIZED_NAME_POD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdnotifyMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYSTEMD) != null && !jsonObj.get(SERIALIZED_NAME_SYSTEMD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYSTEMD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `systemd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYSTEMD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMEZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEZONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNSETENV) != null && !jsonObj.get(SERIALIZED_NAME_UNSETENV).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNSETENV).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unsetenv` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNSETENV).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UTSNS) != null && !jsonObj.get(SERIALIZED_NAME_UTSNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_UTSNS));
        }
    }

    public static ContainerBasicConfig fromJson(String jsonString) throws IOException {
        return (ContainerBasicConfig)JSON.getGson().fromJson(jsonString, ContainerBasicConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_COMMAND);
        openapiFields.add(SERIALIZED_NAME_CONMON_PID_FILE);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND);
        openapiFields.add(SERIALIZED_NAME_DEPENDENCY_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_ENTRYPOINT);
        openapiFields.add(SERIALIZED_NAME_ENV);
        openapiFields.add(SERIALIZED_NAME_ENV_HOST);
        openapiFields.add(SERIALIZED_NAME_ENVMERGE);
        openapiFields.add(SERIALIZED_NAME_GROUP_ENTRY);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_HOSTUSERS);
        openapiFields.add(SERIALIZED_NAME_HTTPPROXY);
        openapiFields.add(SERIALIZED_NAME_INIT_CONTAINER_TYPE);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_LOG_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_MANAGE_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_OCI_RUNTIME);
        openapiFields.add(SERIALIZED_NAME_PASSWD_ENTRY);
        openapiFields.add(SERIALIZED_NAME_PERSONALITY);
        openapiFields.add(SERIALIZED_NAME_PIDNS);
        openapiFields.add(SERIALIZED_NAME_POD);
        openapiFields.add(SERIALIZED_NAME_REMOVE);
        openapiFields.add(SERIALIZED_NAME_REMOVE_IMAGE);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RESTART_TRIES);
        openapiFields.add(SERIALIZED_NAME_SDNOTIFY_MODE);
        openapiFields.add(SERIALIZED_NAME_SECRET_ENV);
        openapiFields.add(SERIALIZED_NAME_STDIN);
        openapiFields.add(SERIALIZED_NAME_STOP_SIGNAL);
        openapiFields.add(SERIALIZED_NAME_STOP_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_SYSCTL);
        openapiFields.add(SERIALIZED_NAME_SYSTEMD);
        openapiFields.add(SERIALIZED_NAME_TERMINAL);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_TIMEZONE);
        openapiFields.add(SERIALIZED_NAME_UNSETENV);
        openapiFields.add(SERIALIZED_NAME_UNSETENVALL);
        openapiFields.add(SERIALIZED_NAME_UTSNS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContainerBasicConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContainerBasicConfig.class));
            return new TypeAdapter<ContainerBasicConfig>(){

                public void write(JsonWriter out, ContainerBasicConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContainerBasicConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContainerBasicConfig.validateJsonObject(jsonObj);
                    return (ContainerBasicConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

