/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.InspectSecret;
import io.github.pod4dev.libpodj.model.Schema2HealthConfig;
import io.github.pod4dev.libpodj.model.StartupHealthCheck;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="InspectContainerConfig holds further data about how a container was initially configured.")
public class InspectContainerConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ANNOTATIONS = "Annotations";
    @SerializedName(value="Annotations")
    private Map<String, String> annotations = null;
    public static final String SERIALIZED_NAME_ATTACH_STDERR = "AttachStderr";
    @SerializedName(value="AttachStderr")
    private Boolean attachStderr;
    public static final String SERIALIZED_NAME_ATTACH_STDIN = "AttachStdin";
    @SerializedName(value="AttachStdin")
    private Boolean attachStdin;
    public static final String SERIALIZED_NAME_ATTACH_STDOUT = "AttachStdout";
    @SerializedName(value="AttachStdout")
    private Boolean attachStdout;
    public static final String SERIALIZED_NAME_CHROOT_DIRS = "ChrootDirs";
    @SerializedName(value="ChrootDirs")
    private List<String> chrootDirs = null;
    public static final String SERIALIZED_NAME_CMD = "Cmd";
    @SerializedName(value="Cmd")
    private List<String> cmd = null;
    public static final String SERIALIZED_NAME_CREATE_COMMAND = "CreateCommand";
    @SerializedName(value="CreateCommand")
    private List<String> createCommand = null;
    public static final String SERIALIZED_NAME_DOMAINNAME = "Domainname";
    @SerializedName(value="Domainname")
    private String domainname;
    public static final String SERIALIZED_NAME_ENTRYPOINT = "Entrypoint";
    @SerializedName(value="Entrypoint")
    private List<String> entrypoint = null;
    public static final String SERIALIZED_NAME_ENV = "Env";
    @SerializedName(value="Env")
    private List<String> env = null;
    public static final String SERIALIZED_NAME_EXPOSED_PORTS = "ExposedPorts";
    @SerializedName(value="ExposedPorts")
    private Map<String, Object> exposedPorts = null;
    public static final String SERIALIZED_NAME_HEALTH_LOG_DESTINATION = "HealthLogDestination";
    @SerializedName(value="HealthLogDestination")
    private String healthLogDestination;
    public static final String SERIALIZED_NAME_HEALTHCHECK = "Healthcheck";
    @SerializedName(value="Healthcheck")
    private Schema2HealthConfig healthcheck;
    public static final String SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_COUNT = "HealthcheckMaxLogCount";
    @SerializedName(value="HealthcheckMaxLogCount")
    private Integer healthcheckMaxLogCount;
    public static final String SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_SIZE = "HealthcheckMaxLogSize";
    @SerializedName(value="HealthcheckMaxLogSize")
    private Integer healthcheckMaxLogSize;
    public static final String SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION = "HealthcheckOnFailureAction";
    @SerializedName(value="HealthcheckOnFailureAction")
    private String healthcheckOnFailureAction;
    public static final String SERIALIZED_NAME_HOSTNAME = "Hostname";
    @SerializedName(value="Hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_IMAGE = "Image";
    @SerializedName(value="Image")
    private String image;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_ON_BUILD = "OnBuild";
    @SerializedName(value="OnBuild")
    private String onBuild;
    public static final String SERIALIZED_NAME_OPEN_STDIN = "OpenStdin";
    @SerializedName(value="OpenStdin")
    private Boolean openStdin;
    public static final String SERIALIZED_NAME_PASSWD = "Passwd";
    @SerializedName(value="Passwd")
    private Boolean passwd;
    public static final String SERIALIZED_NAME_SECRETS = "Secrets";
    @SerializedName(value="Secrets")
    private List<InspectSecret> secrets = null;
    public static final String SERIALIZED_NAME_STARTUP_HEALTH_CHECK = "StartupHealthCheck";
    @SerializedName(value="StartupHealthCheck")
    private StartupHealthCheck startupHealthCheck;
    public static final String SERIALIZED_NAME_STDIN_ONCE = "StdinOnce";
    @SerializedName(value="StdinOnce")
    private Boolean stdinOnce;
    public static final String SERIALIZED_NAME_STOP_SIGNAL = "StopSignal";
    @SerializedName(value="StopSignal")
    private String stopSignal;
    public static final String SERIALIZED_NAME_STOP_TIMEOUT = "StopTimeout";
    @SerializedName(value="StopTimeout")
    private Integer stopTimeout;
    public static final String SERIALIZED_NAME_SYSTEMD_MODE = "SystemdMode";
    @SerializedName(value="SystemdMode")
    private Boolean systemdMode;
    public static final String SERIALIZED_NAME_TIMEOUT = "Timeout";
    @SerializedName(value="Timeout")
    private Integer timeout;
    public static final String SERIALIZED_NAME_TIMEZONE = "Timezone";
    @SerializedName(value="Timezone")
    private String timezone;
    public static final String SERIALIZED_NAME_TTY = "Tty";
    @SerializedName(value="Tty")
    private Boolean tty;
    public static final String SERIALIZED_NAME_UMASK = "Umask";
    @SerializedName(value="Umask")
    private String umask;
    public static final String SERIALIZED_NAME_USER = "User";
    @SerializedName(value="User")
    private String user;
    public static final String SERIALIZED_NAME_VOLUMES = "Volumes";
    @SerializedName(value="Volumes")
    private Map<String, Object> volumes = null;
    public static final String SERIALIZED_NAME_WORKING_DIR = "WorkingDir";
    @SerializedName(value="WorkingDir")
    private String workingDir;
    public static final String SERIALIZED_NAME_SD_NOTIFY_MODE = "sdNotifyMode";
    @SerializedName(value="sdNotifyMode")
    private String sdNotifyMode;
    public static final String SERIALIZED_NAME_SD_NOTIFY_SOCKET = "sdNotifySocket";
    @SerializedName(value="sdNotifySocket")
    private String sdNotifySocket;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectContainerConfig annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public InspectContainerConfig putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public InspectContainerConfig attachStderr(Boolean attachStderr) {
        this.attachStderr = attachStderr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unused, at present")
    public Boolean getAttachStderr() {
        return this.attachStderr;
    }

    public void setAttachStderr(Boolean attachStderr) {
        this.attachStderr = attachStderr;
    }

    public InspectContainerConfig attachStdin(Boolean attachStdin) {
        this.attachStdin = attachStdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unused, at present")
    public Boolean getAttachStdin() {
        return this.attachStdin;
    }

    public void setAttachStdin(Boolean attachStdin) {
        this.attachStdin = attachStdin;
    }

    public InspectContainerConfig attachStdout(Boolean attachStdout) {
        this.attachStdout = attachStdout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unused, at present")
    public Boolean getAttachStdout() {
        return this.attachStdout;
    }

    public void setAttachStdout(Boolean attachStdout) {
        this.attachStdout = attachStdout;
    }

    public InspectContainerConfig chrootDirs(List<String> chrootDirs) {
        this.chrootDirs = chrootDirs;
        return this;
    }

    public InspectContainerConfig addChrootDirsItem(String chrootDirsItem) {
        if (this.chrootDirs == null) {
            this.chrootDirs = new ArrayList<String>();
        }
        this.chrootDirs.add(chrootDirsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ChrootDirs is an additional set of directories that need to be treated as root directories. Standard bind mounts will be mounted into paths relative to these directories.")
    public List<String> getChrootDirs() {
        return this.chrootDirs;
    }

    public void setChrootDirs(List<String> chrootDirs) {
        this.chrootDirs = chrootDirs;
    }

    public InspectContainerConfig cmd(List<String> cmd) {
        this.cmd = cmd;
        return this;
    }

    public InspectContainerConfig addCmdItem(String cmdItem) {
        if (this.cmd == null) {
            this.cmd = new ArrayList<String>();
        }
        this.cmd.add(cmdItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container command")
    public List<String> getCmd() {
        return this.cmd;
    }

    public void setCmd(List<String> cmd) {
        this.cmd = cmd;
    }

    public InspectContainerConfig createCommand(List<String> createCommand) {
        this.createCommand = createCommand;
        return this;
    }

    public InspectContainerConfig addCreateCommandItem(String createCommandItem) {
        if (this.createCommand == null) {
            this.createCommand = new ArrayList<String>();
        }
        this.createCommand.add(createCommandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CreateCommand is the full command plus arguments of the process the container has been created with.")
    public List<String> getCreateCommand() {
        return this.createCommand;
    }

    public void setCreateCommand(List<String> createCommand) {
        this.createCommand = createCommand;
    }

    public InspectContainerConfig domainname(String domainname) {
        this.domainname = domainname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container domain name - unused at present")
    public String getDomainname() {
        return this.domainname;
    }

    public void setDomainname(String domainname) {
        this.domainname = domainname;
    }

    public InspectContainerConfig entrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public InspectContainerConfig addEntrypointItem(String entrypointItem) {
        if (this.entrypoint == null) {
            this.entrypoint = new ArrayList<String>();
        }
        this.entrypoint.add(entrypointItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container entrypoint")
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public InspectContainerConfig env(List<String> env) {
        this.env = env;
        return this;
    }

    public InspectContainerConfig addEnvItem(String envItem) {
        if (this.env == null) {
            this.env = new ArrayList<String>();
        }
        this.env.add(envItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container environment variables")
    public List<String> getEnv() {
        return this.env;
    }

    public void setEnv(List<String> env) {
        this.env = env;
    }

    public InspectContainerConfig exposedPorts(Map<String, Object> exposedPorts) {
        this.exposedPorts = exposedPorts;
        return this;
    }

    public InspectContainerConfig putExposedPortsItem(String key, Object exposedPortsItem) {
        if (this.exposedPorts == null) {
            this.exposedPorts = new HashMap<String, Object>();
        }
        this.exposedPorts.put(key, exposedPortsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExposedPorts includes ports the container has exposed.")
    public Map<String, Object> getExposedPorts() {
        return this.exposedPorts;
    }

    public void setExposedPorts(Map<String, Object> exposedPorts) {
        this.exposedPorts = exposedPorts;
    }

    public InspectContainerConfig healthLogDestination(String healthLogDestination) {
        this.healthLogDestination = healthLogDestination;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthLogDestination defines the destination where the log is stored")
    public String getHealthLogDestination() {
        return this.healthLogDestination;
    }

    public void setHealthLogDestination(String healthLogDestination) {
        this.healthLogDestination = healthLogDestination;
    }

    public InspectContainerConfig healthcheck(Schema2HealthConfig healthcheck) {
        this.healthcheck = healthcheck;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Schema2HealthConfig getHealthcheck() {
        return this.healthcheck;
    }

    public void setHealthcheck(Schema2HealthConfig healthcheck) {
        this.healthcheck = healthcheck;
    }

    public InspectContainerConfig healthcheckMaxLogCount(Integer healthcheckMaxLogCount) {
        this.healthcheckMaxLogCount = healthcheckMaxLogCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthMaxLogCount is maximum number of attempts in the HealthCheck log file. ('0' value means an infinite number of attempts in the log file)")
    public Integer getHealthcheckMaxLogCount() {
        return this.healthcheckMaxLogCount;
    }

    public void setHealthcheckMaxLogCount(Integer healthcheckMaxLogCount) {
        this.healthcheckMaxLogCount = healthcheckMaxLogCount;
    }

    public InspectContainerConfig healthcheckMaxLogSize(Integer healthcheckMaxLogSize) {
        this.healthcheckMaxLogSize = healthcheckMaxLogSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthMaxLogSize is the maximum length in characters of stored HealthCheck log (\"0\" value means an infinite log length)")
    public Integer getHealthcheckMaxLogSize() {
        return this.healthcheckMaxLogSize;
    }

    public void setHealthcheckMaxLogSize(Integer healthcheckMaxLogSize) {
        this.healthcheckMaxLogSize = healthcheckMaxLogSize;
    }

    public InspectContainerConfig healthcheckOnFailureAction(String healthcheckOnFailureAction) {
        this.healthcheckOnFailureAction = healthcheckOnFailureAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthcheckOnFailureAction defines an action to take once the container turns unhealthy.")
    public String getHealthcheckOnFailureAction() {
        return this.healthcheckOnFailureAction;
    }

    public void setHealthcheckOnFailureAction(String healthcheckOnFailureAction) {
        this.healthcheckOnFailureAction = healthcheckOnFailureAction;
    }

    public InspectContainerConfig hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container hostname")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public InspectContainerConfig image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public InspectContainerConfig labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public InspectContainerConfig putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container labels")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public InspectContainerConfig onBuild(String onBuild) {
        this.onBuild = onBuild;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="On-build arguments - presently unused. More of Buildah's domain.")
    public String getOnBuild() {
        return this.onBuild;
    }

    public void setOnBuild(String onBuild) {
        this.onBuild = onBuild;
    }

    public InspectContainerConfig openStdin(Boolean openStdin) {
        this.openStdin = openStdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the container leaves STDIN open")
    public Boolean getOpenStdin() {
        return this.openStdin;
    }

    public void setOpenStdin(Boolean openStdin) {
        this.openStdin = openStdin;
    }

    public InspectContainerConfig passwd(Boolean passwd) {
        this.passwd = passwd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Passwd determines whether or not podman can add entries to /etc/passwd and /etc/group")
    public Boolean getPasswd() {
        return this.passwd;
    }

    public void setPasswd(Boolean passwd) {
        this.passwd = passwd;
    }

    public InspectContainerConfig secrets(List<InspectSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public InspectContainerConfig addSecretsItem(InspectSecret secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<InspectSecret>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Secrets are the secrets mounted in the container")
    public List<InspectSecret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<InspectSecret> secrets) {
        this.secrets = secrets;
    }

    public InspectContainerConfig startupHealthCheck(StartupHealthCheck startupHealthCheck) {
        this.startupHealthCheck = startupHealthCheck;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public StartupHealthCheck getStartupHealthCheck() {
        return this.startupHealthCheck;
    }

    public void setStartupHealthCheck(StartupHealthCheck startupHealthCheck) {
        this.startupHealthCheck = startupHealthCheck;
    }

    public InspectContainerConfig stdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether STDIN is only left open once. Presently not supported by Podman, unused.")
    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public InspectContainerConfig stopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container stop signal")
    public String getStopSignal() {
        return this.stopSignal;
    }

    public void setStopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
    }

    public InspectContainerConfig stopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StopTimeout is time before container is stopped when calling stop")
    public Integer getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    public InspectContainerConfig systemdMode(Boolean systemdMode) {
        this.systemdMode = systemdMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SystemdMode is whether the container is running in systemd mode. In systemd mode, the container configuration is customized to optimize running systemd in the container.")
    public Boolean getSystemdMode() {
        return this.systemdMode;
    }

    public void setSystemdMode(Boolean systemdMode) {
        this.systemdMode = systemdMode;
    }

    public InspectContainerConfig timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout is time before container is killed by conmon")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public InspectContainerConfig timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timezone is the timezone inside the container. Local means it has the same timezone as the host machine")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public InspectContainerConfig tty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the container creates a TTY")
    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public InspectContainerConfig umask(String umask) {
        this.umask = umask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Umask is the umask inside the container.")
    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public InspectContainerConfig user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User the container was launched with")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public InspectContainerConfig volumes(Map<String, Object> volumes) {
        this.volumes = volumes;
        return this;
    }

    public InspectContainerConfig putVolumesItem(String key, Object volumesItem) {
        if (this.volumes == null) {
            this.volumes = new HashMap<String, Object>();
        }
        this.volumes.put(key, volumesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unused, at present. I've never seen this field populated.")
    public Map<String, Object> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Map<String, Object> volumes) {
        this.volumes = volumes;
    }

    public InspectContainerConfig workingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container working directory")
    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public InspectContainerConfig sdNotifyMode(String sdNotifyMode) {
        this.sdNotifyMode = sdNotifyMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SdNotifyMode is the sd-notify mode of the container.")
    public String getSdNotifyMode() {
        return this.sdNotifyMode;
    }

    public void setSdNotifyMode(String sdNotifyMode) {
        this.sdNotifyMode = sdNotifyMode;
    }

    public InspectContainerConfig sdNotifySocket(String sdNotifySocket) {
        this.sdNotifySocket = sdNotifySocket;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SdNotifySocket is the NOTIFY_SOCKET in use by/configured for the container.")
    public String getSdNotifySocket() {
        return this.sdNotifySocket;
    }

    public void setSdNotifySocket(String sdNotifySocket) {
        this.sdNotifySocket = sdNotifySocket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectContainerConfig inspectContainerConfig = (InspectContainerConfig)o;
        return Objects.equals(this.annotations, inspectContainerConfig.annotations) && Objects.equals(this.attachStderr, inspectContainerConfig.attachStderr) && Objects.equals(this.attachStdin, inspectContainerConfig.attachStdin) && Objects.equals(this.attachStdout, inspectContainerConfig.attachStdout) && Objects.equals(this.chrootDirs, inspectContainerConfig.chrootDirs) && Objects.equals(this.cmd, inspectContainerConfig.cmd) && Objects.equals(this.createCommand, inspectContainerConfig.createCommand) && Objects.equals(this.domainname, inspectContainerConfig.domainname) && Objects.equals(this.entrypoint, inspectContainerConfig.entrypoint) && Objects.equals(this.env, inspectContainerConfig.env) && Objects.equals(this.exposedPorts, inspectContainerConfig.exposedPorts) && Objects.equals(this.healthLogDestination, inspectContainerConfig.healthLogDestination) && Objects.equals(this.healthcheck, inspectContainerConfig.healthcheck) && Objects.equals(this.healthcheckMaxLogCount, inspectContainerConfig.healthcheckMaxLogCount) && Objects.equals(this.healthcheckMaxLogSize, inspectContainerConfig.healthcheckMaxLogSize) && Objects.equals(this.healthcheckOnFailureAction, inspectContainerConfig.healthcheckOnFailureAction) && Objects.equals(this.hostname, inspectContainerConfig.hostname) && Objects.equals(this.image, inspectContainerConfig.image) && Objects.equals(this.labels, inspectContainerConfig.labels) && Objects.equals(this.onBuild, inspectContainerConfig.onBuild) && Objects.equals(this.openStdin, inspectContainerConfig.openStdin) && Objects.equals(this.passwd, inspectContainerConfig.passwd) && Objects.equals(this.secrets, inspectContainerConfig.secrets) && Objects.equals(this.startupHealthCheck, inspectContainerConfig.startupHealthCheck) && Objects.equals(this.stdinOnce, inspectContainerConfig.stdinOnce) && Objects.equals(this.stopSignal, inspectContainerConfig.stopSignal) && Objects.equals(this.stopTimeout, inspectContainerConfig.stopTimeout) && Objects.equals(this.systemdMode, inspectContainerConfig.systemdMode) && Objects.equals(this.timeout, inspectContainerConfig.timeout) && Objects.equals(this.timezone, inspectContainerConfig.timezone) && Objects.equals(this.tty, inspectContainerConfig.tty) && Objects.equals(this.umask, inspectContainerConfig.umask) && Objects.equals(this.user, inspectContainerConfig.user) && Objects.equals(this.volumes, inspectContainerConfig.volumes) && Objects.equals(this.workingDir, inspectContainerConfig.workingDir) && Objects.equals(this.sdNotifyMode, inspectContainerConfig.sdNotifyMode) && Objects.equals(this.sdNotifySocket, inspectContainerConfig.sdNotifySocket);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.attachStderr, this.attachStdin, this.attachStdout, this.chrootDirs, this.cmd, this.createCommand, this.domainname, this.entrypoint, this.env, this.exposedPorts, this.healthLogDestination, this.healthcheck, this.healthcheckMaxLogCount, this.healthcheckMaxLogSize, this.healthcheckOnFailureAction, this.hostname, this.image, this.labels, this.onBuild, this.openStdin, this.passwd, this.secrets, this.startupHealthCheck, this.stdinOnce, this.stopSignal, this.stopTimeout, this.systemdMode, this.timeout, this.timezone, this.tty, this.umask, this.user, this.volumes, this.workingDir, this.sdNotifyMode, this.sdNotifySocket);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectContainerConfig {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    attachStderr: ").append(this.toIndentedString(this.attachStderr)).append("\n");
        sb.append("    attachStdin: ").append(this.toIndentedString(this.attachStdin)).append("\n");
        sb.append("    attachStdout: ").append(this.toIndentedString(this.attachStdout)).append("\n");
        sb.append("    chrootDirs: ").append(this.toIndentedString(this.chrootDirs)).append("\n");
        sb.append("    cmd: ").append(this.toIndentedString(this.cmd)).append("\n");
        sb.append("    createCommand: ").append(this.toIndentedString(this.createCommand)).append("\n");
        sb.append("    domainname: ").append(this.toIndentedString(this.domainname)).append("\n");
        sb.append("    entrypoint: ").append(this.toIndentedString(this.entrypoint)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    exposedPorts: ").append(this.toIndentedString(this.exposedPorts)).append("\n");
        sb.append("    healthLogDestination: ").append(this.toIndentedString(this.healthLogDestination)).append("\n");
        sb.append("    healthcheck: ").append(this.toIndentedString(this.healthcheck)).append("\n");
        sb.append("    healthcheckMaxLogCount: ").append(this.toIndentedString(this.healthcheckMaxLogCount)).append("\n");
        sb.append("    healthcheckMaxLogSize: ").append(this.toIndentedString(this.healthcheckMaxLogSize)).append("\n");
        sb.append("    healthcheckOnFailureAction: ").append(this.toIndentedString(this.healthcheckOnFailureAction)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    onBuild: ").append(this.toIndentedString(this.onBuild)).append("\n");
        sb.append("    openStdin: ").append(this.toIndentedString(this.openStdin)).append("\n");
        sb.append("    passwd: ").append(this.toIndentedString(this.passwd)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("    startupHealthCheck: ").append(this.toIndentedString(this.startupHealthCheck)).append("\n");
        sb.append("    stdinOnce: ").append(this.toIndentedString(this.stdinOnce)).append("\n");
        sb.append("    stopSignal: ").append(this.toIndentedString(this.stopSignal)).append("\n");
        sb.append("    stopTimeout: ").append(this.toIndentedString(this.stopTimeout)).append("\n");
        sb.append("    systemdMode: ").append(this.toIndentedString(this.systemdMode)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    tty: ").append(this.toIndentedString(this.tty)).append("\n");
        sb.append("    umask: ").append(this.toIndentedString(this.umask)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    workingDir: ").append(this.toIndentedString(this.workingDir)).append("\n");
        sb.append("    sdNotifyMode: ").append(this.toIndentedString(this.sdNotifyMode)).append("\n");
        sb.append("    sdNotifySocket: ").append(this.toIndentedString(this.sdNotifySocket)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysecrets;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectContainerConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectContainerConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHROOT_DIRS) != null && !jsonObj.get(SERIALIZED_NAME_CHROOT_DIRS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CHROOT_DIRS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ChrootDirs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHROOT_DIRS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CMD) != null && !jsonObj.get(SERIALIZED_NAME_CMD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CMD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Cmd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CMD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `CreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOMAINNAME) != null && !jsonObj.get(SERIALIZED_NAME_DOMAINNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOMAINNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Domainname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOMAINNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRYPOINT) != null && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENV) != null && !jsonObj.get(SERIALIZED_NAME_ENV).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENV).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Env` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENV).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION) != null && !jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `HealthLogDestination` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTHCHECK) != null && !jsonObj.get(SERIALIZED_NAME_HEALTHCHECK).isJsonNull()) {
            Schema2HealthConfig.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HEALTHCHECK));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION) != null && !jsonObj.get(SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `HealthcheckOnFailureAction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ON_BUILD) != null && !jsonObj.get(SERIALIZED_NAME_ON_BUILD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ON_BUILD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `OnBuild` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ON_BUILD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRETS) != null && !jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonNull() && (jsonArraysecrets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECRETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Secrets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRETS).toString()));
            }
            for (int i = 0; i < jsonArraysecrets.size(); ++i) {
                InspectSecret.validateJsonObject(jsonArraysecrets.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STARTUP_HEALTH_CHECK) != null && !jsonObj.get(SERIALIZED_NAME_STARTUP_HEALTH_CHECK).isJsonNull()) {
            StartupHealthCheck.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STARTUP_HEALTH_CHECK));
        }
        if (jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL) != null && !jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `StopSignal` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STOP_SIGNAL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMEZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEZONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UMASK) != null && !jsonObj.get(SERIALIZED_NAME_UMASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UMASK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Umask` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UMASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `User` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WORKING_DIR) != null && !jsonObj.get(SERIALIZED_NAME_WORKING_DIR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WORKING_DIR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `WorkingDir` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORKING_DIR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdNotifyMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_SOCKET) != null && !jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_SOCKET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_SOCKET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdNotifySocket` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SD_NOTIFY_SOCKET).toString()));
        }
    }

    public static InspectContainerConfig fromJson(String jsonString) throws IOException {
        return (InspectContainerConfig)JSON.getGson().fromJson(jsonString, InspectContainerConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_ATTACH_STDERR);
        openapiFields.add(SERIALIZED_NAME_ATTACH_STDIN);
        openapiFields.add(SERIALIZED_NAME_ATTACH_STDOUT);
        openapiFields.add(SERIALIZED_NAME_CHROOT_DIRS);
        openapiFields.add(SERIALIZED_NAME_CMD);
        openapiFields.add(SERIALIZED_NAME_CREATE_COMMAND);
        openapiFields.add(SERIALIZED_NAME_DOMAINNAME);
        openapiFields.add(SERIALIZED_NAME_ENTRYPOINT);
        openapiFields.add(SERIALIZED_NAME_ENV);
        openapiFields.add(SERIALIZED_NAME_EXPOSED_PORTS);
        openapiFields.add(SERIALIZED_NAME_HEALTH_LOG_DESTINATION);
        openapiFields.add(SERIALIZED_NAME_HEALTHCHECK);
        openapiFields.add(SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_COUNT);
        openapiFields.add(SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_SIZE);
        openapiFields.add(SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_ON_BUILD);
        openapiFields.add(SERIALIZED_NAME_OPEN_STDIN);
        openapiFields.add(SERIALIZED_NAME_PASSWD);
        openapiFields.add(SERIALIZED_NAME_SECRETS);
        openapiFields.add(SERIALIZED_NAME_STARTUP_HEALTH_CHECK);
        openapiFields.add(SERIALIZED_NAME_STDIN_ONCE);
        openapiFields.add(SERIALIZED_NAME_STOP_SIGNAL);
        openapiFields.add(SERIALIZED_NAME_STOP_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_SYSTEMD_MODE);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_TIMEZONE);
        openapiFields.add(SERIALIZED_NAME_TTY);
        openapiFields.add(SERIALIZED_NAME_UMASK);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_WORKING_DIR);
        openapiFields.add(SERIALIZED_NAME_SD_NOTIFY_MODE);
        openapiFields.add(SERIALIZED_NAME_SD_NOTIFY_SOCKET);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectContainerConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectContainerConfig.class));
            return new TypeAdapter<InspectContainerConfig>(){

                public void write(JsonWriter out, InspectContainerConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectContainerConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectContainerConfig.validateJsonObject(jsonObj);
                    return (InspectContainerConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

