/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="InspectExecProcess contains information about the process in a given exec session.")
public class InspectExecProcess
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ARGUMENTS = "arguments";
    @SerializedName(value="arguments")
    private List<String> arguments = null;
    public static final String SERIALIZED_NAME_ENTRYPOINT = "entrypoint";
    @SerializedName(value="entrypoint")
    private String entrypoint;
    public static final String SERIALIZED_NAME_PRIVILEGED = "privileged";
    @SerializedName(value="privileged")
    private Boolean privileged;
    public static final String SERIALIZED_NAME_TTY = "tty";
    @SerializedName(value="tty")
    private Boolean tty;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectExecProcess arguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public InspectExecProcess addArgumentsItem(String argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Arguments are the arguments to the entrypoint command of the exec session.")
    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public InspectExecProcess entrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Entrypoint is the entrypoint for the exec session (the command that will be executed in the container).")
    public String getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
    }

    public InspectExecProcess privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Privileged is whether the exec session will be started with elevated privileges.")
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public InspectExecProcess tty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tty is whether the exec session created a terminal.")
    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public InspectExecProcess user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User is the user the exec session was started as.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectExecProcess inspectExecProcess = (InspectExecProcess)o;
        return Objects.equals(this.arguments, inspectExecProcess.arguments) && Objects.equals(this.entrypoint, inspectExecProcess.entrypoint) && Objects.equals(this.privileged, inspectExecProcess.privileged) && Objects.equals(this.tty, inspectExecProcess.tty) && Objects.equals(this.user, inspectExecProcess.user);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.entrypoint, this.privileged, this.tty, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectExecProcess {\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    entrypoint: ").append(this.toIndentedString(this.entrypoint)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    tty: ").append(this.toIndentedString(this.tty)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectExecProcess is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectExecProcess` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARGUMENTS) != null && !jsonObj.get(SERIALIZED_NAME_ARGUMENTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARGUMENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `arguments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARGUMENTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRYPOINT) != null && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `entrypoint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
    }

    public static InspectExecProcess fromJson(String jsonString) throws IOException {
        return (InspectExecProcess)JSON.getGson().fromJson(jsonString, InspectExecProcess.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARGUMENTS);
        openapiFields.add(SERIALIZED_NAME_ENTRYPOINT);
        openapiFields.add(SERIALIZED_NAME_PRIVILEGED);
        openapiFields.add(SERIALIZED_NAME_TTY);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectExecProcess.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectExecProcess.class));
            return new TypeAdapter<InspectExecProcess>(){

                public void write(JsonWriter out, InspectExecProcess value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectExecProcess read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectExecProcess.validateJsonObject(jsonObj);
                    return (InspectExecProcess)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

