/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.InspectHostPort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="InspectPodInfraConfig contains the configuration of the pod's infra container.")
public class InspectPodInfraConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DN_S_OPTION = "DNSOption";
    @SerializedName(value="DNSOption")
    private List<String> dnSOption = null;
    public static final String SERIALIZED_NAME_DN_S_SEARCH = "DNSSearch";
    @SerializedName(value="DNSSearch")
    private List<String> dnSSearch = null;
    public static final String SERIALIZED_NAME_DN_S_SERVER = "DNSServer";
    @SerializedName(value="DNSServer")
    private List<String> dnSServer = null;
    public static final String SERIALIZED_NAME_HOST_ADD = "HostAdd";
    @SerializedName(value="HostAdd")
    private List<String> hostAdd = null;
    public static final String SERIALIZED_NAME_HOST_NETWORK = "HostNetwork";
    @SerializedName(value="HostNetwork")
    private Boolean hostNetwork;
    public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "NetworkOptions";
    @SerializedName(value="NetworkOptions")
    private Map<String, List<String>> networkOptions = null;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private List<String> networks = null;
    public static final String SERIALIZED_NAME_NO_MANAGE_HOSTS = "NoManageHosts";
    @SerializedName(value="NoManageHosts")
    private Boolean noManageHosts;
    public static final String SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF = "NoManageResolvConf";
    @SerializedName(value="NoManageResolvConf")
    private Boolean noManageResolvConf;
    public static final String SERIALIZED_NAME_PORT_BINDINGS = "PortBindings";
    @SerializedName(value="PortBindings")
    private Map<String, List<InspectHostPort>> portBindings = null;
    public static final String SERIALIZED_NAME_STATIC_I_P = "StaticIP";
    @SerializedName(value="StaticIP")
    private String staticIP;
    public static final String SERIALIZED_NAME_STATIC_M_A_C = "StaticMAC";
    @SerializedName(value="StaticMAC")
    private String staticMAC;
    public static final String SERIALIZED_NAME_CPU_PERIOD = "cpu_period";
    @SerializedName(value="cpu_period")
    private Integer cpuPeriod;
    public static final String SERIALIZED_NAME_CPU_QUOTA = "cpu_quota";
    @SerializedName(value="cpu_quota")
    private Long cpuQuota;
    public static final String SERIALIZED_NAME_CPUSET_CPUS = "cpuset_cpus";
    @SerializedName(value="cpuset_cpus")
    private String cpusetCpus;
    public static final String SERIALIZED_NAME_PID_NS = "pid_ns";
    @SerializedName(value="pid_ns")
    private String pidNs;
    public static final String SERIALIZED_NAME_USERNS = "userns";
    @SerializedName(value="userns")
    private String userns;
    public static final String SERIALIZED_NAME_UTS_NS = "uts_ns";
    @SerializedName(value="uts_ns")
    private String utsNs;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectPodInfraConfig dnSOption(List<String> dnSOption) {
        this.dnSOption = dnSOption;
        return this;
    }

    public InspectPodInfraConfig addDnSOptionItem(String dnSOptionItem) {
        if (this.dnSOption == null) {
            this.dnSOption = new ArrayList<String>();
        }
        this.dnSOption.add(dnSOptionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSOption is a set of DNS options that will be used by the infra container's resolv.conf and shared with the remainder of the pod.")
    public List<String> getDnSOption() {
        return this.dnSOption;
    }

    public void setDnSOption(List<String> dnSOption) {
        this.dnSOption = dnSOption;
    }

    public InspectPodInfraConfig dnSSearch(List<String> dnSSearch) {
        this.dnSSearch = dnSSearch;
        return this;
    }

    public InspectPodInfraConfig addDnSSearchItem(String dnSSearchItem) {
        if (this.dnSSearch == null) {
            this.dnSSearch = new ArrayList<String>();
        }
        this.dnSSearch.add(dnSSearchItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSSearch is a set of DNS search domains that will be used by the infra container's resolv.conf and shared with the remainder of the pod.")
    public List<String> getDnSSearch() {
        return this.dnSSearch;
    }

    public void setDnSSearch(List<String> dnSSearch) {
        this.dnSSearch = dnSSearch;
    }

    public InspectPodInfraConfig dnSServer(List<String> dnSServer) {
        this.dnSServer = dnSServer;
        return this;
    }

    public InspectPodInfraConfig addDnSServerItem(String dnSServerItem) {
        if (this.dnSServer == null) {
            this.dnSServer = new ArrayList<String>();
        }
        this.dnSServer.add(dnSServerItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSServer is a set of DNS Servers that will be used by the infra container's resolv.conf and shared with the remainder of the pod.")
    public List<String> getDnSServer() {
        return this.dnSServer;
    }

    public void setDnSServer(List<String> dnSServer) {
        this.dnSServer = dnSServer;
    }

    public InspectPodInfraConfig hostAdd(List<String> hostAdd) {
        this.hostAdd = hostAdd;
        return this;
    }

    public InspectPodInfraConfig addHostAddItem(String hostAddItem) {
        if (this.hostAdd == null) {
            this.hostAdd = new ArrayList<String>();
        }
        this.hostAdd.add(hostAddItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostAdd adds a number of hosts to the infra container's resolv.conf which will be shared with the rest of the pod.")
    public List<String> getHostAdd() {
        return this.hostAdd;
    }

    public void setHostAdd(List<String> hostAdd) {
        this.hostAdd = hostAdd;
    }

    public InspectPodInfraConfig hostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostNetwork is whether the infra container (and thus the whole pod) will use the host's network and not create a network namespace.")
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public InspectPodInfraConfig networkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
        return this;
    }

    public InspectPodInfraConfig putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
        if (this.networkOptions == null) {
            this.networkOptions = new HashMap<String, List<String>>();
        }
        this.networkOptions.put(key, networkOptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="NetworkOptions are additional options for each network")
    public Map<String, List<String>> getNetworkOptions() {
        return this.networkOptions;
    }

    public void setNetworkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
    }

    public InspectPodInfraConfig networks(List<String> networks) {
        this.networks = networks;
        return this;
    }

    public InspectPodInfraConfig addNetworksItem(String networksItem) {
        if (this.networks == null) {
            this.networks = new ArrayList<String>();
        }
        this.networks.add(networksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Networks is a list of networks the pod will join.")
    public List<String> getNetworks() {
        return this.networks;
    }

    public void setNetworks(List<String> networks) {
        this.networks = networks;
    }

    public InspectPodInfraConfig noManageHosts(Boolean noManageHosts) {
        this.noManageHosts = noManageHosts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NoManageHosts indicates that the pod will not manage /etc/hosts and instead each container will handle their own.")
    public Boolean getNoManageHosts() {
        return this.noManageHosts;
    }

    public void setNoManageHosts(Boolean noManageHosts) {
        this.noManageHosts = noManageHosts;
    }

    public InspectPodInfraConfig noManageResolvConf(Boolean noManageResolvConf) {
        this.noManageResolvConf = noManageResolvConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NoManageResolvConf indicates that the pod will not manage resolv.conf and instead each container will handle their own.")
    public Boolean getNoManageResolvConf() {
        return this.noManageResolvConf;
    }

    public void setNoManageResolvConf(Boolean noManageResolvConf) {
        this.noManageResolvConf = noManageResolvConf;
    }

    public InspectPodInfraConfig portBindings(Map<String, List<InspectHostPort>> portBindings) {
        this.portBindings = portBindings;
        return this;
    }

    public InspectPodInfraConfig putPortBindingsItem(String key, List<InspectHostPort> portBindingsItem) {
        if (this.portBindings == null) {
            this.portBindings = new HashMap<String, List<InspectHostPort>>();
        }
        this.portBindings.put(key, portBindingsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="PortBindings are ports that will be forwarded to the infra container and then shared with the pod.")
    public Map<String, List<InspectHostPort>> getPortBindings() {
        return this.portBindings;
    }

    public void setPortBindings(Map<String, List<InspectHostPort>> portBindings) {
        this.portBindings = portBindings;
    }

    public InspectPodInfraConfig staticIP(String staticIP) {
        this.staticIP = staticIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StaticIP is a static IPv4 that will be assigned to the infra container and then used by the pod.")
    public String getStaticIP() {
        return this.staticIP;
    }

    public void setStaticIP(String staticIP) {
        this.staticIP = staticIP;
    }

    public InspectPodInfraConfig staticMAC(String staticMAC) {
        this.staticMAC = staticMAC;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StaticMAC is a static MAC address that will be assigned to the infra container and then used by the pod.")
    public String getStaticMAC() {
        return this.staticMAC;
    }

    public void setStaticMAC(String staticMAC) {
        this.staticMAC = staticMAC;
    }

    public InspectPodInfraConfig cpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CPUPeriod contains the CPU period of the pod")
    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    public void setCpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
    }

    public InspectPodInfraConfig cpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CPUQuota contains the CPU quota of the pod")
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public InspectPodInfraConfig cpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CPUSetCPUs contains linux specific CPU data for the container")
    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    public void setCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
    }

    public InspectPodInfraConfig pidNs(String pidNs) {
        this.pidNs = pidNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pid is the PID namespace mode of the pod's infra container")
    public String getPidNs() {
        return this.pidNs;
    }

    public void setPidNs(String pidNs) {
        this.pidNs = pidNs;
    }

    public InspectPodInfraConfig userns(String userns) {
        this.userns = userns;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UserNS is the usernamespace that all the containers in the pod will join.")
    public String getUserns() {
        return this.userns;
    }

    public void setUserns(String userns) {
        this.userns = userns;
    }

    public InspectPodInfraConfig utsNs(String utsNs) {
        this.utsNs = utsNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UtsNS is the uts namespace that all containers in the pod will join")
    public String getUtsNs() {
        return this.utsNs;
    }

    public void setUtsNs(String utsNs) {
        this.utsNs = utsNs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectPodInfraConfig inspectPodInfraConfig = (InspectPodInfraConfig)o;
        return Objects.equals(this.dnSOption, inspectPodInfraConfig.dnSOption) && Objects.equals(this.dnSSearch, inspectPodInfraConfig.dnSSearch) && Objects.equals(this.dnSServer, inspectPodInfraConfig.dnSServer) && Objects.equals(this.hostAdd, inspectPodInfraConfig.hostAdd) && Objects.equals(this.hostNetwork, inspectPodInfraConfig.hostNetwork) && Objects.equals(this.networkOptions, inspectPodInfraConfig.networkOptions) && Objects.equals(this.networks, inspectPodInfraConfig.networks) && Objects.equals(this.noManageHosts, inspectPodInfraConfig.noManageHosts) && Objects.equals(this.noManageResolvConf, inspectPodInfraConfig.noManageResolvConf) && Objects.equals(this.portBindings, inspectPodInfraConfig.portBindings) && Objects.equals(this.staticIP, inspectPodInfraConfig.staticIP) && Objects.equals(this.staticMAC, inspectPodInfraConfig.staticMAC) && Objects.equals(this.cpuPeriod, inspectPodInfraConfig.cpuPeriod) && Objects.equals(this.cpuQuota, inspectPodInfraConfig.cpuQuota) && Objects.equals(this.cpusetCpus, inspectPodInfraConfig.cpusetCpus) && Objects.equals(this.pidNs, inspectPodInfraConfig.pidNs) && Objects.equals(this.userns, inspectPodInfraConfig.userns) && Objects.equals(this.utsNs, inspectPodInfraConfig.utsNs);
    }

    public int hashCode() {
        return Objects.hash(this.dnSOption, this.dnSSearch, this.dnSServer, this.hostAdd, this.hostNetwork, this.networkOptions, this.networks, this.noManageHosts, this.noManageResolvConf, this.portBindings, this.staticIP, this.staticMAC, this.cpuPeriod, this.cpuQuota, this.cpusetCpus, this.pidNs, this.userns, this.utsNs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectPodInfraConfig {\n");
        sb.append("    dnSOption: ").append(this.toIndentedString(this.dnSOption)).append("\n");
        sb.append("    dnSSearch: ").append(this.toIndentedString(this.dnSSearch)).append("\n");
        sb.append("    dnSServer: ").append(this.toIndentedString(this.dnSServer)).append("\n");
        sb.append("    hostAdd: ").append(this.toIndentedString(this.hostAdd)).append("\n");
        sb.append("    hostNetwork: ").append(this.toIndentedString(this.hostNetwork)).append("\n");
        sb.append("    networkOptions: ").append(this.toIndentedString(this.networkOptions)).append("\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    noManageHosts: ").append(this.toIndentedString(this.noManageHosts)).append("\n");
        sb.append("    noManageResolvConf: ").append(this.toIndentedString(this.noManageResolvConf)).append("\n");
        sb.append("    portBindings: ").append(this.toIndentedString(this.portBindings)).append("\n");
        sb.append("    staticIP: ").append(this.toIndentedString(this.staticIP)).append("\n");
        sb.append("    staticMAC: ").append(this.toIndentedString(this.staticMAC)).append("\n");
        sb.append("    cpuPeriod: ").append(this.toIndentedString(this.cpuPeriod)).append("\n");
        sb.append("    cpuQuota: ").append(this.toIndentedString(this.cpuQuota)).append("\n");
        sb.append("    cpusetCpus: ").append(this.toIndentedString(this.cpusetCpus)).append("\n");
        sb.append("    pidNs: ").append(this.toIndentedString(this.pidNs)).append("\n");
        sb.append("    userns: ").append(this.toIndentedString(this.userns)).append("\n");
        sb.append("    utsNs: ").append(this.toIndentedString(this.utsNs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectPodInfraConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectPodInfraConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DN_S_OPTION) != null && !jsonObj.get(SERIALIZED_NAME_DN_S_OPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DN_S_OPTION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DNSOption` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DN_S_OPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DN_S_SEARCH) != null && !jsonObj.get(SERIALIZED_NAME_DN_S_SEARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DN_S_SEARCH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DNSSearch` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DN_S_SEARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DN_S_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_DN_S_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DN_S_SERVER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DNSServer` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DN_S_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_ADD) != null && !jsonObj.get(SERIALIZED_NAME_HOST_ADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOST_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `HostAdd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORKS) != null && !jsonObj.get(SERIALIZED_NAME_NETWORKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Networks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATIC_I_P) != null && !jsonObj.get(SERIALIZED_NAME_STATIC_I_P).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATIC_I_P).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `StaticIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATIC_I_P).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATIC_M_A_C) != null && !jsonObj.get(SERIALIZED_NAME_STATIC_M_A_C).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATIC_M_A_C).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `StaticMAC` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATIC_M_A_C).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS) != null && !jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cpuset_cpus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PID_NS) != null && !jsonObj.get(SERIALIZED_NAME_PID_NS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PID_NS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pid_ns` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PID_NS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNS) != null && !jsonObj.get(SERIALIZED_NAME_USERNS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `userns` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UTS_NS) != null && !jsonObj.get(SERIALIZED_NAME_UTS_NS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UTS_NS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uts_ns` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UTS_NS).toString()));
        }
    }

    public static InspectPodInfraConfig fromJson(String jsonString) throws IOException {
        return (InspectPodInfraConfig)JSON.getGson().fromJson(jsonString, InspectPodInfraConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DN_S_OPTION);
        openapiFields.add(SERIALIZED_NAME_DN_S_SEARCH);
        openapiFields.add(SERIALIZED_NAME_DN_S_SERVER);
        openapiFields.add(SERIALIZED_NAME_HOST_ADD);
        openapiFields.add(SERIALIZED_NAME_HOST_NETWORK);
        openapiFields.add(SERIALIZED_NAME_NETWORK_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_HOSTS);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF);
        openapiFields.add(SERIALIZED_NAME_PORT_BINDINGS);
        openapiFields.add(SERIALIZED_NAME_STATIC_I_P);
        openapiFields.add(SERIALIZED_NAME_STATIC_M_A_C);
        openapiFields.add(SERIALIZED_NAME_CPU_PERIOD);
        openapiFields.add(SERIALIZED_NAME_CPU_QUOTA);
        openapiFields.add(SERIALIZED_NAME_CPUSET_CPUS);
        openapiFields.add(SERIALIZED_NAME_PID_NS);
        openapiFields.add(SERIALIZED_NAME_USERNS);
        openapiFields.add(SERIALIZED_NAME_UTS_NS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectPodInfraConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectPodInfraConfig.class));
            return new TypeAdapter<InspectPodInfraConfig>(){

                public void write(JsonWriter out, InspectPodInfraConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectPodInfraConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectPodInfraConfig.validateJsonObject(jsonObj);
                    return (InspectPodInfraConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

