/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="LinuxDevice represents the mknod information for a Linux special device file")
public class LinuxDevice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_FILE_MODE = "fileMode";
    @SerializedName(value="fileMode")
    private Integer fileMode;
    public static final String SERIALIZED_NAME_GID = "gid";
    @SerializedName(value="gid")
    private Integer gid;
    public static final String SERIALIZED_NAME_MAJOR = "major";
    @SerializedName(value="major")
    private Long major;
    public static final String SERIALIZED_NAME_MINOR = "minor";
    @SerializedName(value="minor")
    private Long minor;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    private Integer uid;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LinuxDevice fileMode(Integer fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bits have the same definition on all systems, so that information about files can be moved from one system to another portably. Not all bits apply to all systems. The only required bit is [ModeDir] for directories.")
    public Integer getFileMode() {
        return this.fileMode;
    }

    public void setFileMode(Integer fileMode) {
        this.fileMode = fileMode;
    }

    public LinuxDevice gid(Integer gid) {
        this.gid = gid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gid of the device.")
    public Integer getGid() {
        return this.gid;
    }

    public void setGid(Integer gid) {
        this.gid = gid;
    }

    public LinuxDevice major(Long major) {
        this.major = major;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Major is the device's major number.")
    public Long getMajor() {
        return this.major;
    }

    public void setMajor(Long major) {
        this.major = major;
    }

    public LinuxDevice minor(Long minor) {
        this.minor = minor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minor is the device's minor number.")
    public Long getMinor() {
        return this.minor;
    }

    public void setMinor(Long minor) {
        this.minor = minor;
    }

    public LinuxDevice path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the device.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LinuxDevice type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Device type, block, char, etc.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LinuxDevice uid(Integer uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID of the device.")
    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxDevice linuxDevice = (LinuxDevice)o;
        return Objects.equals(this.fileMode, linuxDevice.fileMode) && Objects.equals(this.gid, linuxDevice.gid) && Objects.equals(this.major, linuxDevice.major) && Objects.equals(this.minor, linuxDevice.minor) && Objects.equals(this.path, linuxDevice.path) && Objects.equals(this.type, linuxDevice.type) && Objects.equals(this.uid, linuxDevice.uid);
    }

    public int hashCode() {
        return Objects.hash(this.fileMode, this.gid, this.major, this.minor, this.path, this.type, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinuxDevice {\n");
        sb.append("    fileMode: ").append(this.toIndentedString(this.fileMode)).append("\n");
        sb.append("    gid: ").append(this.toIndentedString(this.gid)).append("\n");
        sb.append("    major: ").append(this.toIndentedString(this.major)).append("\n");
        sb.append("    minor: ").append(this.toIndentedString(this.minor)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LinuxDevice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LinuxDevice` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static LinuxDevice fromJson(String jsonString) throws IOException {
        return (LinuxDevice)JSON.getGson().fromJson(jsonString, LinuxDevice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FILE_MODE);
        openapiFields.add(SERIALIZED_NAME_GID);
        openapiFields.add(SERIALIZED_NAME_MAJOR);
        openapiFields.add(SERIALIZED_NAME_MINOR);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LinuxDevice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LinuxDevice.class));
            return new TypeAdapter<LinuxDevice>(){

                public void write(JsonWriter out, LinuxDevice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LinuxDevice read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LinuxDevice.validateJsonObject(jsonObj);
                    return (LinuxDevice)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

