/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="LinuxMemory for Linux cgroup 'memory' resource management")
public class LinuxMemory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CHECK_BEFORE_UPDATE = "checkBeforeUpdate";
    @SerializedName(value="checkBeforeUpdate")
    private Boolean checkBeforeUpdate;
    public static final String SERIALIZED_NAME_DISABLE_O_O_M_KILLER = "disableOOMKiller";
    @SerializedName(value="disableOOMKiller")
    private Boolean disableOOMKiller;
    public static final String SERIALIZED_NAME_KERNEL = "kernel";
    @SerializedName(value="kernel")
    private Long kernel;
    public static final String SERIALIZED_NAME_KERNEL_T_C_P = "kernelTCP";
    @SerializedName(value="kernelTCP")
    private Long kernelTCP;
    public static final String SERIALIZED_NAME_LIMIT = "limit";
    @SerializedName(value="limit")
    private Long limit;
    public static final String SERIALIZED_NAME_RESERVATION = "reservation";
    @SerializedName(value="reservation")
    private Long reservation;
    public static final String SERIALIZED_NAME_SWAP = "swap";
    @SerializedName(value="swap")
    private Long swap;
    public static final String SERIALIZED_NAME_SWAPPINESS = "swappiness";
    @SerializedName(value="swappiness")
    private Integer swappiness;
    public static final String SERIALIZED_NAME_USE_HIERARCHY = "useHierarchy";
    @SerializedName(value="useHierarchy")
    private Boolean useHierarchy;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LinuxMemory checkBeforeUpdate(Boolean checkBeforeUpdate) {
        this.checkBeforeUpdate = checkBeforeUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CheckBeforeUpdate enables checking if a new memory limit is lower than the current usage during update, and if so, rejecting the new limit.")
    public Boolean getCheckBeforeUpdate() {
        return this.checkBeforeUpdate;
    }

    public void setCheckBeforeUpdate(Boolean checkBeforeUpdate) {
        this.checkBeforeUpdate = checkBeforeUpdate;
    }

    public LinuxMemory disableOOMKiller(Boolean disableOOMKiller) {
        this.disableOOMKiller = disableOOMKiller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DisableOOMKiller disables the OOM killer for out of memory conditions")
    public Boolean getDisableOOMKiller() {
        return this.disableOOMKiller;
    }

    public void setDisableOOMKiller(Boolean disableOOMKiller) {
        this.disableOOMKiller = disableOOMKiller;
    }

    public LinuxMemory kernel(Long kernel) {
        this.kernel = kernel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kernel memory limit (in bytes).  Deprecated: kernel-memory limits are not supported in cgroups v2, and were obsoleted in [kernel v5.4]. This field should no longer be used, as it may be ignored by runtimes.  [kernel v5.4]: https://github.com/torvalds/linux/commit/0158115f702b0ba208ab0")
    public Long getKernel() {
        return this.kernel;
    }

    public void setKernel(Long kernel) {
        this.kernel = kernel;
    }

    public LinuxMemory kernelTCP(Long kernelTCP) {
        this.kernelTCP = kernelTCP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kernel memory limit for tcp (in bytes)")
    public Long getKernelTCP() {
        return this.kernelTCP;
    }

    public void setKernelTCP(Long kernelTCP) {
        this.kernelTCP = kernelTCP;
    }

    public LinuxMemory limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Memory limit (in bytes).")
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public LinuxMemory reservation(Long reservation) {
        this.reservation = reservation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Memory reservation or soft_limit (in bytes).")
    public Long getReservation() {
        return this.reservation;
    }

    public void setReservation(Long reservation) {
        this.reservation = reservation;
    }

    public LinuxMemory swap(Long swap) {
        this.swap = swap;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total memory limit (memory + swap).")
    public Long getSwap() {
        return this.swap;
    }

    public void setSwap(Long swap) {
        this.swap = swap;
    }

    public LinuxMemory swappiness(Integer swappiness) {
        this.swappiness = swappiness;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How aggressive the kernel will swap memory pages.")
    public Integer getSwappiness() {
        return this.swappiness;
    }

    public void setSwappiness(Integer swappiness) {
        this.swappiness = swappiness;
    }

    public LinuxMemory useHierarchy(Boolean useHierarchy) {
        this.useHierarchy = useHierarchy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enables hierarchical memory accounting")
    public Boolean getUseHierarchy() {
        return this.useHierarchy;
    }

    public void setUseHierarchy(Boolean useHierarchy) {
        this.useHierarchy = useHierarchy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxMemory linuxMemory = (LinuxMemory)o;
        return Objects.equals(this.checkBeforeUpdate, linuxMemory.checkBeforeUpdate) && Objects.equals(this.disableOOMKiller, linuxMemory.disableOOMKiller) && Objects.equals(this.kernel, linuxMemory.kernel) && Objects.equals(this.kernelTCP, linuxMemory.kernelTCP) && Objects.equals(this.limit, linuxMemory.limit) && Objects.equals(this.reservation, linuxMemory.reservation) && Objects.equals(this.swap, linuxMemory.swap) && Objects.equals(this.swappiness, linuxMemory.swappiness) && Objects.equals(this.useHierarchy, linuxMemory.useHierarchy);
    }

    public int hashCode() {
        return Objects.hash(this.checkBeforeUpdate, this.disableOOMKiller, this.kernel, this.kernelTCP, this.limit, this.reservation, this.swap, this.swappiness, this.useHierarchy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinuxMemory {\n");
        sb.append("    checkBeforeUpdate: ").append(this.toIndentedString(this.checkBeforeUpdate)).append("\n");
        sb.append("    disableOOMKiller: ").append(this.toIndentedString(this.disableOOMKiller)).append("\n");
        sb.append("    kernel: ").append(this.toIndentedString(this.kernel)).append("\n");
        sb.append("    kernelTCP: ").append(this.toIndentedString(this.kernelTCP)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    reservation: ").append(this.toIndentedString(this.reservation)).append("\n");
        sb.append("    swap: ").append(this.toIndentedString(this.swap)).append("\n");
        sb.append("    swappiness: ").append(this.toIndentedString(this.swappiness)).append("\n");
        sb.append("    useHierarchy: ").append(this.toIndentedString(this.useHierarchy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LinuxMemory is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LinuxMemory` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static LinuxMemory fromJson(String jsonString) throws IOException {
        return (LinuxMemory)JSON.getGson().fromJson(jsonString, LinuxMemory.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHECK_BEFORE_UPDATE);
        openapiFields.add(SERIALIZED_NAME_DISABLE_O_O_M_KILLER);
        openapiFields.add(SERIALIZED_NAME_KERNEL);
        openapiFields.add(SERIALIZED_NAME_KERNEL_T_C_P);
        openapiFields.add(SERIALIZED_NAME_LIMIT);
        openapiFields.add(SERIALIZED_NAME_RESERVATION);
        openapiFields.add(SERIALIZED_NAME_SWAP);
        openapiFields.add(SERIALIZED_NAME_SWAPPINESS);
        openapiFields.add(SERIALIZED_NAME_USE_HIERARCHY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LinuxMemory.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LinuxMemory.class));
            return new TypeAdapter<LinuxMemory>(){

                public void write(JsonWriter out, LinuxMemory value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LinuxMemory read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LinuxMemory.validateJsonObject(jsonObj);
                    return (LinuxMemory)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

