/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.AttestationProperties;
import io.github.pod4dev.libpodj.model.Descriptor;
import io.github.pod4dev.libpodj.model.ImageProperties;
import io.github.pod4dev.libpodj.model.ManifestSummarySize;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class ManifestSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AVAILABLE = "Available";
    @SerializedName(value="Available")
    private Boolean available;
    public static final String SERIALIZED_NAME_DESCRIPTOR = "Descriptor";
    @SerializedName(value="Descriptor")
    private Descriptor descriptor;
    public static final String SERIALIZED_NAME_I_D = "ID";
    @SerializedName(value="ID")
    private String ID;
    public static final String SERIALIZED_NAME_KIND = "Kind";
    @SerializedName(value="Kind")
    private String kind;
    public static final String SERIALIZED_NAME_SIZE = "Size";
    @SerializedName(value="Size")
    private ManifestSummarySize size;
    public static final String SERIALIZED_NAME_ATTESTATION_DATA = "AttestationData";
    @SerializedName(value="AttestationData")
    private AttestationProperties attestationData;
    public static final String SERIALIZED_NAME_IMAGE_DATA = "ImageData";
    @SerializedName(value="ImageData")
    private ImageProperties imageData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ManifestSummary available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Indicates whether all the child content (image config, layers) is fully available locally")
    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public ManifestSummary descriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ManifestSummary ID(String ID) {
        this.ID = ID;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="ID is the content-addressable ID of an image and is the same as the digest of the image manifest.")
    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public ManifestSummary kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public ManifestSummary size(ManifestSummarySize size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public ManifestSummarySize getSize() {
        return this.size;
    }

    public void setSize(ManifestSummarySize size) {
        this.size = size;
    }

    public ManifestSummary attestationData(AttestationProperties attestationData) {
        this.attestationData = attestationData;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public AttestationProperties getAttestationData() {
        return this.attestationData;
    }

    public void setAttestationData(AttestationProperties attestationData) {
        this.attestationData = attestationData;
    }

    public ManifestSummary imageData(ImageProperties imageData) {
        this.imageData = imageData;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public ImageProperties getImageData() {
        return this.imageData;
    }

    public void setImageData(ImageProperties imageData) {
        this.imageData = imageData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestSummary manifestSummary = (ManifestSummary)o;
        return Objects.equals(this.available, manifestSummary.available) && Objects.equals(this.descriptor, manifestSummary.descriptor) && Objects.equals(this.ID, manifestSummary.ID) && Objects.equals(this.kind, manifestSummary.kind) && Objects.equals(this.size, manifestSummary.size) && Objects.equals(this.attestationData, manifestSummary.attestationData) && Objects.equals(this.imageData, manifestSummary.imageData);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.descriptor, this.ID, this.kind, this.size, this.attestationData, this.imageData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManifestSummary {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    descriptor: ").append(this.toIndentedString(this.descriptor)).append("\n");
        sb.append("    ID: ").append(this.toIndentedString(this.ID)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    attestationData: ").append(this.toIndentedString(this.attestationData)).append("\n");
        sb.append("    imageData: ").append(this.toIndentedString(this.imageData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ManifestSummary is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ManifestSummary` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTOR) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTOR).isJsonNull()) {
            Descriptor.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DESCRIPTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_I_D) != null && !jsonObj.get(SERIALIZED_NAME_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_SIZE).isJsonNull()) {
            ManifestSummarySize.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SIZE));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTESTATION_DATA) != null && !jsonObj.get(SERIALIZED_NAME_ATTESTATION_DATA).isJsonNull()) {
            AttestationProperties.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTESTATION_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_DATA) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_DATA).isJsonNull()) {
            ImageProperties.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE_DATA));
        }
    }

    public static ManifestSummary fromJson(String jsonString) throws IOException {
        return (ManifestSummary)JSON.getGson().fromJson(jsonString, ManifestSummary.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTOR);
        openapiFields.add(SERIALIZED_NAME_I_D);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_ATTESTATION_DATA);
        openapiFields.add(SERIALIZED_NAME_IMAGE_DATA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AVAILABLE);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTOR);
        openapiRequiredFields.add(SERIALIZED_NAME_I_D);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_SIZE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ManifestSummary.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ManifestSummary.class));
            return new TypeAdapter<ManifestSummary>(){

                public void write(JsonWriter out, ManifestSummary value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ManifestSummary read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ManifestSummary.validateJsonObject(jsonObj);
                    return (ManifestSummary)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

