/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PerNetworkOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALIASES = "aliases";
    @SerializedName(value="aliases")
    private List<String> aliases = null;
    public static final String SERIALIZED_NAME_INTERFACE_NAME = "interface_name";
    @SerializedName(value="interface_name")
    private String interfaceName;
    public static final String SERIALIZED_NAME_STATIC_IPS = "static_ips";
    @SerializedName(value="static_ips")
    private List<String> staticIps = null;
    public static final String SERIALIZED_NAME_STATIC_MAC = "static_mac";
    @SerializedName(value="static_mac")
    private String staticMac;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PerNetworkOptions aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public PerNetworkOptions addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Aliases contains a list of names which the dns server should resolve to this container. Should only be set when DNSEnabled is true on the Network. If aliases are set but there is no dns support for this network the network interface implementation should ignore this and NOT error. Optional.")
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public PerNetworkOptions interfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InterfaceName for this container. Required in the backend. Optional in the frontend. Will be filled with ethX (where X is a integer) when empty.")
    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public PerNetworkOptions staticIps(List<String> staticIps) {
        this.staticIps = staticIps;
        return this;
    }

    public PerNetworkOptions addStaticIpsItem(String staticIpsItem) {
        if (this.staticIps == null) {
            this.staticIps = new ArrayList<String>();
        }
        this.staticIps.add(staticIpsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StaticIPs for this container. Optional.")
    public List<String> getStaticIps() {
        return this.staticIps;
    }

    public void setStaticIps(List<String> staticIps) {
        this.staticIps = staticIps;
    }

    public PerNetworkOptions staticMac(String staticMac) {
        this.staticMac = staticMac;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StaticMac for this container. Optional.")
    public String getStaticMac() {
        return this.staticMac;
    }

    public void setStaticMac(String staticMac) {
        this.staticMac = staticMac;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerNetworkOptions perNetworkOptions = (PerNetworkOptions)o;
        return Objects.equals(this.aliases, perNetworkOptions.aliases) && Objects.equals(this.interfaceName, perNetworkOptions.interfaceName) && Objects.equals(this.staticIps, perNetworkOptions.staticIps) && Objects.equals(this.staticMac, perNetworkOptions.staticMac);
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.interfaceName, this.staticIps, this.staticMac);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerNetworkOptions {\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    interfaceName: ").append(this.toIndentedString(this.interfaceName)).append("\n");
        sb.append("    staticIps: ").append(this.toIndentedString(this.staticIps)).append("\n");
        sb.append("    staticMac: ").append(this.toIndentedString(this.staticMac)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PerNetworkOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PerNetworkOptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALIASES) != null && !jsonObj.get(SERIALIZED_NAME_ALIASES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALIASES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `aliases` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALIASES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `interface_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATIC_IPS) != null && !jsonObj.get(SERIALIZED_NAME_STATIC_IPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATIC_IPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `static_ips` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATIC_IPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATIC_MAC) != null && !jsonObj.get(SERIALIZED_NAME_STATIC_MAC).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATIC_MAC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `static_mac` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATIC_MAC).toString()));
        }
    }

    public static PerNetworkOptions fromJson(String jsonString) throws IOException {
        return (PerNetworkOptions)JSON.getGson().fromJson(jsonString, PerNetworkOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALIASES);
        openapiFields.add(SERIALIZED_NAME_INTERFACE_NAME);
        openapiFields.add(SERIALIZED_NAME_STATIC_IPS);
        openapiFields.add(SERIALIZED_NAME_STATIC_MAC);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PerNetworkOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PerNetworkOptions.class));
            return new TypeAdapter<PerNetworkOptions>(){

                public void write(JsonWriter out, PerNetworkOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PerNetworkOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PerNetworkOptions.validateJsonObject(jsonObj);
                    return (PerNetworkOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

