/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="This description is taken verbatim from the CSI Spec:  A topological domain is a sub-division of a cluster, like \"region\", \"zone\", \"rack\", etc. A topological segment is a specific instance of a topological domain, like \"zone3\", \"rack3\", etc. For example {\"com.company/zone\": \"Z1\", \"com.company/rack\": \"R3\"} Valid keys have two segments: an OPTIONAL prefix and name, separated by a slash (/), for example: \"com.company.example/zone\". The key name segment is REQUIRED. The prefix is OPTIONAL. The key name MUST be 63 characters or less, begin and end with an alphanumeric character ([a-z0-9A-Z]), and contain only dashes (-), underscores (_), dots (.), or alphanumerics in between, for example \"zone\". The key prefix MUST be 63 characters or less, begin and end with a lower-case alphanumeric character ([a-z0-9]), contain only dashes (-), dots (.), or lower-case alphanumerics in between, and follow domain name notation format (https://tools.ietf.org/html/rfc1035#section-2.3.1). The key prefix SHOULD include the plugin's host company name and/or the plugin name, to minimize the possibility of collisions with keys from other plugins. If a key prefix is specified, it MUST be identical across all topology keys returned by the SP (across all RPCs). Keys MUST be case-insensitive. Meaning the keys \"Zone\" and \"zone\" MUST not both exist. Each value (topological segment) MUST contain 1 or more strings. Each string MUST be 63 characters or less and begin and end with an alphanumeric character with '-', '_', '.', or alphanumerics in between.")
public class Topology
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_SEGMENTS = "Segments";
    @SerializedName(value="Segments")
    private Map<String, String> segments = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Topology segments(Map<String, String> segments) {
        this.segments = segments;
        return this;
    }

    public Topology putSegmentsItem(String key, String segmentsItem) {
        if (this.segments == null) {
            this.segments = new HashMap<String, String>();
        }
        this.segments.put(key, segmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getSegments() {
        return this.segments;
    }

    public void setSegments(Map<String, String> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Topology topology = (Topology)o;
        return Objects.equals(this.segments, topology.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Topology {\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Topology is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Topology` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static Topology fromJson(String jsonString) throws IOException {
        return (Topology)JSON.getGson().fromJson(jsonString, Topology.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SEGMENTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Topology.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Topology.class));
            return new TypeAdapter<Topology>(){

                public void write(JsonWriter out, Topology value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Topology read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Topology.validateJsonObject(jsonObj);
                    return (Topology)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

