/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.ConnectOptions;
import io.github.pod4dev.libpodj.model.CreateRequest;
import io.github.pod4dev.libpodj.model.DisconnectOptions;
import io.github.pod4dev.libpodj.model.Inspect;
import io.github.pod4dev.libpodj.model.NetworkCreate201Response;
import io.github.pod4dev.libpodj.model.NetworkPrune200Response;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class NetworksCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworksCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworksCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call networkConnectCall(String name, ConnectOptions create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ConnectOptions localVarPostBody = create;
        String localVarPath = "/networks/{name}/connect".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkConnectValidateBeforeCall(String name, ConnectOptions create, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkConnect(Async)");
        }
        return this.networkConnectCall(name, create, _callback);
    }

    private ApiResponse<Void> networkConnectWithHttpInfo(@NotNull String name, ConnectOptions create) throws ApiException {
        Call localVarCall = this.networkConnectValidateBeforeCall(name, create, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkConnectAsync(String name, ConnectOptions create, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkConnectValidateBeforeCall(name, create, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkConnectRequest networkConnect(String name) {
        return new APInetworkConnectRequest(name);
    }

    private Call networkCreateCall(CreateRequest create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateRequest localVarPostBody = create;
        String localVarPath = "/networks/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkCreateValidateBeforeCall(CreateRequest create, ApiCallback _callback) throws ApiException {
        return this.networkCreateCall(create, _callback);
    }

    private ApiResponse<NetworkCreate201Response> networkCreateWithHttpInfo(CreateRequest create) throws ApiException {
        Call localVarCall = this.networkCreateValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<NetworkCreate201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkCreateAsync(CreateRequest create, ApiCallback<NetworkCreate201Response> _callback) throws ApiException {
        Call localVarCall = this.networkCreateValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<NetworkCreate201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkCreateRequest networkCreate() {
        return new APInetworkCreateRequest();
    }

    private Call networkDeleteCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/networks/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkDeleteValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkDelete(Async)");
        }
        return this.networkDeleteCall(name, _callback);
    }

    private ApiResponse<Void> networkDeleteWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.networkDeleteValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkDeleteAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkDeleteValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkDeleteRequest networkDelete(String name) {
        return new APInetworkDeleteRequest(name);
    }

    private Call networkDisconnectCall(String name, DisconnectOptions create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DisconnectOptions localVarPostBody = create;
        String localVarPath = "/networks/{name}/disconnect".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkDisconnectValidateBeforeCall(String name, DisconnectOptions create, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkDisconnect(Async)");
        }
        return this.networkDisconnectCall(name, create, _callback);
    }

    private ApiResponse<Void> networkDisconnectWithHttpInfo(@NotNull String name, DisconnectOptions create) throws ApiException {
        Call localVarCall = this.networkDisconnectValidateBeforeCall(name, create, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkDisconnectAsync(String name, DisconnectOptions create, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkDisconnectValidateBeforeCall(name, create, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkDisconnectRequest networkDisconnect(String name) {
        return new APInetworkDisconnectRequest(name);
    }

    private Call networkInspectCall(String name, Boolean verbose, String scope, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/networks/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (verbose != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("verbose", verbose));
        }
        if (scope != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scope", scope));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkInspectValidateBeforeCall(String name, Boolean verbose, String scope, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkInspect(Async)");
        }
        return this.networkInspectCall(name, verbose, scope, _callback);
    }

    private ApiResponse<Inspect> networkInspectWithHttpInfo(@NotNull String name, Boolean verbose, String scope) throws ApiException {
        Call localVarCall = this.networkInspectValidateBeforeCall(name, verbose, scope, null);
        Type localVarReturnType = new TypeToken<Inspect>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkInspectAsync(String name, Boolean verbose, String scope, ApiCallback<Inspect> _callback) throws ApiException {
        Call localVarCall = this.networkInspectValidateBeforeCall(name, verbose, scope, _callback);
        Type localVarReturnType = new TypeToken<Inspect>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkInspectRequest networkInspect(String name) {
        return new APInetworkInspectRequest(name);
    }

    private Call networkListCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/networks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkListValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.networkListCall(filters, _callback);
    }

    private ApiResponse<List<Inspect>> networkListWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.networkListValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<Inspect>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkListAsync(String filters, ApiCallback<List<Inspect>> _callback) throws ApiException {
        Call localVarCall = this.networkListValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<Inspect>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkListRequest networkList() {
        return new APInetworkListRequest();
    }

    private Call networkPruneCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/networks/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPruneValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.networkPruneCall(filters, _callback);
    }

    private ApiResponse<NetworkPrune200Response> networkPruneWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.networkPruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<NetworkPrune200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkPruneAsync(String filters, ApiCallback<NetworkPrune200Response> _callback) throws ApiException {
        Call localVarCall = this.networkPruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<NetworkPrune200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkPruneRequest networkPrune() {
        return new APInetworkPruneRequest();
    }

    public class APInetworkConnectRequest {
        private final String name;
        private ConnectOptions create;

        private APInetworkConnectRequest(String name) {
            this.name = name;
        }

        public APInetworkConnectRequest create(ConnectOptions create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkConnectCall(this.name, this.create, _callback);
        }

        public void execute() throws ApiException {
            NetworksCompatApi.this.networkConnectWithHttpInfo(this.name, this.create);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkConnectWithHttpInfo(this.name, this.create);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksCompatApi.this.networkConnectAsync(this.name, this.create, _callback);
        }
    }

    public class APInetworkCreateRequest {
        private CreateRequest create;

        private APInetworkCreateRequest() {
        }

        public APInetworkCreateRequest create(CreateRequest create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkCreateCall(this.create, _callback);
        }

        public NetworkCreate201Response execute() throws ApiException {
            ApiResponse<NetworkCreate201Response> localVarResp = NetworksCompatApi.this.networkCreateWithHttpInfo(this.create);
            return localVarResp.getData();
        }

        public ApiResponse<NetworkCreate201Response> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkCreateWithHttpInfo(this.create);
        }

        public Call executeAsync(ApiCallback<NetworkCreate201Response> _callback) throws ApiException {
            return NetworksCompatApi.this.networkCreateAsync(this.create, _callback);
        }
    }

    public class APInetworkDeleteRequest {
        private final String name;

        private APInetworkDeleteRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkDeleteCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            NetworksCompatApi.this.networkDeleteWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkDeleteWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksCompatApi.this.networkDeleteAsync(this.name, _callback);
        }
    }

    public class APInetworkDisconnectRequest {
        private final String name;
        private DisconnectOptions create;

        private APInetworkDisconnectRequest(String name) {
            this.name = name;
        }

        public APInetworkDisconnectRequest create(DisconnectOptions create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkDisconnectCall(this.name, this.create, _callback);
        }

        public void execute() throws ApiException {
            NetworksCompatApi.this.networkDisconnectWithHttpInfo(this.name, this.create);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkDisconnectWithHttpInfo(this.name, this.create);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksCompatApi.this.networkDisconnectAsync(this.name, this.create, _callback);
        }
    }

    public class APInetworkInspectRequest {
        private final String name;
        private Boolean verbose;
        private String scope;

        private APInetworkInspectRequest(String name) {
            this.name = name;
        }

        public APInetworkInspectRequest verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public APInetworkInspectRequest scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkInspectCall(this.name, this.verbose, this.scope, _callback);
        }

        public Inspect execute() throws ApiException {
            ApiResponse<Inspect> localVarResp = NetworksCompatApi.this.networkInspectWithHttpInfo(this.name, this.verbose, this.scope);
            return localVarResp.getData();
        }

        public ApiResponse<Inspect> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkInspectWithHttpInfo(this.name, this.verbose, this.scope);
        }

        public Call executeAsync(ApiCallback<Inspect> _callback) throws ApiException {
            return NetworksCompatApi.this.networkInspectAsync(this.name, this.verbose, this.scope, _callback);
        }
    }

    public class APInetworkListRequest {
        private String filters;

        private APInetworkListRequest() {
        }

        public APInetworkListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkListCall(this.filters, _callback);
        }

        public List<Inspect> execute() throws ApiException {
            ApiResponse<List<Inspect>> localVarResp = NetworksCompatApi.this.networkListWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<Inspect>> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkListWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<Inspect>> _callback) throws ApiException {
            return NetworksCompatApi.this.networkListAsync(this.filters, _callback);
        }
    }

    public class APInetworkPruneRequest {
        private String filters;

        private APInetworkPruneRequest() {
        }

        public APInetworkPruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksCompatApi.this.networkPruneCall(this.filters, _callback);
        }

        public NetworkPrune200Response execute() throws ApiException {
            ApiResponse<NetworkPrune200Response> localVarResp = NetworksCompatApi.this.networkPruneWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<NetworkPrune200Response> executeWithHttpInfo() throws ApiException {
            return NetworksCompatApi.this.networkPruneWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<NetworkPrune200Response> _callback) throws ApiException {
            return NetworksCompatApi.this.networkPruneAsync(this.filters, _callback);
        }
    }
}

