/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.ListResponse;
import io.github.pod4dev.libpodj.model.PruneReport;
import io.github.pod4dev.libpodj.model.Volume;
import io.github.pod4dev.libpodj.model.VolumeCreate;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class VolumesCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public VolumesCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VolumesCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call volumeCreateCall(VolumeCreate create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        VolumeCreate localVarPostBody = create;
        String localVarPath = "/volumes/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeCreateValidateBeforeCall(VolumeCreate create, ApiCallback _callback) throws ApiException {
        return this.volumeCreateCall(create, _callback);
    }

    private ApiResponse<Volume> volumeCreateWithHttpInfo(VolumeCreate create) throws ApiException {
        Call localVarCall = this.volumeCreateValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumeCreateAsync(VolumeCreate create, ApiCallback<Volume> _callback) throws ApiException {
        Call localVarCall = this.volumeCreateValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumeCreateRequest volumeCreate() {
        return new APIvolumeCreateRequest();
    }

    private Call volumeDeleteCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/volumes/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeDeleteValidateBeforeCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeDelete(Async)");
        }
        return this.volumeDeleteCall(name, force, _callback);
    }

    private ApiResponse<Void> volumeDeleteWithHttpInfo(@NotNull String name, Boolean force) throws ApiException {
        Call localVarCall = this.volumeDeleteValidateBeforeCall(name, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call volumeDeleteAsync(String name, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.volumeDeleteValidateBeforeCall(name, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIvolumeDeleteRequest volumeDelete(String name) {
        return new APIvolumeDeleteRequest(name);
    }

    private Call volumeInspectCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/volumes/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeInspectValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeInspect(Async)");
        }
        return this.volumeInspectCall(name, _callback);
    }

    private ApiResponse<Volume> volumeInspectWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.volumeInspectValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumeInspectAsync(String name, ApiCallback<Volume> _callback) throws ApiException {
        Call localVarCall = this.volumeInspectValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumeInspectRequest volumeInspect(String name) {
        return new APIvolumeInspectRequest(name);
    }

    private Call volumeListCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/volumes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumeListValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.volumeListCall(filters, _callback);
    }

    private ApiResponse<ListResponse> volumeListWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.volumeListValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<ListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumeListAsync(String filters, ApiCallback<ListResponse> _callback) throws ApiException {
        Call localVarCall = this.volumeListValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<ListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumeListRequest volumeList() {
        return new APIvolumeListRequest();
    }

    private Call volumePruneCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/volumes/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call volumePruneValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.volumePruneCall(filters, _callback);
    }

    private ApiResponse<PruneReport> volumePruneWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.volumePruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<PruneReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call volumePruneAsync(String filters, ApiCallback<PruneReport> _callback) throws ApiException {
        Call localVarCall = this.volumePruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<PruneReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIvolumePruneRequest volumePrune() {
        return new APIvolumePruneRequest();
    }

    public class APIvolumeCreateRequest {
        private VolumeCreate create;

        private APIvolumeCreateRequest() {
        }

        public APIvolumeCreateRequest create(VolumeCreate create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesCompatApi.this.volumeCreateCall(this.create, _callback);
        }

        public Volume execute() throws ApiException {
            ApiResponse<Volume> localVarResp = VolumesCompatApi.this.volumeCreateWithHttpInfo(this.create);
            return localVarResp.getData();
        }

        public ApiResponse<Volume> executeWithHttpInfo() throws ApiException {
            return VolumesCompatApi.this.volumeCreateWithHttpInfo(this.create);
        }

        public Call executeAsync(ApiCallback<Volume> _callback) throws ApiException {
            return VolumesCompatApi.this.volumeCreateAsync(this.create, _callback);
        }
    }

    public class APIvolumeDeleteRequest {
        private final String name;
        private Boolean force;

        private APIvolumeDeleteRequest(String name) {
            this.name = name;
        }

        public APIvolumeDeleteRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesCompatApi.this.volumeDeleteCall(this.name, this.force, _callback);
        }

        public void execute() throws ApiException {
            VolumesCompatApi.this.volumeDeleteWithHttpInfo(this.name, this.force);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return VolumesCompatApi.this.volumeDeleteWithHttpInfo(this.name, this.force);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return VolumesCompatApi.this.volumeDeleteAsync(this.name, this.force, _callback);
        }
    }

    public class APIvolumeInspectRequest {
        private final String name;

        private APIvolumeInspectRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesCompatApi.this.volumeInspectCall(this.name, _callback);
        }

        public Volume execute() throws ApiException {
            ApiResponse<Volume> localVarResp = VolumesCompatApi.this.volumeInspectWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<Volume> executeWithHttpInfo() throws ApiException {
            return VolumesCompatApi.this.volumeInspectWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Volume> _callback) throws ApiException {
            return VolumesCompatApi.this.volumeInspectAsync(this.name, _callback);
        }
    }

    public class APIvolumeListRequest {
        private String filters;

        private APIvolumeListRequest() {
        }

        public APIvolumeListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesCompatApi.this.volumeListCall(this.filters, _callback);
        }

        public ListResponse execute() throws ApiException {
            ApiResponse<ListResponse> localVarResp = VolumesCompatApi.this.volumeListWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<ListResponse> executeWithHttpInfo() throws ApiException {
            return VolumesCompatApi.this.volumeListWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<ListResponse> _callback) throws ApiException {
            return VolumesCompatApi.this.volumeListAsync(this.filters, _callback);
        }
    }

    public class APIvolumePruneRequest {
        private String filters;

        private APIvolumePruneRequest() {
        }

        public APIvolumePruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return VolumesCompatApi.this.volumePruneCall(this.filters, _callback);
        }

        public PruneReport execute() throws ApiException {
            ApiResponse<PruneReport> localVarResp = VolumesCompatApi.this.volumePruneWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<PruneReport> executeWithHttpInfo() throws ApiException {
            return VolumesCompatApi.this.volumePruneWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<PruneReport> _callback) throws ApiException {
            return VolumesCompatApi.this.volumePruneAsync(this.filters, _callback);
        }
    }
}

