/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.HostInfo;
import io.github.pod4dev.libpodj.model.Plugins;
import io.github.pod4dev.libpodj.model.StoreInfo;
import io.github.pod4dev.libpodj.model.Version;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LibpodInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private HostInfo host;
    public static final String SERIALIZED_NAME_PLUGINS = "plugins";
    @SerializedName(value="plugins")
    private Plugins plugins;
    public static final String SERIALIZED_NAME_REGISTRIES = "registries";
    @SerializedName(value="registries")
    private Map<String, Object> registries = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private StoreInfo store;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Version version;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LibpodInfo host(HostInfo host) {
        this.host = host;
        return this;
    }

    @Nullable
    @Valid
    public HostInfo getHost() {
        return this.host;
    }

    public void setHost(HostInfo host) {
        this.host = host;
    }

    public LibpodInfo plugins(Plugins plugins) {
        this.plugins = plugins;
        return this;
    }

    @Nullable
    @Valid
    public Plugins getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Plugins plugins) {
        this.plugins = plugins;
    }

    public LibpodInfo registries(Map<String, Object> registries) {
        this.registries = registries;
        return this;
    }

    public LibpodInfo putRegistriesItem(String key, Object registriesItem) {
        if (this.registries == null) {
            this.registries = new HashMap<String, Object>();
        }
        this.registries.put(key, registriesItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getRegistries() {
        return this.registries;
    }

    public void setRegistries(Map<String, Object> registries) {
        this.registries = registries;
    }

    public LibpodInfo store(StoreInfo store) {
        this.store = store;
        return this;
    }

    @Nullable
    @Valid
    public StoreInfo getStore() {
        return this.store;
    }

    public void setStore(StoreInfo store) {
        this.store = store;
    }

    public LibpodInfo version(Version version) {
        this.version = version;
        return this;
    }

    @Nullable
    @Valid
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibpodInfo libpodInfo = (LibpodInfo)o;
        return Objects.equals(this.host, libpodInfo.host) && Objects.equals(this.plugins, libpodInfo.plugins) && Objects.equals(this.registries, libpodInfo.registries) && Objects.equals(this.store, libpodInfo.store) && Objects.equals(this.version, libpodInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.plugins, this.registries, this.store, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LibpodInfo {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    plugins: ").append(this.toIndentedString(this.plugins)).append("\n");
        sb.append("    registries: ").append(this.toIndentedString(this.registries)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in LibpodInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LibpodInfo` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_HOST) != null && !jsonObj.get(SERIALIZED_NAME_HOST).isJsonNull()) {
            HostInfo.validateJsonElement(jsonObj.get(SERIALIZED_NAME_HOST));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLUGINS) != null && !jsonObj.get(SERIALIZED_NAME_PLUGINS).isJsonNull()) {
            Plugins.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PLUGINS));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonNull()) {
            StoreInfo.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STORE));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull()) {
            Version.validateJsonElement(jsonObj.get(SERIALIZED_NAME_VERSION));
        }
    }

    public static LibpodInfo fromJson(String jsonString) throws IOException {
        return (LibpodInfo)JSON.getGson().fromJson(jsonString, LibpodInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HOST);
        openapiFields.add(SERIALIZED_NAME_PLUGINS);
        openapiFields.add(SERIALIZED_NAME_REGISTRIES);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LibpodInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LibpodInfo.class));
            return new TypeAdapter<LibpodInfo>(){

                public void write(JsonWriter out, LibpodInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LibpodInfo read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    LibpodInfo.validateJsonElement(jsonElement);
                    return (LibpodInfo)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

