/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Address;
import io.github.pod4dev.libpodj.model.EndpointSettings;
import io.github.pod4dev.libpodj.model.PortBinding;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NetworkSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_BRIDGE = "Bridge";
    @SerializedName(value="Bridge")
    private String bridge;
    public static final String SERIALIZED_NAME_ENDPOINT_I_D = "EndpointID";
    @SerializedName(value="EndpointID")
    private String endpointID;
    public static final String SERIALIZED_NAME_GATEWAY = "Gateway";
    @SerializedName(value="Gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS = "GlobalIPv6Address";
    @SerializedName(value="GlobalIPv6Address")
    private String globalIPv6Address;
    public static final String SERIALIZED_NAME_GLOBAL_I_PV6_PREFIX_LEN = "GlobalIPv6PrefixLen";
    @SerializedName(value="GlobalIPv6PrefixLen")
    private Long globalIPv6PrefixLen;
    public static final String SERIALIZED_NAME_HAIRPIN_MODE = "HairpinMode";
    @SerializedName(value="HairpinMode")
    private Boolean hairpinMode;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "IPAddress";
    @SerializedName(value="IPAddress")
    private String ipAddress;
    public static final String SERIALIZED_NAME_IP_PREFIX_LEN = "IPPrefixLen";
    @SerializedName(value="IPPrefixLen")
    private Long ipPrefixLen;
    public static final String SERIALIZED_NAME_IPV6_GATEWAY = "IPv6Gateway";
    @SerializedName(value="IPv6Gateway")
    private String ipv6Gateway;
    public static final String SERIALIZED_NAME_LINK_LOCAL_I_PV6_ADDRESS = "LinkLocalIPv6Address";
    @SerializedName(value="LinkLocalIPv6Address")
    private String linkLocalIPv6Address;
    public static final String SERIALIZED_NAME_LINK_LOCAL_I_PV6_PREFIX_LEN = "LinkLocalIPv6PrefixLen";
    @SerializedName(value="LinkLocalIPv6PrefixLen")
    private Long linkLocalIPv6PrefixLen;
    public static final String SERIALIZED_NAME_MAC_ADDRESS = "MacAddress";
    @SerializedName(value="MacAddress")
    private String macAddress;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private Map<String, EndpointSettings> networks = new HashMap<String, EndpointSettings>();
    public static final String SERIALIZED_NAME_PORTS = "Ports";
    @SerializedName(value="Ports")
    private Map<String, List<@Valid PortBinding>> ports = new HashMap<String, List<PortBinding>>();
    public static final String SERIALIZED_NAME_SANDBOX_I_D = "SandboxID";
    @SerializedName(value="SandboxID")
    private String sandboxID;
    public static final String SERIALIZED_NAME_SANDBOX_KEY = "SandboxKey";
    @SerializedName(value="SandboxKey")
    private String sandboxKey;
    public static final String SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES = "SecondaryIPAddresses";
    @SerializedName(value="SecondaryIPAddresses")
    private List<@Valid Address> secondaryIPAddresses = new ArrayList<Address>();
    public static final String SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES = "SecondaryIPv6Addresses";
    @SerializedName(value="SecondaryIPv6Addresses")
    private List<@Valid Address> secondaryIPv6Addresses = new ArrayList<Address>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NetworkSettings bridge(String bridge) {
        this.bridge = bridge;
        return this;
    }

    @Nullable
    public String getBridge() {
        return this.bridge;
    }

    public void setBridge(String bridge) {
        this.bridge = bridge;
    }

    public NetworkSettings endpointID(String endpointID) {
        this.endpointID = endpointID;
        return this;
    }

    @Nullable
    public String getEndpointID() {
        return this.endpointID;
    }

    public void setEndpointID(String endpointID) {
        this.endpointID = endpointID;
    }

    public NetworkSettings gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public NetworkSettings globalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
        return this;
    }

    @Nullable
    public String getGlobalIPv6Address() {
        return this.globalIPv6Address;
    }

    public void setGlobalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
    }

    public NetworkSettings globalIPv6PrefixLen(Long globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        return this;
    }

    @Nullable
    public Long getGlobalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    public void setGlobalIPv6PrefixLen(Long globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
    }

    public NetworkSettings hairpinMode(Boolean hairpinMode) {
        this.hairpinMode = hairpinMode;
        return this;
    }

    @Nullable
    public Boolean getHairpinMode() {
        return this.hairpinMode;
    }

    public void setHairpinMode(Boolean hairpinMode) {
        this.hairpinMode = hairpinMode;
    }

    public NetworkSettings ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public NetworkSettings ipPrefixLen(Long ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
        return this;
    }

    @Nullable
    public Long getIpPrefixLen() {
        return this.ipPrefixLen;
    }

    public void setIpPrefixLen(Long ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
    }

    public NetworkSettings ipv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
        return this;
    }

    @Nullable
    public String getIpv6Gateway() {
        return this.ipv6Gateway;
    }

    public void setIpv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
    }

    public NetworkSettings linkLocalIPv6Address(String linkLocalIPv6Address) {
        this.linkLocalIPv6Address = linkLocalIPv6Address;
        return this;
    }

    @Nullable
    public String getLinkLocalIPv6Address() {
        return this.linkLocalIPv6Address;
    }

    public void setLinkLocalIPv6Address(String linkLocalIPv6Address) {
        this.linkLocalIPv6Address = linkLocalIPv6Address;
    }

    public NetworkSettings linkLocalIPv6PrefixLen(Long linkLocalIPv6PrefixLen) {
        this.linkLocalIPv6PrefixLen = linkLocalIPv6PrefixLen;
        return this;
    }

    @Nullable
    public Long getLinkLocalIPv6PrefixLen() {
        return this.linkLocalIPv6PrefixLen;
    }

    public void setLinkLocalIPv6PrefixLen(Long linkLocalIPv6PrefixLen) {
        this.linkLocalIPv6PrefixLen = linkLocalIPv6PrefixLen;
    }

    public NetworkSettings macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Nullable
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public NetworkSettings networks(Map<String, EndpointSettings> networks) {
        this.networks = networks;
        return this;
    }

    public NetworkSettings putNetworksItem(String key, EndpointSettings networksItem) {
        if (this.networks == null) {
            this.networks = new HashMap<String, EndpointSettings>();
        }
        this.networks.put(key, networksItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, EndpointSettings> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map<String, EndpointSettings> networks) {
        this.networks = networks;
    }

    public NetworkSettings ports(Map<String, List<@Valid PortBinding>> ports) {
        this.ports = ports;
        return this;
    }

    public NetworkSettings putPortsItem(String key, List<@Valid PortBinding> portsItem) {
        if (this.ports == null) {
            this.ports = new HashMap<String, List<PortBinding>>();
        }
        this.ports.put(key, portsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid Map<String, List<@Valid PortBinding>> getPorts() {
        return this.ports;
    }

    public void setPorts(Map<String, List<@Valid PortBinding>> ports) {
        this.ports = ports;
    }

    public NetworkSettings sandboxID(String sandboxID) {
        this.sandboxID = sandboxID;
        return this;
    }

    @Nullable
    public String getSandboxID() {
        return this.sandboxID;
    }

    public void setSandboxID(String sandboxID) {
        this.sandboxID = sandboxID;
    }

    public NetworkSettings sandboxKey(String sandboxKey) {
        this.sandboxKey = sandboxKey;
        return this;
    }

    @Nullable
    public String getSandboxKey() {
        return this.sandboxKey;
    }

    public void setSandboxKey(String sandboxKey) {
        this.sandboxKey = sandboxKey;
    }

    public NetworkSettings secondaryIPAddresses(List<@Valid Address> secondaryIPAddresses) {
        this.secondaryIPAddresses = secondaryIPAddresses;
        return this;
    }

    public NetworkSettings addSecondaryIPAddressesItem(Address secondaryIPAddressesItem) {
        if (this.secondaryIPAddresses == null) {
            this.secondaryIPAddresses = new ArrayList<Address>();
        }
        this.secondaryIPAddresses.add(secondaryIPAddressesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Address> getSecondaryIPAddresses() {
        return this.secondaryIPAddresses;
    }

    public void setSecondaryIPAddresses(List<@Valid Address> secondaryIPAddresses) {
        this.secondaryIPAddresses = secondaryIPAddresses;
    }

    public NetworkSettings secondaryIPv6Addresses(List<@Valid Address> secondaryIPv6Addresses) {
        this.secondaryIPv6Addresses = secondaryIPv6Addresses;
        return this;
    }

    public NetworkSettings addSecondaryIPv6AddressesItem(Address secondaryIPv6AddressesItem) {
        if (this.secondaryIPv6Addresses == null) {
            this.secondaryIPv6Addresses = new ArrayList<Address>();
        }
        this.secondaryIPv6Addresses.add(secondaryIPv6AddressesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Address> getSecondaryIPv6Addresses() {
        return this.secondaryIPv6Addresses;
    }

    public void setSecondaryIPv6Addresses(List<@Valid Address> secondaryIPv6Addresses) {
        this.secondaryIPv6Addresses = secondaryIPv6Addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSettings networkSettings = (NetworkSettings)o;
        return Objects.equals(this.bridge, networkSettings.bridge) && Objects.equals(this.endpointID, networkSettings.endpointID) && Objects.equals(this.gateway, networkSettings.gateway) && Objects.equals(this.globalIPv6Address, networkSettings.globalIPv6Address) && Objects.equals(this.globalIPv6PrefixLen, networkSettings.globalIPv6PrefixLen) && Objects.equals(this.hairpinMode, networkSettings.hairpinMode) && Objects.equals(this.ipAddress, networkSettings.ipAddress) && Objects.equals(this.ipPrefixLen, networkSettings.ipPrefixLen) && Objects.equals(this.ipv6Gateway, networkSettings.ipv6Gateway) && Objects.equals(this.linkLocalIPv6Address, networkSettings.linkLocalIPv6Address) && Objects.equals(this.linkLocalIPv6PrefixLen, networkSettings.linkLocalIPv6PrefixLen) && Objects.equals(this.macAddress, networkSettings.macAddress) && Objects.equals(this.networks, networkSettings.networks) && Objects.equals(this.ports, networkSettings.ports) && Objects.equals(this.sandboxID, networkSettings.sandboxID) && Objects.equals(this.sandboxKey, networkSettings.sandboxKey) && Objects.equals(this.secondaryIPAddresses, networkSettings.secondaryIPAddresses) && Objects.equals(this.secondaryIPv6Addresses, networkSettings.secondaryIPv6Addresses);
    }

    public int hashCode() {
        return Objects.hash(this.bridge, this.endpointID, this.gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.hairpinMode, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.linkLocalIPv6Address, this.linkLocalIPv6PrefixLen, this.macAddress, this.networks, this.ports, this.sandboxID, this.sandboxKey, this.secondaryIPAddresses, this.secondaryIPv6Addresses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkSettings {\n");
        sb.append("    bridge: ").append(this.toIndentedString(this.bridge)).append("\n");
        sb.append("    endpointID: ").append(this.toIndentedString(this.endpointID)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    globalIPv6Address: ").append(this.toIndentedString(this.globalIPv6Address)).append("\n");
        sb.append("    globalIPv6PrefixLen: ").append(this.toIndentedString(this.globalIPv6PrefixLen)).append("\n");
        sb.append("    hairpinMode: ").append(this.toIndentedString(this.hairpinMode)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipPrefixLen: ").append(this.toIndentedString(this.ipPrefixLen)).append("\n");
        sb.append("    ipv6Gateway: ").append(this.toIndentedString(this.ipv6Gateway)).append("\n");
        sb.append("    linkLocalIPv6Address: ").append(this.toIndentedString(this.linkLocalIPv6Address)).append("\n");
        sb.append("    linkLocalIPv6PrefixLen: ").append(this.toIndentedString(this.linkLocalIPv6PrefixLen)).append("\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    sandboxID: ").append(this.toIndentedString(this.sandboxID)).append("\n");
        sb.append("    sandboxKey: ").append(this.toIndentedString(this.sandboxKey)).append("\n");
        sb.append("    secondaryIPAddresses: ").append(this.toIndentedString(this.secondaryIPAddresses)).append("\n");
        sb.append("    secondaryIPv6Addresses: ").append(this.toIndentedString(this.secondaryIPv6Addresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysecondaryIPv6Addresses;
        int i;
        JsonArray jsonArraysecondaryIPAddresses;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in NetworkSettings is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NetworkSettings` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_BRIDGE) != null && !jsonObj.get(SERIALIZED_NAME_BRIDGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BRIDGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Bridge` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRIDGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `EndpointID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `GlobalIPv6Address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPv6Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINK_LOCAL_I_PV6_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_LINK_LOCAL_I_PV6_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LINK_LOCAL_I_PV6_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `LinkLocalIPv6Address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINK_LOCAL_I_PV6_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `MacAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SANDBOX_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SANDBOX_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SANDBOX_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `SandboxID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SANDBOX_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SANDBOX_KEY) != null && !jsonObj.get(SERIALIZED_NAME_SANDBOX_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SANDBOX_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `SandboxKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SANDBOX_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES).isJsonNull() && (jsonArraysecondaryIPAddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `SecondaryIPAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES).toString()));
            }
            for (i = 0; i < jsonArraysecondaryIPAddresses.size(); ++i) {
                Address.validateJsonElement(jsonArraysecondaryIPAddresses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES).isJsonNull() && (jsonArraysecondaryIPv6Addresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `SecondaryIPv6Addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES).toString()));
            }
            for (i = 0; i < jsonArraysecondaryIPv6Addresses.size(); ++i) {
                Address.validateJsonElement(jsonArraysecondaryIPv6Addresses.get(i));
            }
        }
    }

    public static NetworkSettings fromJson(String jsonString) throws IOException {
        return (NetworkSettings)JSON.getGson().fromJson(jsonString, NetworkSettings.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BRIDGE);
        openapiFields.add(SERIALIZED_NAME_ENDPOINT_I_D);
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_GLOBAL_I_PV6_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_HAIRPIN_MODE);
        openapiFields.add(SERIALIZED_NAME_IP_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_IP_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_IPV6_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_LINK_LOCAL_I_PV6_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_LINK_LOCAL_I_PV6_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_MAC_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiFields.add(SERIALIZED_NAME_SANDBOX_I_D);
        openapiFields.add(SERIALIZED_NAME_SANDBOX_KEY);
        openapiFields.add(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NetworkSettings.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NetworkSettings.class));
            return new TypeAdapter<NetworkSettings>(){

                public void write(JsonWriter out, NetworkSettings value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NetworkSettings read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    NetworkSettings.validateJsonElement(jsonElement);
                    return (NetworkSettings)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

