/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PodStorageConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
    @SerializedName(value="image_volumes")
    private List<@Valid ImageVolume> imageVolumes = new ArrayList<ImageVolume>();
    public static final String SERIALIZED_NAME_MOUNTS = "mounts";
    @SerializedName(value="mounts")
    private List<@Valid Mount> mounts = new ArrayList<Mount>();
    public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
    @SerializedName(value="overlay_volumes")
    private List<@Valid OverlayVolume> overlayVolumes = new ArrayList<OverlayVolume>();
    public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
    @SerializedName(value="shm_size")
    private Long shmSize;
    public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
    @SerializedName(value="shm_size_systemd")
    private Long shmSizeSystemd;
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    private List<@Valid NamedVolume> volumes = new ArrayList<NamedVolume>();
    public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
    @SerializedName(value="volumes_from")
    private List<String> volumesFrom = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PodStorageConfig imageVolumes(List<@Valid ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
        return this;
    }

    public PodStorageConfig addImageVolumesItem(ImageVolume imageVolumesItem) {
        if (this.imageVolumes == null) {
            this.imageVolumes = new ArrayList<ImageVolume>();
        }
        this.imageVolumes.add(imageVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ImageVolume> getImageVolumes() {
        return this.imageVolumes;
    }

    public void setImageVolumes(List<@Valid ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
    }

    public PodStorageConfig mounts(List<@Valid Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public PodStorageConfig addMountsItem(Mount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<Mount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Mount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<@Valid Mount> mounts) {
        this.mounts = mounts;
    }

    public PodStorageConfig overlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
        return this;
    }

    public PodStorageConfig addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
        if (this.overlayVolumes == null) {
            this.overlayVolumes = new ArrayList<OverlayVolume>();
        }
        this.overlayVolumes.add(overlayVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid OverlayVolume> getOverlayVolumes() {
        return this.overlayVolumes;
    }

    public void setOverlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
    }

    public PodStorageConfig shmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    @Nullable
    public Long getShmSize() {
        return this.shmSize;
    }

    public void setShmSize(Long shmSize) {
        this.shmSize = shmSize;
    }

    public PodStorageConfig shmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
        return this;
    }

    @Nullable
    public Long getShmSizeSystemd() {
        return this.shmSizeSystemd;
    }

    public void setShmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
    }

    public PodStorageConfig volumes(List<@Valid NamedVolume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public PodStorageConfig addVolumesItem(NamedVolume volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<NamedVolume>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid NamedVolume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<@Valid NamedVolume> volumes) {
        this.volumes = volumes;
    }

    public PodStorageConfig volumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public PodStorageConfig addVolumesFromItem(String volumesFromItem) {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ArrayList<String>();
        }
        this.volumesFrom.add(volumesFromItem);
        return this;
    }

    @Nullable
    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public void setVolumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodStorageConfig podStorageConfig = (PodStorageConfig)o;
        return Objects.equals(this.imageVolumes, podStorageConfig.imageVolumes) && Objects.equals(this.mounts, podStorageConfig.mounts) && Objects.equals(this.overlayVolumes, podStorageConfig.overlayVolumes) && Objects.equals(this.shmSize, podStorageConfig.shmSize) && Objects.equals(this.shmSizeSystemd, podStorageConfig.shmSizeSystemd) && Objects.equals(this.volumes, podStorageConfig.volumes) && Objects.equals(this.volumesFrom, podStorageConfig.volumesFrom);
    }

    public int hashCode() {
        return Objects.hash(this.imageVolumes, this.mounts, this.overlayVolumes, this.shmSize, this.shmSizeSystemd, this.volumes, this.volumesFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodStorageConfig {\n");
        sb.append("    imageVolumes: ").append(this.toIndentedString(this.imageVolumes)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    overlayVolumes: ").append(this.toIndentedString(this.overlayVolumes)).append("\n");
        sb.append("    shmSize: ").append(this.toIndentedString(this.shmSize)).append("\n");
        sb.append("    shmSizeSystemd: ").append(this.toIndentedString(this.shmSizeSystemd)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    volumesFrom: ").append(this.toIndentedString(this.volumesFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumes;
        JsonArray jsonArrayoverlayVolumes;
        JsonArray jsonArraymounts;
        int i;
        JsonArray jsonArrayimageVolumes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PodStorageConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodStorageConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonNull() && (jsonArrayimageVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGE_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayimageVolumes.size(); ++i) {
                ImageVolume.validateJsonElement(jsonArrayimageVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonNull() && (jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArraymounts.size(); ++i) {
                Mount.validateJsonElement(jsonArraymounts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonNull() && (jsonArrayoverlayVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_OVERLAY_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayoverlayVolumes.size(); ++i) {
                OverlayVolume.validateJsonElement(jsonArrayoverlayVolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayvolumes.size(); ++i) {
                NamedVolume.validateJsonElement(jsonArrayvolumes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).toString()));
        }
    }

    public static PodStorageConfig fromJson(String jsonString) throws IOException {
        return (PodStorageConfig)JSON.getGson().fromJson(jsonString, PodStorageConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IMAGE_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_OVERLAY_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE_SYSTEMD);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_FROM);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PodStorageConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PodStorageConfig.class));
            return new TypeAdapter<PodStorageConfig>(){

                public void write(JsonWriter out, PodStorageConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PodStorageConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PodStorageConfig.validateJsonElement(jsonElement);
                    return (PodStorageConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

