/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ComponentVersion;
import io.github.pod4dev.libpodj.model.SystemComponentVersionPlatform;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SystemComponentVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_API_VERSION = "ApiVersion";
    @SerializedName(value="ApiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_ARCH = "Arch";
    @SerializedName(value="Arch")
    private String arch;
    public static final String SERIALIZED_NAME_BUILD_TIME = "BuildTime";
    @SerializedName(value="BuildTime")
    private String buildTime;
    public static final String SERIALIZED_NAME_COMPONENTS = "Components";
    @SerializedName(value="Components")
    private List<@Valid ComponentVersion> components = new ArrayList<ComponentVersion>();
    public static final String SERIALIZED_NAME_EXPERIMENTAL = "Experimental";
    @SerializedName(value="Experimental")
    private Boolean experimental;
    public static final String SERIALIZED_NAME_GIT_COMMIT = "GitCommit";
    @SerializedName(value="GitCommit")
    private String gitCommit;
    public static final String SERIALIZED_NAME_GO_VERSION = "GoVersion";
    @SerializedName(value="GoVersion")
    private String goVersion;
    public static final String SERIALIZED_NAME_KERNEL_VERSION = "KernelVersion";
    @SerializedName(value="KernelVersion")
    private String kernelVersion;
    public static final String SERIALIZED_NAME_MIN_A_P_I_VERSION = "MinAPIVersion";
    @SerializedName(value="MinAPIVersion")
    private String minAPIVersion;
    public static final String SERIALIZED_NAME_OS = "Os";
    @SerializedName(value="Os")
    private String os;
    public static final String SERIALIZED_NAME_PLATFORM = "Platform";
    @SerializedName(value="Platform")
    private SystemComponentVersionPlatform platform;
    public static final String SERIALIZED_NAME_VERSION = "Version";
    @SerializedName(value="Version")
    private String version;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SystemComponentVersion apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public SystemComponentVersion arch(String arch) {
        this.arch = arch;
        return this;
    }

    @Nullable
    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public SystemComponentVersion buildTime(String buildTime) {
        this.buildTime = buildTime;
        return this;
    }

    @Nullable
    public String getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public SystemComponentVersion components(List<@Valid ComponentVersion> components) {
        this.components = components;
        return this;
    }

    public SystemComponentVersion addComponentsItem(ComponentVersion componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<ComponentVersion>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ComponentVersion> getComponents() {
        return this.components;
    }

    public void setComponents(List<@Valid ComponentVersion> components) {
        this.components = components;
    }

    public SystemComponentVersion experimental(Boolean experimental) {
        this.experimental = experimental;
        return this;
    }

    @Nullable
    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean experimental) {
        this.experimental = experimental;
    }

    public SystemComponentVersion gitCommit(String gitCommit) {
        this.gitCommit = gitCommit;
        return this;
    }

    @Nullable
    public String getGitCommit() {
        return this.gitCommit;
    }

    public void setGitCommit(String gitCommit) {
        this.gitCommit = gitCommit;
    }

    public SystemComponentVersion goVersion(String goVersion) {
        this.goVersion = goVersion;
        return this;
    }

    @Nullable
    public String getGoVersion() {
        return this.goVersion;
    }

    public void setGoVersion(String goVersion) {
        this.goVersion = goVersion;
    }

    public SystemComponentVersion kernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
        return this;
    }

    @Nullable
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public SystemComponentVersion minAPIVersion(String minAPIVersion) {
        this.minAPIVersion = minAPIVersion;
        return this;
    }

    @Nullable
    public String getMinAPIVersion() {
        return this.minAPIVersion;
    }

    public void setMinAPIVersion(String minAPIVersion) {
        this.minAPIVersion = minAPIVersion;
    }

    public SystemComponentVersion os(String os) {
        this.os = os;
        return this;
    }

    @Nullable
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public SystemComponentVersion platform(SystemComponentVersionPlatform platform) {
        this.platform = platform;
        return this;
    }

    @Nullable
    @Valid
    public SystemComponentVersionPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(SystemComponentVersionPlatform platform) {
        this.platform = platform;
    }

    public SystemComponentVersion version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemComponentVersion systemComponentVersion = (SystemComponentVersion)o;
        return Objects.equals(this.apiVersion, systemComponentVersion.apiVersion) && Objects.equals(this.arch, systemComponentVersion.arch) && Objects.equals(this.buildTime, systemComponentVersion.buildTime) && Objects.equals(this.components, systemComponentVersion.components) && Objects.equals(this.experimental, systemComponentVersion.experimental) && Objects.equals(this.gitCommit, systemComponentVersion.gitCommit) && Objects.equals(this.goVersion, systemComponentVersion.goVersion) && Objects.equals(this.kernelVersion, systemComponentVersion.kernelVersion) && Objects.equals(this.minAPIVersion, systemComponentVersion.minAPIVersion) && Objects.equals(this.os, systemComponentVersion.os) && Objects.equals(this.platform, systemComponentVersion.platform) && Objects.equals(this.version, systemComponentVersion.version);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.arch, this.buildTime, this.components, this.experimental, this.gitCommit, this.goVersion, this.kernelVersion, this.minAPIVersion, this.os, this.platform, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemComponentVersion {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    arch: ").append(this.toIndentedString(this.arch)).append("\n");
        sb.append("    buildTime: ").append(this.toIndentedString(this.buildTime)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    experimental: ").append(this.toIndentedString(this.experimental)).append("\n");
        sb.append("    gitCommit: ").append(this.toIndentedString(this.gitCommit)).append("\n");
        sb.append("    goVersion: ").append(this.toIndentedString(this.goVersion)).append("\n");
        sb.append("    kernelVersion: ").append(this.toIndentedString(this.kernelVersion)).append("\n");
        sb.append("    minAPIVersion: ").append(this.toIndentedString(this.minAPIVersion)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycomponents;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SystemComponentVersion is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SystemComponentVersion` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ApiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARCH) != null && !jsonObj.get(SERIALIZED_NAME_ARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARCH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Arch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUILD_TIME) != null && !jsonObj.get(SERIALIZED_NAME_BUILD_TIME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BUILD_TIME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `BuildTime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUILD_TIME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPONENTS) != null && !jsonObj.get(SERIALIZED_NAME_COMPONENTS).isJsonNull() && (jsonArraycomponents = jsonObj.getAsJsonArray(SERIALIZED_NAME_COMPONENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMPONENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Components` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPONENTS).toString()));
            }
            for (int i = 0; i < jsonArraycomponents.size(); ++i) {
                ComponentVersion.validateJsonElement(jsonArraycomponents.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_GIT_COMMIT) != null && !jsonObj.get(SERIALIZED_NAME_GIT_COMMIT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GIT_COMMIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `GitCommit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GIT_COMMIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GO_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_GO_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GO_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `GoVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GO_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KERNEL_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_KERNEL_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KERNEL_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `KernelVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KERNEL_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIN_A_P_I_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_MIN_A_P_I_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MIN_A_P_I_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `MinAPIVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIN_A_P_I_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS) != null && !jsonObj.get(SERIALIZED_NAME_OS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_PLATFORM).isJsonNull()) {
            SystemComponentVersionPlatform.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PLATFORM));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
    }

    public static SystemComponentVersion fromJson(String jsonString) throws IOException {
        return (SystemComponentVersion)JSON.getGson().fromJson(jsonString, SystemComponentVersion.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_ARCH);
        openapiFields.add(SERIALIZED_NAME_BUILD_TIME);
        openapiFields.add(SERIALIZED_NAME_COMPONENTS);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENTAL);
        openapiFields.add(SERIALIZED_NAME_GIT_COMMIT);
        openapiFields.add(SERIALIZED_NAME_GO_VERSION);
        openapiFields.add(SERIALIZED_NAME_KERNEL_VERSION);
        openapiFields.add(SERIALIZED_NAME_MIN_A_P_I_VERSION);
        openapiFields.add(SERIALIZED_NAME_OS);
        openapiFields.add(SERIALIZED_NAME_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SystemComponentVersion.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SystemComponentVersion.class));
            return new TypeAdapter<SystemComponentVersion>(){

                public void write(JsonWriter out, SystemComponentVersion value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SystemComponentVersion read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SystemComponentVersion.validateJsonElement(jsonElement);
                    return (SystemComponentVersion)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

