/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Driver;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VolumeOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DRIVER_CONFIG = "DriverConfig";
    @SerializedName(value="DriverConfig")
    private Driver driverConfig;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_NO_COPY = "NoCopy";
    @SerializedName(value="NoCopy")
    private Boolean noCopy;
    public static final String SERIALIZED_NAME_SUBPATH = "Subpath";
    @SerializedName(value="Subpath")
    private String subpath;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VolumeOptions driverConfig(Driver driverConfig) {
        this.driverConfig = driverConfig;
        return this;
    }

    @Nullable
    @Valid
    public Driver getDriverConfig() {
        return this.driverConfig;
    }

    public void setDriverConfig(Driver driverConfig) {
        this.driverConfig = driverConfig;
    }

    public VolumeOptions labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public VolumeOptions putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public VolumeOptions noCopy(Boolean noCopy) {
        this.noCopy = noCopy;
        return this;
    }

    @Nullable
    public Boolean getNoCopy() {
        return this.noCopy;
    }

    public void setNoCopy(Boolean noCopy) {
        this.noCopy = noCopy;
    }

    public VolumeOptions subpath(String subpath) {
        this.subpath = subpath;
        return this;
    }

    @Nullable
    public String getSubpath() {
        return this.subpath;
    }

    public void setSubpath(String subpath) {
        this.subpath = subpath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeOptions volumeOptions = (VolumeOptions)o;
        return Objects.equals(this.driverConfig, volumeOptions.driverConfig) && Objects.equals(this.labels, volumeOptions.labels) && Objects.equals(this.noCopy, volumeOptions.noCopy) && Objects.equals(this.subpath, volumeOptions.subpath);
    }

    public int hashCode() {
        return Objects.hash(this.driverConfig, this.labels, this.noCopy, this.subpath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VolumeOptions {\n");
        sb.append("    driverConfig: ").append(this.toIndentedString(this.driverConfig)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    noCopy: ").append(this.toIndentedString(this.noCopy)).append("\n");
        sb.append("    subpath: ").append(this.toIndentedString(this.subpath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in VolumeOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `VolumeOptions` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DRIVER_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER_CONFIG).isJsonNull()) {
            Driver.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DRIVER_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBPATH) != null && !jsonObj.get(SERIALIZED_NAME_SUBPATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBPATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Subpath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBPATH).toString()));
        }
    }

    public static VolumeOptions fromJson(String jsonString) throws IOException {
        return (VolumeOptions)JSON.getGson().fromJson(jsonString, VolumeOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DRIVER_CONFIG);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_NO_COPY);
        openapiFields.add(SERIALIZED_NAME_SUBPATH);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!VolumeOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VolumeOptions.class));
            return new TypeAdapter<VolumeOptions>(){

                public void write(JsonWriter out, VolumeOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public VolumeOptions read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    VolumeOptions.validateJsonElement(jsonElement);
                    return (VolumeOptions)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

