/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.IDMappingOptions;
import io.github.pod4dev.libpodj.model.Namespace;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContainerSecurityConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_APPARMOR_PROFILE = "apparmor_profile";
    @SerializedName(value="apparmor_profile")
    private String apparmorProfile;
    public static final String SERIALIZED_NAME_CAP_ADD = "cap_add";
    @SerializedName(value="cap_add")
    private List<String> capAdd = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CAP_DROP = "cap_drop";
    @SerializedName(value="cap_drop")
    private List<String> capDrop = new ArrayList<String>();
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private List<String> groups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_IDMAPPINGS = "idmappings";
    @SerializedName(value="idmappings")
    private IDMappingOptions idmappings;
    public static final String SERIALIZED_NAME_LABEL_NESTED = "label_nested";
    @SerializedName(value="label_nested")
    private Boolean labelNested;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private List<String> mask = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NO_NEW_PRIVILEGES = "no_new_privileges";
    @SerializedName(value="no_new_privileges")
    private Boolean noNewPrivileges;
    public static final String SERIALIZED_NAME_PRIVILEGED = "privileged";
    @SerializedName(value="privileged")
    private Boolean privileged;
    public static final String SERIALIZED_NAME_PROCFS_OPTS = "procfs_opts";
    @SerializedName(value="procfs_opts")
    private List<String> procfsOpts = new ArrayList<String>();
    public static final String SERIALIZED_NAME_READ_ONLY_FILESYSTEM = "read_only_filesystem";
    @SerializedName(value="read_only_filesystem")
    private Boolean readOnlyFilesystem;
    public static final String SERIALIZED_NAME_READ_WRITE_TMPFS = "read_write_tmpfs";
    @SerializedName(value="read_write_tmpfs")
    private Boolean readWriteTmpfs;
    public static final String SERIALIZED_NAME_SECCOMP_POLICY = "seccomp_policy";
    @SerializedName(value="seccomp_policy")
    private String seccompPolicy;
    public static final String SERIALIZED_NAME_SECCOMP_PROFILE_PATH = "seccomp_profile_path";
    @SerializedName(value="seccomp_profile_path")
    private String seccompProfilePath;
    public static final String SERIALIZED_NAME_SELINUX_OPTS = "selinux_opts";
    @SerializedName(value="selinux_opts")
    private List<String> selinuxOpts = new ArrayList<String>();
    public static final String SERIALIZED_NAME_UMASK = "umask";
    @SerializedName(value="umask")
    private String umask;
    public static final String SERIALIZED_NAME_UNMASK = "unmask";
    @SerializedName(value="unmask")
    private List<String> unmask = new ArrayList<String>();
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;
    public static final String SERIALIZED_NAME_USERNS = "userns";
    @SerializedName(value="userns")
    private Namespace userns;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContainerSecurityConfig apparmorProfile(String apparmorProfile) {
        this.apparmorProfile = apparmorProfile;
        return this;
    }

    @Nullable
    public String getApparmorProfile() {
        return this.apparmorProfile;
    }

    public void setApparmorProfile(String apparmorProfile) {
        this.apparmorProfile = apparmorProfile;
    }

    public ContainerSecurityConfig capAdd(List<String> capAdd) {
        this.capAdd = capAdd;
        return this;
    }

    public ContainerSecurityConfig addCapAddItem(String capAddItem) {
        if (this.capAdd == null) {
            this.capAdd = new ArrayList<String>();
        }
        this.capAdd.add(capAddItem);
        return this;
    }

    @Nullable
    public List<String> getCapAdd() {
        return this.capAdd;
    }

    public void setCapAdd(List<String> capAdd) {
        this.capAdd = capAdd;
    }

    public ContainerSecurityConfig capDrop(List<String> capDrop) {
        this.capDrop = capDrop;
        return this;
    }

    public ContainerSecurityConfig addCapDropItem(String capDropItem) {
        if (this.capDrop == null) {
            this.capDrop = new ArrayList<String>();
        }
        this.capDrop.add(capDropItem);
        return this;
    }

    @Nullable
    public List<String> getCapDrop() {
        return this.capDrop;
    }

    public void setCapDrop(List<String> capDrop) {
        this.capDrop = capDrop;
    }

    public ContainerSecurityConfig groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public ContainerSecurityConfig addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public ContainerSecurityConfig idmappings(IDMappingOptions idmappings) {
        this.idmappings = idmappings;
        return this;
    }

    @Nullable
    @Valid
    public IDMappingOptions getIdmappings() {
        return this.idmappings;
    }

    public void setIdmappings(IDMappingOptions idmappings) {
        this.idmappings = idmappings;
    }

    public ContainerSecurityConfig labelNested(Boolean labelNested) {
        this.labelNested = labelNested;
        return this;
    }

    @Nullable
    public Boolean getLabelNested() {
        return this.labelNested;
    }

    public void setLabelNested(Boolean labelNested) {
        this.labelNested = labelNested;
    }

    public ContainerSecurityConfig mask(List<String> mask) {
        this.mask = mask;
        return this;
    }

    public ContainerSecurityConfig addMaskItem(String maskItem) {
        if (this.mask == null) {
            this.mask = new ArrayList<String>();
        }
        this.mask.add(maskItem);
        return this;
    }

    @Nullable
    public List<String> getMask() {
        return this.mask;
    }

    public void setMask(List<String> mask) {
        this.mask = mask;
    }

    public ContainerSecurityConfig noNewPrivileges(Boolean noNewPrivileges) {
        this.noNewPrivileges = noNewPrivileges;
        return this;
    }

    @Nullable
    public Boolean getNoNewPrivileges() {
        return this.noNewPrivileges;
    }

    public void setNoNewPrivileges(Boolean noNewPrivileges) {
        this.noNewPrivileges = noNewPrivileges;
    }

    public ContainerSecurityConfig privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public ContainerSecurityConfig procfsOpts(List<String> procfsOpts) {
        this.procfsOpts = procfsOpts;
        return this;
    }

    public ContainerSecurityConfig addProcfsOptsItem(String procfsOptsItem) {
        if (this.procfsOpts == null) {
            this.procfsOpts = new ArrayList<String>();
        }
        this.procfsOpts.add(procfsOptsItem);
        return this;
    }

    @Nullable
    public List<String> getProcfsOpts() {
        return this.procfsOpts;
    }

    public void setProcfsOpts(List<String> procfsOpts) {
        this.procfsOpts = procfsOpts;
    }

    public ContainerSecurityConfig readOnlyFilesystem(Boolean readOnlyFilesystem) {
        this.readOnlyFilesystem = readOnlyFilesystem;
        return this;
    }

    @Nullable
    public Boolean getReadOnlyFilesystem() {
        return this.readOnlyFilesystem;
    }

    public void setReadOnlyFilesystem(Boolean readOnlyFilesystem) {
        this.readOnlyFilesystem = readOnlyFilesystem;
    }

    public ContainerSecurityConfig readWriteTmpfs(Boolean readWriteTmpfs) {
        this.readWriteTmpfs = readWriteTmpfs;
        return this;
    }

    @Nullable
    public Boolean getReadWriteTmpfs() {
        return this.readWriteTmpfs;
    }

    public void setReadWriteTmpfs(Boolean readWriteTmpfs) {
        this.readWriteTmpfs = readWriteTmpfs;
    }

    public ContainerSecurityConfig seccompPolicy(String seccompPolicy) {
        this.seccompPolicy = seccompPolicy;
        return this;
    }

    @Nullable
    public String getSeccompPolicy() {
        return this.seccompPolicy;
    }

    public void setSeccompPolicy(String seccompPolicy) {
        this.seccompPolicy = seccompPolicy;
    }

    public ContainerSecurityConfig seccompProfilePath(String seccompProfilePath) {
        this.seccompProfilePath = seccompProfilePath;
        return this;
    }

    @Nullable
    public String getSeccompProfilePath() {
        return this.seccompProfilePath;
    }

    public void setSeccompProfilePath(String seccompProfilePath) {
        this.seccompProfilePath = seccompProfilePath;
    }

    public ContainerSecurityConfig selinuxOpts(List<String> selinuxOpts) {
        this.selinuxOpts = selinuxOpts;
        return this;
    }

    public ContainerSecurityConfig addSelinuxOptsItem(String selinuxOptsItem) {
        if (this.selinuxOpts == null) {
            this.selinuxOpts = new ArrayList<String>();
        }
        this.selinuxOpts.add(selinuxOptsItem);
        return this;
    }

    @Nullable
    public List<String> getSelinuxOpts() {
        return this.selinuxOpts;
    }

    public void setSelinuxOpts(List<String> selinuxOpts) {
        this.selinuxOpts = selinuxOpts;
    }

    public ContainerSecurityConfig umask(String umask) {
        this.umask = umask;
        return this;
    }

    @Nullable
    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public ContainerSecurityConfig unmask(List<String> unmask) {
        this.unmask = unmask;
        return this;
    }

    public ContainerSecurityConfig addUnmaskItem(String unmaskItem) {
        if (this.unmask == null) {
            this.unmask = new ArrayList<String>();
        }
        this.unmask.add(unmaskItem);
        return this;
    }

    @Nullable
    public List<String> getUnmask() {
        return this.unmask;
    }

    public void setUnmask(List<String> unmask) {
        this.unmask = unmask;
    }

    public ContainerSecurityConfig user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ContainerSecurityConfig userns(Namespace userns) {
        this.userns = userns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getUserns() {
        return this.userns;
    }

    public void setUserns(Namespace userns) {
        this.userns = userns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerSecurityConfig containerSecurityConfig = (ContainerSecurityConfig)o;
        return Objects.equals(this.apparmorProfile, containerSecurityConfig.apparmorProfile) && Objects.equals(this.capAdd, containerSecurityConfig.capAdd) && Objects.equals(this.capDrop, containerSecurityConfig.capDrop) && Objects.equals(this.groups, containerSecurityConfig.groups) && Objects.equals(this.idmappings, containerSecurityConfig.idmappings) && Objects.equals(this.labelNested, containerSecurityConfig.labelNested) && Objects.equals(this.mask, containerSecurityConfig.mask) && Objects.equals(this.noNewPrivileges, containerSecurityConfig.noNewPrivileges) && Objects.equals(this.privileged, containerSecurityConfig.privileged) && Objects.equals(this.procfsOpts, containerSecurityConfig.procfsOpts) && Objects.equals(this.readOnlyFilesystem, containerSecurityConfig.readOnlyFilesystem) && Objects.equals(this.readWriteTmpfs, containerSecurityConfig.readWriteTmpfs) && Objects.equals(this.seccompPolicy, containerSecurityConfig.seccompPolicy) && Objects.equals(this.seccompProfilePath, containerSecurityConfig.seccompProfilePath) && Objects.equals(this.selinuxOpts, containerSecurityConfig.selinuxOpts) && Objects.equals(this.umask, containerSecurityConfig.umask) && Objects.equals(this.unmask, containerSecurityConfig.unmask) && Objects.equals(this.user, containerSecurityConfig.user) && Objects.equals(this.userns, containerSecurityConfig.userns);
    }

    public int hashCode() {
        return Objects.hash(this.apparmorProfile, this.capAdd, this.capDrop, this.groups, this.idmappings, this.labelNested, this.mask, this.noNewPrivileges, this.privileged, this.procfsOpts, this.readOnlyFilesystem, this.readWriteTmpfs, this.seccompPolicy, this.seccompProfilePath, this.selinuxOpts, this.umask, this.unmask, this.user, this.userns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerSecurityConfig {\n");
        sb.append("    apparmorProfile: ").append(this.toIndentedString(this.apparmorProfile)).append("\n");
        sb.append("    capAdd: ").append(this.toIndentedString(this.capAdd)).append("\n");
        sb.append("    capDrop: ").append(this.toIndentedString(this.capDrop)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    idmappings: ").append(this.toIndentedString(this.idmappings)).append("\n");
        sb.append("    labelNested: ").append(this.toIndentedString(this.labelNested)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    noNewPrivileges: ").append(this.toIndentedString(this.noNewPrivileges)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    procfsOpts: ").append(this.toIndentedString(this.procfsOpts)).append("\n");
        sb.append("    readOnlyFilesystem: ").append(this.toIndentedString(this.readOnlyFilesystem)).append("\n");
        sb.append("    readWriteTmpfs: ").append(this.toIndentedString(this.readWriteTmpfs)).append("\n");
        sb.append("    seccompPolicy: ").append(this.toIndentedString(this.seccompPolicy)).append("\n");
        sb.append("    seccompProfilePath: ").append(this.toIndentedString(this.seccompProfilePath)).append("\n");
        sb.append("    selinuxOpts: ").append(this.toIndentedString(this.selinuxOpts)).append("\n");
        sb.append("    umask: ").append(this.toIndentedString(this.umask)).append("\n");
        sb.append("    unmask: ").append(this.toIndentedString(this.unmask)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    userns: ").append(this.toIndentedString(this.userns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerSecurityConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerSecurityConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apparmor_profile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAP_ADD) != null && !jsonObj.get(SERIALIZED_NAME_CAP_ADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAP_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cap_add` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAP_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAP_DROP) != null && !jsonObj.get(SERIALIZED_NAME_CAP_DROP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAP_DROP).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cap_drop` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAP_DROP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_IDMAPPINGS).isJsonNull()) {
            IDMappingOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IDMAPPINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MASK) != null && !jsonObj.get(SERIALIZED_NAME_MASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MASK).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mask` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS) != null && !jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `procfs_opts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `seccomp_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `seccomp_profile_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS) != null && !jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `selinux_opts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UMASK) != null && !jsonObj.get(SERIALIZED_NAME_UMASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UMASK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `umask` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UMASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNMASK) != null && !jsonObj.get(SERIALIZED_NAME_UNMASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNMASK).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unmask` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNMASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNS) != null && !jsonObj.get(SERIALIZED_NAME_USERNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USERNS));
        }
    }

    public static ContainerSecurityConfig fromJson(String jsonString) throws IOException {
        return (ContainerSecurityConfig)JSON.getGson().fromJson(jsonString, ContainerSecurityConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APPARMOR_PROFILE);
        openapiFields.add(SERIALIZED_NAME_CAP_ADD);
        openapiFields.add(SERIALIZED_NAME_CAP_DROP);
        openapiFields.add(SERIALIZED_NAME_GROUPS);
        openapiFields.add(SERIALIZED_NAME_IDMAPPINGS);
        openapiFields.add(SERIALIZED_NAME_LABEL_NESTED);
        openapiFields.add(SERIALIZED_NAME_MASK);
        openapiFields.add(SERIALIZED_NAME_NO_NEW_PRIVILEGES);
        openapiFields.add(SERIALIZED_NAME_PRIVILEGED);
        openapiFields.add(SERIALIZED_NAME_PROCFS_OPTS);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY_FILESYSTEM);
        openapiFields.add(SERIALIZED_NAME_READ_WRITE_TMPFS);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_POLICY);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_PROFILE_PATH);
        openapiFields.add(SERIALIZED_NAME_SELINUX_OPTS);
        openapiFields.add(SERIALIZED_NAME_UMASK);
        openapiFields.add(SERIALIZED_NAME_UNMASK);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_USERNS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContainerSecurityConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContainerSecurityConfig.class));
            return new TypeAdapter<ContainerSecurityConfig>(this){

                public void write(JsonWriter out, ContainerSecurityConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContainerSecurityConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ContainerSecurityConfig.validateJsonElement(jsonElement);
                    return (ContainerSecurityConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

